<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class VpnGateway extends \Google\Collection
{
  /**
   * Every HA-VPN gateway interface is configured with an IPv4 address.
   */
  public const GATEWAY_IP_VERSION_IPV4 = 'IPV4';
  /**
   * Every HA-VPN gateway interface is configured with an IPv6 address.
   */
  public const GATEWAY_IP_VERSION_IPV6 = 'IPV6';
  /**
   * Enable VPN gateway with both IPv4 and IPv6 protocols.
   */
  public const STACK_TYPE_IPV4_IPV6 = 'IPV4_IPV6';
  /**
   * Enable VPN gateway with only IPv4 protocol.
   */
  public const STACK_TYPE_IPV4_ONLY = 'IPV4_ONLY';
  /**
   * Enable VPN gateway with only IPv6 protocol.
   */
  public const STACK_TYPE_IPV6_ONLY = 'IPV6_ONLY';
  protected $collection_key = 'vpnInterfaces';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not
   * specified, IPV4 will be used.
   *
   * @var string
   */
  public $gatewayIpVersion;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this VpnGateway, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * VpnGateway.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * URL of the network to which this VPN gateway is attached. Provided by the
   * client when the VPN gateway is created.
   *
   * @var string
   */
  public $network;
  /**
   * [Output Only] URL of the region where the VPN gateway resides.
   *
   * @var string
   */
  public $region;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * The stack type for this VPN gateway to identify the IP protocols that are
   * enabled. Possible values are: IPV4_ONLY,IPV4_IPV6, IPV6_ONLY. If not
   * specified,IPV4_ONLY is used if the gateway IP version isIPV4, or IPV4_IPV6
   * if the gateway IP version isIPV6.
   *
   * @var string
   */
  public $stackType;
  protected $vpnInterfacesType = VpnGatewayVpnGatewayInterface::class;
  protected $vpnInterfacesDataType = 'array';

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * The IP family of the gateway IPs for the HA-VPN gateway interfaces. If not
   * specified, IPV4 will be used.
   *
   * Accepted values: IPV4, IPV6
   *
   * @param self::GATEWAY_IP_VERSION_* $gatewayIpVersion
   */
  public function setGatewayIpVersion($gatewayIpVersion)
  {
    $this->gatewayIpVersion = $gatewayIpVersion;
  }
  /**
   * @return self::GATEWAY_IP_VERSION_*
   */
  public function getGatewayIpVersion()
  {
    return $this->gatewayIpVersion;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this VpnGateway, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * VpnGateway.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * URL of the network to which this VPN gateway is attached. Provided by the
   * client when the VPN gateway is created.
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * [Output Only] URL of the region where the VPN gateway resides.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * The stack type for this VPN gateway to identify the IP protocols that are
   * enabled. Possible values are: IPV4_ONLY,IPV4_IPV6, IPV6_ONLY. If not
   * specified,IPV4_ONLY is used if the gateway IP version isIPV4, or IPV4_IPV6
   * if the gateway IP version isIPV6.
   *
   * Accepted values: IPV4_IPV6, IPV4_ONLY, IPV6_ONLY
   *
   * @param self::STACK_TYPE_* $stackType
   */
  public function setStackType($stackType)
  {
    $this->stackType = $stackType;
  }
  /**
   * @return self::STACK_TYPE_*
   */
  public function getStackType()
  {
    return $this->stackType;
  }
  /**
   * The list of VPN interfaces associated with this VPN gateway.
   *
   * @param VpnGatewayVpnGatewayInterface[] $vpnInterfaces
   */
  public function setVpnInterfaces($vpnInterfaces)
  {
    $this->vpnInterfaces = $vpnInterfaces;
  }
  /**
   * @return VpnGatewayVpnGatewayInterface[]
   */
  public function getVpnInterfaces()
  {
    return $this->vpnInterfaces;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VpnGateway::class, 'Google_Service_Compute_VpnGateway');
