/*!
 Stencil Testing v4.13.0 | MIT Licensed | https://stenciljs.com
 */
function _lazyRequire(e) {
 return new Proxy({}, {
  get(t, s) {
   const r = require(e);
   return Reflect.get(r, s);
  },
  set(t, s, r) {
   const i = require(e);
   return Reflect.set(i, s, r);
  }
 });
}

function _interopDefaultLegacy(e) {
 return e && "object" == typeof e && "default" in e ? e : {
  default: e
 };
}

function _interopNamespace(e) {
 if (e && e.__esModule) return e;
 var t = Object.create(null);
 return e && Object.keys(e).forEach((function(s) {
  if ("default" !== s) {
   var r = Object.getOwnPropertyDescriptor(e, s);
   Object.defineProperty(t, s, r.get ? r : {
    enumerable: !0,
    get: function() {
     return e[s];
    }
   });
  }
 })), t.default = e, Object.freeze(t);
}

function getAugmentedNamespace(e) {
 if (e.__esModule) return e;
 var t = Object.defineProperty({}, "__esModule", {
  value: !0
 });
 return Object.keys(e).forEach((function(s) {
  var r = Object.getOwnPropertyDescriptor(e, s);
  Object.defineProperty(t, s, r.get ? r : {
   enumerable: !0,
   get: function() {
    return e[s];
   }
  });
 })), t;
}

async function startPuppeteerBrowser(e) {
 if (!e.flags.e2e) return null;
 const t = process.env, s = e.testing.browserExecutablePath ? "puppeteer-core" : "puppeteer", r = e.sys.lazyRequire.getModulePath(e.rootDir, s), i = e.sys.platformPath.join(r, "package.json"), n = e.sys.lazyRequire.require(e.rootDir, r);
 t.__STENCIL_PUPPETEER_MODULE__ = r;
 try {
  const s = e.sys.readFileSync(i, "utf8"), r = JSON.parse(s);
  t.__STENCIL_PUPPETEER_VERSION__ = major$1(r.version);
 } catch (e) {
  console.error(`An error occurred determining the version of Puppeteer installed:\n${e}`), 
  t.__STENCIL_PUPPETEER_VERSION__ = void 0;
 }
 t.__STENCIL_BROWSER_WAIT_UNTIL = e.testing.browserWaitUntil, e.flags.devtools && (t.__STENCIL_E2E_DEVTOOLS__ = "true"), 
 e.logger.debug(`puppeteer: ${r}`), e.logger.debug(`puppeteer headless: ${e.testing.browserHeadless}`), 
 Array.isArray(e.testing.browserArgs) && e.logger.debug(`puppeteer args: ${e.testing.browserArgs.join(" ")}`), 
 "boolean" == typeof e.testing.browserDevtools && e.logger.debug(`puppeteer devtools: ${e.testing.browserDevtools}`), 
 "number" == typeof e.testing.browserSlowMo && e.logger.debug(`puppeteer slowMo: ${e.testing.browserSlowMo}`);
 const o = {
  ignoreHTTPSErrors: !0,
  slowMo: e.testing.browserSlowMo
 };
 let a;
 if (e.testing.browserWSEndpoint) a = await n.connect({
  browserWSEndpoint: e.testing.browserWSEndpoint,
  ...o
 }); else {
  const t = {
   args: e.testing.browserArgs,
   headless: e.testing.browserHeadless,
   devtools: e.testing.browserDevtools,
   ...o
  };
  e.testing.browserExecutablePath && (t.executablePath = e.testing.browserExecutablePath), 
  a = await n.launch({
   ...t
  });
 }
 return t.__STENCIL_BROWSER_WS_ENDPOINT__ = a.wsEndpoint(), e.logger.debug(`puppeteer browser wsEndpoint: ${t.__STENCIL_BROWSER_WS_ENDPOINT__}`), 
 a;
}

async function connectBrowser() {
 const e = process.env, t = e.__STENCIL_BROWSER_WS_ENDPOINT__;
 if (!t) return null;
 const s = {
  browserWSEndpoint: t,
  ignoreHTTPSErrors: !0
 }, r = require(e.__STENCIL_PUPPETEER_MODULE__);
 return await r.connect(s);
}

async function disconnectBrowser(e) {
 if (e) try {
  e.disconnect();
 } catch (e) {}
}

function newBrowserPage(e) {
 return e.newPage();
}

function createJestPuppeteerEnvironment$2() {
 const e = class extends NodeEnvironment__default.default {
  constructor(e) {
   super(e), this.browser = null, this.pages = [];
  }
  async setup() {
   "true" === process.env.__STENCIL_E2E_TESTS__ && (this.global.__NEW_TEST_PAGE__ = this.newPuppeteerPage.bind(this), 
   this.global.__CLOSE_OPEN_PAGES__ = this.closeOpenPages.bind(this));
  }
  async newPuppeteerPage() {
   this.browser || (this.browser = await connectBrowser());
   const e = await newBrowserPage(this.browser);
   this.pages.push(e);
   const t = process.env;
   return "string" == typeof t.__STENCIL_DEFAULT_TIMEOUT__ && e.setDefaultTimeout(parseInt(t.__STENCIL_DEFAULT_TIMEOUT__, 10)), 
   e;
  }
  async closeOpenPages() {
   await Promise.all(this.pages.map((e => e.close()))), this.pages.length = 0;
  }
  async teardown() {
   await super.teardown(), await this.closeOpenPages(), await disconnectBrowser(this.browser), 
   this.browser = null;
  }
  getVmContext() {
   return super.getVmContext();
  }
 };
 return e;
}

function relative(e, t) {
 return normalizePath(path__default.default.relative(e, t), !1);
}

function join(...e) {
 return normalizePath(path__default.default.join(...e), !1);
}

function transpile(e, t = {}) {
 var s;
 t = {
  ...t,
  componentExport: null,
  componentMetadata: "compilerstatic",
  coreImportPath: isString(t.coreImportPath) ? t.coreImportPath : "@stencil/core/internal/testing",
  currentDirectory: t.currentDirectory || process.cwd(),
  module: "cjs",
  proxy: null,
  sourceMap: "inline",
  style: null,
  styleImportData: "queryparams",
  target: "es2015",
  transformAliasedImportPaths: (s = process.env.__STENCIL_TRANSPILE_PATHS__, "true" === s)
 };
 try {
  const e = process.versions.node.split(".");
  parseInt(e[0], 10) >= 10 && (t.target = "es2017");
 } catch (e) {}
 return stencil_js.transpileSync(e, t);
}

function formatDiagnostic$2(e) {
 let t = "";
 return e.relFilePath && (t += e.relFilePath, "number" == typeof e.lineNumber && (t += ":" + e.lineNumber + 1, 
 "number" == typeof e.columnNumber && (t += ":" + e.columnNumber)), t += "\n"), t += e.messageText, 
 t;
}

function getCompilerOptions$2(e) {
 if (_tsCompilerOptions$2) return _tsCompilerOptions$2;
 if ("string" != typeof e) return null;
 e = normalizePath(e);
 const t = stencil_js.ts.findConfigFile(e, stencil_js.ts.sys.fileExists);
 if (!t) return null;
 const s = stencil_js.ts.readConfigFile(t, stencil_js.ts.sys.readFile);
 if (s.error) throw new Error(formatDiagnostic$2(loadTypeScriptDiagnostic(s.error)));
 const r = stencil_js.ts.parseJsonConfigFileContent(s.config, stencil_js.ts.sys, e, void 0, t);
 return _tsCompilerOptions$2 = r.options, _tsCompilerOptions$2;
}

function setScreenshotEmulateData(e, t) {
 const s = {
  userAgent: "default",
  viewport: {
   width: 800,
   height: 600,
   deviceScaleFactor: 1,
   isMobile: !1,
   hasTouch: !1,
   isLandscape: !1
  },
  device: void 0
 };
 if ("string" == typeof e.device) try {
  const r = require(t.__STENCIL_PUPPETEER_MODULE__ + "/DeviceDescriptors")[e.device];
  if (!r) return void console.error(`invalid emulate device: ${e.device}`);
  s.device = e.device, s.userAgent = r.userAgent, s.viewport = r.viewport;
 } catch (e) {
  return void console.error("error loading puppeteer DeviceDescriptors", e);
 }
 e.viewport && ("number" == typeof e.viewport.width && (s.viewport.width = e.viewport.width), 
 "number" == typeof e.viewport.height && (s.viewport.height = e.viewport.height), 
 "number" == typeof e.viewport.deviceScaleFactor && (s.viewport.deviceScaleFactor = e.viewport.deviceScaleFactor), 
 "boolean" == typeof e.viewport.hasTouch && (s.viewport.hasTouch = e.viewport.hasTouch), 
 "boolean" == typeof e.viewport.isLandscape && (s.viewport.isLandscape = e.viewport.isLandscape), 
 "boolean" == typeof e.viewport.isMobile && (s.viewport.isMobile = e.viewport.isMobile), 
 "string" == typeof e.userAgent && (s.userAgent = e.userAgent)), t.__STENCIL_EMULATE__ = JSON.stringify(s);
}

async function runJest$2(e, t) {
 let s = !1;
 try {
  const r = function r(e, t) {
   var s, r;
   let i = null !== (r = null === (s = e.emulate) || void 0 === s ? void 0 : s.slice()) && void 0 !== r ? r : [];
   if ("string" == typeof t.emulate) {
    const e = t.emulate.toLowerCase();
    i = i.filter((t => "string" == typeof t.device && t.device.toLowerCase() === e || !("string" != typeof t.userAgent || !t.userAgent.toLowerCase().includes(e))));
   }
   return i;
  }(e.testing, e.flags);
  t.__STENCIL_EMULATE_CONFIGS__ = JSON.stringify(r), t.__STENCIL_ENV__ = JSON.stringify(e.env), 
  t.__STENCIL_TRANSPILE_PATHS__ = e.transformAliasedImportPaths ? "true" : "false", 
  e.flags.ci || e.flags.e2e ? t.__STENCIL_DEFAULT_TIMEOUT__ = "30000" : t.__STENCIL_DEFAULT_TIMEOUT__ = "15000", 
  e.flags.devtools && (t.__STENCIL_DEFAULT_TIMEOUT__ = "300000000"), e.logger.debug(`default timeout: ${t.__STENCIL_DEFAULT_TIMEOUT__}`);
  const i = function i(e) {
   const t = require("yargs"), s = e.flags.knownArgs.slice();
   s.some((e => e.startsWith("--max-workers") || e.startsWith("--maxWorkers"))) || s.push(`--max-workers=${e.maxConcurrentWorkers}`), 
   e.flags.devtools && s.push("--runInBand");
   const r = [ ...s, ...e.flags.unknownArgs ];
   e.logger.info(e.logger.magenta(`jest args: ${r.join(" ")}`));
   let i = t(r).argv;
   if (i = {
    detectLeaks: !1,
    "detect-leaks": !1,
    detectOpenHandles: !1,
    "detect-open-handles": !1,
    errorOnDeprecated: !1,
    "error-on-deprecated": !1,
    listTests: !1,
    "list-tests": !1,
    maxConcurrency: 5,
    "max-concurrency": 5,
    notifyMode: "failure-change",
    "notify-mode": "failure-change",
    passWithNoTests: !1,
    "pass-with-no-tests": !1,
    runTestsByPath: !1,
    "run-tests-by-path": !1,
    testLocationInResults: !1,
    "test-location-in-results": !1,
    ...i
   }, i.config = function n(e) {
    const t = e.testing, s = require("jest-config").defaults, r = Object.keys(s), i = {};
    return Object.keys(t).forEach((e => {
     r.includes(e) && (i[e] = t[e]);
    })), i.rootDir = e.rootDir, isString(t.collectCoverage) && (i.collectCoverage = t.collectCoverage), 
    Array.isArray(t.collectCoverageFrom) && (i.collectCoverageFrom = t.collectCoverageFrom), 
    isString(t.coverageDirectory) && (i.coverageDirectory = t.coverageDirectory), t.coverageThreshold && (i.coverageThreshold = t.coverageThreshold), 
    isString(t.globalSetup) && (i.globalSetup = t.globalSetup), isString(t.globalTeardown) && (i.globalTeardown = t.globalTeardown), 
    isString(t.preset) && (i.preset = t.preset), t.projects && (i.projects = t.projects), 
    Array.isArray(t.reporters) && (i.reporters = t.reporters), isString(t.testResultsProcessor) && (i.testResultsProcessor = t.testResultsProcessor), 
    t.transform && (i.transform = t.transform), t.verbose && (i.verbose = t.verbose), 
    i.testRunner = (new Jest27Stencil).getDefaultJestRunner(), JSON.stringify(i);
   }(e), "string" == typeof i.maxWorkers) try {
    i.maxWorkers = parseInt(i.maxWorkers, 10);
   } catch (e) {}
   return "string" == typeof i.ci && (i.ci = "true" === i.ci || "" === i.ci), i;
  }(e), n = function n(e, t) {
   const s = t.projects ? t.projects : [];
   return s.push(e.rootDir), s;
  }(e, i), {runCLI: o} = require("@jest/core");
  s = !!(await o(i, n)).results.success;
 } catch (t) {
  e.logger.error(`runJest: ${t}`);
 }
 return s;
}

function createTestRunner$2() {
 class e extends TestRunner__default.default {
  async runTests(e, t, s, r, i, n) {
   const o = process.env;
   if (e = e.filter((e => function t(e, s) {
    const r = (e = e.toLowerCase().replace(/\\/g, "/")).includes(".e2e.") || e.includes("/e2e.");
    return !("true" !== s.__STENCIL_E2E_TESTS__ || !r) || "true" === s.__STENCIL_SPEC_TESTS__ && !r;
   }(e.path, o))), "true" === o.__STENCIL_SCREENSHOT__ && o.__STENCIL_EMULATE_CONFIGS__) {
    const a = JSON.parse(o.__STENCIL_EMULATE_CONFIGS__);
    for (let l = 0; l < a.length; l++) setScreenshotEmulateData(a[l], o), await super.runTests(e, t, s, r, i, n);
   } else await super.runTests(e, t, s, r, i, n);
  }
 }
 return e;
}

async function runJestScreenshot$2(e, t) {
 e.logger.debug(`screenshot connector: ${e.testing.screenshotConnector}`);
 const s = new (require(e.testing.screenshotConnector)), r = path$6.join(e.sys.getCompilerExecutingPath(), "..", "..", "screenshot", "pixel-match.js");
 e.logger.debug(`pixelmatch module: ${r}`);
 const i = e.logger.createTimeSpan("screenshot, initBuild started", !0);
 await s.initBuild({
  buildId: createBuildId$2(),
  buildMessage: createBuildMessage$2(),
  buildTimestamp: Date.now(),
  appNamespace: e.namespace,
  rootDir: e.rootDir,
  cacheDir: e.cacheDir,
  packageDir: path$6.join(e.sys.getCompilerExecutingPath(), "..", ".."),
  updateMaster: !!e.flags.updateScreenshot,
  logger: e.logger,
  allowableMismatchedPixels: e.testing.allowableMismatchedPixels,
  allowableMismatchedRatio: e.testing.allowableMismatchedRatio,
  pixelmatchThreshold: e.testing.pixelmatchThreshold,
  waitBeforeScreenshot: e.testing.waitBeforeScreenshot,
  pixelmatchModulePath: r
 }), e.flags.updateScreenshot || await s.pullMasterBuild(), i.finish("screenshot, initBuild finished");
 const n = await Promise.all([ await s.getMasterBuild(), await s.getScreenshotCache() ]), o = n[0], a = n[1];
 t.__STENCIL_SCREENSHOT_BUILD__ = s.toJson(o, a);
 const l = e.logger.createTimeSpan("screenshot, tests started", !0), c = await runJest$2(e, t);
 l.finish(`screenshot, tests finished, passed: ${c}`);
 try {
  const t = e.logger.createTimeSpan("screenshot, completeTimespan started", !0);
  let r = await s.completeBuild(o);
  if (t.finish("screenshot, completeTimespan finished"), r) {
   const t = e.logger.createTimeSpan("screenshot, publishBuild started", !0);
   if (r = await s.publishBuild(r), t.finish("screenshot, publishBuild finished"), 
   e.flags.updateScreenshot) r.currentBuild && "string" == typeof r.currentBuild.previewUrl && e.logger.info(e.logger.magenta(r.currentBuild.previewUrl)); else if (r.compare) {
    try {
     await s.updateScreenshotCache(a, r);
    } catch (t) {
     e.logger.error(t);
    }
    e.logger.info(`screenshots compared: ${r.compare.diffs.length}`), "string" == typeof r.compare.url && e.logger.info(e.logger.magenta(r.compare.url));
   }
  }
 } catch (t) {
  t instanceof Error ? e.logger.error(t, t.stack) : e.logger.error(t);
 }
 return c;
}

function createBuildId$2() {
 const e = new Date;
 let t = e.getFullYear() + "";
 return t += ("0" + (e.getMonth() + 1)).slice(-2), t += ("0" + e.getDate()).slice(-2), 
 t += ("0" + e.getHours()).slice(-2), t += ("0" + e.getMinutes()).slice(-2), t += ("0" + e.getSeconds()).slice(-2), 
 t;
}

function createBuildMessage$2() {
 const e = new Date;
 let t = e.getFullYear() + "-";
 return t += ("0" + (e.getMonth() + 1)).slice(-2) + "-", t += ("0" + e.getDate()).slice(-2) + " ", 
 t += ("0" + e.getHours()).slice(-2) + ":", t += ("0" + e.getMinutes()).slice(-2) + ":", 
 t += ("0" + e.getSeconds()).slice(-2), `Build: ${t}`;
}

function setupMockFetch(e) {
 const t = e.window;
 "fetch" in t || (t.fetch = function(e) {
  return globalMockFetch(e);
 }), "fetch" in e || (e.fetch = function(e) {
  return globalMockFetch(e);
 });
}

async function globalMockFetch(e) {
 let t;
 if (null == e) throw new Error("missing url input for mock fetch()");
 if ("string" == typeof e) t = e; else {
  if ("string" != typeof e.url) throw new Error("invalid url for mock fetch()");
  t = e.url;
 }
 t = new URL(t, location.href).href;
 let s = mockedResponses.get(t);
 if (null == s) {
  const e = new URL(FETCH_DEFAULT_PATH, location.href);
  s = mockedResponses.get(e.href);
 }
 if (null == s) return new MockResponse404;
 const r = s.response.clone();
 return "number" != typeof r.status && (r.status = 200), "string" != typeof r.statusText && (r.status >= 500 ? r.statusText = "Internal Server Error" : 404 === r.status ? r.statusText = "Not Found" : r.status >= 400 ? r.statusText = "Bad Request" : 302 === r.status ? r.statusText = "Found" : 301 === r.status ? r.statusText = "Moved Permanently" : r.status >= 300 ? r.statusText = "Redirection" : r.statusText = "OK"), 
 r.ok = r.status >= 200 && r.status <= 299, "string" != typeof r.type && (r.type = "basic"), 
 r;
}

function setMockedResponse(e, t, s) {
 if (!e) throw new Error("MockResponse required");
 "string" == typeof e.url && "" !== e.url || ("string" == typeof t ? e.url = t : t && "string" == typeof t.url ? e.url = t.url : e.url = FETCH_DEFAULT_PATH);
 const r = new URL(e.url, location.href);
 e.url = r.href;
 const i = {
  response: e,
  reject: s
 };
 mockedResponses.set(e.url, i);
}

function resetBuildConditionals(e) {
 Object.keys(e).forEach((t => {
  e[t] = !0;
 })), e.isDev = !0, e.isTesting = !0, e.isDebug = !1, e.lazyLoad = !0, e.member = !0, 
 e.reflect = !0, e.scoped = !0, e.shadowDom = !0, e.slotRelocation = !0, e.asyncLoading = !0, 
 e.svg = !0, e.updatable = !0, e.vdomAttribute = !0, e.vdomClass = !0, e.vdomFunctional = !0, 
 e.vdomKey = !0, e.vdomPropOrAttr = !0, e.vdomRef = !0, e.vdomListener = !0, e.vdomStyle = !0, 
 e.vdomText = !0, e.vdomXlink = !0, e.allRenderFn = !1, e.devTools = !1, e.hydrateClientSide = !1, 
 e.hydrateServerSide = !1, e.cssAnnotations = !1, e.style = !1, e.hydratedAttribute = !1, 
 e.hydratedClass = !0, e.invisiblePrehydration = !0, e.appendChildSlotFix = !1, e.cloneNodeFix = !1, 
 e.hotModuleReplacement = !1, e.scriptDataOpts = !1, e.scopedSlotTextContentFix = !1, 
 e.slotChildNodesFix = !1, e.experimentalSlotFixes = !1, e.experimentalScopedSlotChanges = !1;
}

function toHaveClasses$2(e, t) {
 if (!e) throw new Error("expect toHaveClasses value is null");
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 if (1 !== e.nodeType) throw new Error("expect toHaveClasses value is not an element");
 const s = t.every((t => e.classList.contains(t)));
 return {
  message: () => `expected to ${s ? "not " : ""}have css classes "${t.join(" ")}", but className is "${e.className}"`,
  pass: s
 };
}

function compareHtml$2(e, t, s) {
 if (null == e) throw new Error(`expect toEqualHtml() value is "${e}"`);
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 let r;
 if (1 === e.nodeType) {
  const t = function i(e) {
   return e && e.ownerDocument && e.ownerDocument.defaultView && e.ownerDocument.defaultView.__stencil_spec_options || {};
  }(e);
  r = index_cjs.serializeNodeToHtml(e, {
   prettyHtml: !0,
   outerHtml: !0,
   removeHtmlComments: !1 === t.includeAnnotations,
   excludeTags: [ "body" ],
   serializeShadowRoot: s
  });
 } else if (11 === e.nodeType) r = index_cjs.serializeNodeToHtml(e, {
  prettyHtml: !0,
  excludeTags: [ "style" ],
  excludeTagContent: [ "style" ],
  serializeShadowRoot: s
 }); else {
  if ("string" != typeof e) throw new Error("expect toEqualHtml() value should be an element, shadow root or string.");
  {
   const t = index_cjs.parseHtmlToFragment(e);
   r = index_cjs.serializeNodeToHtml(t, {
    prettyHtml: !0,
    serializeShadowRoot: s
   });
  }
 }
 const n = index_cjs.parseHtmlToFragment(t), o = index_cjs.serializeNodeToHtml(n, {
  prettyHtml: !0,
  excludeTags: [ "body" ]
 });
 return r !== o ? (expect(r).toBe(o), {
  message: () => "HTML does not match",
  pass: !1
 }) : {
  message: () => "expect HTML to match",
  pass: !0
 };
}

function jestSetupTestFramework$2() {
 global.resourcesUrl = "/build", expect.extend(expectExtend$2), expect.addSnapshotSerializer(HtmlSerializer$2), 
 index_cjs.setupGlobal(global), setupMockFetch(global), beforeEach((() => {
  testing.resetPlatform(), testing.setErrorHandler(void 0), resetBuildConditionals(appData.BUILD), 
  testing.modeResolutionChain.length = 0;
 })), afterEach((async () => {
  var e, t, s, r, i, n;
  global.__CLOSE_OPEN_PAGES__ && await global.__CLOSE_OPEN_PAGES__(), testing.stopAutoApplyChanges();
  const o = null === (i = null === (r = null === (s = null === (t = null === (e = global.window) || void 0 === e ? void 0 : e.document) || void 0 === t ? void 0 : t.childNodes) || void 0 === s ? void 0 : s[1]) || void 0 === r ? void 0 : r.childNodes) || void 0 === i ? void 0 : i.find((e => "BODY" === e.nodeName));
  null === (n = null == o ? void 0 : o.childNodes) || void 0 === n || n.forEach(removeDomNodes$2), 
  index_cjs.teardownGlobal(global), global.resourcesUrl = "/build";
 }));
 const e = jasmine.getEnv();
 null != e && e.addReporter({
  specStarted: e => {
   global.currentSpec = e;
  }
 }), global.screenshotDescriptions = new Set;
 const t = process.env;
 if ("string" == typeof t.__STENCIL_DEFAULT_TIMEOUT__) {
  const e = parseInt(t.__STENCIL_DEFAULT_TIMEOUT__, 10);
  jest.setTimeout(1.5 * e), jasmine.DEFAULT_TIMEOUT_INTERVAL = e;
 }
 if ("string" == typeof t.__STENCIL_ENV__) {
  const e = JSON.parse(t.__STENCIL_ENV__);
  Object.assign(appData.Env, e);
 }
}

function removeDomNodes$2(e) {
 var t, s;
 null != e && ((null === (t = e.childNodes) || void 0 === t ? void 0 : t.length) || e.remove(), 
 null === (s = e.childNodes) || void 0 === s || s.forEach(removeDomNodes$2));
}

function createJestPuppeteerEnvironment$1() {
 const e = class extends NodeEnvironment.TestEnvironment {
  constructor(e, t) {
   super(e, t), this.browser = null, this.pages = [], this.testPath = null, this.testPath = t.testPath;
  }
  async setup() {
   "true" === process.env.__STENCIL_E2E_TESTS__ && (this.global.__NEW_TEST_PAGE__ = this.newPuppeteerPage.bind(this), 
   this.global.__CLOSE_OPEN_PAGES__ = this.closeOpenPages.bind(this));
  }
  async handleTestEvent(e) {
   if ("test_start" === e.name) {
    const t = e.test;
    let s = t.name, r = t.parent;
    for (;r && r.name && "ROOT_DESCRIBE_BLOCK" != r.name; ) s = `${r.name} ${s}`, r = r.parent;
    this.global.currentSpec = {
     description: t.name,
     fullName: s,
     testPath: this.testPath
    };
   }
  }
  async newPuppeteerPage() {
   this.browser || (this.browser = await connectBrowser());
   const e = await newBrowserPage(this.browser);
   this.pages.push(e);
   const t = process.env;
   return "string" == typeof t.__STENCIL_DEFAULT_TIMEOUT__ && e.setDefaultTimeout(parseInt(t.__STENCIL_DEFAULT_TIMEOUT__, 10)), 
   e;
  }
  async closeOpenPages() {
   await Promise.all(this.pages.map((e => e.close()))), this.pages.length = 0;
  }
  async teardown() {
   await super.teardown(), await this.closeOpenPages(), await disconnectBrowser(this.browser), 
   this.browser = null;
  }
  getVmContext() {
   return super.getVmContext();
  }
 };
 return e;
}

function formatDiagnostic$1(e) {
 let t = "";
 return e.relFilePath && (t += e.relFilePath, "number" == typeof e.lineNumber && (t += ":" + e.lineNumber + 1, 
 "number" == typeof e.columnNumber && (t += ":" + e.columnNumber)), t += "\n"), t += e.messageText, 
 t;
}

function getCompilerOptions$1(e) {
 if (_tsCompilerOptions$1) return _tsCompilerOptions$1;
 if ("string" != typeof e) return null;
 e = normalizePath(e);
 const t = stencil_js.ts.findConfigFile(e, stencil_js.ts.sys.fileExists);
 if (!t) return null;
 const s = stencil_js.ts.readConfigFile(t, stencil_js.ts.sys.readFile);
 if (s.error) throw new Error(formatDiagnostic$1(loadTypeScriptDiagnostic(s.error)));
 const r = stencil_js.ts.parseJsonConfigFileContent(s.config, stencil_js.ts.sys, e, void 0, t);
 return _tsCompilerOptions$1 = r.options, _tsCompilerOptions$1;
}

async function runJest$1(e, t) {
 let s = !1;
 try {
  const r = function r(e, t) {
   var s, r;
   let i = null !== (r = null === (s = e.emulate) || void 0 === s ? void 0 : s.slice()) && void 0 !== r ? r : [];
   if ("string" == typeof t.emulate) {
    const e = t.emulate.toLowerCase();
    i = i.filter((t => "string" == typeof t.device && t.device.toLowerCase() === e || !("string" != typeof t.userAgent || !t.userAgent.toLowerCase().includes(e))));
   }
   return i;
  }(e.testing, e.flags);
  t.__STENCIL_EMULATE_CONFIGS__ = JSON.stringify(r), t.__STENCIL_ENV__ = JSON.stringify(e.env), 
  t.__STENCIL_TRANSPILE_PATHS__ = e.transformAliasedImportPaths ? "true" : "false", 
  e.flags.ci || e.flags.e2e ? t.__STENCIL_DEFAULT_TIMEOUT__ = "30000" : t.__STENCIL_DEFAULT_TIMEOUT__ = "15000", 
  e.flags.devtools && (t.__STENCIL_DEFAULT_TIMEOUT__ = "300000000"), e.logger.debug(`default timeout: ${t.__STENCIL_DEFAULT_TIMEOUT__}`);
  const i = function i(e) {
   const t = require("yargs"), s = e.flags.knownArgs.slice();
   s.some((e => e.startsWith("--max-workers") || e.startsWith("--maxWorkers"))) || s.push(`--max-workers=${e.maxConcurrentWorkers}`), 
   e.flags.devtools && s.push("--runInBand");
   const r = [ ...s, ...e.flags.unknownArgs ];
   e.logger.info(e.logger.magenta(`jest args: ${r.join(" ")}`));
   const i = t(r).argv;
   if (i.config = function n(e) {
    const t = e.testing, s = require("jest-config").defaults, r = Object.keys(s), i = {};
    return Object.keys(t).forEach((e => {
     r.includes(e) && (i[e] = t[e]);
    })), i.rootDir = e.rootDir, isString(t.collectCoverage) && (i.collectCoverage = t.collectCoverage), 
    Array.isArray(t.collectCoverageFrom) && (i.collectCoverageFrom = t.collectCoverageFrom), 
    isString(t.coverageDirectory) && (i.coverageDirectory = t.coverageDirectory), t.coverageThreshold && (i.coverageThreshold = t.coverageThreshold), 
    isString(t.globalSetup) && (i.globalSetup = t.globalSetup), isString(t.globalTeardown) && (i.globalTeardown = t.globalTeardown), 
    isString(t.preset) && (i.preset = t.preset), t.projects && (i.projects = t.projects), 
    Array.isArray(t.reporters) && (i.reporters = t.reporters), isString(t.testResultsProcessor) && (i.testResultsProcessor = t.testResultsProcessor), 
    t.transform && (i.transform = t.transform), t.verbose && (i.verbose = t.verbose), 
    i.testRunner = (new Jest28Stencil).getDefaultJestRunner(), JSON.stringify(i);
   }(e), "string" == typeof i.maxWorkers) try {
    i.maxWorkers = parseInt(i.maxWorkers, 10);
   } catch (e) {}
   return "string" == typeof i.ci && (i.ci = "true" === i.ci || "" === i.ci), i;
  }(e), n = function n(e, t) {
   const s = t.projects ? t.projects : [];
   return s.push(e.rootDir), s;
  }(e, i), {runCLI: o} = require("@jest/core");
  s = !!(await o(i, n)).results.success;
 } catch (t) {
  e.logger.error(`runJest: ${t}`);
 }
 return s;
}

function createTestRunner$1() {
 class e extends TestRunner__default.default {
  async runTests(e, t, s) {
   const r = process.env;
   if (e = e.filter((e => function t(e, s) {
    const r = (e = e.toLowerCase().replace(/\\/g, "/")).includes(".e2e.") || e.includes("/e2e.");
    return !("true" !== s.__STENCIL_E2E_TESTS__ || !r) || "true" === s.__STENCIL_SPEC_TESTS__ && !r;
   }(e.path, r))), "true" === r.__STENCIL_SCREENSHOT__ && r.__STENCIL_EMULATE_CONFIGS__) {
    const i = JSON.parse(r.__STENCIL_EMULATE_CONFIGS__);
    for (let n = 0; n < i.length; n++) setScreenshotEmulateData(i[n], r), await super.runTests(e, t, s);
   } else await super.runTests(e, t, s);
  }
 }
 return e;
}

async function runJestScreenshot$1(e, t) {
 e.logger.debug(`screenshot connector: ${e.testing.screenshotConnector}`);
 const s = new (require(e.testing.screenshotConnector)), r = path$6.join(e.sys.getCompilerExecutingPath(), "..", "..", "screenshot", "pixel-match.js");
 e.logger.debug(`pixelmatch module: ${r}`);
 const i = e.logger.createTimeSpan("screenshot, initBuild started", !0);
 await s.initBuild({
  buildId: createBuildId$1(),
  buildMessage: createBuildMessage$1(),
  buildTimestamp: Date.now(),
  appNamespace: e.namespace,
  rootDir: e.rootDir,
  cacheDir: e.cacheDir,
  packageDir: path$6.join(e.sys.getCompilerExecutingPath(), "..", ".."),
  updateMaster: !!e.flags.updateScreenshot,
  logger: e.logger,
  allowableMismatchedPixels: e.testing.allowableMismatchedPixels,
  allowableMismatchedRatio: e.testing.allowableMismatchedRatio,
  pixelmatchThreshold: e.testing.pixelmatchThreshold,
  waitBeforeScreenshot: e.testing.waitBeforeScreenshot,
  pixelmatchModulePath: r
 }), e.flags.updateScreenshot || await s.pullMasterBuild(), i.finish("screenshot, initBuild finished");
 const n = await Promise.all([ await s.getMasterBuild(), await s.getScreenshotCache() ]), o = n[0], a = n[1];
 t.__STENCIL_SCREENSHOT_BUILD__ = s.toJson(o, a);
 const l = e.logger.createTimeSpan("screenshot, tests started", !0), c = await runJest$1(e, t);
 l.finish(`screenshot, tests finished, passed: ${c}`);
 try {
  const t = e.logger.createTimeSpan("screenshot, completeTimespan started", !0);
  let r = await s.completeBuild(o);
  if (t.finish("screenshot, completeTimespan finished"), r) {
   const t = e.logger.createTimeSpan("screenshot, publishBuild started", !0);
   if (r = await s.publishBuild(r), t.finish("screenshot, publishBuild finished"), 
   e.flags.updateScreenshot) r.currentBuild && "string" == typeof r.currentBuild.previewUrl && e.logger.info(e.logger.magenta(r.currentBuild.previewUrl)); else if (r.compare) {
    try {
     await s.updateScreenshotCache(a, r);
    } catch (t) {
     e.logger.error(t);
    }
    e.logger.info(`screenshots compared: ${r.compare.diffs.length}`), "string" == typeof r.compare.url && e.logger.info(e.logger.magenta(r.compare.url));
   }
  }
 } catch (t) {
  t instanceof Error ? e.logger.error(t, t.stack) : e.logger.error(t);
 }
 return c;
}

function createBuildId$1() {
 const e = new Date;
 let t = e.getFullYear() + "";
 return t += ("0" + (e.getMonth() + 1)).slice(-2), t += ("0" + e.getDate()).slice(-2), 
 t += ("0" + e.getHours()).slice(-2), t += ("0" + e.getMinutes()).slice(-2), t += ("0" + e.getSeconds()).slice(-2), 
 t;
}

function createBuildMessage$1() {
 const e = new Date;
 let t = e.getFullYear() + "-";
 return t += ("0" + (e.getMonth() + 1)).slice(-2) + "-", t += ("0" + e.getDate()).slice(-2) + " ", 
 t += ("0" + e.getHours()).slice(-2) + ":", t += ("0" + e.getMinutes()).slice(-2) + ":", 
 t += ("0" + e.getSeconds()).slice(-2), `Build: ${t}`;
}

function toHaveClasses$1(e, t) {
 if (!e) throw new Error("expect toHaveClasses value is null");
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 if (1 !== e.nodeType) throw new Error("expect toHaveClasses value is not an element");
 const s = t.every((t => e.classList.contains(t)));
 return {
  message: () => `expected to ${s ? "not " : ""}have css classes "${t.join(" ")}", but className is "${e.className}"`,
  pass: s
 };
}

function compareHtml$1(e, t, s) {
 if (null == e) throw new Error(`expect toEqualHtml() value is "${e}"`);
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 let r;
 if (1 === e.nodeType) {
  const t = function i(e) {
   return e && e.ownerDocument && e.ownerDocument.defaultView && e.ownerDocument.defaultView.__stencil_spec_options || {};
  }(e);
  r = index_cjs.serializeNodeToHtml(e, {
   prettyHtml: !0,
   outerHtml: !0,
   removeHtmlComments: !1 === t.includeAnnotations,
   excludeTags: [ "body" ],
   serializeShadowRoot: s
  });
 } else if (11 === e.nodeType) r = index_cjs.serializeNodeToHtml(e, {
  prettyHtml: !0,
  excludeTags: [ "style" ],
  excludeTagContent: [ "style" ],
  serializeShadowRoot: s
 }); else {
  if ("string" != typeof e) throw new Error("expect toEqualHtml() value should be an element, shadow root or string.");
  {
   const t = index_cjs.parseHtmlToFragment(e);
   r = index_cjs.serializeNodeToHtml(t, {
    prettyHtml: !0,
    serializeShadowRoot: s
   });
  }
 }
 const n = index_cjs.parseHtmlToFragment(t), o = index_cjs.serializeNodeToHtml(n, {
  prettyHtml: !0,
  excludeTags: [ "body" ]
 });
 return r !== o ? (expect(r).toBe(o), {
  message: () => "HTML does not match",
  pass: !1
 }) : {
  message: () => "expect HTML to match",
  pass: !0
 };
}

function jestSetupTestFramework$1() {
 global.resourcesUrl = "/build", expect.extend(expectExtend$1), expect.addSnapshotSerializer(HtmlSerializer$1), 
 index_cjs.setupGlobal(global), setupMockFetch(global), beforeEach((() => {
  testing.resetPlatform(), testing.setErrorHandler(void 0), resetBuildConditionals(appData.BUILD), 
  testing.modeResolutionChain.length = 0;
 })), afterEach((async () => {
  var e, t, s, r, i, n;
  global.__CLOSE_OPEN_PAGES__ && await global.__CLOSE_OPEN_PAGES__(), testing.stopAutoApplyChanges();
  const o = null === (i = null === (r = null === (s = null === (t = null === (e = global.window) || void 0 === e ? void 0 : e.document) || void 0 === t ? void 0 : t.childNodes) || void 0 === s ? void 0 : s[1]) || void 0 === r ? void 0 : r.childNodes) || void 0 === i ? void 0 : i.find((e => "BODY" === e.nodeName));
  null === (n = null == o ? void 0 : o.childNodes) || void 0 === n || n.forEach(removeDomNodes$1), 
  index_cjs.teardownGlobal(global), global.resourcesUrl = "/build";
 })), global.screenshotDescriptions = new Set;
 const e = process.env;
 if ("string" == typeof e.__STENCIL_DEFAULT_TIMEOUT__) {
  const t = parseInt(e.__STENCIL_DEFAULT_TIMEOUT__, 10);
  jest.setTimeout(1.5 * t);
 }
 if ("string" == typeof e.__STENCIL_ENV__) {
  const t = JSON.parse(e.__STENCIL_ENV__);
  Object.assign(appData.Env, t);
 }
}

function removeDomNodes$1(e) {
 var t, s;
 null != e && ((null === (t = e.childNodes) || void 0 === t ? void 0 : t.length) || e.remove(), 
 null === (s = e.childNodes) || void 0 === s || s.forEach(removeDomNodes$1));
}

function createJestPuppeteerEnvironment() {
 const e = class extends NodeEnvironment.TestEnvironment {
  constructor(e, t) {
   super(e, t), this.browser = null, this.pages = [], this.testPath = null, this.testPath = t.testPath;
  }
  async setup() {
   "true" === process.env.__STENCIL_E2E_TESTS__ && (this.global.__NEW_TEST_PAGE__ = this.newPuppeteerPage.bind(this), 
   this.global.__CLOSE_OPEN_PAGES__ = this.closeOpenPages.bind(this));
  }
  async handleTestEvent(e) {
   if ("test_start" === e.name) {
    const t = e.test;
    let s = t.name, r = t.parent;
    for (;r && r.name && "ROOT_DESCRIBE_BLOCK" != r.name; ) s = `${r.name} ${s}`, r = r.parent;
    this.global.currentSpec = {
     description: t.name,
     fullName: s,
     testPath: this.testPath
    };
   }
  }
  async newPuppeteerPage() {
   this.browser || (this.browser = await connectBrowser());
   const e = await newBrowserPage(this.browser);
   this.pages.push(e);
   const t = process.env;
   return "string" == typeof t.__STENCIL_DEFAULT_TIMEOUT__ && e.setDefaultTimeout(parseInt(t.__STENCIL_DEFAULT_TIMEOUT__, 10)), 
   e;
  }
  async closeOpenPages() {
   await Promise.all(this.pages.map((e => e.close()))), this.pages.length = 0;
  }
  async teardown() {
   await super.teardown(), await this.closeOpenPages(), await disconnectBrowser(this.browser), 
   this.browser = null;
  }
  getVmContext() {
   return super.getVmContext();
  }
 };
 return e;
}

function formatDiagnostic(e) {
 let t = "";
 return e.relFilePath && (t += e.relFilePath, "number" == typeof e.lineNumber && (t += ":" + e.lineNumber + 1, 
 "number" == typeof e.columnNumber && (t += ":" + e.columnNumber)), t += "\n"), t += e.messageText, 
 t;
}

function getCompilerOptions(e) {
 if (_tsCompilerOptions) return _tsCompilerOptions;
 if ("string" != typeof e) return null;
 e = normalizePath(e);
 const t = stencil_js.ts.findConfigFile(e, stencil_js.ts.sys.fileExists);
 if (!t) return null;
 const s = stencil_js.ts.readConfigFile(t, stencil_js.ts.sys.readFile);
 if (s.error) throw new Error(formatDiagnostic(loadTypeScriptDiagnostic(s.error)));
 const r = stencil_js.ts.parseJsonConfigFileContent(s.config, stencil_js.ts.sys, e, void 0, t);
 return _tsCompilerOptions = r.options, _tsCompilerOptions;
}

async function runJest(e, t) {
 let s = !1;
 try {
  const r = function r(e, t) {
   var s, r;
   let i = null !== (r = null === (s = e.emulate) || void 0 === s ? void 0 : s.slice()) && void 0 !== r ? r : [];
   if ("string" == typeof t.emulate) {
    const e = t.emulate.toLowerCase();
    i = i.filter((t => "string" == typeof t.device && t.device.toLowerCase() === e || !("string" != typeof t.userAgent || !t.userAgent.toLowerCase().includes(e))));
   }
   return i;
  }(e.testing, e.flags);
  t.__STENCIL_EMULATE_CONFIGS__ = JSON.stringify(r), t.__STENCIL_ENV__ = JSON.stringify(e.env), 
  t.__STENCIL_TRANSPILE_PATHS__ = e.transformAliasedImportPaths ? "true" : "false", 
  e.flags.ci || e.flags.e2e ? t.__STENCIL_DEFAULT_TIMEOUT__ = "30000" : t.__STENCIL_DEFAULT_TIMEOUT__ = "15000", 
  e.flags.devtools && (t.__STENCIL_DEFAULT_TIMEOUT__ = "300000000"), e.logger.debug(`default timeout: ${t.__STENCIL_DEFAULT_TIMEOUT__}`);
  const i = function i(e) {
   const t = require("yargs"), s = e.flags.knownArgs.slice();
   s.some((e => e.startsWith("--max-workers") || e.startsWith("--maxWorkers"))) || s.push(`--max-workers=${e.maxConcurrentWorkers}`), 
   e.flags.devtools && s.push("--runInBand");
   const r = [ ...s, ...e.flags.unknownArgs ];
   e.logger.info(e.logger.magenta(`jest args: ${r.join(" ")}`));
   const i = t(r).argv;
   if (i.config = function n(e) {
    const t = e.testing, s = require("jest-config").defaults, r = Object.keys(s), i = {};
    return Object.keys(t).forEach((e => {
     r.includes(e) && (i[e] = t[e]);
    })), i.rootDir = e.rootDir, isString(t.collectCoverage) && (i.collectCoverage = t.collectCoverage), 
    Array.isArray(t.collectCoverageFrom) && (i.collectCoverageFrom = t.collectCoverageFrom), 
    isString(t.coverageDirectory) && (i.coverageDirectory = t.coverageDirectory), t.coverageThreshold && (i.coverageThreshold = t.coverageThreshold), 
    isString(t.globalSetup) && (i.globalSetup = t.globalSetup), isString(t.globalTeardown) && (i.globalTeardown = t.globalTeardown), 
    isString(t.preset) && (i.preset = t.preset), t.projects && (i.projects = t.projects), 
    Array.isArray(t.reporters) && (i.reporters = t.reporters), isString(t.testResultsProcessor) && (i.testResultsProcessor = t.testResultsProcessor), 
    t.transform && (i.transform = t.transform), t.verbose && (i.verbose = t.verbose), 
    i.testRunner = (new Jest29Stencil).getDefaultJestRunner(), JSON.stringify(i);
   }(e), "string" == typeof i.maxWorkers) try {
    i.maxWorkers = parseInt(i.maxWorkers, 10);
   } catch (e) {}
   return "string" == typeof i.ci && (i.ci = "true" === i.ci || "" === i.ci), i;
  }(e), n = function n(e, t) {
   const s = t.projects ? t.projects : [];
   return s.push(e.rootDir), s;
  }(e, i), {runCLI: o} = require("@jest/core");
  s = !!(await o(i, n)).results.success;
 } catch (t) {
  e.logger.error(`runJest: ${t}`);
 }
 return s;
}

function createTestRunner() {
 class e extends TestRunner__default.default {
  async runTests(e, t, s) {
   const r = process.env;
   if (e = e.filter((e => function t(e, s) {
    const r = (e = e.toLowerCase().replace(/\\/g, "/")).includes(".e2e.") || e.includes("/e2e.");
    return !("true" !== s.__STENCIL_E2E_TESTS__ || !r) || "true" === s.__STENCIL_SPEC_TESTS__ && !r;
   }(e.path, r))), "true" === r.__STENCIL_SCREENSHOT__ && r.__STENCIL_EMULATE_CONFIGS__) {
    const i = JSON.parse(r.__STENCIL_EMULATE_CONFIGS__);
    for (let n = 0; n < i.length; n++) setScreenshotEmulateData(i[n], r), await super.runTests(e, t, s);
   } else await super.runTests(e, t, s);
  }
 }
 return e;
}

async function runJestScreenshot(e, t) {
 e.logger.debug(`screenshot connector: ${e.testing.screenshotConnector}`);
 const s = new (require(e.testing.screenshotConnector)), r = path$6.join(e.sys.getCompilerExecutingPath(), "..", "..", "screenshot", "pixel-match.js");
 e.logger.debug(`pixelmatch module: ${r}`);
 const i = e.logger.createTimeSpan("screenshot, initBuild started", !0);
 await s.initBuild({
  buildId: createBuildId(),
  buildMessage: createBuildMessage(),
  buildTimestamp: Date.now(),
  appNamespace: e.namespace,
  rootDir: e.rootDir,
  cacheDir: e.cacheDir,
  packageDir: path$6.join(e.sys.getCompilerExecutingPath(), "..", ".."),
  updateMaster: !!e.flags.updateScreenshot,
  logger: e.logger,
  allowableMismatchedPixels: e.testing.allowableMismatchedPixels,
  allowableMismatchedRatio: e.testing.allowableMismatchedRatio,
  pixelmatchThreshold: e.testing.pixelmatchThreshold,
  waitBeforeScreenshot: e.testing.waitBeforeScreenshot,
  pixelmatchModulePath: r
 }), e.flags.updateScreenshot || await s.pullMasterBuild(), i.finish("screenshot, initBuild finished");
 const n = await Promise.all([ await s.getMasterBuild(), await s.getScreenshotCache() ]), o = n[0], a = n[1];
 t.__STENCIL_SCREENSHOT_BUILD__ = s.toJson(o, a);
 const l = e.logger.createTimeSpan("screenshot, tests started", !0), c = await runJest(e, t);
 l.finish(`screenshot, tests finished, passed: ${c}`);
 try {
  const t = e.logger.createTimeSpan("screenshot, completeTimespan started", !0);
  let r = await s.completeBuild(o);
  if (t.finish("screenshot, completeTimespan finished"), r) {
   const t = e.logger.createTimeSpan("screenshot, publishBuild started", !0);
   if (r = await s.publishBuild(r), t.finish("screenshot, publishBuild finished"), 
   e.flags.updateScreenshot) r.currentBuild && "string" == typeof r.currentBuild.previewUrl && e.logger.info(e.logger.magenta(r.currentBuild.previewUrl)); else if (r.compare) {
    try {
     await s.updateScreenshotCache(a, r);
    } catch (t) {
     e.logger.error(t);
    }
    e.logger.info(`screenshots compared: ${r.compare.diffs.length}`), "string" == typeof r.compare.url && e.logger.info(e.logger.magenta(r.compare.url));
   }
  }
 } catch (t) {
  t instanceof Error ? e.logger.error(t, t.stack) : e.logger.error(t);
 }
 return c;
}

function createBuildId() {
 const e = new Date;
 let t = e.getFullYear() + "";
 return t += ("0" + (e.getMonth() + 1)).slice(-2), t += ("0" + e.getDate()).slice(-2), 
 t += ("0" + e.getHours()).slice(-2), t += ("0" + e.getMinutes()).slice(-2), t += ("0" + e.getSeconds()).slice(-2), 
 t;
}

function createBuildMessage() {
 const e = new Date;
 let t = e.getFullYear() + "-";
 return t += ("0" + (e.getMonth() + 1)).slice(-2) + "-", t += ("0" + e.getDate()).slice(-2) + " ", 
 t += ("0" + e.getHours()).slice(-2) + ":", t += ("0" + e.getMinutes()).slice(-2) + ":", 
 t += ("0" + e.getSeconds()).slice(-2), `Build: ${t}`;
}

function toHaveClasses(e, t) {
 if (!e) throw new Error("expect toHaveClasses value is null");
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 if (1 !== e.nodeType) throw new Error("expect toHaveClasses value is not an element");
 const s = t.every((t => e.classList.contains(t)));
 return {
  message: () => `expected to ${s ? "not " : ""}have css classes "${t.join(" ")}", but className is "${e.className}"`,
  pass: s
 };
}

function compareHtml(e, t, s) {
 if (null == e) throw new Error(`expect toEqualHtml() value is "${e}"`);
 if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
 let r;
 if (1 === e.nodeType) {
  const t = function i(e) {
   return e && e.ownerDocument && e.ownerDocument.defaultView && e.ownerDocument.defaultView.__stencil_spec_options || {};
  }(e);
  r = index_cjs.serializeNodeToHtml(e, {
   prettyHtml: !0,
   outerHtml: !0,
   removeHtmlComments: !1 === t.includeAnnotations,
   excludeTags: [ "body" ],
   serializeShadowRoot: s
  });
 } else if (11 === e.nodeType) r = index_cjs.serializeNodeToHtml(e, {
  prettyHtml: !0,
  excludeTags: [ "style" ],
  excludeTagContent: [ "style" ],
  serializeShadowRoot: s
 }); else {
  if ("string" != typeof e) throw new Error("expect toEqualHtml() value should be an element, shadow root or string.");
  {
   const t = index_cjs.parseHtmlToFragment(e);
   r = index_cjs.serializeNodeToHtml(t, {
    prettyHtml: !0,
    serializeShadowRoot: s
   });
  }
 }
 const n = index_cjs.parseHtmlToFragment(t), o = index_cjs.serializeNodeToHtml(n, {
  prettyHtml: !0,
  excludeTags: [ "body" ]
 });
 return r !== o ? (expect(r).toBe(o), {
  message: () => "HTML does not match",
  pass: !1
 }) : {
  message: () => "expect HTML to match",
  pass: !0
 };
}

function jestSetupTestFramework() {
 global.resourcesUrl = "/build", expect.extend(expectExtend), expect.addSnapshotSerializer(HtmlSerializer), 
 index_cjs.setupGlobal(global), setupMockFetch(global), beforeEach((() => {
  testing.resetPlatform(), testing.setErrorHandler(void 0), resetBuildConditionals(appData.BUILD), 
  testing.modeResolutionChain.length = 0;
 })), afterEach((async () => {
  var e, t, s, r, i, n;
  global.__CLOSE_OPEN_PAGES__ && await global.__CLOSE_OPEN_PAGES__(), testing.stopAutoApplyChanges();
  const o = null === (i = null === (r = null === (s = null === (t = null === (e = global.window) || void 0 === e ? void 0 : e.document) || void 0 === t ? void 0 : t.childNodes) || void 0 === s ? void 0 : s[1]) || void 0 === r ? void 0 : r.childNodes) || void 0 === i ? void 0 : i.find((e => "BODY" === e.nodeName));
  null === (n = null == o ? void 0 : o.childNodes) || void 0 === n || n.forEach(removeDomNodes), 
  index_cjs.teardownGlobal(global), global.resourcesUrl = "/build";
 })), global.screenshotDescriptions = new Set;
 const e = process.env;
 if ("string" == typeof e.__STENCIL_DEFAULT_TIMEOUT__) {
  const t = parseInt(e.__STENCIL_DEFAULT_TIMEOUT__, 10);
  jest.setTimeout(1.5 * t);
 }
 if ("string" == typeof e.__STENCIL_ENV__) {
  const t = JSON.parse(e.__STENCIL_ENV__);
  Object.assign(appData.Env, t);
 }
}

function removeDomNodes(e) {
 var t, s;
 null != e && ((null === (t = e.childNodes) || void 0 === t ? void 0 : t.length) || e.remove(), 
 null === (s = e.childNodes) || void 0 === s || s.forEach(removeDomNodes));
}

function publishQueue(e, t) {
 Object.defineProperty(e, gracefulQueue, {
  get: function() {
   return t;
  }
 });
}

function patch(e) {
 function t(e, s) {
  return this instanceof t ? (h.apply(this, arguments), this) : t.apply(Object.create(t.prototype), arguments);
 }
 function s(e, t) {
  return this instanceof s ? (p.apply(this, arguments), this) : s.apply(Object.create(s.prototype), arguments);
 }
 function r(e, t, s, r) {
  return "function" == typeof s && (r = s, s = null), function e(t, s, r, i, n) {
   return m(t, s, r, (function(o, a) {
    !o || "EMFILE" !== o.code && "ENFILE" !== o.code ? "function" == typeof i && i.apply(this, arguments) : enqueue([ e, [ t, s, r, i ], o, n || Date.now(), Date.now() ]);
   }));
  }(e, t, s, r);
 }
 var i, n, o, a, l, c, u, h, p, d, f, m;
 return polyfills(e), e.gracefulify = patch, e.createReadStream = function g(t, s) {
  return new e.ReadStream(t, s);
 }, e.createWriteStream = function y(t, s) {
  return new e.WriteStream(t, s);
 }, i = e.readFile, e.readFile = function v(e, t, s) {
  return "function" == typeof t && (s = t, t = null), function e(t, s, r, n) {
   return i(t, s, (function(i) {
    !i || "EMFILE" !== i.code && "ENFILE" !== i.code ? "function" == typeof r && r.apply(this, arguments) : enqueue([ e, [ t, s, r ], i, n || Date.now(), Date.now() ]);
   }));
  }(e, t, s);
 }, n = e.writeFile, e.writeFile = function w(e, t, s, r) {
  return "function" == typeof s && (r = s, s = null), function e(t, s, r, i, o) {
   return n(t, s, r, (function(n) {
    !n || "EMFILE" !== n.code && "ENFILE" !== n.code ? "function" == typeof i && i.apply(this, arguments) : enqueue([ e, [ t, s, r, i ], n, o || Date.now(), Date.now() ]);
   }));
  }(e, t, s, r);
 }, (o = e.appendFile) && (e.appendFile = function b(e, t, s, r) {
  return "function" == typeof s && (r = s, s = null), function e(t, s, r, i, n) {
   return o(t, s, r, (function(o) {
    !o || "EMFILE" !== o.code && "ENFILE" !== o.code ? "function" == typeof i && i.apply(this, arguments) : enqueue([ e, [ t, s, r, i ], o, n || Date.now(), Date.now() ]);
   }));
  }(e, t, s, r);
 }), (a = e.copyFile) && (e.copyFile = function E(e, t, s, r) {
  return "function" == typeof s && (r = s, s = 0), function e(t, s, r, i, n) {
   return a(t, s, r, (function(o) {
    !o || "EMFILE" !== o.code && "ENFILE" !== o.code ? "function" == typeof i && i.apply(this, arguments) : enqueue([ e, [ t, s, r, i ], o, n || Date.now(), Date.now() ]);
   }));
  }(e, t, s, r);
 }), l = e.readdir, e.readdir = function _(e, t, s) {
  function r(e, t, s, r) {
   return function(n, o) {
    !n || "EMFILE" !== n.code && "ENFILE" !== n.code ? (o && o.sort && o.sort(), "function" == typeof s && s.call(this, n, o)) : enqueue([ i, [ e, t, s ], n, r || Date.now(), Date.now() ]);
   };
  }
  "function" == typeof t && (s = t, t = null);
  var i = c.test(process.version) ? function e(t, s, i, n) {
   return l(t, r(t, s, i, n));
  } : function e(t, s, i, n) {
   return l(t, s, r(t, s, i, n));
  };
  return i(e, t, s);
 }, c = /^v[0-5]\./, "v0.8" === process.version.substr(0, 4) && (t = (u = legacy(e)).ReadStream, 
 s = u.WriteStream), (h = e.ReadStream) && (t.prototype = Object.create(h.prototype), 
 t.prototype.open = function S() {
  var e = this;
  r(e.path, e.flags, e.mode, (function(t, s) {
   t ? (e.autoClose && e.destroy(), e.emit("error", t)) : (e.fd = s, e.emit("open", s), 
   e.read());
  }));
 }), (p = e.WriteStream) && (s.prototype = Object.create(p.prototype), s.prototype.open = function T() {
  var e = this;
  r(e.path, e.flags, e.mode, (function(t, s) {
   t ? (e.destroy(), e.emit("error", t)) : (e.fd = s, e.emit("open", s));
  }));
 }), Object.defineProperty(e, "ReadStream", {
  get: function() {
   return t;
  },
  set: function(e) {
   t = e;
  },
  enumerable: !0,
  configurable: !0
 }), Object.defineProperty(e, "WriteStream", {
  get: function() {
   return s;
  },
  set: function(e) {
   s = e;
  },
  enumerable: !0,
  configurable: !0
 }), d = t, Object.defineProperty(e, "FileReadStream", {
  get: function() {
   return d;
  },
  set: function(e) {
   d = e;
  },
  enumerable: !0,
  configurable: !0
 }), f = s, Object.defineProperty(e, "FileWriteStream", {
  get: function() {
   return f;
  },
  set: function(e) {
   f = e;
  },
  enumerable: !0,
  configurable: !0
 }), m = e.open, e.open = r, e;
}

function enqueue(e) {
 debug$2("ENQUEUE", e[0].name, e[1]), fs$4[gracefulQueue].push(e), retry();
}

function resetQueue() {
 var e, t = Date.now();
 for (e = 0; e < fs$4[gracefulQueue].length; ++e) fs$4[gracefulQueue][e].length > 2 && (fs$4[gracefulQueue][e][3] = t, 
 fs$4[gracefulQueue][e][4] = t);
 retry();
}

function retry() {
 var e, t, s, r, i, n, o, a, l;
 clearTimeout(retryTimer), retryTimer = void 0, 0 !== fs$4[gracefulQueue].length && (t = (e = fs$4[gracefulQueue].shift())[0], 
 s = e[1], r = e[2], i = e[3], n = e[4], void 0 === i ? (debug$2("RETRY", t.name, s), 
 t.apply(null, s)) : Date.now() - i >= 6e4 ? (debug$2("TIMEOUT", t.name, s), "function" == typeof (o = s.pop()) && o.call(null, r)) : (a = Date.now() - n, 
 l = Math.max(n - i, 1), a >= Math.min(1.2 * l, 100) ? (debug$2("RETRY", t.name, s), 
 t.apply(null, s.concat([ i ]))) : fs$4[gracefulQueue].push(e)), void 0 === retryTimer && (retryTimer = setTimeout(retry, 0)));
}

function balanced$1(e, t, s) {
 e instanceof RegExp && (e = maybeMatch(e, s)), t instanceof RegExp && (t = maybeMatch(t, s));
 var r = range$1(e, t, s);
 return r && {
  start: r[0],
  end: r[1],
  pre: s.slice(0, r[0]),
  body: s.slice(r[0] + e.length, r[1]),
  post: s.slice(r[1] + t.length)
 };
}

function maybeMatch(e, t) {
 var s = t.match(e);
 return s ? s[0] : null;
}

function range$1(e, t, s) {
 var r, i, n, o, a, l = s.indexOf(e), c = s.indexOf(t, l + 1), u = l;
 if (l >= 0 && c > 0) {
  if (e === t) return [ l, c ];
  for (r = [], n = s.length; u >= 0 && !a; ) u == l ? (r.push(u), l = s.indexOf(e, u + 1)) : 1 == r.length ? a = [ r.pop(), c ] : ((i = r.pop()) < n && (n = i, 
  o = c), c = s.indexOf(t, u + 1)), u = l < c && l >= 0 ? l : c;
  r.length && (a = [ n, o ]);
 }
 return a;
}

function numeric(e) {
 return parseInt(e, 10) == e ? parseInt(e, 10) : e.charCodeAt(0);
}

function unescapeBraces(e) {
 return e.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
}

function parseCommaParts(e) {
 var t, s, r, i, n, o, a;
 return e ? (t = [], (s = balanced("{", "}", e)) ? (r = s.pre, i = s.body, n = s.post, 
 (o = r.split(","))[o.length - 1] += "{" + i + "}", a = parseCommaParts(n), n.length && (o[o.length - 1] += a.shift(), 
 o.push.apply(o, a)), t.push.apply(t, o), t) : e.split(",")) : [ "" ];
}

function embrace(e) {
 return "{" + e + "}";
}

function isPadded(e) {
 return /^-?0\d/.test(e);
}

function lte$2(e, t) {
 return e <= t;
}

function gte$2(e, t) {
 return e >= t;
}

function expand(e, t) {
 var s, r, i, n, o, a, l, c, u, h, p, d, f, m, g, y, v, w, b, E, _, S = [], T = balanced("{", "}", e);
 if (!T) return [ e ];
 if (s = T.pre, r = T.post.length ? expand(T.post, !1) : [ "" ], /\$$/.test(T.pre)) for (i = 0; i < r.length; i++) n = s + "{" + T.body + "}" + r[i], 
 S.push(n); else {
  if (o = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(T.body), a = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(T.body), 
  l = o || a, c = T.body.indexOf(",") >= 0, !l && !c) return T.post.match(/,.*\}/) ? expand(e = T.pre + "{" + T.body + escClose + T.post) : [ e ];
  if (l) u = T.body.split(/\.\./); else if (1 === (u = parseCommaParts(T.body)).length && 1 === (u = expand(u[0], !1).map(embrace)).length) return r.map((function(e) {
   return T.pre + u[0] + e;
  }));
  if (l) for (p = numeric(u[0]), d = numeric(u[1]), f = Math.max(u[0].length, u[1].length), 
  m = 3 == u.length ? Math.abs(numeric(u[2])) : 1, g = lte$2, d < p && (m *= -1, g = gte$2), 
  y = u.some(isPadded), h = [], v = p; g(v, d); v += m) a ? "\\" === (w = String.fromCharCode(v)) && (w = "") : (w = String(v), 
  y && (b = f - w.length) > 0 && (E = new Array(b + 1).join("0"), w = v < 0 ? "-" + E + w.slice(1) : E + w)), 
  h.push(w); else for (h = [], _ = 0; _ < u.length; _++) h.push.apply(h, expand(u[_], !1));
  for (_ = 0; _ < h.length; _++) for (i = 0; i < r.length; i++) n = s + h[_] + r[i], 
  (!t || l || n) && S.push(n);
 }
 return S;
}

async function nodeCopyTasks(e, t) {
 const s = {
  diagnostics: [],
  dirPaths: [],
  filePaths: []
 };
 try {
  e = flatOne(await Promise.all(e.map((e => async function s(e, t) {
   return isGlob(e.src) ? await async function s(e, t) {
    return (await asyncGlob(e.src, {
     cwd: t,
     nodir: !0
    })).map((s => function r(e, t, s) {
     const r = path__default.default.join(e.dest, e.keepDirStructure ? s : path__default.default.basename(s));
     return {
      src: path__default.default.join(t, s),
      dest: r,
      warn: e.warn,
      keepDirStructure: e.keepDirStructure
     };
    }(e, t, s)));
   }(e, t) : [ {
    src: getSrcAbsPath(t, e.src),
    dest: e.keepDirStructure ? path__default.default.join(e.dest, e.src) : e.dest,
    warn: e.warn,
    keepDirStructure: e.keepDirStructure
   } ];
  }(e, t)))));
  const r = [];
  for (;e.length > 0; ) {
   const t = e.splice(0, 100);
   await Promise.all(t.map((e => processCopyTask(s, r, e))));
  }
  const i = function r(e) {
   const t = [];
   return e.forEach((e => {
    !function s(e, t) {
     (t = normalizePath(t)) !== ROOT_DIR && t + "/" !== ROOT_DIR && "" !== t && (e.includes(t) || e.push(t));
    }(t, path__default.default.dirname(e.dest));
   })), t.sort(((e, t) => {
    const s = e.split("/").length, r = t.split("/").length;
    return s < r ? -1 : s > r ? 1 : e < t ? -1 : e > t ? 1 : 0;
   })), t;
  }(r);
  try {
   await Promise.all(i.map((e => mkdir(e, {
    recursive: !0
   }))));
  } catch (e) {}
  for (;r.length > 0; ) {
   const e = r.splice(0, 100);
   await Promise.all(e.map((e => copyFile(e.src, e.dest))));
  }
 } catch (e) {
  catchError(s.diagnostics, e);
 }
 return s;
}

function getSrcAbsPath(e, t) {
 return path__default.default.isAbsolute(t) ? t : path__default.default.join(e, t);
}

async function processCopyTask(e, t, s) {
 try {
  s.src = normalizePath(s.src), s.dest = normalizePath(s.dest), (await stat(s.src)).isDirectory() ? (e.dirPaths.includes(s.dest) || e.dirPaths.push(s.dest), 
  await async function r(e, t, s) {
   try {
    const r = await readdir(s.src);
    await Promise.all(r.map((async r => {
     const i = {
      src: path__default.default.join(s.src, r),
      dest: path__default.default.join(s.dest, r),
      warn: s.warn
     };
     await processCopyTask(e, t, i);
    })));
   } catch (t) {
    catchError(e.diagnostics, t);
   }
  }(e, t, s)) : function i(e) {
   return e = e.trim().toLowerCase(), IGNORE$1.some((t => e.endsWith(t)));
  }(s.src) || (e.filePaths.includes(s.dest) || e.filePaths.push(s.dest), t.push(s));
 } catch (t) {
  if (!1 !== s.warn) {
   const s = buildError(e.diagnostics);
   t instanceof Error && (s.messageText = t.message);
  }
 }
}

function asyncGlob(e, t) {
 return commonjs$2.glob(e, t);
}

function Yallist$1(e) {
 var t, s, r = this;
 if (r instanceof Yallist$1 || (r = new Yallist$1), r.tail = null, r.head = null, 
 r.length = 0, e && "function" == typeof e.forEach) e.forEach((function(e) {
  r.push(e);
 })); else if (arguments.length > 0) for (t = 0, s = arguments.length; t < s; t++) r.push(arguments[t]);
 return r;
}

function insert(e, t, s) {
 var r = t === e.head ? new Node(s, null, t, e) : new Node(s, t, t.next, e);
 return null === r.next && (e.tail = r), null === r.prev && (e.head = r), e.length++, 
 r;
}

function push(e, t) {
 e.tail = new Node(t, e.tail, null, e), e.head || (e.head = e.tail), e.length++;
}

function unshift(e, t) {
 e.head = new Node(t, null, e.head, e), e.tail || (e.tail = e.head), e.length++;
}

function Node(e, t, s, r) {
 if (!(this instanceof Node)) return new Node(e, t, s, r);
 this.list = r, this.value = e, t ? (t.next = this, this.prev = t) : this.prev = null, 
 s ? (s.prev = this, this.next = s) : this.next = null;
}

async function checkVersion(e, t) {
 try {
  const s = await async function s(e) {
   try {
    const e = await function t() {
     return new Promise((e => {
      fs$5.readFile(getLastCheckStoragePath(), "utf8", ((t, s) => {
       if (!t && isString(s)) try {
        e(JSON.parse(s));
       } catch (e) {}
       e(null);
      }));
     }));
    }();
    if (null == e) return setLastCheck(), null;
    if (!function s(e, t, r) {
     return t + r < e;
    }(Date.now(), e, CHECK_INTERVAL)) return null;
    const t = setLastCheck(), s = await async function r(e) {
     const t = await Promise.resolve().then((function() {
      return _interopNamespace(require("https"));
     }));
     return new Promise(((s, r) => {
      const i = t.request(e, (t => {
       if (t.statusCode > 299) return void r(`url: ${e}, staus: ${t.statusCode}`);
       t.once("error", r);
       const i = [];
       t.once("end", (() => {
        s(i.join(""));
       })), t.on("data", (e => {
        i.push(e);
       }));
      }));
      i.once("error", r), i.end();
     }));
    }(REGISTRY_URL), r = JSON.parse(s);
    return await t, r["dist-tags"].latest;
   } catch (t) {
    e.debug(`getLatestCompilerVersion error: ${t}`);
   }
   return null;
  }(e);
  if (null != s) return () => {
   semverLt(t, s) ? function r(e, t, s) {
    const r = "npm install @stencil/core", i = [ `Update available: ${t} ${ARROW} ${s}`, "To get the latest, please run:", r, CHANGELOG ], n = i.reduce(((e, t) => t.length > e ? t.length : e), 0), o = [];
    let a = BOX_TOP_LEFT;
    for (;a.length <= n + 2 * PADDING; ) a += BOX_HORIZONTAL;
    a += BOX_TOP_RIGHT, o.push(a), i.forEach((e => {
     let t = BOX_VERTICAL;
     for (let e = 0; e < PADDING; e++) t += " ";
     for (t += e; t.length <= n + 2 * PADDING; ) t += " ";
     t += BOX_VERTICAL, o.push(t);
    }));
    let l = BOX_BOTTOM_LEFT;
    for (;l.length <= n + 2 * PADDING; ) l += BOX_HORIZONTAL;
    l += BOX_BOTTOM_RIGHT, o.push(l);
    let c = `${INDENT}${o.join(`\n${INDENT}`)}\n`;
    c = c.replace(t, e.red(t)), c = c.replace(s, e.green(s)), c = c.replace(r, e.cyan(r)), 
    c = c.replace(CHANGELOG, e.dim(CHANGELOG)), console.log(c);
   }(e, t, s) : console.debug(`${e.cyan("@stencil/core")} version ${e.green(t)} is the latest version`);
  };
 } catch (t) {
  e.debug(`unable to load latest compiler version: ${t}`);
 }
 return noop$1;
}

function setLastCheck() {
 return new Promise((e => {
  const t = JSON.stringify(Date.now());
  fs$5.writeFile(getLastCheckStoragePath(), t, (() => {
   e();
  }));
 }));
}

function getLastCheckStoragePath() {
 return path__default.default.join(os$3.tmpdir(), "stencil_last_version_node.json");
}

function getNextWorker(e) {
 const t = e.filter((e => !e.stopped));
 return 0 === t.length ? null : t.sort(((e, t) => e.tasks.size < t.tasks.size ? -1 : e.tasks.size > t.tasks.size ? 1 : e.totalTasksAssigned < t.totalTasksAssigned ? -1 : e.totalTasksAssigned > t.totalTasksAssigned ? 1 : 0))[0];
}

function createNodeSys(e = {}) {
 var t;
 const s = null !== (t = null == e ? void 0 : e.process) && void 0 !== t ? t : global.process, r = null == e ? void 0 : e.logger, i = new Set, n = [], o = os$3.cpus(), a = o.length, l = os$3.platform(), c = path__default.default.join(__dirname, "..", "..", "compiler", "stencil.js"), u = path__default.default.join(__dirname, "..", "..", "dev-server", "index.js"), h = () => {
  const e = [];
  let t;
  for (;isFunction(t = n.pop()); ) try {
   const r = t();
   !(s = r) || "object" != typeof s && "function" != typeof s || "function" != typeof s.then || e.push(r);
  } catch (e) {}
  var s;
  return e.length > 0 ? Promise.all(e) : null;
 }, p = {
  name: "node",
  version: s.versions.node,
  access: e => new Promise((t => {
   fs$5.access(e, (e => t(!e)));
  })),
  accessSync(e) {
   let t = !1;
   try {
    fs$5.accessSync(e), t = !0;
   } catch (e) {}
   return t;
  },
  addDestroy(e) {
   i.add(e);
  },
  removeDestroy(e) {
   i.delete(e);
  },
  applyPrerenderGlobalPatch(e) {
   if ("function" != typeof global.fetch) {
    const t = require(path__default.default.join(__dirname, "node-fetch.js"));
    global.fetch = (s, r) => {
     if ("string" == typeof s) {
      const i = new URL(s, e.devServerHostUrl).href;
      return t.fetch(i, r);
     }
     return s.url = new URL(s.url, e.devServerHostUrl).href, t.fetch(s, r);
    }, global.Headers = t.Headers, global.Request = t.Request, global.Response = t.Response, 
    global.FetchError = t.FetchError;
   }
   e.window.fetch = global.fetch, e.window.Headers = global.Headers, e.window.Request = global.Request, 
   e.window.Response = global.Response, e.window.FetchError = global.FetchError;
  },
  fetch: (e, t) => {
   const s = require(path__default.default.join(__dirname, "node-fetch.js"));
   if ("string" == typeof e) {
    const r = new URL(e).href;
    return s.fetch(r, t);
   }
   return e.url = new URL(e.url).href, s.fetch(e, t);
  },
  checkVersion,
  copyFile: (e, t) => new Promise((s => {
   fs$5.copyFile(e, t, (e => {
    s(!e);
   }));
  })),
  createDir: (e, t) => new Promise((s => {
   t ? fs$5.mkdir(e, t, (t => {
    s({
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     newDirs: [],
     error: t
    });
   })) : fs$5.mkdir(e, (t => {
    s({
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     newDirs: [],
     error: t
    });
   }));
  })),
  createDirSync(e, t) {
   const s = {
    basename: path__default.default.basename(e),
    dirname: path__default.default.dirname(e),
    path: e,
    newDirs: [],
    error: null
   };
   try {
    fs$5.mkdirSync(e, t);
   } catch (e) {
    s.error = e;
   }
   return s;
  },
  createWorkerController(e) {
   const t = path__default.default.join(__dirname, "worker.js");
   return new NodeWorkerController(t, e);
  },
  async destroy() {
   const e = [];
   i.forEach((t => {
    try {
     const s = t();
     s && "function" == typeof s.then && e.push(s);
    } catch (e) {
     console.error(`node sys destroy: ${e}`);
    }
   })), e.length > 0 && await Promise.all(e), i.clear();
  },
  dynamicImport: e => Promise.resolve(require(e)),
  encodeToBase64: e => Buffer.from(e).toString("base64"),
  ensureDependencies: async () => (console.warn("ensureDependencies will be removed in a future version of Stencil."), 
  console.warn("To get the stencilPath, please use getCompilerExecutingPath()."), 
  {
   stencilPath: p.getCompilerExecutingPath(),
   diagnostics: []
  }),
  async ensureResources() {
   console.warn("ensureResources is a no-op, and will be removed in a future version of Stencil");
  },
  exit: async e => {
   await h(), exit$1(e);
  },
  getCurrentDirectory: () => normalizePath(s.cwd()),
  getCompilerExecutingPath: () => c,
  getDevServerExecutingPath: () => u,
  getEnvironmentVar: e => process.env[e],
  getLocalModulePath: () => null,
  getRemoteModuleUrl: () => null,
  glob: asyncGlob,
  hardwareConcurrency: a,
  isSymbolicLink: e => new Promise((t => {
   try {
    fs$5.lstat(e, ((e, s) => {
     t(!e && s.isSymbolicLink());
    }));
   } catch (e) {
    t(!1);
   }
  })),
  nextTick: s.nextTick,
  normalizePath,
  onProcessInterrupt: e => {
   n.includes(e) || n.push(e);
  },
  platformPath: path__default.default,
  readDir: e => new Promise((t => {
   fs$5.readdir(e, ((s, r) => {
    t(s ? [] : r.map((t => normalizePath(path__default.default.join(e, t)))));
   }));
  })),
  parseYarnLockFile: e => lockfile.exports.parse(e),
  isTTY() {
   var e;
   return !!(null === (e = null === process || void 0 === process ? void 0 : process.stdout) || void 0 === e ? void 0 : e.isTTY);
  },
  readDirSync(e) {
   try {
    return fs$5.readdirSync(e).map((t => normalizePath(path__default.default.join(e, t))));
   } catch (e) {}
   return [];
  },
  readFile: (e, t) => new Promise("binary" === t ? t => {
   fs$5.readFile(e, ((e, s) => {
    t(s);
   }));
  } : t => {
   fs$5.readFile(e, "utf8", ((e, s) => {
    t(s);
   }));
  }),
  readFileSync(e) {
   try {
    return fs$5.readFileSync(e, "utf8");
   } catch (e) {}
  },
  homeDir() {
   try {
    return os__namespace.homedir();
   } catch (e) {}
  },
  realpath: e => new Promise((t => {
   fs$5.realpath(e, "utf8", ((e, s) => {
    t({
     path: s,
     error: e
    });
   }));
  })),
  realpathSync(e) {
   const t = {
    path: void 0,
    error: null
   };
   try {
    t.path = fs$5.realpathSync(e, "utf8");
   } catch (e) {
    t.error = e;
   }
   return t;
  },
  rename: (e, t) => new Promise((s => {
   fs$5.rename(e, t, (r => {
    s({
     oldPath: e,
     newPath: t,
     error: r,
     oldDirs: [],
     oldFiles: [],
     newDirs: [],
     newFiles: [],
     renamed: [],
     isFile: !1,
     isDirectory: !1
    });
   }));
  })),
  resolvePath: e => normalizePath(e),
  removeDir: (e, t) => new Promise((s => {
   t && t.recursive ? fs$5.rm(e, {
    recursive: !0,
    force: !0
   }, (t => {
    s({
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     removedDirs: [],
     removedFiles: [],
     error: t
    });
   })) : fs$5.rmdir(e, (t => {
    s({
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     removedDirs: [],
     removedFiles: [],
     error: t
    });
   }));
  })),
  removeDirSync(e, t) {
   try {
    return t && t.recursive ? fs$5.rmSync(e, {
     recursive: !0,
     force: !0
    }) : fs$5.rmdirSync(e), {
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     removedDirs: [],
     removedFiles: [],
     error: null
    };
   } catch (t) {
    return {
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     removedDirs: [],
     removedFiles: [],
     error: t
    };
   }
  },
  removeFile: e => new Promise((t => {
   fs$5.unlink(e, (s => {
    t({
     basename: path__default.default.basename(e),
     dirname: path__default.default.dirname(e),
     path: e,
     error: s
    });
   }));
  })),
  removeFileSync(e) {
   const t = {
    basename: path__default.default.basename(e),
    dirname: path__default.default.dirname(e),
    path: e,
    error: null
   };
   try {
    fs$5.unlinkSync(e);
   } catch (e) {
    t.error = e;
   }
   return t;
  },
  setupCompiler(e) {
   const t = e.ts, s = t.sys.watchDirectory, i = t.sys.watchFile;
   p.watchTimeout = 80, p.events = buildEvents(), p.watchDirectory = (e, t, i) => {
    null == r || r.debug(`NODE_SYS_DEBUG::watchDir ${e}`);
    const n = s(e, (s => {
     null == r || r.debug(`NODE_SYS_DEBUG::watchDir:callback dir=${e} changedPath=${s}`), 
     t(normalizePath(s), "fileUpdate");
    }), i), o = () => {
     n.close();
    };
    return p.addDestroy(o), {
     close() {
      p.removeDestroy(o), n.close();
     }
    };
   }, p.watchFile = (e, s) => {
    null == r || r.debug(`NODE_SYS_DEBUG::watchFile ${e}`);
    const n = i(e, ((e, r) => {
     e = normalizePath(e), r === t.FileWatcherEventKind.Created ? (s(e, "fileAdd"), p.events.emit("fileAdd", e)) : r === t.FileWatcherEventKind.Changed ? (s(e, "fileUpdate"), 
     p.events.emit("fileUpdate", e)) : r === t.FileWatcherEventKind.Deleted && (s(e, "fileDelete"), 
     p.events.emit("fileDelete", e));
    }), 250, {
     watchFile: t.WatchFileKind.FixedPollingInterval,
     fallbackPolling: t.PollingWatchKind.FixedInterval
    }), o = () => {
     n.close();
    };
    return p.addDestroy(o), {
     close() {
      p.removeDestroy(o), n.close();
     }
    };
   };
  },
  stat: e => new Promise((t => {
   fs$5.stat(e, ((e, s) => {
    t(e ? {
     isDirectory: !1,
     isFile: !1,
     isSymbolicLink: !1,
     size: 0,
     mtimeMs: 0,
     error: e
    } : {
     isDirectory: s.isDirectory(),
     isFile: s.isFile(),
     isSymbolicLink: s.isSymbolicLink(),
     size: s.size,
     mtimeMs: s.mtimeMs,
     error: null
    });
   }));
  })),
  statSync(e) {
   try {
    const t = fs$5.statSync(e);
    return {
     isDirectory: t.isDirectory(),
     isFile: t.isFile(),
     isSymbolicLink: t.isSymbolicLink(),
     size: t.size,
     mtimeMs: t.mtimeMs,
     error: null
    };
   } catch (e) {
    return {
     isDirectory: !1,
     isFile: !1,
     isSymbolicLink: !1,
     size: 0,
     mtimeMs: 0,
     error: e
    };
   }
  },
  tmpDirSync: () => os$3.tmpdir(),
  writeFile: (e, t) => new Promise((s => {
   fs$5.writeFile(e, t, (t => {
    s({
     path: e,
     error: t
    });
   }));
  })),
  writeFileSync(e, t) {
   const s = {
    path: e,
    error: null
   };
   try {
    fs$5.writeFileSync(e, t);
   } catch (e) {
    s.error = e;
   }
   return s;
  },
  generateContentHash(e, t) {
   let s = require$$3.createHash("sha1").update(e).digest("hex").toLowerCase();
   return "number" == typeof t && (s = s.slice(0, t)), Promise.resolve(s);
  },
  generateFileHash: (e, t) => new Promise(((s, r) => {
   const i = require$$3.createHash("sha1");
   fs$5.createReadStream(e).on("error", (e => r(e))).on("data", (e => i.update(e))).on("end", (() => {
    let e = i.digest("hex").toLowerCase();
    "number" == typeof t && (e = e.slice(0, t)), s(e);
   }));
  })),
  copy: nodeCopyTasks,
  details: {
   cpuModel: (Array.isArray(o) && o.length > 0 ? o[0] && o[0].model : "") || "",
   freemem: () => os$3.freemem(),
   platform: "darwin" === l || "linux" === l ? l : "win32" === l ? "windows" : "",
   release: os$3.release(),
   totalmem: os$3.totalmem()
  }
 }, d = new NodeResolveModule;
 return p.lazyRequire = new NodeLazyRequire(d, {
  "@types/jest": {
   minVersion: "24.9.1",
   recommendedVersion: "29",
   maxVersion: "29.0.0"
  },
  jest: {
   minVersion: "24.9.0",
   recommendedVersion: "29",
   maxVersion: "29.0.0"
  },
  "jest-cli": {
   minVersion: "24.9.0",
   recommendedVersion: "29",
   maxVersion: "29.0.0"
  },
  puppeteer: {
   minVersion: "10.0.0",
   recommendedVersion: "20"
  },
  "puppeteer-core": {
   minVersion: "10.0.0",
   recommendedVersion: "20"
  },
  "workbox-build": {
   minVersion: "4.3.1",
   recommendedVersion: "4.3.1"
  }
 }), s.on("SIGINT", h), s.on("exit", h), p;
}

function specifierIncluded(e, t) {
 var s, r, i, n = e.split("."), o = t.split(" "), a = o.length > 1 ? o[0] : "=", l = (o.length > 1 ? o[1] : o[0]).split(".");
 for (s = 0; s < 3; ++s) if ((r = parseInt(n[s] || 0, 10)) !== (i = parseInt(l[s] || 0, 10))) return "<" === a ? r < i : ">=" === a && r >= i;
 return ">=" === a;
}

function matchesRange(e, t) {
 var s, r = t.split(/ ?&& ?/);
 if (0 === r.length) return !1;
 for (s = 0; s < r.length; ++s) if (!specifierIncluded(e, r[s])) return !1;
 return !0;
}

function mockValidatedConfig(e = {}) {
 var t;
 const s = mockConfig(e), r = path__default.default.resolve("/");
 return {
  ...s,
  buildEs5: !1,
  cacheDir: ".stencil",
  devMode: !0,
  devServer: {},
  extras: {},
  flags: createConfigFlags(),
  fsNamespace: "testing",
  hashFileNames: !1,
  hashedFileNameLength: 8,
  hydratedFlag: null,
  logLevel: "info",
  logger: mockLogger(),
  minifyCss: !1,
  minifyJs: !1,
  namespace: "Testing",
  outputTargets: null !== (t = s.outputTargets) && void 0 !== t ? t : [],
  packageJsonFilePath: path__default.default.join(r, "package.json"),
  rootDir: r,
  srcDir: "/src",
  srcIndexHtml: "src/index.html",
  sys: createTestingSystem(),
  testing: {},
  transformAliasedImportPaths: !0,
  rollupConfig: {
   inputOptions: {},
   outputOptions: {}
  },
  validatePrimaryPackageOutputTarget: !1,
  ...e
 };
}

function mockConfig(e = {}) {
 const t = path__default.default.resolve("/");
 let {sys: s} = e;
 return s || (s = createTestingSystem()), s.getCurrentDirectory = () => t, {
  _isTesting: !0,
  buildAppCore: !1,
  buildDist: !0,
  buildEs5: !1,
  bundles: null,
  devMode: !0,
  enableCache: !1,
  extras: {},
  flags: createConfigFlags(),
  globalScript: null,
  hashFileNames: !1,
  logger: new TestingLogger,
  maxConcurrentWorkers: 0,
  minifyCss: !1,
  minifyJs: !1,
  namespace: "Testing",
  nodeResolve: {
   customResolveOptions: {}
  },
  outputTargets: null,
  rollupPlugins: {
   before: [],
   after: []
  },
  rootDir: t,
  sourceMap: !0,
  sys: s,
  testing: null,
  validateTypes: !1,
  ...e
 };
}

function mockCompilerCtx(e) {
 const t = e || mockValidatedConfig(), s = {
  version: 1,
  activeBuildId: 0,
  activeDirsAdded: [],
  activeDirsDeleted: [],
  activeFilesAdded: [],
  activeFilesDeleted: [],
  activeFilesUpdated: [],
  addWatchDir: noop$1,
  addWatchFile: noop$1,
  cachedGlobalStyle: null,
  changedFiles: new Set,
  changedModules: new Set,
  collections: [],
  compilerOptions: null,
  cache: null,
  cssModuleImports: new Map,
  events: buildEvents(),
  fs: null,
  hasSuccessfulBuild: !1,
  isActivelyBuilding: !1,
  lastBuildResults: null,
  moduleMap: new Map,
  nodeMap: new WeakMap,
  reset: noop$1,
  resolvedCollections: new Set,
  rollupCache: new Map,
  rollupCacheHydrate: null,
  rollupCacheLazy: null,
  rollupCacheNative: null,
  styleModeNames: new Set,
  worker: stencil_js.createWorkerContext(t.sys)
 };
 return Object.defineProperty(s, "fs", {
  get() {
   return null == this._fs && (this._fs = createInMemoryFs(t.sys)), this._fs;
  }
 }), Object.defineProperty(s, "cache", {
  get() {
   return null == this._cache && (this._cache = function e(t, s) {
    t.enableCache = !0;
    const r = new Cache(t, s.fs);
    return r.initCacheDir(), r;
   }(t, s)), this._cache;
  }
 }), s;
}

function mockLogger() {
 return new TestingLogger;
}

async function initPageEvents(e) {
 e._e2eEvents = new Map, e._e2eEventIds = 0, e.spyOnEvent = pageSpyOnEvent.bind(e, e), 
 await e.exposeFunction("stencilOnEvent", ((t, s) => {
  !function r(e, t, s) {
   const r = e.get(t);
   r && r.callback(s);
  }(e._e2eEvents, t, s);
 })), await e.evaluateOnNewDocument(browserContextEvents);
}

async function pageSpyOnEvent(e, t, s) {
 const r = new EventSpy(t), i = "document" !== s ? () => window : () => document, n = await e.evaluateHandle(i);
 return await addE2EListener(e, n, t, (e => {
  r.push(e);
 })), r;
}

async function waitForEvent(e, t, s) {
 const r = "undefined" != typeof jasmine && jasmine.DEFAULT_TIMEOUT_INTERVAL ? .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL : 2500, i = await e.evaluate(((e, t, s) => new Promise(((r, i) => {
  const n = setTimeout((() => {
   i(new Error(`waitForEvent() timeout, eventName: ${t}`));
  }), s);
  e.addEventListener(t, (e => {
   clearTimeout(n), r(window.stencilSerializeEvent(e));
  }), {
   once: !0
  });
 }))), s, t, r);
 return await e.waitForChanges(), i;
}

async function addE2EListener(e, t, s, r) {
 const i = e._e2eEventIds++;
 e._e2eEvents.set(i, {
  eventName: s,
  callback: r
 }), await t.evaluate(((e, t, s) => {
  e.addEventListener(s, (e => {
   window.stencilOnEvent(t, window.stencilSerializeEvent(e));
  }));
 }), i, s);
}

function browserContextEvents() {
 const e = () => {
  const e = [], t = (e, s) => {
   if (null != s && 1 === s.nodeType) for (let r = 0; r < s.children.length; r++) {
    const i = s.children[r];
    i.tagName.includes("-") && "function" == typeof i.componentOnReady && e.push(i.componentOnReady()), 
    t(e, i);
   }
  };
  return t(e, window.document.documentElement), Promise.all(e).catch((e => console.error(e)));
 }, t = () => e().then((() => new Promise((e => {
  requestAnimationFrame(e);
 })))).then((() => e())).then((() => {
  window.stencilAppLoaded = !0;
 }));
 window.stencilSerializeEventTarget = e => e ? e === window ? {
  serializedWindow: !0
 } : e === document ? {
  serializedDocument: !0
 } : null != e.nodeType ? {
  serializedElement: !0,
  nodeName: e.nodeName,
  nodeValue: e.nodeValue,
  nodeType: e.nodeType,
  tagName: e.tagName,
  className: e.className,
  id: e.id
 } : null : null, window.stencilSerializeEvent = e => ({
  bubbles: e.bubbles,
  cancelBubble: e.cancelBubble,
  cancelable: e.cancelable,
  composed: e.composed,
  currentTarget: window.stencilSerializeEventTarget(e.currentTarget),
  defaultPrevented: e.defaultPrevented,
  detail: e.detail,
  eventPhase: e.eventPhase,
  isTrusted: e.isTrusted,
  returnValue: e.returnValue,
  srcElement: window.stencilSerializeEventTarget(e.srcElement),
  target: window.stencilSerializeEventTarget(e.target),
  timeStamp: e.timeStamp,
  type: e.type,
  isSerializedEvent: !0
 }), "complete" === window.document.readyState ? t() : document.addEventListener("readystatechange", (function(e) {
  "complete" == e.target.readyState && t();
 }));
}

async function find(e, t, s) {
 const {lightSelector: r, shadowSelector: i, text: n, contains: o} = getSelector(s);
 let a;
 if (a = "string" == typeof r ? await async function l(e, t, s, r) {
  let i = await t.$(s);
  if (!i) return null;
  if (r) {
   const t = await e.evaluateHandle(((e, t) => {
    if (!e.shadowRoot) throw new Error(`shadow root does not exist for element: ${e.tagName.toLowerCase()}`);
    return e.shadowRoot.querySelector(t);
   }), i, r);
   if (await i.dispose(), !t) return null;
   i = t.asElement();
  }
  return i;
 }(e, t, r, i) : await async function c(e, t, s, r) {
  const i = await e.evaluateHandle(((e, t, s) => {
   let r = null;
   return function e(i) {
    if (i && !r) if (3 === i.nodeType) {
     if ("string" == typeof t && i.textContent.trim() === t) return void (r = i.parentElement);
     if ("string" == typeof s && i.textContent.includes(s)) return void (r = i.parentElement);
    } else {
     if ("SCRIPT" === i.nodeName || "STYLE" === i.nodeName) return;
     if (e(i.shadowRoot), i.childNodes) for (let t = 0; t < i.childNodes.length; t++) e(i.childNodes[t]);
    }
   }(e), r;
  }), t, s, r);
  return i ? i.asElement() : null;
 }(e, t, n, o), !a) return null;
 const u = new E2EElement(e, a);
 return await u.e2eSync(), u;
}

async function findAll(e, t, s) {
 const r = [], {lightSelector: i, shadowSelector: n} = getSelector(s), o = await t.$$(i);
 if (0 === o.length) return r;
 if (n) for (let t = 0; t < o.length; t++) {
  const s = getPuppeteerExecution(o[t]), i = await s.evaluateHandle(((e, t) => {
   if (!e.shadowRoot) throw new Error(`shadow root does not exist for element: ${e.tagName.toLowerCase()}`);
   return e.shadowRoot.querySelectorAll(t);
  }), o[t], n);
  await o[t].dispose();
  const a = await i.getProperties();
  await i.dispose();
  for (const t of a.values()) {
   const s = t.asElement();
   if (s) {
    const t = new E2EElement(e, s);
    await t.e2eSync(), r.push(t);
   }
  }
 } else for (let t = 0; t < o.length; t++) {
  const s = new E2EElement(e, o[t]);
  await s.e2eSync(), r.push(s);
 }
 return r;
}

function getSelector(e) {
 const t = {
  lightSelector: null,
  shadowSelector: null,
  text: null,
  contains: null
 };
 if ("string" == typeof e) {
  const s = e.split(">>>");
  t.lightSelector = s[0].trim(), t.shadowSelector = s.length > 1 ? s[1].trim() : null;
 } else if ("string" == typeof e.text) t.text = e.text.trim(); else {
  if ("string" != typeof e.contains) throw new Error(`invalid find selector: ${e}`);
  t.contains = e.contains.trim();
 }
 return t;
}

function getPuppeteerExecution(e) {
 return parseInt(process.env.__STENCIL_PUPPETEER_VERSION__, 10) >= 17 ? e.frame : e.executionContext();
}

async function writeScreenshotData(e, t) {
 const s = function r(e, t) {
  const s = `${t}.json`;
  return path__default.default.join(e, s);
 }(e, t.id), i = JSON.stringify(t, null, 2);
 await writeFile(s, i);
}

function writeFile(e, t) {
 return new Promise(((s, r) => {
  fs__default.default.writeFile(e, t, (e => {
   e ? r(e) : s();
  }));
 }));
}

async function compareScreenshot(e, t, s, r, i, n, o, a) {
 var l, c, u, h, p, d, f, m;
 const g = `${require$$3.createHash("md5").update(s).digest("hex")}.png`, y = path$6.join(t.imagesDir, g);
 await async function v(e, t) {
  await function s(e) {
   return new Promise((t => {
    fs__default.default.access(e, (e => t(!e)));
   }));
  }(e) || await writeFile(e, t);
 }(y, s), s = null, o && (o = normalizePath(path$6.relative(t.rootDir, o)));
 const w = function b(e, t) {
  if ("string" != typeof t || 0 === t.trim().length) throw new Error("invalid test description");
  const s = require$$3.createHash("md5");
  return s.update(t + ":"), s.update(e.userAgent + ":"), void 0 !== e.viewport && (s.update(e.viewport.width + ":"), 
  s.update(e.viewport.height + ":"), s.update(e.viewport.deviceScaleFactor + ":"), 
  s.update(e.viewport.hasTouch + ":"), s.update(e.viewport.isMobile + ":")), s.digest("hex").slice(0, 8).toLowerCase();
 }(e, r), E = {
  id: w,
  image: g,
  device: e.device,
  userAgent: e.userAgent,
  desc: r,
  testPath: o,
  width: i,
  height: n,
  deviceScaleFactor: null === (l = e.viewport) || void 0 === l ? void 0 : l.deviceScaleFactor,
  hasTouch: null === (c = e.viewport) || void 0 === c ? void 0 : c.hasTouch,
  isLandscape: null === (u = e.viewport) || void 0 === u ? void 0 : u.isLandscape,
  isMobile: null === (h = e.viewport) || void 0 === h ? void 0 : h.isMobile,
  diff: {
   id: w,
   desc: r,
   imageA: g,
   imageB: g,
   mismatchedPixels: 0,
   device: e.device,
   userAgent: e.userAgent,
   width: i,
   height: n,
   deviceScaleFactor: null === (p = e.viewport) || void 0 === p ? void 0 : p.deviceScaleFactor,
   hasTouch: null === (d = e.viewport) || void 0 === d ? void 0 : d.hasTouch,
   isLandscape: null === (f = e.viewport) || void 0 === f ? void 0 : f.isLandscape,
   isMobile: null === (m = e.viewport) || void 0 === m ? void 0 : m.isMobile,
   allowableMismatchedPixels: t.allowableMismatchedPixels,
   allowableMismatchedRatio: t.allowableMismatchedRatio,
   testPath: o,
   cacheKey: void 0
  }
 };
 if (t.updateMaster) return await writeScreenshotData(t.currentBuildDir, E), E.diff;
 const _ = t.masterScreenshots[E.id];
 if (!_) return await writeScreenshotData(t.currentBuildDir, E), E.diff;
 if (E.diff.imageA = _, E.diff.imageA !== E.diff.imageB) {
  E.diff.cacheKey = function S(e, t, s) {
   const r = require$$3.createHash("md5");
   return r.update(`${e}:${t}:${s}`), r.digest("hex").slice(0, 10);
  }(E.diff.imageA, E.diff.imageB, a);
  const e = t.cache[E.diff.cacheKey];
  if ("number" != typeof e || isNaN(e)) {
   const e = {
    imageAPath: path$6.join(t.imagesDir, E.diff.imageA),
    imageBPath: path$6.join(t.imagesDir, E.diff.imageB),
    width: Math.round(i),
    height: Math.round(n),
    pixelmatchThreshold: a
   };
   E.diff.mismatchedPixels = await async function T(e, t) {
    return new Promise(((s, r) => {
     const i = "undefined" != typeof jasmine && jasmine.DEFAULT_TIMEOUT_INTERVAL ? .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL : 2500, n = setTimeout((() => {
      r(`getMismatchedPixels timeout: ${i}ms`);
     }), i);
     try {
      let i;
      const o = {
       execArgv: process.execArgv.filter((e => !/^--(debug|inspect)/.test(e))),
       env: process.env,
       cwd: process.cwd(),
       stdio: [ "pipe", "pipe", "pipe", "ipc" ]
      }, a = cp.fork(e, [], o);
      a.on("message", (e => {
       a.kill(), clearTimeout(n), s(e);
      })), a.on("error", (e => {
       clearTimeout(n), r(e);
      })), a.stderr.on("data", (e => {
       i = e.toString();
      })), a.on("exit", (e => {
       clearTimeout(n);
       const t = 0 === e ? new Error("Pixelmatch process exited unexpectedly") : new Error(`Pixelmatch process exited with code ${e}: ${i || "unknown error"}`);
       return r(t);
      })), a.send(t);
     } catch (e) {
      clearTimeout(n), r(`getMismatchedPixels error: ${e}`);
     }
    }));
   }(t.pixelmatchModulePath, e);
  } else E.diff.mismatchedPixels = e;
 }
 return await writeScreenshotData(t.currentBuildDir, E), E.diff;
}

async function e2eGoTo(e, t, s = {}) {
 if (e.isClosed()) throw new Error("e2eGoTo unavailable: page already closed");
 if ("string" != typeof t) throw new Error("invalid gotoTest() url");
 if (!t.startsWith("/")) throw new Error("gotoTest() url must start with /");
 const r = env.__STENCIL_BROWSER_URL__;
 if ("string" != typeof r) throw new Error("invalid gotoTest() browser url");
 const i = r + t.substring(1);
 s.waitUntil || (s.waitUntil = env.__STENCIL_BROWSER_WAIT_UNTIL);
 const n = await e._e2eGoto(i, s);
 if (!n.ok()) throw new Error(`Testing unable to load ${t}, HTTP status: ${n.status()}`);
 return await waitForStencil(e, s), n;
}

async function e2eSetContent(e, t, s = {}) {
 if (e.isClosed()) throw new Error("e2eSetContent unavailable: page already closed");
 if ("string" != typeof t) throw new Error("invalid e2eSetContent() html");
 const r = [], i = env.__STENCIL_APP_SCRIPT_URL__;
 if ("string" != typeof i) throw new Error("invalid e2eSetContent() app script url");
 r.push("<!doctype html>"), r.push("<html>"), r.push("<head>");
 const n = env.__STENCIL_APP_STYLE_URL__;
 "string" == typeof n && r.push(`<link rel="stylesheet" href="${n}">`), r.push(`<script type="module" src="${i}"><\/script>`), 
 r.push("</head>"), r.push("<body>"), r.push(t), r.push("</body>"), r.push("</html>");
 const o = env.__STENCIL_BROWSER_URL__;
 if (await e.setRequestInterception(!0), e.on("request", (e => {
  o === e.url() ? e.respond({
   status: 200,
   contentType: "text/html",
   body: r.join("\n")
  }) : e.continue();
 })), s.waitUntil || (s.waitUntil = env.__STENCIL_BROWSER_WAIT_UNTIL), !(await e._e2eGoto(o, s)).ok()) throw new Error("Testing unable to load content");
 await waitForStencil(e, s);
}

async function waitForStencil(e, t) {
 try {
  const s = "number" == typeof t.timeout ? t.timeout : 4750;
  await e.waitForFunction("window.stencilAppLoaded", {
   timeout: s
  });
 } catch (e) {
  throw new Error("App did not load in allowed time. Please ensure the content loads a stencil application.");
 }
}

async function waitForChanges(e) {
 try {
  if (e.isClosed()) return;
  if (await Promise.all(e._e2eElements.map((e => e.e2eRunActions()))), e.isClosed()) return;
  if (await e.evaluate((() => new Promise((e => {
   requestAnimationFrame((() => {
    const t = [], s = (e, t) => {
     if (null != e) {
      "shadowRoot" in e && e.shadowRoot instanceof ShadowRoot && s(e.shadowRoot, t);
      const r = e.children, i = r.length;
      for (let e = 0; e < i; e++) {
       const i = r[e];
       null != i && (i.tagName.includes("-") && "function" == typeof i.componentOnReady && t.push(i.componentOnReady()), 
       s(i, t));
      }
     }
    };
    s(document.documentElement, t), Promise.all(t).then((() => {
     e();
    })).catch((() => {
     e();
    }));
   }));
  })))), e.isClosed()) return;
  "function" == typeof e.waitForTimeout ? await e.waitForTimeout(100) : await e.waitFor(100), 
  await Promise.all(e._e2eElements.map((e => e.e2eSync())));
 } catch (e) {}
}

function serializeConsoleMessage(e) {
 return `${e.text()} ${function t(e) {
  let t = "";
  return e && e.url && (t = `\nLocation: ${e.url}`, e.lineNumber && (t += `:${e.lineNumber}`), 
  e.columnNumber && (t += `:${e.columnNumber}`)), t;
 }(e.location())}`;
}

function findRootComponent(e, t) {
 if (null != t) {
  const s = t.children, r = s.length;
  for (let t = 0; t < r; t++) {
   const r = s[t];
   if (e.has(r.nodeName.toLowerCase())) return r;
  }
  for (let t = 0; t < r; t++) {
   const r = findRootComponent(e, s[t]);
   if (null != r) return r;
  }
 }
 return null;
}

function getAppUrl(e, t, s) {
 const r = e.outputTargets.find(isOutputTargetWww);
 if (r && isString(r.buildDir) && isString(r.dir)) {
  const e = r.buildDir, i = path$6.join(e, s), n = path$6.relative(r.dir, i);
  return new URL(n, t).href;
 }
 const i = e.outputTargets.find(isOutputTargetDistLazy);
 if (i && isString(i.esmDir)) {
  const r = i.esmDir, n = path$6.join(r, s), o = path$6.relative(e.rootDir, n);
  return new URL(o, t).href;
 }
 return t;
}

var commonjsGlobal, debug_1, constants$3, re$3, parseOptions_1, identifiers, semver, constants$2, origCwd, cwd, platform, chdir, polyfills$1, Stream, legacyStreams, clone_1, getPrototypeOf, fs$4, polyfills, legacy, clone, util$2, gracefulQueue, previousSymbol, debug$2, queue, gracefulFs, retryTimer, ansiColors, symbols, lockfile, commonjs$2, balancedMatch, balanced, braceExpansion, escSlash, escOpen, escClose, escComma, escPeriod, glob, commonjs$1, LRUCache_1, commonjs, pattern, walker, ignore, processor, hasMagic$1, compare_1, lte_1, yallist, lruCache, lt_1, cmp_1, comparator, range, satisfies_1, homedir$2, caller$2, pathParse, isWindows, splitWindowsRe, win32, splitPathRe, posix, path$4, parse, getNodeModulesDirs, nodeModulesPaths$2, normalizeOptions$2, toStr, max, concatty, slicy, joiny, implementation, functionBind, call, $hasOwn, hasown, hasOwn, data$1, isCoreModule$2, fs$2, getHomedir$1, path$2, caller$1, nodeModulesPaths$1, normalizeOptions$1, isCore$2, realpathFS$1, homedir$1, defaultPaths$1, defaultIsFile$1, defaultIsDir$1, defaultRealpath, maybeRealpath, defaultReadPackage, getPackageCandidates$1, async$1, isCoreModule$1, data, core, mod, core_1, isCoreModule, isCore$1, isCore, fs, path, getHomedir, caller, nodeModulesPaths, normalizeOptions, realpathFS, homedir, defaultPaths, defaultIsFile, defaultIsDir, defaultRealpathSync, maybeRealpathSync, defaultReadPackageSync, getPackageCandidates, sync, async;

const NodeEnvironment = require("jest-environment-node"), stencil_js = require("../compiler/stencil.js"), path$6 = require("path"), TestRunner = require("jest-runner"), appData = _lazyRequire("@stencil/core/internal/app-data"), testing = _lazyRequire("@stencil/core/internal/testing"), index_cjs = _lazyRequire("../mock-doc/index.cjs"), jest$1 = require("jest"), fs$6 = require("fs"), require$$0$1 = require("constants"), require$$0$2 = require("stream"), require$$4 = require("util"), require$$5 = require("assert"), require$$3 = require("crypto"), os$3 = require("os"), require$$8 = require("buffer"), require$$9 = require("tty"), require$$7 = require("events"), require$$2$1 = require("url"), promises = require("fs/promises"), require$$2 = require("string_decoder"), cp = require("child_process"), process$3 = require("process"), index_js = _lazyRequire("../dev-server/index.js"), NodeEnvironment__default = _interopDefaultLegacy(NodeEnvironment), path__default = _interopDefaultLegacy(path$6), TestRunner__default = _interopDefaultLegacy(TestRunner), fs__default = _interopDefaultLegacy(fs$6), fs__namespace = _interopNamespace(fs$6), require$$0__default = _interopDefaultLegacy(require$$0$1), require$$0__default$1 = _interopDefaultLegacy(require$$0$2), require$$4__default = _interopDefaultLegacy(require$$4), require$$5__default = _interopDefaultLegacy(require$$5), require$$3__default = _interopDefaultLegacy(require$$3), os__default = _interopDefaultLegacy(os$3), os__namespace = _interopNamespace(os$3), require$$8__default = _interopDefaultLegacy(require$$8), require$$9__default = _interopDefaultLegacy(require$$9), require$$7__default = _interopDefaultLegacy(require$$7), require$$2__default$1 = _interopDefaultLegacy(require$$2$1), require$$2__default = _interopDefaultLegacy(require$$2), cp__namespace = _interopNamespace(cp), process__namespace = _interopNamespace(process$3);

commonjsGlobal = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : {};

const debug$4 = ("object" == typeof process && process.env, () => {});

debug_1 = debug$4;

const MAX_SAFE_INTEGER$1 = Number.MAX_SAFE_INTEGER || 9007199254740991;

constants$3 = {
 MAX_LENGTH: 256,
 MAX_SAFE_COMPONENT_LENGTH: 16,
 MAX_SAFE_BUILD_LENGTH: 250,
 MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$1,
 RELEASE_TYPES: [ "major", "premajor", "minor", "preminor", "patch", "prepatch", "prerelease" ],
 SEMVER_SPEC_VERSION: "2.0.0",
 FLAG_INCLUDE_PRERELEASE: 1,
 FLAG_LOOSE: 2
}, function(e, t) {
 const {MAX_SAFE_COMPONENT_LENGTH: s, MAX_SAFE_BUILD_LENGTH: r, MAX_LENGTH: i} = constants$3, n = debug_1, o = (t = e.exports = {}).re = [], a = t.safeRe = [], l = t.src = [], c = t.t = {};
 let u = 0;
 const h = "[a-zA-Z0-9-]", p = [ [ "\\s", 1 ], [ "\\d", i ], [ h, r ] ], d = (e, t, s) => {
  const r = (e => {
   for (const [t, s] of p) e = e.split(`${t}*`).join(`${t}{0,${s}}`).split(`${t}+`).join(`${t}{1,${s}}`);
   return e;
  })(t), i = u++;
  n(e, i, t), c[e] = i, l[i] = t, o[i] = new RegExp(t, s ? "g" : void 0), a[i] = new RegExp(r, s ? "g" : void 0);
 };
 d("NUMERICIDENTIFIER", "0|[1-9]\\d*"), d("NUMERICIDENTIFIERLOOSE", "\\d+"), d("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${h}*`), 
 d("MAINVERSION", `(${l[c.NUMERICIDENTIFIER]})\\.(${l[c.NUMERICIDENTIFIER]})\\.(${l[c.NUMERICIDENTIFIER]})`), 
 d("MAINVERSIONLOOSE", `(${l[c.NUMERICIDENTIFIERLOOSE]})\\.(${l[c.NUMERICIDENTIFIERLOOSE]})\\.(${l[c.NUMERICIDENTIFIERLOOSE]})`), 
 d("PRERELEASEIDENTIFIER", `(?:${l[c.NUMERICIDENTIFIER]}|${l[c.NONNUMERICIDENTIFIER]})`), 
 d("PRERELEASEIDENTIFIERLOOSE", `(?:${l[c.NUMERICIDENTIFIERLOOSE]}|${l[c.NONNUMERICIDENTIFIER]})`), 
 d("PRERELEASE", `(?:-(${l[c.PRERELEASEIDENTIFIER]}(?:\\.${l[c.PRERELEASEIDENTIFIER]})*))`), 
 d("PRERELEASELOOSE", `(?:-?(${l[c.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${l[c.PRERELEASEIDENTIFIERLOOSE]})*))`), 
 d("BUILDIDENTIFIER", `${h}+`), d("BUILD", `(?:\\+(${l[c.BUILDIDENTIFIER]}(?:\\.${l[c.BUILDIDENTIFIER]})*))`), 
 d("FULLPLAIN", `v?${l[c.MAINVERSION]}${l[c.PRERELEASE]}?${l[c.BUILD]}?`), d("FULL", `^${l[c.FULLPLAIN]}$`), 
 d("LOOSEPLAIN", `[v=\\s]*${l[c.MAINVERSIONLOOSE]}${l[c.PRERELEASELOOSE]}?${l[c.BUILD]}?`), 
 d("LOOSE", `^${l[c.LOOSEPLAIN]}$`), d("GTLT", "((?:<|>)?=?)"), d("XRANGEIDENTIFIERLOOSE", `${l[c.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`), 
 d("XRANGEIDENTIFIER", `${l[c.NUMERICIDENTIFIER]}|x|X|\\*`), d("XRANGEPLAIN", `[v=\\s]*(${l[c.XRANGEIDENTIFIER]})(?:\\.(${l[c.XRANGEIDENTIFIER]})(?:\\.(${l[c.XRANGEIDENTIFIER]})(?:${l[c.PRERELEASE]})?${l[c.BUILD]}?)?)?`), 
 d("XRANGEPLAINLOOSE", `[v=\\s]*(${l[c.XRANGEIDENTIFIERLOOSE]})(?:\\.(${l[c.XRANGEIDENTIFIERLOOSE]})(?:\\.(${l[c.XRANGEIDENTIFIERLOOSE]})(?:${l[c.PRERELEASELOOSE]})?${l[c.BUILD]}?)?)?`), 
 d("XRANGE", `^${l[c.GTLT]}\\s*${l[c.XRANGEPLAIN]}$`), d("XRANGELOOSE", `^${l[c.GTLT]}\\s*${l[c.XRANGEPLAINLOOSE]}$`), 
 d("COERCEPLAIN", `(^|[^\\d])(\\d{1,${s}})(?:\\.(\\d{1,${s}}))?(?:\\.(\\d{1,${s}}))?`), 
 d("COERCE", `${l[c.COERCEPLAIN]}(?:$|[^\\d])`), d("COERCEFULL", l[c.COERCEPLAIN] + `(?:${l[c.PRERELEASE]})?` + `(?:${l[c.BUILD]})?(?:$|[^\\d])`), 
 d("COERCERTL", l[c.COERCE], !0), d("COERCERTLFULL", l[c.COERCEFULL], !0), d("LONETILDE", "(?:~>?)"), 
 d("TILDETRIM", `(\\s*)${l[c.LONETILDE]}\\s+`, !0), t.tildeTrimReplace = "$1~", d("TILDE", `^${l[c.LONETILDE]}${l[c.XRANGEPLAIN]}$`), 
 d("TILDELOOSE", `^${l[c.LONETILDE]}${l[c.XRANGEPLAINLOOSE]}$`), d("LONECARET", "(?:\\^)"), 
 d("CARETTRIM", `(\\s*)${l[c.LONECARET]}\\s+`, !0), t.caretTrimReplace = "$1^", d("CARET", `^${l[c.LONECARET]}${l[c.XRANGEPLAIN]}$`), 
 d("CARETLOOSE", `^${l[c.LONECARET]}${l[c.XRANGEPLAINLOOSE]}$`), d("COMPARATORLOOSE", `^${l[c.GTLT]}\\s*(${l[c.LOOSEPLAIN]})$|^$`), 
 d("COMPARATOR", `^${l[c.GTLT]}\\s*(${l[c.FULLPLAIN]})$|^$`), d("COMPARATORTRIM", `(\\s*)${l[c.GTLT]}\\s*(${l[c.LOOSEPLAIN]}|${l[c.XRANGEPLAIN]})`, !0), 
 t.comparatorTrimReplace = "$1$2$3", d("HYPHENRANGE", `^\\s*(${l[c.XRANGEPLAIN]})\\s+-\\s+(${l[c.XRANGEPLAIN]})\\s*$`), 
 d("HYPHENRANGELOOSE", `^\\s*(${l[c.XRANGEPLAINLOOSE]})\\s+-\\s+(${l[c.XRANGEPLAINLOOSE]})\\s*$`), 
 d("STAR", "(<|>)?=?\\s*\\*"), d("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$"), d("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
}(re$3 = {
 exports: {}
}, re$3.exports);

const looseOption = Object.freeze({
 loose: !0
}), emptyOpts = Object.freeze({});

parseOptions_1 = e => e ? "object" != typeof e ? looseOption : e : emptyOpts;

const numeric$1 = /^[0-9]+$/, compareIdentifiers$1 = (e, t) => {
 const s = numeric$1.test(e), r = numeric$1.test(t);
 return s && r && (e = +e, t = +t), e === t ? 0 : s && !r ? -1 : r && !s ? 1 : e < t ? -1 : 1;
};

identifiers = {
 compareIdentifiers: compareIdentifiers$1,
 rcompareIdentifiers: (e, t) => compareIdentifiers$1(t, e)
};

const debug$3 = debug_1, {MAX_LENGTH, MAX_SAFE_INTEGER} = constants$3, {safeRe: re$2, t: t$2} = re$3.exports, parseOptions$2 = parseOptions_1, {compareIdentifiers} = identifiers;

class SemVer$4 {
 constructor(e, t) {
  if (t = parseOptions$2(t), e instanceof SemVer$4) {
   if (e.loose === !!t.loose && e.includePrerelease === !!t.includePrerelease) return e;
   e = e.version;
  } else if ("string" != typeof e) throw new TypeError(`Invalid version. Must be a string. Got type "${typeof e}".`);
  if (e.length > MAX_LENGTH) throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
  debug$3("SemVer", e, t), this.options = t, this.loose = !!t.loose, this.includePrerelease = !!t.includePrerelease;
  const s = e.trim().match(t.loose ? re$2[t$2.LOOSE] : re$2[t$2.FULL]);
  if (!s) throw new TypeError(`Invalid Version: ${e}`);
  if (this.raw = e, this.major = +s[1], this.minor = +s[2], this.patch = +s[3], this.major > MAX_SAFE_INTEGER || this.major < 0) throw new TypeError("Invalid major version");
  if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) throw new TypeError("Invalid minor version");
  if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) throw new TypeError("Invalid patch version");
  s[4] ? this.prerelease = s[4].split(".").map((e => {
   if (/^[0-9]+$/.test(e)) {
    const t = +e;
    if (t >= 0 && t < MAX_SAFE_INTEGER) return t;
   }
   return e;
  })) : this.prerelease = [], this.build = s[5] ? s[5].split(".") : [], this.format();
 }
 format() {
  return this.version = `${this.major}.${this.minor}.${this.patch}`, this.prerelease.length && (this.version += `-${this.prerelease.join(".")}`), 
  this.version;
 }
 toString() {
  return this.version;
 }
 compare(e) {
  if (debug$3("SemVer.compare", this.version, this.options, e), !(e instanceof SemVer$4)) {
   if ("string" == typeof e && e === this.version) return 0;
   e = new SemVer$4(e, this.options);
  }
  return e.version === this.version ? 0 : this.compareMain(e) || this.comparePre(e);
 }
 compareMain(e) {
  return e instanceof SemVer$4 || (e = new SemVer$4(e, this.options)), compareIdentifiers(this.major, e.major) || compareIdentifiers(this.minor, e.minor) || compareIdentifiers(this.patch, e.patch);
 }
 comparePre(e) {
  if (e instanceof SemVer$4 || (e = new SemVer$4(e, this.options)), this.prerelease.length && !e.prerelease.length) return -1;
  if (!this.prerelease.length && e.prerelease.length) return 1;
  if (!this.prerelease.length && !e.prerelease.length) return 0;
  let t = 0;
  do {
   const s = this.prerelease[t], r = e.prerelease[t];
   if (debug$3("prerelease compare", t, s, r), void 0 === s && void 0 === r) return 0;
   if (void 0 === r) return 1;
   if (void 0 === s) return -1;
   if (s !== r) return compareIdentifiers(s, r);
  } while (++t);
 }
 compareBuild(e) {
  e instanceof SemVer$4 || (e = new SemVer$4(e, this.options));
  let t = 0;
  do {
   const s = this.build[t], r = e.build[t];
   if (debug$3("prerelease compare", t, s, r), void 0 === s && void 0 === r) return 0;
   if (void 0 === r) return 1;
   if (void 0 === s) return -1;
   if (s !== r) return compareIdentifiers(s, r);
  } while (++t);
 }
 inc(e, t, s) {
  switch (e) {
  case "premajor":
   this.prerelease.length = 0, this.patch = 0, this.minor = 0, this.major++, this.inc("pre", t, s);
   break;

  case "preminor":
   this.prerelease.length = 0, this.patch = 0, this.minor++, this.inc("pre", t, s);
   break;

  case "prepatch":
   this.prerelease.length = 0, this.inc("patch", t, s), this.inc("pre", t, s);
   break;

  case "prerelease":
   0 === this.prerelease.length && this.inc("patch", t, s), this.inc("pre", t, s);
   break;

  case "major":
   0 === this.minor && 0 === this.patch && 0 !== this.prerelease.length || this.major++, 
   this.minor = 0, this.patch = 0, this.prerelease = [];
   break;

  case "minor":
   0 === this.patch && 0 !== this.prerelease.length || this.minor++, this.patch = 0, 
   this.prerelease = [];
   break;

  case "patch":
   0 === this.prerelease.length && this.patch++, this.prerelease = [];
   break;

  case "pre":
   {
    const e = Number(s) ? 1 : 0;
    if (!t && !1 === s) throw new Error("invalid increment argument: identifier is empty");
    if (0 === this.prerelease.length) this.prerelease = [ e ]; else {
     let r = this.prerelease.length;
     for (;--r >= 0; ) "number" == typeof this.prerelease[r] && (this.prerelease[r]++, 
     r = -2);
     if (-1 === r) {
      if (t === this.prerelease.join(".") && !1 === s) throw new Error("invalid increment argument: identifier already exists");
      this.prerelease.push(e);
     }
    }
    if (t) {
     let r = [ t, e ];
     !1 === s && (r = [ t ]), 0 === compareIdentifiers(this.prerelease[0], t) ? isNaN(this.prerelease[1]) && (this.prerelease = r) : this.prerelease = r;
    }
    break;
   }

  default:
   throw new Error(`invalid increment argument: ${e}`);
  }
  return this.raw = this.format(), this.build.length && (this.raw += `+${this.build.join(".")}`), 
  this;
 }
}

const SemVer$3 = semver = SemVer$4, major$1 = (e, t) => new SemVer$3(e, t).major, COPY = "copy", VALID_CONFIG_OUTPUT_TARGETS = [ "www", "dist", "dist-collection", "dist-custom-elements", "dist-lazy", "dist-hydrate-script", "docs-json", "docs-readme", "docs-vscode", "docs-custom", COPY, "custom", "stats" ], formatComponentRuntimeWatchers = e => {
 const t = {};
 return e.watchers.forEach((({propName: e, methodName: s}) => {
  var r;
  t[e] = [ ...null !== (r = t[e]) && void 0 !== r ? r : [], s ];
 })), t;
}, formatComponentRuntimeMembers = (e, t = !0) => ({
 ...formatPropertiesRuntimeMember(e.properties),
 ...formatStatesRuntimeMember(e.states),
 ...t ? formatMethodsRuntimeMember(e.methods) : {}
}), formatPropertiesRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = trimFalsy([ formatFlags(e), formatAttrName(e) ]);
 })), t;
}, formatFlags = e => {
 let t = formatPropType(e.type);
 return e.mutable && (t |= 1024), e.reflect && (t |= 512), t;
}, formatAttrName = e => {
 if ("string" == typeof e.attribute) {
  if (e.name === e.attribute) return;
  return e.attribute;
 }
}, formatPropType = e => "string" === e ? 1 : "number" === e ? 2 : "boolean" === e ? 4 : "any" === e ? 8 : 16, formatStatesRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = [ 32 ];
 })), t;
}, formatMethodsRuntimeMember = e => {
 const t = {};
 return e.forEach((e => {
  t[e.name] = [ 64 ];
 })), t;
}, formatHostListeners = e => e.listeners.map((e => [ computeListenerFlags(e), e.name, e.method ])), computeListenerFlags = e => {
 let t = 0;
 switch (e.capture && (t |= 2), e.passive && (t |= 1), e.target) {
 case "document":
  t |= 4;
  break;

 case "window":
  t |= 8;
  break;

 case "body":
  t |= 16;
  break;

 case "parent":
  t |= 32;
 }
 return t;
}, trimFalsy = e => {
 const t = e;
 for (let e = t.length - 1; e >= 0 && !t[e]; e--) t.pop();
 return t;
}, noop$1 = () => {}, flatOne = e => e.flat ? e.flat(1) : e.reduce(((e, t) => (e.push(...t), 
e)), []), pluck = (e, t) => t.reduce(((t, s) => (e[s] && (t[s] = e[s]), t)), {}), isBoolean = e => "boolean" == typeof e, isFunction = e => "function" == typeof e, isNumber = e => "number" == typeof e, isObject$1 = e => null != e && "object" == typeof e && !1 === Array.isArray(e), isString = e => "string" == typeof e, isIterable = e => (e => null != e)(e) && isFunction(e[Symbol.iterator]), isGlob = e => {
 const t = {
  "{": "}",
  "(": ")",
  "[": "]"
 }, s = /\\(.)|(^!|\*|[\].+)]\?|\[[^\\\]]+\]|\{[^\\}]+\}|\(\?[:!=][^\\)]+\)|\([^|]+\|[^\\)]+\))/;
 if ("" === e) return !1;
 let r;
 for (;r = s.exec(e); ) {
  if (r[2]) return !0;
  let s = r.index + r[0].length;
  const i = r[1], n = i ? t[i] : null;
  if (i && n) {
   const t = e.indexOf(n, s);
   -1 !== t && (s = t + 1);
  }
  e = e.slice(s);
 }
 return !1;
}, windowsPathRegex = /^(?:[a-zA-Z]:|[\\/]{2}[^\\/]+[\\/]+[^\\/]+)?[\\/]$/, buildError = e => {
 const t = {
  level: "error",
  type: "build",
  header: "Build Error",
  messageText: "build error",
  relFilePath: void 0,
  absFilePath: void 0,
  lines: []
 };
 return e && e.push(t), t;
}, buildWarn = e => {
 const t = {
  level: "warn",
  type: "build",
  header: "Build Warn",
  messageText: "build warn",
  lines: []
 };
 return e.push(t), t;
}, catchError = (e, t, s) => {
 const r = {
  level: "error",
  type: "build",
  header: "Build Error",
  messageText: "build error",
  lines: []
 };
 return isString(s) ? r.messageText = s.length ? s : "UNKNOWN ERROR" : null != t && (null != t.stack ? r.messageText = t.stack.toString() : null != t.message ? r.messageText = t.message.length ? t.message : "UNKNOWN ERROR" : r.messageText = t.toString()), 
 null == e || shouldIgnoreError(r.messageText) || e.push(r), r;
}, hasError = e => null != e && 0 !== e.length && e.some((e => "error" === e.level && "runtime" !== e.type)), shouldIgnoreError = e => e === TASK_CANCELED_MSG, TASK_CANCELED_MSG = "task canceled", normalizePath = (e, t = !0) => {
 if ("string" != typeof e) throw new Error("invalid path to normalize");
 e = normalizeSlashes(e.trim());
 const s = pathComponents(e, getRootLength(e)), r = reducePathComponents(s), i = r[0], n = r[1], o = i + r.slice(1).join("/");
 return "" === o ? "." : "" === i && n && e.includes("/") && !n.startsWith(".") && !n.startsWith("@") && t ? "./" + o : o;
}, normalizeSlashes = e => e.replace(backslashRegExp, "/"), backslashRegExp = /\\/g, reducePathComponents = e => {
 if (!Array.isArray(e) || 0 === e.length) return [];
 const t = [ e[0] ];
 for (let s = 1; s < e.length; s++) {
  const r = e[s];
  if (r && "." !== r) {
   if (".." === r) if (t.length > 1) {
    if (".." !== t[t.length - 1]) {
     t.pop();
     continue;
    }
   } else if (t[0]) continue;
   t.push(r);
  }
 }
 return t;
}, getRootLength = e => {
 const t = getEncodedRootLength(e);
 return t < 0 ? ~t : t;
}, getEncodedRootLength = e => {
 if (!e) return 0;
 const t = e.charCodeAt(0);
 if (47 === t || 92 === t) {
  if (e.charCodeAt(1) !== t) return 1;
  const s = e.indexOf(47 === t ? "/" : "\\", 2);
  return s < 0 ? e.length : s + 1;
 }
 if (isVolumeCharacter(t) && 58 === e.charCodeAt(1)) {
  const t = e.charCodeAt(2);
  if (47 === t || 92 === t) return 3;
  if (2 === e.length) return 2;
 }
 const s = e.indexOf("://");
 if (-1 !== s) {
  const t = s + 3, r = e.indexOf("/", t);
  if (-1 !== r) {
   const i = e.slice(0, s), n = e.slice(t, r);
   if ("file" === i && ("" === n || "localhost" === n) && isVolumeCharacter(e.charCodeAt(r + 1))) {
    const t = getFileUrlVolumeSeparatorEnd(e, r + 2);
    if (-1 !== t) {
     if (47 === e.charCodeAt(t)) return ~(t + 1);
     if (t === e.length) return ~t;
    }
   }
   return ~(r + 1);
  }
  return ~e.length;
 }
 return 0;
}, isVolumeCharacter = e => e >= 97 && e <= 122 || e >= 65 && e <= 90, getFileUrlVolumeSeparatorEnd = (e, t) => {
 const s = e.charCodeAt(t);
 if (58 === s) return t + 1;
 if (37 === s && 51 === e.charCodeAt(t + 1)) {
  const s = e.charCodeAt(t + 2);
  if (97 === s || 65 === s) return t + 3;
 }
 return -1;
}, pathComponents = (e, t) => {
 const s = e.substring(0, t), r = e.substring(t).split("/"), i = r.length;
 return i > 0 && !r[i - 1] && r.pop(), [ s, ...r ];
}, normalizeFsPath = e => normalizePath(e.split("?")[0].replace(/\0/g, "")), loadTypeScriptDiagnostic = e => {
 var t;
 const s = {
  absFilePath: void 0,
  code: e.code.toString(),
  columnNumber: void 0,
  header: "TypeScript",
  language: "typescript",
  level: "warn",
  lineNumber: void 0,
  lines: [],
  messageText: flattenDiagnosticMessageText(e, e.messageText),
  relFilePath: void 0,
  type: "typescript"
 };
 if (1 === e.category && (s.level = "error"), e.file && "number" == typeof e.start) {
  s.absFilePath = e.file.fileName;
  const i = "string" != typeof (r = e.file.text) ? [] : (r = r.replace(/\\r/g, "\n")).split("\n"), n = e.file.getLineAndCharacterOfPosition(e.start), o = {
   lineIndex: n.line,
   lineNumber: n.line + 1,
   text: i[n.line],
   errorCharStart: n.character,
   errorLength: Math.max(null !== (t = e.length) && void 0 !== t ? t : 0, 1)
  };
  if (s.lineNumber = o.lineNumber, s.columnNumber = o.errorCharStart + 1, s.lines.push(o), 
  0 === o.errorLength && o.errorCharStart > 0 && (o.errorLength = 1, o.errorCharStart--), 
  o.lineIndex > 0) {
   const e = {
    lineIndex: o.lineIndex - 1,
    lineNumber: o.lineNumber - 1,
    text: i[o.lineIndex - 1],
    errorCharStart: -1,
    errorLength: -1
   };
   s.lines.unshift(e);
  }
  if (o.lineIndex + 1 < i.length) {
   const e = {
    lineIndex: o.lineIndex + 1,
    lineNumber: o.lineNumber + 1,
    text: i[o.lineIndex + 1],
    errorCharStart: -1,
    errorLength: -1
   };
   s.lines.push(e);
  }
 }
 var r;
 return s;
}, flattenDiagnosticMessageText = (e, t) => {
 var s, r;
 if ("string" == typeof t) return t;
 if (void 0 === t) return "";
 const i = [], n = (null !== (r = null === (s = e.file) || void 0 === s ? void 0 : s.fileName) && void 0 !== r ? r : "").includes("stencil.config");
 n && i.push(2322);
 let o = "";
 if (!i.includes(t.code) && (o = t.messageText, isIterable(t.next))) for (const s of t.next) o += flattenDiagnosticMessageText(e, s);
 return n && (o = o.replace("type 'StencilConfig'", "Stencil Config"), o = o.replace("Object literal may only specify known properties, but ", ""), 
 o = o.replace("Object literal may only specify known properties, and ", "")), o.trim();
}, getComponentsDtsTypesFilePath = e => join(e.typesDir, "components.d.ts"), isOutputTargetDist = e => "dist" === e.type, isOutputTargetDistCollection = e => "dist-collection" === e.type, isOutputTargetDistCustomElements = e => "dist-custom-elements" === e.type, isOutputTargetDistLazy = e => "dist-lazy" === e.type, isOutputTargetHydrate = e => "dist-hydrate-script" === e.type, isOutputTargetCustom = e => "custom" === e.type, isOutputTargetDocsReadme = e => "docs-readme" === e.type, isOutputTargetDocsJson = e => "docs-json" === e.type, isOutputTargetDocsCustom = e => "docs-custom" === e.type, isOutputTargetDocsVscode = e => "docs-vscode" === e.type, isOutputTargetWww = e => "www" === e.type, isOutputTargetStats = e => "stats" === e.type, isJest27TransformOptions = e => null != e && "object" == typeof e && e.hasOwnProperty("config");

let _tsCompilerOptions$2 = null, _tsCompilerOptionsKey$2 = null;

const jestPreprocessor$2 = {
 process(e, t, s, r) {
  if (isJest27TransformOptions(s) && (r = s.config), !r) throw "Unable to find Jest transformation options.";
  if (function i(e, t) {
   var s;
   const r = (null !== (s = e.split(".").pop()) && void 0 !== s ? s : "").toLowerCase().split("?")[0];
   if ("ts" === r || "tsx" === r || "jsx" === r) return !0;
   if ("mjs" === r) return !0;
   if ("js" === r) {
    if (t.includes("import ") || t.includes("import.") || t.includes("import(")) return !0;
    if (t.includes("export ")) return !0;
   }
   return "css" === r;
  }(t, e)) {
   const s = {
    file: t,
    currentDirectory: r.rootDir
   }, i = getCompilerOptions$2(r.rootDir);
   i && (i.baseUrl && (s.baseUrl = i.baseUrl), i.paths && (s.paths = i.paths));
   const n = transpile(e, s), o = n.diagnostics.some((e => "error" === e.level));
   if (n.diagnostics && o) {
    const e = n.diagnostics.map(formatDiagnostic$2).join("\n\n");
    throw new Error(e);
   }
   return n.code;
  }
  return e;
 },
 getCacheKey(e, t, s, r) {
  if (isJest27TransformOptions(s) && (r = s.config), !r) throw "Unable to find Jest transformation options.";
  if (!_tsCompilerOptionsKey$2) {
   const e = getCompilerOptions$2(r.rootDir);
   _tsCompilerOptionsKey$2 = JSON.stringify(e);
  }
  return [ process.version, _tsCompilerOptionsKey$2, e, t, s, !!r.instrument, 7 ].join(":");
 }
}, testingDir$2 = __dirname, rootDir$2 = path$6.join(testingDir$2, ".."), internalDir$2 = path$6.join(rootDir$2, "internal"), moduleExtensions$2 = [ "ts", "tsx", "js", "mjs", "jsx" ], moduleExtensionRegexp$2 = "(" + moduleExtensions$2.join("|") + ")", preset$2 = {
 moduleFileExtensions: [ ...moduleExtensions$2, "json", "d.ts" ],
 moduleNameMapper: {
  "^@stencil/core/cli$": path$6.join(rootDir$2, "cli", "index.js"),
  "^@stencil/core/compiler$": path$6.join(rootDir$2, "compiler", "stencil.js"),
  "^@stencil/core/internal$": path$6.join(internalDir$2, "testing", "index.js"),
  "^@stencil/core/internal/app-data$": path$6.join(internalDir$2, "app-data", "index.cjs"),
  "^@stencil/core/internal/app-globals$": path$6.join(internalDir$2, "app-globals", "index.js"),
  "^@stencil/core/internal/testing$": path$6.join(internalDir$2, "testing", "index.js"),
  "^@stencil/core/mock-doc$": path$6.join(rootDir$2, "mock-doc", "index.cjs"),
  "^@stencil/core/sys$": path$6.join(rootDir$2, "sys", "node", "index.js"),
  "^@stencil/core/testing$": path$6.join(testingDir$2, "index.js"),
  "^@stencil/core$": path$6.join(internalDir$2, "testing", "index.js")
 },
 setupFilesAfterEnv: [ path$6.join(testingDir$2, "jest-setuptestframework.js") ],
 testEnvironment: path$6.join(testingDir$2, "jest-environment.js"),
 testPathIgnorePatterns: [ "/.cache", "/.stencil", "/.vscode", "/dist", "/node_modules", "/www" ],
 testRegex: "(/__tests__/.*|\\.?(test|spec))\\." + moduleExtensionRegexp$2 + "$",
 transform: {
  "^.+\\.(ts|tsx|jsx|css|mjs)$": path$6.join(testingDir$2, "jest-preprocessor.js")
 },
 watchPathIgnorePatterns: [ "^.+\\.d\\.ts$" ]
}, mockedResponses = new Map, mockFetch = {
 json(e, t) {
  setMockedResponse(new index_cjs.MockResponse(JSON.stringify(e, null, 2), {
   headers: new index_cjs.MockHeaders({
    "Content-Type": "application/json"
   })
  }), t, !1);
 },
 text(e, t) {
  setMockedResponse(new index_cjs.MockResponse(e, {
   headers: new index_cjs.MockHeaders({
    "Content-Type": "text/plain"
   })
  }), t, !1);
 },
 response(e, t) {
  setMockedResponse(e, t, !1);
 },
 reject(e, t) {
  setMockedResponse(e, t, !0);
 },
 reset: function mockFetchReset() {
  mockedResponses.clear();
 }
};

class MockResponse404 extends index_cjs.MockResponse {
 constructor() {
  super("", {
   headers: new index_cjs.MockHeaders({
    "Content-Type": "text/plain"
   })
  }), this.ok = !1, this.status = 404, this.statusText = "Not Found";
 }
 async json() {
  return {
   status: 404,
   statusText: "Not Found"
  };
 }
 async text() {
  return "Not Found";
 }
}

const FETCH_DEFAULT_PATH = "/mock-fetch-data", HtmlSerializer$2 = {
 print: e => index_cjs.serializeNodeToHtml(e, {
  serializeShadowRoot: !0,
  prettyHtml: !0,
  outerHtml: !0
 }),
 test: e => null != e && (e instanceof HTMLElement || e instanceof index_cjs.MockNode)
}, deepEqual$2 = function e(t, s) {
 if (t === s) return !0;
 if (t && s && "object" == typeof t && "object" == typeof s) {
  const r = Array.isArray(t), i = Array.isArray(s);
  let n, o, a;
  if (r && i) {
   if (o = t.length, o != s.length) return !1;
   for (n = o; 0 != n--; ) if (!e(t[n], s[n])) return !1;
   return !0;
  }
  if (r != i) return !1;
  const l = t instanceof Date, c = s instanceof Date;
  if (l != c) return !1;
  if (l && c) return t.getTime() == s.getTime();
  const u = t instanceof RegExp, h = s instanceof RegExp;
  if (u != h) return !1;
  if (u && h) return t.toString() == s.toString();
  const p = Object.keys(t);
  if (o = p.length, o !== Object.keys(s).length) return !1;
  for (n = o; 0 != n--; ) if (!Object.prototype.hasOwnProperty.call(s, p[n])) return !1;
  for (n = o; 0 != n--; ) if (a = p[n], !e(t[a], s[a])) return !1;
  return !0;
 }
 return t != t && s != s;
}, expectExtend$2 = {
 toEqualAttribute: function toEqualAttribute$2(e, t, s) {
  if (!e) throw new Error("expect toMatchAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toMatchAttribute value is not an element");
  let r = e.getAttribute(t);
  null != s && (s = String(s)), null != r && (r = String(r));
  const i = s === r;
  return {
   message: () => `expected attribute ${t} "${s}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toEqualAttributes: function toEqualAttributes$2(e, t) {
  if (!e) throw new Error("expect toEqualAttributes value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toEqualAttributes value is not an element");
  const s = Object.keys(t), r = s.every((s => {
   let r = t[s];
   return null != r && (r = String(r)), e.getAttribute(s) === r;
  }));
  return {
   message: () => `expected attributes to ${r ? "not " : ""}equal ${s.map((e => `[${e}="${t[e]}"]`)).join(", ")}`,
   pass: r
  };
 },
 toEqualHtml: function toEqualHtml$2(e, t) {
  return compareHtml$2(e, t, !0);
 },
 toEqualLightHtml: function toEqualLightHtml$2(e, t) {
  return compareHtml$2(e, t, !1);
 },
 toEqualText: function toEqualText$2(e, t) {
  var s;
  if (null == e) throw new Error(`expect toEqualText() value is "${e}"`);
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  let r;
  r = 1 === e.nodeType ? (null !== (s = e.textContent) && void 0 !== s ? s : "").replace(/\s\s+/g, " ").trim() : String(e).replace(/\s\s+/g, " ").trim(), 
  "string" == typeof t && (t = t.replace(/\s\s+/g, " ").trim());
  const i = r === t;
  return {
   message: () => `expected textContent "${t}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toHaveAttribute: function toHaveAttribute$2(e, t) {
  if (!e) throw new Error("expect toHaveAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveAttribute value is not an element");
  const s = e.hasAttribute(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have the attribute "${t}"`,
   pass: s
  };
 },
 toHaveClass: function toHaveClass$2(e, t) {
  if (!e) throw new Error("expect toHaveClass value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveClass value is not an element");
  const s = e.classList.contains(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have css class "${t}"`,
   pass: s
  };
 },
 toHaveClasses: toHaveClasses$2,
 toMatchClasses: function toMatchClasses$2(e, t) {
  let {pass: s} = toHaveClasses$2(e, t);
  return s && (s = t.length === e.classList.length), {
   message: () => `expected to ${s ? "not " : ""}match css classes "${t.join(" ")}", but className is "${e.className}"`,
   pass: s
  };
 },
 toHaveReceivedEvent: function toHaveReceivedEvent$2(e) {
  if (!e) throw new Error("toHaveReceivedEvent event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEvent did not receive an event spy");
  const t = e.events.length > 0;
  return {
   message: () => `expected to have ${t ? "not " : ""}called "${e.eventName}" event`,
   pass: t
  };
 },
 toHaveReceivedEventDetail: function toHaveReceivedEventDetail$2(e, t) {
  if (!e) throw new Error("toHaveReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventDetail did not receive an event spy");
  if (!e.lastEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual$2(e.lastEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveReceivedEventTimes: function toHaveReceivedEventTimes$2(e, t) {
  if (!e) throw new Error("toHaveReceivedEventTimes event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventTimes did not receive an event spy");
  return {
   message: () => `expected event "${e.eventName}" to have been called ${t} times, but was called ${e.events.length} time${e.events.length > 1 ? "s" : ""}`,
   pass: e.length === t
  };
 },
 toHaveFirstReceivedEventDetail: function toHaveFirstReceivedEventDetail$2(e, t) {
  if (!e) throw new Error("toHaveFirstReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveFirstReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual$2(e.firstEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveNthReceivedEventDetail: function toHaveNthReceivedEventDetail$2(e, t, s) {
  if (!e) throw new Error("toHaveNthReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveNthReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const r = e.events[t];
  if (!r) throw new Error(`event at index ${t} was not received`);
  const i = deepEqual$2(r.detail, s);
  return expect(r.detail).toEqual(s), {
   message: () => `expected event "${e.eventName}" detail to ${i ? "not " : ""}equal`,
   pass: i
  };
 },
 toMatchScreenshot: function toMatchScreenshot$2(e, t = {}) {
  if (!e) throw new Error("expect toMatchScreenshot value is null");
  if ("function" == typeof e.then) throw new Error("expect(compare).toMatchScreenshot() must be a resolved value, not a promise, before it can be tested");
  if ("number" != typeof e.mismatchedPixels) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'mismatchedPixels' has type '${typeof e.mismatchedPixels}', but should be a number`);
  if ("number" != typeof e.deviceScaleFactor) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'deviceScaleFactor' has type '${typeof e.deviceScaleFactor}', but should be a number`);
  const s = e.device || e.userAgent;
  if ("number" == typeof t.allowableMismatchedRatio) {
   if (t.allowableMismatchedRatio < 0 || t.allowableMismatchedRatio > 1) throw new Error("expect toMatchScreenshot() allowableMismatchedRatio must be a value ranging from 0 to 1");
   const r = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${r}" for "${e.desc}", but expected ratio to be less than "${t.allowableMismatchedRatio}"`,
    pass: r <= t.allowableMismatchedRatio
   };
  }
  if ("number" == typeof t.allowableMismatchedPixels) {
   if (t.allowableMismatchedPixels < 0) throw new Error("expect toMatchScreenshot() allowableMismatchedPixels value must be a value that is 0 or greater");
   return {
    message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${t.allowableMismatchedPixels}" mismatched pixels`,
    pass: e.mismatchedPixels <= t.allowableMismatchedPixels
   };
  }
  if ("number" == typeof e.allowableMismatchedRatio) {
   const t = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${t}" for "${e.desc}", but expected ratio to be less than "${e.allowableMismatchedRatio}"`,
    pass: t <= e.allowableMismatchedRatio
   };
  }
  if ("number" == typeof e.allowableMismatchedPixels) return {
   message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${e.allowableMismatchedPixels}" mismatched pixels`,
   pass: e.mismatchedPixels <= e.allowableMismatchedPixels
  };
  throw new Error("expect toMatchScreenshot() missing allowableMismatchedPixels in testing config");
 }
};

class Jest27Stencil {
 getJestCliRunner() {
  return runJest$2;
 }
 getRunJestScreenshot() {
  return runJestScreenshot$2;
 }
 getDefaultJestRunner() {
  return "jest-jasmine2";
 }
 getCreateJestPuppeteerEnvironment() {
  return createJestPuppeteerEnvironment$2;
 }
 getJestPreprocessor() {
  return jestPreprocessor$2;
 }
 getCreateJestTestRunner() {
  return createTestRunner$2;
 }
 getJestSetupTestFramework() {
  return jestSetupTestFramework$2;
 }
 getJestPreset() {
  return preset$2;
 }
}

let _tsCompilerOptions$1 = null, _tsCompilerOptionsKey$1 = null;

const jestPreprocessor$1 = {
 process(e, t, s) {
  const r = s.config;
  if (function i(e, t) {
   var s;
   const r = (null !== (s = e.split(".").pop()) && void 0 !== s ? s : "").toLowerCase().split("?")[0];
   if ("ts" === r || "tsx" === r || "jsx" === r) return !0;
   if ("mjs" === r) return !0;
   if ("js" === r) {
    if (t.includes("import ") || t.includes("import.") || t.includes("import(")) return !0;
    if (t.includes("export ")) return !0;
   }
   return "css" === r;
  }(t, e)) {
   const s = {
    file: t,
    currentDirectory: r.rootDir
   }, i = getCompilerOptions$1(r.rootDir);
   i && (i.baseUrl && (s.baseUrl = i.baseUrl), i.paths && (s.paths = i.paths));
   const n = transpile(e, s), o = n.diagnostics.some((e => "error" === e.level));
   if (n.diagnostics && o) {
    const e = n.diagnostics.map(formatDiagnostic$1).join("\n\n");
    throw new Error(e);
   }
   return {
    code: n.code
   };
  }
  return {
   code: e
  };
 },
 getCacheKey(e, t, s) {
  const r = s.config;
  if (!_tsCompilerOptionsKey$1) {
   const e = getCompilerOptions$1(r.rootDir);
   _tsCompilerOptionsKey$1 = JSON.stringify(e);
  }
  return [ process.version, _tsCompilerOptionsKey$1, e, t, s, !!s.instrument, 8 ].join(":");
 }
}, testingDir$1 = __dirname, rootDir$1 = path$6.join(testingDir$1, ".."), internalDir$1 = path$6.join(rootDir$1, "internal"), moduleExtensions$1 = [ "ts", "tsx", "js", "mjs", "jsx" ], moduleExtensionRegexp$1 = "(" + moduleExtensions$1.join("|") + ")", preset$1 = {
 moduleFileExtensions: [ ...moduleExtensions$1, "json", "d.ts" ],
 moduleNameMapper: {
  "^@stencil/core/cli$": path$6.join(rootDir$1, "cli", "index.js"),
  "^@stencil/core/compiler$": path$6.join(rootDir$1, "compiler", "stencil.js"),
  "^@stencil/core/internal$": path$6.join(internalDir$1, "testing", "index.js"),
  "^@stencil/core/internal/app-data$": path$6.join(internalDir$1, "app-data", "index.cjs"),
  "^@stencil/core/internal/app-globals$": path$6.join(internalDir$1, "app-globals", "index.js"),
  "^@stencil/core/internal/testing$": path$6.join(internalDir$1, "testing", "index.js"),
  "^@stencil/core/mock-doc$": path$6.join(rootDir$1, "mock-doc", "index.cjs"),
  "^@stencil/core/sys$": path$6.join(rootDir$1, "sys", "node", "index.js"),
  "^@stencil/core/testing$": path$6.join(testingDir$1, "index.js"),
  "^@stencil/core$": path$6.join(internalDir$1, "testing", "index.js")
 },
 setupFilesAfterEnv: [ path$6.join(testingDir$1, "jest-setuptestframework.js") ],
 testEnvironment: path$6.join(testingDir$1, "jest-environment.js"),
 testPathIgnorePatterns: [ "/.cache", "/.stencil", "/.vscode", "/dist", "/node_modules", "/www" ],
 testRegex: "(/__tests__/.*|\\.?(test|spec))\\." + moduleExtensionRegexp$1 + "$",
 transform: {
  "^.+\\.(ts|tsx|jsx|css|mjs)$": path$6.join(testingDir$1, "jest-preprocessor.js")
 },
 watchPathIgnorePatterns: [ "^.+\\.d\\.ts$" ]
}, HtmlSerializer$1 = {
 print: e => index_cjs.serializeNodeToHtml(e, {
  serializeShadowRoot: !0,
  prettyHtml: !0,
  outerHtml: !0
 }),
 test: e => null != e && (e instanceof HTMLElement || e instanceof index_cjs.MockNode)
}, deepEqual$1 = function e(t, s) {
 if (t === s) return !0;
 if (t && s && "object" == typeof t && "object" == typeof s) {
  const r = Array.isArray(t), i = Array.isArray(s);
  let n, o, a;
  if (r && i) {
   if (o = t.length, o != s.length) return !1;
   for (n = o; 0 != n--; ) if (!e(t[n], s[n])) return !1;
   return !0;
  }
  if (r != i) return !1;
  const l = t instanceof Date, c = s instanceof Date;
  if (l != c) return !1;
  if (l && c) return t.getTime() == s.getTime();
  const u = t instanceof RegExp, h = s instanceof RegExp;
  if (u != h) return !1;
  if (u && h) return t.toString() == s.toString();
  const p = Object.keys(t);
  if (o = p.length, o !== Object.keys(s).length) return !1;
  for (n = o; 0 != n--; ) if (!Object.prototype.hasOwnProperty.call(s, p[n])) return !1;
  for (n = o; 0 != n--; ) if (a = p[n], !e(t[a], s[a])) return !1;
  return !0;
 }
 return t != t && s != s;
}, expectExtend$1 = {
 toEqualAttribute: function toEqualAttribute$1(e, t, s) {
  if (!e) throw new Error("expect toMatchAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toMatchAttribute value is not an element");
  let r = e.getAttribute(t);
  null != s && (s = String(s)), null != r && (r = String(r));
  const i = s === r;
  return {
   message: () => `expected attribute ${t} "${s}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toEqualAttributes: function toEqualAttributes$1(e, t) {
  if (!e) throw new Error("expect toEqualAttributes value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toEqualAttributes value is not an element");
  const s = Object.keys(t), r = s.every((s => {
   let r = t[s];
   return null != r && (r = String(r)), e.getAttribute(s) === r;
  }));
  return {
   message: () => `expected attributes to ${r ? "not " : ""}equal ${s.map((e => `[${e}="${t[e]}"]`)).join(", ")}`,
   pass: r
  };
 },
 toEqualHtml: function toEqualHtml$1(e, t) {
  return compareHtml$1(e, t, !0);
 },
 toEqualLightHtml: function toEqualLightHtml$1(e, t) {
  return compareHtml$1(e, t, !1);
 },
 toEqualText: function toEqualText$1(e, t) {
  var s;
  if (null == e) throw new Error(`expect toEqualText() value is "${e}"`);
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  let r;
  r = 1 === e.nodeType ? (null !== (s = e.textContent) && void 0 !== s ? s : "").replace(/\s\s+/g, " ").trim() : String(e).replace(/\s\s+/g, " ").trim(), 
  "string" == typeof t && (t = t.replace(/\s\s+/g, " ").trim());
  const i = r === t;
  return {
   message: () => `expected textContent "${t}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toHaveAttribute: function toHaveAttribute$1(e, t) {
  if (!e) throw new Error("expect toHaveAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveAttribute value is not an element");
  const s = e.hasAttribute(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have the attribute "${t}"`,
   pass: s
  };
 },
 toHaveClass: function toHaveClass$1(e, t) {
  if (!e) throw new Error("expect toHaveClass value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveClass value is not an element");
  const s = e.classList.contains(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have css class "${t}"`,
   pass: s
  };
 },
 toHaveClasses: toHaveClasses$1,
 toMatchClasses: function toMatchClasses$1(e, t) {
  let {pass: s} = toHaveClasses$1(e, t);
  return s && (s = t.length === e.classList.length), {
   message: () => `expected to ${s ? "not " : ""}match css classes "${t.join(" ")}", but className is "${e.className}"`,
   pass: s
  };
 },
 toHaveReceivedEvent: function toHaveReceivedEvent$1(e) {
  if (!e) throw new Error("toHaveReceivedEvent event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEvent did not receive an event spy");
  const t = e.events.length > 0;
  return {
   message: () => `expected to have ${t ? "not " : ""}called "${e.eventName}" event`,
   pass: t
  };
 },
 toHaveReceivedEventDetail: function toHaveReceivedEventDetail$1(e, t) {
  if (!e) throw new Error("toHaveReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventDetail did not receive an event spy");
  if (!e.lastEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual$1(e.lastEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveReceivedEventTimes: function toHaveReceivedEventTimes$1(e, t) {
  if (!e) throw new Error("toHaveReceivedEventTimes event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventTimes did not receive an event spy");
  return {
   message: () => `expected event "${e.eventName}" to have been called ${t} times, but was called ${e.events.length} time${e.events.length > 1 ? "s" : ""}`,
   pass: e.length === t
  };
 },
 toHaveFirstReceivedEventDetail: function toHaveFirstReceivedEventDetail$1(e, t) {
  if (!e) throw new Error("toHaveFirstReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveFirstReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual$1(e.firstEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveNthReceivedEventDetail: function toHaveNthReceivedEventDetail$1(e, t, s) {
  if (!e) throw new Error("toHaveNthReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveNthReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const r = e.events[t];
  if (!r) throw new Error(`event at index ${t} was not received`);
  const i = deepEqual$1(r.detail, s);
  return expect(r.detail).toEqual(s), {
   message: () => `expected event "${e.eventName}" detail to ${i ? "not " : ""}equal`,
   pass: i
  };
 },
 toMatchScreenshot: function toMatchScreenshot$1(e, t = {}) {
  if (!e) throw new Error("expect toMatchScreenshot value is null");
  if ("function" == typeof e.then) throw new Error("expect(compare).toMatchScreenshot() must be a resolved value, not a promise, before it can be tested");
  if ("number" != typeof e.mismatchedPixels) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'mismatchedPixels' has type '${typeof e.mismatchedPixels}', but should be a number`);
  if ("number" != typeof e.deviceScaleFactor) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'deviceScaleFactor' has type '${typeof e.deviceScaleFactor}', but should be a number`);
  const s = e.device || e.userAgent;
  if ("number" == typeof t.allowableMismatchedRatio) {
   if (t.allowableMismatchedRatio < 0 || t.allowableMismatchedRatio > 1) throw new Error("expect toMatchScreenshot() allowableMismatchedRatio must be a value ranging from 0 to 1");
   const r = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${r}" for "${e.desc}", but expected ratio to be less than "${t.allowableMismatchedRatio}"`,
    pass: r <= t.allowableMismatchedRatio
   };
  }
  if ("number" == typeof t.allowableMismatchedPixels) {
   if (t.allowableMismatchedPixels < 0) throw new Error("expect toMatchScreenshot() allowableMismatchedPixels value must be a value that is 0 or greater");
   return {
    message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${t.allowableMismatchedPixels}" mismatched pixels`,
    pass: e.mismatchedPixels <= t.allowableMismatchedPixels
   };
  }
  if ("number" == typeof e.allowableMismatchedRatio) {
   const t = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${t}" for "${e.desc}", but expected ratio to be less than "${e.allowableMismatchedRatio}"`,
    pass: t <= e.allowableMismatchedRatio
   };
  }
  if ("number" == typeof e.allowableMismatchedPixels) return {
   message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${e.allowableMismatchedPixels}" mismatched pixels`,
   pass: e.mismatchedPixels <= e.allowableMismatchedPixels
  };
  throw new Error("expect toMatchScreenshot() missing allowableMismatchedPixels in testing config");
 }
};

class Jest28Stencil {
 getJestCliRunner() {
  return runJest$1;
 }
 getRunJestScreenshot() {
  return runJestScreenshot$1;
 }
 getDefaultJestRunner() {
  return "jest-circus";
 }
 getCreateJestPuppeteerEnvironment() {
  return createJestPuppeteerEnvironment$1;
 }
 getJestPreprocessor() {
  return jestPreprocessor$1;
 }
 getCreateJestTestRunner() {
  return createTestRunner$1;
 }
 getJestSetupTestFramework() {
  return jestSetupTestFramework$1;
 }
 getJestPreset() {
  return preset$1;
 }
}

let _tsCompilerOptions = null, _tsCompilerOptionsKey = null;

const jestPreprocessor = {
 process(e, t, s) {
  const r = s.config;
  if (function i(e, t) {
   var s;
   const r = (null !== (s = e.split(".").pop()) && void 0 !== s ? s : "").toLowerCase().split("?")[0];
   if ("ts" === r || "tsx" === r || "jsx" === r) return !0;
   if ("mjs" === r) return !0;
   if ("js" === r) {
    if (t.includes("import ") || t.includes("import.") || t.includes("import(")) return !0;
    if (t.includes("export ")) return !0;
   }
   return "css" === r;
  }(t, e)) {
   const s = {
    file: t,
    currentDirectory: r.rootDir
   }, i = getCompilerOptions(r.rootDir);
   i && (i.baseUrl && (s.baseUrl = i.baseUrl), i.paths && (s.paths = i.paths));
   const n = transpile(e, s), o = n.diagnostics.some((e => "error" === e.level));
   if (n.diagnostics && o) {
    const e = n.diagnostics.map(formatDiagnostic).join("\n\n");
    throw new Error(e);
   }
   return {
    code: n.code
   };
  }
  return {
   code: e
  };
 },
 getCacheKey(e, t, s) {
  const r = s.config;
  if (!_tsCompilerOptionsKey) {
   const e = getCompilerOptions(r.rootDir);
   _tsCompilerOptionsKey = JSON.stringify(e);
  }
  return [ process.version, _tsCompilerOptionsKey, e, t, s, !!s.instrument, 9 ].join(":");
 }
}, testingDir = __dirname, rootDir = path$6.join(testingDir, ".."), internalDir = path$6.join(rootDir, "internal"), moduleExtensions = [ "ts", "tsx", "js", "mjs", "jsx" ], moduleExtensionRegexp = "(" + moduleExtensions.join("|") + ")", preset = {
 moduleFileExtensions: [ ...moduleExtensions, "json", "d.ts" ],
 moduleNameMapper: {
  "^@stencil/core/cli$": path$6.join(rootDir, "cli", "index.js"),
  "^@stencil/core/compiler$": path$6.join(rootDir, "compiler", "stencil.js"),
  "^@stencil/core/internal$": path$6.join(internalDir, "testing", "index.js"),
  "^@stencil/core/internal/app-data$": path$6.join(internalDir, "app-data", "index.cjs"),
  "^@stencil/core/internal/app-globals$": path$6.join(internalDir, "app-globals", "index.js"),
  "^@stencil/core/internal/testing$": path$6.join(internalDir, "testing", "index.js"),
  "^@stencil/core/mock-doc$": path$6.join(rootDir, "mock-doc", "index.cjs"),
  "^@stencil/core/sys$": path$6.join(rootDir, "sys", "node", "index.js"),
  "^@stencil/core/testing$": path$6.join(testingDir, "index.js"),
  "^@stencil/core$": path$6.join(internalDir, "testing", "index.js")
 },
 setupFilesAfterEnv: [ path$6.join(testingDir, "jest-setuptestframework.js") ],
 testEnvironment: path$6.join(testingDir, "jest-environment.js"),
 testPathIgnorePatterns: [ "/.cache", "/.stencil", "/.vscode", "/dist", "/node_modules", "/www" ],
 testRegex: "(/__tests__/.*|\\.?(test|spec))\\." + moduleExtensionRegexp + "$",
 transform: {
  "^.+\\.(ts|tsx|jsx|css|mjs)$": path$6.join(testingDir, "jest-preprocessor.js")
 },
 watchPathIgnorePatterns: [ "^.+\\.d\\.ts$" ]
}, HtmlSerializer = {
 print: e => index_cjs.serializeNodeToHtml(e, {
  serializeShadowRoot: !0,
  prettyHtml: !0,
  outerHtml: !0
 }),
 test: e => null != e && (e instanceof HTMLElement || e instanceof index_cjs.MockNode)
}, deepEqual = function e(t, s) {
 if (t === s) return !0;
 if (t && s && "object" == typeof t && "object" == typeof s) {
  const r = Array.isArray(t), i = Array.isArray(s);
  let n, o, a;
  if (r && i) {
   if (o = t.length, o != s.length) return !1;
   for (n = o; 0 != n--; ) if (!e(t[n], s[n])) return !1;
   return !0;
  }
  if (r != i) return !1;
  const l = t instanceof Date, c = s instanceof Date;
  if (l != c) return !1;
  if (l && c) return t.getTime() == s.getTime();
  const u = t instanceof RegExp, h = s instanceof RegExp;
  if (u != h) return !1;
  if (u && h) return t.toString() == s.toString();
  const p = Object.keys(t);
  if (o = p.length, o !== Object.keys(s).length) return !1;
  for (n = o; 0 != n--; ) if (!Object.prototype.hasOwnProperty.call(s, p[n])) return !1;
  for (n = o; 0 != n--; ) if (a = p[n], !e(t[a], s[a])) return !1;
  return !0;
 }
 return t != t && s != s;
}, expectExtend = {
 toEqualAttribute: function toEqualAttribute(e, t, s) {
  if (!e) throw new Error("expect toMatchAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toMatchAttribute value is not an element");
  let r = e.getAttribute(t);
  null != s && (s = String(s)), null != r && (r = String(r));
  const i = s === r;
  return {
   message: () => `expected attribute ${t} "${s}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toEqualAttributes: function toEqualAttributes(e, t) {
  if (!e) throw new Error("expect toEqualAttributes value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toEqualAttributes value is not an element");
  const s = Object.keys(t), r = s.every((s => {
   let r = t[s];
   return null != r && (r = String(r)), e.getAttribute(s) === r;
  }));
  return {
   message: () => `expected attributes to ${r ? "not " : ""}equal ${s.map((e => `[${e}="${t[e]}"]`)).join(", ")}`,
   pass: r
  };
 },
 toEqualHtml: function toEqualHtml(e, t) {
  return compareHtml(e, t, !0);
 },
 toEqualLightHtml: function toEqualLightHtml(e, t) {
  return compareHtml(e, t, !1);
 },
 toEqualText: function toEqualText(e, t) {
  var s;
  if (null == e) throw new Error(`expect toEqualText() value is "${e}"`);
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  let r;
  r = 1 === e.nodeType ? (null !== (s = e.textContent) && void 0 !== s ? s : "").replace(/\s\s+/g, " ").trim() : String(e).replace(/\s\s+/g, " ").trim(), 
  "string" == typeof t && (t = t.replace(/\s\s+/g, " ").trim());
  const i = r === t;
  return {
   message: () => `expected textContent "${t}" to ${i ? "not " : ""}equal "${r}"`,
   pass: i
  };
 },
 toHaveAttribute: function toHaveAttribute(e, t) {
  if (!e) throw new Error("expect toHaveAttribute value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveAttribute value is not an element");
  const s = e.hasAttribute(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have the attribute "${t}"`,
   pass: s
  };
 },
 toHaveClass: function toHaveClass(e, t) {
  if (!e) throw new Error("expect toHaveClass value is null");
  if ("function" == typeof e.then) throw new Error("element must be a resolved value, not a promise, before it can be tested");
  if (1 !== e.nodeType) throw new Error("expect toHaveClass value is not an element");
  const s = e.classList.contains(t);
  return {
   message: () => `expected to ${s ? "not " : ""}have css class "${t}"`,
   pass: s
  };
 },
 toHaveClasses,
 toMatchClasses: function toMatchClasses(e, t) {
  let {pass: s} = toHaveClasses(e, t);
  return s && (s = t.length === e.classList.length), {
   message: () => `expected to ${s ? "not " : ""}match css classes "${t.join(" ")}", but className is "${e.className}"`,
   pass: s
  };
 },
 toHaveReceivedEvent: function toHaveReceivedEvent(e) {
  if (!e) throw new Error("toHaveReceivedEvent event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEvent did not receive an event spy");
  const t = e.events.length > 0;
  return {
   message: () => `expected to have ${t ? "not " : ""}called "${e.eventName}" event`,
   pass: t
  };
 },
 toHaveReceivedEventDetail: function toHaveReceivedEventDetail(e, t) {
  if (!e) throw new Error("toHaveReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventDetail did not receive an event spy");
  if (!e.lastEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual(e.lastEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveReceivedEventTimes: function toHaveReceivedEventTimes(e, t) {
  if (!e) throw new Error("toHaveReceivedEventTimes event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveReceivedEventTimes did not receive an event spy");
  return {
   message: () => `expected event "${e.eventName}" to have been called ${t} times, but was called ${e.events.length} time${e.events.length > 1 ? "s" : ""}`,
   pass: e.length === t
  };
 },
 toHaveFirstReceivedEventDetail: function toHaveFirstReceivedEventDetail(e, t) {
  if (!e) throw new Error("toHaveFirstReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveFirstReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const s = deepEqual(e.firstEvent.detail, t);
  return expect(e.lastEvent.detail).toEqual(t), {
   message: () => `expected event "${e.eventName}" detail to ${s ? "not " : ""}equal`,
   pass: s
  };
 },
 toHaveNthReceivedEventDetail: function toHaveNthReceivedEventDetail(e, t, s) {
  if (!e) throw new Error("toHaveNthReceivedEventDetail event spy is null");
  if ("function" == typeof e.then) throw new Error("event spy must be a resolved value, not a promise, before it can be tested");
  if (!e.eventName) throw new Error("toHaveNthReceivedEventDetail did not receive an event spy");
  if (!e.firstEvent) throw new Error(`event "${e.eventName}" was not received`);
  const r = e.events[t];
  if (!r) throw new Error(`event at index ${t} was not received`);
  const i = deepEqual(r.detail, s);
  return expect(r.detail).toEqual(s), {
   message: () => `expected event "${e.eventName}" detail to ${i ? "not " : ""}equal`,
   pass: i
  };
 },
 toMatchScreenshot: function toMatchScreenshot(e, t = {}) {
  if (!e) throw new Error("expect toMatchScreenshot value is null");
  if ("function" == typeof e.then) throw new Error("expect(compare).toMatchScreenshot() must be a resolved value, not a promise, before it can be tested");
  if ("number" != typeof e.mismatchedPixels) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'mismatchedPixels' has type '${typeof e.mismatchedPixels}', but should be a number`);
  if ("number" != typeof e.deviceScaleFactor) throw new Error(`expect toMatchScreenshot() value is not a valid screenshot compare object - 'deviceScaleFactor' has type '${typeof e.deviceScaleFactor}', but should be a number`);
  const s = e.device || e.userAgent;
  if ("number" == typeof t.allowableMismatchedRatio) {
   if (t.allowableMismatchedRatio < 0 || t.allowableMismatchedRatio > 1) throw new Error("expect toMatchScreenshot() allowableMismatchedRatio must be a value ranging from 0 to 1");
   const r = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${r}" for "${e.desc}", but expected ratio to be less than "${t.allowableMismatchedRatio}"`,
    pass: r <= t.allowableMismatchedRatio
   };
  }
  if ("number" == typeof t.allowableMismatchedPixels) {
   if (t.allowableMismatchedPixels < 0) throw new Error("expect toMatchScreenshot() allowableMismatchedPixels value must be a value that is 0 or greater");
   return {
    message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${t.allowableMismatchedPixels}" mismatched pixels`,
    pass: e.mismatchedPixels <= t.allowableMismatchedPixels
   };
  }
  if ("number" == typeof e.allowableMismatchedRatio) {
   const t = e.mismatchedPixels / (e.width * e.deviceScaleFactor * (e.height * e.deviceScaleFactor));
   return {
    message: () => `${s}: screenshot has a mismatch ratio of "${t}" for "${e.desc}", but expected ratio to be less than "${e.allowableMismatchedRatio}"`,
    pass: t <= e.allowableMismatchedRatio
   };
  }
  if ("number" == typeof e.allowableMismatchedPixels) return {
   message: () => `${s}: screenshot has "${e.mismatchedPixels}" mismatched pixels for "${e.desc}", but expected less than "${e.allowableMismatchedPixels}" mismatched pixels`,
   pass: e.mismatchedPixels <= e.allowableMismatchedPixels
  };
  throw new Error("expect toMatchScreenshot() missing allowableMismatchedPixels in testing config");
 }
};

class Jest29Stencil {
 getJestCliRunner() {
  return runJest;
 }
 getRunJestScreenshot() {
  return runJestScreenshot;
 }
 getDefaultJestRunner() {
  return "jest-circus";
 }
 getCreateJestPuppeteerEnvironment() {
  return createJestPuppeteerEnvironment;
 }
 getJestPreprocessor() {
  return jestPreprocessor;
 }
 getCreateJestTestRunner() {
  return createTestRunner;
 }
 getJestSetupTestFramework() {
  return jestSetupTestFramework;
 }
 getJestPreset() {
  return preset;
 }
}

let JEST_STENCIL_FACADE = null;

const getJestFacade = () => {
 if (!JEST_STENCIL_FACADE) {
  const e = major$1(jest$1.getVersion());
  JEST_STENCIL_FACADE = e <= 27 ? new Jest27Stencil : 28 === e ? new Jest28Stencil : 29 === e ? new Jest29Stencil : new Jest27Stencil;
 }
 return JEST_STENCIL_FACADE;
}, createConfigFlags = (e = {}) => ({
 task: null,
 args: [],
 knownArgs: [],
 unknownArgs: [],
 ...e
});

constants$2 = require$$0__default.default, origCwd = process.cwd, cwd = null, platform = process.env.GRACEFUL_FS_PLATFORM || process.platform, 
process.cwd = function() {
 return cwd || (cwd = origCwd.call(process)), cwd;
};

try {
 process.cwd();
} catch (e) {}

"function" == typeof process.chdir && (chdir = process.chdir, process.chdir = function(e) {
 cwd = null, chdir.call(process, e);
}, Object.setPrototypeOf && Object.setPrototypeOf(process.chdir, chdir)), polyfills$1 = function patch$1(e) {
 function t(t) {
  return t ? function(s, r, i) {
   return t.call(e, s, r, (function(e) {
    a(e) && (e = null), i && i.apply(this, arguments);
   }));
  } : t;
 }
 function s(t) {
  return t ? function(s, r) {
   try {
    return t.call(e, s, r);
   } catch (e) {
    if (!a(e)) throw e;
   }
  } : t;
 }
 function r(t) {
  return t ? function(s, r, i, n) {
   return t.call(e, s, r, i, (function(e) {
    a(e) && (e = null), n && n.apply(this, arguments);
   }));
  } : t;
 }
 function i(t) {
  return t ? function(s, r, i) {
   try {
    return t.call(e, s, r, i);
   } catch (e) {
    if (!a(e)) throw e;
   }
  } : t;
 }
 function n(t) {
  return t ? function(s, r, i) {
   function n(e, t) {
    t && (t.uid < 0 && (t.uid += 4294967296), t.gid < 0 && (t.gid += 4294967296)), i && i.apply(this, arguments);
   }
   return "function" == typeof r && (i = r, r = null), r ? t.call(e, s, r, n) : t.call(e, s, n);
  } : t;
 }
 function o(t) {
  return t ? function(s, r) {
   var i = r ? t.call(e, s, r) : t.call(e, s);
   return i && (i.uid < 0 && (i.uid += 4294967296), i.gid < 0 && (i.gid += 4294967296)), 
   i;
  } : t;
 }
 function a(e) {
  return !e || "ENOSYS" === e.code || !(process.getuid && 0 === process.getuid() || "EINVAL" !== e.code && "EPERM" !== e.code);
 }
 var l;
 constants$2.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./) && function c(e) {
  e.lchmod = function(t, s, r) {
   e.open(t, constants$2.O_WRONLY | constants$2.O_SYMLINK, s, (function(t, i) {
    t ? r && r(t) : e.fchmod(i, s, (function(t) {
     e.close(i, (function(e) {
      r && r(t || e);
     }));
    }));
   }));
  }, e.lchmodSync = function(t, s) {
   var r, i = e.openSync(t, constants$2.O_WRONLY | constants$2.O_SYMLINK, s), n = !0;
   try {
    r = e.fchmodSync(i, s), n = !1;
   } finally {
    if (n) try {
     e.closeSync(i);
    } catch (e) {} else e.closeSync(i);
   }
   return r;
  };
 }(e), e.lutimes || function u(e) {
  constants$2.hasOwnProperty("O_SYMLINK") && e.futimes ? (e.lutimes = function(t, s, r, i) {
   e.open(t, constants$2.O_SYMLINK, (function(t, n) {
    t ? i && i(t) : e.futimes(n, s, r, (function(t) {
     e.close(n, (function(e) {
      i && i(t || e);
     }));
    }));
   }));
  }, e.lutimesSync = function(t, s, r) {
   var i, n = e.openSync(t, constants$2.O_SYMLINK), o = !0;
   try {
    i = e.futimesSync(n, s, r), o = !1;
   } finally {
    if (o) try {
     e.closeSync(n);
    } catch (e) {} else e.closeSync(n);
   }
   return i;
  }) : e.futimes && (e.lutimes = function(e, t, s, r) {
   r && process.nextTick(r);
  }, e.lutimesSync = function() {});
 }(e), e.chown = r(e.chown), e.fchown = r(e.fchown), e.lchown = r(e.lchown), e.chmod = t(e.chmod), 
 e.fchmod = t(e.fchmod), e.lchmod = t(e.lchmod), e.chownSync = i(e.chownSync), e.fchownSync = i(e.fchownSync), 
 e.lchownSync = i(e.lchownSync), e.chmodSync = s(e.chmodSync), e.fchmodSync = s(e.fchmodSync), 
 e.lchmodSync = s(e.lchmodSync), e.stat = n(e.stat), e.fstat = n(e.fstat), e.lstat = n(e.lstat), 
 e.statSync = o(e.statSync), e.fstatSync = o(e.fstatSync), e.lstatSync = o(e.lstatSync), 
 e.chmod && !e.lchmod && (e.lchmod = function(e, t, s) {
  s && process.nextTick(s);
 }, e.lchmodSync = function() {}), e.chown && !e.lchown && (e.lchown = function(e, t, s, r) {
  r && process.nextTick(r);
 }, e.lchownSync = function() {}), "win32" === platform && (e.rename = "function" != typeof e.rename ? e.rename : function(t) {
  function s(s, r, i) {
   var n = Date.now(), o = 0;
   t(s, r, (function a(l) {
    if (l && ("EACCES" === l.code || "EPERM" === l.code || "EBUSY" === l.code) && Date.now() - n < 6e4) return setTimeout((function() {
     e.stat(r, (function(e, n) {
      e && "ENOENT" === e.code ? t(s, r, a) : i(l);
     }));
    }), o), void (o < 100 && (o += 10));
    i && i(l);
   }));
  }
  return Object.setPrototypeOf && Object.setPrototypeOf(s, t), s;
 }(e.rename)), e.read = "function" != typeof e.read ? e.read : function(t) {
  function s(s, r, i, n, o, a) {
   var l, c;
   return a && "function" == typeof a && (c = 0, l = function(u, h, p) {
    if (u && "EAGAIN" === u.code && c < 10) return c++, t.call(e, s, r, i, n, o, l);
    a.apply(this, arguments);
   }), t.call(e, s, r, i, n, o, l);
  }
  return Object.setPrototypeOf && Object.setPrototypeOf(s, t), s;
 }(e.read), e.readSync = "function" != typeof e.readSync ? e.readSync : (l = e.readSync, 
 function(t, s, r, i, n) {
  for (var o = 0; ;) try {
   return l.call(e, t, s, r, i, n);
  } catch (e) {
   if ("EAGAIN" === e.code && o < 10) {
    o++;
    continue;
   }
   throw e;
  }
 });
}, Stream = require$$0__default$1.default.Stream, legacyStreams = function legacy$1(e) {
 return {
  ReadStream: function t(s, r) {
   var i, n, o, a, l;
   if (!(this instanceof t)) return new t(s, r);
   for (Stream.call(this), i = this, this.path = s, this.fd = null, this.readable = !0, 
   this.paused = !1, this.flags = "r", this.mode = 438, this.bufferSize = 65536, r = r || {}, 
   o = 0, a = (n = Object.keys(r)).length; o < a; o++) this[l = n[o]] = r[l];
   if (this.encoding && this.setEncoding(this.encoding), void 0 !== this.start) {
    if ("number" != typeof this.start) throw TypeError("start must be a Number");
    if (void 0 === this.end) this.end = 1 / 0; else if ("number" != typeof this.end) throw TypeError("end must be a Number");
    if (this.start > this.end) throw new Error("start must be <= end");
    this.pos = this.start;
   }
   null === this.fd ? e.open(this.path, this.flags, this.mode, (function(e, t) {
    if (e) return i.emit("error", e), void (i.readable = !1);
    i.fd = t, i.emit("open", t), i._read();
   })) : process.nextTick((function() {
    i._read();
   }));
  },
  WriteStream: function t(s, r) {
   var i, n, o, a;
   if (!(this instanceof t)) return new t(s, r);
   for (Stream.call(this), this.path = s, this.fd = null, this.writable = !0, this.flags = "w", 
   this.encoding = "binary", this.mode = 438, this.bytesWritten = 0, r = r || {}, n = 0, 
   o = (i = Object.keys(r)).length; n < o; n++) this[a = i[n]] = r[a];
   if (void 0 !== this.start) {
    if ("number" != typeof this.start) throw TypeError("start must be a Number");
    if (this.start < 0) throw new Error("start must be >= zero");
    this.pos = this.start;
   }
   this.busy = !1, this._queue = [], null === this.fd && (this._open = e.open, this._queue.push([ this._open, this.path, this.flags, this.mode, void 0 ]), 
   this.flush());
  }
 };
}, clone_1 = function clone$1(e) {
 var t;
 return null === e || "object" != typeof e ? e : (t = e instanceof Object ? {
  __proto__: getPrototypeOf(e)
 } : Object.create(null), Object.getOwnPropertyNames(e).forEach((function(s) {
  Object.defineProperty(t, s, Object.getOwnPropertyDescriptor(e, s));
 })), t);
}, getPrototypeOf = Object.getPrototypeOf || function(e) {
 return e.__proto__;
}, fs$4 = fs__default.default, polyfills = polyfills$1, legacy = legacyStreams, 
clone = clone_1, util$2 = require$$4__default.default, "function" == typeof Symbol && "function" == typeof Symbol.for ? (gracefulQueue = Symbol.for("graceful-fs.queue"), 
previousSymbol = Symbol.for("graceful-fs.previous")) : (gracefulQueue = "___graceful-fs.queue", 
previousSymbol = "___graceful-fs.previous"), debug$2 = function noop() {}, util$2.debuglog ? debug$2 = util$2.debuglog("gfs4") : /\bgfs4\b/i.test("") && (debug$2 = function() {
 var e = util$2.format.apply(util$2, arguments);
 e = "GFS4: " + e.split(/\n/).join("\nGFS4: "), console.error(e);
}), fs$4[gracefulQueue] || (queue = commonjsGlobal[gracefulQueue] || [], publishQueue(fs$4, queue), 
fs$4.close = function(e) {
 function t(t, s) {
  return e.call(fs$4, t, (function(e) {
   e || resetQueue(), "function" == typeof s && s.apply(this, arguments);
  }));
 }
 return Object.defineProperty(t, previousSymbol, {
  value: e
 }), t;
}(fs$4.close), fs$4.closeSync = function(e) {
 function t(t) {
  e.apply(fs$4, arguments), resetQueue();
 }
 return Object.defineProperty(t, previousSymbol, {
  value: e
 }), t;
}(fs$4.closeSync), /\bgfs4\b/i.test("") && process.on("exit", (function() {
 debug$2(fs$4[gracefulQueue]), require$$5__default.default.equal(fs$4[gracefulQueue].length, 0);
}))), commonjsGlobal[gracefulQueue] || publishQueue(commonjsGlobal, fs$4[gracefulQueue]), 
gracefulFs = patch(clone(fs$4)), process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs$4.__patched && (gracefulFs = patch(fs$4), 
fs$4.__patched = !0);

const fs$5 = gracefulFs;

ansiColors = {
 exports: {}
}, function(e) {
 const t = "undefined" != typeof process && "Hyper" === process.env.TERM_PROGRAM, s = "undefined" != typeof process && "win32" === process.platform, r = "undefined" != typeof process && "linux" === process.platform, i = {
  ballotDisabled: "☒",
  ballotOff: "☐",
  ballotOn: "☑",
  bullet: "•",
  bulletWhite: "◦",
  fullBlock: "█",
  heart: "❤",
  identicalTo: "≡",
  line: "─",
  mark: "※",
  middot: "·",
  minus: "－",
  multiplication: "×",
  obelus: "÷",
  pencilDownRight: "✎",
  pencilRight: "✏",
  pencilUpRight: "✐",
  percent: "%",
  pilcrow2: "❡",
  pilcrow: "¶",
  plusMinus: "±",
  question: "?",
  section: "§",
  starsOff: "☆",
  starsOn: "★",
  upDownArrow: "↕"
 }, n = Object.assign({}, i, {
  check: "√",
  cross: "×",
  ellipsisLarge: "...",
  ellipsis: "...",
  info: "i",
  questionSmall: "?",
  pointer: ">",
  pointerSmall: "»",
  radioOff: "( )",
  radioOn: "(*)",
  warning: "‼"
 }), o = Object.assign({}, i, {
  ballotCross: "✘",
  check: "✔",
  cross: "✖",
  ellipsisLarge: "⋯",
  ellipsis: "…",
  info: "ℹ",
  questionFull: "？",
  questionSmall: "﹖",
  pointer: r ? "▸" : "❯",
  pointerSmall: r ? "‣" : "›",
  radioOff: "◯",
  radioOn: "◉",
  warning: "⚠"
 });
 e.exports = s && !t ? n : o, Reflect.defineProperty(e.exports, "common", {
  enumerable: !1,
  value: i
 }), Reflect.defineProperty(e.exports, "windows", {
  enumerable: !1,
  value: n
 }), Reflect.defineProperty(e.exports, "other", {
  enumerable: !1,
  value: o
 });
}(symbols = {
 exports: {}
});

const ANSI_REGEX = /[\u001b\u009b][[\]#;?()]*(?:(?:(?:[^\W_]*;?[^\W_]*)\u0007)|(?:(?:[0-9]{1,4}(;[0-9]{0,4})*)?[~0-9=<>cf-nqrtyA-PRZ]))/g, create = () => {
 const e = {
  enabled: "undefined" != typeof process && "0" !== process.env.FORCE_COLOR,
  visible: !0,
  styles: {},
  keys: {}
 }, t = (e, t, s) => "function" == typeof e ? e(t) : e.wrap(t, s), s = (s, r) => {
  if ("" === s || null == s) return "";
  if (!1 === e.enabled) return s;
  if (!1 === e.visible) return "";
  let i = "" + s, n = i.includes("\n"), o = r.length;
  for (o > 0 && r.includes("unstyle") && (r = [ ...new Set([ "unstyle", ...r ]) ].reverse()); o-- > 0; ) i = t(e.styles[r[o]], i, n);
  return i;
 }, r = (t, r, i) => {
  e.styles[t] = (e => {
   let t = e.open = `[${e.codes[0]}m`, s = e.close = `[${e.codes[1]}m`, r = e.regex = new RegExp(`\\u001b\\[${e.codes[1]}m`, "g");
   return e.wrap = (e, i) => {
    e.includes(s) && (e = e.replace(r, s + t));
    let n = t + e + s;
    return i ? n.replace(/\r*\n/g, `${s}$&${t}`) : n;
   }, e;
  })({
   name: t,
   codes: r
  }), (e.keys[i] || (e.keys[i] = [])).push(t), Reflect.defineProperty(e, t, {
   configurable: !0,
   enumerable: !0,
   set(s) {
    e.alias(t, s);
   },
   get() {
    let r = e => s(e, r.stack);
    return Reflect.setPrototypeOf(r, e), r.stack = this.stack ? this.stack.concat(t) : [ t ], 
    r;
   }
  });
 };
 return r("reset", [ 0, 0 ], "modifier"), r("bold", [ 1, 22 ], "modifier"), r("dim", [ 2, 22 ], "modifier"), 
 r("italic", [ 3, 23 ], "modifier"), r("underline", [ 4, 24 ], "modifier"), r("inverse", [ 7, 27 ], "modifier"), 
 r("hidden", [ 8, 28 ], "modifier"), r("strikethrough", [ 9, 29 ], "modifier"), r("black", [ 30, 39 ], "color"), 
 r("red", [ 31, 39 ], "color"), r("green", [ 32, 39 ], "color"), r("yellow", [ 33, 39 ], "color"), 
 r("blue", [ 34, 39 ], "color"), r("magenta", [ 35, 39 ], "color"), r("cyan", [ 36, 39 ], "color"), 
 r("white", [ 37, 39 ], "color"), r("gray", [ 90, 39 ], "color"), r("grey", [ 90, 39 ], "color"), 
 r("bgBlack", [ 40, 49 ], "bg"), r("bgRed", [ 41, 49 ], "bg"), r("bgGreen", [ 42, 49 ], "bg"), 
 r("bgYellow", [ 43, 49 ], "bg"), r("bgBlue", [ 44, 49 ], "bg"), r("bgMagenta", [ 45, 49 ], "bg"), 
 r("bgCyan", [ 46, 49 ], "bg"), r("bgWhite", [ 47, 49 ], "bg"), r("blackBright", [ 90, 39 ], "bright"), 
 r("redBright", [ 91, 39 ], "bright"), r("greenBright", [ 92, 39 ], "bright"), r("yellowBright", [ 93, 39 ], "bright"), 
 r("blueBright", [ 94, 39 ], "bright"), r("magentaBright", [ 95, 39 ], "bright"), 
 r("cyanBright", [ 96, 39 ], "bright"), r("whiteBright", [ 97, 39 ], "bright"), r("bgBlackBright", [ 100, 49 ], "bgBright"), 
 r("bgRedBright", [ 101, 49 ], "bgBright"), r("bgGreenBright", [ 102, 49 ], "bgBright"), 
 r("bgYellowBright", [ 103, 49 ], "bgBright"), r("bgBlueBright", [ 104, 49 ], "bgBright"), 
 r("bgMagentaBright", [ 105, 49 ], "bgBright"), r("bgCyanBright", [ 106, 49 ], "bgBright"), 
 r("bgWhiteBright", [ 107, 49 ], "bgBright"), e.ansiRegex = ANSI_REGEX, e.hasColor = e.hasAnsi = t => (e.ansiRegex.lastIndex = 0, 
 "string" == typeof t && "" !== t && e.ansiRegex.test(t)), e.alias = (t, r) => {
  let i = "string" == typeof r ? e[r] : r;
  if ("function" != typeof i) throw new TypeError("Expected alias to be the name of an existing color (string) or a function");
  i.stack || (Reflect.defineProperty(i, "name", {
   value: t
  }), e.styles[t] = i, i.stack = [ t ]), Reflect.defineProperty(e, t, {
   configurable: !0,
   enumerable: !0,
   set(s) {
    e.alias(t, s);
   },
   get() {
    let t = e => s(e, t.stack);
    return Reflect.setPrototypeOf(t, e), t.stack = this.stack ? this.stack.concat(i.stack) : i.stack, 
    t;
   }
  });
 }, e.theme = t => {
  if (null === (s = t) || "object" != typeof s || Array.isArray(s)) throw new TypeError("Expected theme to be an object");
  var s;
  for (let s of Object.keys(t)) e.alias(s, t[s]);
  return e;
 }, e.alias("unstyle", (t => "string" == typeof t && "" !== t ? (e.ansiRegex.lastIndex = 0, 
 t.replace(e.ansiRegex, "")) : "")), e.alias("noop", (e => e)), e.none = e.clear = e.noop, 
 e.stripColor = e.unstyle, e.symbols = symbols.exports, e.define = r, e;
};

ansiColors.exports = create(), ansiColors.exports.create = create;

const ansiColor = ansiColors.exports, LOG_LEVELS = [ "debug", "info", "warn", "error" ], CustomElementsExportBehaviorOptions = [ "default", "auto-define-custom-elements", "bundle", "single-export-module" ], createTerminalLogger = e => {
 let t = "info", s = null;
 const r = [], i = e => {
  if (e.length > 0) {
   const t = formatPrefixTimestamp();
   e[0] = ansiColors.exports.dim(t) + e[0].slice(t.length);
  }
 }, n = e => {
  if (e.length) {
   const t = "[ WARN  ]";
   e[0] = ansiColors.exports.bold(ansiColors.exports.yellow(t)) + e[0].slice(t.length);
  }
 }, o = e => {
  if (e.length) {
   const t = "[ ERROR ]";
   e[0] = ansiColors.exports.bold(ansiColors.exports.red(t)) + e[0].slice(t.length);
  }
 }, a = e => {
  if (e.length) {
   const t = formatPrefixTimestamp();
   e[0] = ansiColors.exports.cyan(t) + e[0].slice(t.length);
  }
 }, l = t => {
  const s = e.memoryUsage();
  s > 0 && t.push(ansiColors.exports.dim(` MEM: ${(s / 1e6).toFixed(1)}MB`));
 }, c = (t, i) => {
  if (s) {
   const s = new Date, n = ("0" + s.getHours()).slice(-2) + ":" + ("0" + s.getMinutes()).slice(-2) + ":" + ("0" + s.getSeconds()).slice(-2) + ".0" + Math.floor(s.getMilliseconds() / 1e3 * 10) + "  " + ("000" + (e.memoryUsage() / 1e6).toFixed(1)).slice(-6) + "MB  " + t + "  " + i.join(", ");
   r.push(n);
  }
 }, u = (t, s, r) => {
  let i = t.length - s + r - 1;
  for (;t.length + INDENT$1.length > e.getColumns(); ) if (s > t.length - s + r && s > 5) t = t.slice(1), 
  s--; else {
   if (!(i > 1)) break;
   t = t.slice(0, -1), i--;
  }
  const n = [], o = Math.max(t.length, s + r);
  for (let e = 0; e < o; e++) {
   let i = t.charAt(e);
   e >= s && e < s + r && (i = ansiColors.exports.bgRed("" === i ? " " : i)), n.push(i);
  }
  return n.join("");
 }, h = e => e.trim().startsWith("//") ? ansiColors.exports.dim(e) : e.split(" ").map((e => JS_KEYWORDS.indexOf(e) > -1 ? ansiColors.exports.cyan(e) : e)).join(" "), p = e => {
  let t = !0;
  const s = [];
  for (let r = 0; r < e.length; r++) {
   const i = e.charAt(r);
   ";" === i || "{" === i ? t = !0 : ".#,:}@$[]/*".indexOf(i) > -1 && (t = !1), t && "abcdefghijklmnopqrstuvwxyz-_".indexOf(i.toLowerCase()) > -1 ? s.push(ansiColors.exports.cyan(i)) : s.push(i);
  }
  return s.join("");
 }, d = {
  createLineUpdater: e.createLineUpdater,
  createTimeSpan: (s, r = !1, n) => {
   const o = Date.now(), u = () => Date.now() - o, h = {
    duration: u,
    finish: (s, o, h, p) => {
     const d = u();
     let f;
     return f = d > 1e3 ? "in " + (d / 1e3).toFixed(2) + " s" : parseFloat(d.toFixed(3)) > 0 ? "in " + d + " ms" : "in less than 1 ms", 
     ((s, r, n, o, u, h, p) => {
      let d = s;
      if (n && (d = ansiColor[n](s)), o && (d = ansiColors.exports.bold(d)), d += " " + ansiColors.exports.dim(r), 
      h) {
       if (shouldLog(t, "debug")) {
        const t = [ d ];
        l(t);
        const s = wordWrap(t, e.getColumns());
        a(s), console.log(s.join("\n"));
       }
       c("D", [ `${s} ${r}` ]);
      } else {
       const t = wordWrap([ d ], e.getColumns());
       i(t), console.log(t.join("\n")), c("I", [ `${s} ${r}` ]), p && p.push(`${s} ${r}`);
      }
      u && console.log("");
     })(s, f, o, !!h, !!p, r, n), d;
    }
   };
   return ((s, r, n) => {
    const o = [ `${s} ${ansiColors.exports.dim("...")}` ];
    if (r) {
     if (shouldLog(t, "debug")) {
      l(o);
      const t = wordWrap(o, e.getColumns());
      a(t), console.log(t.join("\n")), c("D", [ `${s} ...` ]);
     }
    } else {
     const t = wordWrap(o, e.getColumns());
     i(t), console.log(t.join("\n")), c("I", [ `${s} ...` ]), n && n.push(`${s} ...`);
    }
   })(s, r, n), h;
  },
  debug: (...s) => {
   if (shouldLog(t, "debug")) {
    l(s);
    const t = wordWrap(s, e.getColumns());
    a(t), console.log(t.join("\n"));
   }
   c("D", s);
  },
  emoji: e.emoji,
  enableColors: e => {
   ansiColor.enabled = e;
  },
  error: (...s) => {
   for (let e = 0; e < s.length; e++) if (s[e] instanceof Error) {
    const t = s[e];
    s[e] = t.message, t.stack && (s[e] += "\n" + t.stack);
   }
   if (shouldLog(t, "error")) {
    const t = wordWrap(s, e.getColumns());
    o(t), console.error("\n" + t.join("\n") + "\n");
   }
   c("E", s);
  },
  getLevel: () => t,
  info: (...s) => {
   if (shouldLog(t, "info")) {
    const t = wordWrap(s, e.getColumns());
    i(t), console.log(t.join("\n"));
   }
   c("I", s);
  },
  printDiagnostics: (s, r) => {
   if (!s || 0 === s.length) return;
   let l = [ "" ];
   s.forEach((s => {
    l = l.concat(((s, r) => {
     const l = wordWrap([ s.messageText ], e.getColumns());
     let c = "";
     s.header && "Build Error" !== s.header && (c += s.header), "string" == typeof s.absFilePath && "string" != typeof s.relFilePath && ("string" != typeof r && (r = e.cwd()), 
     s.relFilePath = e.relativePath(r, s.absFilePath), s.relFilePath.includes("/") || (s.relFilePath = "./" + s.relFilePath));
     let d = s.relFilePath;
     return "string" != typeof d && (d = s.absFilePath), "string" == typeof d && (c.length > 0 && (c += ": "), 
     c += ansiColors.exports.cyan(d), "number" == typeof s.lineNumber && s.lineNumber > -1 && (c += ansiColors.exports.dim(":"), 
     c += ansiColors.exports.yellow(`${s.lineNumber}`), "number" == typeof s.columnNumber && s.columnNumber > -1 && (c += ansiColors.exports.dim(":"), 
     c += ansiColors.exports.yellow(`${s.columnNumber}`)))), c.length > 0 && l.unshift(INDENT$1 + c), 
     l.push(""), s.lines && s.lines.length && (removeLeadingWhitespace(s.lines).forEach((e => {
      if (!isMeaningfulLine(e.text)) return;
      let t = "";
      for (e.lineNumber > -1 && (t = `L${e.lineNumber}:  `); t.length < INDENT$1.length; ) t = " " + t;
      let r = e.text;
      e.errorCharStart > -1 && (r = u(r, e.errorCharStart, e.errorLength)), t = ansiColors.exports.dim(t), 
      "typescript" === s.language || "javascript" === s.language ? t += h(r) : "scss" === s.language || "css" === s.language ? t += p(r) : t += r, 
      l.push(t);
     })), l.push("")), "error" === s.level ? o(l) : "warn" === s.level ? n(l) : "debug" === s.level ? a(l) : i(l), 
     null != s.debugText && "debug" === t && (l.push(s.debugText), a(wordWrap([ s.debugText ], e.getColumns()))), 
     l;
    })(s, r));
   })), console.log(l.join("\n"));
  },
  setLevel: e => t = e,
  setLogFilePath: e => s = e,
  warn: (...s) => {
   if (shouldLog(t, "warn")) {
    const t = wordWrap(s, e.getColumns());
    n(t), console.warn("\n" + t.join("\n") + "\n");
   }
   c("W", s);
  },
  writeLogs: t => {
   if (s) try {
    c("F", [ "--------------------------------------" ]), e.writeLogs(s, r.join("\n"), t);
   } catch (e) {}
   r.length = 0;
  },
  bgRed: ansiColors.exports.bgRed,
  blue: ansiColors.exports.blue,
  bold: ansiColors.exports.bold,
  cyan: ansiColors.exports.cyan,
  dim: ansiColors.exports.dim,
  gray: ansiColors.exports.gray,
  green: ansiColors.exports.green,
  magenta: ansiColors.exports.magenta,
  red: ansiColors.exports.red,
  yellow: ansiColors.exports.yellow
 };
 return d;
}, shouldLog = (e, t) => LOG_LEVELS.indexOf(t) >= LOG_LEVELS.indexOf(e), formatPrefixTimestamp = () => {
 const e = new Date;
 return `[${clampTwoDigits(e.getMinutes())}:${clampTwoDigits(e.getSeconds())}.${Math.floor(e.getMilliseconds() / 1e3 * 10)}]`;
}, clampTwoDigits = e => ("0" + e.toString()).slice(-2), wordWrap = (e, t) => {
 const s = [], r = [];
 e.forEach((e => {
  null === e ? r.push("null") : void 0 === e ? r.push("undefined") : "string" == typeof e ? e.replace(/\s/gm, " ").split(" ").forEach((e => {
   e.trim().length && r.push(e.trim());
  })) : "number" == typeof e || "boolean" == typeof e || "function" == typeof e ? r.push(e.toString()) : Array.isArray(e) || Object(e) === e ? r.push((() => e.toString())) : r.push(e.toString());
 }));
 let i = INDENT$1;
 return r.forEach((e => {
  s.length > 25 || ("function" == typeof e ? (i.trim().length && s.push(i), s.push(e()), 
  i = INDENT$1) : INDENT$1.length + e.length > t - 1 ? (i.trim().length && s.push(i), 
  s.push(INDENT$1 + e), i = INDENT$1) : e.length + i.length > t - 1 ? (s.push(i), 
  i = INDENT$1 + e + " ") : i += e + " ");
 })), i.trim().length && s.push(i), s.map((e => e.trimRight()));
}, removeLeadingWhitespace = e => {
 const t = JSON.parse(JSON.stringify(e));
 for (let e = 0; e < 100; e++) {
  if (!eachLineHasLeadingWhitespace(t)) return t;
  for (let e = 0; e < t.length; e++) if (t[e].text = t[e].text.slice(1), t[e].errorCharStart--, 
  !t[e].text.length) return t;
 }
 return t;
}, eachLineHasLeadingWhitespace = e => {
 if (!e.length) return !1;
 for (let t = 0; t < e.length; t++) {
  if (!e[t].text || e[t].text.length < 1) return !1;
  const s = e[t].text.charAt(0);
  if (" " !== s && "\t" !== s) return !1;
 }
 return !0;
}, isMeaningfulLine = e => !!e && (e = e.trim()).length > 0, JS_KEYWORDS = [ "abstract", "any", "as", "break", "boolean", "case", "catch", "class", "console", "const", "continue", "debugger", "declare", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "from", "function", "get", "if", "import", "in", "implements", "Infinity", "instanceof", "let", "module", "namespace", "NaN", "new", "number", "null", "public", "private", "protected", "require", "return", "static", "set", "string", "super", "switch", "this", "throw", "try", "true", "type", "typeof", "undefined", "var", "void", "with", "while", "yield" ], INDENT$1 = "           ", createNodeLogger = () => {
 const e = function t() {
  return {
   cwd: () => process.cwd(),
   emoji: e => "win32" !== process.platform ? e : "",
   getColumns: () => {
    var e, t;
    const s = null !== (t = null === (e = null === process || void 0 === process ? void 0 : process.stdout) || void 0 === e ? void 0 : e.columns) && void 0 !== t ? t : 80;
    return Math.max(Math.min(s, 120), 60);
   },
   memoryUsage: () => process.memoryUsage().rss,
   relativePath: (e, t) => path__default.default.relative(e, t),
   writeLogs: (e, t, s) => {
    if (s) try {
     fs$5.accessSync(e);
    } catch (e) {
     s = !1;
    }
    s ? fs$5.appendFileSync(e, t) : fs$5.writeFileSync(e, t);
   },
   createLineUpdater: async () => {
    const e = await Promise.resolve().then((function() {
     return _interopNamespace(require("readline"));
    }));
    let t = Promise.resolve();
    const s = s => (s = s.substring(0, process.stdout.columns - 5) + "[0m", t = t.then((() => new Promise((t => {
     e.clearLine(process.stdout, 0), e.cursorTo(process.stdout, 0, null), process.stdout.write(s, t);
    })))));
    return process.stdout.write("[?25l"), {
     update: s,
     stop: () => s("[?25h")
    };
   }
  };
 }();
 return createTerminalLogger(e);
};

(lockfile = {
 exports: {}
}).exports = function(e) {
 function t(r) {
  if (s[r]) return s[r].exports;
  var i = s[r] = {
   i: r,
   l: !1,
   exports: {}
  };
  return e[r].call(i.exports, i, i.exports, t), i.l = !0, i.exports;
 }
 var s = {};
 return t.m = e, t.c = s, t.i = function(e) {
  return e;
 }, t.d = function(e, s, r) {
  t.o(e, s) || Object.defineProperty(e, s, {
   configurable: !1,
   enumerable: !0,
   get: r
  });
 }, t.n = function(e) {
  var s = e && e.__esModule ? function t() {
   return e.default;
  } : function t() {
   return e;
  };
  return t.d(s, "a", s), s;
 }, t.o = function(e, t) {
  return Object.prototype.hasOwnProperty.call(e, t);
 }, t.p = "", t(t.s = 14);
}([ function(e, t) {
 e.exports = path__default.default;
}, function(e, t, s) {
 var r, i;
 t.__esModule = !0, r = s(173), i = function n(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 }(r), t.default = function(e) {
  return function() {
   var t = e.apply(this, arguments);
   return new i.default((function(e, s) {
    return function r(n, o) {
     var a, l;
     try {
      l = (a = t[n](o)).value;
     } catch (e) {
      return void s(e);
     }
     if (!a.done) return i.default.resolve(l).then((function(e) {
      r("next", e);
     }), (function(e) {
      r("throw", e);
     }));
     e(l);
    }("next");
   }));
  };
 };
}, function(e, t) {
 e.exports = require$$4__default.default;
}, function(e, t) {
 e.exports = fs__default.default;
}, function(e, t, s) {
 Object.defineProperty(t, "__esModule", {
  value: !0
 });
 class r extends Error {
  constructor(e, t) {
   super(e), this.code = t;
  }
 }
 t.MessageError = r, t.ProcessSpawnError = class i extends r {
  constructor(e, t, s) {
   super(e, t), this.process = s;
  }
 }, t.SecurityError = class n extends r {}, t.ProcessTermError = class o extends r {};
 class a extends Error {
  constructor(e, t) {
   super(e), this.responseCode = t;
  }
 }
 t.ResponseError = a;
}, function(e, t, s) {
 function r() {
  return f = u(s(1));
 }
 function i() {
  return m = u(s(3));
 }
 function n() {
  return y = u(s(36));
 }
 function o() {
  return v = u(s(0));
 }
 function a() {
  return b = function e(t) {
   var s, r;
   if (t && t.__esModule) return t;
   if (s = {}, null != t) for (r in t) Object.prototype.hasOwnProperty.call(t, r) && (s[r] = t[r]);
   return s.default = t, s;
  }(s(40));
 }
 function l() {
  return E = s(40);
 }
 function c() {
  return S = s(164);
 }
 function u(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 }
 function h(e, t) {
  return new Promise(((s, r) => {
   (m || i()).default.readFile(e, t, (function(e, t) {
    e ? r(e) : s(t);
   }));
  }));
 }
 function p(e) {
  return h(e, "utf8").then(d);
 }
 function d(e) {
  return e.replace(/\r\n/g, "\n");
 }
 var f, m, g, y, v, w, b, E, _, S, T, x, $, C, A, k, D, P, O, L, R, N, F, j, I, M, B;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.getFirstSuitableFolder = t.readFirstAvailableStream = t.makeTempDir = t.hardlinksWork = t.writeFilePreservingEol = t.getFileSizeOnDisk = t.walk = t.symlink = t.find = t.readJsonAndFile = t.readJson = t.readFileAny = t.hardlinkBulk = t.copyBulk = t.unlink = t.glob = t.link = t.chmod = t.lstat = t.exists = t.mkdirp = t.stat = t.access = t.rename = t.readdir = t.realpath = t.readlink = t.writeFile = t.open = t.readFileBuffer = t.lockQueue = t.constants = void 0;
 let U = (T = (0, (f || r()).default)((function*(e, t, s, i) {
  var n, a, l, u, h, p, d, m, g, y, w, b, E;
  let _ = (E = (0, (f || r()).default)((function*(r) {
   var n, a, l, u, h, p, d, f, m, g, y, w;
   const b = r.src, E = r.dest, _ = r.type, C = r.onFresh || fe, A = r.onDone || fe;
   if (x.has(E.toLowerCase()) ? i.verbose(`The case-insensitive file ${E} shouldn't be copied twice in one bulk copy`) : x.add(E.toLowerCase()), 
   "symlink" === _) return yield ne((v || o()).default.dirname(E)), C(), $.symlink.push({
    dest: E,
    linkname: b
   }), void A();
   if (t.ignoreBasenames.indexOf((v || o()).default.basename(b)) >= 0) return;
   const k = yield ae(b);
   let D, P;
   k.isDirectory() && (D = yield re(b));
   try {
    P = yield ae(E);
   } catch (e) {
    if ("ENOENT" !== e.code) throw e;
   }
   if (P) {
    const e = k.isSymbolicLink() && P.isSymbolicLink(), t = k.isDirectory() && P.isDirectory(), r = k.isFile() && P.isFile();
    if (r && T.has(E)) return A(), void i.verbose(i.lang("verboseFileSkipArtifact", b));
    if (r && k.size === P.size && (0, (S || c()).fileDatesEqual)(k.mtime, P.mtime)) return A(), 
    void i.verbose(i.lang("verboseFileSkip", b, E, k.size, +k.mtime));
    if (e) {
     const e = yield te(b);
     if (e === (yield te(E))) return A(), void i.verbose(i.lang("verboseFileSkipSymlink", b, E, e));
    }
    if (t) {
     const e = yield re(E);
     for (pe(D, "src files not initialised"), n = e, l = 0, n = (a = Array.isArray(n)) ? n : n[Symbol.iterator](); ;) {
      if (a) {
       if (l >= n.length) break;
       u = n[l++];
      } else {
       if ((l = n.next()).done) break;
       u = l.value;
      }
      const e = u;
      if (D.indexOf(e) < 0) {
       const t = (v || o()).default.join(E, e);
       if (s.add(t), (yield ae(t)).isDirectory()) for (h = yield re(t), d = 0, h = (p = Array.isArray(h)) ? h : h[Symbol.iterator](); ;) {
        if (p) {
         if (d >= h.length) break;
         f = h[d++];
        } else {
         if ((d = h.next()).done) break;
         f = d.value;
        }
        const e = f;
        s.add((v || o()).default.join(t, e));
       }
      }
     }
    }
   }
   if (P && P.isSymbolicLink() && (yield (0, (S || c()).unlink)(E), P = null), k.isSymbolicLink()) {
    C();
    const e = yield te(b);
    $.symlink.push({
     dest: E,
     linkname: e
    }), A();
   } else if (k.isDirectory()) {
    P || (i.verbose(i.lang("verboseFileFolder", E)), yield ne(E));
    const t = E.split((v || o()).default.sep);
    for (;t.length; ) x.add(t.join((v || o()).default.sep).toLowerCase()), t.pop();
    pe(D, "src files not initialised");
    let s = D.length;
    for (s || A(), m = D, y = 0, m = (g = Array.isArray(m)) ? m : m[Symbol.iterator](); ;) {
     if (g) {
      if (y >= m.length) break;
      w = m[y++];
     } else {
      if ((y = m.next()).done) break;
      w = y.value;
     }
     const t = w;
     e.push({
      dest: (v || o()).default.join(E, t),
      onFresh: C,
      onDone: function(e) {
       function t() {
        return e.apply(this, arguments);
       }
       return t.toString = function() {
        return e.toString();
       }, t;
      }((function() {
       0 == --s && A();
      })),
      src: (v || o()).default.join(b, t)
     });
    }
   } else {
    if (!k.isFile()) throw new Error(`unsure how to copy this: ${b}`);
    C(), $.file.push({
     src: b,
     dest: E,
     atime: k.atime,
     mtime: k.mtime,
     mode: k.mode
    }), A();
   }
  })), function e(t) {
   return E.apply(this, arguments);
  });
  const T = new Set(t.artifactFiles || []), x = new Set;
  for (n = e, l = 0, n = (a = Array.isArray(n)) ? n : n[Symbol.iterator](); ;) {
   if (a) {
    if (l >= n.length) break;
    u = n[l++];
   } else {
    if ((l = n.next()).done) break;
    u = l.value;
   }
   const e = u, s = e.onDone;
   e.onDone = function() {
    t.onProgress(e.dest), s && s();
   };
  }
  t.onStart(e.length);
  const $ = {
   file: [],
   symlink: [],
   link: []
  };
  for (;e.length; ) {
   const t = e.splice(0, ue);
   yield Promise.all(t.map(_));
  }
  for (h = T, d = 0, h = (p = Array.isArray(h)) ? h : h[Symbol.iterator](); ;) {
   if (p) {
    if (d >= h.length) break;
    m = h[d++];
   } else {
    if ((d = h.next()).done) break;
    m = d.value;
   }
   const e = m;
   s.has(e) && (i.verbose(i.lang("verboseFilePhantomExtraneous", e)), s.delete(e));
  }
  for (g = s, w = 0, g = (y = Array.isArray(g)) ? g : g[Symbol.iterator](); ;) {
   if (y) {
    if (w >= g.length) break;
    b = g[w++];
   } else {
    if ((w = g.next()).done) break;
    b = w.value;
   }
   const e = b;
   x.has(e.toLowerCase()) && s.delete(e);
  }
  return $;
 })), function e(t, s, r, i) {
  return T.apply(this, arguments);
 }), W = (x = (0, (f || r()).default)((function*(e, t, s, i) {
  var n, a, l, c, u, h, p, d, m, g, y, w, b;
  let E = (b = (0, (f || r()).default)((function*(r) {
   var n, a, l, c, u, h, p, d, f, m, g, y;
   const w = r.src, b = r.dest, E = r.onFresh || fe, x = r.onDone || fe;
   if (S.has(b.toLowerCase())) return void x();
   if (S.add(b.toLowerCase()), t.ignoreBasenames.indexOf((v || o()).default.basename(w)) >= 0) return;
   const $ = yield ae(w);
   let C;
   $.isDirectory() && (C = yield re(w));
   const A = yield oe(b);
   if (A) {
    const e = yield ae(b), t = $.isSymbolicLink() && e.isSymbolicLink(), r = $.isDirectory() && e.isDirectory(), f = $.isFile() && e.isFile();
    if ($.mode !== e.mode) try {
     yield ie(b, $.mode);
    } catch (e) {
     i.verbose(e);
    }
    if (f && _.has(b)) return x(), void i.verbose(i.lang("verboseFileSkipArtifact", w));
    if (f && null !== $.ino && $.ino === e.ino) return x(), void i.verbose(i.lang("verboseFileSkip", w, b, $.ino));
    if (t) {
     const e = yield te(w);
     if (e === (yield te(b))) return x(), void i.verbose(i.lang("verboseFileSkipSymlink", w, b, e));
    }
    if (r) {
     const e = yield re(b);
     for (pe(C, "src files not initialised"), n = e, l = 0, n = (a = Array.isArray(n)) ? n : n[Symbol.iterator](); ;) {
      if (a) {
       if (l >= n.length) break;
       c = n[l++];
      } else {
       if ((l = n.next()).done) break;
       c = l.value;
      }
      const e = c;
      if (C.indexOf(e) < 0) {
       const t = (v || o()).default.join(b, e);
       if (s.add(t), (yield ae(t)).isDirectory()) for (u = yield re(t), p = 0, u = (h = Array.isArray(u)) ? u : u[Symbol.iterator](); ;) {
        if (h) {
         if (p >= u.length) break;
         d = u[p++];
        } else {
         if ((p = u.next()).done) break;
         d = p.value;
        }
        const e = d;
        s.add((v || o()).default.join(t, e));
       }
      }
     }
    }
   }
   if ($.isSymbolicLink()) {
    E();
    const e = yield te(w);
    T.symlink.push({
     dest: b,
     linkname: e
    }), x();
   } else if ($.isDirectory()) {
    i.verbose(i.lang("verboseFileFolder", b)), yield ne(b);
    const t = b.split((v || o()).default.sep);
    for (;t.length; ) S.add(t.join((v || o()).default.sep).toLowerCase()), t.pop();
    pe(C, "src files not initialised");
    let s = C.length;
    for (s || x(), f = C, g = 0, f = (m = Array.isArray(f)) ? f : f[Symbol.iterator](); ;) {
     if (m) {
      if (g >= f.length) break;
      y = f[g++];
     } else {
      if ((g = f.next()).done) break;
      y = g.value;
     }
     const t = y;
     e.push({
      onFresh: E,
      src: (v || o()).default.join(w, t),
      dest: (v || o()).default.join(b, t),
      onDone: function(e) {
       function t() {
        return e.apply(this, arguments);
       }
       return t.toString = function() {
        return e.toString();
       }, t;
      }((function() {
       0 == --s && x();
      }))
     });
    }
   } else {
    if (!$.isFile()) throw new Error(`unsure how to copy this: ${w}`);
    E(), T.link.push({
     src: w,
     dest: b,
     removeDest: A
    }), x();
   }
  })), function e(t) {
   return b.apply(this, arguments);
  });
  const _ = new Set(t.artifactFiles || []), S = new Set;
  for (n = e, l = 0, n = (a = Array.isArray(n)) ? n : n[Symbol.iterator](); ;) {
   if (a) {
    if (l >= n.length) break;
    c = n[l++];
   } else {
    if ((l = n.next()).done) break;
    c = l.value;
   }
   const e = c, s = e.onDone || fe;
   e.onDone = function() {
    t.onProgress(e.dest), s();
   };
  }
  t.onStart(e.length);
  const T = {
   file: [],
   symlink: [],
   link: []
  };
  for (;e.length; ) {
   const t = e.splice(0, ue);
   yield Promise.all(t.map(E));
  }
  for (u = _, p = 0, u = (h = Array.isArray(u)) ? u : u[Symbol.iterator](); ;) {
   if (h) {
    if (p >= u.length) break;
    d = u[p++];
   } else {
    if ((p = u.next()).done) break;
    d = p.value;
   }
   const e = d;
   s.has(e) && (i.verbose(i.lang("verboseFilePhantomExtraneous", e)), s.delete(e));
  }
  for (m = s, y = 0, m = (g = Array.isArray(m)) ? m : m[Symbol.iterator](); ;) {
   if (g) {
    if (y >= m.length) break;
    w = m[y++];
   } else {
    if ((y = m.next()).done) break;
    w = y.value;
   }
   const e = w;
   S.has(e.toLowerCase()) && s.delete(e);
  }
  return T;
 })), function e(t, s, r, i) {
  return x.apply(this, arguments);
 }), H = t.copyBulk = ($ = (0, (f || r()).default)((function*(e, t, s) {
  const i = {
   onStart: s && s.onStart || fe,
   onProgress: s && s.onProgress || fe,
   possibleExtraneous: s ? s.possibleExtraneous : new Set,
   ignoreBasenames: s && s.ignoreBasenames || [],
   artifactFiles: s && s.artifactFiles || []
  }, n = yield U(e, i, i.possibleExtraneous, t);
  i.onStart(n.file.length + n.symlink.length + n.link.length);
  const l = n.file, u = new Map;
  var h;
  yield (b || a()).queue(l, (h = (0, (f || r()).default)((function*(e) {
   let s;
   for (;s = u.get(e.dest); ) yield s;
   t.verbose(t.lang("verboseFileCopy", e.src, e.dest));
   const r = (0, (S || c()).copyFile)(e, (function() {
    return u.delete(e.dest);
   }));
   return u.set(e.dest, r), i.onProgress(e.dest), r;
  })), function(e) {
   return h.apply(this, arguments);
  }), ue);
  const p = n.symlink;
  yield (b || a()).queue(p, (function(e) {
   const s = (v || o()).default.resolve((v || o()).default.dirname(e.dest), e.linkname);
   return t.verbose(t.lang("verboseFileSymlink", e.dest, s)), G(s, e.dest);
  }));
 })), function e(t, s, r) {
  return $.apply(this, arguments);
 });
 t.hardlinkBulk = (C = (0, (f || r()).default)((function*(e, t, s) {
  const i = {
   onStart: s && s.onStart || fe,
   onProgress: s && s.onProgress || fe,
   possibleExtraneous: s ? s.possibleExtraneous : new Set,
   artifactFiles: s && s.artifactFiles || [],
   ignoreBasenames: []
  }, n = yield W(e, i, i.possibleExtraneous, t);
  i.onStart(n.file.length + n.symlink.length + n.link.length);
  const l = n.link;
  var u;
  yield (b || a()).queue(l, (u = (0, (f || r()).default)((function*(e) {
   t.verbose(t.lang("verboseFileLink", e.src, e.dest)), e.removeDest && (yield (0, 
   (S || c()).unlink)(e.dest)), yield le(e.src, e.dest);
  })), function(e) {
   return u.apply(this, arguments);
  }), ue);
  const h = n.symlink;
  yield (b || a()).queue(h, (function(e) {
   const s = (v || o()).default.resolve((v || o()).default.dirname(e.dest), e.linkname);
   return t.verbose(t.lang("verboseFileSymlink", e.dest, s)), G(s, e.dest);
  }));
 })), function e(t, s, r) {
  return C.apply(this, arguments);
 }), t.readFileAny = (A = (0, (f || r()).default)((function*(e) {
  var t, s, r, i;
  for (t = e, r = 0, t = (s = Array.isArray(t)) ? t : t[Symbol.iterator](); ;) {
   if (s) {
    if (r >= t.length) break;
    i = t[r++];
   } else {
    if ((r = t.next()).done) break;
    i = r.value;
   }
   const e = i;
   if (yield oe(e)) return p(e);
  }
  return null;
 })), function e(t) {
  return A.apply(this, arguments);
 }), t.readJson = (k = (0, (f || r()).default)((function*(e) {
  return (yield z(e)).object;
 })), function e(t) {
  return k.apply(this, arguments);
 });
 let z = t.readJsonAndFile = (D = (0, (f || r()).default)((function*(e) {
  const t = yield p(e);
  try {
   return {
    object: (0, (_ || (_ = u(s(20)))).default)(JSON.parse(de(t))),
    content: t
   };
  } catch (t) {
   throw t.message = `${e}: ${t.message}`, t;
  }
 })), function e(t) {
  return D.apply(this, arguments);
 });
 t.find = (P = (0, (f || r()).default)((function*(e, t) {
  const s = t.split((v || o()).default.sep);
  for (;s.length; ) {
   const t = s.concat(e).join((v || o()).default.sep);
   if (yield oe(t)) return t;
   s.pop();
  }
  return !1;
 })), function e(t, s) {
  return P.apply(this, arguments);
 });
 let G = t.symlink = (O = (0, (f || r()).default)((function*(e, t) {
  try {
   if ((yield ae(t)).isSymbolicLink() && (yield se(t)) === e) return;
  } catch (e) {
   if ("ENOENT" !== e.code) throw e;
  }
  if (yield (0, (S || c()).unlink)(t), "win32" === process.platform) yield he(e, t, "junction"); else {
   let s;
   try {
    s = (v || o()).default.relative((m || i()).default.realpathSync((v || o()).default.dirname(t)), (m || i()).default.realpathSync(e));
   } catch (r) {
    if ("ENOENT" !== r.code) throw r;
    s = (v || o()).default.relative((v || o()).default.dirname(t), e);
   }
   yield he(s || ".", t);
  }
 })), function e(t, s) {
  return O.apply(this, arguments);
 }), q = t.walk = (L = (0, (f || r()).default)((function*(e, t, s = new Set) {
  var r, i, n, a;
  let l = [], c = yield re(e);
  for (s.size && (c = c.filter((function(e) {
   return !s.has(e);
  }))), r = c, n = 0, r = (i = Array.isArray(r)) ? r : r[Symbol.iterator](); ;) {
   if (i) {
    if (n >= r.length) break;
    a = r[n++];
   } else {
    if ((n = r.next()).done) break;
    a = n.value;
   }
   const c = a, u = t ? (v || o()).default.join(t, c) : c, h = (v || o()).default.join(e, c), p = yield ae(h);
   l.push({
    relative: u,
    basename: c,
    absolute: h,
    mtime: +p.mtime
   }), p.isDirectory() && (l = l.concat(yield q(h, u, s)));
  }
  return l;
 })), function e(t, s) {
  return L.apply(this, arguments);
 });
 t.getFileSizeOnDisk = (R = (0, (f || r()).default)((function*(e) {
  const t = yield ae(e), s = t.size, r = t.blksize;
  return Math.ceil(s / r) * r;
 })), function e(t) {
  return R.apply(this, arguments);
 });
 let V = (N = (0, (f || r()).default)((function*(e) {
  if (!(yield oe(e))) return;
  const t = yield Q(e);
  for (let e = 0; e < t.length; ++e) {
   if (t[e] === me) return "\r\n";
   if (t[e] === ge) return "\n";
  }
 })), function e(t) {
  return N.apply(this, arguments);
 });
 t.writeFilePreservingEol = (F = (0, (f || r()).default)((function*(e, t) {
  const s = (yield V(e)) || (y || n()).default.EOL;
  "\n" !== s && (t = t.replace(/\n/g, s)), yield ee(e, t);
 })), function e(t, s) {
  return F.apply(this, arguments);
 }), t.hardlinksWork = (j = (0, (f || r()).default)((function*(e) {
  const t = "test-file" + Math.random(), s = (v || o()).default.join(e, t), r = (v || o()).default.join(e, t + "-link");
  try {
   yield ee(s, "test"), yield le(s, r);
  } catch (e) {
   return !1;
  } finally {
   yield (0, (S || c()).unlink)(s), yield (0, (S || c()).unlink)(r);
  }
  return !0;
 })), function e(t) {
  return j.apply(this, arguments);
 }), t.makeTempDir = (I = (0, (f || r()).default)((function*(e) {
  const t = (v || o()).default.join((y || n()).default.tmpdir(), `yarn-${e || ""}-${Date.now()}-${Math.random()}`);
  return yield (0, (S || c()).unlink)(t), yield ne(t), t;
 })), function e(t) {
  return I.apply(this, arguments);
 }), t.readFirstAvailableStream = (M = (0, (f || r()).default)((function*(e) {
  var t, s, r, n;
  for (t = e, r = 0, t = (s = Array.isArray(t)) ? t : t[Symbol.iterator](); ;) {
   if (s) {
    if (r >= t.length) break;
    n = t[r++];
   } else {
    if ((r = t.next()).done) break;
    n = r.value;
   }
   const e = n;
   try {
    const t = yield Z(e, "r");
    return (m || i()).default.createReadStream(e, {
     fd: t
    });
   } catch (e) {}
  }
  return null;
 })), function e(t) {
  return M.apply(this, arguments);
 }), t.getFirstSuitableFolder = (B = (0, (f || r()).default)((function*(e, t = X.W_OK | X.X_OK) {
  var s, r, i, n;
  const o = {
   skipped: [],
   folder: null
  };
  for (s = e, i = 0, s = (r = Array.isArray(s)) ? s : s[Symbol.iterator](); ;) {
   if (r) {
    if (i >= s.length) break;
    n = s[i++];
   } else {
    if ((i = s.next()).done) break;
    n = i.value;
   }
   const e = n;
   try {
    return yield ne(e), yield ie(e, t), o.folder = e, o;
   } catch (t) {
    o.skipped.push({
     error: t,
     folder: e
    });
   }
  }
  return o;
 })), function e(t) {
  return B.apply(this, arguments);
 }), t.copy = function J(e, t, s) {
  return H([ {
   src: e,
   dest: t
  } ], s);
 }, t.readFile = p, t.readFileRaw = function Y(e) {
  return h(e, "binary");
 }, t.normalizeOS = d;
 const X = t.constants = void 0 !== (m || i()).default.constants ? (m || i()).default.constants : {
  R_OK: (m || i()).default.R_OK,
  W_OK: (m || i()).default.W_OK,
  X_OK: (m || i()).default.X_OK
 };
 t.lockQueue = new ((w || function K() {
  return w = u(s(84));
 }()).default)("fs lock");
 const Q = t.readFileBuffer = (0, (E || l()).promisify)((m || i()).default.readFile), Z = t.open = (0, 
 (E || l()).promisify)((m || i()).default.open), ee = t.writeFile = (0, (E || l()).promisify)((m || i()).default.writeFile), te = t.readlink = (0, 
 (E || l()).promisify)((m || i()).default.readlink), se = t.realpath = (0, (E || l()).promisify)((m || i()).default.realpath), re = t.readdir = (0, 
 (E || l()).promisify)((m || i()).default.readdir);
 t.rename = (0, (E || l()).promisify)((m || i()).default.rename);
 const ie = t.access = (0, (E || l()).promisify)((m || i()).default.access);
 t.stat = (0, (E || l()).promisify)((m || i()).default.stat);
 const ne = t.mkdirp = (0, (E || l()).promisify)(s(116)), oe = t.exists = (0, (E || l()).promisify)((m || i()).default.exists, !0), ae = t.lstat = (0, 
 (E || l()).promisify)((m || i()).default.lstat);
 t.chmod = (0, (E || l()).promisify)((m || i()).default.chmod);
 const le = t.link = (0, (E || l()).promisify)((m || i()).default.link);
 t.glob = (0, (E || l()).promisify)((g || function ce() {
  return g = u(s(75));
 }()).default), t.unlink = (S || c()).unlink;
 const ue = (m || i()).default.copyFile ? 128 : 4, he = (0, (E || l()).promisify)((m || i()).default.symlink), pe = s(7), de = s(122), fe = () => {}, me = "\r".charCodeAt(0), ge = "\n".charCodeAt(0);
}, function(e, t, s) {
 function r(e, t) {
  let s = "PATH";
  if ("win32" === e) {
   s = "Path";
   for (const e in t) "path" === e.toLowerCase() && (s = e);
  }
  return s;
 }
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.getPathKey = r;
 const i = s(36), n = s(0), o = s(45).default;
 var a = s(171);
 const l = a.getCacheDir, c = a.getConfigDir, u = a.getDataDir, h = s(227), p = t.DEPENDENCY_TYPES = [ "devDependencies", "dependencies", "optionalDependencies", "peerDependencies" ], d = t.RESOLUTIONS = "resolutions";
 t.MANIFEST_FIELDS = [ d, ...p ], t.SUPPORTED_NODE_VERSIONS = "^4.8.0 || ^5.7.0 || ^6.2.2 || >=8.0.0", 
 t.YARN_REGISTRY = "https://registry.yarnpkg.com", t.YARN_DOCS = "https://yarnpkg.com/en/docs/cli/", 
 t.YARN_INSTALLER_SH = "https://yarnpkg.com/install.sh", t.YARN_INSTALLER_MSI = "https://yarnpkg.com/latest.msi", 
 t.SELF_UPDATE_VERSION_URL = "https://yarnpkg.com/latest-version", t.CACHE_VERSION = 2, 
 t.LOCKFILE_VERSION = 1, t.NETWORK_CONCURRENCY = 8, t.NETWORK_TIMEOUT = 3e4, t.CHILD_CONCURRENCY = 5, 
 t.REQUIRED_PACKAGE_KEYS = [ "name", "version", "_uid" ], t.PREFERRED_MODULE_CACHE_DIRECTORIES = function f() {
  const e = [ l() ];
  return process.getuid && e.push(n.join(i.tmpdir(), `.yarn-cache-${process.getuid()}`)), 
  e.push(n.join(i.tmpdir(), ".yarn-cache")), e;
 }(), t.CONFIG_DIRECTORY = c();
 const m = t.DATA_DIRECTORY = u();
 t.LINK_REGISTRY_DIRECTORY = n.join(m, "link"), t.GLOBAL_MODULE_DIRECTORY = n.join(m, "global"), 
 t.NODE_BIN_PATH = process.execPath, t.YARN_BIN_PATH = function g() {
  return h ? __filename : n.join(__dirname, "..", "bin", "yarn.js");
 }(), t.NODE_MODULES_FOLDER = "node_modules", t.NODE_PACKAGE_JSON = "package.json", 
 t.POSIX_GLOBAL_PREFIX = `${process.env.DESTDIR || ""}/usr/local`, t.FALLBACK_GLOBAL_PREFIX = n.join(o, ".yarn"), 
 t.META_FOLDER = ".yarn-meta", t.INTEGRITY_FILENAME = ".yarn-integrity", t.LOCKFILE_FILENAME = "yarn.lock", 
 t.METADATA_FILENAME = ".yarn-metadata.json", t.TARBALL_FILENAME = ".yarn-tarball.tgz", 
 t.CLEAN_FILENAME = ".yarnclean", t.NPM_LOCK_FILENAME = "package-lock.json", t.NPM_SHRINKWRAP_FILENAME = "npm-shrinkwrap.json", 
 t.DEFAULT_INDENT = "  ", t.SINGLE_INSTANCE_PORT = 31997, t.SINGLE_INSTANCE_FILENAME = ".yarn-single-instance", 
 t.ENV_PATH_KEY = r(process.platform, process.env), t.VERSION_COLOR_SCHEME = {
  major: "red",
  premajor: "red",
  minor: "yellow",
  preminor: "yellow",
  patch: "green",
  prepatch: "green",
  prerelease: "red",
  unchanged: "white",
  unknown: "red"
 };
}, function(e, t, s) {
 var r = process.env.NODE_ENV;
 e.exports = function(e, t, s, i, n, o, a, l) {
  var c, u, h;
  if ("production" !== r && void 0 === t) throw new Error("invariant requires an error message argument");
  if (!e) throw void 0 === t ? c = new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings.") : (u = [ s, i, n, o, a, l ], 
  h = 0, (c = new Error(t.replace(/%s/g, (function() {
   return u[h++];
  })))).name = "Invariant Violation"), c.framesToPop = 1, c;
 };
}, , function(e, t) {
 e.exports = require$$3__default.default;
}, , function(e, t) {
 var s = e.exports = "undefined" != typeof window && window.Math == Math ? window : "undefined" != typeof self && self.Math == Math ? self : Function("return this")();
 "number" == typeof __g && (__g = s);
}, function(e, t, s) {
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.sortAlpha = function r(e, t) {
  const s = Math.min(e.length, t.length);
  for (let r = 0; r < s; r++) {
   const s = e.charCodeAt(r), i = t.charCodeAt(r);
   if (s !== i) return s - i;
  }
  return e.length - t.length;
 }, t.entries = function i(e) {
  const t = [];
  if (e) for (const s in e) t.push([ s, e[s] ]);
  return t;
 }, t.removePrefix = function n(e, t) {
  return e.startsWith(t) && (e = e.slice(t.length)), e;
 }, t.removeSuffix = function o(e, t) {
  return e.endsWith(t) ? e.slice(0, -t.length) : e;
 }, t.addSuffix = function a(e, t) {
  return e.endsWith(t) ? e : e + t;
 }, t.hyphenate = function l(e) {
  return e.replace(/[A-Z]/g, (e => "-" + e.charAt(0).toLowerCase()));
 }, t.camelCase = function c(e) {
  return /[A-Z]/.test(e) ? null : p(e);
 }, t.compareSortedArrays = function u(e, t) {
  if (e.length !== t.length) return !1;
  for (let s = 0, r = e.length; s < r; s++) if (e[s] !== t[s]) return !1;
  return !0;
 }, t.sleep = function h(e) {
  return new Promise((t => {
   setTimeout(t, e);
  }));
 };
 const p = s(176);
}, function(e, t, s) {
 var r = s(107)("wks"), i = s(111), n = s(11).Symbol, o = "function" == typeof n;
 (e.exports = function(e) {
  return r[e] || (r[e] = o && n[e] || (o ? n : i)("Symbol." + e));
 }).store = r;
}, function(e, t, s) {
 function r() {
  return y = function e(t) {
   var s, r;
   if (t && t.__esModule) return t;
   if (s = {}, null != t) for (r in t) Object.prototype.hasOwnProperty.call(t, r) && (s[r] = t[r]);
   return s.default = t, s;
  }(s(5));
 }
 function i(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 }
 function n(e) {
  return (0, (f || function t() {
   return f = s(29);
  }()).normalizePattern)(e).name;
 }
 function o(e) {
  return e && Object.keys(e).length ? e : void 0;
 }
 function a(e) {
  return e.resolved || (e.reference && e.hash ? `${e.reference}#${e.hash}` : null);
 }
 function l(e, t) {
  const s = n(e), r = t.integrity ? function i(e) {
   return e.toString().split(" ").sort().join(" ");
  }(t.integrity) : "", a = {
   name: s === t.name ? void 0 : t.name,
   version: t.version,
   uid: t.uid === t.version ? void 0 : t.uid,
   resolved: t.resolved,
   registry: "npm" === t.registry ? void 0 : t.registry,
   dependencies: o(t.dependencies),
   optionalDependencies: o(t.optionalDependencies),
   permissions: o(t.permissions),
   prebuiltVariants: o(t.prebuiltVariants)
  };
  return r && (a.integrity = r), a;
 }
 function c(e, t) {
  t.optionalDependencies = t.optionalDependencies || {}, t.dependencies = t.dependencies || {}, 
  t.uid = t.uid || t.version, t.permissions = t.permissions || {}, t.registry = t.registry || "npm", 
  t.name = t.name || n(e);
  const s = t.integrity;
  return s && s.isIntegrity && (t.integrity = b.parse(s)), t;
 }
 var u, h, p, d, f, m, g, y;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.stringify = t.parse = void 0, Object.defineProperty(t, "parse", {
  enumerable: !0,
  get: function e() {
   return i(h || function t() {
    return h = s(81);
   }()).default;
  }
 }), Object.defineProperty(t, "stringify", {
  enumerable: !0,
  get: function e() {
   return i(p || function t() {
    return p = s(150);
   }()).default;
  }
 }), t.implodeEntry = l, t.explodeEntry = c;
 const v = s(7), w = s(0), b = s(55);
 class E {
  constructor({cache: e, source: t, parseResultType: s} = {}) {
   this.source = t || "", this.cache = e, this.parseResultType = s;
  }
  hasEntriesExistWithoutIntegrity() {
   if (!this.cache) return !1;
   for (const e in this.cache) if (!/^.*@(file:|http)/.test(e) && this.cache[e] && !this.cache[e].integrity) return !0;
   return !1;
  }
  static fromDirectory(e, t) {
   return (0, (u || function n() {
    return u = i(s(1));
   }()).default)((function*() {
    const n = w.join(e, (g || function o() {
     return g = s(6);
    }()).LOCKFILE_FILENAME);
    let a, l, c = "";
    return (yield (y || r()).exists(n)) ? (c = yield (y || r()).readFile(n), l = (0, 
    (m || function u() {
     return m = i(s(81));
    }()).default)(c, n), t && ("merge" === l.type ? t.info(t.lang("lockfileMerged")) : "conflict" === l.type && t.warn(t.lang("lockfileConflict"))), 
    a = l.object) : t && t.info(t.lang("noLockfileFound")), new E({
     cache: a,
     source: c,
     parseResultType: l && l.type
    });
   }))();
  }
  getLocked(e) {
   const t = this.cache;
   if (!t) return;
   const s = e in t && t[e];
   return "string" == typeof s ? this.getLocked(s) : s ? (c(e, s), s) : void 0;
  }
  removePattern(e) {
   const t = this.cache;
   t && delete t[e];
  }
  getLockfile(e) {
   var t, r, i, o;
   const c = {}, u = new Map;
   for (t = Object.keys(e).sort((d || function h() {
    return d = s(12);
   }()).sortAlpha), i = 0, t = (r = Array.isArray(t)) ? t : t[Symbol.iterator](); ;) {
    if (r) {
     if (i >= t.length) break;
     o = t[i++];
    } else {
     if ((i = t.next()).done) break;
     o = i.value;
    }
    const s = o, h = e[s], p = h._remote, d = h._reference;
    v(d, "Package is missing a reference"), v(p, "Package is missing a remote");
    const f = a(p), m = f && u.get(f);
    if (m) {
     c[s] = m, m.name || n(s) === h.name || (m.name = h.name);
     continue;
    }
    const g = l(s, {
     name: h.name,
     version: h.version,
     uid: h._uid,
     resolved: p.resolved,
     integrity: p.integrity,
     registry: p.registry,
     dependencies: h.dependencies,
     peerDependencies: h.peerDependencies,
     optionalDependencies: h.optionalDependencies,
     permissions: d.permissions,
     prebuiltVariants: h.prebuiltVariants
    });
    c[s] = g, f && u.set(f, g);
   }
   return c;
  }
 }
 t.default = E;
}, , , function(e, t) {
 e.exports = require$$0__default$1.default;
}, , , function(e, t, s) {
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.default = function e(t = {}) {
  var s, r, i, n;
  if (Array.isArray(t)) for (s = t, i = 0, s = (r = Array.isArray(s)) ? s : s[Symbol.iterator](); ;) {
   if (r) {
    if (i >= s.length) break;
    n = s[i++];
   } else {
    if ((i = s.next()).done) break;
    n = i.value;
   }
   e(n);
  } else if ((null !== t && "object" == typeof t || "function" == typeof t) && (Object.setPrototypeOf(t, null), 
  "object" == typeof t)) for (const s in t) e(t[s]);
  return t;
 };
}, , function(e, t) {
 e.exports = require$$5__default.default;
}, function(e, t) {
 var s = e.exports = {
  version: "2.5.7"
 };
 "number" == typeof __e && (__e = s);
}, , , , function(e, t, s) {
 var r = s(34);
 e.exports = function(e) {
  if (!r(e)) throw TypeError(e + " is not an object!");
  return e;
 };
}, , function(e, t, s) {
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.normalizePattern = function r(e) {
  let t = !1, s = "latest", r = e, i = !1;
  "@" === r[0] && (i = !0, r = r.slice(1));
  const n = r.split("@");
  return n.length > 1 && (r = n.shift(), s = n.join("@"), s ? t = !0 : s = "*"), i && (r = `@${r}`), 
  {
   name: r,
   range: s,
   hasVersion: t
  };
 };
}, , function(e, t, s) {
 var r = s(50), i = s(106);
 e.exports = s(33) ? function(e, t, s) {
  return r.f(e, t, i(1, s));
 } : function(e, t, s) {
  return e[t] = s, e;
 };
}, function(e, t, s) {
 function r(e, t) {
  for (var s in e) t[s] = e[s];
 }
 function i(e, t, s) {
  return o(e, t, s);
 }
 var n = s(63), o = n.Buffer;
 o.from && o.alloc && o.allocUnsafe && o.allocUnsafeSlow ? e.exports = n : (r(n, t), 
 t.Buffer = i), r(o, i), i.from = function(e, t, s) {
  if ("number" == typeof e) throw new TypeError("Argument must not be a number");
  return o(e, t, s);
 }, i.alloc = function(e, t, s) {
  if ("number" != typeof e) throw new TypeError("Argument must be a number");
  var r = o(e);
  return void 0 !== t ? "string" == typeof s ? r.fill(t, s) : r.fill(t) : r.fill(0), 
  r;
 }, i.allocUnsafe = function(e) {
  if ("number" != typeof e) throw new TypeError("Argument must be a number");
  return o(e);
 }, i.allocUnsafeSlow = function(e) {
  if ("number" != typeof e) throw new TypeError("Argument must be a number");
  return n.SlowBuffer(e);
 };
}, function(e, t, s) {
 e.exports = !s(85)((function() {
  return 7 != Object.defineProperty({}, "a", {
   get: function() {
    return 7;
   }
  }).a;
 }));
}, function(e, t) {
 e.exports = function(e) {
  return "object" == typeof e ? null !== e : "function" == typeof e;
 };
}, function(e, t) {
 e.exports = {};
}, function(e, t) {
 e.exports = os__default.default;
}, , , , function(e, t, s) {
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.wait = function r(e) {
  return new Promise((t => {
   setTimeout(t, e);
  }));
 }, t.promisify = function i(e, t) {
  return function(...s) {
   return new Promise((function(r, i) {
    s.push((function(e, ...s) {
     let n = s;
     s.length <= 1 && (n = s[0]), t && (n = e, e = null), e ? i(e) : r(n);
    })), e.apply(null, s);
   }));
  };
 }, t.queue = function n(e, t, s = 1 / 0) {
  s = Math.min(s, e.length), e = e.slice();
  const r = [];
  let i = e.length;
  return i ? new Promise(((n, o) => {
   function a() {
    const s = e.shift();
    t(s).then((function(t) {
     r.push(t), i--, 0 === i ? n(r) : e.length && a();
    }), o);
   }
   for (let e = 0; e < s; e++) a();
  })) : Promise.resolve(r);
 };
}, function(e, t, s) {
 var r = s(11), i = s(23), n = s(48), o = s(31), a = s(49), l = "prototype", c = function(e, t, s) {
  var u, h, p, d = e & c.F, f = e & c.G, m = e & c.S, g = e & c.P, y = e & c.B, v = e & c.W, w = f ? i : i[t] || (i[t] = {}), b = w[l], E = f ? r : m ? r[t] : (r[t] || {})[l];
  for (u in f && (s = t), s) (h = !d && E && void 0 !== E[u]) && a(w, u) || (p = h ? E[u] : s[u], 
  w[u] = f && "function" != typeof E[u] ? s[u] : y && h ? n(p, r) : v && E[u] == p ? function(e) {
   var t = function(t, s, r) {
    if (this instanceof e) {
     switch (arguments.length) {
     case 0:
      return new e;

     case 1:
      return new e(t);

     case 2:
      return new e(t, s);
     }
     return new e(t, s, r);
    }
    return e.apply(this, arguments);
   };
   return t[l] = e[l], t;
  }(p) : g && "function" == typeof p ? n(Function.call, p) : p, g && ((w.virtual || (w.virtual = {}))[u] = p, 
  e & c.R && b && !b[u] && o(b, u, p)));
 };
 c.F = 1, c.G = 2, c.S = 4, c.P = 8, c.B = 16, c.W = 32, c.U = 64, c.R = 128, e.exports = c;
}, function(e, t, s) {
 try {
  var r = s(2);
  if ("function" != typeof r.inherits) throw "";
  e.exports = r.inherits;
 } catch (t) {
  e.exports = s(224);
 }
}, , , function(e, t, s) {
 var r;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.home = void 0;
 const i = s(0), n = t.home = s(36).homedir(), o = (r || function a() {
  return r = function e(t) {
   return t && t.__esModule ? t : {
    default: t
   };
  }(s(169));
 }()).default ? i.resolve("/usr/local/share") : n;
 t.default = o;
}, function(e, t) {
 e.exports = function(e) {
  if ("function" != typeof e) throw TypeError(e + " is not a function!");
  return e;
 };
}, function(e, t) {
 var s = {}.toString;
 e.exports = function(e) {
  return s.call(e).slice(8, -1);
 };
}, function(e, t, s) {
 var r = s(46);
 e.exports = function(e, t, s) {
  if (r(e), void 0 === t) return e;
  switch (s) {
  case 1:
   return function(s) {
    return e.call(t, s);
   };

  case 2:
   return function(s, r) {
    return e.call(t, s, r);
   };

  case 3:
   return function(s, r, i) {
    return e.call(t, s, r, i);
   };
  }
  return function() {
   return e.apply(t, arguments);
  };
 };
}, function(e, t) {
 var s = {}.hasOwnProperty;
 e.exports = function(e, t) {
  return s.call(e, t);
 };
}, function(e, t, s) {
 var r = s(27), i = s(184), n = s(201), o = Object.defineProperty;
 t.f = s(33) ? Object.defineProperty : function e(t, s, a) {
  if (r(t), s = n(s, !0), r(a), i) try {
   return o(t, s, a);
  } catch (e) {}
  if ("get" in a || "set" in a) throw TypeError("Accessors not supported!");
  return "value" in a && (t[s] = a.value), t;
 };
}, , , , function(e, t) {
 e.exports = require$$7__default.default;
}, function(e, t, s) {
 function r(e, t) {
  if (t = t || {}, "string" == typeof e) return i(e, t);
  if (e.algorithm && e.digest) {
   const s = new y;
   return s[e.algorithm] = [ e ], i(n(s, t), t);
  }
  return i(n(e, t), t);
 }
 function i(e, t) {
  return t.single ? new g(e, t) : e.trim().split(/\s+/).reduce(((e, s) => {
   const r = new g(s, t);
   if (r.algorithm && r.digest) {
    const t = r.algorithm;
    e[t] || (e[t] = []), e[t].push(r);
   }
   return e;
  }), new y);
 }
 function n(e, t) {
  return e.algorithm && e.digest ? g.prototype.toString.call(e, t) : "string" == typeof e ? n(r(e, t), t) : y.prototype.toString.call(e, t);
 }
 function o(e) {
  const t = (e = e || {}).integrity && r(e.integrity, e), s = t && Object.keys(t).length, i = s && t.pickAlgorithm(e), n = s && t[i], o = Array.from(new Set((e.algorithms || [ "sha512" ]).concat(i ? [ i ] : []))), a = o.map(c.createHash);
  let l = 0;
  const h = new u({
   transform(e, t, s) {
    l += e.length, a.forEach((s => s.update(e, t))), s(null, e, t);
   }
  }).on("end", (() => {
   const c = e.options && e.options.length ? `?${e.options.join("?")}` : "", u = r(a.map(((e, t) => `${o[t]}-${e.digest("base64")}${c}`)).join(" "), e), p = s && u.match(t, e);
   if ("number" == typeof e.size && l !== e.size) {
    const s = new Error(`stream size mismatch when checking ${t}.\n  Wanted: ${e.size}\n  Found: ${l}`);
    s.code = "EBADSIZE", s.found = l, s.expected = e.size, s.sri = t, h.emit("error", s);
   } else if (e.integrity && !p) {
    const e = new Error(`${t} integrity checksum failed when using ${i}: wanted ${n} but got ${u}. (${l} bytes)`);
    e.code = "EINTEGRITY", e.found = u, e.expected = n, e.algorithm = i, e.sri = t, 
    h.emit("error", e);
   } else h.emit("size", l), h.emit("integrity", u), p && h.emit("verified", p);
  }));
  return h;
 }
 function a(e, t) {
  return x.indexOf(e.toLowerCase()) >= x.indexOf(t.toLowerCase()) ? e : t;
 }
 const l = s(32).Buffer, c = s(9), u = s(17).Transform, h = [ "sha256", "sha384", "sha512" ], p = /^[a-z0-9+/]+(?:=?=?)$/i, d = /^([^-]+)-([^?]+)([?\S*]*)$/, f = /^([^-]+)-([A-Za-z0-9+/=]{44,88})(\?[\x21-\x7E]*)*$/, m = /^[\x21-\x7E]+$/;
 class g {
  get isHash() {
   return !0;
  }
  constructor(e, t) {
   const s = !(!t || !t.strict);
   this.source = e.trim();
   const r = this.source.match(s ? f : d);
   if (!r) return;
   if (s && !h.some((e => e === r[1]))) return;
   this.algorithm = r[1], this.digest = r[2];
   const i = r[3];
   this.options = i ? i.slice(1).split("?") : [];
  }
  hexDigest() {
   return this.digest && l.from(this.digest, "base64").toString("hex");
  }
  toJSON() {
   return this.toString();
  }
  toString(e) {
   if (e && e.strict && !(h.some((e => e === this.algorithm)) && this.digest.match(p) && (this.options || []).every((e => e.match(m))))) return "";
   const t = this.options && this.options.length ? `?${this.options.join("?")}` : "";
   return `${this.algorithm}-${this.digest}${t}`;
  }
 }
 class y {
  get isIntegrity() {
   return !0;
  }
  toJSON() {
   return this.toString();
  }
  toString(e) {
   let t = (e = e || {}).sep || " ";
   return e.strict && (t = t.replace(/\S+/g, " ")), Object.keys(this).map((s => this[s].map((t => g.prototype.toString.call(t, e))).filter((e => e.length)).join(t))).filter((e => e.length)).join(t);
  }
  concat(e, t) {
   const s = "string" == typeof e ? e : n(e, t);
   return r(`${this.toString(t)} ${s}`, t);
  }
  hexDigest() {
   return r(this, {
    single: !0
   }).hexDigest();
  }
  match(e, t) {
   const s = r(e, t), i = s.pickAlgorithm(t);
   return this[i] && s[i] && this[i].find((e => s[i].find((t => e.digest === t.digest)))) || !1;
  }
  pickAlgorithm(e) {
   const t = e && e.pickAlgorithm || a, s = Object.keys(this);
   if (!s.length) throw new Error(`No algorithms available for ${JSON.stringify(this.toString())}`);
   return s.reduce(((e, s) => t(e, s) || e));
  }
 }
 e.exports.parse = r, e.exports.stringify = n, e.exports.fromHex = function v(e, t, s) {
  const i = s && s.options && s.options.length ? `?${s.options.join("?")}` : "";
  return r(`${t}-${l.from(e, "hex").toString("base64")}${i}`, s);
 }, e.exports.fromData = function w(e, t) {
  const s = (t = t || {}).algorithms || [ "sha512" ], r = t.options && t.options.length ? `?${t.options.join("?")}` : "";
  return s.reduce(((s, i) => {
   const n = c.createHash(i).update(e).digest("base64"), o = new g(`${i}-${n}${r}`, t);
   if (o.algorithm && o.digest) {
    const e = o.algorithm;
    s[e] || (s[e] = []), s[e].push(o);
   }
   return s;
  }), new y);
 }, e.exports.fromStream = function b(e, t) {
  const s = (t = t || {}).Promise || Promise, r = o(t);
  return new s(((t, s) => {
   let i;
   e.pipe(r), e.on("error", s), r.on("error", s), r.on("integrity", (e => {
    i = e;
   })), r.on("end", (() => t(i))), r.on("data", (() => {}));
  }));
 }, e.exports.checkData = function E(e, t, s) {
  if (t = r(t, s = s || {}), !Object.keys(t).length) {
   if (s.error) throw Object.assign(new Error("No valid integrity hashes to check against"), {
    code: "EINTEGRITY"
   });
   return !1;
  }
  const i = t.pickAlgorithm(s), n = r({
   algorithm: i,
   digest: c.createHash(i).update(e).digest("base64")
  }), o = n.match(t, s);
  if (o || !s.error) return o;
  if ("number" == typeof s.size && e.length !== s.size) {
   const r = new Error(`data size mismatch when checking ${t}.\n  Wanted: ${s.size}\n  Found: ${e.length}`);
   throw r.code = "EBADSIZE", r.found = e.length, r.expected = s.size, r.sri = t, r;
  }
  {
   const s = new Error(`Integrity checksum failed when using ${i}: Wanted ${t}, but got ${n}. (${e.length} bytes)`);
   throw s.code = "EINTEGRITY", s.found = n, s.expected = t, s.algorithm = i, s.sri = t, 
   s;
  }
 }, e.exports.checkStream = function _(e, t, s) {
  const r = (s = s || {}).Promise || Promise, i = o(Object.assign({}, s, {
   integrity: t
  }));
  return new r(((t, s) => {
   let r;
   e.pipe(i), e.on("error", s), i.on("error", s), i.on("verified", (e => {
    r = e;
   })), i.on("end", (() => t(r))), i.on("data", (() => {}));
  }));
 }, e.exports.integrityStream = o, e.exports.create = function S(e) {
  const t = (e = e || {}).algorithms || [ "sha512" ], s = e.options && e.options.length ? `?${e.options.join("?")}` : "", r = t.map(c.createHash);
  return {
   update: function(e, t) {
    return r.forEach((s => s.update(e, t))), this;
   },
   digest: function(i) {
    return t.reduce(((t, i) => {
     const n = r.shift().digest("base64"), o = new g(`${i}-${n}${s}`, e);
     if (o.algorithm && o.digest) {
      const e = o.algorithm;
      t[e] || (t[e] = []), t[e].push(o);
     }
     return t;
    }), new y);
   }
  };
 };
 const T = new Set(c.getHashes()), x = [ "md5", "whirlpool", "sha1", "sha224", "sha256", "sha384", "sha512", "sha3", "sha3-256", "sha3-384", "sha3-512", "sha3_256", "sha3_384", "sha3_512" ].filter((e => T.has(e)));
}, , , , , function(e, t, s) {
 function r(e, t) {
  e = e || {}, t = t || {};
  var s = {};
  return Object.keys(t).forEach((function(e) {
   s[e] = t[e];
  })), Object.keys(e).forEach((function(t) {
   s[t] = e[t];
  })), s;
 }
 function i(e, t, s) {
  if ("string" != typeof t) throw new TypeError("glob pattern string required");
  return s || (s = {}), !(!s.nocomment && "#" === t.charAt(0)) && ("" === t.trim() ? "" === e : new n(t, s).match(e));
 }
 function n(e, t) {
  if (!(this instanceof n)) return new n(e, t);
  if ("string" != typeof e) throw new TypeError("glob pattern string required");
  t || (t = {}), e = e.trim(), "/" !== a.sep && (e = e.split(a.sep).join("/")), this.options = t, 
  this.set = [], this.pattern = e, this.regexp = null, this.negate = !1, this.comment = !1, 
  this.empty = !1, this.make();
 }
 function o(e, t) {
  if (t || (t = this instanceof n ? this.options : {}), void 0 === (e = void 0 === e ? this.pattern : e)) throw new TypeError("undefined pattern");
  return t.nobrace || !e.match(/\{.*\}/) ? [ e ] : c(e);
 }
 var a, l, c, u, h, p, d, f, m;
 e.exports = i, i.Minimatch = n, a = {
  sep: "/"
 };
 try {
  a = s(0);
 } catch (e) {}
 l = i.GLOBSTAR = n.GLOBSTAR = {}, c = s(175), u = {
  "!": {
   open: "(?:(?!(?:",
   close: "))[^/]*?)"
  },
  "?": {
   open: "(?:",
   close: ")?"
  },
  "+": {
   open: "(?:",
   close: ")+"
  },
  "*": {
   open: "(?:",
   close: ")*"
  },
  "@": {
   open: "(?:",
   close: ")"
  }
 }, p = (h = "[^/]") + "*?", d = function g(e) {
  return e.split("").reduce((function(e, t) {
   return e[t] = !0, e;
  }), {});
 }("().*{}+?[]^$\\!"), f = /\/+/, i.filter = function y(e, t) {
  return t = t || {}, function(s, r, n) {
   return i(s, e, t);
  };
 }, i.defaults = function(e) {
  var t, s;
  return e && Object.keys(e).length ? (t = i, s = function s(i, n, o) {
   return t.minimatch(i, n, r(e, o));
  }, s.Minimatch = function s(i, n) {
   return new t.Minimatch(i, r(e, n));
  }, s) : i;
 }, n.defaults = function(e) {
  return e && Object.keys(e).length ? i.defaults(e).Minimatch : n;
 }, n.prototype.debug = function() {}, n.prototype.make = function v() {
  var e, t, s;
  this._made || (e = this.pattern, (t = this.options).nocomment || "#" !== e.charAt(0) ? e ? (this.parseNegate(), 
  s = this.globSet = this.braceExpand(), t.debug && (this.debug = console.error), 
  this.debug(this.pattern, s), s = this.globParts = s.map((function(e) {
   return e.split(f);
  })), this.debug(this.pattern, s), s = s.map((function(e, t, s) {
   return e.map(this.parse, this);
  }), this), this.debug(this.pattern, s), s = s.filter((function(e) {
   return -1 === e.indexOf(!1);
  })), this.debug(this.pattern, s), this.set = s) : this.empty = !0 : this.comment = !0);
 }, n.prototype.parseNegate = function w() {
  var e, t, s = this.pattern, r = !1, i = 0;
  if (!this.options.nonegate) {
   for (e = 0, t = s.length; e < t && "!" === s.charAt(e); e++) r = !r, i++;
   i && (this.pattern = s.substr(i)), this.negate = r;
  }
 }, i.braceExpand = function(e, t) {
  return o(e, t);
 }, n.prototype.braceExpand = o, n.prototype.parse = function b(e, t) {
  function s() {
   if (f) {
    switch (f) {
    case "*":
     i += p, n = !0;
     break;

    case "?":
     i += h, n = !0;
     break;

    default:
     i += "\\" + f;
    }
    b.debug("clearStateChar %j %j", f, i), f = !1;
   }
  }
  var r, i, n, o, a, c, f, g, y, v, w, b, E, _, S, T, x, $, C, A, k, D, P, O, L, R, N, F, j, I, M, B;
  if (e.length > 65536) throw new TypeError("pattern is too long");
  if (!(r = this.options).noglobstar && "**" === e) return l;
  if ("" === e) return "";
  for (i = "", n = !!r.nocase, o = !1, a = [], c = [], g = !1, y = -1, v = -1, w = "." === e.charAt(0) ? "" : r.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)", 
  b = this, E = 0, _ = e.length; E < _ && (S = e.charAt(E)); E++) if (this.debug("%s\t%s %s %j", e, E, i, S), 
  o && d[S]) i += "\\" + S, o = !1; else switch (S) {
  case "/":
   return !1;

  case "\\":
   s(), o = !0;
   continue;

  case "?":
  case "*":
  case "+":
  case "@":
  case "!":
   if (this.debug("%s\t%s %s %j <-- stateChar", e, E, i, S), g) {
    this.debug("  in class"), "!" === S && E === v + 1 && (S = "^"), i += S;
    continue;
   }
   b.debug("call clearStateChar %j", f), s(), f = S, r.noext && s();
   continue;

  case "(":
   if (g) {
    i += "(";
    continue;
   }
   if (!f) {
    i += "\\(";
    continue;
   }
   a.push({
    type: f,
    start: E - 1,
    reStart: i.length,
    open: u[f].open,
    close: u[f].close
   }), i += "!" === f ? "(?:(?!(?:" : "(?:", this.debug("plType %j %j", f, i), f = !1;
   continue;

  case ")":
   if (g || !a.length) {
    i += "\\)";
    continue;
   }
   s(), n = !0, T = a.pop(), i += T.close, "!" === T.type && c.push(T), T.reEnd = i.length;
   continue;

  case "|":
   if (g || !a.length || o) {
    i += "\\|", o = !1;
    continue;
   }
   s(), i += "|";
   continue;

  case "[":
   if (s(), g) {
    i += "\\" + S;
    continue;
   }
   g = !0, v = E, y = i.length, i += S;
   continue;

  case "]":
   if (E === v + 1 || !g) {
    i += "\\" + S, o = !1;
    continue;
   }
   if (g) {
    x = e.substring(v + 1, E);
    try {
     RegExp("[" + x + "]");
    } catch (e) {
     $ = this.parse(x, m), i = i.substr(0, y) + "\\[" + $[0] + "\\]", n = n || $[1], 
     g = !1;
     continue;
    }
   }
   n = !0, g = !1, i += S;
   continue;

  default:
   s(), o ? o = !1 : !d[S] || "^" === S && g || (i += "\\"), i += S;
  }
  for (g && (x = e.substr(v + 1), $ = this.parse(x, m), i = i.substr(0, y) + "\\[" + $[0], 
  n = n || $[1]), T = a.pop(); T; T = a.pop()) C = i.slice(T.reStart + T.open.length), 
  this.debug("setting tail", i, T), C = C.replace(/((?:\\{2}){0,64})(\\?)\|/g, (function(e, t, s) {
   return s || (s = "\\"), t + t + s + "|";
  })), this.debug("tail=%j\n   %s", C, C, T, i), A = "*" === T.type ? p : "?" === T.type ? h : "\\" + T.type, 
  n = !0, i = i.slice(0, T.reStart) + A + "\\(" + C;
  switch (s(), o && (i += "\\\\"), k = !1, i.charAt(0)) {
  case ".":
  case "[":
  case "(":
   k = !0;
  }
  for (D = c.length - 1; D > -1; D--) {
   for (P = c[D], O = i.slice(0, P.reStart), L = i.slice(P.reStart, P.reEnd - 8), R = i.slice(P.reEnd - 8, P.reEnd), 
   R += N = i.slice(P.reEnd), F = O.split("(").length - 1, j = N, E = 0; E < F; E++) j = j.replace(/\)[+*?]?/, "");
   I = "", "" === (N = j) && t !== m && (I = "$"), i = O + L + N + I + R;
  }
  if ("" !== i && n && (i = "(?=.)" + i), k && (i = w + i), t === m) return [ i, n ];
  if (!n) return function U(e) {
   return e.replace(/\\(.)/g, "$1");
  }(e);
  M = r.nocase ? "i" : "";
  try {
   B = new RegExp("^" + i + "$", M);
  } catch (e) {
   return new RegExp("$.");
  }
  return B._glob = e, B._src = i, B;
 }, m = {}, i.makeRe = function(e, t) {
  return new n(e, t || {}).makeRe();
 }, n.prototype.makeRe = function E() {
  var e, t, s, r, i;
  if (this.regexp || !1 === this.regexp) return this.regexp;
  if (!(e = this.set).length) return this.regexp = !1, this.regexp;
  t = this.options, s = t.noglobstar ? p : t.dot ? "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?" : "(?:(?!(?:\\/|^)\\.).)*?", 
  r = t.nocase ? "i" : "", i = e.map((function(e) {
   return e.map((function(e) {
    return e === l ? s : "string" == typeof e ? function t(e) {
     return e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    }(e) : e._src;
   })).join("\\/");
  })).join("|"), i = "^(?:" + i + ")$", this.negate && (i = "^(?!" + i + ").*$");
  try {
   this.regexp = new RegExp(i, r);
  } catch (e) {
   this.regexp = !1;
  }
  return this.regexp;
 }, i.match = function(e, t, s) {
  var r = new n(t, s = s || {});
  return e = e.filter((function(e) {
   return r.match(e);
  })), r.options.nonull && !e.length && e.push(t), e;
 }, n.prototype.match = function _(e, t) {
  var s, r, i, n, o, l;
  if (this.debug("match", e, this.pattern), this.comment) return !1;
  if (this.empty) return "" === e;
  if ("/" === e && t) return !0;
  for (s = this.options, "/" !== a.sep && (e = e.split(a.sep).join("/")), e = e.split(f), 
  this.debug(this.pattern, "split", e), r = this.set, this.debug(this.pattern, "set", r), 
  n = e.length - 1; n >= 0 && !(i = e[n]); n--) ;
  for (n = 0; n < r.length; n++) if (o = r[n], l = e, s.matchBase && 1 === o.length && (l = [ i ]), 
  this.matchOne(l, o, t)) return !!s.flipNegate || !this.negate;
  return !s.flipNegate && this.negate;
 }, n.prototype.matchOne = function(e, t, s) {
  var r, i, n, o, a, c, u, h, p, d, f = this.options;
  for (this.debug("matchOne", {
   this: this,
   file: e,
   pattern: t
  }), this.debug("matchOne", e.length, t.length), r = 0, i = 0, n = e.length, o = t.length; r < n && i < o; r++, 
  i++) {
   if (this.debug("matchOne loop"), a = t[i], c = e[r], this.debug(t, a, c), !1 === a) return !1;
   if (a === l) {
    if (this.debug("GLOBSTAR", [ t, a, c ]), u = r, (h = i + 1) === o) {
     for (this.debug("** at the end"); r < n; r++) if ("." === e[r] || ".." === e[r] || !f.dot && "." === e[r].charAt(0)) return !1;
     return !0;
    }
    for (;u < n; ) {
     if (p = e[u], this.debug("\nglobstar while", e, u, t, h, p), this.matchOne(e.slice(u), t.slice(h), s)) return this.debug("globstar found match!", u, n, p), 
     !0;
     if ("." === p || ".." === p || !f.dot && "." === p.charAt(0)) {
      this.debug("dot detected!", e, u, t, h);
      break;
     }
     this.debug("globstar swallow a segment, and continue"), u++;
    }
    return !(!s || (this.debug("\n>>> no match, partial?", e, u, t, h), u !== n));
   }
   if ("string" == typeof a ? (d = f.nocase ? c.toLowerCase() === a.toLowerCase() : c === a, 
   this.debug("string match", a, c, d)) : (d = c.match(a), this.debug("pattern match", a, c, d)), 
   !d) return !1;
  }
  if (r === n && i === o) return !0;
  if (r === n) return s;
  if (i === o) return r === n - 1 && "" === e[r];
  throw new Error("wtf?");
 };
}, function(e, t, s) {
 function r(e) {
  var t = function() {
   return t.called ? t.value : (t.called = !0, t.value = e.apply(this, arguments));
  };
  return t.called = !1, t;
 }
 function i(e) {
  var t = function() {
   if (t.called) throw new Error(t.onceError);
   return t.called = !0, t.value = e.apply(this, arguments);
  }, s = e.name || "Function wrapped with `once`";
  return t.onceError = s + " shouldn't be called more than once", t.called = !1, t;
 }
 var n = s(123);
 e.exports = n(r), e.exports.strict = n(i), r.proto = r((function() {
  Object.defineProperty(Function.prototype, "once", {
   value: function() {
    return r(this);
   },
   configurable: !0
  }), Object.defineProperty(Function.prototype, "onceStrict", {
   value: function() {
    return i(this);
   },
   configurable: !0
  });
 }));
}, , function(e, t) {
 e.exports = require$$8__default.default;
}, , , , function(e, t) {
 e.exports = function(e) {
  if (null == e) throw TypeError("Can't call method on  " + e);
  return e;
 };
}, function(e, t, s) {
 var r = s(34), i = s(11).document, n = r(i) && r(i.createElement);
 e.exports = function(e) {
  return n ? i.createElement(e) : {};
 };
}, function(e, t) {
 e.exports = !0;
}, function(e, t, s) {
 function r(e) {
  var t, s;
  this.promise = new e((function(e, r) {
   if (void 0 !== t || void 0 !== s) throw TypeError("Bad Promise constructor");
   t = e, s = r;
  })), this.resolve = i(t), this.reject = i(s);
 }
 var i = s(46);
 e.exports.f = function(e) {
  return new r(e);
 };
}, function(e, t, s) {
 var r = s(50).f, i = s(49), n = s(13)("toStringTag");
 e.exports = function(e, t, s) {
  e && !i(e = s ? e : e.prototype, n) && r(e, n, {
   configurable: !0,
   value: t
  });
 };
}, function(e, t, s) {
 var r = s(107)("keys"), i = s(111);
 e.exports = function(e) {
  return r[e] || (r[e] = i(e));
 };
}, function(e, t) {
 var s = Math.ceil, r = Math.floor;
 e.exports = function(e) {
  return isNaN(e = +e) ? 0 : (e > 0 ? r : s)(e);
 };
}, function(e, t, s) {
 var r = s(131), i = s(67);
 e.exports = function(e) {
  return r(i(e));
 };
}, function(e, t, s) {
 function r(e, t, s) {
  if ("function" == typeof t && (s = t, t = {}), t || (t = {}), t.sync) {
   if (s) throw new TypeError("callback provided to sync glob");
   return d(e, t);
  }
  return new i(e, t, s);
 }
 function i(e, t, s) {
  function r() {
   --o._processing, o._processing <= 0 && (a ? process.nextTick((function() {
    o._finish();
   })) : o._finish());
  }
  var n, o, a, l;
  if ("function" == typeof t && (s = t, t = null), t && t.sync) {
   if (s) throw new TypeError("callback provided to sync glob");
   return new E(e, t);
  }
  if (!(this instanceof i)) return new i(e, t, s);
  if (m(this, e, t), this._didRealPath = !1, n = this.minimatch.set.length, this.matches = new Array(n), 
  "function" == typeof s && (s = b(s), this.on("error", s), this.on("end", (function(e) {
   s(null, e);
  }))), o = this, this._processing = 0, this._emitQueue = [], this._processQueue = [], 
  this.paused = !1, this.noprocess) return this;
  if (0 === n) return r();
  for (a = !0, l = 0; l < n; l++) this._process(this.minimatch.set[l], l, !1, r);
  a = !1;
 }
 var n, o, a, l, c, u, h, p, d, f, m, g, y, v, w, b, E;
 e.exports = r, n = s(3), o = s(114), (a = s(60)).Minimatch, l = s(42), c = s(54).EventEmitter, 
 u = s(0), h = s(22), p = s(76), d = s(218), (f = s(115)).alphasort, f.alphasorti, 
 m = f.setopts, g = f.ownProp, y = s(223), s(2), v = f.childrenIgnored, w = f.isIgnored, 
 b = s(61), r.sync = d, E = r.GlobSync = d.GlobSync, r.glob = r, r.hasMagic = function(e, t) {
  var s, r, n = function o(e, t) {
   var s, r;
   if (null === t || "object" != typeof t) return e;
   for (r = (s = Object.keys(t)).length; r--; ) e[s[r]] = t[s[r]];
   return e;
  }({}, t);
  if (n.noprocess = !0, s = new i(e, n).minimatch.set, !e) return !1;
  if (s.length > 1) return !0;
  for (r = 0; r < s[0].length; r++) if ("string" != typeof s[0][r]) return !0;
  return !1;
 }, r.Glob = i, l(i, c), i.prototype._finish = function() {
  if (h(this instanceof i), !this.aborted) {
   if (this.realpath && !this._didRealpath) return this._realpath();
   f.finish(this), this.emit("end", this.found);
  }
 }, i.prototype._realpath = function() {
  function e() {
   0 == --t && s._finish();
  }
  var t, s, r;
  if (!this._didRealpath) {
   if (this._didRealpath = !0, 0 === (t = this.matches.length)) return this._finish();
   for (s = this, r = 0; r < this.matches.length; r++) this._realpathSet(r, e);
  }
 }, i.prototype._realpathSet = function(e, t) {
  var s, r, i, n, a = this.matches[e];
  return a ? (s = Object.keys(a), r = this, 0 === (i = s.length) ? t() : (n = this.matches[e] = Object.create(null), 
  void s.forEach((function(s, a) {
   s = r._makeAbs(s), o.realpath(s, r.realpathCache, (function(o, a) {
    o ? "stat" === o.syscall ? n[s] = !0 : r.emit("error", o) : n[a] = !0, 0 == --i && (r.matches[e] = n, 
    t());
   }));
  })))) : t();
 }, i.prototype._mark = function(e) {
  return f.mark(this, e);
 }, i.prototype._makeAbs = function(e) {
  return f.makeAbs(this, e);
 }, i.prototype.abort = function() {
  this.aborted = !0, this.emit("abort");
 }, i.prototype.pause = function() {
  this.paused || (this.paused = !0, this.emit("pause"));
 }, i.prototype.resume = function() {
  var e, t, s, r, i;
  if (this.paused) {
   if (this.emit("resume"), this.paused = !1, this._emitQueue.length) for (e = this._emitQueue.slice(0), 
   this._emitQueue.length = 0, t = 0; t < e.length; t++) s = e[t], this._emitMatch(s[0], s[1]);
   if (this._processQueue.length) for (r = this._processQueue.slice(0), this._processQueue.length = 0, 
   t = 0; t < r.length; t++) i = r[t], this._processing--, this._process(i[0], i[1], i[2], i[3]);
  }
 }, i.prototype._process = function(e, t, s, r) {
  var n, o, l, c, u;
  if (h(this instanceof i), h("function" == typeof r), !this.aborted) if (this._processing++, 
  this.paused) this._processQueue.push([ e, t, s, r ]); else {
   for (n = 0; "string" == typeof e[n]; ) n++;
   switch (n) {
   case e.length:
    return void this._processSimple(e.join("/"), t, r);

   case 0:
    o = null;
    break;

   default:
    o = e.slice(0, n).join("/");
   }
   if (l = e.slice(n), null === o ? c = "." : p(o) || p(e.join("/")) ? (o && p(o) || (o = "/" + o), 
   c = o) : c = o, u = this._makeAbs(c), v(this, c)) return r();
   l[0] === a.GLOBSTAR ? this._processGlobStar(o, c, u, l, t, s, r) : this._processReaddir(o, c, u, l, t, s, r);
  }
 }, i.prototype._processReaddir = function(e, t, s, r, i, n, o) {
  var a = this;
  this._readdir(s, n, (function(l, c) {
   return a._processReaddir2(e, t, s, r, i, n, c, o);
  }));
 }, i.prototype._processReaddir2 = function(e, t, s, r, i, n, o, a) {
  var l, c, h, p, d, f, m, g;
  if (!o) return a();
  for (l = r[0], c = !!this.minimatch.negate, h = l._glob, p = this.dot || "." === h.charAt(0), 
  d = [], f = 0; f < o.length; f++) ("." !== (m = o[f]).charAt(0) || p) && (c && !e ? !m.match(l) : m.match(l)) && d.push(m);
  if (0 === (g = d.length)) return a();
  if (1 === r.length && !this.mark && !this.stat) {
   for (this.matches[i] || (this.matches[i] = Object.create(null)), f = 0; f < g; f++) m = d[f], 
   e && (m = "/" !== e ? e + "/" + m : e + m), "/" !== m.charAt(0) || this.nomount || (m = u.join(this.root, m)), 
   this._emitMatch(i, m);
   return a();
  }
  for (r.shift(), f = 0; f < g; f++) m = d[f], e && (m = "/" !== e ? e + "/" + m : e + m), 
  this._process([ m ].concat(r), i, n, a);
  a();
 }, i.prototype._emitMatch = function(e, t) {
  var s, r, i;
  this.aborted || w(this, t) || (this.paused ? this._emitQueue.push([ e, t ]) : (s = p(t) ? t : this._makeAbs(t), 
  this.mark && (t = this._mark(t)), this.absolute && (t = s), this.matches[e][t] || this.nodir && ("DIR" === (r = this.cache[s]) || Array.isArray(r)) || (this.matches[e][t] = !0, 
  (i = this.statCache[s]) && this.emit("stat", t, i), this.emit("match", t))));
 }, i.prototype._readdirInGlobStar = function(e, t) {
  var s, r;
  if (!this.aborted) {
   if (this.follow) return this._readdir(e, !1, t);
   s = this, (r = y("lstat\0" + e, (function i(r, n) {
    if (r && "ENOENT" === r.code) return t();
    var o = n && n.isSymbolicLink();
    s.symlinks[e] = o, o || !n || n.isDirectory() ? s._readdir(e, !1, t) : (s.cache[e] = "FILE", 
    t());
   }))) && n.lstat(e, r);
  }
 }, i.prototype._readdir = function(e, t, s) {
  if (!this.aborted && (s = y("readdir\0" + e + "\0" + t, s))) {
   if (t && !g(this.symlinks, e)) return this._readdirInGlobStar(e, s);
   if (g(this.cache, e)) {
    var r = this.cache[e];
    if (!r || "FILE" === r) return s();
    if (Array.isArray(r)) return s(null, r);
   }
   n.readdir(e, function i(e, t, s) {
    return function(r, i) {
     r ? e._readdirError(t, r, s) : e._readdirEntries(t, i, s);
    };
   }(this, e, s));
  }
 }, i.prototype._readdirEntries = function(e, t, s) {
  var r, i;
  if (!this.aborted) {
   if (!this.mark && !this.stat) for (r = 0; r < t.length; r++) i = t[r], i = "/" === e ? e + i : e + "/" + i, 
   this.cache[i] = !0;
   return this.cache[e] = t, s(null, t);
  }
 }, i.prototype._readdirError = function(e, t, s) {
  var r, i;
  if (!this.aborted) {
   switch (t.code) {
   case "ENOTSUP":
   case "ENOTDIR":
    r = this._makeAbs(e), this.cache[r] = "FILE", r === this.cwdAbs && ((i = new Error(t.code + " invalid cwd " + this.cwd)).path = this.cwd, 
    i.code = t.code, this.emit("error", i), this.abort());
    break;

   case "ENOENT":
   case "ELOOP":
   case "ENAMETOOLONG":
   case "UNKNOWN":
    this.cache[this._makeAbs(e)] = !1;
    break;

   default:
    this.cache[this._makeAbs(e)] = !1, this.strict && (this.emit("error", t), this.abort()), 
    this.silent || console.error("glob error", t);
   }
   return s();
  }
 }, i.prototype._processGlobStar = function(e, t, s, r, i, n, o) {
  var a = this;
  this._readdir(s, n, (function(l, c) {
   a._processGlobStar2(e, t, s, r, i, n, c, o);
  }));
 }, i.prototype._processGlobStar2 = function(e, t, s, r, i, n, o, a) {
  var l, c, u, h, p, d, f, m;
  if (!o) return a();
  if (l = r.slice(1), u = (c = e ? [ e ] : []).concat(l), this._process(u, i, !1, a), 
  h = this.symlinks[s], p = o.length, h && n) return a();
  for (d = 0; d < p; d++) ("." !== o[d].charAt(0) || this.dot) && (f = c.concat(o[d], l), 
  this._process(f, i, !0, a), m = c.concat(o[d], r), this._process(m, i, !0, a));
  a();
 }, i.prototype._processSimple = function(e, t, s) {
  var r = this;
  this._stat(e, (function(i, n) {
   r._processSimple2(e, t, i, n, s);
  }));
 }, i.prototype._processSimple2 = function(e, t, s, r, i) {
  if (this.matches[t] || (this.matches[t] = Object.create(null)), !r) return i();
  if (e && p(e) && !this.nomount) {
   var n = /[\/\\]$/.test(e);
   "/" === e.charAt(0) ? e = u.join(this.root, e) : (e = u.resolve(this.root, e), n && (e += "/"));
  }
  "win32" === process.platform && (e = e.replace(/\\/g, "/")), this._emitMatch(t, e), 
  i();
 }, i.prototype._stat = function(e, t) {
  var s, r, i, o, a, l = this._makeAbs(e), c = "/" === e.slice(-1);
  if (e.length > this.maxLength) return t();
  if (!this.stat && g(this.cache, l)) {
   if (s = this.cache[l], Array.isArray(s) && (s = "DIR"), !c || "DIR" === s) return t(null, s);
   if (c && "FILE" === s) return t();
  }
  if (void 0 !== (r = this.statCache[l])) return !1 === r ? t(null, r) : (i = r.isDirectory() ? "DIR" : "FILE", 
  c && "FILE" === i ? t() : t(null, i, r));
  o = this, a = y("stat\0" + l, (function u(s, r) {
   if (r && r.isSymbolicLink()) return n.stat(l, (function(s, i) {
    s ? o._stat2(e, l, null, r, t) : o._stat2(e, l, s, i, t);
   }));
   o._stat2(e, l, s, r, t);
  })), a && n.lstat(l, a);
 }, i.prototype._stat2 = function(e, t, s, r, i) {
  var n, o;
  return !s || "ENOENT" !== s.code && "ENOTDIR" !== s.code ? (n = "/" === e.slice(-1), 
  this.statCache[t] = r, "/" === t.slice(-1) && r && !r.isDirectory() ? i(null, !1, r) : (o = !0, 
  r && (o = r.isDirectory() ? "DIR" : "FILE"), this.cache[t] = this.cache[t] || o, 
  n && "FILE" === o ? i() : i(null, o, r))) : (this.statCache[t] = !1, i());
 };
}, function(e, t, s) {
 function r(e) {
  return "/" === e.charAt(0);
 }
 function i(e) {
  var t = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/.exec(e), s = t[1] || "", r = Boolean(s && ":" !== s.charAt(1));
  return Boolean(t[2] || r);
 }
 e.exports = "win32" === process.platform ? i : r, e.exports.posix = r, e.exports.win32 = i;
}, , , function(e, t) {
 e.exports = require$$9__default.default;
}, , function(e, t, s) {
 function r() {
  return l = n(s(7));
 }
 function i() {
  return u = s(6);
 }
 function n(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 }
 function o(e, t) {
  const s = new T(e, t);
  return s.next(), s.parse();
 }
 var a, l, c, u, h, p;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.default = function(e, t = "lockfile") {
  return function i(e) {
   return e.includes(A) && e.includes(C) && e.includes($);
  }(e = (0, (c || function r() {
   return c = n(s(122));
  }()).default)(e)) ? function a(e, t) {
   const s = function r(e) {
    const t = [ [], [] ], s = e.split(/\r?\n/g);
    let r = !1;
    for (;s.length; ) {
     const e = s.shift();
     if (e.startsWith(A)) {
      for (;s.length; ) {
       const e = s.shift();
       if (e === C) {
        r = !1;
        break;
       }
       r || e.startsWith(x) ? r = !0 : t[0].push(e);
      }
      for (;s.length; ) {
       const e = s.shift();
       if (e.startsWith($)) break;
       t[1].push(e);
      }
     } else t[0].push(e), t[1].push(e);
    }
    return [ t[0].join("\n"), t[1].join("\n") ];
   }(e);
   try {
    return {
     type: "merge",
     object: Object.assign({}, o(s[0], t), o(s[1], t))
    };
   } catch (e) {
    if (e instanceof SyntaxError) return {
     type: "conflict",
     object: {}
    };
    throw e;
   }
  }(e, t) : {
   type: "success",
   object: o(e, t)
  };
 };
 const d = /^yarn lockfile v(\d+)$/, f = "BOOLEAN", m = "STRING", g = "COLON", y = "NEWLINE", v = "COMMENT", w = "INDENT", b = "INVALID", E = "NUMBER", _ = "COMMA", S = [ f, m, E ];
 class T {
  constructor(e, t = "lockfile") {
   this.comments = [], this.tokens = function* s(e) {
    function t(e, t) {
     return {
      line: r,
      col: i,
      type: e,
      value: t
     };
    }
    let s = !1, r = 1, i = 0;
    for (;e.length; ) {
     let n = 0;
     if ("\n" === e[0] || "\r" === e[0]) n++, "\n" === e[1] && n++, r++, i = 0, yield t(y); else if ("#" === e[0]) {
      n++;
      let s = "";
      for (;"\n" !== e[n]; ) s += e[n], n++;
      yield t(v, s);
     } else if (" " === e[0]) if (s) {
      let s = "";
      for (let t = 0; " " === e[t]; t++) s += e[t];
      if (s.length % 2) throw new TypeError("Invalid number of spaces");
      n = s.length, yield t(w, s.length / 2);
     } else n++; else if ('"' === e[0]) {
      let s = "";
      for (let t = 0; ;t++) {
       const r = e[t];
       if (s += r, t > 0 && '"' === r && ("\\" !== e[t - 1] || "\\" === e[t - 2])) break;
      }
      n = s.length;
      try {
       yield t(m, JSON.parse(s));
      } catch (e) {
       if (!(e instanceof SyntaxError)) throw e;
       yield t(b);
      }
     } else if (/^[0-9]/.test(e)) {
      let s = "";
      for (let t = 0; /^[0-9]$/.test(e[t]); t++) s += e[t];
      n = s.length, yield t(E, +s);
     } else if (/^true/.test(e)) yield t(f, !0), n = 4; else if (/^false/.test(e)) yield t(f, !1), 
     n = 5; else if (":" === e[0]) yield t(g), n++; else if ("," === e[0]) yield t(_), 
     n++; else if (/^[a-zA-Z\/-]/g.test(e)) {
      let s = "";
      for (let t = 0; t < e.length; t++) {
       const r = e[t];
       if (":" === r || " " === r || "\n" === r || "\r" === r || "," === r) break;
       s += r;
      }
      n = s.length, yield t(m, s);
     } else yield t(b);
     n || (yield t(b)), i += n, s = "\n" === e[0] || "\r" === e[0] && "\n" === e[1], 
     e = e.slice(n);
    }
    yield t("EOF");
   }(e), this.fileLoc = t;
  }
  onComment(e) {
   const t = e.value;
   (0, (l || r()).default)("string" == typeof t, "expected token value to be a string");
   const n = t.trim(), o = n.match(d);
   if (o) {
    const e = +o[1];
    if (e > (u || i()).LOCKFILE_VERSION) throw new ((h || function t() {
     return h = s(4);
    }()).MessageError)(`Can't install from a lockfile of version ${e} as you're on an old yarn version that only supports versions up to ${(u || i()).LOCKFILE_VERSION}. Run \`$ yarn self-update\` to upgrade to the latest version.`);
   }
   this.comments.push(n);
  }
  next() {
   const e = this.tokens.next();
   (0, (l || r()).default)(e, "expected a token");
   const t = e.done, s = e.value;
   if (t || !s) throw new Error("No more tokens");
   return s.type === v ? (this.onComment(s), this.next()) : this.token = s;
  }
  unexpected(e = "Unexpected token") {
   throw new SyntaxError(`${e} ${this.token.line}:${this.token.col} in ${this.fileLoc}`);
  }
  expect(e) {
   this.token.type === e ? this.next() : this.unexpected();
  }
  eat(e) {
   return this.token.type === e && (this.next(), !0);
  }
  parse(e = 0) {
   var t, i, o, c, u, h, d, f, v;
   const b = (0, (p || function E() {
    return p = n(s(20));
   }()).default)();
   for (;;) {
    const p = this.token;
    if (p.type === y) {
     const t = this.next();
     if (!e) continue;
     if (t.type !== w) break;
     if (t.value !== e) break;
     this.next();
    } else if (p.type === w) {
     if (p.value !== e) break;
     this.next();
    } else {
     if ("EOF" === p.type) break;
     if (p.type === m) {
      const s = p.value;
      (0, (l || r()).default)(s, "Expected a key");
      const n = [ s ];
      for (this.next(); this.token.type === _; ) {
       this.next();
       const e = this.token;
       e.type !== m && this.unexpected("Expected string");
       const t = e.value;
       (0, (l || r()).default)(t, "Expected a key"), n.push(t), this.next();
      }
      const a = this.token;
      if (a.type === g) {
       this.next();
       const s = this.parse(e + 1);
       for (t = n, o = 0, t = (i = Array.isArray(t)) ? t : t[Symbol.iterator](); ;) {
        if (i) {
         if (o >= t.length) break;
         c = t[o++];
        } else {
         if ((o = t.next()).done) break;
         c = o.value;
        }
        b[c] = s;
       }
       if (e && this.token.type !== w) break;
      } else if (v = a, S.indexOf(v.type) >= 0) {
       for (u = n, d = 0, u = (h = Array.isArray(u)) ? u : u[Symbol.iterator](); ;) {
        if (h) {
         if (d >= u.length) break;
         f = u[d++];
        } else {
         if ((d = u.next()).done) break;
         f = d.value;
        }
        b[f] = a.value;
       }
       this.next();
      } else this.unexpected("Invalid value type");
     } else this.unexpected(`Unknown token: ${(a || (a = n(s(2)))).default.inspect(p)}`);
    }
   }
   return b;
  }
 }
 const x = "|||||||", $ = ">>>>>>>", C = "=======", A = "<<<<<<<";
}, , , function(e, t, s) {
 function r() {
  return i = function e(t) {
   return t && t.__esModule ? t : {
    default: t
   };
  }(s(20));
 }
 var i;
 Object.defineProperty(t, "__esModule", {
  value: !0
 });
 const n = s(212)("yarn");
 t.default = class o {
  constructor(e, t = 1 / 0) {
   this.concurrencyQueue = [], this.maxConcurrency = t, this.runningCount = 0, this.warnedStuck = !1, 
   this.alias = e, this.first = !0, this.running = (0, (i || r()).default)(), this.queue = (0, 
   (i || r()).default)(), this.stuckTick = this.stuckTick.bind(this);
  }
  stillActive() {
   this.stuckTimer && clearTimeout(this.stuckTimer), this.stuckTimer = setTimeout(this.stuckTick, 5e3), 
   this.stuckTimer.unref && this.stuckTimer.unref();
  }
  stuckTick() {
   1 === this.runningCount && (this.warnedStuck = !0, n(`The ${JSON.stringify(this.alias)} blocking queue may be stuck. 5 seconds without any activity with 1 worker: ${Object.keys(this.running)[0]}`));
  }
  push(e, t) {
   return this.first ? this.first = !1 : this.stillActive(), new Promise(((s, r) => {
    (this.queue[e] = this.queue[e] || []).push({
     factory: t,
     resolve: s,
     reject: r
    }), this.running[e] || this.shift(e);
   }));
  }
  shift(e) {
   this.running[e] && (delete this.running[e], this.runningCount--, this.stuckTimer && (clearTimeout(this.stuckTimer), 
   this.stuckTimer = null), this.warnedStuck && (this.warnedStuck = !1, n(`${JSON.stringify(this.alias)} blocking queue finally resolved. Nothing to worry about.`)));
   const t = this.queue[e];
   if (!t) return;
   var s = t.shift();
   const r = s.resolve, i = s.reject, o = s.factory;
   t.length || delete this.queue[e];
   const a = () => {
    this.shift(e), this.shiftConcurrencyQueue();
   };
   this.maybePushConcurrencyQueue((() => {
    this.running[e] = !0, this.runningCount++, o().then((function(e) {
     return r(e), a(), null;
    })).catch((function(e) {
     i(e), a();
    }));
   }));
  }
  maybePushConcurrencyQueue(e) {
   this.runningCount < this.maxConcurrency ? e() : this.concurrencyQueue.push(e);
  }
  shiftConcurrencyQueue() {
   if (this.runningCount < this.maxConcurrency) {
    const e = this.concurrencyQueue.shift();
    e && e();
   }
  }
 };
}, function(e, t) {
 e.exports = function(e) {
  try {
   return !!e();
  } catch (e) {
   return !0;
  }
 };
}, , , , , , , , , , , , , , , function(e, t, s) {
 var r = s(47), i = s(13)("toStringTag"), n = "Arguments" == r(function() {
  return arguments;
 }());
 e.exports = function(e) {
  var t, s, o;
  return void 0 === e ? "Undefined" : null === e ? "Null" : "string" == typeof (s = function(e, t) {
   try {
    return e[t];
   } catch (e) {}
  }(t = Object(e), i)) ? s : n ? r(t) : "Object" == (o = r(t)) && "function" == typeof t.callee ? "Arguments" : o;
 };
}, function(e, t) {
 e.exports = "constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",");
}, function(e, t, s) {
 var r = s(11).document;
 e.exports = r && r.documentElement;
}, function(e, t, s) {
 var r = s(69), i = s(41), n = s(197), o = s(31), a = s(35), l = s(188), c = s(71), u = s(194), h = s(13)("iterator"), p = !([].keys && "next" in [].keys()), d = "keys", f = "values", m = function() {
  return this;
 };
 e.exports = function(e, t, s, g, y, v, w) {
  var b, E, _, S, T, x, $, C, A, k, D, P;
  if (l(s, t, g), b = function(e) {
   if (!p && e in T) return T[e];
   switch (e) {
   case d:
    return function t() {
     return new s(this, e);
    };

   case f:
    return function t() {
     return new s(this, e);
    };
   }
   return function t() {
    return new s(this, e);
   };
  }, E = t + " Iterator", _ = y == f, S = !1, T = e.prototype, $ = (x = T[h] || T["@@iterator"] || y && T[y]) || b(y), 
  C = y ? _ ? b("entries") : $ : void 0, (A = "Array" == t && T.entries || x) && (P = u(A.call(new e))) !== Object.prototype && P.next && (c(P, E, !0), 
  r || "function" == typeof P[h] || o(P, h, m)), _ && x && x.name !== f && (S = !0, 
  $ = function e() {
   return x.call(this);
  }), r && !w || !p && !S && T[h] || o(T, h, $), a[t] = $, a[E] = m, y) if (k = {
   values: _ ? $ : b(f),
   keys: v ? $ : b(d),
   entries: C
  }, w) for (D in k) D in T || n(T, D, k[D]); else i(i.P + i.F * (p || S), t, k);
  return k;
 };
}, function(e, t) {
 e.exports = function(e) {
  try {
   return {
    e: !1,
    v: e()
   };
  } catch (e) {
   return {
    e: !0,
    v: e
   };
  }
 };
}, function(e, t, s) {
 var r = s(27), i = s(34), n = s(70);
 e.exports = function(e, t) {
  var s;
  return r(e), i(t) && t.constructor === e ? t : ((0, (s = n.f(e)).resolve)(t), s.promise);
 };
}, function(e, t) {
 e.exports = function(e, t) {
  return {
   enumerable: !(1 & e),
   configurable: !(2 & e),
   writable: !(4 & e),
   value: t
  };
 };
}, function(e, t, s) {
 var r = s(23), i = s(11), n = "__core-js_shared__", o = i[n] || (i[n] = {});
 (e.exports = function(e, t) {
  return o[e] || (o[e] = void 0 !== t ? t : {});
 })("versions", []).push({
  version: r.version,
  mode: s(69) ? "pure" : "global",
  copyright: "© 2018 Denis Pushkarev (zloirock.ru)"
 });
}, function(e, t, s) {
 var r = s(27), i = s(46), n = s(13)("species");
 e.exports = function(e, t) {
  var s, o = r(e).constructor;
  return void 0 === o || null == (s = r(o)[n]) ? t : i(s);
 };
}, function(e, t, s) {
 var r, i, n, o = s(48), a = s(185), l = s(102), c = s(68), u = s(11), h = u.process, p = u.setImmediate, d = u.clearImmediate, f = u.MessageChannel, m = u.Dispatch, g = 0, y = {}, v = "onreadystatechange", w = function() {
  var e, t = +this;
  y.hasOwnProperty(t) && (e = y[t], delete y[t], e());
 }, b = function(e) {
  w.call(e.data);
 };
 p && d || (p = function e(t) {
  for (var s = [], i = 1; arguments.length > i; ) s.push(arguments[i++]);
  return y[++g] = function() {
   a("function" == typeof t ? t : Function(t), s);
  }, r(g), g;
 }, d = function e(t) {
  delete y[t];
 }, "process" == s(47)(h) ? r = function(e) {
  h.nextTick(o(w, e, 1));
 } : m && m.now ? r = function(e) {
  m.now(o(w, e, 1));
 } : f ? (n = (i = new f).port2, i.port1.onmessage = b, r = o(n.postMessage, n, 1)) : u.addEventListener && "function" == typeof postMessage && !u.importScripts ? (r = function(e) {
  u.postMessage(e + "", "*");
 }, u.addEventListener("message", b, !1)) : r = v in c("script") ? function(e) {
  l.appendChild(c("script"))[v] = function() {
   l.removeChild(this), w.call(e);
  };
 } : function(e) {
  setTimeout(o(w, e, 1), 0);
 }), e.exports = {
  set: p,
  clear: d
 };
}, function(e, t, s) {
 var r = s(73), i = Math.min;
 e.exports = function(e) {
  return e > 0 ? i(r(e), 9007199254740991) : 0;
 };
}, function(e, t) {
 var s = 0, r = Math.random();
 e.exports = function(e) {
  return "Symbol(".concat(void 0 === e ? "" : e, ")_", (++s + r).toString(36));
 };
}, function(e, t, s) {
 function r(e) {
  function s() {
   var e, i, n, o, a, l;
   if (s.enabled) {
    for (e = s, n = (i = +new Date) - (r || i), e.diff = n, e.prev = r, e.curr = i, 
    r = i, o = new Array(arguments.length), a = 0; a < o.length; a++) o[a] = arguments[a];
    o[0] = t.coerce(o[0]), "string" != typeof o[0] && o.unshift("%O"), l = 0, o[0] = o[0].replace(/%([a-zA-Z%])/g, (function(s, r) {
     var i, n;
     return "%%" === s || (l++, "function" == typeof (i = t.formatters[r]) && (n = o[l], 
     s = i.call(e, n), o.splice(l, 1), l--)), s;
    })), t.formatArgs.call(e, o), (s.log || t.log || console.log.bind(console)).apply(e, o);
   }
  }
  var r;
  return s.namespace = e, s.enabled = t.enabled(e), s.useColors = t.useColors(), s.color = function n(e) {
   var s, r = 0;
   for (s in e) r = (r << 5) - r + e.charCodeAt(s), r |= 0;
   return t.colors[Math.abs(r) % t.colors.length];
  }(e), s.destroy = i, "function" == typeof t.init && t.init(s), t.instances.push(s), 
  s;
 }
 function i() {
  var e = t.instances.indexOf(this);
  return -1 !== e && (t.instances.splice(e, 1), !0);
 }
 (t = e.exports = r.debug = r.default = r).coerce = function n(e) {
  return e instanceof Error ? e.stack || e.message : e;
 }, t.disable = function o() {
  t.enable("");
 }, t.enable = function a(e) {
  var s, r, i, n;
  for (t.save(e), t.names = [], t.skips = [], i = (r = ("string" == typeof e ? e : "").split(/[\s,]+/)).length, 
  s = 0; s < i; s++) r[s] && ("-" === (e = r[s].replace(/\*/g, ".*?"))[0] ? t.skips.push(new RegExp("^" + e.substr(1) + "$")) : t.names.push(new RegExp("^" + e + "$")));
  for (s = 0; s < t.instances.length; s++) (n = t.instances[s]).enabled = t.enabled(n.namespace);
 }, t.enabled = function l(e) {
  if ("*" === e[e.length - 1]) return !0;
  var s, r;
  for (s = 0, r = t.skips.length; s < r; s++) if (t.skips[s].test(e)) return !1;
  for (s = 0, r = t.names.length; s < r; s++) if (t.names[s].test(e)) return !0;
  return !1;
 }, t.humanize = s(229), t.instances = [], t.names = [], t.skips = [], t.formatters = {};
}, , function(e, t, s) {
 function r(e) {
  return e && "realpath" === e.syscall && ("ELOOP" === e.code || "ENOMEM" === e.code || "ENAMETOOLONG" === e.code);
 }
 function i(e, t, s) {
  if (u) return a(e, t, s);
  "function" == typeof t && (s = t, t = null), a(e, t, (function(i, n) {
   r(i) ? h.realpath(e, t, s) : s(i, n);
  }));
 }
 function n(e, t) {
  if (u) return l(e, t);
  try {
   return l(e, t);
  } catch (s) {
   if (r(s)) return h.realpathSync(e, t);
   throw s;
  }
 }
 var o, a, l, c, u, h;
 e.exports = i, i.realpath = i, i.sync = n, i.realpathSync = n, i.monkeypatch = function p() {
  o.realpath = i, o.realpathSync = n;
 }, i.unmonkeypatch = function d() {
  o.realpath = a, o.realpathSync = l;
 }, o = s(3), a = o.realpath, l = o.realpathSync, c = process.version, u = /^v[0-5]\./.test(c), 
 h = s(217);
}, function(e, t, s) {
 function r(e, t) {
  return Object.prototype.hasOwnProperty.call(e, t);
 }
 function i(e, t) {
  return e.toLowerCase().localeCompare(t.toLowerCase());
 }
 function n(e, t) {
  return e.localeCompare(t);
 }
 function o(e) {
  var t, s = null;
  return "/**" === e.slice(-3) && (t = e.replace(/(\/\*\*)+$/, ""), s = new p(t, {
   dot: !0
  })), {
   matcher: new p(e, {
    dot: !0
   }),
   gmatcher: s
  };
 }
 function a(e, t) {
  var s = t;
  return s = "/" === t.charAt(0) ? c.join(e.root, t) : h(t) || "" === t ? t : e.changedCwd ? c.resolve(e.cwd, t) : c.resolve(t), 
  "win32" === process.platform && (s = s.replace(/\\/g, "/")), s;
 }
 function l(e, t) {
  return !!e.ignore.length && e.ignore.some((function(e) {
   return e.matcher.match(t) || !(!e.gmatcher || !e.gmatcher.match(t));
  }));
 }
 var c, u, h, p;
 t.alphasort = n, t.alphasorti = i, t.setopts = function d(e, t, s) {
  if (s || (s = {}), s.matchBase && -1 === t.indexOf("/")) {
   if (s.noglobstar) throw new Error("base matching requires globstar");
   t = "**/" + t;
  }
  e.silent = !!s.silent, e.pattern = t, e.strict = !1 !== s.strict, e.realpath = !!s.realpath, 
  e.realpathCache = s.realpathCache || Object.create(null), e.follow = !!s.follow, 
  e.dot = !!s.dot, e.mark = !!s.mark, e.nodir = !!s.nodir, e.nodir && (e.mark = !0), 
  e.sync = !!s.sync, e.nounique = !!s.nounique, e.nonull = !!s.nonull, e.nosort = !!s.nosort, 
  e.nocase = !!s.nocase, e.stat = !!s.stat, e.noprocess = !!s.noprocess, e.absolute = !!s.absolute, 
  e.maxLength = s.maxLength || 1 / 0, e.cache = s.cache || Object.create(null), e.statCache = s.statCache || Object.create(null), 
  e.symlinks = s.symlinks || Object.create(null), function i(e, t) {
   e.ignore = t.ignore || [], Array.isArray(e.ignore) || (e.ignore = [ e.ignore ]), 
   e.ignore.length && (e.ignore = e.ignore.map(o));
  }(e, s), e.changedCwd = !1;
  var n = process.cwd();
  r(s, "cwd") ? (e.cwd = c.resolve(s.cwd), e.changedCwd = e.cwd !== n) : e.cwd = n, 
  e.root = s.root || c.resolve(e.cwd, "/"), e.root = c.resolve(e.root), "win32" === process.platform && (e.root = e.root.replace(/\\/g, "/")), 
  e.cwdAbs = h(e.cwd) ? e.cwd : a(e, e.cwd), "win32" === process.platform && (e.cwdAbs = e.cwdAbs.replace(/\\/g, "/")), 
  e.nomount = !!s.nomount, s.nonegate = !0, s.nocomment = !0, e.minimatch = new p(t, s), 
  e.options = e.minimatch.options;
 }, t.ownProp = r, t.makeAbs = a, t.finish = function f(e) {
  var t, s, r, o, c, u = e.nounique, h = u ? [] : Object.create(null);
  for (t = 0, s = e.matches.length; t < s; t++) (r = e.matches[t]) && 0 !== Object.keys(r).length ? (c = Object.keys(r), 
  u ? h.push.apply(h, c) : c.forEach((function(e) {
   h[e] = !0;
  }))) : e.nonull && (o = e.minimatch.globSet[t], u ? h.push(o) : h[o] = !0);
  if (u || (h = Object.keys(h)), e.nosort || (h = h.sort(e.nocase ? i : n)), e.mark) {
   for (t = 0; t < h.length; t++) h[t] = e._mark(h[t]);
   e.nodir && (h = h.filter((function(t) {
    var s = !/\/$/.test(t), r = e.cache[t] || e.cache[a(e, t)];
    return s && r && (s = "DIR" !== r && !Array.isArray(r)), s;
   })));
  }
  e.ignore.length && (h = h.filter((function(t) {
   return !l(e, t);
  }))), e.found = h;
 }, t.mark = function m(e, t) {
  var s, r, i, n = a(e, t), o = e.cache[n], l = t;
  return o && (s = "DIR" === o || Array.isArray(o), r = "/" === t.slice(-1), s && !r ? l += "/" : !s && r && (l = l.slice(0, -1)), 
  l !== t && (i = a(e, l), e.statCache[i] = e.statCache[n], e.cache[i] = e.cache[n])), 
  l;
 }, t.isIgnored = l, t.childrenIgnored = function g(e, t) {
  return !!e.ignore.length && e.ignore.some((function(e) {
   return !(!e.gmatcher || !e.gmatcher.match(t));
  }));
 }, c = s(0), u = s(60), h = s(76), p = u.Minimatch;
}, function(e, t, s) {
 function r(e, t, s, a) {
  var l, c, u;
  "function" == typeof t ? (s = t, t = {}) : t && "object" == typeof t || (t = {
   mode: t
  }), l = t.mode, c = t.fs || n, void 0 === l && (l = o & ~process.umask()), a || (a = null), 
  u = s || function() {}, e = i.resolve(e), c.mkdir(e, l, (function(s) {
   if (!s) return u(null, a = a || e);
   "ENOENT" === s.code ? r(i.dirname(e), t, (function(s, i) {
    s ? u(s, i) : r(e, t, u, i);
   })) : c.stat(e, (function(e, t) {
    e || !t.isDirectory() ? u(s, a) : u(null, a);
   }));
  }));
 }
 var i = s(0), n = s(3), o = parseInt("0777", 8);
 e.exports = r.mkdirp = r.mkdirP = r, r.sync = function e(t, s, r) {
  var a, l, c;
  s && "object" == typeof s || (s = {
   mode: s
  }), a = s.mode, l = s.fs || n, void 0 === a && (a = o & ~process.umask()), r || (r = null), 
  t = i.resolve(t);
  try {
   l.mkdirSync(t, a), r = r || t;
  } catch (n) {
   if ("ENOENT" === n.code) r = e(i.dirname(t), s, r), e(t, s, r); else {
    try {
     c = l.statSync(t);
    } catch (e) {
     throw n;
    }
    if (!c.isDirectory()) throw n;
   }
  }
  return r;
 };
}, , , , , , function(e, t, s) {
 e.exports = e => {
  if ("string" != typeof e) throw new TypeError("Expected a string, got " + typeof e);
  return 65279 === e.charCodeAt(0) ? e.slice(1) : e;
 };
}, function(e, t) {
 e.exports = function e(t, s) {
  function r() {
   var e, s, r, i = new Array(arguments.length);
   for (e = 0; e < i.length; e++) i[e] = arguments[e];
   return s = t.apply(this, i), r = i[i.length - 1], "function" == typeof s && s !== r && Object.keys(r).forEach((function(e) {
    s[e] = r[e];
   })), s;
  }
  if (t && s) return e(t)(s);
  if ("function" != typeof t) throw new TypeError("need wrapper function");
  return Object.keys(t).forEach((function(e) {
   r[e] = t[e];
  })), r;
 };
}, , , , , , , , function(e, t, s) {
 var r = s(47);
 e.exports = Object("z").propertyIsEnumerable(0) ? Object : function(e) {
  return "String" == r(e) ? e.split("") : Object(e);
 };
}, function(e, t, s) {
 var r = s(195), i = s(101);
 e.exports = Object.keys || function e(t) {
  return r(t, i);
 };
}, function(e, t, s) {
 var r = s(67);
 e.exports = function(e) {
  return Object(r(e));
 };
}, , , , , , , , , , , , function(e, t) {
 e.exports = {
  name: "yarn",
  installationMethod: "unknown",
  version: "1.10.0-0",
  license: "BSD-2-Clause",
  preferGlobal: !0,
  description: "📦🐈 Fast, reliable, and secure dependency management.",
  dependencies: {
   "@zkochan/cmd-shim": "^2.2.4",
   "babel-runtime": "^6.26.0",
   bytes: "^3.0.0",
   camelcase: "^4.0.0",
   chalk: "^2.1.0",
   commander: "^2.9.0",
   death: "^1.0.0",
   debug: "^3.0.0",
   "deep-equal": "^1.0.1",
   "detect-indent": "^5.0.0",
   dnscache: "^1.0.1",
   glob: "^7.1.1",
   "gunzip-maybe": "^1.4.0",
   "hash-for-dep": "^1.2.3",
   "imports-loader": "^0.8.0",
   ini: "^1.3.4",
   inquirer: "^3.0.1",
   invariant: "^2.2.0",
   "is-builtin-module": "^2.0.0",
   "is-ci": "^1.0.10",
   "is-webpack-bundle": "^1.0.0",
   leven: "^2.0.0",
   "loud-rejection": "^1.2.0",
   micromatch: "^2.3.11",
   mkdirp: "^0.5.1",
   "node-emoji": "^1.6.1",
   "normalize-url": "^2.0.0",
   "npm-logical-tree": "^1.2.1",
   "object-path": "^0.11.2",
   "proper-lockfile": "^2.0.0",
   puka: "^1.0.0",
   read: "^1.0.7",
   request: "^2.87.0",
   "request-capture-har": "^1.2.2",
   rimraf: "^2.5.0",
   semver: "^5.1.0",
   ssri: "^5.3.0",
   "strip-ansi": "^4.0.0",
   "strip-bom": "^3.0.0",
   "tar-fs": "^1.16.0",
   "tar-stream": "^1.6.1",
   uuid: "^3.0.1",
   "v8-compile-cache": "^2.0.0",
   "validate-npm-package-license": "^3.0.3",
   yn: "^2.0.0"
  },
  devDependencies: {
   "babel-core": "^6.26.0",
   "babel-eslint": "^7.2.3",
   "babel-loader": "^6.2.5",
   "babel-plugin-array-includes": "^2.0.3",
   "babel-plugin-transform-builtin-extend": "^1.1.2",
   "babel-plugin-transform-inline-imports-commonjs": "^1.0.0",
   "babel-plugin-transform-runtime": "^6.4.3",
   "babel-preset-env": "^1.6.0",
   "babel-preset-flow": "^6.23.0",
   "babel-preset-stage-0": "^6.0.0",
   babylon: "^6.5.0",
   commitizen: "^2.9.6",
   "cz-conventional-changelog": "^2.0.0",
   eslint: "^4.3.0",
   "eslint-config-fb-strict": "^22.0.0",
   "eslint-plugin-babel": "^5.0.0",
   "eslint-plugin-flowtype": "^2.35.0",
   "eslint-plugin-jasmine": "^2.6.2",
   "eslint-plugin-jest": "^21.0.0",
   "eslint-plugin-jsx-a11y": "^6.0.2",
   "eslint-plugin-prefer-object-spread": "^1.2.1",
   "eslint-plugin-prettier": "^2.1.2",
   "eslint-plugin-react": "^7.1.0",
   "eslint-plugin-relay": "^0.0.24",
   "eslint-plugin-yarn-internal": "file:scripts/eslint-rules",
   execa: "^0.10.0",
   "flow-bin": "^0.66.0",
   "git-release-notes": "^3.0.0",
   gulp: "^3.9.0",
   "gulp-babel": "^7.0.0",
   "gulp-if": "^2.0.1",
   "gulp-newer": "^1.0.0",
   "gulp-plumber": "^1.0.1",
   "gulp-sourcemaps": "^2.2.0",
   "gulp-util": "^3.0.7",
   "gulp-watch": "^5.0.0",
   jest: "^22.4.4",
   jsinspect: "^0.12.6",
   minimatch: "^3.0.4",
   "mock-stdin": "^0.3.0",
   prettier: "^1.5.2",
   temp: "^0.8.3",
   webpack: "^2.1.0-beta.25",
   yargs: "^6.3.0"
  },
  resolutions: {
   sshpk: "^1.14.2"
  },
  engines: {
   node: ">=4.0.0"
  },
  repository: "yarnpkg/yarn",
  bin: {
   yarn: "./bin/yarn.js",
   yarnpkg: "./bin/yarn.js"
  },
  scripts: {
   build: "gulp build",
   "build-bundle": "node ./scripts/build-webpack.js",
   "build-chocolatey": "powershell ./scripts/build-chocolatey.ps1",
   "build-deb": "./scripts/build-deb.sh",
   "build-dist": "bash ./scripts/build-dist.sh",
   "build-win-installer": "scripts\\build-windows-installer.bat",
   changelog: "git-release-notes $(git describe --tags --abbrev=0 $(git describe --tags --abbrev=0)^)..$(git describe --tags --abbrev=0) scripts/changelog.md",
   "dupe-check": "yarn jsinspect ./src",
   lint: "eslint . && flow check",
   "pkg-tests": "yarn --cwd packages/pkg-tests jest yarn.test.js",
   prettier: "eslint src __tests__ --fix",
   "release-branch": "./scripts/release-branch.sh",
   test: "yarn lint && yarn test-only",
   "test-only": "node --max_old_space_size=4096 node_modules/jest/bin/jest.js --verbose",
   "test-only-debug": "node --inspect-brk --max_old_space_size=4096 node_modules/jest/bin/jest.js --runInBand --verbose",
   "test-coverage": "node --max_old_space_size=4096 node_modules/jest/bin/jest.js --coverage --verbose",
   watch: "gulp watch",
   commit: "git-cz"
  },
  jest: {
   collectCoverageFrom: [ "src/**/*.js" ],
   testEnvironment: "node",
   modulePathIgnorePatterns: [ "__tests__/fixtures/", "packages/pkg-tests/pkg-tests-fixtures", "dist/" ],
   testPathIgnorePatterns: [ "__tests__/(fixtures|__mocks__)/", "updates/", "_(temp|mock|install|init|helpers).js$", "packages/pkg-tests" ]
  },
  config: {
   commitizen: {
    path: "./node_modules/cz-conventional-changelog"
   }
  }
 };
}, , , , , function(e, t, s) {
 function r() {
  return a = s(12);
 }
 function i(e) {
  return "boolean" == typeof e || "number" == typeof e || function t(e) {
   return 0 === e.indexOf("true") || 0 === e.indexOf("false") || /[:\s\n\\",\[\]]/g.test(e) || /^[0-9]/g.test(e) || !/^[a-zA-Z]/g.test(e);
  }(e) ? JSON.stringify(e) : e;
 }
 function n(e, t) {
  return p[e] || p[t] ? (p[e] || 100) > (p[t] || 100) ? 1 : -1 : (0, (a || r()).sortAlpha)(e, t);
 }
 function o(e, t) {
  if ("object" != typeof e) throw new TypeError;
  const s = t.indent, l = [], c = Object.keys(e).sort(n);
  let u = [];
  for (let n = 0; n < c.length; n++) {
   const h = c[n], p = e[h];
   if (null == p || u.indexOf(h) >= 0) continue;
   const d = [ h ];
   if ("object" == typeof p) for (let t = n + 1; t < c.length; t++) {
    const s = c[t];
    p === e[s] && d.push(s);
   }
   const f = d.sort((a || r()).sortAlpha).map(i).join(", ");
   if ("string" == typeof p || "boolean" == typeof p || "number" == typeof p) l.push(`${f} ${i(p)}`); else {
    if ("object" != typeof p) throw new TypeError;
    l.push(`${f}:\n${o(p, {
     indent: s + "  "
    })}` + (t.topLevel ? "\n" : ""));
   }
   u = u.concat(d);
  }
  return s + l.join(`\n${s}`);
 }
 var a, l, c;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.default = function u(e, t, r) {
  const i = o(e, {
   indent: "",
   topLevel: !0
  });
  if (t) return i;
  const n = [];
  return n.push("# THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY."), 
  n.push(`# yarn lockfile v${(l || function a() {
   return l = s(6);
  }()).LOCKFILE_VERSION}`), r && (n.push(`# yarn v${(c || function u() {
   return c = s(145);
  }()).version}`), n.push(`# node ${h}`)), n.push("\n"), n.push(i), n.join("\n");
 };
 const h = process.version, p = {
  name: 1,
  version: 2,
  uid: 3,
  resolved: 4,
  integrity: 5,
  registry: 6,
  dependencies: 7
 };
}, , , , , , , , , , , , , , function(e, t, s) {
 function r() {
  return a = o(s(1));
 }
 function i() {
  return l = o(s(3));
 }
 function n() {
  return c = s(40);
 }
 function o(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 }
 var a, l, c, u, h, p;
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.fileDatesEqual = t.copyFile = t.unlink = void 0;
 let d, f = (u = (0, (a || r()).default)((function*(e, t, s) {
  const r = void 0 === e;
  let i = e || -1;
  if (void 0 === d) {
   const e = yield y(t);
   d = T(e.mtime, s.mtime);
  }
  if (!d) {
   if (r) try {
    i = yield v(t, "a", s.mode);
   } catch (e) {
    try {
     i = yield v(t, "r", s.mode);
    } catch (e) {
     return;
    }
   }
   try {
    i && (yield w(i, s.atime, s.mtime));
   } catch (e) {} finally {
    r && i && (yield g(i));
   }
  }
 })), function e(t, s, r) {
  return u.apply(this, arguments);
 });
 const m = (0, (c || n()).promisify)((l || i()).default.readFile), g = (0, (c || n()).promisify)((l || i()).default.close), y = (0, 
 (c || n()).promisify)((l || i()).default.lstat), v = (0, (c || n()).promisify)((l || i()).default.open), w = (0, 
 (c || n()).promisify)((l || i()).default.futimes), b = (0, (c || n()).promisify)((l || i()).default.write), E = t.unlink = (0, 
 (c || n()).promisify)(s(233));
 t.copyFile = (h = (0, (a || r()).default)((function*(e, t) {
  try {
   yield E(e.dest), yield _(e.src, e.dest, 0, e);
  } finally {
   t && t();
  }
 })), function e(t, s) {
  return h.apply(this, arguments);
 });
 const _ = (e, t, s, r) => (l || i()).default.copyFile ? new Promise(((n, o) => (l || i()).default.copyFile(e, t, s, (e => {
  e ? o(e) : f(void 0, t, r).then((() => n())).catch((e => o(e)));
 })))) : S(e, t, s, r), S = (p = (0, (a || r()).default)((function*(e, t, s, r) {
  const i = yield v(t, "w", r.mode);
  try {
   const s = yield m(e);
   yield b(i, s, 0, s.length), yield f(i, t, r);
  } finally {
   yield g(i);
  }
 })), function e(t, s, r, i) {
  return p.apply(this, arguments);
 }), T = t.fileDatesEqual = (e, t) => {
  const s = e.getTime(), r = t.getTime();
  if ("win32" !== process.platform) return s === r;
  if (Math.abs(s - r) <= 1) return !0;
  const i = Math.floor(s / 1e3), n = Math.floor(r / 1e3);
  return s - 1e3 * i == 0 || r - 1e3 * n == 0 ? i === n : s === r;
 };
}, , , , , function(e, t, s) {
 function r() {
  return Boolean(process.env.FAKEROOTKEY);
 }
 function i(e) {
  return 0 === e;
 }
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.isFakeRoot = r, t.isRootUser = i, t.default = i(function n() {
  return "win32" !== process.platform && process.getuid ? process.getuid() : null;
 }()) && !r();
}, , function(e, t, s) {
 function r() {
  return process.env.LOCALAPPDATA ? a.join(process.env.LOCALAPPDATA, "Yarn") : null;
 }
 Object.defineProperty(t, "__esModule", {
  value: !0
 }), t.getDataDir = function i() {
  if ("win32" === process.platform) {
   const e = r();
   return null == e ? c : a.join(e, "Data");
  }
  return process.env.XDG_DATA_HOME ? a.join(process.env.XDG_DATA_HOME, "yarn") : c;
 }, t.getCacheDir = function n() {
  return "win32" === process.platform ? a.join(r() || a.join(l, "AppData", "Local", "Yarn"), "Cache") : process.env.XDG_CACHE_HOME ? a.join(process.env.XDG_CACHE_HOME, "yarn") : "darwin" === process.platform ? a.join(l, "Library", "Caches", "Yarn") : u;
 }, t.getConfigDir = function o() {
  if ("win32" === process.platform) {
   const e = r();
   return null == e ? c : a.join(e, "Config");
  }
  return process.env.XDG_CONFIG_HOME ? a.join(process.env.XDG_CONFIG_HOME, "yarn") : c;
 };
 const a = s(0), l = s(45).default, c = a.join(l, ".config", "yarn"), u = a.join(l, ".cache", "yarn");
}, , function(e, t, s) {
 e.exports = {
  default: s(179),
  __esModule: !0
 };
}, function(e, t, s) {
 function r(e, t, s) {
  e instanceof RegExp && (e = i(e, s)), t instanceof RegExp && (t = i(t, s));
  var r = n(e, t, s);
  return r && {
   start: r[0],
   end: r[1],
   pre: s.slice(0, r[0]),
   body: s.slice(r[0] + e.length, r[1]),
   post: s.slice(r[1] + t.length)
  };
 }
 function i(e, t) {
  var s = t.match(e);
  return s ? s[0] : null;
 }
 function n(e, t, s) {
  var r, i, n, o, a, l = s.indexOf(e), c = s.indexOf(t, l + 1), u = l;
  if (l >= 0 && c > 0) {
   for (r = [], n = s.length; u >= 0 && !a; ) u == l ? (r.push(u), l = s.indexOf(e, u + 1)) : 1 == r.length ? a = [ r.pop(), c ] : ((i = r.pop()) < n && (n = i, 
   o = c), c = s.indexOf(t, u + 1)), u = l < c && l >= 0 ? l : c;
   r.length && (a = [ n, o ]);
  }
  return a;
 }
 e.exports = r, r.range = n;
}, function(e, t, s) {
 function r(e) {
  return parseInt(e, 10) == e ? parseInt(e, 10) : e.charCodeAt(0);
 }
 function i(e) {
  return e.split(h).join("\\").split(p).join("{").split(d).join("}").split(f).join(",").split(m).join(".");
 }
 function n(e) {
  var t, s, r, i, o, a, l;
  return e ? (t = [], (s = y("{", "}", e)) ? (r = s.pre, i = s.body, o = s.post, (a = r.split(","))[a.length - 1] += "{" + i + "}", 
  l = n(o), o.length && (a[a.length - 1] += l.shift(), a.push.apply(a, l)), t.push.apply(t, a), 
  t) : e.split(",")) : [ "" ];
 }
 function o(e) {
  return "{" + e + "}";
 }
 function a(e) {
  return /^-?0\d/.test(e);
 }
 function l(e, t) {
  return e <= t;
 }
 function c(e, t) {
  return e >= t;
 }
 function u(e, t) {
  var s, i, h, p, f, m, v, w, b, E, _, S, T, x, $, C, A, k, D, P, O, L = [], R = y("{", "}", e);
  if (!R || /\$$/.test(R.pre)) return [ e ];
  if (s = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(R.body), i = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(R.body), 
  h = s || i, p = R.body.indexOf(",") >= 0, !h && !p) return R.post.match(/,.*\}/) ? u(e = R.pre + "{" + R.body + d + R.post) : [ e ];
  if (h) f = R.body.split(/\.\./); else if (1 === (f = n(R.body)).length && 1 === (f = u(f[0], !1).map(o)).length) return (m = R.post.length ? u(R.post, !1) : [ "" ]).map((function(e) {
   return R.pre + f[0] + e;
  }));
  if (v = R.pre, m = R.post.length ? u(R.post, !1) : [ "" ], h) for (b = r(f[0]), 
  E = r(f[1]), _ = Math.max(f[0].length, f[1].length), S = 3 == f.length ? Math.abs(r(f[2])) : 1, 
  T = l, E < b && (S *= -1, T = c), x = f.some(a), w = [], $ = b; T($, E); $ += S) i ? "\\" === (C = String.fromCharCode($)) && (C = "") : (C = String($), 
  x && (A = _ - C.length) > 0 && (k = new Array(A + 1).join("0"), C = $ < 0 ? "-" + k + C.slice(1) : k + C)), 
  w.push(C); else w = g(f, (function(e) {
   return u(e, !1);
  }));
  for (D = 0; D < w.length; D++) for (P = 0; P < m.length; P++) O = v + w[D] + m[P], 
  (!t || h || O) && L.push(O);
  return L;
 }
 var h, p, d, f, m, g = s(178), y = s(174);
 e.exports = function v(e) {
  return e ? ("{}" === e.substr(0, 2) && (e = "\\{\\}" + e.substr(2)), u(function t(e) {
   return e.split("\\\\").join(h).split("\\{").join(p).split("\\}").join(d).split("\\,").join(f).split("\\.").join(m);
  }(e), !0).map(i)) : [];
 }, h = "\0SLASH" + Math.random() + "\0", p = "\0OPEN" + Math.random() + "\0", d = "\0CLOSE" + Math.random() + "\0", 
 f = "\0COMMA" + Math.random() + "\0", m = "\0PERIOD" + Math.random() + "\0";
}, function(e, t, s) {
 e.exports = function(e) {
  return 0 === (e = arguments.length > 1 ? Array.from(arguments).map((e => e.trim())).filter((e => e.length)).join("-") : e.trim()).length ? "" : 1 === e.length ? e.toLowerCase() : /^[a-z0-9]+$/.test(e) ? e : (e !== e.toLowerCase() && (e = function t(e) {
   let t = !1, s = !1, r = !1;
   for (let i = 0; i < e.length; i++) {
    const n = e[i];
    t && /[a-zA-Z]/.test(n) && n.toUpperCase() === n ? (e = e.substr(0, i) + "-" + e.substr(i), 
    t = !1, r = s, s = !0, i++) : s && r && /[a-zA-Z]/.test(n) && n.toLowerCase() === n ? (e = e.substr(0, i - 1) + "-" + e.substr(i - 1), 
    r = s, s = !1, t = !0) : (t = n.toLowerCase() === n, r = s, s = n.toUpperCase() === n);
   }
   return e;
  }(e)), e.replace(/^[_.\- ]+/, "").toLowerCase().replace(/[_.\- ]+(\w|$)/g, ((e, t) => t.toUpperCase())));
 };
}, , function(e, t) {
 e.exports = function(e, t) {
  var r, i, n = [];
  for (r = 0; r < e.length; r++) i = t(e[r], r), s(i) ? n.push.apply(n, i) : n.push(i);
  return n;
 };
 var s = Array.isArray || function(e) {
  return "[object Array]" === Object.prototype.toString.call(e);
 };
}, function(e, t, s) {
 s(205), s(207), s(210), s(206), s(208), s(209), e.exports = s(23).Promise;
}, function(e, t) {
 e.exports = function() {};
}, function(e, t) {
 e.exports = function(e, t, s, r) {
  if (!(e instanceof t) || void 0 !== r && r in e) throw TypeError(s + ": incorrect invocation!");
  return e;
 };
}, function(e, t, s) {
 var r = s(74), i = s(110), n = s(200);
 e.exports = function(e) {
  return function(t, s, o) {
   var a, l = r(t), c = i(l.length), u = n(o, c);
   if (e && s != s) {
    for (;c > u; ) if ((a = l[u++]) != a) return !0;
   } else for (;c > u; u++) if ((e || u in l) && l[u] === s) return e || u || 0;
   return !e && -1;
  };
 };
}, function(e, t, s) {
 var r = s(48), i = s(187), n = s(186), o = s(27), a = s(110), l = s(203), c = {}, u = {};
 (t = e.exports = function(e, t, s, h, p) {
  var d, f, m, g, y = p ? function() {
   return e;
  } : l(e), v = r(s, h, t ? 2 : 1), w = 0;
  if ("function" != typeof y) throw TypeError(e + " is not iterable!");
  if (n(y)) {
   for (d = a(e.length); d > w; w++) if ((g = t ? v(o(f = e[w])[0], f[1]) : v(e[w])) === c || g === u) return g;
  } else for (m = y.call(e); !(f = m.next()).done; ) if ((g = i(m, v, f.value, t)) === c || g === u) return g;
 }).BREAK = c, t.RETURN = u;
}, function(e, t, s) {
 e.exports = !s(33) && !s(85)((function() {
  return 7 != Object.defineProperty(s(68)("div"), "a", {
   get: function() {
    return 7;
   }
  }).a;
 }));
}, function(e, t) {
 e.exports = function(e, t, s) {
  var r = void 0 === s;
  switch (t.length) {
  case 0:
   return r ? e() : e.call(s);

  case 1:
   return r ? e(t[0]) : e.call(s, t[0]);

  case 2:
   return r ? e(t[0], t[1]) : e.call(s, t[0], t[1]);

  case 3:
   return r ? e(t[0], t[1], t[2]) : e.call(s, t[0], t[1], t[2]);

  case 4:
   return r ? e(t[0], t[1], t[2], t[3]) : e.call(s, t[0], t[1], t[2], t[3]);
  }
  return e.apply(s, t);
 };
}, function(e, t, s) {
 var r = s(35), i = s(13)("iterator"), n = Array.prototype;
 e.exports = function(e) {
  return void 0 !== e && (r.Array === e || n[i] === e);
 };
}, function(e, t, s) {
 var r = s(27);
 e.exports = function(e, t, s, i) {
  try {
   return i ? t(r(s)[0], s[1]) : t(s);
  } catch (t) {
   var n = e.return;
   throw void 0 !== n && r(n.call(e)), t;
  }
 };
}, function(e, t, s) {
 var r = s(192), i = s(106), n = s(71), o = {};
 s(31)(o, s(13)("iterator"), (function() {
  return this;
 })), e.exports = function(e, t, s) {
  e.prototype = r(o, {
   next: i(1, s)
  }), n(e, t + " Iterator");
 };
}, function(e, t, s) {
 var r, i = s(13)("iterator"), n = !1;
 try {
  (r = [ 7 ][i]()).return = function() {
   n = !0;
  }, Array.from(r, (function() {
   throw 2;
  }));
 } catch (e) {}
 e.exports = function(e, t) {
  var s, r, o;
  if (!t && !n) return !1;
  s = !1;
  try {
   (o = (r = [ 7 ])[i]()).next = function() {
    return {
     done: s = !0
    };
   }, r[i] = function() {
    return o;
   }, e(r);
  } catch (e) {}
  return s;
 };
}, function(e, t) {
 e.exports = function(e, t) {
  return {
   value: t,
   done: !!e
  };
 };
}, function(e, t, s) {
 var r = s(11), i = s(109).set, n = r.MutationObserver || r.WebKitMutationObserver, o = r.process, a = r.Promise, l = "process" == s(47)(o);
 e.exports = function() {
  var e, t, s, c, u, h, p = function() {
   var r, i;
   for (l && (r = o.domain) && r.exit(); e; ) {
    i = e.fn, e = e.next;
    try {
     i();
    } catch (r) {
     throw e ? s() : t = void 0, r;
    }
   }
   t = void 0, r && r.enter();
  };
  return l ? s = function() {
   o.nextTick(p);
  } : !n || r.navigator && r.navigator.standalone ? a && a.resolve ? (h = a.resolve(void 0), 
  s = function() {
   h.then(p);
  }) : s = function() {
   i.call(r, p);
  } : (c = !0, u = document.createTextNode(""), new n(p).observe(u, {
   characterData: !0
  }), s = function() {
   u.data = c = !c;
  }), function(r) {
   var i = {
    fn: r,
    next: void 0
   };
   t && (t.next = i), e || (e = i, s()), t = i;
  };
 };
}, function(e, t, s) {
 var r = s(27), i = s(193), n = s(101), o = s(72)("IE_PROTO"), a = function() {}, l = "prototype", c = function() {
  var e, t = s(68)("iframe"), r = n.length;
  for (t.style.display = "none", s(102).appendChild(t), t.src = "javascript:", (e = t.contentWindow.document).open(), 
  e.write("<script>document.F=Object<\/script>"), e.close(), c = e.F; r--; ) delete c[l][n[r]];
  return c();
 };
 e.exports = Object.create || function e(t, s) {
  var n;
  return null !== t ? (a[l] = r(t), n = new a, a[l] = null, n[o] = t) : n = c(), void 0 === s ? n : i(n, s);
 };
}, function(e, t, s) {
 var r = s(50), i = s(27), n = s(132);
 e.exports = s(33) ? Object.defineProperties : function e(t, s) {
  var o, a, l, c;
  for (i(t), a = (o = n(s)).length, l = 0; a > l; ) r.f(t, c = o[l++], s[c]);
  return t;
 };
}, function(e, t, s) {
 var r = s(49), i = s(133), n = s(72)("IE_PROTO"), o = Object.prototype;
 e.exports = Object.getPrototypeOf || function(e) {
  return e = i(e), r(e, n) ? e[n] : "function" == typeof e.constructor && e instanceof e.constructor ? e.constructor.prototype : e instanceof Object ? o : null;
 };
}, function(e, t, s) {
 var r = s(49), i = s(74), n = s(182)(!1), o = s(72)("IE_PROTO");
 e.exports = function(e, t) {
  var s, a = i(e), l = 0, c = [];
  for (s in a) s != o && r(a, s) && c.push(s);
  for (;t.length > l; ) r(a, s = t[l++]) && (~n(c, s) || c.push(s));
  return c;
 };
}, function(e, t, s) {
 var r = s(31);
 e.exports = function(e, t, s) {
  for (var i in t) s && e[i] ? e[i] = t[i] : r(e, i, t[i]);
  return e;
 };
}, function(e, t, s) {
 e.exports = s(31);
}, function(e, t, s) {
 var r = s(11), i = s(23), n = s(50), o = s(33), a = s(13)("species");
 e.exports = function(e) {
  var t = "function" == typeof i[e] ? i[e] : r[e];
  o && t && !t[a] && n.f(t, a, {
   configurable: !0,
   get: function() {
    return this;
   }
  });
 };
}, function(e, t, s) {
 var r = s(73), i = s(67);
 e.exports = function(e) {
  return function(t, s) {
   var n, o, a = String(i(t)), l = r(s), c = a.length;
   return l < 0 || l >= c ? e ? "" : void 0 : (n = a.charCodeAt(l)) < 55296 || n > 56319 || l + 1 === c || (o = a.charCodeAt(l + 1)) < 56320 || o > 57343 ? e ? a.charAt(l) : n : e ? a.slice(l, l + 2) : o - 56320 + (n - 55296 << 10) + 65536;
  };
 };
}, function(e, t, s) {
 var r = s(73), i = Math.max, n = Math.min;
 e.exports = function(e, t) {
  return (e = r(e)) < 0 ? i(e + t, 0) : n(e, t);
 };
}, function(e, t, s) {
 var r = s(34);
 e.exports = function(e, t) {
  if (!r(e)) return e;
  var s, i;
  if (t && "function" == typeof (s = e.toString) && !r(i = s.call(e))) return i;
  if ("function" == typeof (s = e.valueOf) && !r(i = s.call(e))) return i;
  if (!t && "function" == typeof (s = e.toString) && !r(i = s.call(e))) return i;
  throw TypeError("Can't convert object to primitive value");
 };
}, function(e, t, s) {
 var r = s(11).navigator;
 e.exports = r && r.userAgent || "";
}, function(e, t, s) {
 var r = s(100), i = s(13)("iterator"), n = s(35);
 e.exports = s(23).getIteratorMethod = function(e) {
  if (null != e) return e[i] || e["@@iterator"] || n[r(e)];
 };
}, function(e, t, s) {
 var r = s(180), i = s(190), n = s(35), o = s(74);
 e.exports = s(103)(Array, "Array", (function(e, t) {
  this._t = o(e), this._i = 0, this._k = t;
 }), (function() {
  var e = this._t, t = this._k, s = this._i++;
  return !e || s >= e.length ? (this._t = void 0, i(1)) : i(0, "keys" == t ? s : "values" == t ? e[s] : [ s, e[s] ]);
 }), "values"), n.Arguments = n.Array, r("keys"), r("values"), r("entries");
}, function(e, t) {}, function(e, t, s) {
 var r, i, n, o, a = s(69), l = s(11), c = s(48), u = s(100), h = s(41), p = s(34), d = s(46), f = s(181), m = s(183), g = s(108), y = s(109).set, v = s(191)(), w = s(70), b = s(104), E = s(202), _ = s(105), S = "Promise", T = l.TypeError, x = l.process, $ = x && x.versions, C = $ && $.v8 || "", A = l[S], k = "process" == u(x), D = function() {}, P = i = w.f, O = !!function() {
  var e, t;
  try {
   return t = ((e = A.resolve(1)).constructor = {})[s(13)("species")] = function(e) {
    e(D, D);
   }, (k || "function" == typeof PromiseRejectionEvent) && e.then(D) instanceof t && 0 !== C.indexOf("6.6") && -1 === E.indexOf("Chrome/66");
  } catch (e) {}
 }(), L = function(e) {
  var t;
  return !(!p(e) || "function" != typeof (t = e.then)) && t;
 }, R = function(e, t) {
  if (!e._n) {
   e._n = !0;
   var s = e._c;
   v((function() {
    for (var r = e._v, i = 1 == e._s, n = 0, o = function(t) {
     var s, n, o, a = i ? t.ok : t.fail, l = t.resolve, c = t.reject, u = t.domain;
     try {
      a ? (i || (2 == e._h && j(e), e._h = 1), !0 === a ? s = r : (u && u.enter(), s = a(r), 
      u && (u.exit(), o = !0)), s === t.promise ? c(T("Promise-chain cycle")) : (n = L(s)) ? n.call(s, l, c) : l(s)) : c(r);
     } catch (e) {
      u && !o && u.exit(), c(e);
     }
    }; s.length > n; ) o(s[n++]);
    e._c = [], e._n = !1, t && !e._h && N(e);
   }));
  }
 }, N = function(e) {
  y.call(l, (function() {
   var t, s, r, i = e._v, n = F(e);
   if (n && (t = b((function() {
    k ? x.emit("unhandledRejection", i, e) : (s = l.onunhandledrejection) ? s({
     promise: e,
     reason: i
    }) : (r = l.console) && r.error && r.error("Unhandled promise rejection", i);
   })), e._h = k || F(e) ? 2 : 1), e._a = void 0, n && t.e) throw t.v;
  }));
 }, F = function(e) {
  return 1 !== e._h && 0 === (e._a || e._c).length;
 }, j = function(e) {
  y.call(l, (function() {
   var t;
   k ? x.emit("rejectionHandled", e) : (t = l.onrejectionhandled) && t({
    promise: e,
    reason: e._v
   });
  }));
 }, I = function(e) {
  var t = this;
  t._d || (t._d = !0, (t = t._w || t)._v = e, t._s = 2, t._a || (t._a = t._c.slice()), 
  R(t, !0));
 }, M = function(e) {
  var t, s = this;
  if (!s._d) {
   s._d = !0, s = s._w || s;
   try {
    if (s === e) throw T("Promise can't be resolved itself");
    (t = L(e)) ? v((function() {
     var r = {
      _w: s,
      _d: !1
     };
     try {
      t.call(e, c(M, r, 1), c(I, r, 1));
     } catch (e) {
      I.call(r, e);
     }
    })) : (s._v = e, s._s = 1, R(s, !1));
   } catch (e) {
    I.call({
     _w: s,
     _d: !1
    }, e);
   }
  }
 };
 O || (A = function e(t) {
  f(this, A, S, "_h"), d(t), r.call(this);
  try {
   t(c(M, this, 1), c(I, this, 1));
  } catch (e) {
   I.call(this, e);
  }
 }, (r = function e(t) {
  this._c = [], this._a = void 0, this._s = 0, this._d = !1, this._v = void 0, this._h = 0, 
  this._n = !1;
 }).prototype = s(196)(A.prototype, {
  then: function e(t, s) {
   var r = P(g(this, A));
   return r.ok = "function" != typeof t || t, r.fail = "function" == typeof s && s, 
   r.domain = k ? x.domain : void 0, this._c.push(r), this._a && this._a.push(r), this._s && R(this, !1), 
   r.promise;
  },
  catch: function(e) {
   return this.then(void 0, e);
  }
 }), n = function() {
  var e = new r;
  this.promise = e, this.resolve = c(M, e, 1), this.reject = c(I, e, 1);
 }, w.f = P = function(e) {
  return e === A || e === o ? new n(e) : i(e);
 }), h(h.G + h.W + h.F * !O, {
  Promise: A
 }), s(71)(A, S), s(198)(S), o = s(23)[S], h(h.S + h.F * !O, S, {
  reject: function e(t) {
   var s = P(this);
   return (0, s.reject)(t), s.promise;
  }
 }), h(h.S + h.F * (a || !O), S, {
  resolve: function e(t) {
   return _(a && this === o ? A : this, t);
  }
 }), h(h.S + h.F * !(O && s(189)((function(e) {
  A.all(e).catch(D);
 }))), S, {
  all: function e(t) {
   var s = this, r = P(s), i = r.resolve, n = r.reject, o = b((function() {
    var e = [], r = 0, o = 1;
    m(t, !1, (function(t) {
     var a = r++, l = !1;
     e.push(void 0), o++, s.resolve(t).then((function(t) {
      l || (l = !0, e[a] = t, --o || i(e));
     }), n);
    })), --o || i(e);
   }));
   return o.e && n(o.v), r.promise;
  },
  race: function e(t) {
   var s = this, r = P(s), i = r.reject, n = b((function() {
    m(t, !1, (function(e) {
     s.resolve(e).then(r.resolve, i);
    }));
   }));
   return n.e && i(n.v), r.promise;
  }
 });
}, function(e, t, s) {
 var r = s(199)(!0);
 s(103)(String, "String", (function(e) {
  this._t = String(e), this._i = 0;
 }), (function() {
  var e, t = this._t, s = this._i;
  return s >= t.length ? {
   value: void 0,
   done: !0
  } : (e = r(t, s), this._i += e.length, {
   value: e,
   done: !1
  });
 }));
}, function(e, t, s) {
 var r = s(41), i = s(23), n = s(11), o = s(108), a = s(105);
 r(r.P + r.R, "Promise", {
  finally: function(e) {
   var t = o(this, i.Promise || n.Promise), s = "function" == typeof e;
   return this.then(s ? function(s) {
    return a(t, e()).then((function() {
     return s;
    }));
   } : e, s ? function(s) {
    return a(t, e()).then((function() {
     throw s;
    }));
   } : e);
  }
 });
}, function(e, t, s) {
 var r = s(41), i = s(70), n = s(104);
 r(r.S, "Promise", {
  try: function(e) {
   var t = i.f(this), s = n(e);
   return (s.e ? t.reject : t.resolve)(s.v), t.promise;
  }
 });
}, function(e, t, s) {
 var r, i, n, o, a, l, c, u, h;
 for (s(204), r = s(11), i = s(31), n = s(35), o = s(13)("toStringTag"), a = "CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,TextTrackList,TouchList".split(","), 
 l = 0; l < a.length; l++) (h = (u = r[c = a[l]]) && u.prototype) && !h[o] && i(h, o, c), 
 n[c] = n.Array;
}, function(e, t, s) {
 function r() {
  var e;
  try {
   e = t.storage.debug;
  } catch (e) {}
  return !e && "undefined" != typeof process && "env" in process && (e = process.env.DEBUG), 
  e;
 }
 (t = e.exports = s(112)).log = function i() {
  return "object" == typeof console && console.log && Function.prototype.apply.call(console.log, console, arguments);
 }, t.formatArgs = function n(e) {
  var s, r, i, n = this.useColors;
  e[0] = (n ? "%c" : "") + this.namespace + (n ? " %c" : " ") + e[0] + (n ? "%c " : " ") + "+" + t.humanize(this.diff), 
  n && (s = "color: " + this.color, e.splice(1, 0, s, "color: inherit"), r = 0, i = 0, 
  e[0].replace(/%[a-zA-Z%]/g, (function(e) {
   "%%" !== e && (r++, "%c" === e && (i = r));
  })), e.splice(i, 0, s));
 }, t.save = function o(e) {
  try {
   null == e ? t.storage.removeItem("debug") : t.storage.debug = e;
  } catch (e) {}
 }, t.load = r, t.useColors = function a() {
  return !("undefined" == typeof window || !window.process || "renderer" !== window.process.type) || ("undefined" == typeof navigator || !navigator.userAgent || !navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) && ("undefined" != typeof document && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || "undefined" != typeof window && window.console && (window.console.firebug || window.console.exception && window.console.table) || "undefined" != typeof navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || "undefined" != typeof navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
 }, t.storage = "undefined" != typeof chrome && void 0 !== chrome.storage ? chrome.storage.local : function l() {
  try {
   return window.localStorage;
  } catch (e) {}
 }(), t.colors = [ "#0000CC", "#0000FF", "#0033CC", "#0033FF", "#0066CC", "#0066FF", "#0099CC", "#0099FF", "#00CC00", "#00CC33", "#00CC66", "#00CC99", "#00CCCC", "#00CCFF", "#3300CC", "#3300FF", "#3333CC", "#3333FF", "#3366CC", "#3366FF", "#3399CC", "#3399FF", "#33CC00", "#33CC33", "#33CC66", "#33CC99", "#33CCCC", "#33CCFF", "#6600CC", "#6600FF", "#6633CC", "#6633FF", "#66CC00", "#66CC33", "#9900CC", "#9900FF", "#9933CC", "#9933FF", "#99CC00", "#99CC33", "#CC0000", "#CC0033", "#CC0066", "#CC0099", "#CC00CC", "#CC00FF", "#CC3300", "#CC3333", "#CC3366", "#CC3399", "#CC33CC", "#CC33FF", "#CC6600", "#CC6633", "#CC9900", "#CC9933", "#CCCC00", "#CCCC33", "#FF0000", "#FF0033", "#FF0066", "#FF0099", "#FF00CC", "#FF00FF", "#FF3300", "#FF3333", "#FF3366", "#FF3399", "#FF33CC", "#FF33FF", "#FF6600", "#FF6633", "#FF9900", "#FF9933", "#FFCC00", "#FFCC33" ], 
 t.formatters.j = function(e) {
  try {
   return JSON.stringify(e);
  } catch (e) {
   return "[UnexpectedJSONParseError]: " + e.message;
  }
 }, t.enable(r());
}, function(e, t, s) {
 "undefined" == typeof process || "renderer" === process.type ? e.exports = s(211) : e.exports = s(213);
}, function(e, t, s) {
 function r() {
  return process.env.DEBUG;
 }
 var i, n = s(79), o = s(2);
 (t = e.exports = s(112)).init = function a(e) {
  var s, r;
  for (e.inspectOpts = {}, s = Object.keys(t.inspectOpts), r = 0; r < s.length; r++) e.inspectOpts[s[r]] = t.inspectOpts[s[r]];
 }, t.log = function l() {
  return process.stderr.write(o.format.apply(o, arguments) + "\n");
 }, t.formatArgs = function c(e) {
  var s, r, i, n = this.namespace;
  this.useColors ? (i = "  " + (r = "[3" + ((s = this.color) < 8 ? s : "8;5;" + s)) + ";1m" + n + " [0m", 
  e[0] = i + e[0].split("\n").join("\n" + i), e.push(r + "m+" + t.humanize(this.diff) + "[0m")) : e[0] = function o() {
   return t.inspectOpts.hideDate ? "" : (new Date).toISOString() + " ";
  }() + n + " " + e[0];
 }, t.save = function u(e) {
  null == e ? delete process.env.DEBUG : process.env.DEBUG = e;
 }, t.load = r, t.useColors = function h() {
  return "colors" in t.inspectOpts ? Boolean(t.inspectOpts.colors) : n.isatty(process.stderr.fd);
 }, t.colors = [ 6, 2, 3, 4, 5, 1 ];
 try {
  (i = s(239)) && i.level >= 2 && (t.colors = [ 20, 21, 26, 27, 32, 33, 38, 39, 40, 41, 42, 43, 44, 45, 56, 57, 62, 63, 68, 69, 74, 75, 76, 77, 78, 79, 80, 81, 92, 93, 98, 99, 112, 113, 128, 129, 134, 135, 148, 149, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 178, 179, 184, 185, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 214, 215, 220, 221 ]);
 } catch (e) {}
 t.inspectOpts = Object.keys(process.env).filter((function(e) {
  return /^debug_/i.test(e);
 })).reduce((function(e, t) {
  var s = t.substring(6).toLowerCase().replace(/_([a-z])/g, (function(e, t) {
   return t.toUpperCase();
  })), r = process.env[t];
  return r = !!/^(yes|on|true|enabled)$/i.test(r) || !/^(no|off|false|disabled)$/i.test(r) && ("null" === r ? null : Number(r)), 
  e[s] = r, e;
 }), {}), t.formatters.o = function(e) {
  return this.inspectOpts.colors = this.useColors, o.inspect(e, this.inspectOpts).split("\n").map((function(e) {
   return e.trim();
  })).join(" ");
 }, t.formatters.O = function(e) {
  return this.inspectOpts.colors = this.useColors, o.inspect(e, this.inspectOpts);
 }, t.enable(r());
}, , , , function(e, t, s) {
 var r, i, n = s(0), o = "win32" === process.platform, a = s(3);
 n.normalize, r = o ? /(.*?)(?:[\/\\]+|$)/g : /(.*?)(?:[\/]+|$)/g, i = o ? /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/ : /^[\/]*/, 
 t.realpathSync = function e(t, s) {
  function l() {
   var e = i.exec(t);
   p = e[0].length, d = e[0], f = e[0], m = "", o && !h[f] && (a.lstatSync(f), h[f] = !0);
  }
  var c, u, h, p, d, f, m, g, y, v, w, b;
  if (t = n.resolve(t), s && Object.prototype.hasOwnProperty.call(s, t)) return s[t];
  for (c = t, u = {}, h = {}, l(); p < t.length; ) if (r.lastIndex = p, g = r.exec(t), 
  m = d, d += g[0], f = m + g[1], p = r.lastIndex, !(h[f] || s && s[f] === f)) {
   if (s && Object.prototype.hasOwnProperty.call(s, f)) y = s[f]; else {
    if (!(v = a.lstatSync(f)).isSymbolicLink()) {
     h[f] = !0, s && (s[f] = f);
     continue;
    }
    w = null, o || (b = v.dev.toString(32) + ":" + v.ino.toString(32), u.hasOwnProperty(b) && (w = u[b])), 
    null === w && (a.statSync(f), w = a.readlinkSync(f)), y = n.resolve(m, w), s && (s[f] = y), 
    o || (u[b] = w);
   }
   t = n.resolve(y, t.slice(p)), l();
  }
  return s && (s[c] = t), t;
 }, t.realpath = function e(t, s, l) {
  function c() {
   var e = i.exec(t);
   y = e[0].length, v = e[0], w = e[0], b = "", o && !g[w] ? a.lstat(w, (function(e) {
    if (e) return l(e);
    g[w] = !0, u();
   })) : process.nextTick(u);
  }
  function u() {
   if (y >= t.length) return s && (s[f] = t), l(null, t);
   r.lastIndex = y;
   var e = r.exec(t);
   return b = v, v += e[0], w = b + e[1], y = r.lastIndex, g[w] || s && s[w] === w ? process.nextTick(u) : s && Object.prototype.hasOwnProperty.call(s, w) ? d(s[w]) : a.lstat(w, h);
  }
  function h(e, t) {
   if (e) return l(e);
   if (!t.isSymbolicLink()) return g[w] = !0, s && (s[w] = w), process.nextTick(u);
   if (!o) {
    var r = t.dev.toString(32) + ":" + t.ino.toString(32);
    if (m.hasOwnProperty(r)) return p(null, m[r], w);
   }
   a.stat(w, (function(e) {
    if (e) return l(e);
    a.readlink(w, (function(e, t) {
     o || (m[r] = t), p(e, t);
    }));
   }));
  }
  function p(e, t, r) {
   if (e) return l(e);
   var i = n.resolve(b, t);
   s && (s[r] = i), d(i);
  }
  function d(e) {
   t = n.resolve(e, t.slice(y)), c();
  }
  var f, m, g, y, v, w, b;
  if ("function" != typeof l && (l = function E(e) {
   return "function" == typeof e ? e : function t() {
    return function e(t) {
     if (t) {
      if (process.throwDeprecation) throw t;
      if (!process.noDeprecation) {
       var s = "fs: missing callback " + (t.stack || t.message);
       process.traceDeprecation ? console.trace(s) : console.error(s);
      }
     }
    };
   }();
  }(s), s = null), t = n.resolve(t), s && Object.prototype.hasOwnProperty.call(s, t)) return process.nextTick(l.bind(null, null, s[t]));
  f = t, m = {}, g = {}, c();
 };
}, function(e, t, s) {
 function r(e, t) {
  if ("function" == typeof t || 3 === arguments.length) throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
  return new i(e, t).found;
 }
 function i(e, t) {
  var s, r;
  if (!e) throw new Error("must provide pattern");
  if ("function" == typeof t || 3 === arguments.length) throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
  if (!(this instanceof i)) return new i(e, t);
  if (p(this, e, t), this.noprocess) return this;
  for (s = this.minimatch.set.length, this.matches = new Array(s), r = 0; r < s; r++) this._process(this.minimatch.set[r], r, !1);
  this._finish();
 }
 var n, o, a, l, c, u, h, p, d, f, m;
 e.exports = r, r.GlobSync = i, n = s(3), o = s(114), (a = s(60)).Minimatch, s(75).Glob, 
 s(2), l = s(0), c = s(22), u = s(76), (h = s(115)).alphasort, h.alphasorti, p = h.setopts, 
 d = h.ownProp, f = h.childrenIgnored, m = h.isIgnored, i.prototype._finish = function() {
  if (c(this instanceof i), this.realpath) {
   var e = this;
   this.matches.forEach((function(t, s) {
    var r, i = e.matches[s] = Object.create(null);
    for (r in t) try {
     r = e._makeAbs(r), i[o.realpathSync(r, e.realpathCache)] = !0;
    } catch (t) {
     if ("stat" !== t.syscall) throw t;
     i[e._makeAbs(r)] = !0;
    }
   }));
  }
  h.finish(this);
 }, i.prototype._process = function(e, t, s) {
  var r, n, o, l, h;
  for (c(this instanceof i), r = 0; "string" == typeof e[r]; ) r++;
  switch (r) {
  case e.length:
   return void this._processSimple(e.join("/"), t);

  case 0:
   n = null;
   break;

  default:
   n = e.slice(0, r).join("/");
  }
  o = e.slice(r), null === n ? l = "." : u(n) || u(e.join("/")) ? (n && u(n) || (n = "/" + n), 
  l = n) : l = n, h = this._makeAbs(l), f(this, l) || (o[0] === a.GLOBSTAR ? this._processGlobStar(n, l, h, o, t, s) : this._processReaddir(n, l, h, o, t, s));
 }, i.prototype._processReaddir = function(e, t, s, r, i, n) {
  var o, a, c, u, h, p, d, f, m, g = this._readdir(s, n);
  if (g) {
   for (o = r[0], a = !!this.minimatch.negate, c = o._glob, u = this.dot || "." === c.charAt(0), 
   h = [], p = 0; p < g.length; p++) ("." !== (d = g[p]).charAt(0) || u) && (a && !e ? !d.match(o) : d.match(o)) && h.push(d);
   if (0 !== (f = h.length)) if (1 !== r.length || this.mark || this.stat) for (r.shift(), 
   p = 0; p < f; p++) d = h[p], m = e ? [ e, d ] : [ d ], this._process(m.concat(r), i, n); else for (this.matches[i] || (this.matches[i] = Object.create(null)), 
   p = 0; p < f; p++) d = h[p], e && (d = "/" !== e.slice(-1) ? e + "/" + d : e + d), 
   "/" !== d.charAt(0) || this.nomount || (d = l.join(this.root, d)), this._emitMatch(i, d);
  }
 }, i.prototype._emitMatch = function(e, t) {
  var s, r;
  m(this, t) || (s = this._makeAbs(t), this.mark && (t = this._mark(t)), this.absolute && (t = s), 
  this.matches[e][t] || this.nodir && ("DIR" === (r = this.cache[s]) || Array.isArray(r)) || (this.matches[e][t] = !0, 
  this.stat && this._stat(t)));
 }, i.prototype._readdirInGlobStar = function(e) {
  var t, s, r;
  if (this.follow) return this._readdir(e, !1);
  try {
   s = n.lstatSync(e);
  } catch (e) {
   if ("ENOENT" === e.code) return null;
  }
  return r = s && s.isSymbolicLink(), this.symlinks[e] = r, r || !s || s.isDirectory() ? t = this._readdir(e, !1) : this.cache[e] = "FILE", 
  t;
 }, i.prototype._readdir = function(e, t) {
  if (t && !d(this.symlinks, e)) return this._readdirInGlobStar(e);
  if (d(this.cache, e)) {
   var s = this.cache[e];
   if (!s || "FILE" === s) return null;
   if (Array.isArray(s)) return s;
  }
  try {
   return this._readdirEntries(e, n.readdirSync(e));
  } catch (t) {
   return this._readdirError(e, t), null;
  }
 }, i.prototype._readdirEntries = function(e, t) {
  var s, r;
  if (!this.mark && !this.stat) for (s = 0; s < t.length; s++) r = t[s], r = "/" === e ? e + r : e + "/" + r, 
  this.cache[r] = !0;
  return this.cache[e] = t, t;
 }, i.prototype._readdirError = function(e, t) {
  var s, r;
  switch (t.code) {
  case "ENOTSUP":
  case "ENOTDIR":
   if (s = this._makeAbs(e), this.cache[s] = "FILE", s === this.cwdAbs) throw (r = new Error(t.code + " invalid cwd " + this.cwd)).path = this.cwd, 
   r.code = t.code, r;
   break;

  case "ENOENT":
  case "ELOOP":
  case "ENAMETOOLONG":
  case "UNKNOWN":
   this.cache[this._makeAbs(e)] = !1;
   break;

  default:
   if (this.cache[this._makeAbs(e)] = !1, this.strict) throw t;
   this.silent || console.error("glob error", t);
  }
 }, i.prototype._processGlobStar = function(e, t, s, r, i, n) {
  var o, a, l, c, u, h, p, d = this._readdir(s, n);
  if (d && (o = r.slice(1), l = (a = e ? [ e ] : []).concat(o), this._process(l, i, !1), 
  c = d.length, !this.symlinks[s] || !n)) for (u = 0; u < c; u++) ("." !== d[u].charAt(0) || this.dot) && (h = a.concat(d[u], o), 
  this._process(h, i, !0), p = a.concat(d[u], r), this._process(p, i, !0));
 }, i.prototype._processSimple = function(e, t) {
  var s, r = this._stat(e);
  this.matches[t] || (this.matches[t] = Object.create(null)), r && (e && u(e) && !this.nomount && (s = /[\/\\]$/.test(e), 
  "/" === e.charAt(0) ? e = l.join(this.root, e) : (e = l.resolve(this.root, e), s && (e += "/"))), 
  "win32" === process.platform && (e = e.replace(/\\/g, "/")), this._emitMatch(t, e));
 }, i.prototype._stat = function(e) {
  var t, s, r, i = this._makeAbs(e), o = "/" === e.slice(-1);
  if (e.length > this.maxLength) return !1;
  if (!this.stat && d(this.cache, i)) {
   if (t = this.cache[i], Array.isArray(t) && (t = "DIR"), !o || "DIR" === t) return t;
   if (o && "FILE" === t) return !1;
  }
  if (!(s = this.statCache[i])) {
   try {
    r = n.lstatSync(i);
   } catch (e) {
    if (e && ("ENOENT" === e.code || "ENOTDIR" === e.code)) return this.statCache[i] = !1, 
    !1;
   }
   if (r && r.isSymbolicLink()) try {
    s = n.statSync(i);
   } catch (e) {
    s = r;
   } else s = r;
  }
  return this.statCache[i] = s, t = !0, s && (t = s.isDirectory() ? "DIR" : "FILE"), 
  this.cache[i] = this.cache[i] || t, (!o || "FILE" !== t) && t;
 }, i.prototype._mark = function(e) {
  return h.mark(this, e);
 }, i.prototype._makeAbs = function(e) {
  return h.makeAbs(this, e);
 };
}, , , function(e, t, s) {
 e.exports = function(e, t) {
  var s, r, i;
  return s = (t = t || process.argv).indexOf("--"), r = /^--/.test(e) ? "" : "--", 
  -1 !== (i = t.indexOf(r + e)) && (-1 === s || i < s);
 };
}, , function(e, t, s) {
 var r = s(123), i = Object.create(null), n = s(61);
 e.exports = r((function o(e, t) {
  return i[e] ? (i[e].push(t), null) : (i[e] = [ t ], function s(e) {
   return n((function t() {
    var s, r = i[e], n = r.length, o = function a(e) {
     for (var t = e.length, s = [], r = 0; r < t; r++) s[r] = e[r];
     return s;
    }(arguments);
    try {
     for (s = 0; s < n; s++) r[s].apply(null, o);
    } finally {
     r.length > n ? (r.splice(0, n), process.nextTick((function() {
      t.apply(null, o);
     }))) : delete i[e];
    }
   }));
  }(e));
 }));
}, function(e, t) {
 "function" == typeof Object.create ? e.exports = function e(t, s) {
  t.super_ = s, t.prototype = Object.create(s.prototype, {
   constructor: {
    value: t,
    enumerable: !1,
    writable: !0,
    configurable: !0
   }
  });
 } : e.exports = function e(t, s) {
  t.super_ = s;
  var r = function() {};
  r.prototype = s.prototype, t.prototype = new r, t.prototype.constructor = t;
 };
}, , , function(e, t, s) {
 e.exports = void 0 !== s;
}, , function(e, t) {
 function s(e, t, s) {
  if (!(e < t)) return e < 1.5 * t ? Math.floor(e / t) + " " + s : Math.ceil(e / t) + " " + s + "s";
 }
 var r = 1e3, i = 60 * r, n = 60 * i, o = 24 * n;
 e.exports = function(e, t) {
  t = t || {};
  var a = typeof e;
  if ("string" === a && e.length > 0) return function l(e) {
   var t, s;
   if (!((e = String(e)).length > 100) && (t = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(e))) switch (s = parseFloat(t[1]), 
   (t[2] || "ms").toLowerCase()) {
   case "years":
   case "year":
   case "yrs":
   case "yr":
   case "y":
    return 315576e5 * s;

   case "days":
   case "day":
   case "d":
    return s * o;

   case "hours":
   case "hour":
   case "hrs":
   case "hr":
   case "h":
    return s * n;

   case "minutes":
   case "minute":
   case "mins":
   case "min":
   case "m":
    return s * i;

   case "seconds":
   case "second":
   case "secs":
   case "sec":
   case "s":
    return s * r;

   case "milliseconds":
   case "millisecond":
   case "msecs":
   case "msec":
   case "ms":
    return s;

   default:
    return;
   }
  }(e);
  if ("number" === a && !1 === isNaN(e)) return t.long ? function c(e) {
   return s(e, o, "day") || s(e, n, "hour") || s(e, i, "minute") || s(e, r, "second") || e + " ms";
  }(e) : function u(e) {
   return e >= o ? Math.round(e / o) + "d" : e >= n ? Math.round(e / n) + "h" : e >= i ? Math.round(e / i) + "m" : e >= r ? Math.round(e / r) + "s" : e + "ms";
  }(e);
  throw new Error("val is not a non-empty string or a valid number. val=" + JSON.stringify(e));
 };
}, , , , function(e, t, s) {
 function r(e) {
  [ "unlink", "chmod", "stat", "lstat", "rmdir", "readdir" ].forEach((function(t) {
   e[t] = e[t] || d[t], e[t += "Sync"] = e[t] || d[t];
  })), e.maxBusyTries = e.maxBusyTries || 3, e.emfileWait = e.emfileWait || 1e3, !1 === e.glob && (e.disableGlob = !0), 
  e.disableGlob = e.disableGlob || !1, e.glob = e.glob || g;
 }
 function i(e, t, s) {
  function i(e, r) {
   return e ? s(e) : 0 === (l = r.length) ? s() : void r.forEach((function(e) {
    n(e, t, (function r(i) {
     if (i) {
      if (("EBUSY" === i.code || "ENOTEMPTY" === i.code || "EPERM" === i.code) && o < t.maxBusyTries) return o++, 
      setTimeout((function() {
       n(e, t, r);
      }), 100 * o);
      if ("EMFILE" === i.code && y < t.emfileWait) return setTimeout((function() {
       n(e, t, r);
      }), y++);
      "ENOENT" === i.code && (i = null);
     }
     y = 0, function c(e) {
      a = a || e, 0 == --l && s(a);
     }(i);
    }));
   }));
  }
  var o, a, l;
  if ("function" == typeof t && (s = t, t = {}), h(e, "rimraf: missing path"), h.equal(typeof e, "string", "rimraf: path should be a string"), 
  h.equal(typeof s, "function", "rimraf: callback function required"), h(t, "rimraf: invalid options argument provided"), 
  h.equal(typeof t, "object", "rimraf: options should be object"), r(t), o = 0, a = null, 
  l = 0, t.disableGlob || !f.hasMagic(e)) return i(null, [ e ]);
  t.lstat(e, (function(s, r) {
   if (!s) return i(null, [ e ]);
   f(e, t.glob, i);
  }));
 }
 function n(e, t, s) {
  h(e), h(t), h("function" == typeof s), t.lstat(e, (function(r, i) {
   return r && "ENOENT" === r.code ? s(null) : (r && "EPERM" === r.code && v && o(e, t, r, s), 
   i && i.isDirectory() ? l(e, t, r, s) : void t.unlink(e, (function(r) {
    if (r) {
     if ("ENOENT" === r.code) return s(null);
     if ("EPERM" === r.code) return v ? o(e, t, r, s) : l(e, t, r, s);
     if ("EISDIR" === r.code) return l(e, t, r, s);
    }
    return s(r);
   })));
  }));
 }
 function o(e, t, s, r) {
  h(e), h(t), h("function" == typeof r), s && h(s instanceof Error), t.chmod(e, m, (function(i) {
   i ? r("ENOENT" === i.code ? null : s) : t.stat(e, (function(i, n) {
    i ? r("ENOENT" === i.code ? null : s) : n.isDirectory() ? l(e, t, s, r) : t.unlink(e, r);
   }));
  }));
 }
 function a(e, t, s) {
  h(e), h(t), s && h(s instanceof Error);
  try {
   t.chmodSync(e, m);
  } catch (e) {
   if ("ENOENT" === e.code) return;
   throw s;
  }
  try {
   var r = t.statSync(e);
  } catch (e) {
   if ("ENOENT" === e.code) return;
   throw s;
  }
  r.isDirectory() ? u(e, t, s) : t.unlinkSync(e);
 }
 function l(e, t, s, r) {
  h(e), h(t), s && h(s instanceof Error), h("function" == typeof r), t.rmdir(e, (function(n) {
   !n || "ENOTEMPTY" !== n.code && "EEXIST" !== n.code && "EPERM" !== n.code ? n && "ENOTDIR" === n.code ? r(s) : r(n) : function o(e, t, s) {
    h(e), h(t), h("function" == typeof s), t.readdir(e, (function(r, n) {
     var o, a;
     return r ? s(r) : 0 === (o = n.length) ? t.rmdir(e, s) : void n.forEach((function(r) {
      i(p.join(e, r), t, (function(r) {
       if (!a) return r ? s(a = r) : void (0 == --o && t.rmdir(e, s));
      }));
     }));
    }));
   }(e, t, r);
  }));
 }
 function c(e, t) {
  var s, i, n;
  if (r(t = t || {}), h(e, "rimraf: missing path"), h.equal(typeof e, "string", "rimraf: path should be a string"), 
  h(t, "rimraf: missing options"), h.equal(typeof t, "object", "rimraf: options should be object"), 
  t.disableGlob || !f.hasMagic(e)) s = [ e ]; else try {
   t.lstatSync(e), s = [ e ];
  } catch (r) {
   s = f.sync(e, t.glob);
  }
  if (s.length) for (i = 0; i < s.length; i++) {
   e = s[i];
   try {
    n = t.lstatSync(e);
   } catch (s) {
    if ("ENOENT" === s.code) return;
    "EPERM" === s.code && v && a(e, t, s);
   }
   try {
    n && n.isDirectory() ? u(e, t, null) : t.unlinkSync(e);
   } catch (s) {
    if ("ENOENT" === s.code) return;
    if ("EPERM" === s.code) return v ? a(e, t, s) : u(e, t, s);
    if ("EISDIR" !== s.code) throw s;
    u(e, t, s);
   }
  }
 }
 function u(e, t, s) {
  h(e), h(t), s && h(s instanceof Error);
  try {
   t.rmdirSync(e);
  } catch (r) {
   if ("ENOENT" === r.code) return;
   if ("ENOTDIR" === r.code) throw s;
   "ENOTEMPTY" !== r.code && "EEXIST" !== r.code && "EPERM" !== r.code || function r(e, t) {
    var s, r, i, n;
    for (h(e), h(t), t.readdirSync(e).forEach((function(s) {
     c(p.join(e, s), t);
    })), s = v ? 100 : 1, r = 0; ;) {
     i = !0;
     try {
      return n = t.rmdirSync(e, t), i = !1, n;
     } finally {
      if (++r < s && i) continue;
     }
    }
   }(e, t);
  }
 }
 var h, p, d, f, m, g, y, v;
 e.exports = i, i.sync = c, h = s(22), p = s(0), d = s(3), f = s(75), m = parseInt("666", 8), 
 g = {
  nosort: !0,
  silent: !0
 }, y = 0, v = "win32" === process.platform;
}, , , , , , function(e, t, s) {
 var r, i = s(221), n = i("no-color") || i("no-colors") || i("color=false") ? 0 : i("color=16m") || i("color=full") || i("color=truecolor") ? 3 : i("color=256") ? 2 : i("color") || i("colors") || i("color=true") || i("color=always") ? 1 : process.stdout && !process.stdout.isTTY ? 0 : "win32" === process.platform ? 1 : "CI" in process.env ? "TRAVIS" in process.env || "Travis" === process.env.CI ? 1 : 0 : "TEAMCITY_VERSION" in process.env ? null === process.env.TEAMCITY_VERSION.match(/^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/) ? 0 : 1 : /^(screen|xterm)-256(?:color)?/.test(process.env.TERM) ? 2 : /^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(process.env.TERM) || "COLORTERM" in process.env ? 1 : (process.env.TERM, 
 0);
 0 === n && "FORCE_COLOR" in process.env && (n = 1), e.exports = process && (0 !== (r = n) && {
  level: r,
  hasBasic: !0,
  has256: r >= 2,
  has16m: r >= 3
 });
} ]);

const exit$1 = function e(t, s) {
 function r() {
  i === s.length && process.exit(t);
 }
 s || (s = [ process.stdout, process.stderr ]);
 var i = 0;
 s.forEach((function(e) {
  0 === e.bufferSize ? i++ : e.write("", "utf-8", (function() {
   i++, r();
  })), e.write = function() {};
 })), r(), process.on("exit", (function() {
  process.exit(t);
 }));
}, buildEvents = () => {
 const e = [], t = t => {
  const s = e.findIndex((e => e.callback === t));
  return s > -1 && (e.splice(s, 1), !0);
 };
 return {
  emit: (t, s) => {
   const r = t.toLowerCase().trim(), i = e.slice();
   for (const e of i) if (null == e.eventName) try {
    e.callback(t, s);
   } catch (e) {
    console.error(e);
   } else if (e.eventName === r) try {
    e.callback(s);
   } catch (e) {
    console.error(e);
   }
  },
  on: (s, r) => {
   if ("function" == typeof s) {
    const r = null, i = s;
    return e.push({
     eventName: r,
     callback: i
    }), () => t(i);
   }
   if ("string" == typeof s && "function" == typeof r) {
    const i = s.toLowerCase().trim(), n = r;
    return e.push({
     eventName: i,
     callback: n
    }), () => t(n);
   }
   return () => !1;
  },
  unsubscribeAll: () => {
   e.length = 0;
  }
 };
};

commonjs$2 = {}, balancedMatch = balanced$1, balanced$1.range = range$1, balanced = balancedMatch, 
braceExpansion = function expandTop(e) {
 return e ? ("{}" === e.substr(0, 2) && (e = "\\{\\}" + e.substr(2)), expand(function t(e) {
  return e.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
 }(e), !0).map(unescapeBraces)) : [];
}, escSlash = "\0SLASH" + Math.random() + "\0", escOpen = "\0OPEN" + Math.random() + "\0", 
escClose = "\0CLOSE" + Math.random() + "\0", escComma = "\0COMMA" + Math.random() + "\0", 
escPeriod = "\0PERIOD" + Math.random() + "\0";

const expand$1 = braceExpansion, assertValidPattern = e => {
 if ("string" != typeof e) throw new TypeError("invalid pattern");
 if (e.length > 65536) throw new TypeError("pattern is too long");
}, posixClasses = {
 "[:alnum:]": [ "\\p{L}\\p{Nl}\\p{Nd}", !0 ],
 "[:alpha:]": [ "\\p{L}\\p{Nl}", !0 ],
 "[:ascii:]": [ "\\x00-\\x7f", !1 ],
 "[:blank:]": [ "\\p{Zs}\\t", !0 ],
 "[:cntrl:]": [ "\\p{Cc}", !0 ],
 "[:digit:]": [ "\\p{Nd}", !0 ],
 "[:graph:]": [ "\\p{Z}\\p{C}", !0, !0 ],
 "[:lower:]": [ "\\p{Ll}", !0 ],
 "[:print:]": [ "\\p{C}", !0 ],
 "[:punct:]": [ "\\p{P}", !0 ],
 "[:space:]": [ "\\p{Z}\\t\\r\\n\\v\\f", !0 ],
 "[:upper:]": [ "\\p{Lu}", !0 ],
 "[:word:]": [ "\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", !0 ],
 "[:xdigit:]": [ "A-Fa-f0-9", !1 ]
}, braceEscape = e => e.replace(/[[\]\\-]/g, "\\$&"), rangesToString = e => e.join(""), parseClass = (e, t) => {
 const s = t;
 if ("[" !== e.charAt(s)) throw new Error("not in a brace expression");
 const r = [], i = [];
 let n = s + 1, o = !1, a = !1, l = !1, c = !1, u = s, h = "";
 e: for (;n < e.length; ) {
  const t = e.charAt(n);
  if ("!" !== t && "^" !== t || n !== s + 1) {
   if ("]" === t && o && !l) {
    u = n + 1;
    break;
   }
   if (o = !0, "\\" !== t || l) {
    if ("[" === t && !l) for (const [t, [o, l, c]] of Object.entries(posixClasses)) if (e.startsWith(t, n)) {
     if (h) return [ "$.", !1, e.length - s, !0 ];
     n += t.length, c ? i.push(o) : r.push(o), a = a || l;
     continue e;
    }
    l = !1, h ? (t > h ? r.push(braceEscape(h) + "-" + braceEscape(t)) : t === h && r.push(braceEscape(t)), 
    h = "", n++) : e.startsWith("-]", n + 1) ? (r.push(braceEscape(t + "-")), n += 2) : e.startsWith("-", n + 1) ? (h = t, 
    n += 2) : (r.push(braceEscape(t)), n++);
   } else l = !0, n++;
  } else c = !0, n++;
 }
 if (u < n) return [ "", !1, 0, !1 ];
 if (!r.length && !i.length) return [ "$.", !1, e.length - s, !0 ];
 if (0 === i.length && 1 === r.length && /^\\?.$/.test(r[0]) && !c) {
  return [ (p = 2 === r[0].length ? r[0].slice(-1) : r[0], p.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&")), !1, u - s, !1 ];
 }
 var p;
 const d = "[" + (c ? "^" : "") + rangesToString(r) + "]", f = "[" + (c ? "" : "^") + rangesToString(i) + "]";
 return [ r.length && i.length ? "(" + d + "|" + f + ")" : r.length ? d : f, a, u - s, !0 ];
}, unescape$1 = (e, {windowsPathsNoEscape: t = !1} = {}) => t ? e.replace(/\[([^\/\\])\]/g, "$1") : e.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1"), types = new Set([ "!", "?", "+", "*", "@" ]), isExtglobType = e => types.has(e), addPatternStart = new Set([ "[", "." ]), justDots = new Set([ "..", "." ]), reSpecials = new Set("().*{}+?[]^$\\!");

class AST {
 type;
 #e;
 #t;
 #s=!1;
 #r=[];
 #i;
 #n;
 #o;
 #a=!1;
 #l;
 #c;
 #u=!1;
 constructor(e, t, s = {}) {
  this.type = e, e && (this.#t = !0), this.#i = t, this.#e = this.#i ? this.#i.#e : this, 
  this.#l = this.#e === this ? s : this.#e.#l, this.#o = this.#e === this ? [] : this.#e.#o, 
  "!" !== e || this.#e.#a || this.#o.push(this), this.#n = this.#i ? this.#i.#r.length : 0;
 }
 get hasMagic() {
  if (void 0 !== this.#t) return this.#t;
  for (const e of this.#r) if ("string" != typeof e && (e.type || e.hasMagic)) return this.#t = !0;
  return this.#t;
 }
 toString() {
  return void 0 !== this.#c ? this.#c : this.type ? this.#c = this.type + "(" + this.#r.map((e => String(e))).join("|") + ")" : this.#c = this.#r.map((e => String(e))).join("");
 }
 #h() {
  if (this !== this.#e) throw new Error("should only call on root");
  if (this.#a) return this;
  let e;
  for (this.toString(), this.#a = !0; e = this.#o.pop(); ) {
   if ("!" !== e.type) continue;
   let t = e, s = t.#i;
   for (;s; ) {
    for (let r = t.#n + 1; !s.type && r < s.#r.length; r++) for (const t of e.#r) {
     if ("string" == typeof t) throw new Error("string part in extglob AST??");
     t.copyIn(s.#r[r]);
    }
    t = s, s = t.#i;
   }
  }
  return this;
 }
 push(...e) {
  for (const t of e) if ("" !== t) {
   if ("string" != typeof t && !(t instanceof AST && t.#i === this)) throw new Error("invalid part: " + t);
   this.#r.push(t);
  }
 }
 toJSON() {
  const e = null === this.type ? this.#r.slice().map((e => "string" == typeof e ? e : e.toJSON())) : [ this.type, ...this.#r.map((e => e.toJSON())) ];
  return this.isStart() && !this.type && e.unshift([]), this.isEnd() && (this === this.#e || this.#e.#a && "!" === this.#i?.type) && e.push({}), 
  e;
 }
 isStart() {
  if (this.#e === this) return !0;
  if (!this.#i?.isStart()) return !1;
  if (0 === this.#n) return !0;
  const e = this.#i;
  for (let t = 0; t < this.#n; t++) {
   const s = e.#r[t];
   if (!(s instanceof AST && "!" === s.type)) return !1;
  }
  return !0;
 }
 isEnd() {
  if (this.#e === this) return !0;
  if ("!" === this.#i?.type) return !0;
  if (!this.#i?.isEnd()) return !1;
  if (!this.type) return this.#i?.isEnd();
  const e = this.#i ? this.#i.#r.length : 0;
  return this.#n === e - 1;
 }
 copyIn(e) {
  "string" == typeof e ? this.push(e) : this.push(e.clone(this));
 }
 clone(e) {
  const t = new AST(this.type, e);
  for (const e of this.#r) t.copyIn(e);
  return t;
 }
 static #p(e, t, s, r) {
  let i = !1, n = !1, o = -1, a = !1;
  if (null === t.type) {
   let l = s, c = "";
   for (;l < e.length; ) {
    const s = e.charAt(l++);
    if (i || "\\" === s) i = !i, c += s; else if (n) l === o + 1 ? "^" !== s && "!" !== s || (a = !0) : "]" !== s || l === o + 2 && a || (n = !1), 
    c += s; else if ("[" !== s) if (r.noext || !isExtglobType(s) || "(" !== e.charAt(l)) c += s; else {
     t.push(c), c = "";
     const i = new AST(s, t);
     l = AST.#p(e, i, l, r), t.push(i);
    } else n = !0, o = l, a = !1, c += s;
   }
   return t.push(c), l;
  }
  let l = s + 1, c = new AST(null, t);
  const u = [];
  let h = "";
  for (;l < e.length; ) {
   const s = e.charAt(l++);
   if (i || "\\" === s) i = !i, h += s; else if (n) l === o + 1 ? "^" !== s && "!" !== s || (a = !0) : "]" !== s || l === o + 2 && a || (n = !1), 
   h += s; else if ("[" !== s) if (isExtglobType(s) && "(" === e.charAt(l)) {
    c.push(h), h = "";
    const t = new AST(s, c);
    c.push(t), l = AST.#p(e, t, l, r);
   } else if ("|" !== s) {
    if (")" === s) return "" === h && 0 === t.#r.length && (t.#u = !0), c.push(h), h = "", 
    t.push(...u, c), l;
    h += s;
   } else c.push(h), h = "", u.push(c), c = new AST(null, t); else n = !0, o = l, a = !1, 
   h += s;
  }
  return t.type = null, t.#t = void 0, t.#r = [ e.substring(s - 1) ], l;
 }
 static fromGlob(e, t = {}) {
  const s = new AST(null, void 0, t);
  return AST.#p(e, s, 0, t), s;
 }
 toMMPattern() {
  if (this !== this.#e) return this.#e.toMMPattern();
  const e = this.toString(), [t, s, r, i] = this.toRegExpSource();
  if (!(r || this.#t || this.#l.nocase && !this.#l.nocaseMagicOnly && e.toUpperCase() !== e.toLowerCase())) return s;
  const n = (this.#l.nocase ? "i" : "") + (i ? "u" : "");
  return Object.assign(new RegExp(`^${t}$`, n), {
   _src: t,
   _glob: e
  });
 }
 toRegExpSource(e) {
  const t = e ?? !!this.#l.dot;
  if (this.#e === this && this.#h(), !this.type) {
   const s = this.isStart() && this.isEnd(), r = this.#r.map((t => {
    const [r, i, n, o] = "string" == typeof t ? AST.#d(t, this.#t, s) : t.toRegExpSource(e);
    return this.#t = this.#t || n, this.#s = this.#s || o, r;
   })).join("");
   let i = "";
   if (this.isStart() && "string" == typeof this.#r[0] && (1 !== this.#r.length || !justDots.has(this.#r[0]))) {
    const s = addPatternStart, n = t && s.has(r.charAt(0)) || r.startsWith("\\.") && s.has(r.charAt(2)) || r.startsWith("\\.\\.") && s.has(r.charAt(4)), o = !t && !e && s.has(r.charAt(0));
    i = n ? "(?!(?:^|/)\\.\\.?(?:$|/))" : o ? "(?!\\.)" : "";
   }
   let n = "";
   return this.isEnd() && this.#e.#a && "!" === this.#i?.type && (n = "(?:$|\\/)"), 
   [ i + r + n, unescape$1(r), this.#t = !!this.#t, this.#s ];
  }
  const s = "*" === this.type || "+" === this.type, r = "!" === this.type ? "(?:(?!(?:" : "(?:";
  let i = this.#f(t);
  if (this.isStart() && this.isEnd() && !i && "!" !== this.type) {
   const e = this.toString();
   return this.#r = [ e ], this.type = null, this.#t = void 0, [ e, unescape$1(this.toString()), !1, !1 ];
  }
  let n = !s || e || t ? "" : this.#f(!0);
  n === i && (n = ""), n && (i = `(?:${i})(?:${n})*?`);
  let o = "";
  return o = "!" === this.type && this.#u ? (this.isStart() && !t ? "(?!\\.)" : "") + "[^/]+?" : r + i + ("!" === this.type ? "))" + (!this.isStart() || t || e ? "" : "(?!\\.)") + "[^/]*?)" : "@" === this.type ? ")" : "?" === this.type ? ")?" : "+" === this.type && n ? ")" : "*" === this.type && n ? ")?" : `)${this.type}`), 
  [ o, unescape$1(i), this.#t = !!this.#t, this.#s ];
 }
 #f(e) {
  return this.#r.map((t => {
   if ("string" == typeof t) throw new Error("string type in extglob ast??");
   const [s, r, i, n] = t.toRegExpSource(e);
   return this.#s = this.#s || n, s;
  })).filter((e => !(this.isStart() && this.isEnd() && !e))).join("|");
 }
 static #d(e, t, s = !1) {
  let r = !1, i = "", n = !1;
  for (let o = 0; o < e.length; o++) {
   const a = e.charAt(o);
   if (r) r = !1, i += (reSpecials.has(a) ? "\\" : "") + a; else if ("\\" !== a) {
    if ("[" === a) {
     const [s, r, a, l] = parseClass(e, o);
     if (a) {
      i += s, n = n || r, o += a - 1, t = t || l;
      continue;
     }
    }
    "*" !== a ? "?" !== a ? i += a.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&") : (i += "[^/]", 
    t = !0) : (i += s && "*" === e ? "[^/]+?" : "[^/]*?", t = !0);
   } else o === e.length - 1 ? i += "\\\\" : r = !0;
  }
  return [ i, unescape$1(e), !!t, n ];
 }
}

const escape = (e, {windowsPathsNoEscape: t = !1} = {}) => t ? e.replace(/[?*()[\]]/g, "[$&]") : e.replace(/[?*()[\]\\]/g, "\\$&"), minimatch = (e, t, s = {}) => (assertValidPattern(t), 
!(!s.nocomment && "#" === t.charAt(0)) && new Minimatch(t, s).match(e)), starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/, starDotExtTest = e => t => !t.startsWith(".") && t.endsWith(e), starDotExtTestDot = e => t => t.endsWith(e), starDotExtTestNocase = e => (e = e.toLowerCase(), 
t => !t.startsWith(".") && t.toLowerCase().endsWith(e)), starDotExtTestNocaseDot = e => (e = e.toLowerCase(), 
t => t.toLowerCase().endsWith(e)), starDotStarRE = /^\*+\.\*+$/, starDotStarTest = e => !e.startsWith(".") && e.includes("."), starDotStarTestDot = e => "." !== e && ".." !== e && e.includes("."), dotStarRE = /^\.\*+$/, dotStarTest = e => "." !== e && ".." !== e && e.startsWith("."), starRE = /^\*+$/, starTest = e => 0 !== e.length && !e.startsWith("."), starTestDot = e => 0 !== e.length && "." !== e && ".." !== e, qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/, qmarksTestNocase = ([e, t = ""]) => {
 const s = qmarksTestNoExt([ e ]);
 return t ? (t = t.toLowerCase(), e => s(e) && e.toLowerCase().endsWith(t)) : s;
}, qmarksTestNocaseDot = ([e, t = ""]) => {
 const s = qmarksTestNoExtDot([ e ]);
 return t ? (t = t.toLowerCase(), e => s(e) && e.toLowerCase().endsWith(t)) : s;
}, qmarksTestDot = ([e, t = ""]) => {
 const s = qmarksTestNoExtDot([ e ]);
 return t ? e => s(e) && e.endsWith(t) : s;
}, qmarksTest = ([e, t = ""]) => {
 const s = qmarksTestNoExt([ e ]);
 return t ? e => s(e) && e.endsWith(t) : s;
}, qmarksTestNoExt = ([e]) => {
 const t = e.length;
 return e => e.length === t && !e.startsWith(".");
}, qmarksTestNoExtDot = ([e]) => {
 const t = e.length;
 return e => e.length === t && "." !== e && ".." !== e;
}, defaultPlatform$2 = "object" == typeof process && process ? "object" == typeof process.env && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix", sep = "win32" === defaultPlatform$2 ? "\\" : "/";

minimatch.sep = sep;

const GLOBSTAR = Symbol("globstar **");

minimatch.GLOBSTAR = GLOBSTAR;

const filter = (e, t = {}) => s => minimatch(s, e, t);

minimatch.filter = filter;

const ext = (e, t = {}) => Object.assign({}, e, t), defaults = e => {
 if (!e || "object" != typeof e || !Object.keys(e).length) return minimatch;
 const t = minimatch;
 return Object.assign(((s, r, i = {}) => t(s, r, ext(e, i))), {
  Minimatch: class s extends t.Minimatch {
   constructor(t, s = {}) {
    super(t, ext(e, s));
   }
   static defaults(s) {
    return t.defaults(ext(e, s)).Minimatch;
   }
  },
  AST: class s extends t.AST {
   constructor(t, s, r = {}) {
    super(t, s, ext(e, r));
   }
   static fromGlob(s, r = {}) {
    return t.AST.fromGlob(s, ext(e, r));
   }
  },
  unescape: (s, r = {}) => t.unescape(s, ext(e, r)),
  escape: (s, r = {}) => t.escape(s, ext(e, r)),
  filter: (s, r = {}) => t.filter(s, ext(e, r)),
  defaults: s => t.defaults(ext(e, s)),
  makeRe: (s, r = {}) => t.makeRe(s, ext(e, r)),
  braceExpand: (s, r = {}) => t.braceExpand(s, ext(e, r)),
  match: (s, r, i = {}) => t.match(s, r, ext(e, i)),
  sep: t.sep,
  GLOBSTAR
 });
};

minimatch.defaults = defaults;

const braceExpand = (e, t = {}) => (assertValidPattern(e), t.nobrace || !/\{(?:(?!\{).)*\}/.test(e) ? [ e ] : expand$1(e));

minimatch.braceExpand = braceExpand;

const makeRe = (e, t = {}) => new Minimatch(e, t).makeRe();

minimatch.makeRe = makeRe;

const match = (e, t, s = {}) => {
 const r = new Minimatch(t, s);
 return e = e.filter((e => r.match(e))), r.options.nonull && !e.length && e.push(t), 
 e;
};

minimatch.match = match;

const globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;

class Minimatch {
 options;
 set;
 pattern;
 windowsPathsNoEscape;
 nonegate;
 negate;
 comment;
 empty;
 preserveMultipleSlashes;
 partial;
 globSet;
 globParts;
 nocase;
 isWindows;
 platform;
 windowsNoMagicRoot;
 regexp;
 constructor(e, t = {}) {
  assertValidPattern(e), t = t || {}, this.options = t, this.pattern = e, this.platform = t.platform || defaultPlatform$2, 
  this.isWindows = "win32" === this.platform, this.windowsPathsNoEscape = !!t.windowsPathsNoEscape || !1 === t.allowWindowsEscape, 
  this.windowsPathsNoEscape && (this.pattern = this.pattern.replace(/\\/g, "/")), 
  this.preserveMultipleSlashes = !!t.preserveMultipleSlashes, this.regexp = null, 
  this.negate = !1, this.nonegate = !!t.nonegate, this.comment = !1, this.empty = !1, 
  this.partial = !!t.partial, this.nocase = !!this.options.nocase, this.windowsNoMagicRoot = void 0 !== t.windowsNoMagicRoot ? t.windowsNoMagicRoot : !(!this.isWindows || !this.nocase), 
  this.globSet = [], this.globParts = [], this.set = [], this.make();
 }
 hasMagic() {
  if (this.options.magicalBraces && this.set.length > 1) return !0;
  for (const e of this.set) for (const t of e) if ("string" != typeof t) return !0;
  return !1;
 }
 debug(...e) {}
 make() {
  const e = this.pattern, t = this.options;
  if (!t.nocomment && "#" === e.charAt(0)) return void (this.comment = !0);
  if (!e) return void (this.empty = !0);
  this.parseNegate(), this.globSet = [ ...new Set(this.braceExpand()) ], t.debug && (this.debug = (...e) => console.error(...e)), 
  this.debug(this.pattern, this.globSet);
  const s = this.globSet.map((e => this.slashSplit(e)));
  this.globParts = this.preprocess(s), this.debug(this.pattern, this.globParts);
  let r = this.globParts.map(((e, t, s) => {
   if (this.isWindows && this.windowsNoMagicRoot) {
    const t = !("" !== e[0] || "" !== e[1] || "?" !== e[2] && globMagic.test(e[2]) || globMagic.test(e[3])), s = /^[a-z]:/i.test(e[0]);
    if (t) return [ ...e.slice(0, 4), ...e.slice(4).map((e => this.parse(e))) ];
    if (s) return [ e[0], ...e.slice(1).map((e => this.parse(e))) ];
   }
   return e.map((e => this.parse(e)));
  }));
  if (this.debug(this.pattern, r), this.set = r.filter((e => -1 === e.indexOf(!1))), 
  this.isWindows) for (let e = 0; e < this.set.length; e++) {
   const t = this.set[e];
   "" === t[0] && "" === t[1] && "?" === this.globParts[e][2] && "string" == typeof t[3] && /^[a-z]:$/i.test(t[3]) && (t[2] = "?");
  }
  this.debug(this.pattern, this.set);
 }
 preprocess(e) {
  if (this.options.noglobstar) for (let t = 0; t < e.length; t++) for (let s = 0; s < e[t].length; s++) "**" === e[t][s] && (e[t][s] = "*");
  const {optimizationLevel: t = 1} = this.options;
  return t >= 2 ? (e = this.firstPhasePreProcess(e), e = this.secondPhasePreProcess(e)) : e = t >= 1 ? this.levelOneOptimize(e) : this.adjascentGlobstarOptimize(e), 
  e;
 }
 adjascentGlobstarOptimize(e) {
  return e.map((e => {
   let t = -1;
   for (;-1 !== (t = e.indexOf("**", t + 1)); ) {
    let s = t;
    for (;"**" === e[s + 1]; ) s++;
    s !== t && e.splice(t, s - t);
   }
   return e;
  }));
 }
 levelOneOptimize(e) {
  return e.map((e => 0 === (e = e.reduce(((e, t) => {
   const s = e[e.length - 1];
   return "**" === t && "**" === s ? e : ".." === t && s && ".." !== s && "." !== s && "**" !== s ? (e.pop(), 
   e) : (e.push(t), e);
  }), [])).length ? [ "" ] : e));
 }
 levelTwoFileOptimize(e) {
  Array.isArray(e) || (e = this.slashSplit(e));
  let t = !1;
  do {
   if (t = !1, !this.preserveMultipleSlashes) {
    for (let s = 1; s < e.length - 1; s++) {
     const r = e[s];
     1 === s && "" === r && "" === e[0] || "." !== r && "" !== r || (t = !0, e.splice(s, 1), 
     s--);
    }
    "." !== e[0] || 2 !== e.length || "." !== e[1] && "" !== e[1] || (t = !0, e.pop());
   }
   let s = 0;
   for (;-1 !== (s = e.indexOf("..", s + 1)); ) {
    const r = e[s - 1];
    r && "." !== r && ".." !== r && "**" !== r && (t = !0, e.splice(s - 1, 2), s -= 2);
   }
  } while (t);
  return 0 === e.length ? [ "" ] : e;
 }
 firstPhasePreProcess(e) {
  let t = !1;
  do {
   t = !1;
   for (let s of e) {
    let r = -1;
    for (;-1 !== (r = s.indexOf("**", r + 1)); ) {
     let i = r;
     for (;"**" === s[i + 1]; ) i++;
     i > r && s.splice(r + 1, i - r);
     let n = s[r + 1];
     const o = s[r + 2], a = s[r + 3];
     if (".." !== n) continue;
     if (!o || "." === o || ".." === o || !a || "." === a || ".." === a) continue;
     t = !0, s.splice(r, 1);
     const l = s.slice(0);
     l[r] = "**", e.push(l), r--;
    }
    if (!this.preserveMultipleSlashes) {
     for (let e = 1; e < s.length - 1; e++) {
      const r = s[e];
      1 === e && "" === r && "" === s[0] || "." !== r && "" !== r || (t = !0, s.splice(e, 1), 
      e--);
     }
     "." !== s[0] || 2 !== s.length || "." !== s[1] && "" !== s[1] || (t = !0, s.pop());
    }
    let i = 0;
    for (;-1 !== (i = s.indexOf("..", i + 1)); ) {
     const e = s[i - 1];
     if (e && "." !== e && ".." !== e && "**" !== e) {
      t = !0;
      const e = 1 === i && "**" === s[i + 1] ? [ "." ] : [];
      s.splice(i - 1, 2, ...e), 0 === s.length && s.push(""), i -= 2;
     }
    }
   }
  } while (t);
  return e;
 }
 secondPhasePreProcess(e) {
  for (let t = 0; t < e.length - 1; t++) for (let s = t + 1; s < e.length; s++) {
   const r = this.partsMatch(e[t], e[s], !this.preserveMultipleSlashes);
   r && (e[t] = r, e[s] = []);
  }
  return e.filter((e => e.length));
 }
 partsMatch(e, t, s = !1) {
  let r = 0, i = 0, n = [], o = "";
  for (;r < e.length && i < t.length; ) if (e[r] === t[i]) n.push("b" === o ? t[i] : e[r]), 
  r++, i++; else if (s && "**" === e[r] && t[i] === e[r + 1]) n.push(e[r]), r++; else if (s && "**" === t[i] && e[r] === t[i + 1]) n.push(t[i]), 
  i++; else if ("*" !== e[r] || !t[i] || !this.options.dot && t[i].startsWith(".") || "**" === t[i]) {
   if ("*" !== t[i] || !e[r] || !this.options.dot && e[r].startsWith(".") || "**" === e[r]) return !1;
   if ("a" === o) return !1;
   o = "b", n.push(t[i]), r++, i++;
  } else {
   if ("b" === o) return !1;
   o = "a", n.push(e[r]), r++, i++;
  }
  return e.length === t.length && n;
 }
 parseNegate() {
  if (this.nonegate) return;
  const e = this.pattern;
  let t = !1, s = 0;
  for (let r = 0; r < e.length && "!" === e.charAt(r); r++) t = !t, s++;
  s && (this.pattern = e.slice(s)), this.negate = t;
 }
 matchOne(e, t, s = !1) {
  var r, i, n, o, a, l, c, u, h;
  const p = this.options;
  if (this.isWindows) {
   const s = "string" == typeof e[0] && /^[a-z]:$/i.test(e[0]), r = !s && "" === e[0] && "" === e[1] && "?" === e[2] && /^[a-z]:$/i.test(e[3]), i = "string" == typeof t[0] && /^[a-z]:$/i.test(t[0]), n = r ? 3 : s ? 0 : void 0, o = !i && "" === t[0] && "" === t[1] && "?" === t[2] && "string" == typeof t[3] && /^[a-z]:$/i.test(t[3]) ? 3 : i ? 0 : void 0;
   if ("number" == typeof n && "number" == typeof o) {
    const [s, r] = [ e[n], t[o] ];
    s.toLowerCase() === r.toLowerCase() && (t[o] = s, o > n ? t = t.slice(o) : n > o && (e = e.slice(n)));
   }
  }
  const {optimizationLevel: d = 1} = this.options;
  for (d >= 2 && (e = this.levelTwoFileOptimize(e)), this.debug("matchOne", this, {
   file: e,
   pattern: t
  }), this.debug("matchOne", e.length, t.length), r = 0, i = 0, n = e.length, o = t.length; r < n && i < o; r++, 
  i++) {
   if (this.debug("matchOne loop"), a = t[i], l = e[r], this.debug(t, a, l), !1 === a) return !1;
   if (a === GLOBSTAR) {
    if (this.debug("GLOBSTAR", [ t, a, l ]), c = r, (u = i + 1) === o) {
     for (this.debug("** at the end"); r < n; r++) if ("." === e[r] || ".." === e[r] || !p.dot && "." === e[r].charAt(0)) return !1;
     return !0;
    }
    for (;c < n; ) {
     if (h = e[c], this.debug("\nglobstar while", e, c, t, u, h), this.matchOne(e.slice(c), t.slice(u), s)) return this.debug("globstar found match!", c, n, h), 
     !0;
     if ("." === h || ".." === h || !p.dot && "." === h.charAt(0)) {
      this.debug("dot detected!", e, c, t, u);
      break;
     }
     this.debug("globstar swallow a segment, and continue"), c++;
    }
    return !(!s || (this.debug("\n>>> no match, partial?", e, c, t, u), c !== n));
   }
   let d;
   if ("string" == typeof a ? (d = l === a, this.debug("string match", a, l, d)) : (d = a.test(l), 
   this.debug("pattern match", a, l, d)), !d) return !1;
  }
  if (r === n && i === o) return !0;
  if (r === n) return s;
  if (i === o) return r === n - 1 && "" === e[r];
  throw new Error("wtf?");
 }
 braceExpand() {
  return braceExpand(this.pattern, this.options);
 }
 parse(e) {
  assertValidPattern(e);
  const t = this.options;
  if ("**" === e) return GLOBSTAR;
  if ("" === e) return "";
  let s, r = null;
  (s = e.match(starRE)) ? r = t.dot ? starTestDot : starTest : (s = e.match(starDotExtRE)) ? r = (t.nocase ? t.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : t.dot ? starDotExtTestDot : starDotExtTest)(s[1]) : (s = e.match(qmarksRE)) ? r = (t.nocase ? t.dot ? qmarksTestNocaseDot : qmarksTestNocase : t.dot ? qmarksTestDot : qmarksTest)(s) : (s = e.match(starDotStarRE)) ? r = t.dot ? starDotStarTestDot : starDotStarTest : (s = e.match(dotStarRE)) && (r = dotStarTest);
  const i = AST.fromGlob(e, this.options).toMMPattern();
  return r ? Object.assign(i, {
   test: r
  }) : i;
 }
 makeRe() {
  if (this.regexp || !1 === this.regexp) return this.regexp;
  const e = this.set;
  if (!e.length) return this.regexp = !1, this.regexp;
  const t = this.options, s = t.noglobstar ? "[^/]*?" : t.dot ? "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?" : "(?:(?!(?:\\/|^)\\.).)*?", r = new Set(t.nocase ? [ "i" ] : []);
  let i = e.map((e => {
   const t = e.map((e => {
    if (e instanceof RegExp) for (const t of e.flags.split("")) r.add(t);
    return "string" == typeof e ? e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&") : e === GLOBSTAR ? GLOBSTAR : e._src;
   }));
   return t.forEach(((e, r) => {
    const i = t[r + 1], n = t[r - 1];
    e === GLOBSTAR && n !== GLOBSTAR && (void 0 === n ? void 0 !== i && i !== GLOBSTAR ? t[r + 1] = "(?:\\/|" + s + "\\/)?" + i : t[r] = s : void 0 === i ? t[r - 1] = n + "(?:\\/|" + s + ")?" : i !== GLOBSTAR && (t[r - 1] = n + "(?:\\/|\\/" + s + "\\/)" + i, 
    t[r + 1] = GLOBSTAR));
   })), t.filter((e => e !== GLOBSTAR)).join("/");
  })).join("|");
  const [n, o] = e.length > 1 ? [ "(?:", ")" ] : [ "", "" ];
  i = "^" + n + i + o + "$", this.negate && (i = "^(?!" + i + ").+$");
  try {
   this.regexp = new RegExp(i, [ ...r ].join(""));
  } catch (e) {
   this.regexp = !1;
  }
  return this.regexp;
 }
 slashSplit(e) {
  return this.preserveMultipleSlashes ? e.split("/") : this.isWindows && /^\/\/[^\/]+/.test(e) ? [ "", ...e.split(/\/+/) ] : e.split(/\/+/);
 }
 match(e, t = this.partial) {
  if (this.debug("match", e, this.pattern), this.comment) return !1;
  if (this.empty) return "" === e;
  if ("/" === e && t) return !0;
  const s = this.options;
  this.isWindows && (e = e.split("\\").join("/"));
  const r = this.slashSplit(e);
  this.debug(this.pattern, "split", r);
  const i = this.set;
  this.debug(this.pattern, "set", i);
  let n = r[r.length - 1];
  if (!n) for (let e = r.length - 2; !n && e >= 0; e--) n = r[e];
  for (let e = 0; e < i.length; e++) {
   const o = i[e];
   let a = r;
   if (s.matchBase && 1 === o.length && (a = [ n ]), this.matchOne(a, o, t)) return !!s.flipNegate || !this.negate;
  }
  return !s.flipNegate && this.negate;
 }
 static defaults(e) {
  return minimatch.defaults(e).Minimatch;
 }
}

minimatch.AST = AST, minimatch.Minimatch = Minimatch, minimatch.escape = escape, 
minimatch.unescape = unescape$1;

const require$$0 = getAugmentedNamespace(Object.freeze({
 __proto__: null,
 minimatch,
 sep,
 GLOBSTAR,
 filter,
 defaults,
 braceExpand,
 makeRe,
 match,
 Minimatch,
 AST,
 escape,
 unescape: unescape$1
}));

glob = {}, commonjs$1 = {}, Object.defineProperty(commonjs$1, "__esModule", {
 value: !0
}), LRUCache_1 = commonjs$1.LRUCache = void 0;

const perf = "object" == typeof performance && performance && "function" == typeof performance.now ? performance : Date, warned = new Set, PROCESS = "object" == typeof process && process ? process : {}, emitWarning = (e, t, s, r) => {
 "function" == typeof PROCESS.emitWarning ? PROCESS.emitWarning(e, t, s, r) : console.error(`[${s}] ${t}: ${e}`);
};

let AC = globalThis.AbortController, AS = globalThis.AbortSignal;

if (void 0 === AC) {
 AS = class e {
  onabort;
  _onabort=[];
  reason;
  aborted=!1;
  addEventListener(e, t) {
   this._onabort.push(t);
  }
 }, AC = class e {
  constructor() {
   t();
  }
  signal=new AS;
  abort(e) {
   if (!this.signal.aborted) {
    this.signal.reason = e, this.signal.aborted = !0;
    for (const t of this.signal._onabort) t(e);
    this.signal.onabort?.(e);
   }
  }
 };
 let e = "1" !== PROCESS.env?.LRU_CACHE_IGNORE_AC_WARNING;
 const t = () => {
  e && (e = !1, emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.", "NO_ABORT_CONTROLLER", "ENOTSUP", t));
 };
}

const isPosInt = e => e && e === Math.floor(e) && e > 0 && isFinite(e), getUintArray = e => isPosInt(e) ? e <= Math.pow(2, 8) ? Uint8Array : e <= Math.pow(2, 16) ? Uint16Array : e <= Math.pow(2, 32) ? Uint32Array : e <= Number.MAX_SAFE_INTEGER ? ZeroArray : null : null;

class ZeroArray extends Array {
 constructor(e) {
  super(e), this.fill(0);
 }
}

class Stack {
 heap;
 length;
 static #m=!1;
 static create(e) {
  const t = getUintArray(e);
  if (!t) return [];
  Stack.#m = !0;
  const s = new Stack(e, t);
  return Stack.#m = !1, s;
 }
 constructor(e, t) {
  if (!Stack.#m) throw new TypeError("instantiate Stack using Stack.create(n)");
  this.heap = new t(e), this.length = 0;
 }
 push(e) {
  this.heap[this.length++] = e;
 }
 pop() {
  return this.heap[--this.length];
 }
}

class LRUCache$1 {
 #g;
 #y;
 #v;
 #w;
 #b;
 ttl;
 ttlResolution;
 ttlAutopurge;
 updateAgeOnGet;
 updateAgeOnHas;
 allowStale;
 noDisposeOnSet;
 noUpdateTTL;
 maxEntrySize;
 sizeCalculation;
 noDeleteOnFetchRejection;
 noDeleteOnStaleGet;
 allowStaleOnFetchAbort;
 allowStaleOnFetchRejection;
 ignoreFetchAbort;
 #E;
 #_;
 #S;
 #T;
 #x;
 #$;
 #C;
 #A;
 #k;
 #D;
 #P;
 #O;
 #L;
 #R;
 #N;
 #F;
 #j;
 static unsafeExposeInternals(e) {
  return {
   starts: e.#L,
   ttls: e.#R,
   sizes: e.#O,
   keyMap: e.#S,
   keyList: e.#T,
   valList: e.#x,
   next: e.#$,
   prev: e.#C,
   get head() {
    return e.#A;
   },
   get tail() {
    return e.#k;
   },
   free: e.#D,
   isBackgroundFetch: t => e.#I(t),
   backgroundFetch: (t, s, r, i) => e.#M(t, s, r, i),
   moveToTail: t => e.#B(t),
   indexes: t => e.#U(t),
   rindexes: t => e.#W(t),
   isStale: t => e.#H(t)
  };
 }
 get max() {
  return this.#g;
 }
 get maxSize() {
  return this.#y;
 }
 get calculatedSize() {
  return this.#_;
 }
 get size() {
  return this.#E;
 }
 get fetchMethod() {
  return this.#b;
 }
 get dispose() {
  return this.#v;
 }
 get disposeAfter() {
  return this.#w;
 }
 constructor(e) {
  const {max: t = 0, ttl: s, ttlResolution: r = 1, ttlAutopurge: i, updateAgeOnGet: n, updateAgeOnHas: o, allowStale: a, dispose: l, disposeAfter: c, noDisposeOnSet: u, noUpdateTTL: h, maxSize: p = 0, maxEntrySize: d = 0, sizeCalculation: f, fetchMethod: m, noDeleteOnFetchRejection: g, noDeleteOnStaleGet: y, allowStaleOnFetchRejection: v, allowStaleOnFetchAbort: w, ignoreFetchAbort: b} = e;
  if (0 !== t && !isPosInt(t)) throw new TypeError("max option must be a nonnegative integer");
  const E = t ? getUintArray(t) : Array;
  if (!E) throw new Error("invalid max value: " + t);
  if (this.#g = t, this.#y = p, this.maxEntrySize = d || this.#y, this.sizeCalculation = f, 
  this.sizeCalculation) {
   if (!this.#y && !this.maxEntrySize) throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");
   if ("function" != typeof this.sizeCalculation) throw new TypeError("sizeCalculation set to non-function");
  }
  if (void 0 !== m && "function" != typeof m) throw new TypeError("fetchMethod must be a function if specified");
  if (this.#b = m, this.#F = !!m, this.#S = new Map, this.#T = new Array(t).fill(void 0), 
  this.#x = new Array(t).fill(void 0), this.#$ = new E(t), this.#C = new E(t), this.#A = 0, 
  this.#k = 0, this.#D = Stack.create(t), this.#E = 0, this.#_ = 0, "function" == typeof l && (this.#v = l), 
  "function" == typeof c ? (this.#w = c, this.#P = []) : (this.#w = void 0, this.#P = void 0), 
  this.#N = !!this.#v, this.#j = !!this.#w, this.noDisposeOnSet = !!u, this.noUpdateTTL = !!h, 
  this.noDeleteOnFetchRejection = !!g, this.allowStaleOnFetchRejection = !!v, this.allowStaleOnFetchAbort = !!w, 
  this.ignoreFetchAbort = !!b, 0 !== this.maxEntrySize) {
   if (0 !== this.#y && !isPosInt(this.#y)) throw new TypeError("maxSize must be a positive integer if specified");
   if (!isPosInt(this.maxEntrySize)) throw new TypeError("maxEntrySize must be a positive integer if specified");
   this.#z();
  }
  if (this.allowStale = !!a, this.noDeleteOnStaleGet = !!y, this.updateAgeOnGet = !!n, 
  this.updateAgeOnHas = !!o, this.ttlResolution = isPosInt(r) || 0 === r ? r : 1, 
  this.ttlAutopurge = !!i, this.ttl = s || 0, this.ttl) {
   if (!isPosInt(this.ttl)) throw new TypeError("ttl must be a positive integer if specified");
   this.#G();
  }
  if (0 === this.#g && 0 === this.ttl && 0 === this.#y) throw new TypeError("At least one of max, maxSize, or ttl is required");
  if (!this.ttlAutopurge && !this.#g && !this.#y) {
   const e = "LRU_CACHE_UNBOUNDED";
   (e => !warned.has(e))(e) && (warned.add(e), emitWarning("TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.", "UnboundedCacheWarning", e, LRUCache$1));
  }
 }
 getRemainingTTL(e) {
  return this.#S.has(e) ? 1 / 0 : 0;
 }
 #G() {
  const e = new ZeroArray(this.#g), t = new ZeroArray(this.#g);
  this.#R = e, this.#L = t, this.#q = (s, r, i = perf.now()) => {
   if (t[s] = 0 !== r ? i : 0, e[s] = r, 0 !== r && this.ttlAutopurge) {
    const e = setTimeout((() => {
     this.#H(s) && this.delete(this.#T[s]);
    }), r + 1);
    e.unref && e.unref();
   }
  }, this.#V = s => {
   t[s] = 0 !== e[s] ? perf.now() : 0;
  }, this.#J = (i, n) => {
   if (e[n]) {
    const o = e[n], a = t[n];
    if (!o || !a) return;
    i.ttl = o, i.start = a, i.now = s || r();
    const l = i.now - a;
    i.remainingTTL = o - l;
   }
  };
  let s = 0;
  const r = () => {
   const e = perf.now();
   if (this.ttlResolution > 0) {
    s = e;
    const t = setTimeout((() => s = 0), this.ttlResolution);
    t.unref && t.unref();
   }
   return e;
  };
  this.getRemainingTTL = i => {
   const n = this.#S.get(i);
   if (void 0 === n) return 0;
   const o = e[n], a = t[n];
   return o && a ? o - ((s || r()) - a) : 1 / 0;
  }, this.#H = i => {
   const n = t[i], o = e[i];
   return !!o && !!n && (s || r()) - n > o;
  };
 }
 #V=() => {};
 #J=() => {};
 #q=() => {};
 #H=() => !1;
 #z() {
  const e = new ZeroArray(this.#g);
  this.#_ = 0, this.#O = e, this.#Y = t => {
   this.#_ -= e[t], e[t] = 0;
  }, this.#X = (e, t, s, r) => {
   if (this.#I(t)) return 0;
   if (!isPosInt(s)) {
    if (!r) throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");
    if ("function" != typeof r) throw new TypeError("sizeCalculation must be a function");
    if (s = r(t, e), !isPosInt(s)) throw new TypeError("sizeCalculation return invalid (expect positive integer)");
   }
   return s;
  }, this.#K = (t, s, r) => {
   if (e[t] = s, this.#y) {
    const s = this.#y - e[t];
    for (;this.#_ > s; ) this.#Q(!0);
   }
   this.#_ += e[t], r && (r.entrySize = s, r.totalCalculatedSize = this.#_);
  };
 }
 #Y=e => {};
 #K=(e, t, s) => {};
 #X=(e, t, s, r) => {
  if (s || r) throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");
  return 0;
 };
 * #U({allowStale: e = this.allowStale} = {}) {
  if (this.#E) for (let t = this.#k; this.#Z(t) && (!e && this.#H(t) || (yield t), 
  t !== this.#A); ) t = this.#C[t];
 }
 * #W({allowStale: e = this.allowStale} = {}) {
  if (this.#E) for (let t = this.#A; this.#Z(t) && (!e && this.#H(t) || (yield t), 
  t !== this.#k); ) t = this.#$[t];
 }
 #Z(e) {
  return void 0 !== e && this.#S.get(this.#T[e]) === e;
 }
 * entries() {
  for (const e of this.#U()) void 0 === this.#x[e] || void 0 === this.#T[e] || this.#I(this.#x[e]) || (yield [ this.#T[e], this.#x[e] ]);
 }
 * rentries() {
  for (const e of this.#W()) void 0 === this.#x[e] || void 0 === this.#T[e] || this.#I(this.#x[e]) || (yield [ this.#T[e], this.#x[e] ]);
 }
 * keys() {
  for (const e of this.#U()) {
   const t = this.#T[e];
   void 0 === t || this.#I(this.#x[e]) || (yield t);
  }
 }
 * rkeys() {
  for (const e of this.#W()) {
   const t = this.#T[e];
   void 0 === t || this.#I(this.#x[e]) || (yield t);
  }
 }
 * values() {
  for (const e of this.#U()) void 0 === this.#x[e] || this.#I(this.#x[e]) || (yield this.#x[e]);
 }
 * rvalues() {
  for (const e of this.#W()) void 0 === this.#x[e] || this.#I(this.#x[e]) || (yield this.#x[e]);
 }
 [Symbol.iterator]() {
  return this.entries();
 }
 find(e, t = {}) {
  for (const s of this.#U()) {
   const r = this.#x[s], i = this.#I(r) ? r.__staleWhileFetching : r;
   if (void 0 !== i && e(i, this.#T[s], this)) return this.get(this.#T[s], t);
  }
 }
 forEach(e, t = this) {
  for (const s of this.#U()) {
   const r = this.#x[s], i = this.#I(r) ? r.__staleWhileFetching : r;
   void 0 !== i && e.call(t, i, this.#T[s], this);
  }
 }
 rforEach(e, t = this) {
  for (const s of this.#W()) {
   const r = this.#x[s], i = this.#I(r) ? r.__staleWhileFetching : r;
   void 0 !== i && e.call(t, i, this.#T[s], this);
  }
 }
 purgeStale() {
  let e = !1;
  for (const t of this.#W({
   allowStale: !0
  })) this.#H(t) && (this.delete(this.#T[t]), e = !0);
  return e;
 }
 info(e) {
  const t = this.#S.get(e);
  if (void 0 === t) return;
  const s = this.#x[t], r = this.#I(s) ? s.__staleWhileFetching : s;
  if (void 0 === r) return;
  const i = {
   value: r
  };
  if (this.#R && this.#L) {
   const e = this.#R[t], s = this.#L[t];
   if (e && s) {
    const t = e - (perf.now() - s);
    i.ttl = t, i.start = Date.now();
   }
  }
  return this.#O && (i.size = this.#O[t]), i;
 }
 dump() {
  const e = [];
  for (const t of this.#U({
   allowStale: !0
  })) {
   const s = this.#T[t], r = this.#x[t], i = this.#I(r) ? r.__staleWhileFetching : r;
   if (void 0 === i || void 0 === s) continue;
   const n = {
    value: i
   };
   if (this.#R && this.#L) {
    n.ttl = this.#R[t];
    const e = perf.now() - this.#L[t];
    n.start = Math.floor(Date.now() - e);
   }
   this.#O && (n.size = this.#O[t]), e.unshift([ s, n ]);
  }
  return e;
 }
 load(e) {
  this.clear();
  for (const [t, s] of e) {
   if (s.start) {
    const e = Date.now() - s.start;
    s.start = perf.now() - e;
   }
   this.set(t, s.value, s);
  }
 }
 set(e, t, s = {}) {
  if (void 0 === t) return this.delete(e), this;
  const {ttl: r = this.ttl, start: i, noDisposeOnSet: n = this.noDisposeOnSet, sizeCalculation: o = this.sizeCalculation, status: a} = s;
  let {noUpdateTTL: l = this.noUpdateTTL} = s;
  const c = this.#X(e, t, s.size || 0, o);
  if (this.maxEntrySize && c > this.maxEntrySize) return a && (a.set = "miss", a.maxEntrySizeExceeded = !0), 
  this.delete(e), this;
  let u = 0 === this.#E ? void 0 : this.#S.get(e);
  if (void 0 === u) u = 0 === this.#E ? this.#k : 0 !== this.#D.length ? this.#D.pop() : this.#E === this.#g ? this.#Q(!1) : this.#E, 
  this.#T[u] = e, this.#x[u] = t, this.#S.set(e, u), this.#$[this.#k] = u, this.#C[u] = this.#k, 
  this.#k = u, this.#E++, this.#K(u, c, a), a && (a.set = "add"), l = !1; else {
   this.#B(u);
   const s = this.#x[u];
   if (t !== s) {
    if (this.#F && this.#I(s)) {
     s.__abortController.abort(new Error("replaced"));
     const {__staleWhileFetching: t} = s;
     void 0 === t || n || (this.#N && this.#v?.(t, e, "set"), this.#j && this.#P?.push([ t, e, "set" ]));
    } else n || (this.#N && this.#v?.(s, e, "set"), this.#j && this.#P?.push([ s, e, "set" ]));
    if (this.#Y(u), this.#K(u, c, a), this.#x[u] = t, a) {
     a.set = "replace";
     const e = s && this.#I(s) ? s.__staleWhileFetching : s;
     void 0 !== e && (a.oldValue = e);
    }
   } else a && (a.set = "update");
  }
  if (0 === r || this.#R || this.#G(), this.#R && (l || this.#q(u, r, i), a && this.#J(a, u)), 
  !n && this.#j && this.#P) {
   const e = this.#P;
   let t;
   for (;t = e?.shift(); ) this.#w?.(...t);
  }
  return this;
 }
 pop() {
  try {
   for (;this.#E; ) {
    const e = this.#x[this.#A];
    if (this.#Q(!0), this.#I(e)) {
     if (e.__staleWhileFetching) return e.__staleWhileFetching;
    } else if (void 0 !== e) return e;
   }
  } finally {
   if (this.#j && this.#P) {
    const e = this.#P;
    let t;
    for (;t = e?.shift(); ) this.#w?.(...t);
   }
  }
 }
 #Q(e) {
  const t = this.#A, s = this.#T[t], r = this.#x[t];
  return this.#F && this.#I(r) ? r.__abortController.abort(new Error("evicted")) : (this.#N || this.#j) && (this.#N && this.#v?.(r, s, "evict"), 
  this.#j && this.#P?.push([ r, s, "evict" ])), this.#Y(t), e && (this.#T[t] = void 0, 
  this.#x[t] = void 0, this.#D.push(t)), 1 === this.#E ? (this.#A = this.#k = 0, this.#D.length = 0) : this.#A = this.#$[t], 
  this.#S.delete(s), this.#E--, t;
 }
 has(e, t = {}) {
  const {updateAgeOnHas: s = this.updateAgeOnHas, status: r} = t, i = this.#S.get(e);
  if (void 0 !== i) {
   const e = this.#x[i];
   if (this.#I(e) && void 0 === e.__staleWhileFetching) return !1;
   if (!this.#H(i)) return s && this.#V(i), r && (r.has = "hit", this.#J(r, i)), !0;
   r && (r.has = "stale", this.#J(r, i));
  } else r && (r.has = "miss");
  return !1;
 }
 peek(e, t = {}) {
  const {allowStale: s = this.allowStale} = t, r = this.#S.get(e);
  if (void 0 === r || !s && this.#H(r)) return;
  const i = this.#x[r];
  return this.#I(i) ? i.__staleWhileFetching : i;
 }
 #M(e, t, s, r) {
  const i = void 0 === t ? void 0 : this.#x[t];
  if (this.#I(i)) return i;
  const n = new AC, {signal: o} = s;
  o?.addEventListener("abort", (() => n.abort(o.reason)), {
   signal: n.signal
  });
  const a = {
   signal: n.signal,
   options: s,
   context: r
  }, l = (r, i = !1) => {
   const {aborted: o} = n.signal, l = s.ignoreFetchAbort && void 0 !== r;
   if (s.status && (o && !i ? (s.status.fetchAborted = !0, s.status.fetchError = n.signal.reason, 
   l && (s.status.fetchAbortIgnored = !0)) : s.status.fetchResolved = !0), o && !l && !i) return c(n.signal.reason);
   const h = u;
   return this.#x[t] === u && (void 0 === r ? h.__staleWhileFetching ? this.#x[t] = h.__staleWhileFetching : this.delete(e) : (s.status && (s.status.fetchUpdated = !0), 
   this.set(e, r, a.options))), r;
  }, c = r => {
   const {aborted: i} = n.signal, o = i && s.allowStaleOnFetchAbort, a = o || s.allowStaleOnFetchRejection, l = a || s.noDeleteOnFetchRejection, c = u;
   if (this.#x[t] === u && (l && void 0 !== c.__staleWhileFetching ? o || (this.#x[t] = c.__staleWhileFetching) : this.delete(e)), 
   a) return s.status && void 0 !== c.__staleWhileFetching && (s.status.returnedStale = !0), 
   c.__staleWhileFetching;
   if (c.__returned === c) throw r;
  };
  s.status && (s.status.fetchDispatched = !0);
  const u = new Promise(((t, r) => {
   const o = this.#b?.(e, i, a);
   o && o instanceof Promise && o.then((e => t(void 0 === e ? void 0 : e)), r), n.signal.addEventListener("abort", (() => {
    s.ignoreFetchAbort && !s.allowStaleOnFetchAbort || (t(void 0), s.allowStaleOnFetchAbort && (t = e => l(e, !0)));
   }));
  })).then(l, (e => (s.status && (s.status.fetchRejected = !0, s.status.fetchError = e), 
  c(e)))), h = Object.assign(u, {
   __abortController: n,
   __staleWhileFetching: i,
   __returned: void 0
  });
  return void 0 === t ? (this.set(e, h, {
   ...a.options,
   status: void 0
  }), t = this.#S.get(e)) : this.#x[t] = h, h;
 }
 #I(e) {
  if (!this.#F) return !1;
  const t = e;
  return !!t && t instanceof Promise && t.hasOwnProperty("__staleWhileFetching") && t.__abortController instanceof AC;
 }
 async fetch(e, t = {}) {
  const {allowStale: s = this.allowStale, updateAgeOnGet: r = this.updateAgeOnGet, noDeleteOnStaleGet: i = this.noDeleteOnStaleGet, ttl: n = this.ttl, noDisposeOnSet: o = this.noDisposeOnSet, size: a = 0, sizeCalculation: l = this.sizeCalculation, noUpdateTTL: c = this.noUpdateTTL, noDeleteOnFetchRejection: u = this.noDeleteOnFetchRejection, allowStaleOnFetchRejection: h = this.allowStaleOnFetchRejection, ignoreFetchAbort: p = this.ignoreFetchAbort, allowStaleOnFetchAbort: d = this.allowStaleOnFetchAbort, context: f, forceRefresh: m = !1, status: g, signal: y} = t;
  if (!this.#F) return g && (g.fetch = "get"), this.get(e, {
   allowStale: s,
   updateAgeOnGet: r,
   noDeleteOnStaleGet: i,
   status: g
  });
  const v = {
   allowStale: s,
   updateAgeOnGet: r,
   noDeleteOnStaleGet: i,
   ttl: n,
   noDisposeOnSet: o,
   size: a,
   sizeCalculation: l,
   noUpdateTTL: c,
   noDeleteOnFetchRejection: u,
   allowStaleOnFetchRejection: h,
   allowStaleOnFetchAbort: d,
   ignoreFetchAbort: p,
   status: g,
   signal: y
  };
  let w = this.#S.get(e);
  if (void 0 === w) {
   g && (g.fetch = "miss");
   const t = this.#M(e, w, v, f);
   return t.__returned = t;
  }
  {
   const t = this.#x[w];
   if (this.#I(t)) {
    const e = s && void 0 !== t.__staleWhileFetching;
    return g && (g.fetch = "inflight", e && (g.returnedStale = !0)), e ? t.__staleWhileFetching : t.__returned = t;
   }
   const i = this.#H(w);
   if (!m && !i) return g && (g.fetch = "hit"), this.#B(w), r && this.#V(w), g && this.#J(g, w), 
   t;
   const n = this.#M(e, w, v, f), o = void 0 !== n.__staleWhileFetching && s;
   return g && (g.fetch = i ? "stale" : "refresh", o && i && (g.returnedStale = !0)), 
   o ? n.__staleWhileFetching : n.__returned = n;
  }
 }
 get(e, t = {}) {
  const {allowStale: s = this.allowStale, updateAgeOnGet: r = this.updateAgeOnGet, noDeleteOnStaleGet: i = this.noDeleteOnStaleGet, status: n} = t, o = this.#S.get(e);
  if (void 0 !== o) {
   const t = this.#x[o], a = this.#I(t);
   return n && this.#J(n, o), this.#H(o) ? (n && (n.get = "stale"), a ? (n && s && void 0 !== t.__staleWhileFetching && (n.returnedStale = !0), 
   s ? t.__staleWhileFetching : void 0) : (i || this.delete(e), n && s && (n.returnedStale = !0), 
   s ? t : void 0)) : (n && (n.get = "hit"), a ? t.__staleWhileFetching : (this.#B(o), 
   r && this.#V(o), t));
  }
  n && (n.get = "miss");
 }
 #ee(e, t) {
  this.#C[t] = e, this.#$[e] = t;
 }
 #B(e) {
  e !== this.#k && (e === this.#A ? this.#A = this.#$[e] : this.#ee(this.#C[e], this.#$[e]), 
  this.#ee(this.#k, e), this.#k = e);
 }
 delete(e) {
  let t = !1;
  if (0 !== this.#E) {
   const s = this.#S.get(e);
   if (void 0 !== s) if (t = !0, 1 === this.#E) this.clear(); else {
    this.#Y(s);
    const t = this.#x[s];
    if (this.#I(t) ? t.__abortController.abort(new Error("deleted")) : (this.#N || this.#j) && (this.#N && this.#v?.(t, e, "delete"), 
    this.#j && this.#P?.push([ t, e, "delete" ])), this.#S.delete(e), this.#T[s] = void 0, 
    this.#x[s] = void 0, s === this.#k) this.#k = this.#C[s]; else if (s === this.#A) this.#A = this.#$[s]; else {
     const e = this.#C[s];
     this.#$[e] = this.#$[s];
     const t = this.#$[s];
     this.#C[t] = this.#C[s];
    }
    this.#E--, this.#D.push(s);
   }
  }
  if (this.#j && this.#P?.length) {
   const e = this.#P;
   let t;
   for (;t = e?.shift(); ) this.#w?.(...t);
  }
  return t;
 }
 clear() {
  for (const e of this.#W({
   allowStale: !0
  })) {
   const t = this.#x[e];
   if (this.#I(t)) t.__abortController.abort(new Error("deleted")); else {
    const s = this.#T[e];
    this.#N && this.#v?.(t, s, "delete"), this.#j && this.#P?.push([ t, s, "delete" ]);
   }
  }
  if (this.#S.clear(), this.#x.fill(void 0), this.#T.fill(void 0), this.#R && this.#L && (this.#R.fill(0), 
  this.#L.fill(0)), this.#O && this.#O.fill(0), this.#A = 0, this.#k = 0, this.#D.length = 0, 
  this.#_ = 0, this.#E = 0, this.#j && this.#P) {
   const e = this.#P;
   let t;
   for (;t = e?.shift(); ) this.#w?.(...t);
  }
 }
}

LRUCache_1 = commonjs$1.LRUCache = LRUCache$1, function(e) {
 var t = commonjsGlobal && commonjsGlobal.__importDefault || function(e) {
  return e && e.__esModule ? e : {
   default: e
  };
 };
 Object.defineProperty(e, "__esModule", {
  value: !0
 }), e.Minipass = e.isWritable = e.isReadable = e.isStream = void 0;
 const s = "object" == typeof process && process ? process : {
  stdout: null,
  stderr: null
 }, r = require$$7__default.default, i = t(require$$0__default$1.default), n = require$$2__default.default;
 e.isStream = t => !!t && "object" == typeof t && (t instanceof U || t instanceof i.default || (0, 
 e.isReadable)(t) || (0, e.isWritable)(t)), e.isReadable = e => !!e && "object" == typeof e && e instanceof r.EventEmitter && "function" == typeof e.pipe && e.pipe !== i.default.Writable.prototype.pipe, 
 e.isWritable = e => !!e && "object" == typeof e && e instanceof r.EventEmitter && "function" == typeof e.write && "function" == typeof e.end;
 const o = Symbol("EOF"), a = Symbol("maybeEmitEnd"), l = Symbol("emittedEnd"), c = Symbol("emittingEnd"), u = Symbol("emittedError"), h = Symbol("closed"), p = Symbol("read"), d = Symbol("flush"), f = Symbol("flushChunk"), m = Symbol("encoding"), g = Symbol("decoder"), y = Symbol("flowing"), v = Symbol("paused"), w = Symbol("resume"), b = Symbol("buffer"), E = Symbol("pipes"), _ = Symbol("bufferLength"), S = Symbol("bufferPush"), T = Symbol("bufferShift"), x = Symbol("objectMode"), $ = Symbol("destroyed"), C = Symbol("error"), A = Symbol("emitData"), k = Symbol("emitEnd"), D = Symbol("emitEnd2"), P = Symbol("async"), O = Symbol("abort"), L = Symbol("aborted"), R = Symbol("signal"), N = Symbol("dataListeners"), F = Symbol("discarded"), j = e => Promise.resolve().then(e), I = e => e();
 class M {
  src;
  dest;
  opts;
  ondrain;
  constructor(e, t, s) {
   this.src = e, this.dest = t, this.opts = s, this.ondrain = () => e[w](), this.dest.on("drain", this.ondrain);
  }
  unpipe() {
   this.dest.removeListener("drain", this.ondrain);
  }
  proxyErrors(e) {}
  end() {
   this.unpipe(), this.opts.end && this.dest.end();
  }
 }
 class B extends M {
  unpipe() {
   this.src.removeListener("error", this.proxyErrors), super.unpipe();
  }
  constructor(e, t, s) {
   super(e, t, s), this.proxyErrors = e => t.emit("error", e), e.on("error", this.proxyErrors);
  }
 }
 class U extends r.EventEmitter {
  [y]=!1;
  [v]=!1;
  [E]=[];
  [b]=[];
  [x];
  [m];
  [P];
  [g];
  [o]=!1;
  [l]=!1;
  [c]=!1;
  [h]=!1;
  [u]=null;
  [_]=0;
  [$]=!1;
  [R];
  [L]=!1;
  [N]=0;
  [F]=!1;
  writable=!0;
  readable=!0;
  constructor(...e) {
   const t = e[0] || {};
   if (super(), t.objectMode && "string" == typeof t.encoding) throw new TypeError("Encoding and objectMode may not be used together");
   var s;
   t.objectMode ? (this[x] = !0, this[m] = null) : !(s = t).objectMode && s.encoding && "buffer" !== s.encoding ? (this[m] = t.encoding, 
   this[x] = !1) : (this[x] = !1, this[m] = null), this[P] = !!t.async, this[g] = this[m] ? new n.StringDecoder(this[m]) : null, 
   t && !0 === t.debugExposeBuffer && Object.defineProperty(this, "buffer", {
    get: () => this[b]
   }), t && !0 === t.debugExposePipes && Object.defineProperty(this, "pipes", {
    get: () => this[E]
   });
   const {signal: r} = t;
   r && (this[R] = r, r.aborted ? this[O]() : r.addEventListener("abort", (() => this[O]())));
  }
  get bufferLength() {
   return this[_];
  }
  get encoding() {
   return this[m];
  }
  set encoding(e) {
   throw new Error("Encoding must be set at instantiation time");
  }
  setEncoding(e) {
   throw new Error("Encoding must be set at instantiation time");
  }
  get objectMode() {
   return this[x];
  }
  set objectMode(e) {
   throw new Error("objectMode must be set at instantiation time");
  }
  get async() {
   return this[P];
  }
  set async(e) {
   this[P] = this[P] || !!e;
  }
  [O]() {
   this[L] = !0, this.emit("abort", this[R]?.reason), this.destroy(this[R]?.reason);
  }
  get aborted() {
   return this[L];
  }
  set aborted(e) {}
  write(e, t, s) {
   if (this[L]) return !1;
   if (this[o]) throw new Error("write after end");
   if (this[$]) return this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), {
    code: "ERR_STREAM_DESTROYED"
   })), !0;
   "function" == typeof t && (s = t, t = "utf8"), t || (t = "utf8");
   const r = this[P] ? j : I;
   if (!this[x] && !Buffer.isBuffer(e)) if (i = e, !Buffer.isBuffer(i) && ArrayBuffer.isView(i)) e = Buffer.from(e.buffer, e.byteOffset, e.byteLength); else if ((e => e instanceof ArrayBuffer || !!e && "object" == typeof e && e.constructor && "ArrayBuffer" === e.constructor.name && e.byteLength >= 0)(e)) e = Buffer.from(e); else if ("string" != typeof e) throw new Error("Non-contiguous data written to non-objectMode stream");
   var i;
   return this[x] ? (this[y] && 0 !== this[_] && this[d](!0), this[y] ? this.emit("data", e) : this[S](e), 
   0 !== this[_] && this.emit("readable"), s && r(s), this[y]) : e.length ? ("string" != typeof e || t === this[m] && !this[g]?.lastNeed || (e = Buffer.from(e, t)), 
   Buffer.isBuffer(e) && this[m] && (e = this[g].write(e)), this[y] && 0 !== this[_] && this[d](!0), 
   this[y] ? this.emit("data", e) : this[S](e), 0 !== this[_] && this.emit("readable"), 
   s && r(s), this[y]) : (0 !== this[_] && this.emit("readable"), s && r(s), this[y]);
  }
  read(e) {
   if (this[$]) return null;
   if (this[F] = !1, 0 === this[_] || 0 === e || e && e > this[_]) return this[a](), 
   null;
   this[x] && (e = null), this[b].length > 1 && !this[x] && (this[b] = [ this[m] ? this[b].join("") : Buffer.concat(this[b], this[_]) ]);
   const t = this[p](e || null, this[b][0]);
   return this[a](), t;
  }
  [p](e, t) {
   if (this[x]) this[T](); else {
    const s = t;
    e === s.length || null === e ? this[T]() : "string" == typeof s ? (this[b][0] = s.slice(e), 
    t = s.slice(0, e), this[_] -= e) : (this[b][0] = s.subarray(e), t = s.subarray(0, e), 
    this[_] -= e);
   }
   return this.emit("data", t), this[b].length || this[o] || this.emit("drain"), t;
  }
  end(e, t, s) {
   return "function" == typeof e && (s = e, e = void 0), "function" == typeof t && (s = t, 
   t = "utf8"), void 0 !== e && this.write(e, t), s && this.once("end", s), this[o] = !0, 
   this.writable = !1, !this[y] && this[v] || this[a](), this;
  }
  [w]() {
   this[$] || (this[N] || this[E].length || (this[F] = !0), this[v] = !1, this[y] = !0, 
   this.emit("resume"), this[b].length ? this[d]() : this[o] ? this[a]() : this.emit("drain"));
  }
  resume() {
   return this[w]();
  }
  pause() {
   this[y] = !1, this[v] = !0, this[F] = !1;
  }
  get destroyed() {
   return this[$];
  }
  get flowing() {
   return this[y];
  }
  get paused() {
   return this[v];
  }
  [S](e) {
   this[x] ? this[_] += 1 : this[_] += e.length, this[b].push(e);
  }
  [T]() {
   return this[x] ? this[_] -= 1 : this[_] -= this[b][0].length, this[b].shift();
  }
  [d](e = !1) {
   do {} while (this[f](this[T]()) && this[b].length);
   e || this[b].length || this[o] || this.emit("drain");
  }
  [f](e) {
   return this.emit("data", e), this[y];
  }
  pipe(e, t) {
   if (this[$]) return e;
   this[F] = !1;
   const r = this[l];
   return t = t || {}, e === s.stdout || e === s.stderr ? t.end = !1 : t.end = !1 !== t.end, 
   t.proxyErrors = !!t.proxyErrors, r ? t.end && e.end() : (this[E].push(t.proxyErrors ? new B(this, e, t) : new M(this, e, t)), 
   this[P] ? j((() => this[w]())) : this[w]()), e;
  }
  unpipe(e) {
   const t = this[E].find((t => t.dest === e));
   t && (1 === this[E].length ? (this[y] && 0 === this[N] && (this[y] = !1), this[E] = []) : this[E].splice(this[E].indexOf(t), 1), 
   t.unpipe());
  }
  addListener(e, t) {
   return this.on(e, t);
  }
  on(e, t) {
   const s = super.on(e, t);
   if ("data" === e) this[F] = !1, this[N]++, this[E].length || this[y] || this[w](); else if ("readable" === e && 0 !== this[_]) super.emit("readable"); else if ((e => "end" === e || "finish" === e || "prefinish" === e)(e) && this[l]) super.emit(e), 
   this.removeAllListeners(e); else if ("error" === e && this[u]) {
    const e = t;
    this[P] ? j((() => e.call(this, this[u]))) : e.call(this, this[u]);
   }
   return s;
  }
  removeListener(e, t) {
   return this.off(e, t);
  }
  off(e, t) {
   const s = super.off(e, t);
   return "data" === e && (this[N] = this.listeners("data").length, 0 !== this[N] || this[F] || this[E].length || (this[y] = !1)), 
   s;
  }
  removeAllListeners(e) {
   const t = super.removeAllListeners(e);
   return "data" !== e && void 0 !== e || (this[N] = 0, this[F] || this[E].length || (this[y] = !1)), 
   t;
  }
  get emittedEnd() {
   return this[l];
  }
  [a]() {
   this[c] || this[l] || this[$] || 0 !== this[b].length || !this[o] || (this[c] = !0, 
   this.emit("end"), this.emit("prefinish"), this.emit("finish"), this[h] && this.emit("close"), 
   this[c] = !1);
  }
  emit(e, ...t) {
   const s = t[0];
   if ("error" !== e && "close" !== e && e !== $ && this[$]) return !1;
   if ("data" === e) return !(!this[x] && !s) && (this[P] ? (j((() => this[A](s))), 
   !0) : this[A](s));
   if ("end" === e) return this[k]();
   if ("close" === e) {
    if (this[h] = !0, !this[l] && !this[$]) return !1;
    const e = super.emit("close");
    return this.removeAllListeners("close"), e;
   }
   if ("error" === e) {
    this[u] = s, super.emit(C, s);
    const e = !(this[R] && !this.listeners("error").length) && super.emit("error", s);
    return this[a](), e;
   }
   if ("resume" === e) {
    const e = super.emit("resume");
    return this[a](), e;
   }
   if ("finish" === e || "prefinish" === e) {
    const t = super.emit(e);
    return this.removeAllListeners(e), t;
   }
   const r = super.emit(e, ...t);
   return this[a](), r;
  }
  [A](e) {
   for (const t of this[E]) !1 === t.dest.write(e) && this.pause();
   const t = !this[F] && super.emit("data", e);
   return this[a](), t;
  }
  [k]() {
   return !this[l] && (this[l] = !0, this.readable = !1, this[P] ? (j((() => this[D]())), 
   !0) : this[D]());
  }
  [D]() {
   if (this[g]) {
    const e = this[g].end();
    if (e) {
     for (const t of this[E]) t.dest.write(e);
     this[F] || super.emit("data", e);
    }
   }
   for (const e of this[E]) e.end();
   const e = super.emit("end");
   return this.removeAllListeners("end"), e;
  }
  async collect() {
   const e = Object.assign([], {
    dataLength: 0
   });
   this[x] || (e.dataLength = 0);
   const t = this.promise();
   return this.on("data", (t => {
    e.push(t), this[x] || (e.dataLength += t.length);
   })), await t, e;
  }
  async concat() {
   if (this[x]) throw new Error("cannot concat in objectMode");
   const e = await this.collect();
   return this[m] ? e.join("") : Buffer.concat(e, e.dataLength);
  }
  async promise() {
   return new Promise(((e, t) => {
    this.on($, (() => t(new Error("stream destroyed")))), this.on("error", (e => t(e))), 
    this.on("end", (() => e()));
   }));
  }
  [Symbol.asyncIterator]() {
   this[F] = !1;
   let e = !1;
   const t = async () => (this.pause(), e = !0, {
    value: void 0,
    done: !0
   });
   return {
    next: () => {
     if (e) return t();
     const s = this.read();
     if (null !== s) return Promise.resolve({
      done: !1,
      value: s
     });
     if (this[o]) return t();
     let r, i;
     const n = e => {
      this.off("data", a), this.off("end", l), this.off($, c), t(), i(e);
     }, a = e => {
      this.off("error", n), this.off("end", l), this.off($, c), this.pause(), r({
       value: e,
       done: !!this[o]
      });
     }, l = () => {
      this.off("error", n), this.off("data", a), this.off($, c), t(), r({
       done: !0,
       value: void 0
      });
     }, c = () => n(new Error("stream destroyed"));
     return new Promise(((e, t) => {
      i = t, r = e, this.once($, c), this.once("error", n), this.once("end", l), this.once("data", a);
     }));
    },
    throw: t,
    return: t,
    [Symbol.asyncIterator]() {
     return this;
    }
   };
  }
  [Symbol.iterator]() {
   this[F] = !1;
   let e = !1;
   const t = () => (this.pause(), this.off(C, t), this.off($, t), this.off("end", t), 
   e = !0, {
    done: !0,
    value: void 0
   });
   return this.once("end", t), this.once(C, t), this.once($, t), {
    next: () => {
     if (e) return t();
     const s = this.read();
     return null === s ? t() : {
      done: !1,
      value: s
     };
    },
    throw: t,
    return: t,
    [Symbol.iterator]() {
     return this;
    }
   };
  }
  destroy(e) {
   return this[$] ? (e ? this.emit("error", e) : this.emit($), this) : (this[$] = !0, 
   this[F] = !0, this[b].length = 0, this[_] = 0, "function" != typeof this.close || this[h] || this.close(), 
   e ? this.emit("error", e) : this.emit($), this);
  }
  static get isStream() {
   return e.isStream;
  }
 }
 e.Minipass = U;
}(commonjs = {});

const realpathSync = fs$6.realpathSync.native, defaultFS = {
 lstatSync: fs$6.lstatSync,
 readdir: fs$6.readdir,
 readdirSync: fs$6.readdirSync,
 readlinkSync: fs$6.readlinkSync,
 realpathSync,
 promises: {
  lstat: promises.lstat,
  readdir: promises.readdir,
  readlink: promises.readlink,
  realpath: promises.realpath
 }
}, fsFromOption = e => e && e !== defaultFS && e !== fs__namespace ? {
 ...defaultFS,
 ...e,
 promises: {
  ...defaultFS.promises,
  ...e.promises || {}
 }
} : defaultFS, uncDriveRegexp = /^\\\\\?\\([a-z]:)\\?$/i, eitherSep = /[\\\/]/, entToType = e => e.isFile() ? 8 : e.isDirectory() ? 4 : e.isSymbolicLink() ? 10 : e.isCharacterDevice() ? 2 : e.isBlockDevice() ? 6 : e.isSocket() ? 12 : e.isFIFO() ? 1 : 0, normalizeCache = new Map, normalize = e => {
 const t = normalizeCache.get(e);
 if (t) return t;
 const s = e.normalize("NFKD");
 return normalizeCache.set(e, s), s;
}, normalizeNocaseCache = new Map, normalizeNocase = e => {
 const t = normalizeNocaseCache.get(e);
 if (t) return t;
 const s = normalize(e.toLowerCase());
 return normalizeNocaseCache.set(e, s), s;
};

class ResolveCache extends LRUCache_1 {
 constructor() {
  super({
   max: 256
  });
 }
}

class ChildrenCache extends LRUCache_1 {
 constructor(e = 16384) {
  super({
   maxSize: e,
   sizeCalculation: e => e.length + 1
  });
 }
}

const setAsCwd = Symbol("PathScurry setAsCwd");

class PathBase {
 name;
 root;
 roots;
 parent;
 nocase;
 #te;
 #se;
 get dev() {
  return this.#se;
 }
 #re;
 get mode() {
  return this.#re;
 }
 #ie;
 get nlink() {
  return this.#ie;
 }
 #ne;
 get uid() {
  return this.#ne;
 }
 #oe;
 get gid() {
  return this.#oe;
 }
 #ae;
 get rdev() {
  return this.#ae;
 }
 #le;
 get blksize() {
  return this.#le;
 }
 #ce;
 get ino() {
  return this.#ce;
 }
 #E;
 get size() {
  return this.#E;
 }
 #ue;
 get blocks() {
  return this.#ue;
 }
 #he;
 get atimeMs() {
  return this.#he;
 }
 #pe;
 get mtimeMs() {
  return this.#pe;
 }
 #de;
 get ctimeMs() {
  return this.#de;
 }
 #fe;
 get birthtimeMs() {
  return this.#fe;
 }
 #me;
 get atime() {
  return this.#me;
 }
 #ge;
 get mtime() {
  return this.#ge;
 }
 #ye;
 get ctime() {
  return this.#ye;
 }
 #ve;
 get birthtime() {
  return this.#ve;
 }
 #we;
 #be;
 #Ee;
 #_e;
 #Se;
 #Te;
 #xe;
 #$e;
 #Ce;
 #Ae;
 get path() {
  return (this.parent || this).fullpath();
 }
 constructor(e, t = 0, s, r, i, n, o) {
  this.name = e, this.#we = i ? normalizeNocase(e) : normalize(e), this.#xe = 1023 & t, 
  this.nocase = i, this.roots = r, this.root = s || this, this.#$e = n, this.#Ee = o.fullpath, 
  this.#Se = o.relative, this.#Te = o.relativePosix, this.parent = o.parent, this.parent ? this.#te = this.parent.#te : this.#te = fsFromOption(o.fs);
 }
 depth() {
  return void 0 !== this.#be ? this.#be : this.parent ? this.#be = this.parent.depth() + 1 : this.#be = 0;
 }
 childrenCache() {
  return this.#$e;
 }
 resolve(e) {
  if (!e) return this;
  const t = this.getRootString(e), s = e.substring(t.length).split(this.splitSep);
  return t ? this.getRoot(t).#ke(s) : this.#ke(s);
 }
 #ke(e) {
  let t = this;
  for (const s of e) t = t.child(s);
  return t;
 }
 children() {
  const e = this.#$e.get(this);
  if (e) return e;
  const t = Object.assign([], {
   provisional: 0
  });
  return this.#$e.set(this, t), this.#xe &= -17, t;
 }
 child(e, t) {
  if ("" === e || "." === e) return this;
  if (".." === e) return this.parent || this;
  const s = this.children(), r = this.nocase ? normalizeNocase(e) : normalize(e);
  for (const e of s) if (e.#we === r) return e;
  const i = this.parent ? this.sep : "", n = this.#Ee ? this.#Ee + i + e : void 0, o = this.newChild(e, 0, {
   ...t,
   parent: this,
   fullpath: n
  });
  return this.canReaddir() || (o.#xe |= 128), s.push(o), o;
 }
 relative() {
  if (void 0 !== this.#Se) return this.#Se;
  const e = this.name, t = this.parent;
  if (!t) return this.#Se = this.name;
  const s = t.relative();
  return s + (s && t.parent ? this.sep : "") + e;
 }
 relativePosix() {
  if ("/" === this.sep) return this.relative();
  if (void 0 !== this.#Te) return this.#Te;
  const e = this.name, t = this.parent;
  if (!t) return this.#Te = this.fullpathPosix();
  const s = t.relativePosix();
  return s + (s && t.parent ? "/" : "") + e;
 }
 fullpath() {
  if (void 0 !== this.#Ee) return this.#Ee;
  const e = this.name, t = this.parent;
  if (!t) return this.#Ee = this.name;
  const s = t.fullpath() + (t.parent ? this.sep : "") + e;
  return this.#Ee = s;
 }
 fullpathPosix() {
  if (void 0 !== this.#_e) return this.#_e;
  if ("/" === this.sep) return this.#_e = this.fullpath();
  if (!this.parent) {
   const e = this.fullpath().replace(/\\/g, "/");
   return /^[a-z]:\//i.test(e) ? this.#_e = `//?/${e}` : this.#_e = e;
  }
  const e = this.parent, t = e.fullpathPosix(), s = t + (t && e.parent ? "/" : "") + this.name;
  return this.#_e = s;
 }
 isUnknown() {
  return !(15 & this.#xe);
 }
 isType(e) {
  return this[`is${e}`]();
 }
 getType() {
  return this.isUnknown() ? "Unknown" : this.isDirectory() ? "Directory" : this.isFile() ? "File" : this.isSymbolicLink() ? "SymbolicLink" : this.isFIFO() ? "FIFO" : this.isCharacterDevice() ? "CharacterDevice" : this.isBlockDevice() ? "BlockDevice" : this.isSocket() ? "Socket" : "Unknown";
 }
 isFile() {
  return 8 == (15 & this.#xe);
 }
 isDirectory() {
  return 4 == (15 & this.#xe);
 }
 isCharacterDevice() {
  return 2 == (15 & this.#xe);
 }
 isBlockDevice() {
  return 6 == (15 & this.#xe);
 }
 isFIFO() {
  return 1 == (15 & this.#xe);
 }
 isSocket() {
  return 12 == (15 & this.#xe);
 }
 isSymbolicLink() {
  return !(10 & ~this.#xe);
 }
 lstatCached() {
  return 32 & this.#xe ? this : void 0;
 }
 readlinkCached() {
  return this.#Ce;
 }
 realpathCached() {
  return this.#Ae;
 }
 readdirCached() {
  const e = this.children();
  return e.slice(0, e.provisional);
 }
 canReadlink() {
  if (this.#Ce) return !0;
  if (!this.parent) return !1;
  const e = 15 & this.#xe;
  return !(0 !== e && 10 !== e || 256 & this.#xe || 128 & this.#xe);
 }
 calledReaddir() {
  return !!(16 & this.#xe);
 }
 isENOENT() {
  return !!(128 & this.#xe);
 }
 isNamed(e) {
  return this.nocase ? this.#we === normalizeNocase(e) : this.#we === normalize(e);
 }
 async readlink() {
  const e = this.#Ce;
  if (e) return e;
  if (this.canReadlink() && this.parent) try {
   const e = await this.#te.promises.readlink(this.fullpath()), t = this.parent.resolve(e);
   if (t) return this.#Ce = t;
  } catch (e) {
   return void this.#De(e.code);
  }
 }
 readlinkSync() {
  const e = this.#Ce;
  if (e) return e;
  if (this.canReadlink() && this.parent) try {
   const e = this.#te.readlinkSync(this.fullpath()), t = this.parent.resolve(e);
   if (t) return this.#Ce = t;
  } catch (e) {
   return void this.#De(e.code);
  }
 }
 #Pe(e) {
  this.#xe |= 16;
  for (let t = e.provisional; t < e.length; t++) e[t].#Oe();
 }
 #Oe() {
  128 & this.#xe || (this.#xe = -16 & this.#xe | 128, this.#Le());
 }
 #Le() {
  const e = this.children();
  e.provisional = 0;
  for (const t of e) t.#Oe();
 }
 #Re() {
  this.#xe |= 512, this.#Ne();
 }
 #Ne() {
  if (64 & this.#xe) return;
  let e = this.#xe;
  4 == (15 & e) && (e &= -16), this.#xe = 64 | e, this.#Le();
 }
 #Fe(e = "") {
  "ENOTDIR" === e || "EPERM" === e ? this.#Ne() : "ENOENT" === e ? this.#Oe() : this.children().provisional = 0;
 }
 #je(e = "") {
  "ENOTDIR" === e ? this.parent.#Ne() : "ENOENT" === e && this.#Oe();
 }
 #De(e = "") {
  let t = this.#xe;
  t |= 256, "ENOENT" === e && (t |= 128), "EINVAL" !== e && "UNKNOWN" !== e || (t &= -16), 
  this.#xe = t, "ENOTDIR" === e && this.parent && this.parent.#Ne();
 }
 #Ie(e, t) {
  return this.#Me(e, t) || this.#Be(e, t);
 }
 #Be(e, t) {
  const s = entToType(e), r = this.newChild(e.name, s, {
   parent: this
  }), i = 15 & r.#xe;
  return 4 !== i && 10 !== i && 0 !== i && (r.#xe |= 64), t.unshift(r), t.provisional++, 
  r;
 }
 #Me(e, t) {
  for (let s = t.provisional; s < t.length; s++) {
   const r = t[s];
   if ((this.nocase ? normalizeNocase(e.name) : normalize(e.name)) === r.#we) return this.#Ue(e, r, s, t);
  }
 }
 #Ue(e, t, s, r) {
  const i = t.name;
  return t.#xe = -16 & t.#xe | entToType(e), i !== e.name && (t.name = e.name), s !== r.provisional && (s === r.length - 1 ? r.pop() : r.splice(s, 1), 
  r.unshift(t)), r.provisional++, t;
 }
 async lstat() {
  if (!(128 & this.#xe)) try {
   return this.#We(await this.#te.promises.lstat(this.fullpath())), this;
  } catch (e) {
   this.#je(e.code);
  }
 }
 lstatSync() {
  if (!(128 & this.#xe)) try {
   return this.#We(this.#te.lstatSync(this.fullpath())), this;
  } catch (e) {
   this.#je(e.code);
  }
 }
 #We(e) {
  const {atime: t, atimeMs: s, birthtime: r, birthtimeMs: i, blksize: n, blocks: o, ctime: a, ctimeMs: l, dev: c, gid: u, ino: h, mode: p, mtime: d, mtimeMs: f, nlink: m, rdev: g, size: y, uid: v} = e;
  this.#me = t, this.#he = s, this.#ve = r, this.#fe = i, this.#le = n, this.#ue = o, 
  this.#ye = a, this.#de = l, this.#se = c, this.#oe = u, this.#ce = h, this.#re = p, 
  this.#ge = d, this.#pe = f, this.#ie = m, this.#ae = g, this.#E = y, this.#ne = v;
  const w = entToType(e);
  this.#xe = -16 & this.#xe | w | 32, 0 !== w && 4 !== w && 10 !== w && (this.#xe |= 64);
 }
 #He=[];
 #ze=!1;
 #Ge(e) {
  this.#ze = !1;
  const t = this.#He.slice();
  this.#He.length = 0, t.forEach((t => t(null, e)));
 }
 readdirCB(e, t = !1) {
  if (!this.canReaddir()) return void (t ? e(null, []) : queueMicrotask((() => e(null, []))));
  const s = this.children();
  if (this.calledReaddir()) {
   const r = s.slice(0, s.provisional);
   return void (t ? e(null, r) : queueMicrotask((() => e(null, r))));
  }
  if (this.#He.push(e), this.#ze) return;
  this.#ze = !0;
  const r = this.fullpath();
  this.#te.readdir(r, {
   withFileTypes: !0
  }, ((e, t) => {
   if (e) this.#Fe(e.code), s.provisional = 0; else {
    for (const e of t) this.#Ie(e, s);
    this.#Pe(s);
   }
   this.#Ge(s.slice(0, s.provisional));
  }));
 }
 #qe;
 async readdir() {
  if (!this.canReaddir()) return [];
  const e = this.children();
  if (this.calledReaddir()) return e.slice(0, e.provisional);
  const t = this.fullpath();
  if (this.#qe) await this.#qe; else {
   let s = () => {};
   this.#qe = new Promise((e => s = e));
   try {
    for (const s of await this.#te.promises.readdir(t, {
     withFileTypes: !0
    })) this.#Ie(s, e);
    this.#Pe(e);
   } catch (t) {
    this.#Fe(t.code), e.provisional = 0;
   }
   this.#qe = void 0, s();
  }
  return e.slice(0, e.provisional);
 }
 readdirSync() {
  if (!this.canReaddir()) return [];
  const e = this.children();
  if (this.calledReaddir()) return e.slice(0, e.provisional);
  const t = this.fullpath();
  try {
   for (const s of this.#te.readdirSync(t, {
    withFileTypes: !0
   })) this.#Ie(s, e);
   this.#Pe(e);
  } catch (t) {
   this.#Fe(t.code), e.provisional = 0;
  }
  return e.slice(0, e.provisional);
 }
 canReaddir() {
  if (704 & this.#xe) return !1;
  const e = 15 & this.#xe;
  return 0 === e || 4 === e || 10 === e;
 }
 shouldWalk(e, t) {
  return !(4 & ~this.#xe) && !(704 & this.#xe) && !e.has(this) && (!t || t(this));
 }
 async realpath() {
  if (this.#Ae) return this.#Ae;
  if (!(896 & this.#xe)) try {
   const e = await this.#te.promises.realpath(this.fullpath());
   return this.#Ae = this.resolve(e);
  } catch (e) {
   this.#Re();
  }
 }
 realpathSync() {
  if (this.#Ae) return this.#Ae;
  if (!(896 & this.#xe)) try {
   const e = this.#te.realpathSync(this.fullpath());
   return this.#Ae = this.resolve(e);
  } catch (e) {
   this.#Re();
  }
 }
 [setAsCwd](e) {
  if (e === this) return;
  const t = new Set([]);
  let s = [], r = this;
  for (;r && r.parent; ) t.add(r), r.#Se = s.join(this.sep), r.#Te = s.join("/"), 
  r = r.parent, s.push("..");
  for (r = e; r && r.parent && !t.has(r); ) r.#Se = void 0, r.#Te = void 0, r = r.parent;
 }
}

class PathWin32 extends PathBase {
 sep="\\";
 splitSep=eitherSep;
 constructor(e, t = 0, s, r, i, n, o) {
  super(e, t, s, r, i, n, o);
 }
 newChild(e, t = 0, s = {}) {
  return new PathWin32(e, t, this.root, this.roots, this.nocase, this.childrenCache(), s);
 }
 getRootString(e) {
  return path$6.win32.parse(e).root;
 }
 getRoot(e) {
  if ((e = (e => e.replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\"))(e.toUpperCase())) === this.root.name) return this.root;
  for (const [t, s] of Object.entries(this.roots)) if (this.sameRoot(e, t)) return this.roots[e] = s;
  return this.roots[e] = new PathScurryWin32(e, this).root;
 }
 sameRoot(e, t = this.root.name) {
  return (e = e.toUpperCase().replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\")) === t;
 }
}

class PathPosix extends PathBase {
 splitSep="/";
 sep="/";
 constructor(e, t = 0, s, r, i, n, o) {
  super(e, t, s, r, i, n, o);
 }
 getRootString(e) {
  return e.startsWith("/") ? "/" : "";
 }
 getRoot(e) {
  return this.root;
 }
 newChild(e, t = 0, s = {}) {
  return new PathPosix(e, t, this.root, this.roots, this.nocase, this.childrenCache(), s);
 }
}

class PathScurryBase {
 root;
 rootPath;
 roots;
 cwd;
 #Ve;
 #Je;
 #$e;
 nocase;
 #te;
 constructor(e = process.cwd(), t, s, {nocase: r, childrenCacheSize: i = 16384, fs: n = defaultFS} = {}) {
  this.#te = fsFromOption(n), (e instanceof URL || e.startsWith("file://")) && (e = require$$2$1.fileURLToPath(e));
  const o = t.resolve(e);
  this.roots = Object.create(null), this.rootPath = this.parseRootPath(o), this.#Ve = new ResolveCache, 
  this.#Je = new ResolveCache, this.#$e = new ChildrenCache(i);
  const a = o.substring(this.rootPath.length).split(s);
  if (1 !== a.length || a[0] || a.pop(), void 0 === r) throw new TypeError("must provide nocase setting to PathScurryBase ctor");
  this.nocase = r, this.root = this.newRoot(this.#te), this.roots[this.rootPath] = this.root;
  let l = this.root, c = a.length - 1;
  const u = t.sep;
  let h = this.rootPath, p = !1;
  for (const e of a) {
   const t = c--;
   l = l.child(e, {
    relative: new Array(t).fill("..").join(u),
    relativePosix: new Array(t).fill("..").join("/"),
    fullpath: h += (p ? "" : u) + e
   }), p = !0;
  }
  this.cwd = l;
 }
 depth(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.depth();
 }
 childrenCache() {
  return this.#$e;
 }
 resolve(...e) {
  let t = "";
  for (let s = e.length - 1; s >= 0; s--) {
   const r = e[s];
   if (r && "." !== r && (t = t ? `${r}/${t}` : r, this.isAbsolute(r))) break;
  }
  const s = this.#Ve.get(t);
  if (void 0 !== s) return s;
  const r = this.cwd.resolve(t).fullpath();
  return this.#Ve.set(t, r), r;
 }
 resolvePosix(...e) {
  let t = "";
  for (let s = e.length - 1; s >= 0; s--) {
   const r = e[s];
   if (r && "." !== r && (t = t ? `${r}/${t}` : r, this.isAbsolute(r))) break;
  }
  const s = this.#Je.get(t);
  if (void 0 !== s) return s;
  const r = this.cwd.resolve(t).fullpathPosix();
  return this.#Je.set(t, r), r;
 }
 relative(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.relative();
 }
 relativePosix(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.relativePosix();
 }
 basename(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.name;
 }
 dirname(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), (e.parent || e).fullpath();
 }
 async readdir(e = this.cwd, t = {
  withFileTypes: !0
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s} = t;
  if (e.canReaddir()) {
   const t = await e.readdir();
   return s ? t : t.map((e => e.name));
  }
  return [];
 }
 readdirSync(e = this.cwd, t = {
  withFileTypes: !0
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0} = t;
  return e.canReaddir() ? s ? e.readdirSync() : e.readdirSync().map((e => e.name)) : [];
 }
 async lstat(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.lstat();
 }
 lstatSync(e = this.cwd) {
  return "string" == typeof e && (e = this.cwd.resolve(e)), e.lstatSync();
 }
 async readlink(e = this.cwd, {withFileTypes: t} = {
  withFileTypes: !1
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e.withFileTypes, 
  e = this.cwd);
  const s = await e.readlink();
  return t ? s : s?.fullpath();
 }
 readlinkSync(e = this.cwd, {withFileTypes: t} = {
  withFileTypes: !1
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e.withFileTypes, 
  e = this.cwd);
  const s = e.readlinkSync();
  return t ? s : s?.fullpath();
 }
 async realpath(e = this.cwd, {withFileTypes: t} = {
  withFileTypes: !1
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e.withFileTypes, 
  e = this.cwd);
  const s = await e.realpath();
  return t ? s : s?.fullpath();
 }
 realpathSync(e = this.cwd, {withFileTypes: t} = {
  withFileTypes: !1
 }) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e.withFileTypes, 
  e = this.cwd);
  const s = e.realpathSync();
  return t ? s : s?.fullpath();
 }
 async walk(e = this.cwd, t = {}) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0, follow: r = !1, filter: i, walkFilter: n} = t, o = [];
  i && !i(e) || o.push(s ? e : e.fullpath());
  const a = new Set, l = (e, t) => {
   a.add(e), e.readdirCB(((e, c) => {
    if (e) return t(e);
    let u = c.length;
    if (!u) return t();
    const h = () => {
     0 == --u && t();
    };
    for (const e of c) i && !i(e) || o.push(s ? e : e.fullpath()), r && e.isSymbolicLink() ? e.realpath().then((e => e?.isUnknown() ? e.lstat() : e)).then((e => e?.shouldWalk(a, n) ? l(e, h) : h())) : e.shouldWalk(a, n) ? l(e, h) : h();
   }), !0);
  }, c = e;
  return new Promise(((e, t) => {
   l(c, (s => {
    if (s) return t(s);
    e(o);
   }));
  }));
 }
 walkSync(e = this.cwd, t = {}) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0, follow: r = !1, filter: i, walkFilter: n} = t, o = [];
  i && !i(e) || o.push(s ? e : e.fullpath());
  const a = new Set([ e ]);
  for (const e of a) {
   const t = e.readdirSync();
   for (const e of t) {
    i && !i(e) || o.push(s ? e : e.fullpath());
    let t = e;
    if (e.isSymbolicLink()) {
     if (!r || !(t = e.realpathSync())) continue;
     t.isUnknown() && t.lstatSync();
    }
    t.shouldWalk(a, n) && a.add(t);
   }
  }
  return o;
 }
 [Symbol.asyncIterator]() {
  return this.iterate();
 }
 iterate(e = this.cwd, t = {}) {
  return "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd), this.stream(e, t)[Symbol.asyncIterator]();
 }
 [Symbol.iterator]() {
  return this.iterateSync();
 }
 * iterateSync(e = this.cwd, t = {}) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0, follow: r = !1, filter: i, walkFilter: n} = t;
  i && !i(e) || (yield s ? e : e.fullpath());
  const o = new Set([ e ]);
  for (const e of o) {
   const t = e.readdirSync();
   for (const e of t) {
    i && !i(e) || (yield s ? e : e.fullpath());
    let t = e;
    if (e.isSymbolicLink()) {
     if (!r || !(t = e.realpathSync())) continue;
     t.isUnknown() && t.lstatSync();
    }
    t.shouldWalk(o, n) && o.add(t);
   }
  }
 }
 stream(e = this.cwd, t = {}) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0, follow: r = !1, filter: i, walkFilter: n} = t, o = new commonjs.Minipass({
   objectMode: !0
  });
  i && !i(e) || o.write(s ? e : e.fullpath());
  const a = new Set, l = [ e ];
  let c = 0;
  const u = () => {
   let e = !1;
   for (;!e; ) {
    const t = l.shift();
    if (!t) return void (0 === c && o.end());
    c++, a.add(t);
    const h = (t, d, f = !1) => {
     if (t) return o.emit("error", t);
     if (r && !f) {
      const e = [];
      for (const t of d) t.isSymbolicLink() && e.push(t.realpath().then((e => e?.isUnknown() ? e.lstat() : e)));
      if (e.length) return void Promise.all(e).then((() => h(null, d, !0)));
     }
     for (const t of d) !t || i && !i(t) || o.write(s ? t : t.fullpath()) || (e = !0);
     c--;
     for (const e of d) {
      const t = e.realpathCached() || e;
      t.shouldWalk(a, n) && l.push(t);
     }
     e && !o.flowing ? o.once("drain", u) : p || u();
    };
    let p = !0;
    t.readdirCB(h, !0), p = !1;
   }
  };
  return u(), o;
 }
 streamSync(e = this.cwd, t = {}) {
  "string" == typeof e ? e = this.cwd.resolve(e) : e instanceof PathBase || (t = e, 
  e = this.cwd);
  const {withFileTypes: s = !0, follow: r = !1, filter: i, walkFilter: n} = t, o = new commonjs.Minipass({
   objectMode: !0
  }), a = new Set;
  i && !i(e) || o.write(s ? e : e.fullpath());
  const l = [ e ];
  let c = 0;
  const u = () => {
   let e = !1;
   for (;!e; ) {
    const t = l.shift();
    if (!t) return void (0 === c && o.end());
    c++, a.add(t);
    const u = t.readdirSync();
    for (const t of u) i && !i(t) || o.write(s ? t : t.fullpath()) || (e = !0);
    c--;
    for (const e of u) {
     let t = e;
     if (e.isSymbolicLink()) {
      if (!r || !(t = e.realpathSync())) continue;
      t.isUnknown() && t.lstatSync();
     }
     t.shouldWalk(a, n) && l.push(t);
    }
   }
   e && !o.flowing && o.once("drain", u);
  };
  return u(), o;
 }
 chdir(e = this.cwd) {
  const t = this.cwd;
  this.cwd = "string" == typeof e ? this.cwd.resolve(e) : e, this.cwd[setAsCwd](t);
 }
}

class PathScurryWin32 extends PathScurryBase {
 sep="\\";
 constructor(e = process.cwd(), t = {}) {
  const {nocase: s = !0} = t;
  super(e, path$6.win32, "\\", {
   ...t,
   nocase: s
  }), this.nocase = s;
  for (let e = this.cwd; e; e = e.parent) e.nocase = this.nocase;
 }
 parseRootPath(e) {
  return path$6.win32.parse(e).root.toUpperCase();
 }
 newRoot(e) {
  return new PathWin32(this.rootPath, 4, void 0, this.roots, this.nocase, this.childrenCache(), {
   fs: e
  });
 }
 isAbsolute(e) {
  return e.startsWith("/") || e.startsWith("\\") || /^[a-z]:(\/|\\)/i.test(e);
 }
}

class PathScurryPosix extends PathScurryBase {
 sep="/";
 constructor(e = process.cwd(), t = {}) {
  const {nocase: s = !1} = t;
  super(e, path$6.posix, "/", {
   ...t,
   nocase: s
  }), this.nocase = s;
 }
 parseRootPath(e) {
  return "/";
 }
 newRoot(e) {
  return new PathPosix(this.rootPath, 4, void 0, this.roots, this.nocase, this.childrenCache(), {
   fs: e
  });
 }
 isAbsolute(e) {
  return e.startsWith("/");
 }
}

class PathScurryDarwin extends PathScurryPosix {
 constructor(e = process.cwd(), t = {}) {
  const {nocase: s = !0} = t;
  super(e, {
   ...t,
   nocase: s
  });
 }
}

const Path = "win32" === process.platform ? PathWin32 : PathPosix, PathScurry = "win32" === process.platform ? PathScurryWin32 : "darwin" === process.platform ? PathScurryDarwin : PathScurryPosix, require$$1$2 = getAugmentedNamespace(Object.freeze({
 __proto__: null,
 ResolveCache,
 ChildrenCache,
 PathBase,
 PathWin32,
 PathPosix,
 PathScurryBase,
 PathScurryWin32,
 PathScurryPosix,
 PathScurryDarwin,
 Path,
 PathScurry
}));

pattern = {}, Object.defineProperty(pattern, "__esModule", {
 value: !0
}), pattern.Pattern = void 0;

const minimatch_1$4 = require$$0;

class Pattern {
 #Ye;
 #Xe;
 #Ke;
 length;
 #Qe;
 #Ze;
 #et;
 #tt;
 #st;
 #rt;
 #it=!0;
 constructor(e, t, s, r) {
  if (!(e.length >= 1)) throw new TypeError("empty pattern list");
  if (!(t.length >= 1)) throw new TypeError("empty glob list");
  if (t.length !== e.length) throw new TypeError("mismatched pattern list and glob list lengths");
  if (this.length = e.length, s < 0 || s >= this.length) throw new TypeError("index out of range");
  if (this.#Ye = e, this.#Xe = t, this.#Ke = s, this.#Qe = r, 0 === this.#Ke) if (this.isUNC()) {
   const [e, t, s, r, ...i] = this.#Ye, [n, o, a, l, ...c] = this.#Xe;
   "" === i[0] && (i.shift(), c.shift());
   const u = [ e, t, s, r, "" ].join("/"), h = [ n, o, a, l, "" ].join("/");
   this.#Ye = [ u, ...i ], this.#Xe = [ h, ...c ], this.length = this.#Ye.length;
  } else if (this.isDrive() || this.isAbsolute()) {
   const [e, ...t] = this.#Ye, [s, ...r] = this.#Xe;
   "" === t[0] && (t.shift(), r.shift());
   const i = e + "/", n = s + "/";
   this.#Ye = [ i, ...t ], this.#Xe = [ n, ...r ], this.length = this.#Ye.length;
  }
 }
 pattern() {
  return this.#Ye[this.#Ke];
 }
 isString() {
  return "string" == typeof this.#Ye[this.#Ke];
 }
 isGlobstar() {
  return this.#Ye[this.#Ke] === minimatch_1$4.GLOBSTAR;
 }
 isRegExp() {
  return this.#Ye[this.#Ke] instanceof RegExp;
 }
 globString() {
  return this.#et = this.#et || (0 === this.#Ke ? this.isAbsolute() ? this.#Xe[0] + this.#Xe.slice(1).join("/") : this.#Xe.join("/") : this.#Xe.slice(this.#Ke).join("/"));
 }
 hasMore() {
  return this.length > this.#Ke + 1;
 }
 rest() {
  return void 0 !== this.#Ze ? this.#Ze : this.hasMore() ? (this.#Ze = new Pattern(this.#Ye, this.#Xe, this.#Ke + 1, this.#Qe), 
  this.#Ze.#rt = this.#rt, this.#Ze.#st = this.#st, this.#Ze.#tt = this.#tt, this.#Ze) : this.#Ze = null;
 }
 isUNC() {
  const e = this.#Ye;
  return void 0 !== this.#st ? this.#st : this.#st = "win32" === this.#Qe && 0 === this.#Ke && "" === e[0] && "" === e[1] && "string" == typeof e[2] && !!e[2] && "string" == typeof e[3] && !!e[3];
 }
 isDrive() {
  const e = this.#Ye;
  return void 0 !== this.#tt ? this.#tt : this.#tt = "win32" === this.#Qe && 0 === this.#Ke && this.length > 1 && "string" == typeof e[0] && /^[a-z]:$/i.test(e[0]);
 }
 isAbsolute() {
  const e = this.#Ye;
  return void 0 !== this.#rt ? this.#rt : this.#rt = "" === e[0] && e.length > 1 || this.isDrive() || this.isUNC();
 }
 root() {
  const e = this.#Ye[0];
  return "string" == typeof e && this.isAbsolute() && 0 === this.#Ke ? e : "";
 }
 checkFollowGlobstar() {
  return !(0 === this.#Ke || !this.isGlobstar() || !this.#it);
 }
 markFollowGlobstar() {
  return !(0 === this.#Ke || !this.isGlobstar() || !this.#it || (this.#it = !1, 0));
 }
}

pattern.Pattern = Pattern, walker = {}, ignore = {}, Object.defineProperty(ignore, "__esModule", {
 value: !0
}), ignore.Ignore = void 0;

const minimatch_1$3 = require$$0, pattern_js_1$1 = pattern, defaultPlatform$1 = "object" == typeof process && process && "string" == typeof process.platform ? process.platform : "linux";

ignore.Ignore = class Ignore {
 relative;
 relativeChildren;
 absolute;
 absoluteChildren;
 constructor(e, {nobrace: t, nocase: s, noext: r, noglobstar: i, platform: n = defaultPlatform$1}) {
  this.relative = [], this.absolute = [], this.relativeChildren = [], this.absoluteChildren = [];
  const o = {
   dot: !0,
   nobrace: t,
   nocase: s,
   noext: r,
   noglobstar: i,
   optimizationLevel: 2,
   platform: n,
   nocomment: !0,
   nonegate: !0
  };
  for (const t of e) {
   const e = new minimatch_1$3.Minimatch(t, o);
   for (let t = 0; t < e.set.length; t++) {
    const s = e.set[t], r = e.globParts[t];
    if (!s || !r) throw new Error("invalid pattern object");
    const i = new pattern_js_1$1.Pattern(s, r, 0, n), a = new minimatch_1$3.Minimatch(i.globString(), o), l = "**" === r[r.length - 1], c = i.isAbsolute();
    c ? this.absolute.push(a) : this.relative.push(a), l && (c ? this.absoluteChildren.push(a) : this.relativeChildren.push(a));
   }
  }
 }
 ignored(e) {
  const t = e.fullpath(), s = `${t}/`, r = e.relative() || ".", i = `${r}/`;
  for (const e of this.relative) if (e.match(r) || e.match(i)) return !0;
  for (const e of this.absolute) if (e.match(t) || e.match(s)) return !0;
  return !1;
 }
 childrenIgnored(e) {
  const t = e.fullpath() + "/", s = (e.relative() || ".") + "/";
  for (const e of this.relativeChildren) if (e.match(s)) return !0;
  for (const e of this.absoluteChildren) if (e.match(t)) return !0;
  return !1;
 }
}, processor = {}, Object.defineProperty(processor, "__esModule", {
 value: !0
}), processor.Processor = processor.SubWalks = processor.MatchRecord = processor.HasWalkedCache = void 0;

const minimatch_1$2 = require$$0;

class HasWalkedCache {
 store;
 constructor(e = new Map) {
  this.store = e;
 }
 copy() {
  return new HasWalkedCache(new Map(this.store));
 }
 hasWalked(e, t) {
  return this.store.get(e.fullpath())?.has(t.globString());
 }
 storeWalked(e, t) {
  const s = e.fullpath(), r = this.store.get(s);
  r ? r.add(t.globString()) : this.store.set(s, new Set([ t.globString() ]));
 }
}

processor.HasWalkedCache = HasWalkedCache;

class MatchRecord {
 store=new Map;
 add(e, t, s) {
  const r = (t ? 2 : 0) | (s ? 1 : 0), i = this.store.get(e);
  this.store.set(e, void 0 === i ? r : r & i);
 }
 entries() {
  return [ ...this.store.entries() ].map((([e, t]) => [ e, !!(2 & t), !!(1 & t) ]));
 }
}

processor.MatchRecord = MatchRecord;

class SubWalks {
 store=new Map;
 add(e, t) {
  if (!e.canReaddir()) return;
  const s = this.store.get(e);
  s ? s.find((e => e.globString() === t.globString())) || s.push(t) : this.store.set(e, [ t ]);
 }
 get(e) {
  const t = this.store.get(e);
  if (!t) throw new Error("attempting to walk unknown path");
  return t;
 }
 entries() {
  return this.keys().map((e => [ e, this.store.get(e) ]));
 }
 keys() {
  return [ ...this.store.keys() ].filter((e => e.canReaddir()));
 }
}

processor.SubWalks = SubWalks;

class Processor {
 hasWalkedCache;
 matches=new MatchRecord;
 subwalks=new SubWalks;
 patterns;
 follow;
 dot;
 opts;
 constructor(e, t) {
  this.opts = e, this.follow = !!e.follow, this.dot = !!e.dot, this.hasWalkedCache = t ? t.copy() : new HasWalkedCache;
 }
 processPatterns(e, t) {
  this.patterns = t;
  const s = t.map((t => [ e, t ]));
  for (let [e, t] of s) {
   this.hasWalkedCache.storeWalked(e, t);
   const s = t.root(), r = t.isAbsolute() && !1 !== this.opts.absolute;
   if (s) {
    e = e.resolve("/" === s && void 0 !== this.opts.root ? this.opts.root : s);
    const r = t.rest();
    if (!r) {
     this.matches.add(e, !0, !1);
     continue;
    }
    t = r;
   }
   if (e.isENOENT()) continue;
   let i, n, o = !1;
   for (;"string" == typeof (i = t.pattern()) && (n = t.rest()); ) {
    const s = e.resolve(i);
    e = s, t = n, o = !0;
   }
   if (i = t.pattern(), n = t.rest(), o) {
    if (this.hasWalkedCache.hasWalked(e, t)) continue;
    this.hasWalkedCache.storeWalked(e, t);
   }
   if ("string" != typeof i) if (i === minimatch_1$2.GLOBSTAR) {
    (!e.isSymbolicLink() || this.follow || t.checkFollowGlobstar()) && this.subwalks.add(e, t);
    const s = n?.pattern(), i = n?.rest();
    if (n && ("" !== s && "." !== s || i)) {
     if (".." === s) {
      const t = e.parent || e;
      i ? this.hasWalkedCache.hasWalked(t, i) || this.subwalks.add(t, i) : this.matches.add(t, r, !0);
     }
    } else this.matches.add(e, r, "" === s || "." === s);
   } else i instanceof RegExp && this.subwalks.add(e, t); else {
    const t = ".." === i || "" === i || "." === i;
    this.matches.add(e.resolve(i), r, t);
   }
  }
  return this;
 }
 subwalkTargets() {
  return this.subwalks.keys();
 }
 child() {
  return new Processor(this.opts, this.hasWalkedCache);
 }
 filterEntries(e, t) {
  const s = this.subwalks.get(e), r = this.child();
  for (const e of t) for (const t of s) {
   const s = t.isAbsolute(), i = t.pattern(), n = t.rest();
   i === minimatch_1$2.GLOBSTAR ? r.testGlobstar(e, t, n, s) : i instanceof RegExp ? r.testRegExp(e, i, n, s) : r.testString(e, i, n, s);
  }
  return r;
 }
 testGlobstar(e, t, s, r) {
  if (!this.dot && e.name.startsWith(".") || (t.hasMore() || this.matches.add(e, r, !1), 
  e.canReaddir() && (this.follow || !e.isSymbolicLink() ? this.subwalks.add(e, t) : e.isSymbolicLink() && (s && t.checkFollowGlobstar() ? this.subwalks.add(e, s) : t.markFollowGlobstar() && this.subwalks.add(e, t)))), 
  s) {
   const t = s.pattern();
   if ("string" == typeof t && ".." !== t && "" !== t && "." !== t) this.testString(e, t, s.rest(), r); else if (".." === t) {
    const t = e.parent || e;
    this.subwalks.add(t, s);
   } else t instanceof RegExp && this.testRegExp(e, t, s.rest(), r);
  }
 }
 testRegExp(e, t, s, r) {
  t.test(e.name) && (s ? this.subwalks.add(e, s) : this.matches.add(e, r, !1));
 }
 testString(e, t, s, r) {
  e.isNamed(t) && (s ? this.subwalks.add(e, s) : this.matches.add(e, r, !1));
 }
}

processor.Processor = Processor, Object.defineProperty(walker, "__esModule", {
 value: !0
}), walker.GlobStream = walker.GlobWalker = walker.GlobUtil = void 0;

const minipass_1 = commonjs, ignore_js_1 = ignore, processor_js_1 = processor;

class GlobUtil {
 path;
 patterns;
 opts;
 seen=new Set;
 paused=!1;
 aborted=!1;
 #nt=[];
 #ot;
 #at;
 signal;
 maxDepth;
 constructor(e, t, s) {
  this.patterns = e, this.path = t, this.opts = s, this.#at = s.posix || "win32" !== s.platform ? "/" : "\\", 
  s.ignore && (this.#ot = ((e, t) => "string" == typeof e ? new ignore_js_1.Ignore([ e ], t) : Array.isArray(e) ? new ignore_js_1.Ignore(e, t) : e)(s.ignore, s)), 
  this.maxDepth = s.maxDepth || 1 / 0, s.signal && (this.signal = s.signal, this.signal.addEventListener("abort", (() => {
   this.#nt.length = 0;
  })));
 }
 #lt(e) {
  return this.seen.has(e) || !!this.#ot?.ignored?.(e);
 }
 #ct(e) {
  return !!this.#ot?.childrenIgnored?.(e);
 }
 pause() {
  this.paused = !0;
 }
 resume() {
  if (this.signal?.aborted) return;
  let e;
  for (this.paused = !1; !this.paused && (e = this.#nt.shift()); ) e();
 }
 onResume(e) {
  this.signal?.aborted || (this.paused ? this.#nt.push(e) : e());
 }
 async matchCheck(e, t) {
  if (t && this.opts.nodir) return;
  let s;
  if (this.opts.realpath) {
   if (s = e.realpathCached() || await e.realpath(), !s) return;
   e = s;
  }
  const r = e.isUnknown() || this.opts.stat;
  return this.matchCheckTest(r ? await e.lstat() : e, t);
 }
 matchCheckTest(e, t) {
  return !e || !(this.maxDepth === 1 / 0 || e.depth() <= this.maxDepth) || t && !e.canReaddir() || this.opts.nodir && e.isDirectory() || this.#lt(e) ? void 0 : e;
 }
 matchCheckSync(e, t) {
  if (t && this.opts.nodir) return;
  let s;
  if (this.opts.realpath) {
   if (s = e.realpathCached() || e.realpathSync(), !s) return;
   e = s;
  }
  const r = e.isUnknown() || this.opts.stat;
  return this.matchCheckTest(r ? e.lstatSync() : e, t);
 }
 matchFinish(e, t) {
  if (this.#lt(e)) return;
  const s = void 0 === this.opts.absolute ? t : this.opts.absolute;
  this.seen.add(e);
  const r = this.opts.mark && e.isDirectory() ? this.#at : "";
  if (this.opts.withFileTypes) this.matchEmit(e); else if (s) {
   const t = this.opts.posix ? e.fullpathPosix() : e.fullpath();
   this.matchEmit(t + r);
  } else {
   const t = this.opts.posix ? e.relativePosix() : e.relative(), s = this.opts.dotRelative && !t.startsWith(".." + this.#at) ? "." + this.#at : "";
   this.matchEmit(t ? s + t + r : "." + r);
  }
 }
 async match(e, t, s) {
  const r = await this.matchCheck(e, s);
  r && this.matchFinish(r, t);
 }
 matchSync(e, t, s) {
  const r = this.matchCheckSync(e, s);
  r && this.matchFinish(r, t);
 }
 walkCB(e, t, s) {
  this.signal?.aborted && s(), this.walkCB2(e, t, new processor_js_1.Processor(this.opts), s);
 }
 walkCB2(e, t, s, r) {
  if (this.#ct(e)) return r();
  if (this.signal?.aborted && r(), this.paused) return void this.onResume((() => this.walkCB2(e, t, s, r)));
  s.processPatterns(e, t);
  let i = 1;
  const n = () => {
   0 == --i && r();
  };
  for (const [e, t, r] of s.matches.entries()) this.#lt(e) || (i++, this.match(e, t, r).then((() => n())));
  for (const e of s.subwalkTargets()) {
   if (this.maxDepth !== 1 / 0 && e.depth() >= this.maxDepth) continue;
   i++;
   const t = e.readdirCached();
   e.calledReaddir() ? this.walkCB3(e, t, s, n) : e.readdirCB(((t, r) => this.walkCB3(e, r, s, n)), !0);
  }
  n();
 }
 walkCB3(e, t, s, r) {
  s = s.filterEntries(e, t);
  let i = 1;
  const n = () => {
   0 == --i && r();
  };
  for (const [e, t, r] of s.matches.entries()) this.#lt(e) || (i++, this.match(e, t, r).then((() => n())));
  for (const [e, t] of s.subwalks.entries()) i++, this.walkCB2(e, t, s.child(), n);
  n();
 }
 walkCBSync(e, t, s) {
  this.signal?.aborted && s(), this.walkCB2Sync(e, t, new processor_js_1.Processor(this.opts), s);
 }
 walkCB2Sync(e, t, s, r) {
  if (this.#ct(e)) return r();
  if (this.signal?.aborted && r(), this.paused) return void this.onResume((() => this.walkCB2Sync(e, t, s, r)));
  s.processPatterns(e, t);
  let i = 1;
  const n = () => {
   0 == --i && r();
  };
  for (const [e, t, r] of s.matches.entries()) this.#lt(e) || this.matchSync(e, t, r);
  for (const e of s.subwalkTargets()) {
   if (this.maxDepth !== 1 / 0 && e.depth() >= this.maxDepth) continue;
   i++;
   const t = e.readdirSync();
   this.walkCB3Sync(e, t, s, n);
  }
  n();
 }
 walkCB3Sync(e, t, s, r) {
  s = s.filterEntries(e, t);
  let i = 1;
  const n = () => {
   0 == --i && r();
  };
  for (const [e, t, r] of s.matches.entries()) this.#lt(e) || this.matchSync(e, t, r);
  for (const [e, t] of s.subwalks.entries()) i++, this.walkCB2Sync(e, t, s.child(), n);
  n();
 }
}

walker.GlobUtil = GlobUtil, walker.GlobWalker = class GlobWalker extends GlobUtil {
 matches;
 constructor(e, t, s) {
  super(e, t, s), this.matches = new Set;
 }
 matchEmit(e) {
  this.matches.add(e);
 }
 async walk() {
  if (this.signal?.aborted) throw this.signal.reason;
  return this.path.isUnknown() && await this.path.lstat(), await new Promise(((e, t) => {
   this.walkCB(this.path, this.patterns, (() => {
    this.signal?.aborted ? t(this.signal.reason) : e(this.matches);
   }));
  })), this.matches;
 }
 walkSync() {
  if (this.signal?.aborted) throw this.signal.reason;
  return this.path.isUnknown() && this.path.lstatSync(), this.walkCBSync(this.path, this.patterns, (() => {
   if (this.signal?.aborted) throw this.signal.reason;
  })), this.matches;
 }
}, walker.GlobStream = class GlobStream extends GlobUtil {
 results;
 constructor(e, t, s) {
  super(e, t, s), this.results = new minipass_1.Minipass({
   signal: this.signal,
   objectMode: !0
  }), this.results.on("drain", (() => this.resume())), this.results.on("resume", (() => this.resume()));
 }
 matchEmit(e) {
  this.results.write(e), this.results.flowing || this.pause();
 }
 stream() {
  const e = this.path;
  return e.isUnknown() ? e.lstat().then((() => {
   this.walkCB(e, this.patterns, (() => this.results.end()));
  })) : this.walkCB(e, this.patterns, (() => this.results.end())), this.results;
 }
 streamSync() {
  return this.path.isUnknown() && this.path.lstatSync(), this.walkCBSync(this.path, this.patterns, (() => this.results.end())), 
  this.results;
 }
}, Object.defineProperty(glob, "__esModule", {
 value: !0
}), glob.Glob = void 0;

const minimatch_1$1 = require$$0, path_scurry_1 = require$$1$2, url_1 = require$$2__default$1.default, pattern_js_1 = pattern, walker_js_1 = walker, defaultPlatform = "object" == typeof process && process && "string" == typeof process.platform ? process.platform : "linux";

class Glob {
 absolute;
 cwd;
 root;
 dot;
 dotRelative;
 follow;
 ignore;
 magicalBraces;
 mark;
 matchBase;
 maxDepth;
 nobrace;
 nocase;
 nodir;
 noext;
 noglobstar;
 pattern;
 platform;
 realpath;
 scurry;
 stat;
 signal;
 windowsPathsNoEscape;
 withFileTypes;
 opts;
 patterns;
 constructor(e, t) {
  if (!t) throw new TypeError("glob options required");
  if (this.withFileTypes = !!t.withFileTypes, this.signal = t.signal, this.follow = !!t.follow, 
  this.dot = !!t.dot, this.dotRelative = !!t.dotRelative, this.nodir = !!t.nodir, 
  this.mark = !!t.mark, t.cwd ? (t.cwd instanceof URL || t.cwd.startsWith("file://")) && (t.cwd = (0, 
  url_1.fileURLToPath)(t.cwd)) : this.cwd = "", this.cwd = t.cwd || "", this.root = t.root, 
  this.magicalBraces = !!t.magicalBraces, this.nobrace = !!t.nobrace, this.noext = !!t.noext, 
  this.realpath = !!t.realpath, this.absolute = t.absolute, this.noglobstar = !!t.noglobstar, 
  this.matchBase = !!t.matchBase, this.maxDepth = "number" == typeof t.maxDepth ? t.maxDepth : 1 / 0, 
  this.stat = !!t.stat, this.ignore = t.ignore, this.withFileTypes && void 0 !== this.absolute) throw new Error("cannot set absolute and withFileTypes:true");
  if ("string" == typeof e && (e = [ e ]), this.windowsPathsNoEscape = !!t.windowsPathsNoEscape || !1 === t.allowWindowsEscape, 
  this.windowsPathsNoEscape && (e = e.map((e => e.replace(/\\/g, "/")))), this.matchBase) {
   if (t.noglobstar) throw new TypeError("base matching requires globstar");
   e = e.map((e => e.includes("/") ? e : `./**/${e}`));
  }
  if (this.pattern = e, this.platform = t.platform || defaultPlatform, this.opts = {
   ...t,
   platform: this.platform
  }, t.scurry) {
   if (this.scurry = t.scurry, void 0 !== t.nocase && t.nocase !== t.scurry.nocase) throw new Error("nocase option contradicts provided scurry option");
  } else {
   const e = "win32" === t.platform ? path_scurry_1.PathScurryWin32 : "darwin" === t.platform ? path_scurry_1.PathScurryDarwin : t.platform ? path_scurry_1.PathScurryPosix : path_scurry_1.PathScurry;
   this.scurry = new e(this.cwd, {
    nocase: t.nocase,
    fs: t.fs
   });
  }
  this.nocase = this.scurry.nocase;
  const s = "darwin" === this.platform || "win32" === this.platform, r = {
   ...t,
   dot: this.dot,
   matchBase: this.matchBase,
   nobrace: this.nobrace,
   nocase: this.nocase,
   nocaseMagicOnly: s,
   nocomment: !0,
   noext: this.noext,
   nonegate: !0,
   optimizationLevel: 2,
   platform: this.platform,
   windowsPathsNoEscape: this.windowsPathsNoEscape,
   debug: !!this.opts.debug
  }, i = this.pattern.map((e => new minimatch_1$1.Minimatch(e, r))), [n, o] = i.reduce(((e, t) => (e[0].push(...t.set), 
  e[1].push(...t.globParts), e)), [ [], [] ]);
  this.patterns = n.map(((e, t) => {
   const s = o[t];
   if (!s) throw new Error("invalid pattern object");
   return new pattern_js_1.Pattern(e, s, 0, this.platform);
  }));
 }
 async walk() {
  return [ ...await new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
   ...this.opts,
   maxDepth: this.maxDepth !== 1 / 0 ? this.maxDepth + this.scurry.cwd.depth() : 1 / 0,
   platform: this.platform,
   nocase: this.nocase
  }).walk() ];
 }
 walkSync() {
  return [ ...new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
   ...this.opts,
   maxDepth: this.maxDepth !== 1 / 0 ? this.maxDepth + this.scurry.cwd.depth() : 1 / 0,
   platform: this.platform,
   nocase: this.nocase
  }).walkSync() ];
 }
 stream() {
  return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
   ...this.opts,
   maxDepth: this.maxDepth !== 1 / 0 ? this.maxDepth + this.scurry.cwd.depth() : 1 / 0,
   platform: this.platform,
   nocase: this.nocase
  }).stream();
 }
 streamSync() {
  return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
   ...this.opts,
   maxDepth: this.maxDepth !== 1 / 0 ? this.maxDepth + this.scurry.cwd.depth() : 1 / 0,
   platform: this.platform,
   nocase: this.nocase
  }).streamSync();
 }
 iterateSync() {
  return this.streamSync()[Symbol.iterator]();
 }
 [Symbol.iterator]() {
  return this.iterateSync();
 }
 iterate() {
  return this.stream()[Symbol.asyncIterator]();
 }
 [Symbol.asyncIterator]() {
  return this.iterate();
 }
}

glob.Glob = Glob, hasMagic$1 = {}, Object.defineProperty(hasMagic$1, "__esModule", {
 value: !0
}), hasMagic$1.hasMagic = void 0;

const minimatch_1 = require$$0;

hasMagic$1.hasMagic = (e, t = {}) => {
 Array.isArray(e) || (e = [ e ]);
 for (const s of e) if (new minimatch_1.Minimatch(s, t).hasMagic()) return !0;
 return !1;
}, function(e) {
 function t(e, t = {}) {
  return new h.Glob(e, t).streamSync();
 }
 function s(e, t = {}) {
  return new h.Glob(e, t).stream();
 }
 function r(e, t = {}) {
  return new h.Glob(e, t).walkSync();
 }
 async function i(e, t = {}) {
  return new h.Glob(e, t).walk();
 }
 function n(e, t = {}) {
  return new h.Glob(e, t).iterateSync();
 }
 function o(e, t = {}) {
  return new h.Glob(e, t).iterate();
 }
 var a, l, c;
 Object.defineProperty(e, "__esModule", {
  value: !0
 }), e.glob = e.hasMagic = e.Glob = e.unescape = e.escape = e.sync = e.iterate = e.iterateSync = e.stream = e.streamSync = e.globIterate = e.globIterateSync = e.globSync = e.globStream = e.globStreamSync = void 0;
 const u = require$$0, h = glob, p = hasMagic$1;
 e.globStreamSync = t, e.globStream = s, e.globSync = r, e.globIterateSync = n, e.globIterate = o, 
 e.streamSync = t, e.stream = Object.assign(s, {
  sync: t
 }), e.iterateSync = n, e.iterate = Object.assign(o, {
  sync: n
 }), e.sync = Object.assign(r, {
  stream: t,
  iterate: n
 }), a = require$$0, Object.defineProperty(e, "escape", {
  enumerable: !0,
  get: function() {
   return a.escape;
  }
 }), Object.defineProperty(e, "unescape", {
  enumerable: !0,
  get: function() {
   return a.unescape;
  }
 }), l = glob, Object.defineProperty(e, "Glob", {
  enumerable: !0,
  get: function() {
   return l.Glob;
  }
 }), c = hasMagic$1, Object.defineProperty(e, "hasMagic", {
  enumerable: !0,
  get: function() {
   return c.hasMagic;
  }
 }), e.glob = Object.assign(i, {
  glob: i,
  globSync: r,
  sync: e.sync,
  globStream: s,
  stream: e.stream,
  globStreamSync: t,
  streamSync: e.streamSync,
  globIterate: o,
  iterate: e.iterate,
  globIterateSync: n,
  iterateSync: e.iterateSync,
  Glob: h.Glob,
  hasMagic: p.hasMagic,
  escape: u.escape,
  unescape: u.unescape
 }), e.glob.glob = e.glob;
}(commonjs$2);

const copyFile = require$$4.promisify(fs$5.copyFile), mkdir = require$$4.promisify(fs$5.mkdir), readdir = require$$4.promisify(fs$5.readdir);

require$$4.promisify(fs$5.readFile);

const stat = require$$4.promisify(fs$5.stat), ROOT_DIR = normalizePath(path__default.default.resolve("/")), IGNORE$1 = [ ".ds_store", ".gitignore", "desktop.ini", "thumbs.db" ], SemVer$2 = semver, compare$5 = compare_1 = (e, t, s) => new SemVer$2(e, s).compare(new SemVer$2(t, s)), semverLte = lte_1 = (e, t, s) => compare$5(e, t, s) <= 0;

yallist = Yallist$1, Yallist$1.Node = Node, Yallist$1.create = Yallist$1, Yallist$1.prototype.removeNode = function(e) {
 var t, s;
 if (e.list !== this) throw new Error("removing node which does not belong to this list");
 return t = e.next, s = e.prev, t && (t.prev = s), s && (s.next = t), e === this.head && (this.head = t), 
 e === this.tail && (this.tail = s), e.list.length--, e.next = null, e.prev = null, 
 e.list = null, t;
}, Yallist$1.prototype.unshiftNode = function(e) {
 if (e !== this.head) {
  e.list && e.list.removeNode(e);
  var t = this.head;
  e.list = this, e.next = t, t && (t.prev = e), this.head = e, this.tail || (this.tail = e), 
  this.length++;
 }
}, Yallist$1.prototype.pushNode = function(e) {
 if (e !== this.tail) {
  e.list && e.list.removeNode(e);
  var t = this.tail;
  e.list = this, e.prev = t, t && (t.next = e), this.tail = e, this.head || (this.head = e), 
  this.length++;
 }
}, Yallist$1.prototype.push = function() {
 for (var e = 0, t = arguments.length; e < t; e++) push(this, arguments[e]);
 return this.length;
}, Yallist$1.prototype.unshift = function() {
 for (var e = 0, t = arguments.length; e < t; e++) unshift(this, arguments[e]);
 return this.length;
}, Yallist$1.prototype.pop = function() {
 if (this.tail) {
  var e = this.tail.value;
  return this.tail = this.tail.prev, this.tail ? this.tail.next = null : this.head = null, 
  this.length--, e;
 }
}, Yallist$1.prototype.shift = function() {
 if (this.head) {
  var e = this.head.value;
  return this.head = this.head.next, this.head ? this.head.prev = null : this.tail = null, 
  this.length--, e;
 }
}, Yallist$1.prototype.forEach = function(e, t) {
 t = t || this;
 for (var s = this.head, r = 0; null !== s; r++) e.call(t, s.value, r, this), s = s.next;
}, Yallist$1.prototype.forEachReverse = function(e, t) {
 t = t || this;
 for (var s = this.tail, r = this.length - 1; null !== s; r--) e.call(t, s.value, r, this), 
 s = s.prev;
}, Yallist$1.prototype.get = function(e) {
 for (var t = 0, s = this.head; null !== s && t < e; t++) s = s.next;
 if (t === e && null !== s) return s.value;
}, Yallist$1.prototype.getReverse = function(e) {
 for (var t = 0, s = this.tail; null !== s && t < e; t++) s = s.prev;
 if (t === e && null !== s) return s.value;
}, Yallist$1.prototype.map = function(e, t) {
 var s, r;
 for (t = t || this, s = new Yallist$1, r = this.head; null !== r; ) s.push(e.call(t, r.value, this)), 
 r = r.next;
 return s;
}, Yallist$1.prototype.mapReverse = function(e, t) {
 var s, r;
 for (t = t || this, s = new Yallist$1, r = this.tail; null !== r; ) s.push(e.call(t, r.value, this)), 
 r = r.prev;
 return s;
}, Yallist$1.prototype.reduce = function(e, t) {
 var s, r, i = this.head;
 if (arguments.length > 1) s = t; else {
  if (!this.head) throw new TypeError("Reduce of empty list with no initial value");
  i = this.head.next, s = this.head.value;
 }
 for (r = 0; null !== i; r++) s = e(s, i.value, r), i = i.next;
 return s;
}, Yallist$1.prototype.reduceReverse = function(e, t) {
 var s, r, i = this.tail;
 if (arguments.length > 1) s = t; else {
  if (!this.tail) throw new TypeError("Reduce of empty list with no initial value");
  i = this.tail.prev, s = this.tail.value;
 }
 for (r = this.length - 1; null !== i; r--) s = e(s, i.value, r), i = i.prev;
 return s;
}, Yallist$1.prototype.toArray = function() {
 var e, t, s = new Array(this.length);
 for (e = 0, t = this.head; null !== t; e++) s[e] = t.value, t = t.next;
 return s;
}, Yallist$1.prototype.toArrayReverse = function() {
 var e, t, s = new Array(this.length);
 for (e = 0, t = this.tail; null !== t; e++) s[e] = t.value, t = t.prev;
 return s;
}, Yallist$1.prototype.slice = function(e, t) {
 var s, r, i;
 if ((t = t || this.length) < 0 && (t += this.length), (e = e || 0) < 0 && (e += this.length), 
 s = new Yallist$1, t < e || t < 0) return s;
 for (e < 0 && (e = 0), t > this.length && (t = this.length), r = 0, i = this.head; null !== i && r < e; r++) i = i.next;
 for (;null !== i && r < t; r++, i = i.next) s.push(i.value);
 return s;
}, Yallist$1.prototype.sliceReverse = function(e, t) {
 var s, r, i;
 if ((t = t || this.length) < 0 && (t += this.length), (e = e || 0) < 0 && (e += this.length), 
 s = new Yallist$1, t < e || t < 0) return s;
 for (e < 0 && (e = 0), t > this.length && (t = this.length), r = this.length, i = this.tail; null !== i && r > t; r--) i = i.prev;
 for (;null !== i && r > e; r--, i = i.prev) s.push(i.value);
 return s;
}, Yallist$1.prototype.splice = function(e, t, ...s) {
 var r, i, n;
 for (e > this.length && (e = this.length - 1), e < 0 && (e = this.length + e), r = 0, 
 i = this.head; null !== i && r < e; r++) i = i.next;
 for (n = [], r = 0; i && r < t; r++) n.push(i.value), i = this.removeNode(i);
 for (null === i && (i = this.tail), i !== this.head && i !== this.tail && (i = i.prev), 
 r = 0; r < s.length; r++) i = insert(this, i, s[r]);
 return n;
}, Yallist$1.prototype.reverse = function() {
 var e, t, s = this.head, r = this.tail;
 for (e = s; null !== e; e = e.prev) t = e.prev, e.prev = e.next, e.next = t;
 return this.head = r, this.tail = s, this;
};

try {
 require("./iterator.js")(Yallist$1);
} catch (e) {}

const Yallist = yallist, MAX = Symbol("max"), LENGTH = Symbol("length"), LENGTH_CALCULATOR = Symbol("lengthCalculator"), ALLOW_STALE = Symbol("allowStale"), MAX_AGE = Symbol("maxAge"), DISPOSE = Symbol("dispose"), NO_DISPOSE_ON_SET = Symbol("noDisposeOnSet"), LRU_LIST = Symbol("lruList"), CACHE = Symbol("cache"), UPDATE_AGE_ON_GET = Symbol("updateAgeOnGet"), naiveLength = () => 1, get = (e, t, s) => {
 const r = e[CACHE].get(t);
 if (r) {
  const t = r.value;
  if (isStale(e, t)) {
   if (del(e, r), !e[ALLOW_STALE]) return;
  } else s && (e[UPDATE_AGE_ON_GET] && (r.value.now = Date.now()), e[LRU_LIST].unshiftNode(r));
  return t.value;
 }
}, isStale = (e, t) => {
 if (!t || !t.maxAge && !e[MAX_AGE]) return !1;
 const s = Date.now() - t.now;
 return t.maxAge ? s > t.maxAge : e[MAX_AGE] && s > e[MAX_AGE];
}, trim = e => {
 if (e[LENGTH] > e[MAX]) for (let t = e[LRU_LIST].tail; e[LENGTH] > e[MAX] && null !== t; ) {
  const s = t.prev;
  del(e, t), t = s;
 }
}, del = (e, t) => {
 if (t) {
  const s = t.value;
  e[DISPOSE] && e[DISPOSE](s.key, s.value), e[LENGTH] -= s.length, e[CACHE].delete(s.key), 
  e[LRU_LIST].removeNode(t);
 }
};

class Entry {
 constructor(e, t, s, r, i) {
  this.key = e, this.value = t, this.length = s, this.now = r, this.maxAge = i || 0;
 }
}

const forEachStep = (e, t, s, r) => {
 let i = s.value;
 isStale(e, i) && (del(e, s), e[ALLOW_STALE] || (i = void 0)), i && t.call(r, i.value, i.key, e);
};

lruCache = class LRUCache {
 constructor(e) {
  if ("number" == typeof e && (e = {
   max: e
  }), e || (e = {}), e.max && ("number" != typeof e.max || e.max < 0)) throw new TypeError("max must be a non-negative number");
  this[MAX] = e.max || 1 / 0;
  const t = e.length || naiveLength;
  if (this[LENGTH_CALCULATOR] = "function" != typeof t ? naiveLength : t, this[ALLOW_STALE] = e.stale || !1, 
  e.maxAge && "number" != typeof e.maxAge) throw new TypeError("maxAge must be a number");
  this[MAX_AGE] = e.maxAge || 0, this[DISPOSE] = e.dispose, this[NO_DISPOSE_ON_SET] = e.noDisposeOnSet || !1, 
  this[UPDATE_AGE_ON_GET] = e.updateAgeOnGet || !1, this.reset();
 }
 set max(e) {
  if ("number" != typeof e || e < 0) throw new TypeError("max must be a non-negative number");
  this[MAX] = e || 1 / 0, trim(this);
 }
 get max() {
  return this[MAX];
 }
 set allowStale(e) {
  this[ALLOW_STALE] = !!e;
 }
 get allowStale() {
  return this[ALLOW_STALE];
 }
 set maxAge(e) {
  if ("number" != typeof e) throw new TypeError("maxAge must be a non-negative number");
  this[MAX_AGE] = e, trim(this);
 }
 get maxAge() {
  return this[MAX_AGE];
 }
 set lengthCalculator(e) {
  "function" != typeof e && (e = naiveLength), e !== this[LENGTH_CALCULATOR] && (this[LENGTH_CALCULATOR] = e, 
  this[LENGTH] = 0, this[LRU_LIST].forEach((e => {
   e.length = this[LENGTH_CALCULATOR](e.value, e.key), this[LENGTH] += e.length;
  }))), trim(this);
 }
 get lengthCalculator() {
  return this[LENGTH_CALCULATOR];
 }
 get length() {
  return this[LENGTH];
 }
 get itemCount() {
  return this[LRU_LIST].length;
 }
 rforEach(e, t) {
  t = t || this;
  for (let s = this[LRU_LIST].tail; null !== s; ) {
   const r = s.prev;
   forEachStep(this, e, s, t), s = r;
  }
 }
 forEach(e, t) {
  t = t || this;
  for (let s = this[LRU_LIST].head; null !== s; ) {
   const r = s.next;
   forEachStep(this, e, s, t), s = r;
  }
 }
 keys() {
  return this[LRU_LIST].toArray().map((e => e.key));
 }
 values() {
  return this[LRU_LIST].toArray().map((e => e.value));
 }
 reset() {
  this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length && this[LRU_LIST].forEach((e => this[DISPOSE](e.key, e.value))), 
  this[CACHE] = new Map, this[LRU_LIST] = new Yallist, this[LENGTH] = 0;
 }
 dump() {
  return this[LRU_LIST].map((e => !isStale(this, e) && {
   k: e.key,
   v: e.value,
   e: e.now + (e.maxAge || 0)
  })).toArray().filter((e => e));
 }
 dumpLru() {
  return this[LRU_LIST];
 }
 set(e, t, s) {
  if ((s = s || this[MAX_AGE]) && "number" != typeof s) throw new TypeError("maxAge must be a number");
  const r = s ? Date.now() : 0, i = this[LENGTH_CALCULATOR](t, e);
  if (this[CACHE].has(e)) {
   if (i > this[MAX]) return del(this, this[CACHE].get(e)), !1;
   const n = this[CACHE].get(e).value;
   return this[DISPOSE] && (this[NO_DISPOSE_ON_SET] || this[DISPOSE](e, n.value)), 
   n.now = r, n.maxAge = s, n.value = t, this[LENGTH] += i - n.length, n.length = i, 
   this.get(e), trim(this), !0;
  }
  const n = new Entry(e, t, i, r, s);
  return n.length > this[MAX] ? (this[DISPOSE] && this[DISPOSE](e, t), !1) : (this[LENGTH] += n.length, 
  this[LRU_LIST].unshift(n), this[CACHE].set(e, this[LRU_LIST].head), trim(this), 
  !0);
 }
 has(e) {
  if (!this[CACHE].has(e)) return !1;
  const t = this[CACHE].get(e).value;
  return !isStale(this, t);
 }
 get(e) {
  return get(this, e, !0);
 }
 peek(e) {
  return get(this, e, !1);
 }
 pop() {
  const e = this[LRU_LIST].tail;
  return e ? (del(this, e), e.value) : null;
 }
 del(e) {
  del(this, this[CACHE].get(e));
 }
 load(e) {
  this.reset();
  const t = Date.now();
  for (let s = e.length - 1; s >= 0; s--) {
   const r = e[s], i = r.e || 0;
   if (0 === i) this.set(r.k, r.v); else {
    const e = i - t;
    e > 0 && this.set(r.k, r.v, e);
   }
  }
 }
 prune() {
  this[CACHE].forEach(((e, t) => get(this, t, !1)));
 }
};

const compare$4 = compare_1, compare$3 = compare_1, compare$2 = compare_1, compare$1 = compare_1, compare = compare_1, semverLt = lt_1 = (e, t, s) => compare(e, t, s) < 0, lt = lt_1, lte = lte_1;

cmp_1 = (e, t, s, r) => {
 switch (t) {
 case "===":
  return "object" == typeof e && (e = e.version), "object" == typeof s && (s = s.version), 
  e === s;

 case "!==":
  return "object" == typeof e && (e = e.version), "object" == typeof s && (s = s.version), 
  e !== s;

 case "":
 case "=":
 case "==":
  return ((e, t, s) => 0 === compare$4(e, t, s))(e, s, r);

 case "!=":
  return ((e, t, s) => 0 !== compare$3(e, t, s))(e, s, r);

 case ">":
  return ((e, t, s) => compare$2(e, t, s) > 0)(e, s, r);

 case ">=":
  return ((e, t, s) => compare$1(e, t, s) >= 0)(e, s, r);

 case "<":
  return lt(e, s, r);

 case "<=":
  return lte(e, s, r);

 default:
  throw new TypeError(`Invalid operator: ${t}`);
 }
};

const ANY = Symbol("SemVer ANY");

class Comparator$1 {
 static get ANY() {
  return ANY;
 }
 constructor(e, t) {
  if (t = parseOptions$1(t), e instanceof Comparator$1) {
   if (e.loose === !!t.loose) return e;
   e = e.value;
  }
  e = e.trim().split(/\s+/).join(" "), debug$1("comparator", e, t), this.options = t, 
  this.loose = !!t.loose, this.parse(e), this.semver === ANY ? this.value = "" : this.value = this.operator + this.semver.version, 
  debug$1("comp", this);
 }
 parse(e) {
  const t = this.options.loose ? re$1[t$1.COMPARATORLOOSE] : re$1[t$1.COMPARATOR], s = e.match(t);
  if (!s) throw new TypeError(`Invalid comparator: ${e}`);
  this.operator = void 0 !== s[1] ? s[1] : "", "=" === this.operator && (this.operator = ""), 
  s[2] ? this.semver = new SemVer$1(s[2], this.options.loose) : this.semver = ANY;
 }
 toString() {
  return this.value;
 }
 test(e) {
  if (debug$1("Comparator.test", e, this.options.loose), this.semver === ANY || e === ANY) return !0;
  if ("string" == typeof e) try {
   e = new SemVer$1(e, this.options);
  } catch (e) {
   return !1;
  }
  return cmp(e, this.operator, this.semver, this.options);
 }
 intersects(e, t) {
  if (!(e instanceof Comparator$1)) throw new TypeError("a Comparator is required");
  return "" === this.operator ? "" === this.value || new Range$2(e.value, t).test(this.value) : "" === e.operator ? "" === e.value || new Range$2(this.value, t).test(e.semver) : !((t = parseOptions$1(t)).includePrerelease && ("<0.0.0-0" === this.value || "<0.0.0-0" === e.value) || !t.includePrerelease && (this.value.startsWith("<0.0.0") || e.value.startsWith("<0.0.0")) || (!this.operator.startsWith(">") || !e.operator.startsWith(">")) && (!this.operator.startsWith("<") || !e.operator.startsWith("<")) && (this.semver.version !== e.semver.version || !this.operator.includes("=") || !e.operator.includes("=")) && !(cmp(this.semver, "<", e.semver, t) && this.operator.startsWith(">") && e.operator.startsWith("<")) && !(cmp(this.semver, ">", e.semver, t) && this.operator.startsWith("<") && e.operator.startsWith(">")));
 }
}

comparator = Comparator$1;

const parseOptions$1 = parseOptions_1, {safeRe: re$1, t: t$1} = re$3.exports, cmp = cmp_1, debug$1 = debug_1, SemVer$1 = semver, Range$2 = range;

class Range$1 {
 constructor(e, t) {
  if (t = parseOptions(t), e instanceof Range$1) return e.loose === !!t.loose && e.includePrerelease === !!t.includePrerelease ? e : new Range$1(e.raw, t);
  if (e instanceof Comparator) return this.raw = e.value, this.set = [ [ e ] ], this.format(), 
  this;
  if (this.options = t, this.loose = !!t.loose, this.includePrerelease = !!t.includePrerelease, 
  this.raw = e.trim().split(/\s+/).join(" "), this.set = this.raw.split("||").map((e => this.parseRange(e.trim()))).filter((e => e.length)), 
  !this.set.length) throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
  if (this.set.length > 1) {
   const e = this.set[0];
   if (this.set = this.set.filter((e => !isNullSet(e[0]))), 0 === this.set.length) this.set = [ e ]; else if (this.set.length > 1) for (const e of this.set) if (1 === e.length && isAny(e[0])) {
    this.set = [ e ];
    break;
   }
  }
  this.format();
 }
 format() {
  return this.range = this.set.map((e => e.join(" ").trim())).join("||").trim(), this.range;
 }
 toString() {
  return this.range;
 }
 parseRange(e) {
  const s = ((this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE)) + ":" + e, r = cache.get(s);
  if (r) return r;
  const i = this.options.loose, n = i ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
  e = e.replace(n, hyphenReplace(this.options.includePrerelease)), debug("hyphen replace", e), 
  e = e.replace(re[t.COMPARATORTRIM], comparatorTrimReplace), debug("comparator trim", e), 
  e = e.replace(re[t.TILDETRIM], tildeTrimReplace), debug("tilde trim", e), e = e.replace(re[t.CARETTRIM], caretTrimReplace), 
  debug("caret trim", e);
  let o = e.split(" ").map((e => parseComparator(e, this.options))).join(" ").split(/\s+/).map((e => replaceGTE0(e, this.options)));
  i && (o = o.filter((e => (debug("loose invalid filter", e, this.options), !!e.match(re[t.COMPARATORLOOSE]))))), 
  debug("range list", o);
  const a = new Map, l = o.map((e => new Comparator(e, this.options)));
  for (const e of l) {
   if (isNullSet(e)) return [ e ];
   a.set(e.value, e);
  }
  a.size > 1 && a.has("") && a.delete("");
  const c = [ ...a.values() ];
  return cache.set(s, c), c;
 }
 intersects(e, t) {
  if (!(e instanceof Range$1)) throw new TypeError("a Range is required");
  return this.set.some((s => isSatisfiable(s, t) && e.set.some((e => isSatisfiable(e, t) && s.every((s => e.every((e => s.intersects(e, t)))))))));
 }
 test(e) {
  if (!e) return !1;
  if ("string" == typeof e) try {
   e = new SemVer(e, this.options);
  } catch (e) {
   return !1;
  }
  for (let t = 0; t < this.set.length; t++) if (testSet(this.set[t], e, this.options)) return !0;
  return !1;
 }
}

range = Range$1;

const cache = new lruCache({
 max: 1e3
}), parseOptions = parseOptions_1, Comparator = comparator, debug = debug_1, SemVer = semver, {safeRe: re, t, comparatorTrimReplace, tildeTrimReplace, caretTrimReplace} = re$3.exports, {FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE} = constants$3, isNullSet = e => "<0.0.0-0" === e.value, isAny = e => "" === e.value, isSatisfiable = (e, t) => {
 let s = !0;
 const r = e.slice();
 let i = r.pop();
 for (;s && r.length; ) s = r.every((e => i.intersects(e, t))), i = r.pop();
 return s;
}, parseComparator = (e, t) => (debug("comp", e, t), e = replaceCarets(e, t), debug("caret", e), 
e = replaceTildes(e, t), debug("tildes", e), e = replaceXRanges(e, t), debug("xrange", e), 
e = replaceStars(e, t), debug("stars", e), e), isX = e => !e || "x" === e.toLowerCase() || "*" === e, replaceTildes = (e, t) => e.trim().split(/\s+/).map((e => replaceTilde(e, t))).join(" "), replaceTilde = (e, s) => {
 const r = s.loose ? re[t.TILDELOOSE] : re[t.TILDE];
 return e.replace(r, ((t, s, r, i, n) => {
  let o;
  return debug("tilde", e, t, s, r, i, n), isX(s) ? o = "" : isX(r) ? o = `>=${s}.0.0 <${+s + 1}.0.0-0` : isX(i) ? o = `>=${s}.${r}.0 <${s}.${+r + 1}.0-0` : n ? (debug("replaceTilde pr", n), 
  o = `>=${s}.${r}.${i}-${n} <${s}.${+r + 1}.0-0`) : o = `>=${s}.${r}.${i} <${s}.${+r + 1}.0-0`, 
  debug("tilde return", o), o;
 }));
}, replaceCarets = (e, t) => e.trim().split(/\s+/).map((e => replaceCaret(e, t))).join(" "), replaceCaret = (e, s) => {
 debug("caret", e, s);
 const r = s.loose ? re[t.CARETLOOSE] : re[t.CARET], i = s.includePrerelease ? "-0" : "";
 return e.replace(r, ((t, s, r, n, o) => {
  let a;
  return debug("caret", e, t, s, r, n, o), isX(s) ? a = "" : isX(r) ? a = `>=${s}.0.0${i} <${+s + 1}.0.0-0` : isX(n) ? a = "0" === s ? `>=${s}.${r}.0${i} <${s}.${+r + 1}.0-0` : `>=${s}.${r}.0${i} <${+s + 1}.0.0-0` : o ? (debug("replaceCaret pr", o), 
  a = "0" === s ? "0" === r ? `>=${s}.${r}.${n}-${o} <${s}.${r}.${+n + 1}-0` : `>=${s}.${r}.${n}-${o} <${s}.${+r + 1}.0-0` : `>=${s}.${r}.${n}-${o} <${+s + 1}.0.0-0`) : (debug("no pr"), 
  a = "0" === s ? "0" === r ? `>=${s}.${r}.${n}${i} <${s}.${r}.${+n + 1}-0` : `>=${s}.${r}.${n}${i} <${s}.${+r + 1}.0-0` : `>=${s}.${r}.${n} <${+s + 1}.0.0-0`), 
  debug("caret return", a), a;
 }));
}, replaceXRanges = (e, t) => (debug("replaceXRanges", e, t), e.split(/\s+/).map((e => replaceXRange(e, t))).join(" ")), replaceXRange = (e, s) => {
 e = e.trim();
 const r = s.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
 return e.replace(r, ((t, r, i, n, o, a) => {
  debug("xRange", e, t, r, i, n, o, a);
  const l = isX(i), c = l || isX(n), u = c || isX(o), h = u;
  return "=" === r && h && (r = ""), a = s.includePrerelease ? "-0" : "", l ? t = ">" === r || "<" === r ? "<0.0.0-0" : "*" : r && h ? (c && (n = 0), 
  o = 0, ">" === r ? (r = ">=", c ? (i = +i + 1, n = 0, o = 0) : (n = +n + 1, o = 0)) : "<=" === r && (r = "<", 
  c ? i = +i + 1 : n = +n + 1), "<" === r && (a = "-0"), t = `${r + i}.${n}.${o}${a}`) : c ? t = `>=${i}.0.0${a} <${+i + 1}.0.0-0` : u && (t = `>=${i}.${n}.0${a} <${i}.${+n + 1}.0-0`), 
  debug("xRange return", t), t;
 }));
}, replaceStars = (e, s) => (debug("replaceStars", e, s), e.trim().replace(re[t.STAR], "")), replaceGTE0 = (e, s) => (debug("replaceGTE0", e, s), 
e.trim().replace(re[s.includePrerelease ? t.GTE0PRE : t.GTE0], "")), hyphenReplace = e => (t, s, r, i, n, o, a, l, c, u, h, p, d) => `${s = isX(r) ? "" : isX(i) ? `>=${r}.0.0${e ? "-0" : ""}` : isX(n) ? `>=${r}.${i}.0${e ? "-0" : ""}` : o ? `>=${s}` : `>=${s}${e ? "-0" : ""}`} ${l = isX(c) ? "" : isX(u) ? `<${+c + 1}.0.0-0` : isX(h) ? `<${c}.${+u + 1}.0-0` : p ? `<=${c}.${u}.${h}-${p}` : e ? `<${c}.${u}.${+h + 1}-0` : `<=${l}`}`.trim(), testSet = (e, t, s) => {
 for (let s = 0; s < e.length; s++) if (!e[s].test(t)) return !1;
 if (t.prerelease.length && !s.includePrerelease) {
  for (let s = 0; s < e.length; s++) if (debug(e[s].semver), e[s].semver !== Comparator.ANY && e[s].semver.prerelease.length > 0) {
   const r = e[s].semver;
   if (r.major === t.major && r.minor === t.minor && r.patch === t.patch) return !0;
  }
  return !1;
 }
 return !0;
}, Range = range;

satisfies_1 = (e, t, s) => {
 try {
  t = new Range(t, s);
 } catch (e) {
  return !1;
 }
 return t.test(e);
};

const satisfies$1 = satisfies_1;

class NodeLazyRequire {
 constructor(e, t) {
  this.nodeResolveModule = e, this.lazyDependencies = t, this.ensured = new Set;
 }
 async ensure(e, t) {
  const s = [], r = [];
  if (t.forEach((t => {
   if (!this.ensured.has(t)) {
    const {minVersion: s, recommendedVersion: i, maxVersion: n} = this.lazyDependencies[t];
    try {
     const r = this.nodeResolveModule.resolveModule(e, t), i = JSON.parse(fs$5.readFileSync(r, "utf8"));
     if (n ? satisfies$1(i.version, `${s} - ${major$1(n)}.x`) : semverLte(s, i.version)) return void this.ensured.add(t);
    } catch (e) {}
    r.push(`${t}@${i}`);
   }
  })), r.length > 0) {
   const e = buildError(s);
   e.header = "Please install supported versions of dev dependencies with either npm or yarn.", 
   e.messageText = `npm install --save-dev ${r.join(" ")}`;
  }
  return s;
 }
 require(e, t) {
  const s = this.getModulePath(e, t);
  return require(s);
 }
 getModulePath(e, t) {
  const s = this.nodeResolveModule.resolveModule(e, t);
  return path__default.default.dirname(s);
 }
}

class NodeResolveModule {
 constructor() {
  this.resolveModuleCache = new Map;
 }
 resolveModule(e, t, s) {
  const r = `${e}:${t}`, i = this.resolveModuleCache.get(r);
  if (i) return i;
  if (s && s.manuallyResolve) return this.resolveModuleManually(e, t, r);
  if (t.startsWith("@types/")) return this.resolveTypesModule(e, t, r);
  const n = require("module");
  e = path__default.default.resolve(e);
  const o = path__default.default.join(e, "noop.js");
  let a = normalizePath(n._resolveFilename(t, {
   id: o,
   filename: o,
   paths: n._nodeModulePaths(e)
  }));
  const l = normalizePath(path__default.default.parse(e).root);
  let c;
  for (;a !== l; ) if (a = normalizePath(path__default.default.dirname(a)), c = path__default.default.join(a, "package.json"), 
  fs$5.existsSync(c)) return this.resolveModuleCache.set(r, c), c;
  throw new Error(`error loading "${t}" from "${e}"`);
 }
 resolveTypesModule(e, t, s) {
  const r = t.split("/"), i = normalizePath(path__default.default.parse(e).root);
  let n, o = normalizePath(path__default.default.join(e, "noop.js"));
  for (;o !== i; ) if (o = normalizePath(path__default.default.dirname(o)), n = path__default.default.join(o, "node_modules", r[0], r[1], "package.json"), 
  fs$5.existsSync(n)) return this.resolveModuleCache.set(s, n), n;
  throw new Error(`error loading "${t}" from "${e}"`);
 }
 resolveModuleManually(e, t, s) {
  const r = normalizePath(path__default.default.parse(e).root);
  let i, n = normalizePath(path__default.default.join(e, "noop.js"));
  for (;n !== r; ) if (n = normalizePath(path__default.default.dirname(n)), i = path__default.default.join(n, "node_modules", t, "package.json"), 
  fs$5.existsSync(i)) return this.resolveModuleCache.set(s, i), i;
  throw new Error(`error loading "${t}" from "${e}"`);
 }
}

const REGISTRY_URL = "https://registry.npmjs.org/@stencil/core", CHECK_INTERVAL = 6048e5, CHANGELOG = "https://github.com/ionic-team/stencil/blob/main/CHANGELOG.md", ARROW = "→", BOX_TOP_LEFT = "╭", BOX_TOP_RIGHT = "╮", BOX_BOTTOM_LEFT = "╰", BOX_BOTTOM_RIGHT = "╯", BOX_VERTICAL = "│", BOX_HORIZONTAL = "─", PADDING = 2, INDENT = "   ";

class NodeWorkerMain extends require$$7.EventEmitter {
 constructor(e, t) {
  super(), this.id = e, this.tasks = new Map, this.exitCode = null, this.processQueue = !0, 
  this.sendQueue = [], this.stopped = !1, this.successfulMessage = !1, this.totalTasksAssigned = 0, 
  this.fork(t);
 }
 fork(e) {
  const t = {
   execArgv: process.execArgv.filter((e => !/^--(debug|inspect)/.test(e))),
   env: process.env,
   cwd: process.cwd(),
   silent: !0
  };
  this.childProcess = cp__namespace.fork(e, [], t), this.childProcess.stdout.setEncoding("utf8"), 
  this.childProcess.stdout.on("data", (e => {
   console.log(e);
  })), this.childProcess.stderr.setEncoding("utf8"), this.childProcess.stderr.on("data", (e => {
   console.log(e);
  })), this.childProcess.on("message", this.receiveFromWorker.bind(this)), this.childProcess.on("error", (e => {
   this.emit("error", e);
  })), this.childProcess.once("exit", (e => {
   this.exitCode = e, this.emit("exit", e);
  }));
 }
 run(e) {
  this.totalTasksAssigned++, this.tasks.set(e.stencilId, e);
  const [t, ...s] = e.inputArgs;
  this.sendToWorker({
   stencilId: e.stencilId,
   method: t,
   args: s
  });
 }
 sendToWorker(e) {
  this.processQueue ? this.childProcess.send(e, (e => {
   if (!(e && e instanceof Error) && (this.processQueue = !0, this.sendQueue.length > 0)) {
    const e = this.sendQueue.slice();
    this.sendQueue = [], e.forEach((e => this.sendToWorker(e)));
   }
  })) && !/^win/.test(process.platform) || (this.processQueue = !1) : this.sendQueue.push(e);
 }
 receiveFromWorker(e) {
  if (this.successfulMessage = !0, this.stopped) return;
  const t = this.tasks.get(e.stencilId);
  t ? (null != e.stencilRtnError ? t.reject(e.stencilRtnError) : t.resolve(e.stencilRtnValue), 
  this.tasks.delete(e.stencilId), this.emit("response", e)) : null != e.stencilRtnError && this.emit("error", e.stencilRtnError);
 }
 stop() {
  this.stopped = !0, this.tasks.forEach((e => e.reject(TASK_CANCELED_MSG))), this.tasks.clear(), 
  this.successfulMessage ? (this.childProcess.send({
   exit: !0
  }), setTimeout((() => {
   null === this.exitCode && this.childProcess.kill("SIGKILL");
  }), 100)) : this.childProcess.kill("SIGKILL");
 }
}

class NodeWorkerController extends require$$7.EventEmitter {
 constructor(e, t) {
  super(), this.forkModulePath = e, this.workerIds = 0, this.stencilId = 0, this.isEnding = !1, 
  this.taskQueue = [], this.workers = [];
  const s = os$3.cpus().length;
  this.useForkedWorkers = t > 0, this.maxWorkers = Math.max(Math.min(t, s), 2) - 1, 
  this.useForkedWorkers ? this.startWorkers() : this.mainThreadRunner = require(e);
 }
 onError(e, t) {
  if ("ERR_IPC_CHANNEL_CLOSED" === e.code) return this.stopWorker(t);
  "EPIPE" !== e.code && console.error(e);
 }
 onExit(e) {
  setTimeout((() => {
   let t = !1;
   const s = this.workers.find((t => t.id === e));
   s && (s.tasks.forEach((e => {
    e.retries++, this.taskQueue.unshift(e), t = !0;
   })), s.tasks.clear()), this.stopWorker(e), t && this.processTaskQueue();
  }), 10);
 }
 startWorkers() {
  for (;this.workers.length < this.maxWorkers; ) this.startWorker();
 }
 startWorker() {
  const e = this.workerIds++, t = new NodeWorkerMain(e, this.forkModulePath);
  t.on("response", this.processTaskQueue.bind(this)), t.once("exit", (() => {
   this.onExit(e);
  })), t.on("error", (t => {
   this.onError(t, e);
  })), this.workers.push(t);
 }
 stopWorker(e) {
  const t = this.workers.find((t => t.id === e));
  if (t) {
   t.stop();
   const e = this.workers.indexOf(t);
   e > -1 && this.workers.splice(e, 1);
  }
 }
 processTaskQueue() {
  if (!this.isEnding) for (this.useForkedWorkers && this.startWorkers(); this.taskQueue.length > 0; ) {
   const e = getNextWorker(this.workers);
   if (!e) break;
   e.run(this.taskQueue.shift());
  }
 }
 send(...e) {
  return this.isEnding ? Promise.reject(TASK_CANCELED_MSG) : this.useForkedWorkers ? new Promise(((t, s) => {
   const r = {
    stencilId: this.stencilId++,
    inputArgs: e,
    retries: 0,
    resolve: t,
    reject: s
   };
   this.taskQueue.push(r), this.processTaskQueue();
  })) : this.mainThreadRunner[e[0]].apply(null, e.slice(1));
 }
 handler(e) {
  return (...t) => this.send(e, ...t);
 }
 cancelTasks() {
  for (const e of this.workers) e.tasks.forEach((e => e.reject(TASK_CANCELED_MSG))), 
  e.tasks.clear();
  this.taskQueue.length = 0;
 }
 destroy() {
  if (!this.isEnding) {
   this.isEnding = !0;
   for (const e of this.taskQueue) e.reject(TASK_CANCELED_MSG);
   this.taskQueue.length = 0;
   const e = this.workers.map((e => e.id));
   for (const t of e) this.stopWorker(t);
  }
 }
}

const getAbsolutePath = (e, t) => (path$6.isAbsolute(t) || (t = join(e.rootDir, t)), 
t), setBooleanConfig = (e, t, s, r) => {
 var i;
 if (s) {
  const r = null === (i = e.flags) || void 0 === i ? void 0 : i[s];
  isBoolean(r) && (e[t] = r);
 }
 const n = getUserConfigName(e, t);
 "function" == typeof e[n] && (e[n] = !!e[n]()), isBoolean(e[n]) ? e[t] = e[n] : e[t] = r;
}, getUserConfigName = (e, t) => {
 var s;
 const r = Object.keys(e);
 for (const i of r) if (i.toLowerCase() === t.toLowerCase()) {
  if (i !== t) return null === (s = e.logger) || void 0 === s || s.warn(`config "${i}" should be "${t}"`), 
  i;
  break;
 }
 return t;
}, validateCollection = (e, t) => t.filter(isOutputTargetDistCollection).map((t => {
 var s;
 return {
  ...t,
  transformAliasedImportPaths: !isBoolean(t.transformAliasedImportPaths) || t.transformAliasedImportPaths,
  dir: getAbsolutePath(e, null !== (s = t.dir) && void 0 !== s ? s : "dist/collection")
 };
})), validateCopy = (e, t = []) => {
 if (null === e || !1 === e) return [];
 Array.isArray(e) || (e = []), e = e.slice();
 for (const s of t) e.every((e => e.src !== s.src)) && e.push(s);
 return ((e, t = (e => e)) => {
  const s = new Set;
  return e.filter((e => {
   const r = t(e);
   return null == r || !s.has(r) && (s.add(r), !0);
  }));
 })(e, (e => `${e.src}:${e.dest}:${e.keepDirStructure}`));
}, validateCustomElement = (e, t) => {
 const s = "dist";
 return t.filter(isOutputTargetDistCustomElements).reduce(((t, r) => {
  const i = {
   ...r,
   dir: getAbsolutePath(e, r.dir || join(s, "components"))
  };
  if (isBoolean(i.empty) || (i.empty = !0), isBoolean(i.externalRuntime) || (i.externalRuntime = !0), 
  isBoolean(i.generateTypeDeclarations) || (i.generateTypeDeclarations = !0), null != i.customElementsExportBehavior && CustomElementsExportBehaviorOptions.includes(i.customElementsExportBehavior) || (i.customElementsExportBehavior = "default"), 
  i.generateTypeDeclarations) {
   const r = getAbsolutePath(e, join(s, "types"));
   t.push({
    type: "dist-types",
    dir: i.dir,
    typesDir: r
   });
  }
  return i.copy = validateCopy(i.copy, []), i.copy.length > 0 && t.push({
   type: COPY,
   dir: e.rootDir,
   copy: [ ...i.copy ]
  }), t.push(i), t;
 }), []);
}, validateCustomOutput = (e, t, s) => s.filter(isOutputTargetCustom).map((s => {
 if (s.validate) {
  const r = [];
  try {
   s.validate(e, t);
  } catch (e) {
   catchError(r, e);
  }
  s.copy && s.copy.length > 0 && e.outputTargets.push({
   type: COPY,
   dir: e.rootDir,
   copy: [ ...s.copy ]
  }), t.push(...r);
 }
 return s;
})), validateDist = (e, t) => {
 var s;
 const r = t.filter(isOutputTargetDist), i = [];
 for (const t of r) {
  const r = validateOutputTargetDist(e, t);
  i.push(r);
  const n = e.fsNamespace || "app", o = join(r.buildDir, n);
  if (i.push({
   type: "dist-lazy",
   esmDir: o,
   systemDir: e.buildEs5 ? o : void 0,
   systemLoaderFile: e.buildEs5 ? join(o, n + ".js") : void 0,
   legacyLoaderFile: join(r.buildDir, n + ".js"),
   polyfills: void 0 === t.polyfills || !!r.polyfills,
   isBrowserBuild: !0,
   empty: r.empty
  }), i.push({
   type: COPY,
   dir: o,
   copyAssets: "dist",
   copy: (null !== (s = r.copy) && void 0 !== s ? s : []).concat()
  }), i.push({
   type: "dist-global-styles",
   file: join(o, `${e.fsNamespace}.css`)
  }), i.push({
   type: "dist-types",
   dir: r.dir,
   typesDir: r.typesDir
  }), e.buildDist) {
   r.collectionDir && (i.push({
    type: "dist-collection",
    dir: r.dir,
    collectionDir: r.collectionDir,
    empty: r.empty,
    transformAliasedImportPaths: r.transformAliasedImportPathsInCollection
   }), i.push({
    type: COPY,
    dir: r.collectionDir,
    copyAssets: "collection",
    copy: [ ...r.copy, {
     src: "**/*.svg"
    }, {
     src: "**/*.js"
    } ]
   }));
   const t = join(r.dir, "esm"), s = e.buildEs5 ? join(r.dir, "esm-es5") : void 0, n = join(r.dir, "cjs");
   i.push({
    type: "dist-lazy",
    esmDir: t,
    esmEs5Dir: s,
    cjsDir: n,
    cjsIndexFile: join(r.dir, "index.cjs.js"),
    esmIndexFile: join(r.dir, "index.js"),
    polyfills: !0,
    empty: r.empty
   }), i.push({
    type: "dist-lazy-loader",
    dir: r.esmLoaderPath,
    esmDir: t,
    esmEs5Dir: s,
    cjsDir: n,
    componentDts: getComponentsDtsTypesFilePath(r),
    empty: r.empty
   });
  }
 }
 return i;
}, validateOutputTargetDist = (e, t) => {
 var s, r;
 const i = {
  ...t,
  dir: getAbsolutePath(e, t.dir || DEFAULT_DIR),
  buildDir: isString(t.buildDir) ? t.buildDir : DEFAULT_BUILD_DIR,
  collectionDir: void 0 !== t.collectionDir ? t.collectionDir : DEFAULT_COLLECTION_DIR,
  typesDir: t.typesDir || DEFAULT_TYPES_DIR,
  esmLoaderPath: t.esmLoaderPath || DEFAULT_ESM_LOADER_DIR,
  copy: validateCopy(null !== (s = t.copy) && void 0 !== s ? s : [], []),
  polyfills: !!isBoolean(t.polyfills) && t.polyfills,
  empty: !isBoolean(t.empty) || t.empty,
  transformAliasedImportPathsInCollection: !isBoolean(t.transformAliasedImportPathsInCollection) || t.transformAliasedImportPathsInCollection,
  isPrimaryPackageOutputTarget: null !== (r = t.isPrimaryPackageOutputTarget) && void 0 !== r && r
 };
 return path$6.isAbsolute(i.buildDir) || (i.buildDir = join(i.dir, i.buildDir)), 
 i.collectionDir && !path$6.isAbsolute(i.collectionDir) && (i.collectionDir = join(i.dir, i.collectionDir)), 
 path$6.isAbsolute(i.esmLoaderPath) || (i.esmLoaderPath = function n(...e) {
  return normalizePath(path__default.default.resolve(...e), !1);
 }(i.dir, i.esmLoaderPath)), path$6.isAbsolute(i.typesDir) || (i.typesDir = join(i.dir, i.typesDir)), 
 i;
}, DEFAULT_DIR = "dist", DEFAULT_BUILD_DIR = "", DEFAULT_COLLECTION_DIR = "collection", DEFAULT_TYPES_DIR = "types", DEFAULT_ESM_LOADER_DIR = "loader", validateDocs = (e, t, s) => {
 const r = [];
 return isString(e.flags.docsJson) && r.push(validateJsonDocsOutputTarget(e, t, {
  type: "docs-json",
  file: e.flags.docsJson
 })), s.filter(isOutputTargetDocsJson).forEach((s => {
  r.push(validateJsonDocsOutputTarget(e, t, s));
 })), (e.flags.docs || "docs" === e.flags.task) && (s.some(isOutputTargetDocsReadme) || r.push(validateReadmeOutputTarget(e, {
  type: "docs-readme"
 }))), s.filter(isOutputTargetDocsReadme).forEach((t => {
  r.push(validateReadmeOutputTarget(e, t));
 })), s.filter(isOutputTargetDocsCustom).forEach((e => {
  r.push(validateCustomDocsOutputTarget(t, e));
 })), s.filter(isOutputTargetDocsVscode).forEach((e => {
  r.push(validateVScodeDocsOutputTarget(t, e));
 })), r;
}, validateReadmeOutputTarget = (e, t) => (isString(t.dir) || (t.dir = e.srcDir), 
path$6.isAbsolute(t.dir) || (t.dir = join(e.rootDir, t.dir)), null == t.footer && (t.footer = "*Built with [StencilJS](https://stenciljs.com/)*"), 
t.strict = !!t.strict, t), validateJsonDocsOutputTarget = (e, t, s) => (isString(s.file) || (buildError(t).messageText = 'docs-json outputTarget missing the "file" option'), 
s.file = join(e.rootDir, s.file), isString(s.typesFile) ? s.typesFile = join(e.rootDir, s.typesFile) : null !== s.typesFile && s.file.endsWith(".json") && (s.typesFile = s.file.replace(/\.json$/, ".d.ts")), 
s.strict = !!s.strict, s), validateCustomDocsOutputTarget = (e, t) => (isFunction(t.generator) || (buildError(e).messageText = 'docs-custom outputTarget missing the "generator" function'), 
t.strict = !!t.strict, t), validateVScodeDocsOutputTarget = (e, t) => (isString(t.file) || (buildError(e).messageText = 'docs-vscode outputTarget missing the "file" path'), 
t), validateHydrateScript = (e, t) => {
 const s = [];
 if (!t.some(isOutputTargetHydrate)) {
  const s = t.filter(isOutputTargetWww).some((e => isString(e.indexHtml))), r = e.flags.prerender || e.flags.ssr;
  if (s && r) {
   let e;
   const s = t.find(isOutputTargetDist);
   e = null != s && isString(s.dir) ? join(s.dir, "hydrate") : "dist/hydrate";
   const r = {
    type: "dist-hydrate-script",
    dir: e
   };
   t.push(r);
  }
 }
 return t.filter(isOutputTargetHydrate).forEach((t => {
  isString(t.dir) || (t.dir = "hydrate"), path$6.isAbsolute(t.dir) || (t.dir = join(e.rootDir, t.dir)), 
  isBoolean(t.empty) || (t.empty = !0), t.external = t.external || [], t.external.push("fs"), 
  t.external.push("path"), t.external.push("crypto"), s.push(t);
 })), s;
}, validateLazy = (e, t) => t.filter(isOutputTargetDistLazy).map((t => {
 const s = getAbsolutePath(e, t.dir || join("dist", e.fsNamespace));
 return {
  type: "dist-lazy",
  esmDir: s,
  systemDir: e.buildEs5 ? s : void 0,
  systemLoaderFile: e.buildEs5 ? join(s, `${e.fsNamespace}.js`) : void 0,
  polyfills: !!t.polyfills,
  isBrowserBuild: !0,
  empty: !isBoolean(t.empty) || t.empty
 };
})), validateStats = (e, t) => {
 const s = [];
 return e.flags.stats && (t.some(isOutputTargetStats) || s.push({
  type: "stats"
 })), s.push(...t.filter(isOutputTargetStats)), s.forEach((t => {
  t.file || (t.file = "stencil-stats.json"), path$6.isAbsolute(t.file) || (t.file = join(e.rootDir, t.file));
 })), s;
}, DEFAULT_GLOB_PATTERNS = [ "*.html", "**/*.{js,css,json}" ], validateWww = (e, t, s) => {
 const r = s.length > 0, i = !!e.flags.e2e, n = s.filter(isOutputTargetWww);
 return r && (!i || s.some(isOutputTargetWww) || s.some(isOutputTargetDist)) || n.push({
  type: "www"
 }), e.flags.prerender && 0 === n.length && (buildError(t).messageText = 'You need at least one "www" output target configured in your stencil.config.ts, when the "--prerender" flag is used'), 
 n.reduce(((s, r) => {
  const i = validateWwwOutputTarget(e, r, t);
  s.push(i);
  const n = i.buildDir;
  return s.push({
   type: "dist-lazy",
   dir: n,
   esmDir: n,
   systemDir: e.buildEs5 ? n : void 0,
   systemLoaderFile: e.buildEs5 ? join(n, `${e.fsNamespace}.js`) : void 0,
   polyfills: i.polyfills,
   isBrowserBuild: !0
  }), s.push({
   type: COPY,
   dir: n,
   copyAssets: "dist"
  }), s.push({
   type: COPY,
   dir: i.appDir,
   copy: validateCopy(i.copy, [ {
    src: "assets",
    warn: !1
   }, {
    src: "manifest.json",
    warn: !1
   } ])
  }), s.push({
   type: "dist-global-styles",
   file: join(n, `${e.fsNamespace}.css`)
  }), s;
 }), []);
}, validateWwwOutputTarget = (e, t, s) => {
 isString(t.baseUrl) || (t.baseUrl = "/"), t.baseUrl.endsWith("/") || (t.baseUrl += "/"), 
 t.dir = getAbsolutePath(e, t.dir || "www");
 const r = new URL(t.baseUrl, "http://localhost/").pathname;
 return t.appDir = join(t.dir, r), (t.appDir.endsWith("/") || t.appDir.endsWith("\\")) && (t.appDir = t.appDir.substring(0, t.appDir.length - 1)), 
 isString(t.buildDir) || (t.buildDir = "build"), path$6.isAbsolute(t.buildDir) || (t.buildDir = join(t.appDir, t.buildDir)), 
 isString(t.indexHtml) || (t.indexHtml = "index.html"), path$6.isAbsolute(t.indexHtml) || (t.indexHtml = join(t.appDir, t.indexHtml)), 
 isBoolean(t.empty) || (t.empty = !0), ((e, t, s) => {
  if (e.flags.ssr || e.flags.prerender || "prerender" === e.flags.task) {
   s.baseUrl = normalizePath(s.baseUrl), s.baseUrl.startsWith("http://") || s.baseUrl.startsWith("https://") || (buildError(t).messageText = 'When prerendering, the "baseUrl" output target config must be a full URL and start with either "http://" or "https://". The config can be updated in the "www" output target within the stencil config.');
   try {
    new URL(s.baseUrl);
   } catch (e) {
    buildError(t).messageText = `invalid "baseUrl": ${e}`;
   }
   s.baseUrl.endsWith("/") || (s.baseUrl += "/"), isString(s.prerenderConfig) && (path$6.isAbsolute(s.prerenderConfig) || (s.prerenderConfig = join(e.rootDir, s.prerenderConfig)));
  }
 })(e, s, t), ((e, t) => {
  var s, r, i, n;
  if (!1 === t.serviceWorker) return;
  if (e.devMode && !e.flags.serviceWorker) return void (t.serviceWorker = null);
  if (null === t.serviceWorker) return void (t.serviceWorker = null);
  if (!t.serviceWorker && e.devMode) return void (t.serviceWorker = null);
  const o = "string" == typeof (null === (s = t.serviceWorker) || void 0 === s ? void 0 : s.globDirectory) ? t.serviceWorker.globDirectory : t.appDir;
  t.serviceWorker = {
   ...t.serviceWorker,
   globDirectory: o,
   swDest: isString(null === (r = t.serviceWorker) || void 0 === r ? void 0 : r.swDest) ? t.serviceWorker.swDest : join(null !== (i = t.appDir) && void 0 !== i ? i : "", "sw.js")
  }, Array.isArray(t.serviceWorker.globPatterns) || ("string" == typeof t.serviceWorker.globPatterns ? t.serviceWorker.globPatterns = [ t.serviceWorker.globPatterns ] : "string" != typeof t.serviceWorker.globPatterns && (t.serviceWorker.globPatterns = DEFAULT_GLOB_PATTERNS.slice())), 
  "string" == typeof t.serviceWorker.globIgnores && (t.serviceWorker.globIgnores = [ t.serviceWorker.globIgnores ]), 
  t.serviceWorker.globIgnores = t.serviceWorker.globIgnores || [], ((e, t) => {
   t.push("**/host.config.json", "**/*.system.entry.js", "**/*.system.js", `**/${e.fsNamespace}.js`, `**/${e.fsNamespace}.esm.js`, `**/${e.fsNamespace}.css`);
  })(e, t.serviceWorker.globIgnores), t.serviceWorker.dontCacheBustURLsMatching = /p-\w{8}/, 
  isString(t.serviceWorker.swSrc) && !path$6.isAbsolute(t.serviceWorker.swSrc) && (t.serviceWorker.swSrc = join(e.rootDir, t.serviceWorker.swSrc)), 
  isString(t.serviceWorker.swDest) && !path$6.isAbsolute(t.serviceWorker.swDest) && (t.serviceWorker.swDest = join(null !== (n = t.appDir) && void 0 !== n ? n : "", t.serviceWorker.swDest));
 })(e, t), void 0 === t.polyfills && (t.polyfills = !0), t.polyfills = !!t.polyfills, 
 t;
}, validateHydrated = e => {
 var t;
 if (null === e.hydratedFlag || !1 === e.hydratedFlag) return null;
 const s = {
  ...null !== (t = e.hydratedFlag) && void 0 !== t ? t : {}
 };
 return isString(s.name) && "" !== s.property || (s.name = "hydrated"), "attribute" === s.selector ? s.selector = "attribute" : s.selector = "class", 
 isString(s.property) && "" !== s.property || (s.property = "visibility"), isString(s.initialValue) || null === s.initialValue || (s.initialValue = "hidden"), 
 isString(s.hydratedValue) || null === s.initialValue || (s.hydratedValue = "inherit"), 
 s;
}, validateNamespace = (e, t, s) => {
 const r = (e = (e = isString(e) ? e : "App").trim()).replace(/(\w)|(\-)|(\$)/g, "");
 return "" !== r && (buildError(s).messageText = `Namespace "${e}" contains invalid characters: ${r}`), 
 e.length < 3 && (buildError(s).messageText = `Namespace "${e}" must be at least 3 characters`), 
 /^\d+$/.test(e.charAt(0)) && (buildError(s).messageText = `Namespace "${e}" cannot have a number for the first character`), 
 "-" === e.charAt(0) && (buildError(s).messageText = `Namespace "${e}" cannot have a dash for the first character`), 
 "-" === e.charAt(e.length - 1) && (buildError(s).messageText = `Namespace "${e}" cannot have a dash for the last character`), 
 isString(t) || (t = e.toLowerCase().trim()), e.includes("-") && (e = e.toLowerCase().split("-").map((e => e.charAt(0).toUpperCase() + e.slice(1))).join("")), 
 {
  namespace: e,
  fsNamespace: t
 };
}, validatePaths = e => {
 const t = "string" != typeof e.rootDir ? "/" : e.rootDir;
 let s = "string" != typeof e.srcDir ? DEFAULT_SRC_DIR : e.srcDir;
 path$6.isAbsolute(s) || (s = join(t, s));
 let r = "string" != typeof e.cacheDir ? DEFAULT_CACHE_DIR : e.cacheDir;
 r = path$6.isAbsolute(r) ? normalizePath(r) : join(t, r);
 let i = "string" != typeof e.srcIndexHtml ? join(s, DEFAULT_INDEX_HTML) : e.srcIndexHtml;
 path$6.isAbsolute(i) || (i = join(t, i));
 const n = {
  rootDir: t,
  srcDir: s,
  cacheDir: r,
  srcIndexHtml: i,
  packageJsonFilePath: join(t, "package.json")
 };
 return "string" != typeof e.globalScript || path$6.isAbsolute(e.globalScript) || (n.globalScript = join(t, e.globalScript)), 
 "string" != typeof e.globalStyle || path$6.isAbsolute(e.globalStyle) || (n.globalStyle = join(t, e.globalStyle)), 
 e.writeLog && (n.buildLogFilePath = "string" == typeof e.buildLogFilePath ? e.buildLogFilePath : DEFAULT_BUILD_LOG_FILE_NAME, 
 path$6.isAbsolute(n.buildLogFilePath) || (n.buildLogFilePath = join(t, e.buildLogFilePath))), 
 n;
}, DEFAULT_BUILD_LOG_FILE_NAME = "stencil-build.log", DEFAULT_CACHE_DIR = ".stencil", DEFAULT_INDEX_HTML = "index.html", DEFAULT_SRC_DIR = "src", validateRollupConfig = e => {
 let t = {
  ...DEFAULT_ROLLUP_CONFIG
 };
 const s = e.rollupConfig;
 return s && isObject$1(s) ? (s.inputOptions && isObject$1(s.inputOptions) && (t = {
  ...t,
  inputOptions: pluck(s.inputOptions, [ "context", "moduleContext", "treeshake" ])
 }), s.outputOptions && isObject$1(s.outputOptions) && (t = {
  ...t,
  outputOptions: pluck(s.outputOptions, [ "globals" ])
 }), t) : t;
}, DEFAULT_ROLLUP_CONFIG = {
 inputOptions: {},
 outputOptions: {}
}, getPackageDirPath = (e, t) => {
 const s = normalizePath(e).split("/"), r = (e => {
  e.startsWith("~") && (e = e.substring(1));
  const t = e.split("/"), s = {
   moduleId: null,
   filePath: null,
   scope: null,
   scopeSubModuleId: null
  };
  return e.startsWith("@") && t.length > 1 ? (s.moduleId = t.slice(0, 2).join("/"), 
  s.filePath = t.slice(2).join("/"), s.scope = t[0], s.scopeSubModuleId = t[1]) : (s.moduleId = t[0], 
  s.filePath = t.slice(1).join("/")), s;
 })(t);
 for (let e = s.length - 1; e >= 1; e--) if ("node_modules" === s[e - 1]) if (r.scope) {
  if (s[e] === r.scope && s[e + 1] === r.scopeSubModuleId) return s.slice(0, e + 2).join("/");
 } else if (s[e] === r.moduleId) return s.slice(0, e + 1).join("/");
 return null;
}, addTestingConfigOption = (e, t) => {
 e.includes(t) || e.push(t);
}, DEFAULT_IGNORE_PATTERNS = [ ".vscode", ".stencil", "node_modules" ];

let CACHED_VALIDATED_CONFIG = null;

const validateConfig = (e = {}, t) => {
 var s, r, i, n, o, a, l, c, u, h, p, d, f;
 const m = [];
 if (null !== CACHED_VALIDATED_CONFIG && CACHED_VALIDATED_CONFIG === e) return {
  config: e,
  diagnostics: m
 };
 const g = Object.assign({}, e), y = t.logger || g.logger || createNodeLogger(), v = JSON.parse(JSON.stringify(g.flags || {}));
 let w = "info";
 v.debug || v.verbose ? w = "debug" : v.logLevel && (w = v.logLevel), y.setLevel(w);
 let b = null !== (s = g.devMode) && void 0 !== s && s;
 v.prod ? b = !1 : v.dev ? b = !0 : isBoolean(g.devMode) || (b = !1);
 const E = null !== (r = g.hashFileNames) && void 0 !== r ? r : !b, _ = {
  devServer: {},
  ...g,
  buildEs5: !0 === g.buildEs5 || !b && "prod" === g.buildEs5,
  devMode: b,
  extras: g.extras || {},
  flags: v,
  hashFileNames: E,
  hashedFileNameLength: null !== (i = g.hashedFileNameLength) && void 0 !== i ? i : 8,
  hydratedFlag: validateHydrated(g),
  logLevel: w,
  logger: y,
  minifyCss: null !== (n = g.minifyCss) && void 0 !== n ? n : !b,
  minifyJs: null !== (o = g.minifyJs) && void 0 !== o ? o : !b,
  outputTargets: null !== (a = g.outputTargets) && void 0 !== a ? a : [],
  rollupConfig: validateRollupConfig(g),
  sys: null !== (c = null !== (l = g.sys) && void 0 !== l ? l : t.sys) && void 0 !== c ? c : createNodeSys({
   logger: y
  }),
  testing: null !== (u = g.testing) && void 0 !== u ? u : {},
  transformAliasedImportPaths: !isBoolean(e.transformAliasedImportPaths) || e.transformAliasedImportPaths,
  validatePrimaryPackageOutputTarget: null !== (h = e.validatePrimaryPackageOutputTarget) && void 0 !== h && h,
  ...validateNamespace(g.namespace, g.fsNamespace, m),
  ...validatePaths(g)
 };
 if (_.extras.lifecycleDOMEvents = !!_.extras.lifecycleDOMEvents, _.extras.scriptDataOpts = !!_.extras.scriptDataOpts, 
 _.extras.initializeNextTick = !!_.extras.initializeNextTick, _.extras.tagNameTransform = !!_.extras.tagNameTransform, 
 !0 === _.extras.experimentalSlotFixes) {
  const e = [ "appendChildSlotFix", "slotChildNodesFix", "cloneNodeFix", "scopedSlotTextContentFix" ].filter((e => !1 === _.extras[e]));
  if (e.length > 0) {
   const t = buildError(m);
   t.level = "warn", t.messageText = `If the 'experimentalSlotFixes' flag is enabled it will override any slot fix flags which are disabled. In particular, the following currently-disabled flags will be ignored: ${e.join(", ")}. Please update your Stencil config accordingly.`;
  }
 }
 return _.extras.experimentalSlotFixes = !!_.extras.experimentalSlotFixes, !0 === _.extras.experimentalSlotFixes ? (_.extras.appendChildSlotFix = !0, 
 _.extras.cloneNodeFix = !0, _.extras.slotChildNodesFix = !0, _.extras.scopedSlotTextContentFix = !0) : (_.extras.appendChildSlotFix = !!_.extras.appendChildSlotFix, 
 _.extras.cloneNodeFix = !!_.extras.cloneNodeFix, _.extras.slotChildNodesFix = !!_.extras.slotChildNodesFix, 
 _.extras.scopedSlotTextContentFix = !!_.extras.scopedSlotTextContentFix), _.extras.experimentalScopedSlotChanges = !!_.extras.experimentalScopedSlotChanges, 
 setBooleanConfig(_, "sourceMap", null, void 0 === _.sourceMap || _.sourceMap), setBooleanConfig(_, "watch", "watch", !1), 
 setBooleanConfig(_, "buildDocs", "docs", !_.devMode), setBooleanConfig(_, "buildDist", "esm", !_.devMode || !!_.buildEs5), 
 setBooleanConfig(_, "profile", "profile", _.devMode), setBooleanConfig(_, "writeLog", "log", !1), 
 setBooleanConfig(_, "buildAppCore", null, !0), setBooleanConfig(_, "autoprefixCss", null, _.buildEs5), 
 setBooleanConfig(_, "validateTypes", null, !_._isTesting), setBooleanConfig(_, "allowInlineScripts", null, !0), 
 isString(_.taskQueue) || (_.taskQueue = "async"), isBoolean(_.hashFileNames) || (_.hashFileNames = !_.devMode), 
 isNumber(_.hashedFileNameLength) || (_.hashedFileNameLength = 8), _.hashedFileNameLength < 4 && (buildError(m).messageText = "validatedConfig.hashedFileNameLength must be at least 4 characters"), 
 _.hashedFileNameLength > 32 && (buildError(m).messageText = "validatedConfig.hashedFileNameLength cannot be more than 32 characters"), 
 _.env || (_.env = {}), ((e, t) => {
  const s = (e.outputTargets || []).slice();
  s.forEach((e => {
   (function s(e) {
    return VALID_CONFIG_OUTPUT_TARGETS.includes(e);
   })(e.type) || (buildError(t).messageText = `Invalid outputTarget type "${e.type}". Valid outputTarget types include: ${VALID_CONFIG_OUTPUT_TARGETS.map((e => `"${e}"`)).join(", ")}`);
  })), e.outputTargets = [ ...validateCollection(e, s), ...validateCustomElement(e, s), ...validateCustomOutput(e, t, s), ...validateLazy(e, s), ...validateWww(e, t, s), ...validateDist(e, s), ...validateDocs(e, t, s), ...validateStats(e, s) ], 
  e.outputTargets = [ ...e.outputTargets, ...validateHydrateScript(e, [ ...s, ...e.outputTargets ]) ];
 })(_, m), ((e, t) => {
  const s = e.plugins;
  if (e.rollupPlugins || (e.rollupPlugins = {}), !Array.isArray(s)) return void (e.plugins = []);
  const r = s.filter((e => !(!e || "object" != typeof e || e.pluginType))), i = r.some((e => "node-resolve" === e.name));
  r.some((e => "commonjs" === e.name)) && (buildWarn(t).messageText = 'Stencil already uses "@rollup/plugin-commonjs", please remove it from your "stencil.config.ts" plugins.\n    You can configure the commonjs settings using the "commonjs" property in "stencil.config.ts'), 
  i && (buildWarn(t).messageText = 'Stencil already uses "@rollup/plugin-commonjs", please remove it from your "stencil.config.ts" plugins.\n    You can configure the commonjs settings using the "commonjs" property in "stencil.config.ts'), 
  e.rollupPlugins.before = [ ...e.rollupPlugins.before || [], ...r.filter((({name: e}) => "node-resolve" !== e && "commonjs" !== e)) ], 
  e.plugins = s.filter((e => !(!e || "object" != typeof e || !e.pluginType)));
 })(_, m), _.devServer = ((e, t) => {
  var s, r, i, n, o;
  if (!1 === (null === e.devServer || e.devServer)) return {};
  const {flags: a} = e, l = {
   ...e.devServer
  };
  a.address && isString(a.address) ? l.address = a.address : isString(l.address) || (l.address = "0.0.0.0");
  let c = "http";
  if (l.address.toLowerCase().startsWith("http://") ? (l.address = l.address.substring(7), 
  c = "http") : l.address.toLowerCase().startsWith("https://") && (l.address = l.address.substring(8), 
  c = "https"), l.address = l.address.split("/")[0], null !== l.pingRoute) {
   let e = isString(l.pingRoute) ? l.pingRoute : "/ping";
   e.startsWith("/") || (e = `/${e}`), l.pingRoute = e;
  }
  const u = l.address.split(":");
  let h, p, d = "localhost" !== u[0] && isNaN(u[0].split(".")[0]) ? void 0 : 3333;
  if (u.length > 1 && (isNaN(u[1]) || (l.address = u[0], d = parseInt(u[1], 10))), 
  isNumber(a.port) ? l.port = a.port : null === l.port || isNumber(l.port) || isNumber(d) && (l.port = d), 
  void 0 === l.reloadStrategy ? l.reloadStrategy = "hmr" : "hmr" !== l.reloadStrategy && "pageReload" !== l.reloadStrategy && null !== l.reloadStrategy && (buildError(t).messageText = `Invalid devServer reloadStrategy "${l.reloadStrategy}". Valid configs include "hmr", "pageReload" and null.`), 
  isBoolean(l.gzip) || (l.gzip = !0), isBoolean(l.openBrowser) || (l.openBrowser = !0), 
  isBoolean(l.websocket) || (l.websocket = !0), a.ssr ? l.ssr = !0 : l.ssr = !!l.ssr, 
  l.ssr) {
   const t = (null !== (s = e.outputTargets) && void 0 !== s ? s : []).find(isOutputTargetWww);
   l.prerenderConfig = null == t ? void 0 : t.prerenderConfig;
  }
  isString(e.srcIndexHtml) && (l.srcIndexHtml = normalizePath(e.srcIndexHtml)), "http" !== l.protocol && "https" !== l.protocol && (l.protocol = l.https ? "https" : c || "http"), 
  null !== l.historyApiFallback && ((Array.isArray(l.historyApiFallback) || "object" != typeof l.historyApiFallback) && (l.historyApiFallback = {}), 
  isString(l.historyApiFallback.index) || (l.historyApiFallback.index = "index.html"), 
  isBoolean(l.historyApiFallback.disableDotRule) || (l.historyApiFallback.disableDotRule = !1)), 
  (!1 === a.open || a.prerender && !e.watch) && (l.openBrowser = !1);
  const f = (null !== (r = e.outputTargets) && void 0 !== r ? r : []).find(isOutputTargetWww);
  return f ? (p = new URL(null !== (i = f.baseUrl) && void 0 !== i ? i : "", "http://config.stenciljs.com").pathname, 
  h = null !== (n = f.appDir) && void 0 !== n ? n : "") : (p = "", h = null !== (o = e.rootDir) && void 0 !== o ? o : ""), 
  isString(p) && "" !== p.trim() || (p = "/"), p = normalizePath(p), p.startsWith("/") || (p = "/" + p), 
  p.endsWith("/") || (p += "/"), isBoolean(l.logRequests) || (l.logRequests = "debug" === e.logLevel), 
  isString(l.root) || (l.root = h), isString(l.basePath) || (l.basePath = p), isString(l.baseUrl) && (buildError(t).messageText = 'devServer config "baseUrl" has been renamed to "basePath", and should not include a domain or protocol.'), 
  path$6.isAbsolute(l.root) || (l.root = join(e.rootDir, l.root)), l.root = normalizePath(l.root), 
  l.excludeHmr ? Array.isArray(l.excludeHmr) || (buildError(t).messageText = "dev server excludeHmr must be an array of glob strings") : l.excludeHmr = [], 
  !e.devMode || e.buildEs5 ? l.experimentalDevModules = !1 : l.experimentalDevModules = !!l.experimentalDevModules, 
  l;
 })(_, m), ((e, t) => {
  var s, r;
  const i = e.testing = Object.assign({}, e.testing || {});
  if (!e.flags.e2e && !e.flags.spec) return;
  let n = e.configPath;
  isString(n) ? path$6.basename(n).includes(".") && (n = path$6.dirname(n)) : n = e.rootDir, 
  "boolean" == typeof e.flags.headless || "new" === e.flags.headless ? i.browserHeadless = e.flags.headless : "boolean" != typeof i.browserHeadless && "new" !== i.browserHeadless && (i.browserHeadless = !0), 
  i.browserWaitUntil || (i.browserWaitUntil = "load"), i.browserArgs = i.browserArgs || [], 
  addTestingConfigOption(i.browserArgs, "--font-render-hinting=medium"), addTestingConfigOption(i.browserArgs, "--incognito"), 
  e.flags.ci ? (addTestingConfigOption(i.browserArgs, "--no-sandbox"), addTestingConfigOption(i.browserArgs, "--disable-setuid-sandbox"), 
  addTestingConfigOption(i.browserArgs, "--disable-dev-shm-usage"), i.browserHeadless = "new" !== i.browserHeadless || "new") : (e.flags.devtools || i.browserDevtools) && (i.browserDevtools = !0, 
  i.browserHeadless = !1), "string" == typeof i.rootDir ? path$6.isAbsolute(i.rootDir) || (i.rootDir = join(e.rootDir, i.rootDir)) : i.rootDir = e.rootDir, 
  "string" == typeof e.flags.screenshotConnector && (i.screenshotConnector = e.flags.screenshotConnector), 
  "string" == typeof i.screenshotConnector ? path$6.isAbsolute(i.screenshotConnector) ? i.screenshotConnector = normalizePath(i.screenshotConnector) : i.screenshotConnector = join(e.rootDir, i.screenshotConnector) : i.screenshotConnector = join(e.sys.getCompilerExecutingPath(), "..", "..", "screenshot", "local-connector.js"), 
  Array.isArray(i.testPathIgnorePatterns) || (i.testPathIgnorePatterns = DEFAULT_IGNORE_PATTERNS.map((e => join(i.rootDir, e))), 
  (null !== (s = e.outputTargets) && void 0 !== s ? s : []).filter((e => (isOutputTargetDist(e) || isOutputTargetWww(e)) && !!e.dir)).forEach((e => {
   var t;
   null === (t = i.testPathIgnorePatterns) || void 0 === t || t.push(e.dir);
  }))), "string" != typeof i.preset ? i.preset = join(e.sys.getCompilerExecutingPath(), "..", "..", "testing") : path$6.isAbsolute(i.preset) || (i.preset = join(n, i.preset)), 
  Array.isArray(i.setupFilesAfterEnv) || (i.setupFilesAfterEnv = []), i.setupFilesAfterEnv.unshift(join(e.sys.getCompilerExecutingPath(), "..", "..", "testing", "jest-setuptestframework.js")), 
  isString(i.testEnvironment) && !path$6.isAbsolute(i.testEnvironment) && ((r = i.testEnvironment).startsWith(".") || r.startsWith("/")) && (i.testEnvironment = join(n, i.testEnvironment)), 
  "number" == typeof i.allowableMismatchedPixels ? i.allowableMismatchedPixels < 0 && (buildError(t).messageText = "allowableMismatchedPixels must be a value that is 0 or greater") : i.allowableMismatchedPixels = 100, 
  "number" == typeof i.allowableMismatchedRatio && (i.allowableMismatchedRatio < 0 || i.allowableMismatchedRatio > 1) && (buildError(t).messageText = "allowableMismatchedRatio must be a value ranging from 0 to 1"), 
  "number" == typeof i.pixelmatchThreshold ? (i.pixelmatchThreshold < 0 || i.pixelmatchThreshold > 1) && (buildError(t).messageText = "pixelmatchThreshold must be a value ranging from 0 to 1") : i.pixelmatchThreshold = .1, 
  void 0 === i.testRegex && (i.testRegex = "(/__tests__/.*|(\\.|/)(test|spec|e2e))\\.[jt]sx?$"), 
  Array.isArray(i.testMatch) ? delete i.testRegex : "string" == typeof i.testRegex && delete i.testMatch, 
  "string" != typeof i.runner && (i.runner = join(e.sys.getCompilerExecutingPath(), "..", "..", "testing", "jest-runner.js")), 
  "number" == typeof i.waitBeforeScreenshot ? i.waitBeforeScreenshot < 0 && (buildError(t).messageText = "waitBeforeScreenshot must be a value that is 0 or greater") : i.waitBeforeScreenshot = 10, 
  Array.isArray(i.emulate) && 0 !== i.emulate.length || (i.emulate = [ {
   userAgent: "default",
   viewport: {
    width: 600,
    height: 600,
    deviceScaleFactor: 1,
    isMobile: !1,
    hasTouch: !1,
    isLandscape: !1
   }
  } ]);
 })(_, m), Array.isArray(_.bundles) ? _.bundles = (d = _.bundles, f = e => e.components.length, 
 d.slice().sort(((e, t) => {
  const s = f(e), r = f(t);
  return s < r ? -1 : s > r ? 1 : 0;
 }))) : _.bundles = [], (e => {
  "number" != typeof e.maxConcurrentWorkers && (e.maxConcurrentWorkers = 8), "number" == typeof e.flags.maxWorkers ? e.maxConcurrentWorkers = e.flags.maxWorkers : e.flags.ci && (e.maxConcurrentWorkers = 4), 
  e.maxConcurrentWorkers = Math.max(Math.min(e.maxConcurrentWorkers, 16), 0), e.devServer && (e.devServer.worker = e.maxConcurrentWorkers > 0);
 })(_), setBooleanConfig(_, "devInspector", null, _.devMode), _._isTesting || ((e, t) => {
  var s;
  !(null !== (s = e.outputTargets) && void 0 !== s ? s : []).some(isOutputTargetDist) || isString(e.namespace) && "app" !== e.namespace.toLowerCase() || (buildError(t).messageText = 'When generating a distribution it is recommended to choose a unique namespace rather than the default setting "App". Please updated the "namespace" config property within the stencil config.');
 })(_, m), setBooleanConfig(_, "enableCache", "cache", !0), Array.isArray(_.watchIgnoredRegex) || null == _.watchIgnoredRegex || (_.watchIgnoredRegex = [ _.watchIgnoredRegex ]), 
 _.watchIgnoredRegex = (_.watchIgnoredRegex || []).reduce(((e, t) => (t instanceof RegExp && e.push(t), 
 e)), []), (null === (p = _.nodeResolve) || void 0 === p ? void 0 : p.customResolveOptions) && (buildWarn(m).messageText = "nodeResolve.customResolveOptions is a deprecated option in a Stencil Configuration file. If you need this option, please open a new issue in the Stencil repository (https://github.com/ionic-team/stencil/issues/new/choose)"), 
 CACHED_VALIDATED_CONFIG = _, {
  config: _,
  diagnostics: m
 };
};

class BuildContext {
 constructor(e, t) {
  this.buildId = -1, this.buildMessages = [], this.buildResults = null, this.bundleBuildCount = 0, 
  this.collections = [], this.completedTasks = [], this.components = [], this.componentGraph = new Map, 
  this.data = {}, this.buildStats = void 0, this.diagnostics = [], this.dirsAdded = [], 
  this.dirsDeleted = [], this.entryModules = [], this.filesAdded = [], this.filesChanged = [], 
  this.filesDeleted = [], this.filesUpdated = [], this.filesWritten = [], this.globalStyle = void 0, 
  this.hasConfigChanges = !1, this.hasFinished = !1, this.hasHtmlChanges = !1, this.hasPrintedResults = !1, 
  this.hasServiceWorkerChanges = !1, this.hasScriptChanges = !0, this.hasStyleChanges = !0, 
  this.hydrateAppFilePath = null, this.indexBuildCount = 0, this.indexDoc = void 0, 
  this.isRebuild = !1, this.moduleFiles = [], this.outputs = [], this.packageJson = {}, 
  this.packageJsonFilePath = null, this.pendingCopyTasks = [], this.requiresFullBuild = !0, 
  this.scriptsAdded = [], this.scriptsDeleted = [], this.startTime = Date.now(), this.styleBuildCount = 0, 
  this.stylesPromise = null, this.stylesUpdated = [], this.timeSpan = null, this.transpileBuildCount = 0, 
  this.config = validateConfig(e, {}).config, this.compilerCtx = t, this.buildId = ++this.compilerCtx.activeBuildId, 
  this.debug = e.logger.debug.bind(e.logger);
 }
 start() {
  const e = `${this.isRebuild ? "rebuild" : "build"}, ${this.config.fsNamespace}, ${this.config.devMode ? "dev" : "prod"} mode, started`, t = {
   buildId: this.buildId,
   messages: [],
   progress: 0
  };
  this.compilerCtx.events.emit("buildLog", t), this.timeSpan = this.createTimeSpan(e), 
  this.timestamp = getBuildTimestamp(), this.debug(`start build, ${this.timestamp}`);
  const s = {
   buildId: this.buildId,
   timestamp: this.timestamp
  };
  this.compilerCtx.events.emit("buildStart", s);
 }
 createTimeSpan(e, t) {
  if (!this.hasFinished || t) {
   t && this.config.watch && (e = `${this.config.logger.cyan("[" + this.buildId + "]")} ${e}`);
   const s = this.config.logger.createTimeSpan(e, t, this.buildMessages);
   if (!t && this.compilerCtx.events) {
    const e = {
     buildId: this.buildId,
     messages: this.buildMessages,
     progress: getProgress(this.completedTasks)
    };
    this.compilerCtx.events.emit("buildLog", e);
   }
   return {
    duration: () => s.duration(),
    finish: (e, r, i, n) => {
     if ((!this.hasFinished || t) && (t && this.config.watch && (e = `${this.config.logger.cyan("[" + this.buildId + "]")} ${e}`), 
     s.finish(e, r, i, n), !t)) {
      const e = {
       buildId: this.buildId,
       messages: this.buildMessages.slice(),
       progress: getProgress(this.completedTasks)
      };
      this.compilerCtx.events.emit("buildLog", e);
     }
     return s.duration();
    }
   };
  }
  return {
   duration: () => 0,
   finish: () => 0
  };
 }
 debug(e) {
  this.config.logger.debug(e);
 }
 get hasError() {
  return hasError(this.diagnostics);
 }
 get hasWarning() {
  return null != (e = this.diagnostics) && 0 !== e.length && e.some((e => "warn" === e.level));
  var e;
 }
 progress(e) {
  this.completedTasks.push(e);
 }
 async validateTypesBuild() {
  this.hasError || this.validateTypesPromise && (this.config.watch || (this.debug("build, non-watch, waiting on validateTypes"), 
  await this.validateTypesPromise, this.debug("build, non-watch, finished waiting on validateTypes")));
 }
}

const getBuildTimestamp = () => {
 const e = new Date;
 let t = e.getUTCFullYear() + "-";
 return t += ("0" + (e.getUTCMonth() + 1)).slice(-2) + "-", t += ("0" + e.getUTCDate()).slice(-2) + "T", 
 t += ("0" + e.getUTCHours()).slice(-2) + ":", t += ("0" + e.getUTCMinutes()).slice(-2) + ":", 
 t += ("0" + e.getUTCSeconds()).slice(-2), t;
}, getProgress = e => {
 let t = 0;
 const s = Object.keys(ProgressTask);
 return s.forEach(((s, r) => {
  e.includes(ProgressTask[s]) && (t = r);
 })), (t + 1) / s.length;
}, ProgressTask = {
 emptyOutputTargets: {},
 transpileApp: {},
 generateStyles: {},
 generateOutputTargets: {},
 validateTypesBuild: {},
 writeBuildFiles: {}
};

class Cache {
 constructor(e, t) {
  this.config = e, this.cacheFs = t, this.failed = 0, this.skip = !1, this.sys = e.sys, 
  this.logger = e.logger;
 }
 async initCacheDir() {
  if (!this.config._isTesting && this.config.cacheDir) {
   if (this.buildCacheDir = join(this.config.cacheDir, ".build"), !this.config.enableCache || !this.cacheFs) return this.config.logger.info("cache optimizations disabled"), 
   void this.clearDiskCache();
   this.config.logger.debug(`cache enabled, cacheDir: ${this.buildCacheDir}`);
   try {
    const e = join(this.buildCacheDir, "_README.log");
    await this.cacheFs.writeFile(e, CACHE_DIR_README);
   } catch (e) {
    this.logger.error(`Cache, initCacheDir: ${e}`), this.config.enableCache = !1;
   }
  }
 }
 async get(e) {
  if (!this.config.enableCache || this.skip) return null;
  if (this.failed >= MAX_FAILED) return this.skip || (this.skip = !0, this.logger.debug(`cache had ${this.failed} failed ops, skip disk ops for remainder of build`)), 
  null;
  let t;
  try {
   t = await this.cacheFs.readFile(this.getCacheFilePath(e)), this.failed = 0, this.skip = !1;
  } catch (e) {
   this.failed++, t = null;
  }
  return t;
 }
 async put(e, t) {
  if (!this.config.enableCache) return !1;
  try {
   return await this.cacheFs.writeFile(this.getCacheFilePath(e), t), !0;
  } catch (e) {
   return this.failed++, !1;
  }
 }
 async has(e) {
  return "string" == typeof await this.get(e);
 }
 async createKey(e, ...t) {
  return this.config.enableCache && this.sys.generateContentHash ? e + "_" + await this.sys.generateContentHash(JSON.stringify(t), 32) : e + 9999999 * Math.random();
 }
 async commit() {
  this.config.enableCache && (this.skip = !1, this.failed = 0, await this.cacheFs.commit(), 
  await this.clearExpiredCache());
 }
 clear() {
  null != this.cacheFs && this.cacheFs.clearCache();
 }
 async clearExpiredCache() {
  if (null == this.cacheFs || null == this.sys.cacheStorage) return;
  const e = Date.now(), t = await this.sys.cacheStorage.get(EXP_STORAGE_KEY);
  if (null != t) {
   if (e - t < ONE_DAY) return;
   const s = this.cacheFs.sys, r = await s.readDir(this.buildCacheDir), i = r.map((e => join(this.buildCacheDir, e)));
   let n = 0;
   const o = i.map((async t => {
    const r = (await s.stat(t)).mtimeMs;
    r && e - r > ONE_WEEK && (await s.removeFile(t), n++);
   }));
   await Promise.all(o), this.logger.debug(`clearExpiredCache, cachedFileNames: ${r.length}, totalCleared: ${n}`);
  }
  this.logger.debug("clearExpiredCache, set last clear"), await this.sys.cacheStorage.set(EXP_STORAGE_KEY, e);
 }
 async clearDiskCache() {
  null != this.cacheFs && await this.cacheFs.access(this.buildCacheDir) && (await this.cacheFs.remove(this.buildCacheDir), 
  await this.cacheFs.commit());
 }
 getCacheFilePath(e) {
  return join(this.buildCacheDir, e) + ".log";
 }
 getMemoryStats() {
  return null != this.cacheFs ? this.cacheFs.getMemoryStats() : null;
 }
}

const MAX_FAILED = 100, ONE_DAY = 864e5, ONE_WEEK = 7 * ONE_DAY, EXP_STORAGE_KEY = "last_clear_expired_cache", CACHE_DIR_README = '# Stencil Cache Directory\n\nThis directory contains files which the compiler has\ncached for faster builds. To disable caching, please set\n"enableCache: false" within the stencil config.\n\nTo change the cache directory, please update the\n"cacheDir" property within the stencil config.\n', createInMemoryFs = e => {
 const t = new Map, s = new Map, r = async (e, s = {}) => {
  e = normalizePath(e);
  const r = [];
  if (!0 === s.inMemoryOnly) {
   let i = e;
   i.endsWith("/") || (i += "/");
   const o = e.split("/");
   t.forEach(((t, i) => {
    if (!i.startsWith(e)) return;
    const a = i.split("/");
    if ((a.length === o.length + 1 || s.recursive && a.length > o.length) && t.exists) {
     const e = {
      absPath: i,
      relPath: a[o.length],
      isDirectory: t.isDirectory,
      isFile: t.isFile
     };
     n(s, e) || r.push(e);
    }
   }));
  } else await i(e, e, s, r);
  return r.sort(((e, t) => e.absPath < t.absPath ? -1 : e.absPath > t.absPath ? 1 : 0));
 }, i = async (t, s, r, o) => {
  const l = await e.readDir(s);
  if (l.length > 0) {
   const e = m(s);
   e.exists = !0, e.isFile = !1, e.isDirectory = !0, await Promise.all(l.map((async e => {
    const s = normalizePath(e), l = normalizePath(relative(t, s)), c = await a(s), u = {
     absPath: s,
     relPath: l,
     isDirectory: c.isDirectory,
     isFile: c.isFile
    };
    n(r, u) || (o.push(u), !0 === r.recursive && !0 === c.isDirectory && await i(t, s, r, o));
   })));
  }
 }, n = (e, t) => {
  if (t.isDirectory) {
   if (Array.isArray(e.excludeDirNames)) {
    const s = path$6.basename(t.absPath);
    if (e.excludeDirNames.some((e => s === e))) return !0;
   }
  } else if (Array.isArray(e.excludeExtensions)) {
   const s = t.relPath.toLowerCase();
   if (e.excludeExtensions.some((e => s.endsWith(e)))) return !0;
  }
  return !1;
 }, o = async e => {
  const t = m(e);
  t.queueWriteToDisk || (t.queueDeleteFromDisk = !0);
 }, a = async t => {
  const s = m(t);
  if ("boolean" != typeof s.isDirectory || "boolean" != typeof s.isFile) {
   const r = await e.stat(t);
   r.error ? s.exists = !1 : (s.exists = !0, r.isFile ? (s.isFile = !0, s.isDirectory = !1, 
   s.size = r.size) : r.isDirectory ? (s.isFile = !1, s.isDirectory = !0, s.size = r.size) : (s.isFile = !1, 
   s.isDirectory = !1, s.size = null));
  }
  return {
   exists: !!s.exists,
   isFile: !!s.isFile,
   isDirectory: !!s.isDirectory,
   size: "number" == typeof s.size ? s.size : 0
  };
 }, l = t => {
  const s = m(t);
  if ("boolean" != typeof s.isDirectory || "boolean" != typeof s.isFile) {
   const r = e.statSync(t);
   r.error ? s.exists = !1 : (s.exists = !0, r.isFile ? (s.isFile = !0, s.isDirectory = !1, 
   s.size = r.size) : r.isDirectory ? (s.isFile = !1, s.isDirectory = !0, s.size = r.size) : (s.isFile = !1, 
   s.isDirectory = !1, s.size = null));
  }
  return {
   exists: !!s.exists,
   isFile: !!s.isFile,
   isDirectory: !!s.isDirectory,
   size: s.size
  };
 }, c = async (t, r, i) => {
  if ("string" != typeof t) throw new Error(`writeFile, invalid filePath: ${t}`);
  if ("string" != typeof r) throw new Error(`writeFile, invalid content: ${t}`);
  const n = {
   ignored: !1,
   changedContent: !1,
   queuedWrite: !1
  };
  if (!0 === shouldIgnore(t)) return n.ignored = !0, n;
  const o = m(t);
  if (o.exists = !0, o.isFile = !0, o.isDirectory = !1, o.queueDeleteFromDisk = !1, 
  "string" == typeof o.fileText ? n.changedContent = o.fileText.replace(/\r/g, "") !== r.replace(/\r/g, "") : n.changedContent = !0, 
  o.fileText = r, n.queuedWrite = !1, null != i && ("string" == typeof i.outputTargetType && s.set(t, i.outputTargetType), 
  !1 === i.useCache && (o.useCache = !1)), null != i && !0 === i.inMemoryOnly) o.queueWriteToDisk ? n.queuedWrite = !0 : o.queueWriteToDisk = !1, 
  await u(t, !0); else if (null != i && !0 === i.immediateWrite) {
   if (n.changedContent || !0 !== i.useCache) {
    const s = await e.readFile(t);
    if ("string" == typeof s && (n.changedContent = o.fileText.replace(/\r/g, "") !== s.replace(/\r/g, "")), 
    n.changedContent) {
     await u(t, !1);
     const {error: s} = await e.writeFile(t, o.fileText);
     if (s) throw s;
    }
   }
  } else o.queueWriteToDisk || !0 !== n.changedContent || (o.queueWriteToDisk = !0, 
  n.queuedWrite = !0);
  return n;
 }, u = async (t, s) => {
  if (!s) return void await e.createDir(path$6.dirname(t), {
   recursive: !0
  });
  const r = [];
  for (;"string" == typeof (t = path$6.dirname(t)) && t.length > 0 && "/" !== t && !1 === t.endsWith(":/") && !1 === t.endsWith(":\\"); ) r.push(t);
  r.reverse(), await h(r, s);
 }, h = async (t, s) => {
  const r = [];
  for (const i of t) {
   const t = m(i);
   if (!0 !== t.exists || !0 !== t.isDirectory) try {
    t.exists = !0, t.isDirectory = !0, t.isFile = !1, s || await e.createDir(i), r.push(i);
   } catch (e) {}
  }
  return r;
 }, p = async t => {
  const s = m(t);
  if (null == s.fileText) throw new Error(`unable to find item fileText to write: ${t}`);
  return await e.writeFile(t, s.fileText), !1 === s.useCache && f(t), t;
 }, d = e => {
  e = normalizePath(e), t.forEach(((t, s) => {
   const r = relative(e, s).split("/")[0];
   r.startsWith(".") || r.startsWith("/") || f(s);
  }));
 }, f = e => {
  e = normalizePath(e);
  const s = t.get(e);
  null == s || s.queueWriteToDisk || t.delete(e);
 }, m = e => {
  e = normalizePath(e);
  let s = t.get(e);
  return null != s || t.set(e, s = {
   exists: null,
   fileText: null,
   size: null,
   mtimeMs: null,
   isDirectory: null,
   isFile: null,
   queueCopyFileToDest: null,
   queueDeleteFromDisk: null,
   queueWriteToDisk: null,
   useCache: null
  }), s;
 }, g = 5242880;
 return {
  access: async e => {
   const t = m(e);
   return "boolean" != typeof t.exists ? (await a(e)).exists : t.exists;
  },
  accessSync: e => {
   const t = m(e);
   return "boolean" != typeof t.exists ? l(e).exists : t.exists;
  },
  cancelDeleteDirectoriesFromDisk: e => {
   for (const t of e) {
    const e = m(t);
    !0 === e.queueDeleteFromDisk && (e.queueDeleteFromDisk = !1);
   }
  },
  cancelDeleteFilesFromDisk: e => {
   for (const t of e) {
    const e = m(t);
    !0 === e.isFile && !0 === e.queueDeleteFromDisk && (e.queueDeleteFromDisk = !1);
   }
  },
  clearCache: () => {
   t.clear();
  },
  clearDirCache: d,
  clearFileCache: f,
  commit: async () => {
   const s = getCommitInstructions(t), r = await h(s.dirsToEnsure, !1), i = await (l = s.filesToWrite, 
   Promise.all(l.map((async e => {
    if ("string" != typeof e) throw new Error("unable to writeFile without filePath");
    return p(e);
   })))), n = await (t => {
    const s = Promise.all(t.map((async t => {
     const [s, r] = t;
     return await e.copyFile(s, r), [ s, r ];
    })));
    return s;
   })(s.filesToCopy), o = await (async t => await Promise.all(t.map((async t => {
    if ("string" != typeof t) throw new Error("unable to unlink without filePath");
    return await e.removeFile(t), t;
   }))))(s.filesToDelete), a = await (async t => {
    const s = [];
    for (const r of t) await e.removeDir(r), s.push(r);
    return s;
   })(s.dirsToDelete);
   var l;
   return s.filesToDelete.forEach(f), s.dirsToDelete.forEach(d), {
    filesCopied: n,
    filesWritten: i,
    filesDeleted: o,
    dirsDeleted: a,
    dirsAdded: r
   };
  },
  copyFile: async (e, t) => {
   m(e).queueCopyFileToDest = t;
  },
  emptyDirs: async e => {
   e = e.filter(isString).map((e => normalizePath(e))).reduce(((e, t) => (e.includes(t) || e.push(t), 
   e)), []);
   const t = await Promise.all(e.map((e => r(e, {
    recursive: !0
   })))), s = [];
   for (const e of t) for (const t of e) s.includes(t.absPath) || s.push(t.absPath);
   s.sort(((e, t) => {
    const s = e.split("/").length, r = t.split("/").length;
    return s < r ? 1 : s > r ? -1 : 0;
   })), await Promise.all(s.map(o)), e.forEach((e => {
    const t = m(e);
    t.isFile = !1, t.isDirectory = !0, t.queueWriteToDisk = !0, t.queueDeleteFromDisk = !1;
   }));
  },
  getBuildOutputs: () => {
   const e = [];
   return s.forEach(((t, s) => {
    const r = e.find((e => e.type === t));
    r ? r.files.push(s) : e.push({
     type: t,
     files: [ s ]
    });
   })), e.forEach((e => e.files.sort())), e.sort(((e, t) => e.type < t.type ? -1 : e.type > t.type ? 1 : 0));
  },
  getItem: m,
  getMemoryStats: () => `data length: ${t.size}`,
  readFile: async (t, s) => {
   if (null == s || !0 === s.useCache || void 0 === s.useCache) {
    const e = m(t);
    if (e.exists && "string" == typeof e.fileText) return e.fileText;
   }
   const r = await e.readFile(t), i = m(t);
   return "string" == typeof r ? r.length < g && (i.exists = !0, i.isFile = !0, i.isDirectory = !1, 
   i.fileText = r) : i.exists = !1, r;
  },
  readFileSync: (t, s) => {
   if (null == s || !0 === s.useCache || void 0 === s.useCache) {
    const e = m(t);
    if (e.exists && "string" == typeof e.fileText) return e.fileText;
   }
   const r = e.readFileSync(t), i = m(t);
   return "string" == typeof r ? r.length < g && (i.exists = !0, i.isFile = !0, i.isDirectory = !1, 
   i.fileText = r) : i.exists = !1, r;
  },
  readdir: r,
  remove: async e => {
   const t = await a(e);
   !0 === t.isDirectory ? await (async e => {
    const t = m(e);
    t.isFile = !1, t.isDirectory = !0, t.queueWriteToDisk || (t.queueDeleteFromDisk = !0);
    try {
     const t = await r(e, {
      recursive: !0
     });
     await Promise.all(t.map((e => e.relPath.endsWith(".gitkeep") ? null : o(e.absPath))));
    } catch (e) {}
   })(e) : !0 === t.isFile && await o(e);
  },
  stat: a,
  statSync: l,
  sys: e,
  writeFile: c,
  writeFiles: (e, t) => {
   const s = [];
   return isIterable(e) ? e.forEach(((e, r) => {
    s.push(c(r, e, t));
   })) : Object.keys(e).map((r => {
    s.push(c(r, e[r], t));
   })), Promise.all(s);
  }
 };
}, getCommitInstructions = e => {
 const t = {
  filesToDelete: [],
  filesToWrite: [],
  filesToCopy: [],
  dirsToDelete: [],
  dirsToEnsure: []
 };
 e.forEach(((e, s) => {
  if (!0 === e.queueWriteToDisk) {
   if (!0 === e.isFile) {
    t.filesToWrite.push(s);
    const e = normalizePath(path$6.dirname(s));
    t.dirsToEnsure.includes(e) || t.dirsToEnsure.push(e);
    const r = t.dirsToDelete.indexOf(e);
    r > -1 && t.dirsToDelete.splice(r, 1);
    const i = t.filesToDelete.indexOf(s);
    i > -1 && t.filesToDelete.splice(i, 1);
   } else if (!0 === e.isDirectory) {
    t.dirsToEnsure.includes(s) || t.dirsToEnsure.push(s);
    const e = t.dirsToDelete.indexOf(s);
    e > -1 && t.dirsToDelete.splice(e, 1);
   }
  } else if (!0 === e.queueDeleteFromDisk) e.isDirectory && !t.dirsToEnsure.includes(s) ? t.dirsToDelete.push(s) : e.isFile && !t.filesToWrite.includes(s) && t.filesToDelete.push(s); else if ("string" == typeof e.queueCopyFileToDest) {
   const r = s, i = e.queueCopyFileToDest;
   t.filesToCopy.push([ r, i ]);
   const n = normalizePath(path$6.dirname(i));
   t.dirsToEnsure.includes(n) || t.dirsToEnsure.push(n);
   const o = t.dirsToDelete.indexOf(n);
   o > -1 && t.dirsToDelete.splice(o, 1);
   const a = t.filesToDelete.indexOf(i);
   a > -1 && t.filesToDelete.splice(a, 1);
  }
  e.queueDeleteFromDisk = !1, e.queueWriteToDisk = !1;
 }));
 for (let e = 0, s = t.dirsToEnsure.length; e < s; e++) {
  const s = t.dirsToEnsure[e].split("/");
  for (let e = 2; e < s.length; e++) {
   const r = s.slice(0, e).join("/");
   !1 === t.dirsToEnsure.includes(r) && t.dirsToEnsure.push(r);
  }
 }
 t.dirsToEnsure.sort(((e, t) => {
  const s = e.split("/").length, r = t.split("/").length;
  return s < r ? -1 : s > r ? 1 : e.length < t.length ? -1 : e.length > t.length ? 1 : 0;
 })), t.dirsToDelete.sort(((e, t) => {
  const s = e.split("/").length, r = t.split("/").length;
  return s < r ? 1 : s > r ? -1 : e.length < t.length ? 1 : e.length > t.length ? -1 : 0;
 }));
 for (const e of t.dirsToEnsure) {
  const s = t.dirsToDelete.indexOf(e);
  s > -1 && t.dirsToDelete.splice(s, 1);
 }
 return t.dirsToDelete = t.dirsToDelete.filter((e => "/" !== e && !0 !== e.endsWith(":/"))), 
 t.dirsToEnsure = t.dirsToEnsure.filter((t => {
  const s = e.get(t);
  return (null == s || !0 !== s.exists || !0 !== s.isDirectory) && "/" !== t && !t.endsWith(":/");
 })), t;
}, shouldIgnore = e => (e = e.trim().toLowerCase(), IGNORE.some((t => e.endsWith(t)))), IGNORE = [ ".ds_store", ".gitignore", "desktop.ini", "thumbs.db" ];

class TestingLogger {
 constructor() {
  this.isEnabled = !1;
 }
 enable() {
  this.isEnabled = !0;
 }
 setLevel(e) {}
 getLevel() {
  return "info";
 }
 enableColors(e) {}
 emoji(e) {
  return "";
 }
 info(...e) {
  this.isEnabled && console.log(...e);
 }
 warn(...e) {
  this.isEnabled && console.warn(...e);
 }
 error(...e) {
  this.isEnabled && console.error(...e);
 }
 debug(...e) {
  this.isEnabled && console.log(...e);
 }
 color(e, t) {}
 red(e) {
  return e;
 }
 green(e) {
  return e;
 }
 yellow(e) {
  return e;
 }
 blue(e) {
  return e;
 }
 magenta(e) {
  return e;
 }
 cyan(e) {
  return e;
 }
 gray(e) {
  return e;
 }
 bold(e) {
  return e;
 }
 dim(e) {
  return e;
 }
 bgRed(e) {
  return e;
 }
 createTimeSpan(e, t = !1) {
  return {
   duration: () => 0,
   finish: () => 0
  };
 }
 printDiagnostics(e) {}
}

homedir$2 = os__default.default.homedir || function e() {
 var t = process.env.HOME, s = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
 return "win32" === process.platform ? process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || t || null : "darwin" === process.platform ? t || (s ? "/Users/" + s : null) : "linux" === process.platform ? t || (0 === process.getuid() ? "/root" : s ? "/home/" + s : null) : t || null;
}, caller$2 = function() {
 var e, t = Error.prepareStackTrace;
 return Error.prepareStackTrace = function(e, t) {
  return t;
 }, e = (new Error).stack, Error.prepareStackTrace = t, e[2].getFileName();
}, pathParse = {
 exports: {}
}, isWindows = "win32" === process.platform, splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/, 
(win32 = {}).parse = function(e) {
 if ("string" != typeof e) throw new TypeError("Parameter 'pathString' must be a string, not " + typeof e);
 var t = function s(e) {
  return splitWindowsRe.exec(e).slice(1);
 }(e);
 if (!t || 5 !== t.length) throw new TypeError("Invalid path '" + e + "'");
 return {
  root: t[1],
  dir: t[0] === t[1] ? t[0] : t[0].slice(0, -1),
  base: t[2],
  ext: t[4],
  name: t[3]
 };
}, splitPathRe = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/, 
(posix = {}).parse = function(e) {
 if ("string" != typeof e) throw new TypeError("Parameter 'pathString' must be a string, not " + typeof e);
 var t = function s(e) {
  return splitPathRe.exec(e).slice(1);
 }(e);
 if (!t || 5 !== t.length) throw new TypeError("Invalid path '" + e + "'");
 return {
  root: t[1],
  dir: t[0].slice(0, -1),
  base: t[2],
  ext: t[4],
  name: t[3]
 };
}, pathParse.exports = isWindows ? win32.parse : posix.parse, pathParse.exports.posix = posix.parse, 
pathParse.exports.win32 = win32.parse, path$4 = path__default.default, parse = path$4.parse || pathParse.exports, 
getNodeModulesDirs = function e(t, s) {
 var r, i, n = "/";
 for (/^([A-Za-z]:)/.test(t) ? n = "" : /^\\\\/.test(t) && (n = "\\\\"), r = [ t ], 
 i = parse(t); i.dir !== r[r.length - 1]; ) r.push(i.dir), i = parse(i.dir);
 return r.reduce((function(e, t) {
  return e.concat(s.map((function(e) {
   return path$4.resolve(n, t, e);
  })));
 }), []);
}, nodeModulesPaths$2 = function e(t, s, r) {
 var i, n = s && s.moduleDirectory ? [].concat(s.moduleDirectory) : [ "node_modules" ];
 return s && "function" == typeof s.paths ? s.paths(r, t, (function() {
  return getNodeModulesDirs(t, n);
 }), s) : (i = getNodeModulesDirs(t, n), s && s.paths ? i.concat(s.paths) : i);
}, normalizeOptions$2 = function(e, t) {
 return t || {};
}, toStr = Object.prototype.toString, max = Math.max, concatty = function e(t, s) {
 var r, i, n = [];
 for (r = 0; r < t.length; r += 1) n[r] = t[r];
 for (i = 0; i < s.length; i += 1) n[i + t.length] = s[i];
 return n;
}, slicy = function e(t, s) {
 var r, i, n = [];
 for (r = s || 0, i = 0; r < t.length; r += 1, i += 1) n[i] = t[r];
 return n;
}, joiny = function(e, t) {
 var s, r = "";
 for (s = 0; s < e.length; s += 1) r += e[s], s + 1 < e.length && (r += t);
 return r;
}, implementation = function e(t) {
 var s, r, i, n, o, a, l, c = this;
 if ("function" != typeof c || "[object Function]" !== toStr.apply(c)) throw new TypeError("Function.prototype.bind called on incompatible " + c);
 for (s = slicy(arguments, 1), i = function() {
  if (this instanceof r) {
   var e = c.apply(this, concatty(s, arguments));
   return Object(e) === e ? e : this;
  }
  return c.apply(t, concatty(s, arguments));
 }, n = max(0, c.length - s.length), o = [], a = 0; a < n; a++) o[a] = "$" + a;
 return r = Function("binder", "return function (" + joiny(o, ",") + "){ return binder.apply(this,arguments); }")(i), 
 c.prototype && ((l = function e() {}).prototype = c.prototype, r.prototype = new l, 
 l.prototype = null), r;
}, functionBind = Function.prototype.bind || implementation, call = Function.prototype.call, 
$hasOwn = Object.prototype.hasOwnProperty, hasown = functionBind.call(call, $hasOwn), 
hasOwn = hasown, data$1 = {
 assert: !0,
 "node:assert": [ ">= 14.18 && < 15", ">= 16" ],
 "assert/strict": ">= 15",
 "node:assert/strict": ">= 16",
 async_hooks: ">= 8",
 "node:async_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 buffer_ieee754: ">= 0.5 && < 0.9.7",
 buffer: !0,
 "node:buffer": [ ">= 14.18 && < 15", ">= 16" ],
 child_process: !0,
 "node:child_process": [ ">= 14.18 && < 15", ">= 16" ],
 cluster: ">= 0.5",
 "node:cluster": [ ">= 14.18 && < 15", ">= 16" ],
 console: !0,
 "node:console": [ ">= 14.18 && < 15", ">= 16" ],
 constants: !0,
 "node:constants": [ ">= 14.18 && < 15", ">= 16" ],
 crypto: !0,
 "node:crypto": [ ">= 14.18 && < 15", ">= 16" ],
 _debug_agent: ">= 1 && < 8",
 _debugger: "< 8",
 dgram: !0,
 "node:dgram": [ ">= 14.18 && < 15", ">= 16" ],
 diagnostics_channel: [ ">= 14.17 && < 15", ">= 15.1" ],
 "node:diagnostics_channel": [ ">= 14.18 && < 15", ">= 16" ],
 dns: !0,
 "node:dns": [ ">= 14.18 && < 15", ">= 16" ],
 "dns/promises": ">= 15",
 "node:dns/promises": ">= 16",
 domain: ">= 0.7.12",
 "node:domain": [ ">= 14.18 && < 15", ">= 16" ],
 events: !0,
 "node:events": [ ">= 14.18 && < 15", ">= 16" ],
 freelist: "< 6",
 fs: !0,
 "node:fs": [ ">= 14.18 && < 15", ">= 16" ],
 "fs/promises": [ ">= 10 && < 10.1", ">= 14" ],
 "node:fs/promises": [ ">= 14.18 && < 15", ">= 16" ],
 _http_agent: ">= 0.11.1",
 "node:_http_agent": [ ">= 14.18 && < 15", ">= 16" ],
 _http_client: ">= 0.11.1",
 "node:_http_client": [ ">= 14.18 && < 15", ">= 16" ],
 _http_common: ">= 0.11.1",
 "node:_http_common": [ ">= 14.18 && < 15", ">= 16" ],
 _http_incoming: ">= 0.11.1",
 "node:_http_incoming": [ ">= 14.18 && < 15", ">= 16" ],
 _http_outgoing: ">= 0.11.1",
 "node:_http_outgoing": [ ">= 14.18 && < 15", ">= 16" ],
 _http_server: ">= 0.11.1",
 "node:_http_server": [ ">= 14.18 && < 15", ">= 16" ],
 http: !0,
 "node:http": [ ">= 14.18 && < 15", ">= 16" ],
 http2: ">= 8.8",
 "node:http2": [ ">= 14.18 && < 15", ">= 16" ],
 https: !0,
 "node:https": [ ">= 14.18 && < 15", ">= 16" ],
 inspector: ">= 8",
 "node:inspector": [ ">= 14.18 && < 15", ">= 16" ],
 "inspector/promises": [ ">= 19" ],
 "node:inspector/promises": [ ">= 19" ],
 _linklist: "< 8",
 module: !0,
 "node:module": [ ">= 14.18 && < 15", ">= 16" ],
 net: !0,
 "node:net": [ ">= 14.18 && < 15", ">= 16" ],
 "node-inspect/lib/_inspect": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
 os: !0,
 "node:os": [ ">= 14.18 && < 15", ">= 16" ],
 path: !0,
 "node:path": [ ">= 14.18 && < 15", ">= 16" ],
 "path/posix": ">= 15.3",
 "node:path/posix": ">= 16",
 "path/win32": ">= 15.3",
 "node:path/win32": ">= 16",
 perf_hooks: ">= 8.5",
 "node:perf_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 process: ">= 1",
 "node:process": [ ">= 14.18 && < 15", ">= 16" ],
 punycode: ">= 0.5",
 "node:punycode": [ ">= 14.18 && < 15", ">= 16" ],
 querystring: !0,
 "node:querystring": [ ">= 14.18 && < 15", ">= 16" ],
 readline: !0,
 "node:readline": [ ">= 14.18 && < 15", ">= 16" ],
 "readline/promises": ">= 17",
 "node:readline/promises": ">= 17",
 repl: !0,
 "node:repl": [ ">= 14.18 && < 15", ">= 16" ],
 smalloc: ">= 0.11.5 && < 3",
 _stream_duplex: ">= 0.9.4",
 "node:_stream_duplex": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_transform: ">= 0.9.4",
 "node:_stream_transform": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_wrap: ">= 1.4.1",
 "node:_stream_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_passthrough: ">= 0.9.4",
 "node:_stream_passthrough": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_readable: ">= 0.9.4",
 "node:_stream_readable": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_writable: ">= 0.9.4",
 "node:_stream_writable": [ ">= 14.18 && < 15", ">= 16" ],
 stream: !0,
 "node:stream": [ ">= 14.18 && < 15", ">= 16" ],
 "stream/consumers": ">= 16.7",
 "node:stream/consumers": ">= 16.7",
 "stream/promises": ">= 15",
 "node:stream/promises": ">= 16",
 "stream/web": ">= 16.5",
 "node:stream/web": ">= 16.5",
 string_decoder: !0,
 "node:string_decoder": [ ">= 14.18 && < 15", ">= 16" ],
 sys: [ ">= 0.4 && < 0.7", ">= 0.8" ],
 "node:sys": [ ">= 14.18 && < 15", ">= 16" ],
 "test/reporters": ">= 19.9 && < 20.2",
 "node:test/reporters": [ ">= 18.17 && < 19", ">= 19.9", ">= 20" ],
 "node:test": [ ">= 16.17 && < 17", ">= 18" ],
 timers: !0,
 "node:timers": [ ">= 14.18 && < 15", ">= 16" ],
 "timers/promises": ">= 15",
 "node:timers/promises": ">= 16",
 _tls_common: ">= 0.11.13",
 "node:_tls_common": [ ">= 14.18 && < 15", ">= 16" ],
 _tls_legacy: ">= 0.11.3 && < 10",
 _tls_wrap: ">= 0.11.3",
 "node:_tls_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 tls: !0,
 "node:tls": [ ">= 14.18 && < 15", ">= 16" ],
 trace_events: ">= 10",
 "node:trace_events": [ ">= 14.18 && < 15", ">= 16" ],
 tty: !0,
 "node:tty": [ ">= 14.18 && < 15", ">= 16" ],
 url: !0,
 "node:url": [ ">= 14.18 && < 15", ">= 16" ],
 util: !0,
 "node:util": [ ">= 14.18 && < 15", ">= 16" ],
 "util/types": ">= 15.3",
 "node:util/types": ">= 16",
 "v8/tools/arguments": ">= 10 && < 12",
 "v8/tools/codemap": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/consarray": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/csvparser": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/logreader": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/profile_view": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/splaytree": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 v8: ">= 1",
 "node:v8": [ ">= 14.18 && < 15", ">= 16" ],
 vm: !0,
 "node:vm": [ ">= 14.18 && < 15", ">= 16" ],
 wasi: [ ">= 13.4 && < 13.5", ">= 18.17 && < 19", ">= 20" ],
 "node:wasi": [ ">= 18.17 && < 19", ">= 20" ],
 worker_threads: ">= 11.7",
 "node:worker_threads": [ ">= 14.18 && < 15", ">= 16" ],
 zlib: ">= 0.5",
 "node:zlib": [ ">= 14.18 && < 15", ">= 16" ]
}, isCoreModule$2 = function e(t, s) {
 return hasOwn(data$1, t) && function r(e, t) {
  var s, r;
  if ("boolean" == typeof t) return t;
  if ("string" != typeof (s = void 0 === e ? process.versions && process.versions.node : e)) throw new TypeError(void 0 === e ? "Unable to determine current node version" : "If provided, a valid node version is required");
  if (t && "object" == typeof t) {
   for (r = 0; r < t.length; ++r) if (matchesRange(s, t[r])) return !0;
   return !1;
  }
  return matchesRange(s, t);
 }(s, data$1[t]);
}, fs$2 = fs__default.default, getHomedir$1 = homedir$2, path$2 = path__default.default, 
caller$1 = caller$2, nodeModulesPaths$1 = nodeModulesPaths$2, normalizeOptions$1 = normalizeOptions$2, 
isCore$2 = isCoreModule$2, realpathFS$1 = "win32" !== process.platform && fs$2.realpath && "function" == typeof fs$2.realpath.native ? fs$2.realpath.native : fs$2.realpath, 
homedir$1 = getHomedir$1(), defaultPaths$1 = function() {
 return [ path$2.join(homedir$1, ".node_modules"), path$2.join(homedir$1, ".node_libraries") ];
}, defaultIsFile$1 = function e(t, s) {
 fs$2.stat(t, (function(e, t) {
  return e ? "ENOENT" === e.code || "ENOTDIR" === e.code ? s(null, !1) : s(e) : s(null, t.isFile() || t.isFIFO());
 }));
}, defaultIsDir$1 = function e(t, s) {
 fs$2.stat(t, (function(e, t) {
  return e ? "ENOENT" === e.code || "ENOTDIR" === e.code ? s(null, !1) : s(e) : s(null, t.isDirectory());
 }));
}, defaultRealpath = function e(t, s) {
 realpathFS$1(t, (function(e, r) {
  e && "ENOENT" !== e.code ? s(e) : s(null, e ? t : r);
 }));
}, maybeRealpath = function e(t, s, r, i) {
 r && !1 === r.preserveSymlinks ? t(s, i) : i(null, s);
}, defaultReadPackage = function e(t, s, r) {
 t(s, (function(e, t) {
  if (e) r(e); else try {
   var s = JSON.parse(t);
   r(null, s);
  } catch (e) {
   r(null);
  }
 }));
}, getPackageCandidates$1 = function e(t, s, r) {
 var i, n = nodeModulesPaths$1(s, r, t);
 for (i = 0; i < n.length; i++) n[i] = path$2.join(n[i], t);
 return n;
}, async$1 = function e(t, s, r) {
 function i(e) {
  if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(t)) S = path$2.resolve(e, t), 
  "." !== t && ".." !== t && "/" !== t.slice(-1) || (S += "/"), /\/$/.test(t) && S === e ? l(S, x.package, n) : o(S, x.package, n); else {
   if (w && isCore$2(t)) return T(null, t);
   !function s(e, t, r) {
    var i = function() {
     return getPackageCandidates$1(e, t, x);
    };
    c(r, y ? y(e, t, i, x) : i());
   }(t, e, (function(e, s, r) {
    if (e) T(e); else {
     if (s) return maybeRealpath(f, s, x, (function(e, t) {
      e ? T(e) : T(null, t, r);
     }));
     var i = new Error("Cannot find module '" + t + "' from '" + E + "'");
     i.code = "MODULE_NOT_FOUND", T(i);
    }
   }));
  }
 }
 function n(e, s, r) {
  e ? T(e) : s ? T(null, s, r) : l(S, (function(e, s, r) {
   if (e) T(e); else if (s) maybeRealpath(f, s, x, (function(e, t) {
    e ? T(e) : T(null, t, r);
   })); else {
    var i = new Error("Cannot find module '" + t + "' from '" + E + "'");
    i.code = "MODULE_NOT_FOUND", T(i);
   }
  }));
 }
 function o(e, t, s) {
  var r = t, i = s;
  "function" == typeof r && (i = r, r = void 0), function e(t, s, r) {
   function n(r, n, a) {
    var u, p, d;
    return c = n, r ? i(r) : a && c && x.pathFilter && (p = (u = path$2.relative(a, l)).slice(0, u.length - t[0].length), 
    d = x.pathFilter(c, s, p)) ? e([ "" ].concat(v.slice()), path$2.resolve(a, d), c) : void h(l, o);
   }
   function o(r, n) {
    return r ? i(r) : n ? i(null, l, c) : void e(t.slice(1), s, c);
   }
   var l, c;
   if (0 === t.length) return i(null, void 0, r);
   l = s + t[0], (c = r) ? n(null, c) : a(path$2.dirname(l), n);
  }([ "" ].concat(v), e, r);
 }
 function a(e, t) {
  return "" === e || "/" === e || "win32" === process.platform && /^\w:[/\\]*$/.test(e) || /[/\\]node_modules[/\\]*$/.test(e) ? t(null) : void maybeRealpath(f, e, x, (function(s, r) {
   if (s) return a(path$2.dirname(e), t);
   var i = path$2.join(r, "package.json");
   h(i, (function(s, r) {
    if (!r) return a(path$2.dirname(e), t);
    m(d, i, (function(s, r) {
     s && t(s);
     var n = r;
     n && x.packageFilter && (n = x.packageFilter(n, i)), t(null, n, e);
    }));
   }));
  }));
 }
 function l(e, t, s) {
  var r = s, i = t;
  "function" == typeof i && (r = i, i = x.package), maybeRealpath(f, e, x, (function(t, s) {
   if (t) return r(t);
   var n = path$2.join(s, "package.json");
   h(n, (function(t, s) {
    return t ? r(t) : s ? void m(d, n, (function(t, s) {
     var i, a;
     return t ? r(t) : ((i = s) && x.packageFilter && (i = x.packageFilter(i, n)), i && i.main ? "string" != typeof i.main ? ((a = new TypeError("package “" + i.name + "” `main` must be a string")).code = "INVALID_PACKAGE_MAIN", 
     r(a)) : ("." !== i.main && "./" !== i.main || (i.main = "index"), void o(path$2.resolve(e, i.main), i, (function(t, s, i) {
      return t ? r(t) : s ? r(null, s, i) : i ? void l(path$2.resolve(e, i.main), i, (function(t, s, i) {
       return t ? r(t) : s ? r(null, s, i) : void o(path$2.join(e, "index"), i, r);
      })) : o(path$2.join(e, "index"), i, r);
     }))) : void o(path$2.join(e, "/index"), i, r));
    })) : o(path$2.join(e, "index"), i, r);
   }));
  }));
 }
 function c(e, t) {
  function s(t, s, n) {
   return t ? e(t) : s ? e(null, s, n) : void l(i, x.package, r);
  }
  function r(s, r, i) {
   return s ? e(s) : r ? e(null, r, i) : void c(e, t.slice(1));
  }
  if (0 === t.length) return e(null, void 0);
  var i = t[0];
  p(path$2.dirname(i), (function n(r, a) {
   return r ? e(r) : a ? void o(i, x.package, s) : c(e, t.slice(1));
  }));
 }
 var u, h, p, d, f, m, g, y, v, w, b, E, _, S, T = r, x = s;
 return "function" == typeof s && (T = x, x = {}), "string" != typeof t ? (u = new TypeError("Path must be a string."), 
 process.nextTick((function() {
  T(u);
 }))) : (x = normalizeOptions$1(t, x), h = x.isFile || defaultIsFile$1, p = x.isDirectory || defaultIsDir$1, 
 d = x.readFile || fs$2.readFile, f = x.realpath || defaultRealpath, m = x.readPackage || defaultReadPackage, 
 x.readFile && x.readPackage ? (g = new TypeError("`readFile` and `readPackage` are mutually exclusive."), 
 process.nextTick((function() {
  T(g);
 }))) : (y = x.packageIterator, v = x.extensions || [ ".js" ], w = !1 !== x.includeCoreModules, 
 b = x.basedir || path$2.dirname(caller$1()), E = x.filename || b, x.paths = x.paths || defaultPaths$1(), 
 _ = path$2.resolve(b), void maybeRealpath(f, _, x, (function(e, t) {
  e ? T(e) : i(t);
 }))));
};

const require$$1 = {
 assert: !0,
 "node:assert": [ ">= 14.18 && < 15", ">= 16" ],
 "assert/strict": ">= 15",
 "node:assert/strict": ">= 16",
 async_hooks: ">= 8",
 "node:async_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 buffer_ieee754: ">= 0.5 && < 0.9.7",
 buffer: !0,
 "node:buffer": [ ">= 14.18 && < 15", ">= 16" ],
 child_process: !0,
 "node:child_process": [ ">= 14.18 && < 15", ">= 16" ],
 cluster: ">= 0.5",
 "node:cluster": [ ">= 14.18 && < 15", ">= 16" ],
 console: !0,
 "node:console": [ ">= 14.18 && < 15", ">= 16" ],
 constants: !0,
 "node:constants": [ ">= 14.18 && < 15", ">= 16" ],
 crypto: !0,
 "node:crypto": [ ">= 14.18 && < 15", ">= 16" ],
 _debug_agent: ">= 1 && < 8",
 _debugger: "< 8",
 dgram: !0,
 "node:dgram": [ ">= 14.18 && < 15", ">= 16" ],
 diagnostics_channel: [ ">= 14.17 && < 15", ">= 15.1" ],
 "node:diagnostics_channel": [ ">= 14.18 && < 15", ">= 16" ],
 dns: !0,
 "node:dns": [ ">= 14.18 && < 15", ">= 16" ],
 "dns/promises": ">= 15",
 "node:dns/promises": ">= 16",
 domain: ">= 0.7.12",
 "node:domain": [ ">= 14.18 && < 15", ">= 16" ],
 events: !0,
 "node:events": [ ">= 14.18 && < 15", ">= 16" ],
 freelist: "< 6",
 fs: !0,
 "node:fs": [ ">= 14.18 && < 15", ">= 16" ],
 "fs/promises": [ ">= 10 && < 10.1", ">= 14" ],
 "node:fs/promises": [ ">= 14.18 && < 15", ">= 16" ],
 _http_agent: ">= 0.11.1",
 "node:_http_agent": [ ">= 14.18 && < 15", ">= 16" ],
 _http_client: ">= 0.11.1",
 "node:_http_client": [ ">= 14.18 && < 15", ">= 16" ],
 _http_common: ">= 0.11.1",
 "node:_http_common": [ ">= 14.18 && < 15", ">= 16" ],
 _http_incoming: ">= 0.11.1",
 "node:_http_incoming": [ ">= 14.18 && < 15", ">= 16" ],
 _http_outgoing: ">= 0.11.1",
 "node:_http_outgoing": [ ">= 14.18 && < 15", ">= 16" ],
 _http_server: ">= 0.11.1",
 "node:_http_server": [ ">= 14.18 && < 15", ">= 16" ],
 http: !0,
 "node:http": [ ">= 14.18 && < 15", ">= 16" ],
 http2: ">= 8.8",
 "node:http2": [ ">= 14.18 && < 15", ">= 16" ],
 https: !0,
 "node:https": [ ">= 14.18 && < 15", ">= 16" ],
 inspector: ">= 8",
 "node:inspector": [ ">= 14.18 && < 15", ">= 16" ],
 "inspector/promises": [ ">= 19" ],
 "node:inspector/promises": [ ">= 19" ],
 _linklist: "< 8",
 module: !0,
 "node:module": [ ">= 14.18 && < 15", ">= 16" ],
 net: !0,
 "node:net": [ ">= 14.18 && < 15", ">= 16" ],
 "node-inspect/lib/_inspect": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
 "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
 os: !0,
 "node:os": [ ">= 14.18 && < 15", ">= 16" ],
 path: !0,
 "node:path": [ ">= 14.18 && < 15", ">= 16" ],
 "path/posix": ">= 15.3",
 "node:path/posix": ">= 16",
 "path/win32": ">= 15.3",
 "node:path/win32": ">= 16",
 perf_hooks: ">= 8.5",
 "node:perf_hooks": [ ">= 14.18 && < 15", ">= 16" ],
 process: ">= 1",
 "node:process": [ ">= 14.18 && < 15", ">= 16" ],
 punycode: ">= 0.5",
 "node:punycode": [ ">= 14.18 && < 15", ">= 16" ],
 querystring: !0,
 "node:querystring": [ ">= 14.18 && < 15", ">= 16" ],
 readline: !0,
 "node:readline": [ ">= 14.18 && < 15", ">= 16" ],
 "readline/promises": ">= 17",
 "node:readline/promises": ">= 17",
 repl: !0,
 "node:repl": [ ">= 14.18 && < 15", ">= 16" ],
 smalloc: ">= 0.11.5 && < 3",
 _stream_duplex: ">= 0.9.4",
 "node:_stream_duplex": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_transform: ">= 0.9.4",
 "node:_stream_transform": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_wrap: ">= 1.4.1",
 "node:_stream_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_passthrough: ">= 0.9.4",
 "node:_stream_passthrough": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_readable: ">= 0.9.4",
 "node:_stream_readable": [ ">= 14.18 && < 15", ">= 16" ],
 _stream_writable: ">= 0.9.4",
 "node:_stream_writable": [ ">= 14.18 && < 15", ">= 16" ],
 stream: !0,
 "node:stream": [ ">= 14.18 && < 15", ">= 16" ],
 "stream/consumers": ">= 16.7",
 "node:stream/consumers": ">= 16.7",
 "stream/promises": ">= 15",
 "node:stream/promises": ">= 16",
 "stream/web": ">= 16.5",
 "node:stream/web": ">= 16.5",
 string_decoder: !0,
 "node:string_decoder": [ ">= 14.18 && < 15", ">= 16" ],
 sys: [ ">= 0.4 && < 0.7", ">= 0.8" ],
 "node:sys": [ ">= 14.18 && < 15", ">= 16" ],
 "test/reporters": ">= 19.9 && < 20.2",
 "node:test/reporters": [ ">= 18.17 && < 19", ">= 19.9", ">= 20" ],
 "node:test": [ ">= 16.17 && < 17", ">= 18" ],
 timers: !0,
 "node:timers": [ ">= 14.18 && < 15", ">= 16" ],
 "timers/promises": ">= 15",
 "node:timers/promises": ">= 16",
 _tls_common: ">= 0.11.13",
 "node:_tls_common": [ ">= 14.18 && < 15", ">= 16" ],
 _tls_legacy: ">= 0.11.3 && < 10",
 _tls_wrap: ">= 0.11.3",
 "node:_tls_wrap": [ ">= 14.18 && < 15", ">= 16" ],
 tls: !0,
 "node:tls": [ ">= 14.18 && < 15", ">= 16" ],
 trace_events: ">= 10",
 "node:trace_events": [ ">= 14.18 && < 15", ">= 16" ],
 tty: !0,
 "node:tty": [ ">= 14.18 && < 15", ">= 16" ],
 url: !0,
 "node:url": [ ">= 14.18 && < 15", ">= 16" ],
 util: !0,
 "node:util": [ ">= 14.18 && < 15", ">= 16" ],
 "util/types": ">= 15.3",
 "node:util/types": ">= 16",
 "v8/tools/arguments": ">= 10 && < 12",
 "v8/tools/codemap": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/consarray": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/csvparser": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/logreader": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/profile_view": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 "v8/tools/splaytree": [ ">= 4.4 && < 5", ">= 5.2 && < 12" ],
 v8: ">= 1",
 "node:v8": [ ">= 14.18 && < 15", ">= 16" ],
 vm: !0,
 "node:vm": [ ">= 14.18 && < 15", ">= 16" ],
 wasi: [ ">= 13.4 && < 13.5", ">= 18.17 && < 19", ">= 20" ],
 "node:wasi": [ ">= 18.17 && < 19", ">= 20" ],
 worker_threads: ">= 11.7",
 "node:worker_threads": [ ">= 14.18 && < 15", ">= 16" ],
 zlib: ">= 0.5",
 "node:zlib": [ ">= 14.18 && < 15", ">= 16" ]
};

for (mod in isCoreModule$1 = isCoreModule$2, core = {}, data = require$$1) Object.prototype.hasOwnProperty.call(data, mod) && (core[mod] = isCoreModule$1(mod));

core_1 = core, isCoreModule = isCoreModule$2, isCore$1 = function e(t) {
 return isCoreModule(t);
}, isCore = isCoreModule$2, fs = fs__default.default, path = path__default.default, 
getHomedir = homedir$2, caller = caller$2, nodeModulesPaths = nodeModulesPaths$2, 
normalizeOptions = normalizeOptions$2, realpathFS = "win32" !== process.platform && fs.realpathSync && "function" == typeof fs.realpathSync.native ? fs.realpathSync.native : fs.realpathSync, 
homedir = getHomedir(), defaultPaths = function() {
 return [ path.join(homedir, ".node_modules"), path.join(homedir, ".node_libraries") ];
}, defaultIsFile = function e(t) {
 try {
  var s = fs.statSync(t, {
   throwIfNoEntry: !1
  });
 } catch (e) {
  if (e && ("ENOENT" === e.code || "ENOTDIR" === e.code)) return !1;
  throw e;
 }
 return !!s && (s.isFile() || s.isFIFO());
}, defaultIsDir = function e(t) {
 try {
  var s = fs.statSync(t, {
   throwIfNoEntry: !1
  });
 } catch (e) {
  if (e && ("ENOENT" === e.code || "ENOTDIR" === e.code)) return !1;
  throw e;
 }
 return !!s && s.isDirectory();
}, defaultRealpathSync = function e(t) {
 try {
  return realpathFS(t);
 } catch (e) {
  if ("ENOENT" !== e.code) throw e;
 }
 return t;
}, maybeRealpathSync = function e(t, s, r) {
 return r && !1 === r.preserveSymlinks ? t(s) : s;
}, defaultReadPackageSync = function e(t, s) {
 var r = t(s);
 try {
  return JSON.parse(r);
 } catch (e) {}
}, getPackageCandidates = function e(t, s, r) {
 var i, n = nodeModulesPaths(s, r, t);
 for (i = 0; i < n.length; i++) n[i] = path.join(n[i], t);
 return n;
}, sync = function e(t, s) {
 function r(e) {
  var t, s, r, n, l = i(path.dirname(e));
  if (l && l.dir && l.pkg && o.pathFilter && (t = path.relative(l.dir, e), (s = o.pathFilter(l.pkg, e, t)) && (e = path.resolve(l.dir, s))), 
  a(e)) return e;
  for (r = 0; r < d.length; r++) if (n = e + d[r], a(n)) return n;
 }
 function i(e) {
  var t, s;
  if ("" !== e && "/" !== e && !("win32" === process.platform && /^\w:[/\\]*$/.test(e) || /[/\\]node_modules[/\\]*$/.test(e))) return t = path.join(maybeRealpathSync(u, e, o), "package.json"), 
  a(t) ? ((s = h(l, t)) && o.packageFilter && (s = o.packageFilter(s, e)), {
   pkg: s,
   dir: e
  }) : i(path.dirname(e));
 }
 function n(e) {
  var t, s, i, c, p = path.join(maybeRealpathSync(u, e, o), "/package.json");
  if (a(p)) {
   try {
    t = h(l, p);
   } catch (e) {}
   if (t && o.packageFilter && (t = o.packageFilter(t, e)), t && t.main) {
    if ("string" != typeof t.main) throw (s = new TypeError("package “" + t.name + "” `main` must be a string")).code = "INVALID_PACKAGE_MAIN", 
    s;
    "." !== t.main && "./" !== t.main || (t.main = "index");
    try {
     if (i = r(path.resolve(e, t.main))) return i;
     if (c = n(path.resolve(e, t.main))) return c;
    } catch (e) {}
   }
  }
  return r(path.join(e, "/index"));
 }
 var o, a, l, c, u, h, p, d, f, m, g, y, v, w, b, E;
 if ("string" != typeof t) throw new TypeError("Path must be a string.");
 if (o = normalizeOptions(t, s), a = o.isFile || defaultIsFile, l = o.readFileSync || fs.readFileSync, 
 c = o.isDirectory || defaultIsDir, u = o.realpathSync || defaultRealpathSync, h = o.readPackageSync || defaultReadPackageSync, 
 o.readFileSync && o.readPackageSync) throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
 if (p = o.packageIterator, d = o.extensions || [ ".js" ], f = !1 !== o.includeCoreModules, 
 m = o.basedir || path.dirname(caller()), g = o.filename || m, o.paths = o.paths || defaultPaths(), 
 y = maybeRealpathSync(u, path.resolve(m), o), /^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(t)) {
  if (v = path.resolve(y, t), "." !== t && ".." !== t && "/" !== t.slice(-1) || (v += "/"), 
  w = r(v) || n(v)) return maybeRealpathSync(u, w, o);
 } else {
  if (f && isCore(t)) return t;
  if (b = function _(e, t) {
   var s, i, a, l, u = function() {
    return getPackageCandidates(e, t, o);
   }, h = p ? p(e, t, u, o) : u();
   for (s = 0; s < h.length; s++) if (i = h[s], c(path.dirname(i))) {
    if (a = r(i)) return a;
    if (l = n(i)) return l;
   }
  }(t, y), b) return maybeRealpathSync(u, b, o);
 }
 throw (E = new Error("Cannot find module '" + t + "' from '" + g + "'")).code = "MODULE_NOT_FOUND", 
 E;
}, (async = async$1).core = core_1, async.isCore = isCore$1, async.sync = sync;

const resolve$1 = async, createSystem = e => {
 var t;
 const s = null !== (t = null == e ? void 0 : e.logger) && void 0 !== t ? t : createNodeLogger(), r = new Map, i = new Set, n = e => i.add(e), o = e => i.delete(e), a = buildEvents(), l = e => {
  if ("/" === e || "" === e) return "/";
  const t = path$6.dirname(e), s = path$6.basename(e);
  return t.endsWith("/") ? normalizePath(`${t}${s}`) : normalizePath(`${t}/${s}`);
 }, c = e => {
  const t = r.get(l(e));
  return !(!t || !(t.isDirectory || t.isFile && "string" == typeof t.data));
 }, u = (e, t) => {
  e = l(e);
  const s = {
   basename: path$6.basename(e),
   dirname: path$6.dirname(e),
   path: e,
   newDirs: [],
   error: null
  };
  return h(e, t, s), s;
 }, h = (e, t, s) => {
  const i = path$6.dirname(e);
  t && t.recursive && !(e => "/" === e || windowsPathRegex.test(e))(i) && h(i, t, s);
  const n = r.get(e);
  n ? (n.isDirectory = !0, n.isFile = !1) : (r.set(e, {
   basename: path$6.basename(e),
   dirname: i,
   isDirectory: !0,
   isFile: !1,
   watcherCallbacks: null,
   data: void 0
  }), s.newDirs.push(e), b(e, new Set));
 }, p = e => {
  e = l(e);
  const t = [], s = r.get(e);
  return s && s.isDirectory && r.forEach(((s, r) => {
   "/" !== r && (s.isDirectory || s.isFile && "string" == typeof s.data) && (e.endsWith("/") && `${e}${s.basename}` === r || `${e}/${s.basename}` === r) && t.push(r);
  })), t.sort();
 }, d = e => {
  e = l(e);
  const t = r.get(e);
  if (t && t.isFile) return t.data;
 }, f = e => ({
  path: l(e),
  error: null
 }), m = (e, t, s) => {
  const i = v(e);
  if (!i.error && !s.error) if (i.isFile) {
   const i = path$6.dirname(t), n = u(i, {
    recursive: !0
   }), o = r.get(e).data, a = E(t, o);
   s.newDirs.push(...n.newDirs), s.renamed.push({
    oldPath: e,
    newPath: t,
    isDirectory: !1,
    isFile: !0
   }), a.error ? s.error = a.error : s.newFiles.push(t);
  } else if (i.isDirectory) {
   const r = p(e), i = u(t, {
    recursive: !0
   });
   s.newDirs.push(...i.newDirs), s.renamed.push({
    oldPath: e,
    newPath: t,
    isDirectory: !0,
    isFile: !1
   });
   for (const i of r) {
    const r = i.replace(e, t);
    m(i, r, s);
   }
  }
 }, g = (e, t = {}) => {
  const s = {
   basename: path$6.basename(e),
   dirname: path$6.dirname(e),
   path: e,
   removedDirs: [],
   removedFiles: [],
   error: null
  };
  return y(e, t, s), s;
 }, y = (e, t, s) => {
  if (!s.error) {
   e = l(e);
   const i = p(e);
   if (t && t.recursive) for (const e of i) {
    const i = r.get(e);
    if (i) if (i.isDirectory) y(e, t, s); else if (i.isFile) {
     const t = w(e);
     t.error ? s.error = t.error : s.removedFiles.push(e);
    }
   } else if (i.length > 0) return void (s.error = "cannot delete directory that contains files/subdirectories");
   r.delete(e), b(e, new Set), s.removedDirs.push(e);
  }
 }, v = e => {
  e = l(e);
  const t = r.get(e);
  return t && (t.isDirectory || t.isFile && "string" == typeof t.data) ? {
   isDirectory: t.isDirectory,
   isFile: t.isFile,
   isSymbolicLink: !1,
   size: t.isFile && t.data ? t.data.length : 0,
   error: null
  } : {
   isDirectory: !1,
   isFile: !1,
   isSymbolicLink: !1,
   size: 0,
   error: `ENOENT: no such file or directory, statSync '${e}'`
  };
 }, w = e => {
  e = l(e);
  const t = {
   basename: path$6.basename(e),
   dirname: path$6.dirname(e),
   path: e,
   error: null
  }, s = r.get(e);
  if (s) {
   if (s.watcherCallbacks) for (const t of s.watcherCallbacks) t(e, "fileDelete");
   r.delete(e), b(e, new Set);
  }
  return t;
 }, b = (e, t) => {
  const s = l(path$6.dirname(e)), i = r.get(s);
  if (i && i.isDirectory && i.watcherCallbacks) for (const t of i.watcherCallbacks) t(e, null);
  t.has(s) || (t.add(s), b(s, t));
 }, E = (e, t) => {
  const s = {
   path: e = l(e),
   error: null
  }, i = r.get(e);
  if (i) {
   const s = i.data !== t;
   if (i.data = t, s && i.watcherCallbacks) for (const t of i.watcherCallbacks) t(e, "fileUpdate");
  } else r.set(e, {
   basename: path$6.basename(e),
   dirname: path$6.dirname(e),
   isDirectory: !1,
   isFile: !0,
   watcherCallbacks: null,
   data: t
  }), b(e, new Set);
  return s;
 }, _ = "undefined" != typeof self ? null === self || void 0 === self ? void 0 : self.fetch : "undefined" != typeof window ? null === window || void 0 === window ? void 0 : window.fetch : "undefined" != typeof global ? null === global || void 0 === global ? void 0 : global.fetch : void 0, S = Promise.resolve();
 u("/");
 const T = {
  name: "in-memory",
  version: "4.13.0",
  events: a,
  access: async e => c(e),
  accessSync: c,
  addDestroy: n,
  copyFile: async (e, t) => (E(t, d(e)), !0),
  createDir: async (e, t) => u(e, t),
  createDirSync: u,
  homeDir: () => os__namespace.homedir(),
  isTTY: () => {
   var e;
   return !!(null === (e = null == process__namespace ? void 0 : process__namespace.stdout) || void 0 === e ? void 0 : e.isTTY);
  },
  getEnvironmentVar: e => null == process__namespace ? void 0 : process__namespace.env[e],
  destroy: async () => {
   const e = [];
   i.forEach((t => {
    try {
     const s = t();
     s && "function" == typeof s.then && e.push(s);
    } catch (e) {
     s.error(`stencil sys destroy: ${e}`);
    }
   })), await Promise.all(e), i.clear();
  },
  encodeToBase64: e => btoa(unescape(encodeURIComponent(e))),
  exit: async e => s.warn(`exit ${e}`),
  getCurrentDirectory: () => "/",
  getCompilerExecutingPath: () => T.getRemoteModuleUrl({
   moduleId: "@stencil/core",
   path: "compiler/stencil.min.js"
  }),
  getLocalModulePath: e => join(e.rootDir, "node_modules", e.moduleId, e.path),
  getRemoteModuleUrl: e => {
   const t = `${e.moduleId}${e.version ? "@" + e.version : ""}/${e.path}`;
   return new URL(t, "https://cdn.jsdelivr.net/npm/").href;
  },
  hardwareConcurrency: 1,
  isSymbolicLink: async e => !1,
  nextTick: e => S.then(e),
  normalizePath: l,
  platformPath: path__default.default,
  readDir: async e => p(e),
  readDirSync: p,
  readFile: async e => d(e),
  readFileSync: d,
  realpath: async e => f(e),
  realpathSync: f,
  removeDestroy: o,
  rename: async (e, t) => {
   const s = {
    oldPath: e = normalizePath(e),
    newPath: t = normalizePath(t),
    renamed: [],
    oldDirs: [],
    oldFiles: [],
    newDirs: [],
    newFiles: [],
    isFile: !1,
    isDirectory: !1,
    error: null
   }, r = v(e);
   if (r.error) s.error = `${e} does not exist`; else if (r.isFile ? s.isFile = !0 : r.isDirectory && (s.isDirectory = !0), 
   m(e, t, s), !s.error) if (s.isDirectory) {
    const t = g(e, {
     recursive: !0
    });
    t.error ? s.error = t.error : (s.oldDirs.push(...t.removedDirs), s.oldFiles.push(...t.removedFiles));
   } else if (s.isFile) {
    const t = w(e);
    t.error ? s.error = t.error : s.oldFiles.push(e);
   }
   return s;
  },
  fetch: _,
  resolvePath: e => l(e),
  removeDir: async (e, t = {}) => g(e, t),
  removeDirSync: g,
  stat: async e => v(e),
  statSync: v,
  tmpDirSync: () => "/.tmp",
  removeFile: async e => w(e),
  removeFileSync: w,
  watchDirectory: (e, t) => {
   e = l(e);
   const s = r.get(e), i = () => {
    const s = r.get(e);
    if (s && s.watcherCallbacks) {
     const e = s.watcherCallbacks.indexOf(t);
     e > -1 && s.watcherCallbacks.splice(e, 1);
    }
   };
   return n(i), s ? (s.isDirectory = !0, s.isFile = !1, s.watcherCallbacks = s.watcherCallbacks || [], 
   s.watcherCallbacks.push(t)) : r.set(e, {
    basename: path$6.basename(e),
    dirname: path$6.dirname(e),
    isDirectory: !0,
    isFile: !1,
    watcherCallbacks: [ t ],
    data: void 0
   }), {
    close() {
     o(i), i();
    }
   };
  },
  watchFile: (e, t) => {
   e = l(e);
   const s = r.get(e), i = () => {
    const s = r.get(e);
    if (s && s.watcherCallbacks) {
     const e = s.watcherCallbacks.indexOf(t);
     e > -1 && s.watcherCallbacks.splice(e, 1);
    }
   };
   return n(i), s ? (s.isDirectory = !1, s.isFile = !0, s.watcherCallbacks = s.watcherCallbacks || [], 
   s.watcherCallbacks.push(t)) : r.set(e, {
    basename: path$6.basename(e),
    dirname: path$6.dirname(e),
    isDirectory: !1,
    isFile: !0,
    watcherCallbacks: [ t ],
    data: void 0
   }), {
    close() {
     o(i), i();
    }
   };
  },
  watchTimeout: 32,
  writeFile: async (e, t) => E(e, t),
  writeFileSync: E,
  generateContentHash: async (e, t) => {
   const s = await crypto.subtle.digest("SHA-256", (new TextEncoder).encode(e));
   let r = Array.from(new Uint8Array(s)).map((e => e.toString(16).padStart(2, "0"))).join("");
   return "number" == typeof t && (r = r.slice(0, t)), r;
  },
  createWorkerController: null,
  details: {
   cpuModel: "",
   freemem: () => 0,
   platform: "",
   release: "",
   totalmem: 0
  },
  copy: async (e, t) => (s.info("todo, copy task", e.length, t), {
   diagnostics: [],
   dirPaths: [],
   filePaths: []
  })
 };
 return T.resolveModuleId = e => ((e, t, s) => {
  const r = ((e, t, s) => ({
   async isFile(e, s) {
    const r = normalizeFsPath(e);
    (await t.stat(r)).isFile ? s(null, !0) : s(null, !1);
   },
   async isDirectory(e, s) {
    const r = normalizeFsPath(e);
    (await t.stat(r)).isDirectory ? s(null, !0) : s(null, !1);
   },
   async readFile(e, s) {
    const r = normalizeFsPath(e), i = await t.readFile(r);
    return isString(i) ? s(null, i) : s(`readFile not found: ${e}`);
   },
   async realpath(t, s) {
    const r = normalizeFsPath(t), i = await e.realpath(r);
    i.error && "ENOENT" !== i.error.code ? s(i.error) : s(null, i.error ? r : i.path);
   },
   extensions: s
  }))(e, null, s.exts);
  return r.basedir = path$6.dirname(normalizeFsPath(s.containingFile)), s.packageFilter ? r.packageFilter = s.packageFilter : null !== s.packageFilter && (r.packageFilter = e => (isString(e.main) && "" !== e.main || (e.main = "package.json"), 
  e)), new Promise(((e, t) => {
   resolve$1(s.moduleId, r, ((r, i, n) => {
    if (r) t(r); else {
     i = normalizePath(i);
     const t = {
      moduleId: s.moduleId,
      resolveId: i,
      pkgData: n,
      pkgDirPath: getPackageDirPath(i, s.moduleId)
     };
     e(t);
    }
   }));
  }));
 })(T, 0, e), T;
}, createTestingSystem = () => {
 let e = 0, t = 0;
 const s = createSystem();
 s.platformPath = path__default.default, s.generateContentHash = (e, t) => {
  let s = require$$3.createHash("sha1").update(e).digest("hex").toLowerCase();
  return "number" == typeof t && (s = s.slice(0, t)), Promise.resolve(s);
 };
 const r = t => {
  const s = t;
  return (...t) => (e++, s.apply(s, t));
 }, i = e => {
  const s = e;
  return (...e) => (t++, s.apply(s, e));
 };
 if (s.access = r(s.access), s.accessSync = r(s.accessSync), s.homeDir = r(s.homeDir), 
 s.readFile = r(s.readFile), s.readFileSync = r(s.readFileSync), s.readDir = r(s.readDir), 
 s.readDirSync = r(s.readDirSync), s.stat = r(s.stat), s.statSync = r(s.statSync), 
 s.copyFile = i(s.copyFile), s.createDir = i(s.createDir), s.createDirSync = i(s.createDirSync), 
 s.removeFile = i(s.removeFile), s.removeFileSync = i(s.removeFileSync), s.writeFile = i(s.writeFile), 
 s.writeFileSync = i(s.writeFileSync), s.getCompilerExecutingPath = () => "bin/stencil.js", 
 Object.defineProperties(s, {
  diskReads: {
   get: () => e,
   set(t) {
    e = t;
   }
  },
  diskWrites: {
   get: () => t,
   set(e) {
    t = e;
   }
  }
 }), !function n(e) {
  return "diskReads" in e && "diskWrites" in e;
 }(s)) throw new Error("could not generate TestingSystem");
 return s;
};

class EventSpy {
 constructor(e) {
  this.eventName = e, this.events = [], this.cursor = 0, this.queuedHandler = [];
 }
 get length() {
  return this.events.length;
 }
 get firstEvent() {
  return this.events[0] || null;
 }
 get lastEvent() {
  return this.events[this.events.length - 1] || null;
 }
 next() {
  const e = this.cursor;
  this.cursor++;
  const t = this.events[e];
  if (t) return Promise.resolve({
   done: !1,
   value: t
  });
  {
   let t;
   const s = new Promise((e => t = e));
   return this.queuedHandler.push(t), s.then((() => ({
    done: !1,
    value: this.events[e]
   })));
  }
 }
 push(e) {
  this.events.push(e);
  const t = this.queuedHandler.shift();
  t && t();
 }
}

class E2EElement extends index_cjs.MockHTMLElement {
 _queueAction(e) {
  this._queuedActions.push(e);
 }
 constructor(e, t) {
  super(null, null), this._page = e, this._elmHandle = t, this._queuedActions = [], 
  e._e2eElements.push(this);
 }
 find(e) {
  return find(this._page, this._elmHandle, e);
 }
 findAll(e) {
  return findAll(this._page, this._elmHandle, e);
 }
 callMethod(e, ...t) {
  return this._queueAction({
   methodName: e,
   methodArgs: t
  }), this.e2eRunActions();
 }
 triggerEvent(e, t) {
  this._queueAction({
   eventName: e,
   eventInitDict: t
  });
 }
 async spyOnEvent(e) {
  const t = new EventSpy(e);
  return await addE2EListener(this._page, this._elmHandle, e, (e => {
   t.push(e);
  })), t;
 }
 async click(e) {
  await this._elmHandle.click(e), await this._page.waitForChanges();
 }
 async focus() {
  await this._elmHandle.focus(), await this._page.waitForChanges();
 }
 async hover() {
  await this._elmHandle.hover(), await this._page.waitForChanges();
 }
 async isVisible() {
  this._validate();
  let e = !1;
  try {
   const t = getPuppeteerExecution(this._elmHandle);
   e = await t.evaluate((e => new Promise((t => {
    window.requestAnimationFrame((() => {
     if (e.isConnected) {
      const s = window.getComputedStyle(e);
      s && "none" !== s.display && "hidden" !== s.visibility && "0" !== s.opacity ? window.requestAnimationFrame((() => {
       e.clientWidth, t(!0);
      })) : t(!1);
     } else t(!1);
    }));
   }))), this._elmHandle);
  } catch (e) {}
  return e;
 }
 waitForEvent(e) {
  return waitForEvent(this._page, e, this._elmHandle);
 }
 waitForVisible() {
  return new Promise(((e, t) => {
   const s = setInterval((async () => {
    await this.isVisible() && (clearInterval(s), clearTimeout(n), e());
   }), 10), r = "undefined" != typeof jasmine && jasmine.DEFAULT_TIMEOUT_INTERVAL ? .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL : 2500, i = new Error(`waitForVisible timed out: ${r}ms`), n = setTimeout((() => {
    clearTimeout(s), t(i);
   }), r);
  }));
 }
 waitForNotVisible() {
  return new Promise(((e, t) => {
   const s = setInterval((async () => {
    await this.isVisible() || (clearInterval(s), clearTimeout(n), e());
   }), 10), r = "undefined" != typeof jasmine && jasmine.DEFAULT_TIMEOUT_INTERVAL ? .5 * jasmine.DEFAULT_TIMEOUT_INTERVAL : 2500, i = new Error(`waitForNotVisible timed out: ${r}ms`), n = setTimeout((() => {
    clearTimeout(s), t(i);
   }), r);
  }));
 }
 isIntersectingViewport() {
  return this._elmHandle.isIntersectingViewport();
 }
 async press(e, t) {
  await this._elmHandle.press(e, t), await this._page.waitForChanges();
 }
 async tap() {
  await this._elmHandle.tap(), await this._page.waitForChanges();
 }
 async type(e, t) {
  await this._elmHandle.type(e, t), await this._page.waitForChanges();
 }
 async getProperty(e) {
  this._validate();
  const t = getPuppeteerExecution(this._elmHandle);
  return await t.evaluate(((e, t) => e[t]), this._elmHandle, e);
 }
 setProperty(e, t) {
  this._queueAction({
   setPropertyName: e,
   setPropertyValue: t
  });
 }
 getAttribute(e) {
  return this._validate(), super.getAttribute(e);
 }
 setAttribute(e, t) {
  this._queueAction({
   setAttributeName: e,
   setAttributeValue: t
  });
 }
 removeAttribute(e) {
  this._queueAction({
   removeAttribute: e
  });
 }
 toggleAttribute(e, t) {
  this._queueAction({
   toggleAttributeName: e,
   toggleAttributeForce: t
  });
 }
 get classList() {
  return {
   add: (...e) => {
    e.forEach((e => {
     this._queueAction({
      classAdd: e
     });
    }));
   },
   remove: (...e) => {
    e.forEach((e => {
     this._queueAction({
      classRemove: e
     });
    }));
   },
   toggle: e => {
    this._queueAction({
     classToggle: e
    });
   },
   contains: e => (this._validate(), super.className.split(" ").includes(e))
  };
 }
 get className() {
  return this._validate(), super.className;
 }
 set className(e) {
  this._queueAction({
   setPropertyName: "className",
   setPropertyValue: e
  });
 }
 get id() {
  return this._validate(), super.id;
 }
 set id(e) {
  this._queueAction({
   setPropertyName: "id",
   setPropertyValue: e
  });
 }
 get innerHTML() {
  return this._validate(), super.innerHTML;
 }
 set innerHTML(e) {
  this._queueAction({
   setPropertyName: "innerHTML",
   setPropertyValue: e
  });
 }
 get innerText() {
  return this._validate(), super.innerText;
 }
 set innerText(e) {
  this._queueAction({
   setPropertyName: "innerText",
   setPropertyValue: e
  });
 }
 get nodeValue() {
  return this._validate(), super.nodeValue;
 }
 set nodeValue(e) {
  "string" == typeof e && this._queueAction({
   setPropertyName: "nodeValue",
   setPropertyValue: e
  });
 }
 get outerHTML() {
  return this._validate(), super.outerHTML;
 }
 set outerHTML(e) {
  throw new Error("outerHTML is read-only");
 }
 get shadowRoot() {
  return this._validate(), super.shadowRoot;
 }
 set shadowRoot(e) {
  super.shadowRoot = e;
 }
 get tabIndex() {
  return this._validate(), super.tabIndex;
 }
 set tabIndex(e) {
  this._queueAction({
   setPropertyName: "tabIndex",
   setPropertyValue: e
  });
 }
 get textContent() {
  return this._validate(), super.textContent;
 }
 set textContent(e) {
  this._queueAction({
   setPropertyName: "textContent",
   setPropertyValue: e
  });
 }
 get title() {
  return this._validate(), super.title;
 }
 set title(e) {
  this._queueAction({
   setPropertyName: "title",
   setPropertyValue: e
  });
 }
 async getComputedStyle(e) {
  const t = await this._page.evaluate(((e, t) => {
   const s = {}, r = window.getComputedStyle(e, t);
   return Object.keys(r).forEach((e => {
    if (isNaN(e)) {
     const t = r[e];
     null != t && (s[e] = t);
    } else {
     const t = r[e];
     if (t.includes("-")) {
      const e = r.getPropertyValue(t);
      null != e && (s[t] = e);
     }
    }
   })), s;
  }), this._elmHandle, e);
  return t.getPropertyValue = e => t[e], t;
 }
 async e2eRunActions() {
  if (0 === this._queuedActions.length) return;
  const e = getPuppeteerExecution(this._elmHandle), t = await e.evaluate(((e, t) => e.componentOnReady().then((() => {
   let s = null;
   return t.forEach((t => {
    if (t.methodName) s = e[t.methodName].apply(e, t.methodArgs); else if (t.setPropertyName) e[t.setPropertyName] = t.setPropertyValue; else if (t.setAttributeName) e.setAttribute(t.setAttributeName, t.setAttributeValue); else if (t.removeAttribute) e.removeAttribute(t.removeAttribute); else if (t.toggleAttributeName) "boolean" == typeof t.toggleAttributeForce ? e.toggleAttribute(t.toggleAttributeName, t.toggleAttributeForce) : e.toggleAttribute(t.toggleAttributeName); else if (t.classAdd) e.classList.add(t.classAdd); else if (t.classRemove) e.classList.remove(t.classRemove); else if (t.classToggle) e.classList.toggle(t.classToggle); else if (t.eventName) {
     const s = t.eventInitDict || {};
     "boolean" != typeof s.bubbles && (s.bubbles = !0), "boolean" != typeof s.cancelable && (s.cancelable = !0), 
     "boolean" != typeof s.composed && (s.composed = !0);
     const r = new CustomEvent(t.eventName, s);
     e.dispatchEvent(r);
    }
   })), s && "function" == typeof s.then ? s.then((e => e)) : s;
  }))), this._elmHandle, this._queuedActions);
  return this._queuedActions.length = 0, t;
 }
 async e2eSync() {
  const e = getPuppeteerExecution(this._elmHandle), {outerHTML: t, shadowRootHTML: s} = await e.evaluate((e => ({
   outerHTML: e.outerHTML,
   shadowRootHTML: e.shadowRoot ? e.shadowRoot.innerHTML : null
  })), this._elmHandle);
  "string" == typeof s ? (this.shadowRoot = index_cjs.parseHtmlToFragment(s), this.shadowRoot.host = this) : this.shadowRoot = null;
  const r = index_cjs.parseHtmlToFragment(t).firstElementChild;
  for (this.nodeName = r.nodeName, this.attributes = index_cjs.cloneAttributes(r.attributes); this.childNodes.length > 0; ) this.removeChild(this.childNodes[0]);
  for (;r.childNodes.length > 0; ) this.appendChild(r.childNodes[0]);
 }
 _validate() {
  if (this._queuedActions.length > 0) throw new Error("await page.waitForChanges() must be called before reading element information");
 }
 async e2eDispose() {
  this._elmHandle && (await this._elmHandle.dispose(), this._elmHandle = null);
  const e = this._page._e2eElements.indexOf(this);
  e > -1 && this._page._e2eElements.splice(e, 1), this._page = null;
 }
}

const env = process.env;

Object.defineProperty(exports, "MockHeaders", {
 enumerable: !0,
 get: function() {
  return index_cjs.MockHeaders;
 }
}), Object.defineProperty(exports, "MockRequest", {
 enumerable: !0,
 get: function() {
  return index_cjs.MockRequest;
 }
}), Object.defineProperty(exports, "MockResponse", {
 enumerable: !0,
 get: function() {
  return index_cjs.MockResponse;
 }
}), exports.createTesting = async e => {
 e = function t(e) {
  return e.buildEs5 = !1, e.devMode = !0, e.minifyCss = !1, e.minifyJs = !1, e.hashFileNames = !1, 
  e.validateTypes = !1, e._isTesting = !0, e.buildDist = !0, e.flags.serve = !1, e.flags.open = !1, 
  e.outputTargets.forEach((e => {
   "www" === e.type && (e.serviceWorker = null);
  })), e.flags.args.includes("--watchAll") && (e.watch = !0), e;
 }(e);
 const {createCompiler: s} = require("../compiler/stencil.js"), r = await s(e);
 let i, n;
 const o = async () => {
  const t = [];
  e && (e.sys && e.sys.destroy && t.push(e.sys.destroy()), e = null), i && (i.close && t.push(i.close()), 
  i = null), n && (n.close && t.push(n.close()), n = null), await Promise.all(t);
 };
 return {
  destroy: o,
  run: async (t = {}) => {
   let s, a = !1, l = !1, c = null;
   const u = [];
   try {
    if (!t.spec && !t.e2e) return e.logger.error("Testing requires either the --spec or --e2e command line flags, or both. For example, to run unit tests, use the command: stencil test --spec"), 
    !1;
    if (s = process.env, t.e2e && (u.push("e2e"), s.__STENCIL_E2E_TESTS__ = "true"), 
    t.spec && (u.push("spec"), s.__STENCIL_SPEC_TESTS__ = "true"), e.logger.info(e.logger.magenta(`testing ${u.join(" and ")} files${e.watch ? " (watch)" : ""}`)), 
    a = !(!t.e2e || !t.screenshot), a && (s.__STENCIL_SCREENSHOT__ = "true", t.updateScreenshot ? e.logger.info(e.logger.magenta("updating master screenshots")) : e.logger.info(e.logger.magenta("comparing against master screenshots"))), 
    t.e2e) {
     let t = null;
     e.outputTargets.forEach((e => {
      e.empty = !1;
     }));
     const a = !(e.flags && !1 === e.flags.build);
     if (a && e.watch && (c = await r.createWatcher()), a) if (c) {
      const e = c;
      t = new Promise((t => {
       const s = e.on("buildFinish", (e => {
        s(), t(e);
       }));
      })), e.start();
     } else t = r.build();
     e.devServer.openBrowser = !1, e.devServer.gzip = !1, e.devServer.reloadStrategy = null;
     const l = await Promise.all([ index_js.start(e.devServer, e.logger), startPuppeteerBrowser(e) ]);
     if (i = l[0], n = l[1], t) {
      const s = await t;
      if (!s || !e.watch && hasError(s && s.diagnostics)) return await o(), !1;
     }
     if (i) {
      s.__STENCIL_BROWSER_URL__ = i.browserUrl, e.logger.debug(`e2e dev server url: ${s.__STENCIL_BROWSER_URL__}`), 
      s.__STENCIL_APP_SCRIPT_URL__ = function h(e, t) {
       return getAppUrl(e, t, `${e.fsNamespace}.esm.js`);
      }(e, i.browserUrl), e.logger.debug(`e2e app script url: ${s.__STENCIL_APP_SCRIPT_URL__}`);
      const t = function p(e, t) {
       return e.globalStyle ? getAppUrl(e, t, `${e.fsNamespace}.css`) : null;
      }(e, i.browserUrl);
      t && (s.__STENCIL_APP_STYLE_URL__ = t, e.logger.debug(`e2e app style url: ${s.__STENCIL_APP_STYLE_URL__}`));
     }
    }
   } catch (t) {
    return e.logger.error(t), !1;
   }
   try {
    if (a) {
     const t = getJestFacade().getRunJestScreenshot();
     l = await t(e, s);
    } else {
     const t = getJestFacade().getJestCliRunner();
     l = await t(e, s);
    }
    e.logger.info(""), c && await c.close();
   } catch (t) {
    e.logger.error(t);
   }
   return l;
  }
 };
}, exports.getCreateJestPuppeteerEnvironment = () => getJestFacade().getCreateJestPuppeteerEnvironment(), 
exports.getCreateJestTestRunner = () => getJestFacade().getCreateJestTestRunner(), 
exports.getJestPreprocessor = () => getJestFacade().getJestPreprocessor(), exports.getJestPreset = () => getJestFacade().getJestPreset(), 
exports.getJestSetupTestFramework = () => getJestFacade().getJestSetupTestFramework(), 
exports.mockBuildCtx = function mockBuildCtx(e, t) {
 const s = e || mockValidatedConfig(), r = t || mockCompilerCtx(s);
 return new BuildContext(s, r);
}, exports.mockCompilerCtx = mockCompilerCtx, exports.mockCompilerSystem = function mockCompilerSystem() {
 return createTestingSystem();
}, exports.mockConfig = mockConfig, exports.mockDocument = function mockDocument(e = null) {
 return new index_cjs.MockWindow(e).document;
}, exports.mockFetch = mockFetch, exports.mockLoadConfigInit = e => ({
 config: {},
 configPath: void 0,
 initTsConfig: !0,
 logger: void 0,
 sys: void 0,
 ...e
}), exports.mockLogger = mockLogger, exports.mockModule = (e = {}) => ({
 cmps: [],
 coreRuntimeApis: [],
 outputTargetCoreRuntimeApis: {},
 collectionName: "",
 dtsFilePath: "",
 excludeFromCollection: !1,
 externalImports: [],
 htmlAttrNames: [],
 htmlTagNames: [],
 htmlParts: [],
 isCollectionDependency: !1,
 isLegacy: !1,
 jsFilePath: "",
 localImports: [],
 originalImports: [],
 originalCollectionComponentPath: "",
 potentialCmpRefs: [],
 sourceFilePath: "",
 staticSourceFile: "",
 staticSourceFileText: "",
 sourceMapPath: "",
 sourceMapFileText: "",
 hasVdomAttribute: !1,
 hasVdomClass: !1,
 hasVdomFunctional: !1,
 hasVdomKey: !1,
 hasVdomListener: !1,
 hasVdomPropOrAttr: !1,
 hasVdomRef: !1,
 hasVdomRender: !1,
 hasVdomStyle: !1,
 hasVdomText: !1,
 hasVdomXlink: !1,
 ...e
}), exports.mockValidatedConfig = mockValidatedConfig, exports.mockWindow = function mockWindow(e) {
 return new index_cjs.MockWindow(e);
}, exports.newE2EPage = async function newE2EPage(e = {}) {
 if (!global.__NEW_TEST_PAGE__) throw new Error("newE2EPage() is only available from E2E tests, and ran with the --e2e cmd line flag.");
 const t = await global.__NEW_TEST_PAGE__(), s = [];
 try {
  t._e2eElements = [], t._e2eGoto = t.goto, t._e2eClose = t.close, await t.setCacheEnabled(!1), 
  await initPageEvents(t), function r(e) {
   const t = process.env;
   "true" === t.__STENCIL_SCREENSHOT__ ? e.compareScreenshot = (s, r) => {
    const i = global;
    let n, o = "", a = "";
    if (i.currentSpec && ("string" == typeof i.currentSpec.fullName && (o = i.currentSpec.fullName), 
    "string" == typeof i.currentSpec.testPath && (a = i.currentSpec.testPath)), "string" == typeof s ? (o.length > 0 ? o += ", " + s : o = s, 
    "object" == typeof r && (n = r)) : "object" == typeof s && (n = s), o = o.trim(), 
    n = n || {}, !o) throw new Error(`Invalid screenshot description in "${a}"`);
    if (i.screenshotDescriptions.has(o)) throw new Error(`Screenshot description "${o}" found in "${a}" cannot be used for multiple screenshots and must be unique. To make screenshot descriptions unique within the same test, use the first argument to "compareScreenshot", such as "compareScreenshot('more to the description')".`);
    return i.screenshotDescriptions.add(o), async function l(e, t, s, r, i) {
     if ("string" != typeof t.__STENCIL_EMULATE__) throw new Error("compareScreenshot, missing screenshot emulate env var");
     if ("string" != typeof t.__STENCIL_SCREENSHOT_BUILD__) throw new Error("compareScreenshot, missing screen build env var");
     const n = JSON.parse(t.__STENCIL_EMULATE__), o = JSON.parse(t.__STENCIL_SCREENSHOT_BUILD__);
     await function a(e) {
      return new Promise((t => setTimeout(t, e)));
     }(o.timeoutBeforeScreenshot), await e.evaluate((() => new Promise((e => {
      window.requestAnimationFrame((() => {
       e();
      }));
     }))));
     let l = n.viewport.width, c = n.viewport.height;
     i && i.clip && ("number" == typeof i.clip.width && (l = i.clip.width), "number" == typeof i.clip.height && (c = i.clip.height));
     const u = function h(e, {width: t, height: s}) {
      const r = {
       type: "png",
       fullPage: e.fullPage,
       omitBackground: e.omitBackground,
       encoding: "binary"
      };
      return e.clip ? r.clip = {
       x: e.clip.x,
       y: e.clip.y,
       width: e.clip.width,
       height: e.clip.height
      } : r.clip = {
       x: 0,
       y: 0,
       width: t,
       height: s
      }, r;
     }(i, {
      width: l,
      height: c
     }), p = await e.screenshot(u), d = "number" == typeof i.pixelmatchThreshold ? i.pixelmatchThreshold : o.pixelmatchThreshold;
     return await compareScreenshot(n, o, p, s, l, c, r, d);
    }(e, t, o, a, n);
   } : e.compareScreenshot = async () => ({
    id: "placeholder",
    mismatchedPixels: 0,
    allowableMismatchedPixels: 1,
    allowableMismatchedRatio: 1,
    desc: "",
    width: 1,
    height: 1,
    deviceScaleFactor: 1
   });
  }(t);
  let r = null;
  t.close = async e => {
   try {
    if (Array.isArray(t._e2eElements)) {
     const e = t._e2eElements.map((async e => {
      "function" == typeof e.e2eDispose && await e.e2eDispose();
     }));
     await Promise.all(e);
    }
   } catch (e) {}
   const s = () => {
    throw new Error("The page was already closed");
   };
   t._e2eElements = s, t._e2eEvents = s, t._e2eGoto = s, t.find = s, t.debugger = s, 
   t.findAll = s, t.compareScreenshot = s, t.setContent = s, t.spyOnEvent = s, t.waitForChanges = s, 
   t.waitForEvent = s;
   try {
    t.isClosed() || await t._e2eClose(e);
   } catch (e) {}
  };
  const i = async () => (r || (r = t.evaluateHandle((() => document))), (await r).asElement());
  t.find = async e => {
   const s = await i();
   return find(t, s, e);
  }, t.findAll = async e => {
   const s = await i();
   return findAll(t, s, e);
  }, t.waitForEvent = async e => {
   const s = await i();
   return waitForEvent(t, e, s);
  }, t.getDiagnostics = () => s, t.waitForChanges = waitForChanges.bind(null, t), 
  t.debugger = () => {
   if ("true" !== env.__STENCIL_E2E_DEVTOOLS__) throw new Error("Set the --devtools flag in order to use E2EPage.debugger()");
   return t.evaluate((() => new Promise((e => {
    e();
   }))));
  };
  const n = !0 === e.failOnConsoleError, o = !0 === e.failOnNetworkError;
  t.on("console", (e => {
   if ("error" === e.type() && (s.push({
    type: "error",
    message: e.text(),
    location: e.location().url
   }), n)) throw new Error(serializeConsoleMessage(e));
   !function t(e) {
    const t = serializeConsoleMessage(e), s = e.type(), r = "warning" === s ? "warn" : s;
    "debug" !== r && ("function" == typeof console[r] ? console[r](t) : console.log(s, t));
   }(e);
  })), t.on("pageerror", (e => {
   throw s.push({
    type: "pageerror",
    message: e.message,
    location: e.stack
   }), e;
  })), t.on("requestfailed", (e => {
   if (s.push({
    type: "requestfailed",
    message: e.failure().errorText,
    location: e.url()
   }), o) throw new Error(e.failure().errorText);
   console.error("requestfailed", e.url());
  })), "string" == typeof e.html ? await e2eSetContent(t, e.html, {
   waitUntil: e.waitUntil
  }) : "string" == typeof e.url ? await e2eGoTo(t, e.url, {
   waitUntil: e.waitUntil
  }) : (t.goto = e2eGoTo.bind(null, t), t.setContent = e2eSetContent.bind(null, t));
 } catch (e) {
  throw t && (t.isClosed() || await t.close()), e;
 }
 return t;
}, exports.newSpecPage = async function newSpecPage(e) {
 var t;
 if (null == e) throw new Error("NewSpecPageOptions required");
 testing.resetPlatform(null !== (t = e.platform) && void 0 !== t ? t : {}), resetBuildConditionals(appData.BUILD), 
 Array.isArray(e.components) && testing.registerComponents(e.components), e.hydrateClientSide && (e.includeAnnotations = !0), 
 e.hydrateServerSide ? (e.includeAnnotations = !0, testing.setSupportsShadowDom(!1)) : (e.includeAnnotations = !!e.includeAnnotations, 
 !1 === e.supportsShadowDom ? testing.setSupportsShadowDom(!1) : testing.setSupportsShadowDom(!0)), 
 appData.BUILD.cssAnnotations = e.includeAnnotations;
 const s = new Set;
 testing.win.__stencil_spec_options = e;
 const r = testing.win.document, i = {
  win: testing.win,
  doc: r,
  body: r.body,
  build: appData.BUILD,
  styles: testing.styles,
  setContent: e => (r.body.innerHTML = e, testing.flushAll()),
  waitForChanges: testing.flushAll,
  flushLoadModule: testing.flushLoadModule,
  flushQueue: testing.flushQueue
 }, n = e.components.map((e => {
  if (null == e.COMPILER_META) throw new Error('Invalid component class: Missing static "COMPILER_META" property.');
  s.add(e.COMPILER_META.tagName), e.isProxied = !1, function t(e) {
   var t, s, r, i, n, o;
   "function" == typeof (null === (t = e.prototype) || void 0 === t ? void 0 : t.__componentWillLoad) && (e.prototype.componentWillLoad = e.prototype.__componentWillLoad, 
   e.prototype.__componentWillLoad = null), "function" == typeof (null === (s = e.prototype) || void 0 === s ? void 0 : s.__componentWillUpdate) && (e.prototype.componentWillUpdate = e.prototype.__componentWillUpdate, 
   e.prototype.__componentWillUpdate = null), "function" == typeof (null === (r = e.prototype) || void 0 === r ? void 0 : r.__componentWillRender) && (e.prototype.componentWillRender = e.prototype.__componentWillRender, 
   e.prototype.__componentWillRender = null), "function" == typeof (null === (i = e.prototype) || void 0 === i ? void 0 : i.componentWillLoad) && (e.prototype.__componentWillLoad = e.prototype.componentWillLoad, 
   e.prototype.componentWillLoad = function() {
    const e = this.__componentWillLoad();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   }), "function" == typeof (null === (n = e.prototype) || void 0 === n ? void 0 : n.componentWillUpdate) && (e.prototype.__componentWillUpdate = e.prototype.componentWillUpdate, 
   e.prototype.componentWillUpdate = function() {
    const e = this.__componentWillUpdate();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   }), "function" == typeof (null === (o = e.prototype) || void 0 === o ? void 0 : o.componentWillRender) && (e.prototype.__componentWillRender = e.prototype.componentWillRender, 
   e.prototype.componentWillRender = function() {
    const e = this.__componentWillRender();
    return null != e && "function" == typeof e.then ? testing.writeTask((() => e)) : testing.writeTask((() => Promise.resolve())), 
    e;
   });
  }(e);
  const r = `${e.COMPILER_META.tagName}.${Math.round(899999 * Math.random()) + 1e5}`, i = e.COMPILER_META.styles;
  if (Array.isArray(i)) if (i.length > 1) {
   const t = {};
   i.forEach((e => {
    t[e.modeName] = e.styleStr;
   })), e.style = t;
  } else 1 === i.length && (e.style = i[0].styleStr);
  testing.registerModule(r, e);
  const n = ((e, t) => [ e, t.map((e => ((e, t) => {
   let s = 0;
   "shadow" === e.encapsulation ? (s |= 1, e.shadowDelegatesFocus && (s |= 16)) : "scoped" === e.encapsulation && (s |= 2), 
   e.formAssociated && (s |= 64), "shadow" !== e.encapsulation && e.htmlTagNames.includes("slot") && (s |= 4), 
   e.hasMode && (s |= 32);
   const r = formatComponentRuntimeMembers(e, t), i = formatHostListeners(e), n = formatComponentRuntimeWatchers(e);
   return trimFalsy([ s, e.tagName, Object.keys(r).length > 0 ? r : void 0, i.length > 0 ? i : void 0, Object.keys(n).length > 0 ? n : void 0 ]);
  })(e, !0))) ])(r, [ e.COMPILER_META ]);
  return n;
 })), o = (e => {
  const t = e.some((e => e.htmlTagNames.includes("slot"))), s = e.some((e => "shadow" === e.encapsulation)), r = e.some((e => "shadow" !== e.encapsulation && e.htmlTagNames.includes("slot"))), i = {
   allRenderFn: e.every((e => e.hasRenderFn)),
   cmpDidLoad: e.some((e => e.hasComponentDidLoadFn)),
   cmpShouldUpdate: e.some((e => e.hasComponentShouldUpdateFn)),
   cmpDidUnload: e.some((e => e.hasComponentDidUnloadFn)),
   cmpDidUpdate: e.some((e => e.hasComponentDidUpdateFn)),
   cmpDidRender: e.some((e => e.hasComponentDidRenderFn)),
   cmpWillLoad: e.some((e => e.hasComponentWillLoadFn)),
   cmpWillUpdate: e.some((e => e.hasComponentWillUpdateFn)),
   cmpWillRender: e.some((e => e.hasComponentWillRenderFn)),
   formAssociated: e.some((e => e.formAssociated)),
   connectedCallback: e.some((e => e.hasConnectedCallbackFn)),
   disconnectedCallback: e.some((e => e.hasDisconnectedCallbackFn)),
   element: e.some((e => e.hasElement)),
   event: e.some((e => e.hasEvent)),
   hasRenderFn: e.some((e => e.hasRenderFn)),
   lifecycle: e.some((e => e.hasLifecycle)),
   asyncLoading: !1,
   hostListener: e.some((e => e.hasListener)),
   hostListenerTargetWindow: e.some((e => e.hasListenerTargetWindow)),
   hostListenerTargetDocument: e.some((e => e.hasListenerTargetDocument)),
   hostListenerTargetBody: e.some((e => e.hasListenerTargetBody)),
   hostListenerTargetParent: e.some((e => e.hasListenerTargetParent)),
   hostListenerTarget: e.some((e => e.hasListenerTarget)),
   member: e.some((e => e.hasMember)),
   method: e.some((e => e.hasMethod)),
   mode: e.some((e => e.hasMode)),
   observeAttribute: e.some((e => e.hasAttribute)),
   prop: e.some((e => e.hasProp)),
   propBoolean: e.some((e => e.hasPropBoolean)),
   propNumber: e.some((e => e.hasPropNumber)),
   propString: e.some((e => e.hasPropString)),
   propMutable: e.some((e => e.hasPropMutable)),
   reflect: e.some((e => e.hasReflect)),
   scoped: e.some((e => "scoped" === e.encapsulation)),
   shadowDom: s,
   shadowDelegatesFocus: s && e.some((e => e.shadowDelegatesFocus)),
   slot: t,
   slotRelocation: r,
   state: e.some((e => e.hasState)),
   style: e.some((e => e.hasStyle)),
   svg: e.some((e => e.htmlTagNames.includes("svg"))),
   updatable: e.some((e => e.isUpdateable)),
   vdomAttribute: e.some((e => e.hasVdomAttribute)),
   vdomXlink: e.some((e => e.hasVdomXlink)),
   vdomClass: e.some((e => e.hasVdomClass)),
   vdomFunctional: e.some((e => e.hasVdomFunctional)),
   vdomKey: e.some((e => e.hasVdomKey)),
   vdomListener: e.some((e => e.hasVdomListener)),
   vdomPropOrAttr: e.some((e => e.hasVdomPropOrAttr)),
   vdomRef: e.some((e => e.hasVdomRef)),
   vdomRender: e.some((e => e.hasVdomRender)),
   vdomStyle: e.some((e => e.hasVdomStyle)),
   vdomText: e.some((e => e.hasVdomText)),
   watchCallback: e.some((e => e.hasWatchCallback)),
   taskQueue: !0
  };
  return i.asyncLoading = i.cmpWillUpdate || i.cmpWillLoad || i.cmpWillRender, i.vdomAttribute = i.vdomAttribute || i.reflect, 
  i.vdomPropOrAttr = i.vdomPropOrAttr || i.reflect, i;
 })(e.components.map((e => e.COMPILER_META)));
 if (e.strictBuild ? Object.assign(appData.BUILD, o) : Object.keys(o).forEach((e => {
  !0 === o[e] && (appData.BUILD[e] = !0);
 })), appData.BUILD.asyncLoading = !0, e.hydrateClientSide ? (appData.BUILD.hydrateClientSide = !0, 
 appData.BUILD.hydrateServerSide = !1) : e.hydrateServerSide && (appData.BUILD.hydrateServerSide = !0, 
 appData.BUILD.hydrateClientSide = !1), appData.BUILD.cloneNodeFix = !1, appData.BUILD.shadowDomShim = !1, 
 appData.BUILD.attachStyles = !!e.attachStyles, "string" == typeof e.url && (i.win.location.href = e.url), 
 "string" == typeof e.direction && i.doc.documentElement.setAttribute("dir", e.direction), 
 "string" == typeof e.language && i.doc.documentElement.setAttribute("lang", e.language), 
 "string" == typeof e.cookie) try {
  i.doc.cookie = e.cookie;
 } catch (e) {}
 if ("string" == typeof e.referrer) try {
  i.doc.referrer = e.referrer;
 } catch (e) {}
 if ("string" == typeof e.userAgent) try {
  i.win.navigator.userAgent = e.userAgent;
 } catch (e) {}
 if (testing.bootstrapLazy(n), "function" == typeof e.template) {
  const t = {
   $ancestorComponent$: void 0,
   $flags$: 0,
   $modeName$: void 0,
   $cmpMeta$: {
    $flags$: 0,
    $tagName$: "body"
   },
   $hostElement$: i.body
  };
  testing.renderVdom(t, e.template());
 } else "string" == typeof e.html && (i.body.innerHTML = e.html);
 !1 !== e.flushQueue && await i.waitForChanges();
 let a = null;
 return Object.defineProperty(i, "root", {
  get() {
   if (null == a && (a = findRootComponent(s, i.body)), null != a) return a;
   const e = i.body.firstElementChild;
   return null != e ? e : null;
  }
 }), Object.defineProperty(i, "rootInstance", {
  get() {
   const e = testing.getHostRef(i.root);
   return null != e ? e.$lazyInstance$ : null;
  }
 }), e.hydrateServerSide && testing.insertVdomAnnotations(r, []), e.autoApplyChanges && (testing.startAutoApplyChanges(), 
 i.waitForChanges = () => (console.error('waitForChanges() cannot be used manually if the "startAutoApplyChanges" option is enabled'), 
 Promise.resolve())), i;
}, exports.setupConsoleMocker = function setupConsoleMocker() {
 function e() {
  console.log = t, console.warn = s, console.error = r;
 }
 const t = console.log, s = console.warn, r = console.error;
 return afterAll((() => {
  e();
 })), {
  setupConsoleMocks: function i() {
   const e = jest.fn(), t = jest.fn(), s = jest.fn();
   return console.log = e, console.warn = t, console.error = s, {
    logMock: e,
    warnMock: t,
    errorMock: s
   };
  },
  teardownConsoleMocks: e
 };
}, exports.shuffleArray = function shuffleArray(e) {
 let t, s, r = e.length;
 for (;0 !== r; ) s = Math.floor(Math.random() * r), r -= 1, t = e[r], e[r] = e[s], 
 e[s] = t;
 return e;
}, exports.transpile = transpile;