import type { ReactComponentOrElement } from '../models/ReactComponentOrElement';
import type { HookOverlayOptions } from './HookOverlayOptions';
interface OverlayBase extends HTMLElement {
    present: () => Promise<void>;
    dismiss: (data?: any, role?: string | undefined) => Promise<boolean>;
}
export declare function useOverlay<OptionsType, OverlayType extends OverlayBase>(displayName: string, controller: {
    create: (options: OptionsType) => Promise<OverlayType>;
}, defineCustomElement: () => void, component: ReactComponentOrElement, componentProps?: any): {
    present: (options: OptionsType & HookOverlayOptions) => Promise<void>;
    dismiss: (data?: any, role?: string) => Promise<void>;
};
export {};
