import type { PopoverOptions } from '@ionic/core/components';
import type { ReactComponentOrElement } from '../models/ReactComponentOrElement';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonPicker component
 * @param component The component that the popover will show. Can be a React Component, a functional component, or a JSX Element
 * @param componentProps The props that will be passed to the component, if required
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonPopover(component: ReactComponentOrElement, componentProps?: any): UseIonPopoverResult;
export type UseIonPopoverResult = [
    (options?: Omit<PopoverOptions, 'component' | 'componentProps'> & HookOverlayOptions) => void,
    /**
     * Dismisses the popover
     */
    (data?: any, role?: string) => void
];
