import type { ActionSheetButton, ActionSheetOptions } from '@ionic/core/components';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonActionSheet component
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonActionSheet(): UseIonActionSheetResult;
export type UseIonActionSheetResult = [
    {
        /**
         * Presents the action sheet
         * @param buttons An array of buttons for the action sheet
         * @param header Optional - Title for the action sheet
         */
        (buttons: ActionSheetButton[], header?: string | undefined): Promise<void>;
        /**
         * Presents the action sheet
         * @param options The options to pass to the IonActionSheet
         */
        (options: ActionSheetOptions & HookOverlayOptions): Promise<void>;
    },
    /**
     * Dismisses the action sheet
     */
    () => Promise<void>
];
