import type { JSX as LocalJSX } from '@ionic/core/components';
import React from 'react';
import { NavContext } from '../../contexts/NavContext';
import type { IonTabsContextState } from './IonTabsContext';
declare global {
    namespace JSX {
        interface IntrinsicElements {
            'ion-tabs': any;
        }
    }
}
type ChildFunction = (ionTabContext: IonTabsContextState) => React.ReactNode;
interface Props extends LocalJSX.IonTabs {
    className?: string;
    children: ChildFunction | React.ReactNode;
}
export declare const IonTabs: {
    new (props: Props): {
        context: React.ContextType<typeof NavContext>;
        routerOutletRef: React.Ref<HTMLIonRouterOutletElement>;
        selectTabHandler?: ((tag: string) => boolean) | undefined;
        tabBarRef: React.RefObject<any>;
        ionTabContextState: IonTabsContextState;
        componentDidMount(): void;
        render(): React.JSX.Element;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<Props>) => {} | Pick<{}, K> | null) | Pick<{}, K> | null, callback?: (() => void) | undefined): void;
        forceUpdate(callback?: (() => void) | undefined): void;
        readonly props: Readonly<Props> & Readonly<{
            children?: React.ReactNode;
        }>;
        state: Readonly<{}>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        shouldComponentUpdate?(nextProps: Readonly<Props>, nextState: Readonly<{}>, nextContext: any): boolean;
        componentWillUnmount?(): void;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<Props>, prevState: Readonly<{}>): any;
        componentDidUpdate?(prevProps: Readonly<Props>, prevState: Readonly<{}>, snapshot?: any): void;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<Props>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<Props>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<Props>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<Props>, nextState: Readonly<{}>, nextContext: any): void;
    };
    readonly contextType: React.Context<import("../../contexts/NavContext").NavContextState>;
};
export {};
