/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { expect } from "@playwright/test";
import { configs, test } from "../../../../utils/test/playwright/index";
/**
 * This behavior does not vary across directions
 */
configs({ directions: ['ltr'] }).forEach(({ title, screenshot, config }) => {
    test.describe(title('item: colors'), () => {
        test('should not have visual regressions', async ({ page }) => {
            await page.goto(`/src/components/item/test/colors`, config);
            await page.setIonViewport();
            await expect(page).toHaveScreenshot(screenshot(`item-colors-diff`));
        });
    });
});
