/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { Host, h } from "@stencil/core";
import { getIonMode } from "../../global/ionic-global";
export class Grid {
    constructor() {
        this.fixed = false;
    }
    render() {
        const mode = getIonMode(this);
        return (h(Host, { key: '265ab989098511c0b7e7d99edc792081f3ac7dfe', class: {
                [mode]: true,
                'grid-fixed': this.fixed,
            } }, h("slot", { key: '83e3ea4d1a60d1a6dab6b592e70a98924c0cfd7c' })));
    }
    static get is() { return "ion-grid"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["grid.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["grid.css"]
        };
    }
    static get properties() {
        return {
            "fixed": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the grid will have a fixed width based on the screen size."
                },
                "attribute": "fixed",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
