<?php


namespace App\Http\Controllers;



use Illuminate\Http\Request;
use App\Models\FcmToken;
use Illuminate\Support\Facades\Http;
use Google\Client;


class NotificationController extends Controller
{
    // Save the user's FCM token
    public function saveToken(Request $request)
    {
        $request->validate([
            'login_id' => 'required',
            'fcm_token' => 'required',
        ]);

        FcmToken::updateOrCreate(
            ['login_id' => $request->login_id],
            ['fcm_token' => $request->fcm_token]
        );

        return response()->json(['status' => 'success']);
    }


    // Send notification to a specific login_id
    public function sendNotification(Request $request)
    {
        $request->validate([
            'login_id' => 'required',
            'title' => 'required',
            'body' => 'required',
        ]);

        // Fetch user token
        $token = FcmToken::where('login_id', $request->login_id)->value('fcm_token');

        if (!$token) {
            return response()->json(['error' => 'Token not found'], 404);
        }

       $client = new \Google\Client();


        $client->setAuthConfig(storage_path('app/firebase/grs-monit-firebase-adminsdk-fbsvc-a64366b3a1.json'));
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');

        $accessToken = $client->fetchAccessTokenWithAssertion()['access_token'];

        // FCM v1 endpoint
        $projectId = "grs-monit";
        $url = "https://fcm.googleapis.com/v1/projects/$projectId/messages:send";

        // Message Payload
        $data = [
            "message" => [
                "token" => $token,
                "notification" => [
                    "title" => $request->title,
                    "body" => $request->body,
                ],
                "webpush" => [
                    "fcm_options" => [
                        "link" => "https://grsystems.co.in"
                    ]
                ]
            ]
        ];

        // Send notification using Laravel HTTP client
        $response = Http::withHeaders([
            "Authorization" => "Bearer " . $accessToken,
            "Content-Type" => "application/json"
        ])->post($url, $data);

        return response()->json([
            "status" => "sent",
            "firebase_response" => $response->json()
        ]);
    }
}

