<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Request;
use App\Models\Users;
use App\Models\Employee;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Artisan;
use App\Models\NatureOfCallMaster;
use Illuminate\Http\Exceptions\ThrottleRequestsException;
use App\Models\FcmToken;
use Illuminate\Support\Facades\Http;

use DateTime;

class MobileAppController extends Controller
{
	
public function mainmenu(Request $request)
{
    $usertype = $request->input('usertype', 'employee'); // default type

    // --- Step 1: Get all top-level menus ---
    $mainMenus = DB::select("
        SELECT id, menu_name, icon_class, route_key, page_title, parent_id, sort_order, user_type
        FROM hrms_menus
        WHERE status = 'active'
          AND (user_type = ? OR user_type = 'all')
          AND parent_id IS NULL
        ORDER BY sort_order ASC
    ", [$usertype]);

    // --- Step 2: Get all submenus ---
    $subMenus = DB::select("
        SELECT id, menu_name, icon_class, route_key, page_title, parent_id, sort_order, user_type
        FROM hrms_menus
        WHERE status = 'active'
          AND (user_type = ? OR user_type = 'all')
          AND parent_id IS NOT NULL
        ORDER BY sort_order ASC
    ", [$usertype]);

    // --- Step 3: Group submenus by parent_id ---
    $children = [];
    foreach ($subMenus as $sub) {
        $children[$sub->parent_id][] = $sub;
    }

    // --- Step 4: Attach submenus to their parent ---
    foreach ($mainMenus as &$menu) {
        $menu->children = $children[$menu->id] ?? [];
    }

    // --- Step 5: Return response ---
    return response()->json([
        'status' => true,
        'usertype' => $usertype,
        'menus' => $mainMenus
    ]);
}
public function getDailyAttendance(Request $req) {
    $login = $req->login_id;
    $date  = $req->date;

    
    $punch = DB::table("hr_daily_atten")
        ->selectRaw("
            MIN(USERTIME) as clock_in,
            MAX(USERTIME) as clock_out
        ")
        ->where("LOGIN_ID", $login)
        ->whereDate("SDATE", $date)
        ->first();

    
    $total = null;
    if ($punch->clock_in && $punch->clock_out) {
        $total = DB::selectOne("
            SELECT TIMEDIFF(?, ?) AS total_hours
        ", [$punch->clock_out, $punch->clock_in])->total_hours;
    }

    return response()->json([
        "status" => 200,
        "message" => "Success",
        "data" => [
            "clock_in"    => $punch->clock_in ?? "â€”",
            "clock_out"   => $punch->clock_out ?? "â€”",
            "total_hours" => $total ?? "â€”"
        ]
    ]);
}
public function getMonthAttendance(Request $req)
{
    $login = $req->login_id;
    $year  = $req->year;
    $month = $req->month;

    $data = DB::table("hr_daily_atten")
        ->select(
            DB::raw("DATE(SDATE) as date"),
            DB::raw("MIN(USERTIME) as clock_in"),
            DB::raw("MAX(USERTIME) as clock_out")
        )
        ->where("LOGIN_ID", $login)
        ->whereYear("SDATE", $year)
        ->whereMonth("SDATE", $month)
        ->groupBy("date")
        ->orderBy("date", "ASC")
        ->get();

    return response()->json([
        "status" => 200,
        "message" => "Success",
        "month_data" => $data
    ]);
}
// public function sendPunchApprovalRequest(Request $request)
// {
    // $login_id = $request->login_id;

    // // Fetch employee name
    // $employee = DB::table('employee')
                    // ->where('CODE', $login_id)
                    // ->first();

    // $name = $employee ? $employee->NAME : "Employee";

    // $distance = round($request->distance, 2);

    // // --- Build Dynamic Notification Text ---
    // $notification = "$name has requested approval for an out-of-range punch. "
                  // . "They moved $distance meters away from the IN punch location.";

    // DB::table('punch_approval_requests')->insert([
        // 'login_id'         => $login_id,
        // 'date'             => Carbon::now('Asia/Kolkata')->format('Y-m-d'),
        // 'last_in_lat'      => $request->in_lat,
        // 'last_in_lon'      => $request->in_lon,
        // 'moved_lat'        => $request->out_lat,
        // 'moved_lon'        => $request->out_lon,
        // 'distance_m'       => $distance,
        // 'notification_text'=> $notification,  // ðŸ‘ˆ Store exact message
        // 'requested_on'     => now(),
        // 'status'           => 'PENDING'
    // ]);

    // return response()->json([
        // 'status_code' => 200,
        // 'message'     => 'SUCCESS',
        // 'text'        => 'Approval request sent successfully.'
    // ], 200);
// }
public function sendPunchApprovalRequest(Request $request)
{
    $login_id = $request->login_id;  // Employee login ID

    // Get employee details
    $employee = DB::table('employee')
                ->where('CODE', $login_id)
                ->first();

    if (!$employee) {
        return response()->json(['status_code' => 404, 'text' => 'Employee not found']);
    }

    $employeeName = $employee->NAME;
    $employeeBranch = $employee->BRANCH_CODE;
    $distance = round($request->distance, 2);

    // Build notification message
    $notificationBody = "$employeeName has requested approval for an out-of-range punch. "
                      . "They moved $distance meters from the IN punch location.";

    // Save request
    DB::table('punch_approval_requests')->insert([
        'login_id'         => $login_id,
        'date'             => today()->format('Y-m-d'),
        'last_in_lat'      => $request->in_lat,
        'last_in_lon'      => $request->in_lon,
        'moved_lat'        => $request->out_lat,
        'moved_lon'        => $request->out_lon,
        'distance_m'       => $distance,
        'notification_text'=> $notificationBody,
        'requested_on'     => now(),
        'status'           => 'PENDING'
    ]);

    // STEP 1: Find all admins assigned to this employee's branch
    $admins = DB::table('branch_mapping')
                ->where('branch', $employeeBranch)
                ->where('status', 1)
                ->pluck('code'); // these are admin login_ids

    if ($admins->isEmpty()) {
        return response()->json([
            'status_code' => 200,
            'text' => 'Request saved, but no admin mapped to this branch.'
        ]);
    }

    // STEP 2: Send notification to each admin
    foreach ($admins as $adminId) {

        $token = FcmToken::where('login_id', $adminId)->value('fcm_token');

        if (!$token) continue;

        $client = new \Google\Client();
        $client->setAuthConfig(storage_path('app/firebase/grs-monit-firebase-adminsdk-fbsvc-a64366b3a1.json'));
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $accessToken = $client->fetchAccessTokenWithAssertion()['access_token'];

        $url = "https://fcm.googleapis.com/v1/projects/grs-monit/messages:send";

        $message = [
            "message" => [
                "token" => $token,
                "notification" => [
                    "title" => "Punch Approval Request",
                    "body"  => $notificationBody,
                ],
                "webpush" => [
                    "fcm_options" => [
                        "link" => "http://localhost:3000/punch-approvals"
                    ]
                ]
            ]
        ];

        Http::withHeaders([
            "Authorization" => "Bearer " . $accessToken,
            "Content-Type" => "application/json"
        ])->post($url, $message);
    }

    return response()->json([
        'status_code' => 200,
        'text' => 'Approval request sent and notification pushed to admin(s).'
    ]);
}

public function getPendingPunchRequests(Request $request)
{
    $admin_code = $request->login_id;

    $branches = DB::table('branch_mapping')
        ->where('code', $admin_code)
        ->where('status', 1)
        ->pluck('branch');

    if ($branches->isEmpty()) {
        return ['status_code' => 404, 'text' => 'No branch assigned.'];
    }

    $employees = DB::table('employee')
        ->whereIn('BRANCH_CODE', $branches)
        ->pluck('CODE');

   $pending = DB::table('punch_approval_requests')
    ->whereIn('login_id', $employees)
    ->where('status', 'PENDING')
    ->whereDate('date', today())
    ->orderByDesc('id')
    ->get();


    return [
        'status_code' => 200,
        'requests'    => $pending
    ];
}


public function approveRejectPunch(Request $request)
{
    $id = $request->id;
    $status = $request->status;  // APPROVED / REJECTED
    $remark = $request->remark;

    DB::table('punch_approval_requests')
        ->where('id', $id)
        ->update([
            'status' => $status,
            'remark' => $remark,
            'approved_on' => now(),
            'approved_by' => $request->admin_id
        ]);

    return [
        'status_code' => 200,
        'text' => "Request $status successfully"
    ];
}
public function getCurrentPunchStatus(Request $req)
{
    $login_id = $req->login_id;
    $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

    $emp = DB::table('employee')->where('code', $login_id)->first();
    if (!$emp) {
        return response()->json([
            "status_code" => 400,
            "text" => "Invalid employee"
        ]);
    }

    $card = $emp->SWIPECARDNO;

  
    $lastPunch = DB::table('hr_daily_atten')
    ->where('LOGIN_ID', $card)
    ->whereDate('SDATE', $today)
    ->orderByDesc('id')
    ->first();
$extra = json_decode($lastPunch->extra_fields_json ?? '{}', true);
$place = $extra['place_name'] ?? null;


    if (!$lastPunch) {
        return response()->json([
            "status_code" => 200,
            "last_punch_type" => null,
            "next_punch_type" => "IN",
            "last_punch_time" => null
        ]);
    }

    $lastType = strtoupper($lastPunch->STATUS);
    $nextType = $lastType === "IN" ? "OUT" : "IN";
$formattedTime = Carbon::parse($lastPunch->SDATE)->format('d-M-Y H:i');

    return response()->json([
        "status_code" => 200,
        "last_punch_type" => $lastType,
        "next_punch_type" => $nextType,
        "last_punch_time" => $formattedTime,
        "last_lat" => $lastPunch->latitude,
        "last_lon" => $lastPunch->longitude,
        "last_place_name" => $place

    ]);
}
public function getTodayPunches(Request $req)
{
    $login_id = $req->login_id;
    $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

    $emp = DB::select("SELECT SWIPECARDNO FROM employee WHERE CODE = ?", [$login_id]);
    if (empty($emp)) {
        return response()->json([
            "status_code" => 400,
            "text" => "Invalid employee"
        ]);
    }

    $card = $emp[0]->SWIPECARDNO;

    $punches = DB::table('hr_daily_atten')
        ->where('LOGIN_ID', $card)
        ->whereDate('SDATE', $today)
        ->orderBy('SDATE', 'asc')
        ->get();

    return response()->json([
        "status_code" => 200,
        "punches" => $punches
    ]);
}
public function getTodayPunchSummary(Request $req)
{
    $login_id = $req->login_id;
    $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

    $emp = DB::select("SELECT SWIPECARDNO FROM employee WHERE CODE = ?", [$login_id]);

    if (empty($emp)) {
        return response()->json([
            "status_code" => 400,
            "text" => "Invalid employee"
        ]);
    }

    $card = $emp[0]->SWIPECARDNO;

    $rows = DB::table('hr_daily_atten')
        ->where('LOGIN_ID', $card)
        ->whereDate('SDATE', $today)
        ->orderBy('SDATE', 'asc')
        ->get();

    $final = [];
    $current = [];

   foreach ($rows as $row) {

    // Convert extra fields JSON
    $extra = json_decode($row->extra_fields_json ?? "{}", true);

    // ---------- FIX BASE64 ----------
    $imageBase64 = null;

    if (!empty($row->Image)) {

        $cleanPath = ltrim($row->Image, '/');
        $filePath = storage_path('app/' . $cleanPath);

        if (file_exists($filePath)) {
            $mime = mime_content_type($filePath);
            $imageBase64 = "data:$mime;base64," . base64_encode(file_get_contents($filePath));
        }
    }

    // ---------- IN ----------
    if ($row->STATUS == "IN") {

        $current = [
            "in" => array_merge((array)$row, [
               "base64" => $imageBase64
                //"base64" => ''
            ]),
            "out" => null,

            // 🟣 Store extra fields ONLY from IN punch
            "extra_fields" => $extra 
        ];
    }

    // ---------- OUT ----------
    else if ($row->STATUS == "OUT") {

        if (!empty($current)) {

            $current["out"] = array_merge((array)$row, [
               "base64" => $imageBase64
              //    "base64" => ''
            ]);

            // 🟣 Important Fix: Attach same place_name from IN to OUT pair
            if (!isset($current["extra_fields"]["place_name"])) {
                $current["extra_fields"]["place_name"] = $extra["place_name"] ?? null;
            }

            $final[] = $current;

            $current = [];
        }
    }
}


    // If last IN has no OUT yet
    if (!empty($current)) {
        $final[] = $current;
    }

    return response()->json([
        "status_code" => 200,
        "summary" => $final
    ]);
}
public function getReporteePunchSummary_report(Request $req)
{
    $req->validate([
        'login_id' => 'required',
        'reportee_code' => 'required',
        'from_date' => 'required',
        'to_date' => 'required',
    ]);

    $from = $req->from_date;
    $to   = $req->to_date;

    // ============================
    // ⭐ CASE 1: reportee_code = ALL
    // ============================
    if ($req->reportee_code === "all") {

        // 1. Fetch all mapped employees under this manager
        $employees = DB::select("
            SELECT e.CODE, e.NAME, e.SWIPECARDNO
            FROM branch_mapping bm
            INNER JOIN employee e ON bm.branch = e.BRANCH_CODE
            WHERE bm.code = ?
            ORDER BY e.CODE
        ", [$req->login_id]);

        // 2. If no reportees found → include self
        if (empty($employees)) {
            $self = DB::table('employee')
                ->select('CODE', 'NAME', 'SWIPECARDNO')
                ->where('CODE', $req->login_id)
                ->first();

            if ($self) {
                $employees = [ $self ];
            }
        }

        // 3. Build sessions
        $responseArr = [];

        foreach ($employees as $emp) {
            $sessions = $this->buildPunchSessions($emp->SWIPECARDNO, $from, $to);
            $responseArr[] = [
                "code" => $emp->CODE,
                "name" => $emp->NAME,
                "sessions" => $sessions
            ];
        }

        return response()->json([
            "status_code" => 200,
            "summary" => $responseArr
        ]);
    }

    // ============================
    // ⭐ CASE 2: Specific Single Employee
    // ============================

    $emp = DB::table('employee')
        ->where('CODE', $req->reportee_code)
        ->first();

    if (!$emp) {
        return response()->json([
            "status_code" => 400,
            "text" => "Invalid employee"
        ]);
    }

    $sessions = $this->buildPunchSessions($emp->SWIPECARDNO, $from, $to);

    return response()->json([
        "status_code" => 200,
        "summary" => [
            [
                "code" => $emp->CODE,
                "name" => $emp->NAME,
                "sessions" => $sessions
            ]
        ]
    ]);
}

private function buildPunchSessions($card, $from, $to)
{
    $rows = DB::table('hr_daily_atten')
        ->where('LOGIN_ID', $card)
        ->whereBetween(DB::raw('DATE(SDATE)'), [$from, $to])
        ->orderBy('SDATE', 'ASC')
        ->get();

    $sessions = [];
    $current = [];

    foreach ($rows as $row) {

        // Convert extra fields
        $extra = json_decode($row->extra_fields_json ?? "{}", true);

        // --------------------------
        // LOAD IMAGE AS BASE64
        // --------------------------
        $imageBase64 = null;

        if (!empty($row->Image)) {

            // Remove starting slash (if any)
            $cleanPath = ltrim($row->Image, '/');

            // Full storage path
            $filePath = storage_path("app/" . $cleanPath);

            if (file_exists($filePath)) {
                $mime = mime_content_type($filePath);
                $imageBase64 = "data:$mime;base64," . base64_encode(file_get_contents($filePath));
            }
        }

        // ----------- IN PUNCH -----------
        if ($row->STATUS == "IN") {

            $current = [
                "in" => array_merge((array)$row, [
                    "base64" => $imageBase64
                ]),
                "out" => null,
                "extra_fields" => $extra
            ];
        }

        // ----------- OUT PUNCH -----------
        else if ($row->STATUS == "OUT") {

            if (!empty($current)) {

                $current["out"] = array_merge((array)$row, [
                    "base64" => $imageBase64
                ]);

                // carry place_name
                if (!isset($current["extra_fields"]["place_name"])) {
                    $current["extra_fields"]["place_name"] = $extra["place_name"] ?? null;
                }

                $sessions[] = $current;
                $current = [];

            } else {

                // OUT without IN
                $sessions[] = [
                    "in" => null,
                    "out" => array_merge((array)$row, [
                        "base64" => $imageBase64
                    ]),
                    "extra_fields" => $extra
                ];
            }
        }
    }

    // Last IN without OUT
    if (!empty($current)) {
        $sessions[] = $current;
    }

    return $sessions;
}

}
