<?php 
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Request;
use App\Models\Users;
use App\Models\Employee;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Artisan;
use App\Models\NatureOfCallMaster;
use Illuminate\Http\Exceptions\ThrottleRequestsException;

use DateTime;

class LoginController extends Controller
{
	
	public function test(){
		return false;
	}
   
 public function Login(Request $request){
        $uname = $request->username;
        $password = $request->password;

		$user = Employee::where('code', $uname)->first();
		
		$deviceid =$request->deviceid;
		 $devicemapping =DB::select("select count(*) AS cnt from employee where CODE=? AND Androidid is NOT null",[$uname]);
	 if ($devicemapping[0]->cnt > 0) 
	  {
		 $testdevice =DB::select("select count(*) AS cnt from employee where CODE=? AND Androidid =?",[$uname,$deviceid]);
		 
		 if ($testdevice[0]->cnt < 1)
		 {
			  Return response()->json(['message'=> "SUCCESS",'status_code'=> "401",'text' => 'This is not your mapped Device . '], 401);

		 }			 
		 
		
	  }

			  
        if ($user && Hash::check($password, $user->password)) {
            Auth::login($user);
            $token = $user->createToken('authToken', [])->plainTextToken;
			//echo $uname;
            $data = Employee::where('code', $uname)->get();
// 			var_dump($data);
			 //  echo "1234";
			  foreach ($data as $keydata) {
               
                $name = $keydata->NAME;
                $logincode= $keydata->CODE;
                $company_name= $keydata->COMPANY_NAME;
                $branch_code= $keydata->BRANCH_CODE;
                $branch_name= $keydata->BRANCH_NAME;
            }

 return response()->json(['data' => 'Login Successfully', 'name' => $name, 'logincode' => $logincode ,'token'=>$token,'company_name'=>$company_name,'BRANCH_CODE'=>$branch_code,'BRANCH_NAME'=>$branch_name], 200);
            //return response()->json(['data' => 'Login Successfully', 'token' => $token, 'status' => '200'], 200);

        } else {
             return response()->json(['message' => 'Invalid Credentials error', 'status' => '401'], 401);
        }
    }
	
	
	public function getapplink(Request $request){
        $companycode = $request->companycode;
        

		$company = application::where('companycode', $companycode)->first();
		
	

			  
        if ($company) {
           
			//echo $uname;
            $data = application::where('companycode', $companycode)->get();
// 			var_dump($data);
			 //  echo "1234";
			  foreach ($data as $keydata) {
               
                $companycode = $keydata->companycode;
                $applink= $keydata->applink;
                $laravel= $keydata->laravel;
            }

 return response()->json(['data' => 'Login Successfully', 'company' => $companycode, 'applink' => $applink ,'laravel'=>$laravel], 200);
            //return response()->json(['data' => 'Login Successfully', 'token' => $token, 'status' => '200'], 200);

        } else {
             return response()->json(['message' => 'Invalid company code', 'status' => '401'], 401);
        }
    }
	
	
	 public function Loginportal(Request $request){
        $uname = $request->username;
        $password = $request->password;

		$user = Employee::where('code', $uname)->first();
		
	/*	$deviceid =$request->deviceid;
		 $devicemapping =DB::select("select count(*) AS cnt from employee where CODE=? AND Androidid is NOT null",[$uname]);
	 if ($devicemapping[0]->cnt > 0) 
	  {
		 $testdevice =DB::select("select count(*) AS cnt from employee where CODE=? AND Androidid =?",[$uname,$deviceid]);
		 
		 if ($testdevice[0]->cnt < 1)
		 {
			  Return response()->json(['message'=> "SUCCESS",'status_code'=> "401",'text' => 'This is not your mapped Device . '], 401);

		 }			 
		 
		
	  }*/

			  
        if ($user && Hash::check($password, $user->password)) {
            Auth::login($user);
            $token = $user->createToken('authToken', [])->plainTextToken;
			//echo $uname;
            $data = Employee::where('code', $uname)->get();
// 			var_dump($data);
			 //  echo "1234";
			  foreach ($data as $keydata) {
               
                $name = $keydata->NAME;
                $logincode= $keydata->CODE;
                $company_name= $keydata->COMPANY_NAME;
            }

 return response()->json(['data' => 'Login Successfully', 'name' => $name, 'logincode' => $logincode ,'token'=>$token,'company_name'=>$company_name], 200);
            //return response()->json(['data' => 'Login Successfully', 'token' => $token, 'status' => '200'], 200);

        } else {
             return response()->json(['message' => 'Invalid Credentials error', 'status' => '401'], 401);
        }
    }
	
	

 public function getemployeeprofiledetails(Request $request){
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;

		$userprofile = DB::SELECT("select code,name,branch_name,desig_name,mobile,emailid,bankname1,sbacno1,ifsc_code from employee where code = ?",[$login_id]);

        if ($userprofile) {
            return response()->json(['message' => 'Success', 'status' => '200','userprofile'=>$userprofile], 200);
		}else {
            return response()->json(['message' => 'Profile Details Not Found', 'status' => '401'], 401);
        }
    }
	
	
 public function UpdateEmployeeBankDetails(Request $request){
	
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'bank_name' => 'required', 
			'account_no' => 'required', 
			'ifsc_code' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;
        $bank_name = $request->bank_name;
        $ifsc_code = $request->ifsc_code;
        $account_no = $request->account_no;

		$rowsUpdated = DB::UPDATE("update employee set bankname1=?,sbacno1=?,ifsc_code=? where CODE = ?",[$bank_name,$account_no,$ifsc_code,$login_id]);

        if ($rowsUpdated >= 0) {
            return response()->json(['message' => 'Success', 'status' => '200','text'=>'Data Submitted Successfully'], 200);
		}else {
            return response()->json(['message' => 'Profile Details Not Found', 'status' => '401'], 401);
        }
    }
	
	

 public function createdar(Request $request){
        	
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'details' => 'required', 
			// 'dar_date' => 'required', 
			// 'is_field_visit' => 'required', 
			// 'from_time' => 'required', 
			// 'to_time' => 'required', 
			// 'nature_of_call' => 'required', 
			// 'activity_performed' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;
        $details = $request->details;
        // $dar_date = $request->dar_date;
        // $is_field_visit = $request->is_field_visit;
        // $from_time = $request->from_time;
        // $to_time = $request->to_time;
        // $nature_of_call = $request->nature_of_call;
        // $activity_performed = $request->activity_performed;
		
		$headerId = DB::table('dar_header')->insertGetId(['created_by' => $login_id,'created_on' => now(),'status' => '1']);
		foreach($details as $detail)
		{
		$dar_date = $detail['dar_date'];	
		$is_field_visit = $detail['is_field_visit'];
		$from_time = $detail['from_time'];	
		$to_time = $detail['to_time'];	
		$nature_of_call = $detail['nature_of_call'];
		$activity_performed = $detail['activity_performed'];	
			
		DB::table('dar_trailer')->insert(['header_id' => $headerId,'dar_date' => $dar_date, 'is_field_visit' => $is_field_visit, 'from_time' => $from_time, 'to_time' => $to_time, 'nature_of_call' => $nature_of_call,'activity_performed' => $activity_performed,'created_on' => now(),'created_by' => $login_id,'status' => '1']);
		}
		
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);


    }
	
	
	

 public function createpjp(Request $request){
        	
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'details' => 'required', 
			// 'dar_date' => 'required', 
			// 'is_field_visit' => 'required', 
			// 'from_time' => 'required', 
			// 'to_time' => 'required', 
			// 'nature_of_call' => 'required', 
			// 'activity_performed' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;
        $details = $request->details;
        // $dar_date = $request->dar_date;
        // $is_field_visit = $request->is_field_visit;
        // $from_time = $request->from_time;
        // $to_time = $request->to_time;
        // $nature_of_call = $request->nature_of_call;
        // $activity_performed = $request->activity_performed;
		
		$headerId = DB::table('pjp_header')->insertGetId(['created_by' => $login_id,'created_on' => now(),'status' => 'P']);
		foreach($details as $detail)
		{
		$from_date = $detail['from_date'];	
		$to_date = $detail['to_date'];	
		$nature_of_call = $detail['nature_of_call'];
		$reference = $detail['reference'];
		$reason = $detail['reason'];	
			
		DB::table('pjp_trailer')->insert(['header_id' => $headerId,'from_date' => $from_date,'to_date' => $to_date,  'nature_of_call' => $nature_of_call, 'reference' => $reference,'reason' => $reason,'created_on' => now(),'created_by' => $login_id,'status' => 'P']);
		}
		
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);


    }
	
	
 public function createadvanceforemployee(Request $request){
        	
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'deduction_code' => 'required', 
			'advanceamount' => 'required', 
			'noofdues' => 'required', 
			'remarks' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;
        $deduction_code = $request->deduction_code;
        $advanceamount = $request->advanceamount;
        $noofdues = $request->noofdues;
        $remarks = $request->remarks;
		$dueamount = $advanceamount/$noofdues;
	//	$AUTOGENERATE_NO=SELEct Count(AUTOGENERATE_NO)+1 from employee_deduction_header
	  $AUTOGENERATE_NO1 = DB::table('employee_deduction_header')
                                ->max('AUTOGENERATE_NO');
         $AUTOGENERATE_NO= $AUTOGENERATE_NO1 +1;
		 $count = DB::table('employee_deduction_trailer')
      ->whereNull('STATUS')
        ->where('CODE', $login_id)
        ->where('DED_CODE', $deduction_code)
        ->count();

    if ($count > 0) {
        // If count is greater than 0, return a message
        Return response()->json(['message'=> "FAILURE",'status_code'=> "400",'text' => 'Already Previous Loan Dues are Pending'], 200);
       
    } else {
        
		$createadvance = DB::select("insert into employee_deduction_header (code,name,ded_code,total_amt,BALANCE_AMT,NO_DUES,BALANCE_DUES,DUE_AMT,maincode,remarks,status,OTOTAL_AMT,ONO_DUES,ODUE_AMT,CREATED_BY,CREATED_ON,AUTOGENERATE_NO) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);",[$login_id,$login_id,$deduction_code,$advanceamount,$advanceamount,$noofdues,$noofdues,$dueamount,$login_id,$remarks,'REQUESTED',$advanceamount,$noofdues,$dueamount,$login_id,now(),$AUTOGENERATE_NO]);
	
			Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
    } 
		
	


    } 
    
    /*public function createadvanceforemployee(Request $request){
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        'login_id' => 'required', 
        'deduction_code' => 'required', 
        'advanceamount' => 'required', 
        'noofdues' => 'required', 
        'remarks' => 'required', 
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    // Extract variables from the request
    $login_id = $request->login_id;
    $deduction_code = $request->deduction_code;
    $advanceamount = $request->advanceamount;
    $noofdues = $request->noofdues;
    $remarks = $request->remarks;
    $dueamount = $advanceamount / $noofdues;

    // Check if there are existing records with STATUS 'C'
    $count = DB::table('employee_deduction_trailer')
        ->where('STATUS', 'C')
        ->where('CODE', $login_id)
        ->where('DEED_CODE', $deduction_code)
        ->count();

    if ($count > 0) {
        // If count is greater than 0, return a message
        return response()->json([
            'message' => 'Already Previous Loan Dues are Pending',
            'status_code' => '400',
        ], 400);
    } else {
        // If count is 0, proceed with the insertion
        DB::table('employee_deduction_header')->insert([
            'code' => $login_id,
            'name' => $login_id,
            'ded_code' => $deduction_code,
            'total_amt' => $advanceamount,
            'BALANCE_AMT' => $advanceamount,
            'NO_DUES' => $noofdues,
            'BALANCE_DUES' => $noofdues,
            'DUE_AMT' => $dueamount,
            'maincode' => $login_id,
            'remarks' => $remarks,
            'status' => 'REQUESTED',
            'OTOTAL_AMT' => $advanceamount,
            'ONO_DUES' => $noofdues,
            'ODUE_AMT' => $dueamount
        ]);

        // Return a success response
        return response()->json([
            'message' => 'Data Inserted successfully.',
            'status_code' => '200',
        ], 200);
    }
} */

	
	


public function getleavetype(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'financialyear'=>'required',
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		//$code = $request->code;
		$login_id = $request->login_id;
		$financialyear = $request->financialyear;
		
		//$leavecode = DB::table('employee_leave')->select('LEAVE_NAME','LEAVE_CODE')->where('code',$code)->where('FINANCIAL_YEAR', $financialyear)->get();
		$leavecode = DB::select('select a.leave_code,a.leave_name from 	employee_leave a where a.code = ?',[$login_id]);
		return response()->json(['getleavetype' => $leavecode], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	
	
public function getnatureofcalllist(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}

		$naturesOfCall = NatureOfCallMaster::select('id', 'description', 'shortcode')->where('status', 1)->get();

		return response()->json(['message'=>'Success','status_code'=>'200', 'natureofcall'=> $naturesOfCall], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	
	
	public function getdayclosinglogfields(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
	//	$userdetails = self::getuserdetails($login_id);
			$userdetails = self::getemployeedetials($login_id);
		
		$fields = array();
		
		if($userdetails->DESIG_NAME == 'Technician')
		{
			$fields = DB::table('day_closing_fields')->select('code', 'name')->where('status', 1)->get();
		}

		return response()->json(['message'=>'Success','status_code'=>'200', 'fields'=> $fields], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	
public function getreporteeslist(Request $request)
{
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    $login_id = $request->login_id;

    // Fetch reportees based on branch mapping
    $reporteeslist = DB::select("
        SELECT e.code, e.name  
        FROM branch_mapping na 
        INNER JOIN employee e ON na.branch = e.BRANCH_CODE  
        WHERE na.code = ?
    ", [$login_id]);

    // ⭐ If NO reporetees → include self
    if (empty($reporteeslist)) {

        $self = DB::table('employee')
            ->select('CODE as code', 'NAME as name')
            ->where('CODE', $login_id)
            ->first();

        if ($self) {
            $reporteeslist = [ $self ];
        }
    }

    return response()->json([
        'message' => 'Success',
        'status_code' => '200',
        'reporteeslist' => $reporteeslist
    ], 200);
}

	
public function getreporteespunch(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'reportee_code' => 'required', 
			'from_date' => 'required', 
			'to_date' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}

		$login_id = $request->login_id;
		$reportee_code = $request->reportee_code;
		$from_date = $request->from_date;
		$to_date = $request->to_date;
		$to_date_plus_one_day = Carbon::parse($to_date)->addDay();
		$to_date_plus_one_day_formatted = $to_date_plus_one_day->format('Y-m-d');

		if($reportee_code == 'all')
		{
			$wherecondition = "";
		}
		else
		{
			$wherecondition = "and na.CODE = '$reportee_code'"; 
		}

	//	$reportee_details = DB::SELECT("select hda.id,hda.login_id ,hda.name,sdate,location,hda.latitude,hda.longitude from employee na
 //inner join hr_daily_atten hda on na.swipecardno = hda.login_id  inner join  branch_admin c on c.AUTHORITY_CODE=na.BRANCH_CODE
 // where  c.CODE = ?  and sdate between ? and ? $wherecondition order by sdate desc", [$login_id,$from_date,$to_date_plus_one_day_formatted]);
		$reportee_details = DB::SELECT("select hda.id,hda.login_id ,hda.name,sdate,location,hda.latitude,hda.longitude from employee na
 inner join hr_daily_atten hda on na.swipecardno = hda.login_id  inner join  branch_mapping c on c.branch=na.BRANCH_CODE
  where  c.code = ?  and sdate between ? and ? $wherecondition order by sdate desc", [$login_id,$from_date,$to_date_plus_one_day_formatted]);
		return response()->json(['message'=>'Success','status_code'=>'200', 'reportee_details'=> $reportee_details], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}	
	

	
	public function getdeductiontypelist(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$deductiontypelist = DB::SELECT("select code,name from deduction d order by PRIORITY");

		return response()->json(['message'=>'Success','status_code'=>'200', 'deductiontypelist'=> $deductiontypelist], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	

	
public function getdardateslist(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}

$currentDate = Carbon::today();

// Array to store the last 5 dates
$lastFiveDates = [];

// Generate the last 5 dates
for ($i = 0; $i < 5; $i++) {
    $lastFiveDates[] = $currentDate->toDateString();
    $currentDate->subDay(); // Move to the previous day
}

// Output the last 5 dates
//foreach ($lastFiveDates as $date) {
    //$date $date . "<br>";
//}

		return response()->json(['message'=>'Success','status_code'=>'200', 'datelist'=> $lastFiveDates], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}


public function getattendanceimage(Request $request) {
    // Validate the incoming request
   
	//$logo = DB::table('company_images');
	$validator = Validator::make($request->all(), [
        'login_id' => 'required|string', 
        'attendance_id' => 'required|string', 
    ]); 

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $login_id = $request->login_id;
    $attendance_id = $request->attendance_id;
	
	
	$attendanceimage = DB::table('hr_daily_atten')->where('id', $attendance_id)
                        ->first();

    if (!$attendanceimage) {
        return response()->json(['message'=>'Failure','status_code' => 200,'text' => 'Profile image not found'], 404);
    }
	
	
    // Retrieve the image data using the image path
    $imagePath = $attendanceimage->Image;
    $imageData = Storage::get($imagePath);

    // Convert the image data to base64
    $base64Image = base64_encode($imageData);
    //$base64Image = $imageData;

    // Return the image data as JSON
    return response()->json(['message'=>'Failure','status_code' => 200,'image' => $base64Image]);
	
}



// public function createuserpunch(Request $request) {
    // // Validate the incoming request
    // $validator = Validator::make($request->all(), [
        // 'image' => 'required|string', // Changed to string because it's a base64 encoded string
    // ]); 

    // // Check if validation fails
    // if ($validator->fails()) {
        // return response()->json([
            // 'message' => $validator->errors()->all(),
            // 'status_code' => '400',
        // ], 400);
    // }
    // $login_id = $request->login_id;
    // $latitude = $request->latitude;
    // $longitude = $request->longitude;
	 
	
	
    // // Get the base64 encoded image data from the request
    // $imageData = $request->input('image');

    // // Extract image extension and data
    // $extension = explode('/', mime_content_type($imageData))[1];
    // $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imageData));

    // // Generate a unique filename
    // $imageName = time() . '_' . Str::random(10) . '.' . $extension;

    // // Store the image
    // Storage::put('attendanceimage/' . $imageName, $imageData);
	
	// $target_file = 'attendanceimage/'.$imageName;
	
	// $locationcount ='0';
	
	// try {
		
		
		// $getuserdetails = self::getemployeedetials($login_id);
		
		   // // $latitude = DB::table('branch')->select('latitude','longitude')->where('')
		// if($getuserdetails['traveleligibility'] == 'NO')
		// {
			// $latitudelocation = DB::select("select b.latitude,b.longitude FROM branch b INNER JOIN employee e on e.BRANCH_CODE=b.CODE WHERE e.CODE='$login_id'");
			
			// $referenceLatitude = $latitudelocation[0]->latitude;
            // $referenceLongitude = $latitudelocation[0]->longitude;
			
			// $distance = $this->calculateDistance(
                // $referenceLatitude,
                // $referenceLongitude,
                // $latitude,
                // $longitude
				
        // );
		// if($distance <= 0.5)
		// {
		// $locationcount='1';
		// }
		// }
		// ELSE
		// {
			// $result1=DB::select("select EmployeeCode,Branchcode,latitude,longitude from Employee_Travel_Mapping where EmployeeCode=?",[$login_id]);
			
			// foreach($result1 as $value )
		// {
			// if($locationcount=='0')
			// {
				
			// $referenceLatitude = $value->latitude;
            // $referenceLongitude = $value->longitude;
			
			// $distance = $this->calculateDistance(
                // $referenceLatitude,
                // $referenceLongitude,
                // $latitude,
                // $longitude
				
        // );
			// }
		
		// if($distance <= 0.5)
		// {
			// $locationcount='1';
		// }
		
		// }
			
		// }
		
		// //echo $distance;
		// if ($locationcount=='1') { // 500 meters in kilometers
            // // Location is within 500 meters
			
			// $results = DB::select("select name,swipecardno from employee where code=?",[$login_id]);
            // $employeename = $results[0]->name;
			// $swipecardnumber=$results[0]->swipecardno;
			// $status='IN';
			// $currentDateTimeFormatted = Carbon::now('Asia/Kolkata');
			// $time = Carbon::parse($currentDateTimeFormatted)->format('H:i');
			// $location='MOBILE PUNCH';
			
			// DB::insert('insert into hr_daily_atten (login_id, name, status, sdate, usertime, location, image, latitude, longitude) values (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?)', [$swipecardnumber, $employeename, $status, $location, $target_file, $latitude, $longitude]);
			// DB::insert('insert into grs_daily_atten (login_id, name, status, sdate, usertime, location, image, latitude, longitude) VALUES (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?)', [$swipecardnumber, $employeename, $status, $location, $target_file, $latitude, $longitude]);
			
             // Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
        // } else {
            // // Location is not within 100 meters
			// return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => 'Location is not within 500 meters.'], 200);
           // // return response()->json(['error' => 'Location is not within 100 meters.'], 400);
        // }
			
			

			
		// } catch (\Exception $e) {
       

			// return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		// }

       
	
	
// // insert into HR_DAILY_ATTEN (LOGIN_ID ,NAME ,STATUS,SDATE,USERTIME ,LOCATION,Image,latitude,longitude)VALUES(?,?,?,?,?,?,?,?,?)

   
// }



// public function createuserpunch(Request $request) {

//     $validator = Validator::make($request->all(), [
//         'image' => 'required|string', 
//     ]); 

  
//     if ($validator->fails()) {
//         return response()->json([
//             'message' => $validator->errors()->all(),
//             'status_code' => '400',
//         ], 400);
//     }
//     $login_id = $request->login_id;
//     $latitude = $request->latitude;
//     $longitude = $request->longitude;
	 
	
	
//     // Get the base64 encoded image data from the request
//     $imageData = $request->input('image');

//     // Extract image extension and data
//     $extension = explode('/', mime_content_type($imageData))[1];
//     $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imageData));

//     // Generate a unique filename
//     $imageName = time() . '_' . Str::random(10) . '.' . $extension;

//     // Store the image
//     Storage::put('attendanceimage/' . $imageName, $imageData);
	
// 	$target_file = 'attendanceimage/'.$imageName;
	
// 	$locationcount ='0';
// 	$branchname='';
// 	try {
//     $results = DB::select("SELECT name, swipecardno FROM employee WHERE code = ?", [$login_id]);
//     if (empty($results)) {
//         return response()->json(['message' => 'Failure', 'status_code' => 400, 'text' => 'Invalid Employee.'], 200);
//     }

//     $employeename = $results[0]->name;
//     $swipecardnumber = $results[0]->swipecardno;
//     $location = 'MOBILE PUNCH';
//     $branchname = '';
//     $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

//     $lastPunch = DB::table('hr_daily_atten')
//     ->where('login_id', $swipecardnumber)
//     ->whereDate('sdate', $today)
//     ->orderByDesc('sdate')
//     ->first();

// $allowPunch = false;
// $status = 'IN';

// if (!$lastPunch) {

//     // FIRST punch of the day
//     $allowPunch = true;
//     $status = 'IN';

// } else {

   
//     $lastStatus = strtoupper($lastPunch->STATUS);
//     $refLat     = (float)$lastPunch->latitude;
//     $refLon     = (float)$lastPunch->longitude;

//   if ($lastStatus === 'IN') {

//     $distance = $this->calculateDistance($refLat, $refLon, $latitude, $longitude);
//     $distance_m = round($distance * 1000, 2);

//     if ($distance <= 0.1) {
       
//         $allowPunch = true;
//         $status = 'OUT';

//     } else {
       
//         $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

//         $exists = DB::table('punch_approval_requests')
//                     ->where('login_id', $login_id)
//                     ->where('date', $today)
//                     ->where('status', 'APPROVED')
//                     ->exists();

//         if ($exists) {
            
//             $allowPunch = true;
//             $status = 'OUT';
//         } else {

            
//             // DB::table('punch_approval_requests')->insert([
//             //     'login_id'     => $login_id,
//             //     'date'         => $today,
//             //     'last_in_lat'  => $refLat,
//             //     'last_in_lon'  => $refLon,
//             //     'moved_lat'    => $latitude,
//             //     'moved_lon'    => $longitude,
//             //     'distance_m'   => $distance_m,
//             //     'requested_on' => now(),
//             //     'status'       => 'PENDING'
//             // ]);

//             return response()->json([
//                 'status_code' => 301,
//                 'message'     => 'PUNCH_BLOCKED',
//                 'text'        => 'Youâ€™re a little away from your punch-in location. Weâ€™ve sent an approval request to your manager',
//                 'distance_m'  => $distance_m
//             ], 200);
//         }
//     }
// }

//     elseif ($lastStatus === 'OUT') {

//         // After OUT, next punch is a new IN
//         $allowPunch = true;
//         $status = 'IN';
//     }
// }

//     if ($allowPunch) {
       
//         DB::insert('INSERT INTO hr_daily_atten (
//             login_id, name, status, sdate, usertime, location, image, latitude, longitude, punchlocation
//         ) VALUES (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?, ?)', [
//             $swipecardnumber,
//             $employeename,
//             $status,
//             $location,
//             $target_file,
//             $latitude,
//             $longitude,
//             $branchname
//         ]);

//         // Mirror insert
//         DB::insert('INSERT INTO grs_daily_atten (
//             login_id, name, status, sdate, usertime, location, image, latitude, longitude, punchlocation
//         ) VALUES (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?, ?)', [
//             $swipecardnumber,
//             $employeename,
//             $status,
//             $location,
//             $target_file,
//             $latitude,
//             $longitude,
//             $branchname
//         ]);

//         return response()->json([
//             'message' => 'SUCCESS',
//             'status_code' => 200,
//             'text' => "Your $status punch has been logged successfully."
//         ], 200);
//     }

// } catch (\Exception $e) {
//     return response()->json([
//         'message' => 'Failure',
//         'status_code' => 400,
//         'text' => $e->getMessage()
//     ], 200);
// }

// // 	try {
		
		
// // 		$getuserdetails = self::getemployeedetials($login_id);
		
// // 		   // $latitude = DB::table('branch')->select('latitude','longitude')->where('')
// // 		if($getuserdetails['traveleligibility'] == 'NO')
// // 		{
// // 			$latitudelocation = DB::select("select b.latitude,b.longitude ,b.NAME FROM branch b INNER JOIN employee e on e.BRANCH_CODE=b.CODE WHERE e.CODE='$login_id'");
			
// // 			$referenceLatitude = $latitudelocation[0]->latitude;
// //             $referenceLongitude = $latitudelocation[0]->longitude;
// // 			$branchname = $latitudelocation[0]->NAME;
			
// // 			$distance = $this->calculateDistance(
// //                 $referenceLatitude,
// //                 $referenceLongitude,
// //                 $latitude,
// //                 $longitude
				
// //         );
// // // 		if($distance <= 0.5)
// // // 		{
// // // 		$locationcount='1';
// // // 		}
// // // based on Mr.Ramachandran confirmation we reduced 500m as 50m
// // 			if($distance <= 0.1)
// // 		{
// // 		$locationcount='1';
// // 		}
// // 		}
// // 		ELSE
// // 		{
// // 			$result1=DB::select("select EmployeeCode,Branchcode,latitude,longitude from Employee_Travel_Mapping where EmployeeCode=?",[$login_id]);
			
// // 			foreach($result1 as $value )
// // 		{
// // 			if($locationcount==0)
// // 			{
				
// // 			$referenceLatitude = $value->latitude;
// //             $referenceLongitude = $value->longitude;
// // 			$branchname = $value->Branchcode;
// // 			$distance = $this->calculateDistance(
// //                 $referenceLatitude,
// //                 $referenceLongitude,
// //                 $latitude,
// //                 $longitude
				
// //         );
// // 			}
		
// // // 		if($distance <= 0.5)
// // // 		{
// // // 			$locationcount='1';
// // // 		}
// // // based on Mr.Ramachandran confirmation we reduced 500m as 50m
// // 			if($distance <= 0.1)
// // 		{
// // 		$locationcount='1';
// // 		}
		
// // 		}
			
// // 		}
// // 		//added for anywhere punch accetable
// // 	//	$locationcount='1';
// // 		//echo $distance;
// // 		if ($locationcount=='1') { // 500 meters in kilometers
// //             // Location is within 500 meters
			
// // 			$results = DB::select("select name,swipecardno from employee where code=?",[$login_id]);
// //             $employeename = $results[0]->name;
// // 			$swipecardnumber=$results[0]->swipecardno;
// // 			$status='IN';
// // 			$currentDateTimeFormatted = Carbon::now('Asia/Kolkata');
// // 			$time = Carbon::parse($currentDateTimeFormatted)->format('H:i');
// // 			$location='MOBILE PUNCH';
// // 		$existing = DB::table('hr_daily_atten')
// //     ->where('login_id', $swipecardnumber)
// //     ->whereRaw('DATE_FORMAT(sdate, "%Y-%m-%d %H:%i") = DATE_FORMAT(NOW(),"%Y-%m-%d %H:%i")')
// //     ->exists();

// // if (!$existing) {
// //     DB::insert('INSERT INTO hr_daily_atten (
// //         login_id, name, status, sdate, usertime, location, image, latitude, longitude, punchlocation
// //     ) VALUES (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?, ?)', [
// //         $swipecardnumber,
// //         $employeename,
// //         $status,
// //         $location,
// //         $target_file,
// //         $latitude,
// //         $longitude,
// //         $branchname
// //     ]);
// // } else {
   

// //     return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => 'Punch already exists for this time.'], 200);
// // }

// // 			//DB::insert('insert into hr_daily_atten (login_id, name, status, sdate, usertime, location, image, latitude, longitude,punchlocation) values (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?,?)', [$swipecardnumber, $employeename, $status, $location, $target_file, $latitude, $longitude,$branchname]);
// // 			DB::insert('insert into grs_daily_atten (login_id, name, status, sdate, usertime, location, image, latitude, longitude,punchlocation) VALUES (?, ?, ?, NOW(), DATE_FORMAT(NOW(), "%H:%i"), ?, ?, ?, ?,?)', [$swipecardnumber, $employeename, $status, $location, $target_file, $latitude, $longitude,$branchname]);
			
// //              Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Your punch has been logged.'], 200);
// //         } else {
// //             // Location is not within 100 meters
// // 			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => 'Location is not within 100 meters.'], 200);
// //           // return response()->json(['error' => 'Location is not within 100 meters.'], 400);
// //         }
			
			

			
// // 		} catch (\Exception $e) {
       

// 		//	return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
// 	//	}

       
	
	
// // insert into HR_DAILY_ATTEN (LOGIN_ID ,NAME ,STATUS,SDATE,USERTIME ,LOCATION,Image,latitude,longitude)VALUES(?,?,?,?,?,?,?,?,?)

   
// }
// public function createuserpunch(Request $request) {

//     $validator = Validator::make($request->all(), [
//         'image' => 'required|string',
//         'latitude' => 'required',
//         'longitude' => 'required',
//         'punch_type' => 'required|in:IN,OUT'
//     ]);

//     if ($validator->fails()) {
//         return response()->json([
//             'status_code' => 400,
//             'text' => $validator->errors()->first()
//         ]);
//     }

//     $login_id = $request->login_id;
//     $latitude = $request->latitude;
//     $longitude = $request->longitude;
//     $punchType = strtoupper($request->punch_type);
//     $placeName = $request->place_name ?? null;   // ðŸ‘ˆ place name here

//     // image save
//     $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $request->image));
//     $extension = explode('/', mime_content_type($request->image))[1];
//     $imageName = time() . '_' . Str::random(10) . '.' . $extension;
//     Storage::put('attendanceimage/' . $imageName, $imageData);
//     $target_file = 'attendanceimage/' . $imageName;

//     // employee
//     $emp = DB::table('employee')->where('code', $login_id)->first();
//     if (!$emp) {
//         return response()->json(['status_code' => 400, 'text' => 'Invalid employee']);
//     }

//     $card = $emp->SWIPECARDNO;
//     $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

//   $last = DB::table('hr_daily_atten')
//     ->where('login_id', $card)
//     ->whereDate('sdate', $today)
//     ->orderByDesc('id')
//     ->first();


//     // enforce correct IN â†’ OUT sequence
//     if (!$last) {
//         // first punch = IN
//         if ($punchType !== "IN") {
//             return response()->json([
//                 'status_code' => 400,
//                 'text' => 'Your first punch must be IN'
//             ]);
//         }
//     } else {
//         if ($last->STATUS === "IN" && $punchType !== "OUT") {
//             return response()->json([
//                 'status_code' => 400,
//                 'text' => 'Next punch must be OUT'
//             ]);
//         }

//         if ($last->STATUS === "OUT" && $punchType !== "IN") {
//             return response()->json([
//                 'status_code' => 400,
//                 'text' => 'Next punch must be IN'
//             ]);
//         }
//     }

//   // Handle extra fields
// $extra_json = null;

// if ($punchType === "IN") {

//     // IN punch must have place_name from request
//     if (!$placeName) {
//         return response()->json([
//             'status_code' => 400,
//             'text' => 'Place Name is required for IN punch'
//         ]);
//     }

//     $extra_json = json_encode([
//         "place_name" => $placeName
//     ]);
// }

// if ($punchType === "OUT") {

//     // Fetch corresponding IN punch for the same day
//     $inPunch = DB::table('hr_daily_atten')
//         ->where('login_id', $card)
//         ->whereDate('sdate', $today)
//         ->where('status', 'IN')
//         ->orderByDesc('id')
//         ->first();

//     if ($inPunch && $inPunch->extra_fields_json) {
//         $inExtra = json_decode($inPunch->extra_fields_json, true);
//         $placeName = $inExtra['place_name'] ?? null;
//     }

//     // Set place_name from IN punch even for OUT
//     $extra_json = json_encode([
//         "place_name" => $placeName
//     ]);
// }


//     // insert
//     DB::table('hr_daily_atten')->insert([
//         'login_id' => $card,
//         'name'     => $emp->NAME,
//         'status'   => $punchType,
//       'sdate' => Carbon::now('Asia/Kolkata'),
// 'usertime' => Carbon::now('Asia/Kolkata')->format("H:i"),

//         'location' => "MOBILE PUNCH",
//         'image'    => $target_file,
//         'latitude' => $latitude,
//         'longitude'=> $longitude,
//         'punchlocation' => '',
//         'extra_fields_json' => $extra_json
//     ]);

//     DB::table('grs_daily_atten')->insert([
//         'login_id' => $card,
//         'name'     => $emp->NAME,
//         'status'   => $punchType,
//     'sdate' => Carbon::now('Asia/Kolkata'),
// 'usertime' => Carbon::now('Asia/Kolkata')->format("H:i"),

//         'location' => "MOBILE PUNCH",
//         'image'    => $target_file,
//         'latitude' => $latitude,
//         'longitude'=> $longitude,
//         'punchlocation' => '',
//         'extra_fields_json' => $extra_json
//     ]);

//     return response()->json([
//         'status_code' => 200,
//         'text' => "Your $punchType punch has been recorded."
//     ]);
// }
public function createuserpunch(Request $request)
{
    $validator = Validator::make($request->all(), [
        'image' => 'required|string',
        'latitude' => 'required',
        'longitude' => 'required',
        'punch_type' => 'required|in:IN,OUT'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status_code' => 400,
            'text' => $validator->errors()->first()
        ]);
    }

    $login_id   = $request->login_id;
    $latitude   = $request->latitude;
    $longitude  = $request->longitude;
    $punchType  = strtoupper($request->punch_type);
    $placeName  = $request->place_name ?? null;

    /* =====================================================
       SAVE IMAGE
    ======================================================*/
    $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $request->image));
    $extension = explode('/', mime_content_type($request->image))[1];
    $imageName = time() . '_' . Str::random(10) . '.' . $extension;
    Storage::put('attendanceimage/' . $imageName, $imageData);

    $target_file = 'attendanceimage/' . $imageName;

    /* =====================================================
       EMPLOYEE DETAILS
    ======================================================*/
    $emp = DB::table('employee')->where('code', $login_id)->first();
    if (!$emp) {
        return response()->json(['status_code' => 400, 'text' => 'Invalid employee']);
    }

    $card = $emp->SWIPECARDNO;
    $today = Carbon::now('Asia/Kolkata')->format('Y-m-d');

    $lastPunch = DB::table('hr_daily_atten')
        ->where('login_id', $card)
        ->whereDate('sdate', $today)
        ->orderByDesc('id')
        ->first();

    /* =====================================================
       SEQUENCE ENFORCEMENT (IN → OUT → IN → OUT...)
    ======================================================*/
    if (!$lastPunch && $punchType !== 'IN') {
        return response()->json([
            'status_code' => 400,
            'text' => 'Your first punch must be IN'
        ]);
    }

    if ($lastPunch && $lastPunch->STATUS === "IN" && $punchType !== 'OUT') {
        return response()->json([
            'status_code' => 400,
            'text' => 'Next punch must be OUT'
        ]);
    }

    if ($lastPunch && $lastPunch->STATUS === "OUT" && $punchType !== 'IN') {
        return response()->json([
            'status_code' => 400,
            'text' => 'Next punch must be IN'
        ]);
    }

    /* =====================================================
       RADIUS VALIDATION (OLD LOGIC)
       Threshold: 100 meters (0.1 KM)
    ======================================================*/
    if ($lastPunch) {

        if ($lastPunch->STATUS === "IN") {
            $refLat = (float)$lastPunch->latitude;
            $refLon = (float)$lastPunch->longitude;

            $distance = $this->calculateDistance($refLat, $refLon, $latitude, $longitude);
            $meters = round($distance * 1000, 2);  // km → meters

            if ($meters > 100) {

                // Check if manager already approved
                $alreadyApproved = DB::table('punch_approval_requests')
                    ->where('login_id', $login_id)
                    ->where('date', $today)
                    ->where('status', 'APPROVED')
                    ->exists();

                if (!$alreadyApproved) {

                    // // Insert approval request
                    // DB::table('punch_approval_requests')->insert([
                    //     'login_id'     => $login_id,
                    //     'date'         => $today,
                    //     'last_in_lat'  => $refLat,
                    //     'last_in_lon'  => $refLon,
                    //     'moved_lat'    => $latitude,
                    //     'moved_lon'    => $longitude,
                    //     'distance_m'   => $meters,
                    //     'status'       => 'PENDING',
                    //     'requested_on' => now(),
                    //     'notification_msg' => $emp->NAME . " requested punch approval for out-of-range punch."
                    // ]);

                    return response()->json([
                        'status_code' => 301,
                        'text' => 'Too far from IN punch',
                        'distance_m' => $meters
                    ]);
                }
            }
        }
    }

    /* =====================================================
       EXTRA FIELDS JSON (place_name)
    ======================================================*/
    if ($punchType === "IN") {
        if (!$placeName) {
            return response()->json([
                'status_code' => 400,
                'text' => 'Place Name required for IN punch'
            ]);
        }

        $extra_json = json_encode(["place_name" => $placeName]);
    }

    if ($punchType === "OUT") {

        $inPunch = DB::table('hr_daily_atten')
            ->where('login_id', $card)
            ->whereDate('sdate', $today)
            ->where('status', 'IN')
            ->orderByDesc('id')
            ->first();

        $placeName = $inPunch ? json_decode($inPunch->extra_fields_json, true)['place_name'] ?? null : null;

        $extra_json = json_encode(["place_name" => $placeName]);
    }

    /* =====================================================
       FINAL INSERT
    ======================================================*/
    DB::table('hr_daily_atten')->insert([
        'login_id' => $card,
        'name' => $emp->NAME,
        'status' => $punchType,
        'sdate' => Carbon::now('Asia/Kolkata'),
        'usertime' => Carbon::now('Asia/Kolkata')->format("H:i"),
        'location' => "MOBILE PUNCH",
        'image' => $target_file,
        'latitude' => $latitude,
        'longitude' => $longitude,
        'punchlocation' => '',
        'extra_fields_json' => $extra_json
    ]);

    DB::table('grs_daily_atten')->insert([
        'login_id' => $card,
        'name' => $emp->NAME,
        'status' => $punchType,
        'sdate' => Carbon::now('Asia/Kolkata'),
        'usertime' => Carbon::now('Asia/Kolkata')->format("H:i"),
        'location' => "MOBILE PUNCH",
        'image' => $target_file,
        'latitude' => $latitude,
        'longitude' => $longitude,
        'punchlocation' => '',
        'extra_fields_json' => $extra_json
    ]);

    return response()->json([
        'status_code' => 200,
        'text' => "Your $punchType punch has been recorded."
    ]);
}

private function calculateDistance($lat1, $lon1, $lat2, $lon2)
    {
        $earthRadius = 6371; // in kilometers
        
        $lat1 = (float)$lat1; // Convert to float
        $lat2 = (float)$lat2;
        $lon1 = (float)$lon1; // Convert to float
        $lon2 = (float)$lon2;

         $dLat = deg2rad($lat2 - $lat1);
		
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon / 2) * sin($dLon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

        $distance = $earthRadius * $c;

        return $distance;
    }




public function getuserprofileimage(Request $request) {
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        'login_id' => 'required|string', 
    ]); 

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $login_id = $request->login_id;
	$profileImage = DB::table('profile_images')
                        ->where('user_id', $login_id)
                        ->first();

    if (!$profileImage) {
        return response()->json(['message'=>'Failure','status_code' => 200,'text' => 'Profile image not found'], 404);
    }
	
	
    // Retrieve the image data using the image path
    $imagePath = $profileImage->image_path;
    $imageData = Storage::get($imagePath);

    // Convert the image data to base64
    $base64Image = base64_encode($imageData);

    // Return the image data as JSON
    return response()->json(['message'=>'Failure','status_code' => 200,'image' => $base64Image]);
	
}


public function getlogo(Request $request) {
    // Validate the incoming request
   
	//$logo = DB::table('company_images');
	$validator = Validator::make($request->all(), [
        'image_name' => 'required|string', 
    ]); 

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $image_name = $request->image_name;
	
	
	$profileImage = DB::table('company_images')->where('image_name', $image_name)
                        ->first();
//			echo $profileImage; 			

    if (!$profileImage) {
        return response()->json(['message'=>'Failure','status_code' => 200,'text' => 'Profile image not found'], 404);
    }
	
	
    // Retrieve the image data using the image path
    $imagePath = $profileImage->image_path;
    $imageData = Storage::get($imagePath);

    // Convert the image data to base64
    $base64Image = base64_encode($imageData);
    //$base64Image = $imageData;

    // Return the image data as JSON
    return response()->json(['message'=>'Failure','status_code' => 200,'image' => $base64Image]);
	
}


public function updateuserprofileimage(Request $request) {
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        'login_id' => 'required|string', 
        'image' => 'required', 
    ]); 
        // 'image' => 'required|string', 

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $login_id = $request->login_id;
    // $imageData = $request->input('image');

    // $extension = explode('/', mime_content_type($imageData))[1];
    // $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imageData));

    // // Generate a unique filename
    // $imageName = time() . '_' . Str::random(10) . '.' . $extension;

    // // Store the image
    // Storage::put('profileimage/' . $imageName, $imageData);
	// $target_file = 'profileimage/'.$imageName;
	
	
	$image = $request->file('image');
	//time() . '_' . Str::random(10) . '.' . $extension
	$imageName = time() . '_' . Str::random(10) . '.' . $image->getClientOriginalExtension();
	$image->storeAs('profileimage/', $imageName);
	
	$target_file = 'profileimage/'.$imageName;
	
	try {
		$data = [
			'user_id' => $login_id,
			'image_path' => $target_file,
			'created_by' => $login_id,
			'modified_by' => $login_id,
		];

		// Insert a new record into the profile_images table or ignore if user_id already exists
		DB::table('profile_images')->insertOrIgnore($data);

		// Update the record if it already exists and the image_path is different
		DB::table('profile_images')
			->where('user_id', $data['user_id'])
			->where('image_path', '!=', $data['image_path'])
			->update(['image_path' => $data['image_path']]);
					
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);

	
	
   
}






	public function pendingapprovaldetails(Request $request)
	{
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required',
            		
		]);
		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}	
		$login_id = $request->login_id;
		$type= $request->type;
		
		if ($type=='L')
		{
			//loan
			$getpendingleaveapprovaldetails = self::getpendingapprovaldetails($login_id);
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingleaveapprovaldetails], 200);
		}
		else if ($type=='P')
		{
			//permission 
		$getpendingperapprovaldetails = self::getpendingpermissionapprovaldetails($login_id);
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingperapprovaldetails], 200);
		}
		else if($type=='O')
		{
			//od 
			$getpendingodapprovaldetails = self::getpendingodapprovaldetails($login_id);
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingodapprovaldetails], 200);	
		}
		else if($type=='A')
		{
			//advance
			$getpendingadvanceapprovaldetails = self::getpendingadvanceapprovaldetails($login_id);
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingadvanceapprovaldetails], 200);	
		}
		
		else if($type=='PJP')
		{
			//advance
			$getpendingpjpapprovaldetails = self::getpendingpjpapprovaldetails($login_id);
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingpjpapprovaldetails], 200);	
		}
	}
	
	
		
public function getpendingpjpapprovaldetails($login_id){
		
		//$login_id = $request->login_id;
		
		//$leavecode = DB::table('employee_leave')->select('LEAVE_NAME','LEAVE_CODE')->where('code',$code)->where('FINANCIAL_YEAR', $financialyear)->get();
		$getpendingapprovaldetails = DB::select("SELECT distinct ph.id as pjp_no, ph.created_by, e.name as employee_name, ph.created_on  as created_date
FROM new_authority na  
INNER JOIN pjp_header ph ON na.A_EMPLOYEECODE = ph.created_by  
INNER JOIN employee e ON ph.created_by = e.code  where na.maincode = ? and ph.status  = ?",[$login_id,'REQUESTED']);
		
		foreach($getpendingapprovaldetails as $key => $getpendingapprovaldetail)
		{
			$getpendingapprovaldetails[$key]->Details = DB::SELECT("select from_date ,to_date, nature_of_call , reference, reason  from pjp_trailer pt where header_id = ?",[$getpendingapprovaldetail->pjp_no]);
		}
		
		// Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingapprovaldetails], 200);
		
		Return $getpendingapprovaldetails;
		
		
	}
	


	
		public function clearConfigCache()
    {
        // Call the artisan command to clear the config cache
        echo "123";
        Artisan::call('optimize:clear');
        echo "123";
        Artisan::call('config:clear');
        Artisan::call('route:cache');
        //Artisan::call('config:clear');

        return 'Config cache cleared.';
    }
	

	
	
	public function updateapprovalstatus(Request $request)
	{
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required',
			'type' => 'required',
			'record_id' => 'required',
			'remarks' => 'required',
			'status' => 'required',
            		
		]);
		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}	
		
		$type=$request->type;
		if ($type=='L')
		{
			
			$data = self::updateleavestatus($request);
			Return response()->json(['message'=> $data['message'],'status_code'=> $data['status_code'],'text' => $data['text']], 200);
		}
		else if ($type=='P')
		{
			$data = self::updatepermissionstatus($request);
			Return response()->json(['message'=> $data['message'],'status_code'=> $data['status_code'],'text' => $data['text']], 200);
		}
		else if($type=='O')
		{
			
			$data = self::updateodstatus($request);
			Return response()->json(['message'=> $data['message'],'status_code'=> $data['status_code'],'text' => $data['text']], 200);
		}
		else if($type=='A')
		{
			//advance
			
			$data = self::updateadvancestatus($request);
			
			Return response()->json(['message'=> $data['message'],'status_code'=> $data['status_code'],'text' => $data['text']], 200);
		}
		else if($type=='PJP')
		{
			//advance
			$data = self::updatepjpstatus($request);
			Return response()->json(['message'=> $data['message'],'status_code'=> $data['status_code'],'text' => $data['text']], 200);
		}
	}
	
	
		public function updateadvancestatus($request)
	{
		
		$login_id = $request->login_id;
		$type= $request->type;
		$record_id= $request->record_id;
		$remarks= $request->remarks;
		$status= $request->status;
		$totalamt= $request->totalamt;
		$Numberofdues= $request->Numberofdues;
		$DUEAMT= $request->DUEAMT;
	
		
		try {
			// Perform the update operation
			$affectedRows = DB::UPDATE("update employee_deduction_header set STATUS = ? , approval_remarks = ?,approved_by = ?,START_DATE= now(), approved_on=now(),total_amt=?,BALANCE_AMT=?,NO_DUES=?,BALANCE_DUES=?,DUE_AMT=?  WHERE id = ? and STATUS = ?",[$status,$remarks,$login_id,$totalamt,$totalamt,$Numberofdues,$Numberofdues,$DUEAMT,$record_id,'REQUESTED']);
			
			
			$selecteddetails = DB::SELECT("select CODE,DED_CODE,TOTAL_AMT,NO_DUES,DUE_AMT,AUTOGENERATE_NO from employee_deduction_header where id = ? and STATUS = ?",[$record_id,'APPROVED']);
			$no_dues = 0;
			foreach($selecteddetails as $selecteddetail)
			{
					$employee_code  = $selecteddetail->CODE;
					$ded_code = $selecteddetail->DED_CODE;
					$total_amt = $selecteddetail->TOTAL_AMT;
					$no_dues = $selecteddetail->NO_DUES;
					$due_amt = $selecteddetail->DUE_AMT;
				   $AUTOGENERATE_NO = $selecteddetail->AUTOGENERATE_NO;

					
			}
			//echo $no_dues;
			if($no_dues <> 0)
			{
				for($i = 1 ; $i <= $no_dues;$i++ )
				{
					$j = $i-1;
					$duemonth = Carbon::now()->startOfMonth()->addMonths($j)->format('M-Y');
				//	$duemonth = Carbon::now()->addMonths($j)->format('M-Y');
				
					DB::INSERT("insert into employee_deduction_trailer  (CODE,DED_CODE,DUE_NO,DUE_AMT,DUE_MONTH,ADVANCE_STATUS,header_id,created_by,created_on,AUTOGENERATE_NO) values (?,?,?,?,?,?,?,?,now(),?)",[$employee_code,$ded_code,$i,$due_amt,$duemonth,'REQUESTED',$record_id,$login_id,$AUTOGENERATE_NO]);
				}
			}
			
			
			$return['message']="Success";
			$return['status_code']="200";
			$return['text']="STATUS UPDATED SUCCESSFULLY !";

		} catch (QueryException $e) {
			$return['message']="Failure";
			$return['status_code']="400";
			$return['text']="DATA NOT UPDATED !";
		}
		return $return;
	}
	
		public function updatepjpstatus($request)
	{
		$login_id = $request->login_id;
		$type= $request->type;
		$record_id= $request->record_id;
		$remarks= $request->remarks;
		$status= $request->status;
		
		try {
			// Perform the update operation
			$affectedRows = DB::UPDATE("update pjp_header set status = ?,approval_remarks = ? ,approved_by = ? ,approved_on = now() where id = ? and status = ?",[$status,$remarks,$login_id,$record_id,'REQUESTED']);
			$affectedRows = DB::UPDATE("update pjp_header set status  = ? where header_id = ? and status = ?",[$status,$record_id,'REQUESTED']);
			$return['message']="Success";
			$return['status_code']="200";
			$return['text']="STATUS UPDATED SUCCESSFULLY !";

		} catch (QueryException $e) {
			$return['message']="Failure";
			$return['status_code']="400";
			$return['text']="DATA NOT UPDATED !";
		}
		return $return;
	}
	


	
	
	
	
	
	public function updateodstatus($request)
	{
		$login_id = $request->login_id;
		$type= $request->type;
		$record_id= $request->record_id;
		$remarks= $request->remarks;
		$status= $request->status;
		
		try {
			// Perform the update operation
			$affectedRows = DB::UPDATE("update odapplication_details set OD_STATUS = ?,remarks = ? ,approved_by = ? ,approved_date = now() where od_no = ? and od_status = ?",[$status,$remarks,$login_id,$record_id,'REQUESTED']);
			$affectedRows = DB::UPDATE("update odavailed_details set od_status = ? where od_no = ? and od_status = ?",[$status,$record_id,'REQUESTED']);
			$return['message']="Success";
			$return['status_code']="200";
			$return['text']="STATUS UPDATED SUCCESSFULLY !";

		} catch (QueryException $e) {
			$return['message']="Failure";
			$return['status_code']="400";
		 $return['text'] = "DATA NOT UPDATED ! " . $e->getMessage();
		}
		return $return;
	}
	
	
	public function updatepermissionstatus($request)
	{
		$login_id = $request->login_id;
		$type= $request->type;
		$record_id= $request->record_id;
		$remarks= $request->remarks;
		$status= $request->status;
		
		try {
			// Perform the update operation
			$affectedRows = DB::UPDATE("update permission_details set per_status = ?,remarks = ?, approved_by = ?, approved_date =now() where per_no = ? and per_status = ?",[$status,$remarks,$login_id,$record_id,'REQUESTED']);
			$return['message']="Success";
			$return['status_code']="200";
			$return['text']="STATUS UPDATED SUCCESSFULLY !";

		} catch (\Illuminate\Database\QueryException $e) {
    $return['message'] = "Failure";
    $return['status_code'] = "400";
    $return['text'] = "DATA NOT UPDATED! Error: " . $e->getMessage();
}

		return $return;
	}
	public function updateleavestatus($request)
	{
		$login_id = $request->login_id;
		$type= $request->type;
		$record_id= $request->record_id;
		$remarks= $request->remarks;
		$status= $request->status;
		
		try {
			// Perform the update operation
			$affectedRows = DB::UPDATE("update leaveapplication_details set leave_status = ?, remarks = ? , MODIFIED_USERID =?,MODIFIED_DATE =now() where LEAVE_NO = ? and leave_status = ?",[$status,$remarks,$login_id,$record_id,'REQUESTED']);
			$leavedetails = DB::SELECT("select year(from_date) as leaveyear,UPPER(DATE_FORMAT(from_date, '%b')) as leavemonth,leavetype,no_of_days,employee_code  from leaveapplication_details where LEAVE_NO = ?",[$record_id]);
			$affectedRows = DB::UPDATE("update leaveavailed_details set leave_status = ? where leave_no = ? and leave_status=?",[$status,$record_id,'REQUESTED']);
			$affectedRows = DB::UPDATE("update employee_leave set AVAILED = COALESCE(AVAILED, 0) + ? ,   BALANCE= COALESCE(BALANCE,0) -?, {$leavedetails[0]->leavemonth} =? where  FINANCIAL_YEAR  = ? and code = ? and LEAVE_CODE  = ?",[$leavedetails[0]->no_of_days,$leavedetails[0]->no_of_days,$leavedetails[0]->no_of_days,$leavedetails[0]->leaveyear,$leavedetails[0]->employee_code,$leavedetails[0]->leavetype]);
			$return['message']="Success";
			$return['status_code']="200";
			$return['text']="STATUS UPDATED SUCCESSFULLY !";

		} catch (QueryException $e) {
			$return['message']="Failure";
			$return['status_code']="400";
		 //$return['text']="DATA NOT UPDATED !";
		//	$return['text']=$e->getMessage;
				$return['text']=$e;
		}
		return $return;
	}
	
	
public function getpendingapprovaldetails($login_id){
		
		//$login_id = $request->login_id;
		
		//$leavecode = DB::table('employee_leave')->select('LEAVE_NAME','LEAVE_CODE')->where('code',$code)->where('FINANCIAL_YEAR', $financialyear)->get();
		$getpendingapprovaldetails = DB::select("select distinct
		a.leave_no,
		a.branch_code,
		a.reason,
		a.employee_code,
		a.employee_name,
		date(a.from_date) as from_date,
		date(a.to_date) as to_date,
		a.leave_status,
		a.no_of_days,
		a.created_date
from 
	leaveapplication_details a 
	inner join branch_admin b 
on
	b.code = ? and a.branch_code = b.branch_code  and a.LEAVE_STATUS = 'REQUESTED'",[$login_id]);
		
		// Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingapprovaldetails' => $getpendingapprovaldetails], 200);
		
		Return $getpendingapprovaldetails;
		
		
	}
	
	
	public function getpendingpermissionapprovaldetails($login_id){
	
	
		
		
		//$login_id = $request->login_id;
		
		//$leavecode = DB::table('employee_leave')->select('LEAVE_NAME','LEAVE_CODE')->where('code',$code)->where('FINANCIAL_YEAR', $financialyear)->get();
		$getpendingpermissionapprovaldetails = DB::select("select  distinct
	a.per_no,
	a.branch_code,
	a.reason,
	a.employee_code,
	a.employee_name,
	date(a.per_date) as per_date,
	a.From_time ,
    a.To_Time,
	a.per_status,
	a.created_date
from 
	permission_details a 
	inner join branch_admin b 
on
	b.code =? and a.branch_code = b.branch_code and a.per_status = 'REQUESTED'",[$login_id]);
		
		// Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingpermissionapprovaldetails' => $getpendingpermissionapprovaldetails], 200);
		Return $getpendingpermissionapprovaldetails;
	}
	
	
	public function getpendingodapprovaldetails($login_id){
	
	
		
		
		//$login_id = $request->login_id;
		$status='REQUESTED';
		//$leavecode = DB::table('employee_leave')->select('LEAVE_NAME','LEAVE_CODE')->where('code',$code)->where('FINANCIAL_YEAR', $financialyear)->get();
		$getpendingodapprovaldetails = DB::select("select distinct
	a.od_no,
	a.branch_code,
	a.purpose,
	a.employee_code,
	a.employee_name,
	date(a.from_date) as from_date,
    date(a.to_date) as to_date,
	a.From_time ,
    a.To_Time,
	a.OD_status,
    a.visitingplace,
    a.no_of_days,
	a.created_date
from 
	odapplication_details a 
	inner join branch_admin b 
on
	b.code =? and a.branch_code = b.branch_code and a.OD_status=?",[$login_id,$status]);
		///return response()->json(['LEAVE_DETAILS' => $leavecode], 200);
		// Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingodapprovaldetails' => $getpendingodapprovaldetails], 200);
		Return $getpendingodapprovaldetails;
	}
	
	
	
	public function getpendingadvanceapprovaldetails($login_id){
	
	
		
		if($login_id==='10001')
		{
		//$login_id = $request->login_id;
		$status='REQUESTED'; //PENDING
		
		$getpendingodapprovaldetails = DB::select("select DISTINCT
    edh.id advance_no,edh.code,
    edh.ded_code,
    edh.total_amt,
    edh.NO_DUES,
    edh.DUE_AMT,
    e.name as employee_name,
    d.name as deductionname 
from 
    employee_deduction_header edh 
inner join 
    new_authority na on edh.code = na.a_employeecode 
inner join 
    employee e on edh.code = e.code 
inner join 
    deduction d on edh.ded_code = d.code 
where na.maincode=? and
    edh.status = ? 
",[$login_id,$status]);
		///return response()->json(['LEAVE_DETAILS' => $leavecode], 200);
		// Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getpendingodapprovaldetails' => $getpendingodapprovaldetails], 200);
		Return $getpendingodapprovaldetails;
		}
		else{
		   // $$getpendingodapprovaldetails="Not Authorized"
		    Return "Not Authorized";
		}
	} 
	
	
	
	
	public function getplace(){
		
		
		//$place = DB::table('PLACEMASTER')->select('DESCRIPTION')->get();
		$place = DB::select("select description from placemaster");
		return response()->json(['PLACE_MASTER' => $place], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	public function leaveavailable(Request $request){
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
			$code = $request->login_id;
		try {
			//select Leave_name ,Balance  from EMPLOYEE_LEAVE where code in(select code from EMPLOYEE  where maincode='10024')
	
			$leaves = DB::select('select leave_name ,balance  from employee_leave where code in(select code from employee  where code=?)',[$code]);
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'leaveavailable' => $leaves], 200);
		//$place = DB::table('EMPLOYEE_LEAVE')->select('DESCRIPTION')->get();
		//return response()->json(['PLACE_MASTER' => $place], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	
	
	public function leaves(Request $request){
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
			$code = $request->login_id;
		try {
			

//$leaves = DB::select(" select A.EMPLOYEE_CODE,  CASE WHEN CAST(FROM_DATE AS NCHAR)=CAST(TO_DATE AS NCHAR) THEN SUBSTRING(CAST(FROM_DATE AS NCHAR),1,10) ELSE SUBSTRING(CAST(FROM_DATE AS NCHAR),1,10)++'-'++SUBSTRING(CAST(TO_DATE AS NCHAR),1,10) END++' - '++ REASON AS DESCRIPTION ,B.LEAVE_STATUS ,CASE WHEN  UPPER(B.LEAVE_STATUS) = 'APPROVED' THEN 'A'  WHEN  UPPER(B.LEAVE_STATUS) = 'REJECTED' THEN   'R' ELSE 'P' END AS STATUS_CODE    from LEAVEAPPLICATION_DETAILS A  INNER JOIN LEAVEAVAILED_DETAILS B ON A.EMPLOYEE_CODE =B.EMPLOYEE_CODE AND A.LEAVE_NO =B.LEAVE_NO      WHERE A.EMPLOYEE_CODE IN(SELECT CODE FROM EMPLOYEE WHERE CODE =?)", [$code]);
$leaves = DB::select("select a.employee_code,
       case
           when cast(from_date as char)=cast(to_date as char) then substring(cast(from_date as char),1,10)
           else concat(substring(cast(from_date as char),1,10), '-', substring(cast(to_date as char),1,10))
       end as description,
       b.leave_status,
       case
           when upper(b.leave_status) = 'approved' then 'a'
           when upper(b.leave_status) = 'rejected' then 'r'
           else 'p'
       end as status_code
from leaveapplication_details a
inner join leaveavailed_details b on a.employee_code = b.employee_code and a.leave_no = b.leave_no
where a.employee_code in (select code from employee where code = ?)", [$code]);


		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'LEAVESTATUS' => $leaves], 200);
		
		
		//$place = DB::table('EMPLOYEE_LEAVE')->select('DESCRIPTION')->get();
		//return response()->json(['PLACE_MASTER' => $place], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}
	
	
	
	//select Leave_name ,Balance  from EMPLOYEE_LEAVE where code ='00007'
	
	
public function leaveinsert(Request $request){
	
	
	
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'leavetype' => 'required', 
			'leaveduration' => 'required', 
			'startdate' => 'required', 
			'enddate' => 'required', 
			'reason' => 'required', 
			'noofdays' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
		$leavetype = $request->leavetype;
		$leaveduration = $request->leaveduration;
		$startdate = $request->startdate;
		$enddate = $request->enddate;
		$reason = $request->reason;
		$noofdays =$request->noofdays;
		$carbonDate = Carbon::parse($startdate);
		$financialyear = $carbonDate->year;
		
		
		$carbonFromDate = Carbon::parse($startdate);
		$carbonToDate = Carbon::parse($enddate);

		// Check if both dates belong to the same month and year
		if ($carbonFromDate->year == $carbonToDate->year && $carbonFromDate->month == $carbonToDate->month) {
			//echo "Both dates belong to the same month and year.";
		} else {
					return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => 'Start date and end date must be of same month !'], 200);
		}


		//echo $year; // Output: 2025

		//$financialyear =$request->financialyear;
		//$branchcode='CBE';
		//$employeename='GOPINATH';
		
		$leavestatus='REQUESTED';
		
		//get employe details based on login id
		$getemployeedetail = self::getemployeedetials($login_id);
		if($getemployeedetail['status'] == 0)
		{
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => 'EMPLOYEE DETAILS NOT FOUND'], 200);
		}
		
		$isleaveapprovalpending = self::checkifleaveapprovalispending($login_id);
		if($isleaveapprovalpending == 0)
		{
			$message['details']= 'PREVIOUS LEAVE IS IN APPROVAL STATUS. CANNOT APPLY NEW LEAVE';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
		}
		
		
		$isleavealreadyupdated = self::checkifleavealreadyupdated($login_id,$startdate,$enddate);
		if($isleavealreadyupdated == 1)
		{
			$message['details']= 'LEAVE/PERMISSION ALREADY UPDATED FOR THE GIVEN DATE';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
		}
		//get holiday details based on branch and date range
		$isholiday = self::checkifholiday($getemployeedetail['branch_code'],$startdate,$enddate);
		if($isholiday['status'] == 1)
		{
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $isholiday], 200);
		}
		
		//var_dump($isholiday);
		//self::checkifshiftisavailable($login_id,$isholiday['details']);
		//var_dump($isholiday['details']);
		$isshiftavailable = self::checkifshiftisavailable($login_id,$isholiday['details']);
		//var_dump($isshiftavailable);
		if($isshiftavailable['status'] == 1)
		{
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $isshiftavailable], 200);
		}
		
	$result = DB::select("SELECT balance FROM employee_leave WHERE code=? AND leave_code=? AND financial_year=?", [$login_id, $leavetype, $financialyear]);

if (!empty($result)) {
    $balace = $result[0]->balance;
} else {
    $balace = 0; 
}

		
		if($noofdays>$balace)
		{
			$message['details']= 'LEAVE DAYS COUNT EXEEDED';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
		}
		
		
//		var_dump($isshiftavailable);
		
		//check if shift is available
		
		//select * from LEAVEAPPLICATION_DETAILS where EMPLOYEE_CODE = '' LEAVE_STATUS = 'Requested';
		
		try {
			
			$result = DB::select("SELECT IFNULL(MAX(LEAVE_NO), 0) + 1 as max_docno FROM leaveapplication_details");
            $maxDocNo = $result[0]->max_docno;
			
			$results = DB::select("select name,branch_code from employee where code=?",[$login_id]);
            $employeename = $results[0]->name;
			$branchcode=$results[0]->branch_code;
			
			 // DB::insert('insert into leaveapplication_details (leave_no ,branch_code ,employee_code ,employee_name ,from_date ,to_date ,reason ,leave_status,no_of_days ,created_userid ,created_date,leavetype) values (?,?,?,?,?,?,?,?,?,?,CURDATE(),?)', [$maxDocNo,$branchcode,$login_id,$employeename,$startdate,$enddate,$reason,$leavestatus,$noofdays,$login_id,$leavetype]);
			 DB::insert('INSERT INTO leaveapplication_details 
    (leave_no, branch_code, employee_code, employee_name, from_date, to_date, reason, leave_status, no_of_days, created_userid, created_date, leavetype) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURDATE(), ?)', 
    [$maxDocNo, $branchcode, $login_id, addslashes($employeename), $startdate, $enddate, $reason, $leavestatus, $noofdays, $login_id, $leavetype]);

			 //$getdateslist = self::listdates($startdate,$enddate);
			 foreach($isshiftavailable['details'] as $date)
			 {
				 if($date['datestatus'] =='OK')
				 {
					 if($noofdays <> '0.5')
					 {
						 $noofdays = '1';
					 }
					 $leavedate = $date['date'];
					DB::insert('insert into leaveavailed_details(LEAVE_no,BRANCH_CODE,employee_CODE,employee_NAME,LEAVE_date,LEAVE_FOR,LEAVE_COUNT,LEAVE_status,FH_leavetype,SH_leavetype) VALUES (?,?,?,?,?,?,?,?,?,?)', [$maxDocNo,$branchcode,$login_id,$employeename,$leavedate,$leaveduration,$noofdays,$leavestatus,$leavetype,$leavetype]);
				 }
			 }
			 
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}

        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
		
		
	}
	
	
	public function checkifleavealreadyupdated($login_id,$startdate,$enddate){
		$getdateslist = self::listdates($startdate,$enddate);
		$isalreadyapplied = 0;
		foreach($getdateslist  as $date)
		{
			$details = DB::SELECT("select * from leaveavailed_details where employee_CODE = ?  and 	LEAVE_status = ? and LEAVE_DATE = ?",[$login_id, 'Approved',$date]);
			if($details)
			{
				$isalreadyapplied = 1;
			}
			
			
			$details = DB::SELECT("SELECT * FROM permission_details where employee_code =? and PER_status=? and PER_DATE=? ",[$login_id, 'Approved',$date]);
			if($details)
			{
				$isalreadyapplied = 1;
			}
		}
		return $isalreadyapplied;
	}
	
	
	public function checkifleaveapprovalispending($login_id){
		$allownewleave=1;
		$isleaveapprovalpending = DB::SELECT("select * from leaveapplication_details where employee_code = ? and leave_status = ?",[$login_id,'Requested']);
		if($isleaveapprovalpending){
		$allownewleave=0;	
		}
		return $allownewleave;
	}
	
	
	public function getemployeeshiftdetails(Request $request){
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
	
		$dates = self::getcurrentdate();
			$details = self::checkifshiftisavailable($login_id,$dates);
			$shiftno = $details['details'][0]['shiftno'];
			
			$shifttimearr = DB::SELECT("select  concat( LPAD(OFFICE_STARThrs, 2, '0'),':',LPAD(OFFICE_STARTMIN, 2, '0'),' - ',LPAD(OFFICE_ENDHRS, 2, '0'),':',LPAD(OFFICE_ENDMIN, 2, '0'))  as shifttime  from shift_master sm where shiftid = '101'");
			$shifttime=$shifttimearr[0]->shifttime;
			$shiftdetails['shift_id'] = $shiftno;
			$shiftdetails['shift_time'] = $shifttime;
			
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'shiftdetails' => $shiftdetails], 200);
		
		}
		
	public function getcurrentdate()
	{
		//SELECT DATE(NOW()) AS date;
		$dates = array();
		$date = DB::select("SELECT DATE(NOW()) AS date");
		
		$dates[0]['date'] = $date[0]->date;
		$dates[0]['datestatus'] = 'OK';
		return $dates; // This will output the current date without the time portion
	}		
	public function checkifshiftisavailable($login_id,$dates){
		
		$shiftdetails = array();
		$shiftdetails['status']=1;
		$shiftdetails['message'] = "BELOW DATES SHIFT NOT ALLOTED:";
		
		//var_dump($dates);
		foreach($dates as $key => $date)
		{
			//var_dump($date);
			if($date['datestatus'] == "NO LEAVE")
			{
				$shiftdetails['details'][$key]['datestatus']=$date['datestatus'];
				$shiftdetails['details'][$key]['date']=$date['date'];
				$shiftdetails['details'][$key]['particulars']=$date['particulars'];
				//$isholiday['details'][$i]['particulars'] = $date['PARTICULARS'];
			}
			else if($date['datestatus'] == 'OK')
			{
				$mydate=$date['date'];
				$year = date('Y', strtotime($mydate));
				$month = date('m', strtotime($mydate));
				$day = date('d', strtotime($mydate));
				$columnname = "DAY".$day."SHIFT";


				
				$shiftdetailsarray = DB::SELECT("select $columnname from pshift_new where maincode =? and year=? and month=?",[$login_id,$year,$month]);
				
				if($shiftdetailsarray)
				{
					if($shiftdetailsarray[0]->$columnname == '-1')
					{
						$shiftdetails['details'][$key]['datestatus']="NO LEAVE";
						$shiftdetails['details'][$key]['date']=$date['date'];
						$shiftdetails['details'][$key]['particulars']="NO SHIFT";
						$shiftdetails['details'][$key]['shiftno'] = $shiftdetailsarray[0]->$columnname;
						//failure
					}
					else
					{
						$shiftdetails['details'][$key]['datestatus']="OK";
						$shiftdetails['details'][$key]['date']=$date['date'];
						$shiftdetails['status']=0;
						$shiftdetails['details'][$key]['shiftno'] = $shiftdetailsarray[0]->$columnname;
						//success
					}
				}
				else
				{
					$shiftdetails['details'][$key]['datestatus']="NO LEAVE";
					$shiftdetails['details'][$key]['date']=$date['date'];
					$shiftdetails['details'][$key]['particulars']="NO SHIFT";
					$shiftdetails['details'][$key]['shiftno'] = '-1';
					//failure
				}
				
			}
				
		}
		return $shiftdetails;
	}
	
	public function getemployeedetials($code){
		
			
			$employeedetails = DB::select("select name,branch_code,TravelEligibility from employee where code=?",[$code]);
			if($employeedetails)
			{
			$employeedetail['status'] = '1';
            $employeedetail['name'] = $employeedetails[0]->name;
			$employeedetail['branch_code'] =$employeedetails[0]->branch_code;
			$employeedetail['traveleligibility'] =$employeedetails[0]->TravelEligibility;
			}
			else
			{
				$employeedetail['status'] = '0';
			}
			return $employeedetail;
	}
		
		
	public function listdates($startdate,$enddate){
		//$start = new DateTime($startdate);
		//$end = new DateTime($enddate);
		$start = Carbon::createFromFormat('Y-m-d', $startdate);
		$end = Carbon::createFromFormat('Y-m-d', $enddate);
		$dates = array();
		// Iterate through each date and print it
		while ($start->lte($end)) {
			$dates[] = $start->toDateString();
			$start->addDay();
		}
		return $dates;
	}
	
	public function checkifholiday($branch_code,$startdate,$enddate){
		
		//echo $startdate;
		//echo $enddate;
		
		$getdateslist = self::listdates($startdate,$enddate);
		$isholiday = array();
		$isholiday['status'] = 1;
		$isholiday['message'] = "BELOW DATE ARE HOLIDAYS:";
		$i = 0;
		foreach($getdateslist as $getdate)
		{
			$checkifholiday = DB::select("select date(TRNDATE) as forthedate,PARTICULARS from holidays  where TRNDATE =? and branch_code=?",[$getdate,$branch_code]);
			if($checkifholiday)
			{
				
				$isholiday['details'][$i]['datestatus'] = "NO LEAVE";
				$isholiday['details'][$i]['date'] = $checkifholiday[0]->forthedate;
				$isholiday['details'][$i]['particulars'] = $checkifholiday[0]->PARTICULARS;
				
			}
			else
			{
				$isholiday['details'][$i]['datestatus'] = "OK";
				$isholiday['details'][$i]['date'] = $getdate;
				$isholiday['status'] = 0;
				
			}
			$i++;
		}
		return $isholiday;
		
	}
		
		
	
	public function permission(Request $request){
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'perdate' => 'required', 
			'fromtime' => 'required', 
			'totime' => 'required', 
			'reason' => 'required', 
			'totaltime' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
		
		$startdate = $request->perdate;
		$fromtime = $request->fromtime;
		$totime = $request->totime;
		$reason = $request->reason;
		$totaltime =$request->totaltime;
		//$branchcode='CBE';
		//$employeename='GOPINATH';
		
			$results = DB::select("select name,branch_code from employee where code=?",[$login_id]);
            $employeename = $results[0]->name;
			$branchcode=$results[0]->branch_code;
		    $perstatus='REQUESTED';
			
	
		// $isleavealreadyupdated = self::checkifleavealreadyupdated($login_id,$startdate,$startdate);
		// if($isleavealreadyupdated == 1)
		// {
			// $message['details']= 'LEAVE/PERMISSION ALREADY UPDATED FOR THE GIVEN DATE';
			// return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
		// }
		
		$policy = DB::select("select permission_maxtime ,permission_monthhrs,permission_monthnos, permission_yearnos from policy where branch_code =?",[$branchcode]);
			$permission_maxtime = $policy[0]->permission_maxtime;
			$permission_monthhrs = $policy[0]->permission_monthhrs;
			$permission_monthnos = $policy[0]->permission_monthnos;
			$permission_yearnos = $policy[0]->permission_yearnos;
			
			if($totaltime >$permission_maxtime )
			{
				$message['details']= 'PERMISSION HOURS EXEEDED FOR THE '.$permission_maxtime.' HOURS';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
			}
			
			$start = Carbon::createFromFormat('Y-m-d', $startdate);
			
			
			$mydate=$start;
				$year = date('Y', strtotime($mydate));
				$month = date('m', strtotime($mydate));
				$day = date('d', strtotime($mydate));
				$FORMATDATE = $year."-".$month;
			
			
			$permission_count =DB::select("select count(*) percount  from permission_details where  employee_code=? and  date_format(date(per_date), '%Y-%m')=?",[$login_id,$FORMATDATE]);
			$percount=$permission_count[0]->percount;
			
			if ($percount>=$permission_monthnos)
			{
				$message['details']= 'PERMISSION COUNT EXEEDED FOR THE MONTH';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
			}
			
			$permission_countyear =DB::select("select count(*) percountyear  from permission_details where  employee_code=? and  date_format(date(per_date), '%Y')=?",[$login_id,$year]);
			$percountyear=$permission_countyear[0]->percountyear;
			
			if ($percountyear>=$permission_yearnos)
			{
				$message['details']= 'PERMISSION COUNT EXEEDED FOR THE YEAR';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
			}
			

				$month_pre_permosion =DB::select("select round(sum(hour(total_time)) + sum(minute(total_time)) / 60, 2) as total_time_decimal from permission_details where employee_code = ? and date_format(per_date, '%Y-%m') = ?",[$login_id,$FORMATDATE]);
				
				
			    $month_pre_permosionvalue=$month_pre_permosion[0]->total_time_decimal;
				
				list($hours, $minutes) = explode(':', $totaltime);
				$decimalTime = (int)$hours + ((int)$minutes / 60);
				$formattedTime = number_format($decimalTime, 2);
				
				
				
				
				$total=$month_pre_permosionvalue+$formattedTime;
				if($total>$permission_monthhrs)
				{
					$message['details']= 'PERMISSION HOURS EXEEDED FOR THE MONTH';
			        return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
				}
		
		try {
			
			$result = DB::select("SELECT IFNULL(MAX(PER_NO), 0) + 1 as max_docno FROM permission_details");
            $maxDocNo = $result[0]->max_docno;
			$exists = DB::table('permission_details')
    ->where('per_date', $startdate)
    ->where('employee_code', $login_id)
    ->exists();

if ($exists) {
    	$message['details']= 'Permission already exists for this date and employee.';
			        return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
    
} else {
    DB::insert('insert into permission_details (per_no ,branch_code ,employee_code ,employee_name ,per_date,from_time ,to_time ,reason ,per_status,total_time ,created_userid ,created_date) values (?,?,?,?,?,?,?,?,?,?,?,CURDATE())', [$maxDocNo,$branchcode,$login_id,$employeename,$startdate,$fromtime,$totime,$reason,$perstatus,$totaltime,$login_id]);
   
}

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}

        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
		
 }
	
	
	public function onduty(Request $request){
		
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'startdate' => 'required', 
			'enddate' => 'required', 
			'fromtime' => 'required', 
			'reason' => 'required', 
			'visitplace' => 'required', 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
		$startdate = $request->startdate;
		$enddate = $request->enddate;
		$fromtime = $request->fromtime;
		$totime = $request->totime;
		$reason = $request->reason;
		$noofdays =$request->noofdays;
		$visitplace=$request->visitplace;
		//$branchcode='CBE';
		//$employeename='GOPINATH';		
		$odstatus='REQUESTED';
		
		        $mydate=$startdate;
				$year = date('Y', strtotime($mydate));
				$startmonth = date('m', strtotime($mydate));
				$endmonth = date('m', strtotime($enddate));
				$day = date('d', strtotime($mydate));
				
				if($startmonth<>$endmonth)
				{
					$message['details']= 'MULTIPLE MONTH DATES NOT ALLOWED IN ON DUTY';
			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
				}
			
		
		
		$results = DB::select("select name,branch_code from employee where code=?",[$login_id]);
            $employeename = $results[0]->name;
			$branchcode=$results[0]->branch_code;
		try {
			
		
			
			$result = DB::select("select ifnull(max(od_no), 0) + 1 as max_docno from odapplication_details");
            $maxDocNo = $result[0]->max_docno;
            $existing = DB::table('odapplication_details')
    ->where('employee_code', $login_id)
    ->where('from_date', $startdate)
    ->count();
            if ($existing > 0) {
    	$message['details']= 'OD Already applied for this date';
  			return response()->json(['message'=> 'Failure','status_code'=> 401,'text' => $message], 200);
} else {
			
			 DB::insert('insert into odapplication_details (od_no ,branch_code ,employee_code ,employee_name ,from_date,to_date,from_time ,to_time ,visitingplace,purpose ,od_status,no_of_days ,created_userid ,created_date) values (?,?,?,?,?,?,?,?,?,?,?,?,?,curdate())', [$maxDocNo,$branchcode,$login_id,$employeename,$startdate,$enddate,$fromtime,$totime,$visitplace,$reason,$odstatus,$noofdays,$login_id]);
}
$getdateslist = self::listdates($startdate,$enddate);


 foreach($getdateslist as $date)
			 {		
		     $oddate = $date;	
			 $odtype='OD';
			 $odfor='FULLDAY';
			 $odcount='1';
			 
			
			 DB::insert('insert into odavailed_details(od_no,branch_code,employee_code,employee_name,od_date,od_type,od_status,od_for,od_count) values (?,?,?,?,?,?,?,?,?)', [$maxDocNo,$branchcode,$login_id,$employeename,$oddate,$odtype,$odstatus,$odfor,$odcount]);
			 }




			 
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}

        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
		
		
	}
	
	public function getpunch(Request $request){
		
		$code = $request->code;
		
		$date = $request->dates;
		
			try {
			//select Leave_name ,Balance  from EMPLOYEE_LEAVE where code in(select code from EMPLOYEE  where maincode='10024')
	//DB::select('EXEC SP_GETUSERINFO ?, ?', [$user_group, $branch]);
	
	  // $punch = DB::select('CALL IT_GETLOGIN (?, ?)',[$date ,$code]);
	  $punch = DB::select('call edp_getlogdata (?, ?)',[$date ,$code]);
	  
	 
			//$punch = DB::select('EXEC IT_GETLOGIN ?,?',);
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'PUNCH' => $punch], 200);
		
	}
	
	
	public function getmonthdays(Request $request){
		
		$code = $request->code;
		
		$date = $request->dates;
		//$code = '10024'
		//$date ='FEB-2024'
		$date = $request->dates;
		
			try {
	 
 $monthday =DB::select('call PROC_ATTENEXTRACTION (?, ?)',[$code ,$date]);
	 // $monthday = DB::select("
   // select 
        // sum(cast(attencnt as float)) as presentdays,
        // sum(cast(absday as float)) as absdays
    // from emp_hr_monthly_extraction
    // where 
        // code in (select code from employee where maincode = ?) 
        // and format(attend_date, 'MMM-yyyy') = ?

// ", [$code, $date]);
	  
	 
			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'MNTH_DAYS' => $monthday], 200);
		
	}


	
	
	public function ChangePassword(Request $request){
        //$user_mob = $request->mobile_no;
		
		$validator = Validator::make($request->all(), [
			'login_id' => 'required',  
			'old_password' => 'required',  
			'new_password' => 'required',  
		]);

		if ($validator->fails()) {
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
		$login_id = $request->login_id;
		$old_password = $request->old_password;
		$new_password = $request->new_password;
		
		$DBPassWord = DB::select("select LOGIN_PWD as password from employee where code='$login_id'");
		$password = '';
		foreach($DBPassWord as $pass){
			$password = $pass->password;
		}

		if($old_password != $password)
		{
			return response()->json(['message'=> "OLD PASSWORD DOES NOT MATCH",'status_code'=> "400"], 400);
			die;
		}
		else
		{
			$hashpassword = Hash::make($new_password);
			$UPDATEPASSWORD = DB::update("UPDATE employee SET LOGIN_PWD= '$new_password',password = '$hashpassword' WHERE code='$login_id'");
			return response()->json(['message'=> 'PASSWORD HAS BEEN UPDATED SUCCESSFULLY','status_code'=> 200], 200);
		}
		
    }
	
	
	
	//select sum(cast(ATTENCNT as float)) presentdays ,sum(cast(ABSDAY as float))  absdays  from EMP_HR_MONTHLY_EXTRACTION  where code in(select code from employee where maincode ='10024') and FORMAT (ATTEND_DATE ,'MMM-yyyy')='FEB-2024'
	
	
    	public function getbranch(Request $request){
		
		
		
		$login_id = $request->login_id;
		
		
		
		
			try {
		
	
	 
	 $branch =DB::select('SELECT branch as code , branchname  as name  FROM branch_mapping WHERE code =? and status=1 order by branch',[$login_id]);
	
	 
			
		
		}catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getbranch' => $branch], 200);
		
	}
	public function getemployee(Request $request){

		$login_id = $request->login_id;

			try {
 
	// $branch =DB::select('select A_EMPLOYEECODE as code ,A_EMPLOYEENAME as name from  new_authority where maincode =?',[$login_id]);
	 //$branch =DB::select('select e.code,e.name  from branch_admin na inner join employee e on na.AUTHORITY_CODE = e.BRANCH_CODE  where na.CODE = ?',[$login_id]);
	  $branch =DB::select('select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code = ?',[$login_id]);
		} catch (\Exception $e) {
           return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getemployee' => $branch], 200);
		
	}
	
	
	
 public function createdevicemapping(Request $request){
        	
		$validator = Validator::make($request->all(), [
			'employee_id' => 'required', 
			'device_id' => 'required',
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $login_id = $request->login_id;
        $device_id = $request->device_id;
        $employee_id = $request->employee_id;
      
	  
	  $devicemapping =DB::select("select count(*) as cnt from  device_mapping where loginid = ?",[$employee_id]);
	 // echo $devicemapping[0]->cnt;
	 if ($devicemapping[0]->cnt > 0) 
	  {
		 $updatedevice =DB::UPDATE("update device_mapping set deviceid=?,modifiedby=?,modifiedon=curdate() where loginid=?" ,[$device_id,$login_id,$employee_id]);
		 
		  $updatedeviceemployee =DB::UPDATE("update employee set Androidid=?  where code=?" ,[$device_id,$employee_id]);
		 
		 Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Updated successfully.'], 200);
	  }
	  else
	  {
		   
		$createdevice = DB::INSERT("insert into device_mapping (loginid,deviceid,createdby,createdon) values (?,?,?,curdate());",[$employee_id,$device_id,$login_id]);
		
		$updatedeviceemployee =DB::UPDATE("update employee set Androidid=?  where code=?" ,[$device_id,$employee_id]);
		
		Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);

	  }
     

    }
	
	//PORTAL NEW API'S
	
	
	
public function getemployeelist(Request $request){
    $branchcode = $request->branchcode;
    $login_id = $request->login_id;

    try {
        if($branchcode === "ALL"){
			//$employeelist = DB::SELECT("select e.code,e.name  from branch_admin na inner join employee e on na.AUTHORITY_CODE = e.BRANCH_CODE  where na.CODE=? and e.RESIGN_TAG is null,[$login_id]");
				$employeelist = DB::SELECT("select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code = ?  and e.RESIGN_TAG is null",[$login_id]);
          //  $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.resign_tag is null');
        } else {
		//	$employeelist = DB::SELECT("select e.code,e.name  from branch_admin na inner join employee e on na.AUTHORITY_CODE = e.BRANCH_CODE  where na.CODE = ? and na.AUTHORITY_CODE=? and e.RESIGN_TAG is null",[$login_id,$branchcode]);
			$employeelist = DB::SELECT("select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code = ? and na.branch=? and e.RESIGN_TAG is null",[$login_id,$branchcode]);
         //   $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.branch_code = ? and b.resign_tag is null', [$branchcode]);
        }
    } catch (\Exception $e) {
        return response()->json([
            'message'=> 'Failure',
            'status_code'=> 400,
            'text' => $e->getMessage()
        ], 200);
    }

    return response()->json([
        'message'=> "SUCCESS",
        'status_code'=> "200",
        'getemployeelist' => $employeelist
    ], 200);
}
	
	
	// public function getshifts(Request $request)
    // {
        // $fromDate = $request->fromDate;
        // $toDate = $request->toDate;
        // $unit = $request->unit;

        // try {
            // // Assuming self::listdates() is defined somewhere to fetch dates
            // $getdateslist = self::listdates($fromDate, $toDate);

            // // Fetching shifts data from the database
            // $shiftDetails = DB::select("
                // SELECT shiftid,shiftid as shiftcode, CONCAT(shiftid, '-', shiftname) AS shiftname
                // FROM shift_master
                // ORDER BY shiftname
            // ");

            // // Returning the response
            // return response()->json([
                // 'message' => "SUCCESS",
                // 'status_code' => "200",
                // 'shiftdate' => $getdateslist,
                // 'shiftdetail' => $shiftDetails
            // ], 200);

        // } catch (\Exception $e) {
            // // Handling any exceptions
            // return response()->json([
                // 'message' => 'Failure',
                // 'status_code' => 400,
                // 'text' => $e->getMessage()
            // ], 200);
        // }
    // }

public function getshifts(Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $unit = $request->unit;
		
		$start = Carbon::createFromFormat('Y-m-d', $fromDate);
		$end = Carbon::createFromFormat('Y-m-d', $toDate);
           
            $startmonth = $start->month;
			$endmonth =  $end->month;
			// echo $startmonth ;
			// echo $endmonth ;
			if($startmonth==$endmonth)
			{	
			

        try {
            // Assuming self::listdates() is defined somewhere to fetch dates
            $getdateslist = self::listdates($fromDate, $toDate);

            // Fetching shifts data from the database
            $shiftDetails = DB::select("
                SELECT shiftid,shiftid as shiftcode, CONCAT(shiftid, '-', shiftname) AS shiftname
                FROM shift_master
                ORDER BY shiftname
            ");

            // Returning the response
            return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'shiftdate' => $getdateslist,
                'shiftdetail' => $shiftDetails
            ], 200);

        } catch (\Exception $e) {
            // Handling any exceptions
            return response()->json([
                'message' => 'Failure',
                'status_code' => 400,
                'text' => $e->getMessage()
            ], 200);
        }
			}
			else{
				return response()->json(['message'=> "Failure", 'status_code'=> "400", 'text' => 'SELECT FROM DATE AND END DATE AS SAME MONTH'], 200);
			}
    }	
	
	
	public function updateshift(Request $request) {
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			'selectedEmployees' => 'required',
			'shifts' => 'required',
			'unit' => 'required',
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 200);
		}
    $login_id = $request->login_id;
    $selectedEmployees = $request->selectedEmployees;
    $shifts = $request->shifts;
    //$fromDate = $request->fromDate;
	$unit = $request->unit;
	
	foreach ($shifts as $shift) {
		//$shiftid = $shift['shiftId'];
		if($shift['shiftId'] == "")
		{
				return response()->json(['message'=> "Failure", 'status_code'=> "400", 'text' => 'ENSURE SHIFT NAME IS SELECTED FOR ALL DATES'], 200);
		}
	}
	
	
	try{

    foreach ($selectedEmployees as $employee) {
        foreach ($shifts as $shift) {
            $shiftid = $shift['shiftId'];
            $shiftdate = $shift['date'];

            $start = Carbon::createFromFormat('Y-m-d', $shiftdate);
            $year = $start->year;
            $month = $start->month;
            //$day = $start->day;
 $day = str_pad($start->day, 2, '0', STR_PAD_LEFT);
            $columnname = "DAY{$day}SHIFT";
            $isdataavailable = DB::select("select * from pshift_new where  maincode = ? AND year = ? AND month = ?", [$employee, $year, $month]);
            // Assuming you have			the correct table name and column names, modify this query accordingly
			if($isdataavailable)
			{
            $query = "UPDATE pshift_new SET {$columnname} = ?, modifiedby = ?, modifiedon = CURDATE() WHERE maincode = ? AND year = ? AND month = ?";
            DB::update($query, [$shiftid, $login_id, $employee, $year, $month]);
			}
			else
			{
				$employeedetails = DB::select("select company_code from employee where code = ? ", [$employee]);
            
				DB::INSERT("insert into pshift_new ({$columnname},modifiedby,modifiedon,maincode,year,month,companycode,swipecardno,unit_code,createdby,createdon) values (?,?,CURDATE(),?,?,?,?,?,?,?,CURDATE()) ",[$shiftid, $login_id,$employee, $year, $month,$employeedetails[0]->company_code,$employee,$unit,$login_id]);
			}
        }
    }

    return response()->json(['message'=> "SUCCESS", 'status_code'=> "200", 'text' => 'Data Updated successfully.'], 200);
	}
	catch(\Exception $e){
		    return response()->json(['message'=> "Failure", 'status_code'=> "400", 'text' => 'Data Not Updated.'], 200);
	}
	
}



public function createmanualpunch(Request $request) {
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        //'image' => 'required|string', // Changed to string because it's a base64 encoded string
        'login_id' => 'required', // Changed to string because it's a base64 encoded string
        'employeecode' => 'required', // Changed to string because it's a base64 encoded string
        'dateTime' => 'required', // Changed to string because it's a base64 encoded string
        'manualreason' => 'required', // Changed to string because it's a base64 encoded string
    ]); 

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $login_id = $request->login_id;
    $employeecode = $request->employeecode;
    $dateTime = $request->dateTime;
    $manualreason = $request->manualreason;
   
	 
	
	try {
		
		
		$getuserdetails = self::getemployeedetials($login_id);
		
		
			
			$results = DB::select("select name,swipecardno from employee where code=?",[$employeecode]);
            $employeename = $results[0]->name;
			$swipecardnumber=$results[0]->swipecardno;
			$status='IN';
			$currentDateTimeFormatted = Carbon::now('Asia/Kolkata');
			$time = Carbon::parse($dateTime)->format('H:i');
			$location='MANUAL PUNCH';
			
			DB::insert('insert into hr_daily_atten (login_id, name, status, sdate, usertime, location,manual_reason) values (?, ?, ?, ?, ?, ?,?)', [$swipecardnumber, $employeename, $status,$dateTime,$time, $location,$manualreason]);
			DB::insert('insert into grs_daily_atten (login_id, name, status, sdate, usertime, location,manual_reason) VALUES (?, ?, ?, ?, ?, ?,?)', [$swipecardnumber, $employeename, $status,$dateTime,$time, $location,$manualreason]);
			
			DB::insert('insert into manual_punch_history (code, name, date,manual_reason,createdby) VALUES (?, ?, ?, ?, ?)', [$swipecardnumber,$employeename, $dateTime,$manualreason,$login_id]);
			
             Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}

 public function UpdateResignation(Request $request){
	
		$validator = Validator::make($request->all(), [
			  'str'=>'required',
        'rdate'=>'required',
        'txtReason'=>'required',
        'adate'=>'required',
        'redate'=>'required',
        'ldate'=>'required',
        'login_id'=>'required',
        'maincode'=>'required', 
        'branchcode'=>'required',
    
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}
		
        $str = $request->str;
        $rdate = $request->rdate;
        $txtReason = $request->txtReason;
        $login_id = $request->login_id;
        $maincode = $request->maincode;
        $branchcode = $request->branchcode;

		$rowsUpdated = DB::UPDATE("update employee set RESIGN_TAG=?,RESIGN_DATE=?,RESIGN_REASON=?,ACCEPT_DATE=?,RELIEVE_DATE=?,LETTER_DATE=?,MODIFIED_BY=? where BRANCH_CODE=? and CODE = ?",[$str,$rdate,$txtReason,$rdate,$rdate,$rdate,$login_id,$branchcode,$maincode]);

        if ($rowsUpdated >= 0) {
            return response()->json(['message' => 'Success', 'status' => '200','text'=>'Data Submitted Successfully'], 200);
		}else {
            return response()->json(['message' => 'Profile Details Not Found', 'status' => '401'], 401);
        }
    }
	public function Createtask(Request $request)
{
    $validator = Validator::make($request->all(), [
        'taskName' => 'required|string|max:40',
        'taskDetails' => 'required|string|max:40',
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    $taskName = $request->input('taskName');
    $taskDetails = $request->input('taskDetails');
    $loginid = $request->input('login_id');
    $createdOn = now();

    try {
        // Calculate Taskid by selecting max(Taskid) from TaskMaster table and incrementing it by 1
        $maxTaskId = DB::table('TaskMaster')->max('Taskid');
        $newTaskId = $maxTaskId + 1;

        // Insert new task into TaskMaster table
        DB::table('TaskMaster')->insert([
            'Taskid' => $newTaskId,
            'TaskName' => $taskName,
            'TaskDetails' => $taskDetails,
            'Active' => '1',
            'Created_by' => $loginid,
            'Created_on' => $createdOn,
        ]);

        return response()->json([
            'message' => 'Success',
            'status_code' => 200,
            'text' => 'Task inserted successfully!',
        ], 200);
    } catch (QueryException $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => 'Failed to insert task!',
            'error' => $e->getMessage(),
        ], 500);
    }
}
public function GetTaskDetails(Request $request)
{
	 $validator = Validator::make($request->all(), [
       
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    try {
        // Fetch active tasks from taskmaster table
        $tasks = DB::table('TaskMaster')
            ->select('Taskid', 'TaskName', 'TaskDetails')
            ->where('Active', '=', '1')
            ->orderBy('Taskid')
            ->get();

        return response()->json([
            'message' => 'Success',
            'status_code' => 200,
            'tasks' => $tasks,
        ], 200);
    } catch (QueryException $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => 'Failed to fetch active tasks!',
            'error' => $e->getMessage(),
        ], 500);
    }
}

public function attendanceextraction(Request $request)
{
	$login_id = $request->login_id;
	$date = $request->dates;
	 $selectedEmployees = $request->employee_code;
	 $type='A';
	 
	 try {
		
		
$dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

		
		$results = db::delete("delete from it_empcode where login_id=?",[$login_id]);
		
		foreach ($selectedEmployees as $employee) 
		{
			
			DB::insert('insert into it_empcode (login_id, MAINCODE) values (?, ?)', [$login_id,$employee]);
		}
		
		$attendanceextraction =DB::select('call PROC_ATTENEXTRACTION_GRS_NEW (?, ?,?)',[$login_id ,$dates,$type]);
		
		
		
              Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'attendanceextraction' => $attendanceextraction], 200);
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}

       public function GetTasklist(Request $request){
		
		 $validator = Validator::make($request->all(), [
       
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
		
		
		
		
		
		
			try {
		
	
	 
	 $task =DB::select('SELECT Taskid as code , Taskname as name,Taskdetails as description  FROM TaskMaster ');
	
	 
			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'gettask' => $task], 200);
		
	}
	 public function GetTaskDescription(Request $request){
		
		 $validator = Validator::make($request->all(), [
       
        'login_id' => 'required',
        'task_id' => 'required',
        'task_name' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
	}
		
			try {
		
	$taskid=$request->task_id;
	$taskname=$request->task_name;
	 
	 $task =DB::select('SELECT Taskdetails as description  FROM TaskMaster where taskid=? and taskname=?',[$taskid,$taskname]);
	
	 
			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}


        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'gettask' => $task], 200);
		
	}
	public function consolidateattendance(Request $request)
{
	$login_id = $request->login_id;
	$date = $request->dates;
	 $selectedEmployees = $request->employee_code;
	 $type='G';
	 
	 try {
		
		
$dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

		
		$results = db::delete("delete from it_empcode where login_id=?",[$login_id]);
		
		foreach ($selectedEmployees as $employee) 
		{
			
			DB::insert('insert into it_empcode (login_id, MAINCODE) values (?, ?)', [$login_id,$employee]);
		}
		
		$consolidateattendance =DB::select('call PROC_ATTENEXTRACTION_GRS_NEW (?, ?,?)',[$login_id ,$dates,$type]);
		
		
		
             Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'consolidateattendance' => $consolidateattendance], 200);
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}
public function getdesignation(Request $request){	
		$login_id = $request->login_id;	
			try {
 $designation =DB::select('select code ,name from designation');		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'designation' => $designation], 200);
	}
	
// insert into HR_DAILY_ATTEN (LOGIN_ID ,NAME ,STATUS,SDATE,USERTIME ,LOCATION,Image,latitude,longitude)VALUES(?,?,?,?,?,?,?,?,?)

   public function getdepartment(Request $request){	
		$login_id = $request->login_id;	
			try {
 $department =DB::select('select code ,name from department');		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'department' => $department], 200);
	}
public function checkmaincode(Request $request)
{
    try {
        $maincode = $request->maincode;
        $chk = DB::select("SELECT COUNT(*) as cnt FROM employee WHERE MAINCODE = ?", [$maincode]);

        $chkcnt = $chk[0]->cnt; 

        if ($chkcnt > 0) {
            return response()->json([
                'message' => 'EXIST',
                'status_code' => 200,
                'chkcnt' => $chkcnt
            ], 200);
        } else {
            return response()->json([
                'message' => 'NOT FOUND',
                'status_code' => 200,
                'chkcnt' => 0
            ], 200);
        }
    } catch (\Exception $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'error' => $e->getMessage()
        ], 400);
    }
}

	
 
    
public function getemployeepunch(Request $request)
{
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'from_date' => 'required|date_format:Y-m-d',
        'to_date' => 'required|date_format:Y-m-d',
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

    try {
        $login_id = $request->login_id;
        $from_date = $request->from_date;
        $to_date = $request->to_date;

        // Add one day to the to_date
        $to_date_plus_one_day = Carbon::parse($to_date)->addDay()->format('Y-m-d');

        // Perform database operations
        $dates = $request->from_date;
       // $dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

        // Delete previous records for the employee
        DB::delete("delete from it_empcode where login_id=?", [$login_id]);

        // Insert new record for the employee
        DB::insert('insert into it_empcode (login_id, MAINCODE) values (?, ?)', [$login_id, $login_id]);

        // Call stored procedure for attendance extraction
        $type = 'A';
        $attendanceextraction = DB::select('call PROC_ATTENEXTRACTION_GRS (?, ?, ?)', [$login_id, $dates, $type]);

        // Fetch reportee details
        $reportee_details = DB::select("SELECT BRANCHCODE, MAINCODE as EmployeeId, NAME, ATTEND_DATE, SHIFTID, FIRSTIN, LOUT as LastOut, perin, perout, finalmin, finalmax, ATTENCNT, cl as Leaves, absday, WEEKLYOFF, nfh as NFHolidays FROM grs_attext WHERE maincode = ? AND Attend_date BETWEEN ? AND ?", [$login_id, $from_date, $to_date_plus_one_day]);

        // Return success response with reportee details
        return response()->json(['message' => 'Success', 'status_code' => 200, 'reportee_details' => $reportee_details], 200);
    } catch (\Exception $e) {
        // Return failure response with error message
        return response()->json(['message' => 'Failure', 'status_code' => 400, 'text' => $e->getMessage()], 400);
    }
}


public function CreateEmployees(Request $request)
{
    
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'paybranch_code' => 'required',
        'paybranch_name' => 'required',
        'branch_code' => 'required',
        'branch_name' => 'required',
        'company_code' => 'required',
        'company_name' => 'required',
        'name' => 'required',
        'dept_code' => 'required',
        'dept_name' => 'required',
        'desig_code' => 'required',
        'desig_name' => 'required',
        'cadd1' => 'required',
        'cadd2' => 'required',
        'cplace' => 'required',
        'ccity' => 'required',
        'cstate' => 'required',
        'ccountry' => 'required',
        'cpin' => 'required',
        //'cphone' => 'required',
        'mobile' => 'required',
        //'emailid' => 'required',
        'sex' => 'required',
        'fname' => 'required',
        //'hname' => 'required',
        'dob' => 'required',
        'doj' => 'required',
       /// 'education' => 'required',
        'MSTATUS' => 'required',
        'Nominee_Name' => 'required',
        'EMER_CONT_NO' => 'required',
        //'AADHAAR_NUMBER' => 'required',
       // 'PAN_NUMBER' => 'required',
        'Pay_Type' => 'required',
        //'acnumber' => 'required',
        //'IFSC_CODE' => 'required',
        'PER_MONTH_WAGES' => 'required',
        'tour_eligible' => 'required',
        'empcategory' => 'required',
        //'maincode' => 'required',
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    // Get the maximum maincode value from the database
   // $maxTaskId = DB::table('employee')->max('maincode');
   $maxTaskId = DB::table('employee')
                ->where('maincode', '<>', 9999)
                ->max('maincode');
				$maxTaskId = (int) $maxTaskId; 
				//echo $maxTaskId;

    $newTaskId = $maxTaskId + 1;

    // Insert data into the database
    DB::table('employee')->insert([
        'code' => $newTaskId,
        'branch_code' => $request->input('branch_code'),
        'branch_name' => $request->input('branch_name'),
        'company_code' => $request->input('company_code'),
        'company_name' => $request->input('company_name'),
        'name' => $request->input('name'),
        'dept_code' => $request->input('dept_code'),
        'dept_name' => $request->input('dept_name'),
        'desig_code' => $request->input('desig_code'),
        'desig_name' => $request->input('desig_name'),
        'cadd1' => $request->input('cadd1'),
        'cadd2' => $request->input('cadd2'),
        'cplace' => $request->input('cplace'),
        'ccity' => $request->input('ccity'),
        'cstate' => $request->input('cstate'),
        'ccountry' => $request->input('ccountry'),
        'cpin' => $request->input('cpin'),
        'cphone' => $request->input('cphone'),
        'mobile' => $request->input('mobile'),
        'emailid' => $request->input('emailid'),
        'sex' => $request->input('sex'),
        'fname' => $request->input('fname'),
        'hname' => $request->input('hname'),
        'dob' => $request->input('dob'),
        'doa' => $request->input('doj'),
        'doj' => $request->input('doj'),
        'education' => $request->input('education'),
        'login_id' =>$newTaskId,
        'login_pwd' => '1234',
        'created_by' => $request->input('login_id'),
        'created_on' => now(),
        'ATTENDANCE' => 'Y',
        'maincode' =>$newTaskId,
        'SWIPECARDNO' => $newTaskId,
        'MSTATUS' => $request->input('MSTATUS'),
        'empcategory' => $request->input('empcategory'),
        'BLOODGROUP' => $request->input('BLOODGROUP'),
        'Nominee_Name' => $request->input('Nominee_Name'),
        'EMER_CONT_NO' => $request->input('EMER_CONT_NO'),
        'AADHAAR_NUMBER' => $request->input('AADHAAR_NUMBER'),
        'PAN_NUMBER' => $request->input('PAN_NUMBER'),
        'NSW' => '0',
        'SW' => '0',
        'Pay_Type' => $request->input('Pay_Type'),
        'acnumber' => $request->input('acnumber'),
        'IFSC_CODE' => $request->input('IFSC_CODE'),
        'basic' => $request->input('PER_MONTH_WAGES'),
        'PER_MONTH_WAGES' => $request->input('PER_MONTH_WAGES'),
        'TravelEligibility' => $request->input('tour_eligible'),
        'password' => '$2y$10$5rvdzvc6RkfWjzJdS2TBkeT3wLhiIE0B3vxgfjUO30Lj308get7yy',
        'att_allowances' => '0',
        'shk_allowances' => '0',
        'ISMW' => '0',
        'TOTAL_SALARY' => $request->input('PER_MONTH_WAGES'),
        'gpay_name' => $request->input('gpayname'),
        'gpay_number' => $request->input('gpayno'),
        'BANKNAME1' => $request->input('bank'),
        'PAY_BRANCH_CODE' => $request->input('paybranch_code'),
        'PAY_BRANCH_NAME' => $request->input('paybranch_name'),
		
    ]);

    // Return success response with the new employee ID
    return response()->json([
        'message' => 'SUCCESS',
        'status_code' => 200,
        'text' => 'Data Inserted successfully.',
        'employee_id' => $newTaskId,
    ], 200);
}


public function employeelistforupdate(Request $request){
		 $validator = Validator::make($request->all(), [
        'login_id' => 'required',
       
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

			try {

	// $emloyeelist =db::select('select distinct maincode as  code ,name as name from employee where resign_tag is null');
	$employeeList = DB::select("SELECT DISTINCT maincode AS code, name AS name FROM employee WHERE resign_tag IS NULL AND maincode NOT IN ('10000')");


		} catch (\Exception $e) {

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}

        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getemployeelist' => $employeeList], 200);
	}
	
	
	public function UpdateEmployees(Request $request)
{
    // Validate the incoming request data
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'maincode' => 'required',
        // 'branch_code' => 'required',
        // 'branch_name' => 'required',
        // 'company_code' => 'required',
        // 'company_name' => 'required',
        // 'name' => 'required',
        // 'dept_code' => 'required',
        // 'dept_name' => 'required',
        // 'desig_code' => 'required',
        // 'desig_name' => 'required',
        // 'cadd1' => 'required',
        // 'cadd2' => 'required',
        // 'cplace' => 'required',
        // 'ccity' => 'required',
        // 'cstate' => 'required',
        // 'ccountry' => 'required',
        // 'cpin' => 'required',
        // 'cphone' => 'required',
        // 'mobile' => 'required',
        // //'emailid' => 'required',
        // 'sex' => 'required',
        // 'fname' => 'required',
        // //'hname' => 'required',
        // 'dob' => 'required',
        // 'doj' => 'required',
      // /// 'education' => 'required',
        // 'MSTATUS' => 'required',
        // 'Nominee_Name' => 'required',
        // 'EMER_CONT_NO' => 'required',
        // 'AADHAAR_NUMBER' => 'required',
      // // 'PAN_NUMBER' => 'required',
        // 'Pay_Type' => 'required',
        // //'acnumber' => 'required',
        // //'IFSC_CODE' => 'required',
        // 'PER_MONTH_WAGES' => 'required',
        // 'tour_eligible' => 'required',
        // 'empcategory' => 'required',
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

  $maincode=$request->maincode;

    // Insert data into the database
    DB::table('employee')
	 ->where('maincode', $maincode)
	->update([
      
        'branch_code' => $request->input('branch_code'),
        'branch_name' => $request->input('branch_name'),
        'company_code' => $request->input('company_code'),
        'company_name' => $request->input('company_name'),
        'name' => $request->input('name'),
        'dept_code' => $request->input('dept_code'),
        'dept_name' => $request->input('dept_name'),
        'desig_code' => $request->input('desig_code'),
        'desig_name' => $request->input('desig_name'),
        'cadd1' => $request->input('cadd1'),
        'cadd2' => $request->input('cadd2'),
        'cplace' => $request->input('cplace'),
        'ccity' => $request->input('ccity'),
        'cstate' => $request->input('cstate'),
        'ccountry' => $request->input('ccountry'),
        'cpin' => $request->input('cpin'),
        'cphone' => $request->input('cphone'),
        'mobile' => $request->input('mobile'),
        'emailid' => $request->input('emailid'),
      'sex' => $request->input('sex'),
        'fname' => $request->input('fname'),
        'hname' => $request->input('hname'),
        'dob' => $request->input('dob'),
        'doa' => $request->input('doj'),
        'doj' => $request->input('doj'),
        'education' => $request->input('education'),
        'MODIFIED_BY' => $request->input('login_id'),
        'modified_on' => now(),
              'MSTATUS' => $request->input('MSTATUS'),
        'empcategory' => $request->input('empcategory'),
        'BLOODGROUP' => $request->input('BLOODGROUP'),
        'Nominee_Name' => $request->input('Nominee_Name'),
        'EMER_CONT_NO' => $request->input('EMER_CONT_NO'),
        'AADHAAR_NUMBER' => $request->input('AADHAAR_NUMBER'),
        'PAN_NUMBER' => $request->input('PAN_NUMBER'),
      
        'acnumber' => $request->input('acnumber'),
        'IFSC_CODE' => $request->input('IFSC_CODE'),
        'basic' => $request->input('PER_MONTH_WAGES'),
        'PER_MONTH_WAGES' => $request->input('PER_MONTH_WAGES'),
        'TravelEligibility' => $request->input('tour_eligible'),
        'TOTAL_SALARY' =>  $request->input('PER_MONTH_WAGES'),
        'gpay_name' => $request->input('gpayname'),
        'gpay_number' => $request->input('gpayno'),
        'BANKNAME1' => $request->input('bank'),
        'PAY_BRANCH_CODE' => $request->input('paybranch_code'),
        'PAY_BRANCH_NAME' => $request->input('paybranch_name'),
        
		
    ]);

    // Return success response with the new employee ID
    return response()->json([
        'message' => 'SUCCESS',
        'status_code' => 200,
        'text' => 'Data Updated successfully.',
      // 'employee_id' => $newTaskId,
    ], 200);
}

public function CreateTaskAssign(Request $request){
    $validator = Validator::make($request->all(), [
        'login_id' => 'required', 
        'task_id' => 'required',
        'task_name' => 'required',
        'task_details' => 'required',
       // 'status'=> 'required',
        'employeecode'=> 'required|array', // Ensure employeecode is an array
        'completedon'=> 'required',
        'employeename'=>'required|array',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    
    for($i = 0; $i < count($request->employeecode); $i++) {
        $maxTaskId = DB::table('EmployeeTask')->max('Transactionid');
        $newTaskId = $maxTaskId + 1;

        $createEmployeeTask = DB::table('EmployeeTask')->insert([
            'Transactionid' => $newTaskId,
            'Taskid' =>  $request->task_id,
            'TaskName' => $request->task_name,
            'EmployeeId' => $request->employeecode[$i],
            'TaskDetails' =>$request->task_details,
            'CreatedBy' => $request->login_id,
            'CreatedOn' => now(), 
            //'Status' =>'OPEN',
            'Status' =>'OPEN',
            'DateofCompletion' =>$request->completedon,
            'EmployeeName' => $request->employeename[$i],
        ]);
    }

    return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'text' => 'Data Inserted successfully.'], 200);
}


public function GetTaskAssignDetails(Request $request)
{
	 $validator = Validator::make($request->all(), [
       
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    try {
        // Fetch active tasks from taskmaster table
   $tasks = DB::table('EmployeeTask as et')
    ->select('et.Taskid', 'et.TaskName', 'et.TaskDetails', 'et.Transactionid', 'et.EmployeeId','et.EmployeeName', 'e.name as name', 'et.status', 'et.CreatedBy', 'et.createdon', 'et.DateofCompletion', 'et.isclosed', 'et.completedon')
    ->leftJoin('employee as e', 'e.maincode', '=', 'et.createdby')
    ->whereIn('et.status', ['OPEN', 'PENDING'])
    ->where(function($query) {
        $query->where('et.isclosed', '<>', 1)
              ->orWhereNull('et.isclosed');
    })
    ->orderBy('et.Transactionid')
    ->get();





        return response()->json([
            'message' => 'Success',
            'status_code' => 200,
            'tasks' => $tasks,
        ], 200);
    } catch (QueryException $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => 'Failed to fetch active tasks!',
            'error' => $e->getMessage(),
        ], 500);
    }
}

public function UpdateTaskStatus(Request $request) {
    // Validate the request data
    $validator = Validator::make($request->all(), [
        'login_id' => 'required', 
        'status' => 'required', 
        'transactionid' => 'required', 
        'maincode' => 'required',
        'comments' => 'required',
		
        //'isclosed'=>'required',
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    
    // Extract request data
    $status = $request->status;
    $login_id = $request->login_id;
    $transactionid = $request->transactionid;
    $maincode = $request->maincode;
    $comments = $request->comments;

    // Perform the update based on status
    if ($status == 'CLOSED') {
        $rowsUpdated = DB::update("UPDATE EmployeeTask SET status=?, statusupdatedby=?, statusupdatedon=?, isclosed=?, closedby=?,closedon=?,comments=? WHERE transactionid = ? AND employeeid=?", [$status, $login_id, now(), 1, $login_id, now(),$comments,$transactionid, $maincode]);
    } else {
        $rowsUpdated = DB::update("UPDATE EmployeeTask SET status=?, statusupdatedby=?, statusupdatedon=?,comments=? WHERE transactionid = ? AND employeeid=?", [$status, $login_id, now(),$comments, $transactionid, $maincode]);
    }

    // Check if the update was successful
    if ($rowsUpdated >= 0) {
        // Return success response
        return response()->json(['message' => 'Success', 'status' => '200', 'text' => 'Status Updated Successfully'], 200);
    } else {
        // Return failure response
        return response()->json(['message' => 'Status not Updated', 'status' => '401'], 401);
    }
}

public function getTaskforEmployee(Request $request){	
		$login_id = $request->login_id;	
			try {
$designation = DB::select('
    SELECT transactionid, taskname
    FROM EmployeeTask
    WHERE status = ? AND employeeid = ? AND (completedon IS NULL OR completedon = ?)', ['OPEN', $login_id, NULL]);
		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'taskname' => $designation], 200);
	}
	
    public function getTaskDetailsforEmployee(Request $request){	
		$login_id = $request->login_id;	
		$task_id = $request->task_id;	
		
			try {
 $designation = DB::select('
    SELECT et.*, e.name AS CreatedByName
    FROM EmployeeTask AS et
    INNER JOIN employee AS e ON et.CreatedBy = e.code
    WHERE et.Transactionid = ?', [$task_id]);
		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'taskname' => $designation], 200);
	}
	
	 public function getbranchdetail(Request $request){	
		$login_id = $request->login_id;	
			try {
 $getbranchdetail =DB::select('select code,name,group_name,oadd1,oadd2,oplace,ocity,ostate,opin,ophone1,emailid,latitude,longitude from branch');		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getbranchdetail' => $getbranchdetail], 200);
	}
	
	public function getshiftdetail(Request $request){	
		$login_id = $request->login_id;	
			try {
 $getshiftdetail =DB::select('select companycode,shiftid,shiftname,office_starthrs,office_startmin,office_start_tolmin,office_start_tolsec,office_endhrs,office_endmin,office_an_starthrs,office_an_startmin,lunch_starthrs,lunch_startmin,lunch_endhrs,lunch_endmin,daytag from shift_master');		
		} catch (\Exception $e) {
      
			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getshiftdetail' => $getshiftdetail], 200);
	}
	
	
// 	public function createshift(Request $request) {
// 		$validator = Validator::make($request->all(), [
// 			'login_id' => 'required', 
			 
// 		]);

// 		// Check if validation fails
// 		if ($validator->fails()) {
// 			// Validation failed, return error response
// 			return response()->json([
// 				'message' => $validator->errors()->all(),
// 				'status_code' => '400',
// 			], 200);
// 		}
// 			$login_id = $request->login_id;
// 			$shiftid= $request->shiftid;
//             $shiftname= $request->shiftname;
//             $office_starthrs= $request->office_starthrs;
//             $office_startmin= $request->office_startmin;
//             $office_start_tolmin= $request->office_start_tolmin;
//             $office_start_tolsec= $request->office_start_tolsec;
//             $office_endhrs= $request->office_endhrs;
//             $office_endmin= $request->office_endmin;
//             $lunch_starthrs= $request->lunch_starthrs;
//             $lunch_startmin= $request->lunch_startmin;
//             $lunch_endhrs= $request->lunch_endhrs;
//             $lunch_endmin= $request->lunch_endmin;
//             $daytag=$request->daytag;
//             $office_after_starthrs= $request->office_after_starthrs;
//             $office_after_startmin= $request->office_after_startmin;
//             $office_grace_tolmin= $request->office_grace_tolmin;
//             $office_grace_tolsec= $request->office_grace_tolsec;
			

	
// 	try{

   

           
//             $isdataavailable = DB::select("select * from SHIFT_MASTER where  SHIFTID = ? ", [$shiftid]);
//             // Assuming you have			the correct table name and column names, modify this query accordingly
// 			if($isdataavailable)
// 			{
				
// 				$employeedetails = DB::select("select company_code from employee where code = ? ", [$login_id]);
				
//             $query = "UPDATE SHIFT_MASTER SET SHIFTNAME = ?,OFFICE_STARTHRS=?,OFFICE_STARTMIN=?,OFFICE_START_TOLMIN=?,OFFICE_START_TOLSEC=?,OFFICE_ENDHRS=?,OFFICE_ENDMIN=?,OFFICE_AN_STARTHRS=?,OFFICE_AN_STARTMIN=?,LUNCH_STARTHRS=?,LUNCH_STARTMIN=?,LUNCH_ENDHRS=?,LUNCH_ENDMIN=?,daytag=? where SHIFTID=?";
//             DB::update($query, [$shiftname,$office_starthrs,$office_startmin,$office_start_tolmin,$office_start_tolsec,$office_endhrs,$office_endmin,$office_after_starthrs,$office_after_startmin,$lunch_starthrs,$lunch_startmin,$lunch_endhrs,$lunch_endmin,$daytag]);
// 			}
// 			else
// 			{
// 				$employeedetails = DB::select("select company_code from employee where code = ? ", [$login_id]);
            
// 				DB::INSERT("insert into SHIFT_MASTER(CompanyCode,SHIFTID,SHIFTNAME,OFFICE_STARTHRS,OFFICE_STARTMIN,OFFICE_START_TOLMIN,OFFICE_START_TOLSEC,OFFICE_ENDHRS,OFFICE_ENDMIN,OFFICE_AN_STARTHRS,OFFICE_AN_STARTMIN,LUNCH_STARTHRS,LUNCH_STARTMIN,LUNCH_ENDHRS,LUNCH_ENDMIN,daytag) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ",[$employeedetails[0]->company_code,$shiftid,$shiftname,$office_starthrs,$office_startmin,$office_start_tolmin,$office_start_tolsec,$office_endhrs,$office_endmin,$office_after_starthrs,$office_after_startmin,$lunch_starthrs,$lunch_startmin,$lunch_endhrs,$lunch_endmin,$daytag]);
// 			}
   

//     return response()->json(['message'=> "SUCCESS", 'status_code'=> "200", 'text' => 'Data Updated successfully.'], 200);
// 	}
// 	catch(\Exception $e){
// 		    return response()->json(['message'=> "Failure", 'status_code'=> "400", 'text' => 'Data Not Updated.'], 200);
// 	}
	
// }

public function createshift(Request $request) {
		$validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			 
		]);

		// Check if validation fails
		if ($validator->fails()) {
			// Validation failed, return error response
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 200);
		}
			$login_id = $request->login_id;
			$shiftid= $request->shiftid;
            $shiftname= $request->shiftname;
            $office_starthrs= $request->office_starthrs;
            $office_startmin= $request->office_startmin;
            $office_start_tolmin= 0;
            // $office_start_tolmin= $request->office_start_tolmin;
            // $office_start_tolsec= $request->office_start_tolsec;
            $office_start_tolsec= 0;
            $office_endhrs= $request->office_endhrs;
            $office_endmin= $request->office_endmin;
            $lunch_starthrs= $request->lunch_starthrs;
            $lunch_startmin= $request->lunch_startmin;
            $lunch_endhrs= $request->lunch_endhrs;
            $lunch_endmin= $request->lunch_endmin;
            // $daytag=$request->daytag;
            $daytag=1;
            $office_after_starthrs= $request->office_after_starthrs;
            $office_after_startmin= $request->office_after_startmin;
            $office_grace_tolmin= $request->office_grace_tolmin;
            $office_grace_tolsec= $request->office_grace_tolsec;
			$TOTAL_SHIFTHRS=0;
			$employeedetails='S11';
			

	
	try{

   

           
            $isdataavailable = DB::select("select * from shift_master where  SHIFTID = ? ", [$shiftid]);
            // Assuming you have			the correct table name and column names, modify this query accordingly
			if($isdataavailable)
			{
				
				//$employeedetails = DB::select("select company_code from employee where code = ? ", [$login_id]);
				
            $query = "UPDATE shift_master SET SHIFTNAME = ?,OFFICE_STARTHRS=?,OFFICE_STARTMIN=?,OFFICE_START_TOLMIN=?,OFFICE_START_TOLSEC=?,OFFICE_ENDHRS=?,OFFICE_ENDMIN=?,OFFICE_AN_STARTHRS=?,OFFICE_AN_STARTMIN=?,LUNCH_STARTHRS=?,LUNCH_STARTMIN=?,LUNCH_ENDHRS=?,LUNCH_ENDMIN=?,daytag=? where SHIFTID=?";
            DB::update($query, [$shiftname,$office_starthrs,$office_startmin,$office_start_tolmin,$office_start_tolsec,$office_endhrs,$office_endmin,$office_after_starthrs,$office_after_startmin,$lunch_starthrs,$lunch_startmin,$lunch_endhrs,$lunch_endmin,$daytag,$shiftid]);
			}
			else
			{
				//$employeedetails = DB::select("select company_code from employee where code = ? ", [$login_id]);
            $employeedetails='S11';
				DB::INSERT("insert into shift_master(CompanyCode,SHIFTNAME,OFFICE_STARTHRS,OFFICE_STARTMIN,OFFICE_START_TOLMIN,OFFICE_START_TOLSEC,OFFICE_ENDHRS,OFFICE_ENDMIN,OFFICE_AN_STARTHRS,OFFICE_AN_STARTMIN,LUNCH_STARTHRS,LUNCH_STARTMIN,LUNCH_ENDHRS,LUNCH_ENDMIN,daytag,TOTAL_SHIFTHRS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ",[$employeedetails,$shiftname,$office_starthrs,$office_startmin,$office_start_tolmin,$office_start_tolsec,$office_endhrs,$office_endmin,$office_after_starthrs,$office_after_startmin,$lunch_starthrs,$lunch_startmin,$lunch_endhrs,$lunch_endmin,$daytag,$TOTAL_SHIFTHRS]);
			}
   

    return response()->json(['message'=> "SUCCESS", 'status_code'=> "200", 'text' => 'Data Updated successfully.'], 200);
	}
	catch(\Exception $e) {
    return response()->json(['message'=> "Failure", 'status_code'=> "400", 'text' => 'Data Not Updated', 'Exception'=>$e->getMessage()], 400);
}
}

public function getemployeedetailsupdate(Request $request){
		 $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'maincode' => 'required',
		
       
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
	
$maincode = $request->maincode;
			try {

	 $emloyeelist =db::select('select * from employee where maincode=?',[$maincode]);

		} catch (\Exception $e) {

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}

        Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getemployeelist' => $emloyeelist], 200);
	}




public function getTaskComments(Request $request){   
    $login_id = $request->login_id;   
    $task_id = $request->task_id;   
    
    try {
        $designation = DB::select('select * from EmployeeTaskTransaction where transactionid=?', [$task_id]);
    } catch (\Exception $e) {
        return response()->json(['message'=> 'Failure', 'status_code'=> 400, 'text' => $e->getMessage()], 200);
    }
    
    return response()->json(['message'=> "SUCCESS", 'status_code'=> 200, 'taskname' => $designation], 200);
}
public function getUserCount(Request $request)
{
    $login_id = $request->input('login_id');

    $count = DB::table('HRADMIN_USERS')
                ->where('maincode', $login_id)
                ->distinct() // Add distinct here
                ->count();

    return response()->json(['count' => $count]);
}


 public function createTaskComments(Request $request){	
	  $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'task_id' => 'required',
        'comments' => 'required',
        'completedon' => 'required',
       
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    $login_id = $request->login_id;	
    $task_id = $request->task_id;
    $comments = $request->comments;
    $completedon = $request->completedon; // Assuming you get completedon value from the request
		
    try {
       
        if ($completedon == 1) {
           
            DB::update('UPDATE EmployeeTask SET completedon = NOW() WHERE Transactionid = ?', [$task_id]);
			DB::insert('INSERT INTO EmployeeTaskTransaction(Transactionid, Details, UpdatedOn) VALUES (?, ?, NOW())', [$task_id, $comments]);
        } else {
           
            DB::insert('INSERT INTO EmployeeTaskTransaction(Transactionid, Details, UpdatedOn) VALUES (?, ?, NOW())', [$task_id, $comments]);
        }
        
    } catch (\Exception $e) {
        return response()->json(['message'=> 'Failure', 'status_code'=> 400, 'text' => $e->getMessage()], 200);
    }

    return response()->json(['message'=> 'SUCCESS', 'status_code'=> 200, 'taskname' => 'success'], 200);
}

public function createbranch(Request $request) {
    $validator = Validator::make($request->all(), [
        'code' => 'required', 
        'name' => 'required|string', 
        'address1' => 'required|string',  
        'address2' => 'required|string',  
        'place' => 'required|string', 
        'latitude' => 'required', 
        'longitude' => 'required', 
        // 'city' => 'required',
        // 'state' => 'required',
        // 'pincode' => 'required',
        // 'email' => 'required',
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    
    $code = $request->code;
    $name = $request->name;
    $address1 = $request->address1;
    $address2 = $request->address2;
    $place = $request->place;
    $email = $request->email;
    $city = $request->city;
    $state = $request->state;
    $pincode = $request->pincode;
    $latitude = $request->latitude;
    $longitude = $request->longitude;
    $createdby = $request->login_id;
    $createdon = now();
    $active = 'Y';
	$country='INDIA';

    $count = DB::select('SELECT COUNT(*)
 AS cnt FROM branch WHERE CODE = ?', [$code]);

    if ($count[0]->cnt > 0) {
        $affectedRows = DB::update("UPDATE branch SET NAME = ?, OADD1 = ?, OADD2 = ?, OPLACE = ?,OSTATE=?,OCITY=?,OPIN=?,EMAILID=? ,LATITUDE = ?, LONGITUDE = ?, ACTIVE = ?, MODIFIED_BY = ?, MODIFIED_ON = ? WHERE CODE = ?", [
            $name, $address1, $address2, $place,$state,$city,$pincode,$email, $latitude, $longitude, $active, $createdby, $createdon, $code
        ]);

        if ($affectedRows > 0) {
            return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'text' => 'Data Updated successfully.'
            ], 200);
        } else {
            // Handle update failure
        }
    } else {
        $inserted = DB::insert("INSERT INTO branch (CODE , NAME, OADD1, OADD2, OPLACE,OSTATE,OCITY,OPIN,EMAILID,OCOUNTRY, LATITUDE, LONGITUDE, ACTIVE, CREATED_BY, CREATED_ON) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)", [
            $code, $name, $address1, $address2, $place,$state,$city,$pincode,$email,$country,$latitude, $longitude, $active, $createdby, $createdon
        ]);
         $inserted1 = DB::insert("insert into branch_mapping (code,branch,branchname,status,createdby,createdon) VALUES (?, ?, ?, ?, ?, ?)", [$createdby,$code, $name,1,$createdby, $createdon]);

        if ($inserted) {
            return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'text' => 'Data Inserted successfully.'
            ], 200);
        } else {
           
        }
    }
}


public function getshiftheader(Request $request){   
    
    
    try {
        $shiftheader = DB::select('select * from pshift_new where 1=2');
		
		$desiredColumns = ['MAINCODE','YEAR','MONTH','DAY01SHIFT','DAY02SHIFT','DAY03SHIFT','DAY04SHIFT','DAY05SHIFT','DAY06SHIFT','DAY07SHIFT','DAY08SHIFT','DAY09SHIFT','DAY10SHIFT','DAY11SHIFT','DAY12SHIFT','DAY13SHIFT','DAY14SHIFT','DAY15SHIFT','DAY16SHIFT','DAY17SHIFT','DAY18SHIFT','DAY19SHIFT','DAY20SHIFT','DAY21SHIFT','DAY22SHIFT','DAY23SHIFT','DAY24SHIFT','DAY25SHIFT','DAY26SHIFT','DAY27SHIFT','DAY28SHIFT','DAY29SHIFT','DAY30SHIFT','DAY31SHIFT'];

        // Use Schema facade to get all the column names
        $allColumns = Schema::getColumnListing('pshift_new');

        // Filter the columns based on the desired list
        $filteredColumns = array_intersect($allColumns, $desiredColumns);



    } catch (\Exception $e) {
        return response()->json(['message'=> 'Failure', 'status_code'=> 400, 'text' => $e->getMessage()], 200);
    }
    
    return response()->json(['message'=> "SUCCESS", 'status_code'=> 200, 'getshiftheader' => $filteredColumns], 200);


}



 public function insertPShift(Request $request)
    {
        // Get the data from the request
         $datadmp = $request->Shiftdata;
		 //echo '123';
		 //var_dump($data);
		 //return response()->json(['message' => 'Data inserted successfully'], 200);

        try {
            // Begin a transaction
            DB::beginTransaction();
			
			foreach($datadmp as $data)
			{
			
                $employeeExists = DB::table('employee')
                ->where('MAINCODE', $data['MAINCODE'])
                ->exists();

            if (!$employeeExists) {
                // Rollback the transaction if MAINCODE doesn't exist in employee table
                DB::rollBack();
                return response()->json(['message'=> 'Failure', 'status_code'=> 400, 'text' => 'Employee with MAINCODE ' . $data['MAINCODE'] . ' does not exist.'], 400);
            }
			

            // Check if data already exists for the given criteria
            $existingCount = DB::table('pshift_new')
                ->where('MAINCODE', $data['MAINCODE'])
                ->where('YEAR', $data['YEAR'])
                ->where('MONTH', $data['MONTH'])
                ->count();

            // If data exists, delete it
            if ($existingCount > 0) {
                DB::table('pshift_new')
                    ->where('MAINCODE', $data['MAINCODE'])
                    ->where('YEAR', $data['YEAR'])
                    ->where('MONTH', $data['MONTH'])
                    ->delete();
            }

            // Insert the new data
            DB::table('pshift_new')->insert($data);
			}
			
			 $shiftdetals = DB::select('SELECT * FROM  pshift_new WHERE SWIPECARDNO IS NULL');
			 
			 foreach($shiftdetals as $shiftdata)
			 {
				 $maincode =$shiftdata ->MAINCODE;
				 
				 $employeedetails = DB::select('SELECT COMPANY_CODE,SWIPECARDNO,MAINCODE FROM employee where MAINCODE=?',[$maincode]);
				 
				 $companycode =$employeedetails[0]->COMPANY_CODE;
				 $swipecardno =$employeedetails[0]->SWIPECARDNO;
				 
				 $updateshiftswipe = DB::INSERT('update pshift_new set COMPANYCODE=?,SWIPECARDNO=? where SWIPECARDNO IS NULL and MAINCODE=?',[$companycode,$swipecardno,$maincode]);
				 
			 }
			
			

            // Commit the transaction
            DB::commit();

            // Return success response
            return response()->json(['message' => 'Data inserted successfully'], 200);
        } catch (\Exception $e) {
            // Rollback the transaction if an error occurs
            DB::rollBack();

            // Return error response
            return response()->json(['message' => 'Failed to insert data: ' . $e->getMessage()], 500);
        }
    }
    
    public function getemployeelistforreport(Request $request){
    $branchcode = $request->branchcode;
    $login_id = $request->login_id;
    $resigned = $request->resigned;

    try {
        if($resigned==1){
             if($branchcode === "ALL"){
            if($login_id==="9999"){
              $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.branch_code in(SELECT branch as code FROM branch_mapping WHERE code =? order by a.a_employeecode)',[$login_id]);
            }else
            {
                  $employeelist = DB::select('select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code=? and e.RESIGN_TAG="R" order by e.code',[$login_id] );
            }
            // $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where a.maincode=?', [$branchcode]);
            
        } else {
           $employeelist = DB::SELECT('select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code = ? and na.branch=? and e.RESIGN_TAG="R" order by e.code',[$login_id,$branchcode]);
           // $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.branch_code = ?', [$branchcode]);
        }
        }else{
             if($branchcode === "ALL"){
            if($login_id==="9999"){
              $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.branch_code in(SELECT branch as code FROM branch_mapping WHERE code =? order by a.a_employeecode)',[$login_id]);
            }else
            {
                     $employeelist = DB::select('select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code=? and e.RESIGN_TAG is null order by e.code',[$login_id] );
            }
            // $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where a.maincode=?', [$branchcode]);
            
        } else {
             $employeelist = DB::SELECT('select e.code,e.name  from branch_mapping na inner join employee e on na.branch = e.BRANCH_CODE  where na.code = ? and na.branch=? and e.RESIGN_TAG IS NULL order by e.code',[$login_id,$branchcode]);
           // $employeelist = DB::select('select distinct a.a_employeecode as code, a.a_employeename as name from new_authority a inner join employee b on a.a_employeecode = b.maincode where b.branch_code = ?', [$branchcode]);
        }
        }
       
    } catch (\Exception $e) {
        return response()->json([
            'message'=> 'Failure',
            'status_code'=> 400,
            'text' => $e->getMessage()
        ], 200);
    }

    return response()->json([
        'message'=> "SUCCESS",
        'status_code'=> "200",
        'getemployeelist' => $employeelist
    ], 200);
}




public function removebranch(Request $request) {
    $validator = Validator::make($request->all(), [
        'code' => 'required', 
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
    
    $login_id = $request->login_id;
	 $code = $request->code;
    
 try {
	 $count = DB::select('SELECT COUNT(*) AS cnt FROM branch WHERE CODE = ?', [$code]);

    if ($count[0]->cnt > 0) {
        $affectedRows = DB::insert("INSERT INTO branch_history (CODE, NAME, OADD1, OADD2, OPLACE, OCITY, OSTATE, OCOUNTRY, OPIN, OPHONE1, OPHONE2, OFAX, EMAILID, WEBSITE, LOCATION, REGION, GADD1, GADD2, GPLACE, GCITY, GSTATE, GCOUNTRY, GPIN, GPHONE1, GPHONE2, GFAX, MANAGER, MANAGER_FROM, PREVIOUS_MANAGER, ASST_MANAGER, ASST_MANAGER_FROM, PREVIOUS_ASST_MANAGER, INCHARGE, PREVIOUS_INCHARGE, INCEPTION_DATE, NO_OF_EMPLOYEES, NO_OF_DEALERS, NO_OF_MARKERING_EXECUTIVES, CREATED_BY, CREATED_ON, MODIFIED_BY, MODIFIED_ON, OFFICE_STARTHRS, OFFICE_STARTMIN, OFFICE_START_TOLMIN, OFFICE_START_TOLSEC, OFFICE_ENDHRS, OFFICE_ENDMIN, OFFICE_AN_STARTHRS, OFFICE_AN_STARTMIN, LUNCH_STARTHRS, LUNCH_STARTMIN, LUNCH_ENDHRS, LUNCH_ENDMIN, LC_HRS, LC_MIN, LC_SEC, BRANCH_TYPE, LUNCH, LC_CANCELLATION, ZONE, GJV_GENERATE, GROUP_NAME, UNIT_GLCODE, FACTORY_REG, TYPE, ACTIVE, ORG_CODE, PLANT_CODE, SAP_Common_Cost_Center, SAP_Common_Cost_Center_Name, latitude, longitude) SELECT * FROM branch WHERE code=?",[$code]);
		
		$updateRows = DB::update("update branch_history set REMOVED_BY=?,REMOVED_ON=CURDATE() WHERE code=?",[$login_id,$code]);
		
		$deleteRows = DB::insert("delete from  branch WHERE code=?",[$code]);

        if ($deleteRows > 0) {
            return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'text' => 'branch Removed successfully.'
            ], 200);
        } else {
            // Handle update failure
        }
    } 
 }
 catch (\Exception $e) {
        return response()->json([
            'message'=> 'Failure',
            'status_code'=> 400,
            'text' => $e->getMessage()
        ], 200);
    }
}


// public function punchreport(Request $request)
// {
// 	$login_id = $request->login_id;
// 	$date = $request->dates;
// 	 $selectedEmployees = $request->employee_code;
// 	 $type='G';
	 
// 	 try {
		
		
// $dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

		
// 		$results = db::delete("delete from it_empcode where login_id=?",[$login_id]);
		
// 		foreach ($selectedEmployees as $employee) 
// 		{
			
// 			DB::insert('insert into it_empcode (login_id, MAINCODE) values (?, ?)', [$login_id,$employee]);
// 		}
		
// 		$punchreport =DB::select("select LOGIN_ID Employee_code,NAME as Name ,Sdate Date,latitude Latitude,longitude Longitude,punchlocation Punchlocation from hr_daily_atten where LOGIN_ID in (select SWIPECARDNO from employee where CODE in(select maincode from it_empcode where login_id =?)) and date_format(Sdate ,'%b-%Y') =? order by LOGIN_ID ,date",[$login_id,$date]);
		
		
		
		
//              Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'punchreport' => $punchreport], 200);
       
			
			

			
// 		} catch (\Exception $e) {
       

// 			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
// 		}
// }
public function punchreport(Request $request)
{
    $login_id = $request->login_id;
    $selectedEmployees = $request->employee_code;
    $fromDate = $request->from_date;   // expecting YYYY-MM-DD
    $toDate = $request->to_date;       // expecting YYYY-MM-DD
    $type = 'G';

    try {

        // VALIDATION
        if (!$fromDate || !$toDate) {
            return response()->json([
                'message' => 'From Date and To Date required',
                'status_code' => 400
            ], 200);
        }

        // Ensure valid date formats
        $from = Carbon::parse($fromDate)->startOfDay()->format('Y-m-d H:i:s');
        $to = Carbon::parse($toDate)->endOfDay()->format('Y-m-d H:i:s');

        // Clear existing employee filter
        DB::delete("DELETE FROM it_empcode WHERE login_id = ?", [$login_id]);

        foreach ($selectedEmployees as $employee) {
            DB::insert(
                "INSERT INTO it_empcode (login_id, MAINCODE) VALUES (?, ?)",
                [$login_id, $employee]
            );
        }

        // FETCH PUNCH REPORT
        $punchreport = DB::select(
            "SELECT 
                LOGIN_ID AS Employee_code,
                NAME AS Name,
                Sdate AS Date,
                latitude AS Latitude,
                longitude AS Longitude,
                punchlocation AS Punchlocation
             FROM hr_daily_atten
             WHERE LOGIN_ID IN (
                 SELECT SWIPECARDNO 
                 FROM employee 
                 WHERE CODE IN (SELECT MAINCODE FROM it_empcode WHERE login_id = ?)
             )
             AND Sdate BETWEEN ? AND ?
             ORDER BY LOGIN_ID, Sdate",
             [$login_id, $from, $to]
        );

        return response()->json([
            'message' => 'SUCCESS',
            'status_code' => 200,
            'punchreport' => $punchreport
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => $e->getMessage()
        ], 200);
    }
}



public function getbranchadmin(Request $request)
{
	
	  $validator = Validator::make($request->all(), [
        'branchcode' => 'required', 
        'employeecode' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
	
	$branchcode = $request->branchcode;
	$employeecode = $request->employeecode;
	
	 
	 try {
		
		
		$getbranchadmin =DB::select('SELECT count(*) as cnt FROM branch_admin where AUTHORITY_CODE =? AND CODE =?',[$branchcode,$employeecode]);
		
		
		
             Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getbranchadmin' => $getbranchadmin[0]->cnt], 200);
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}


public function Createbranchmapping(Request $request)
{
	
	
	
	  $validator = Validator::make($request->all(), [
        'branch' => 'required', 
        'authoritybranch' => 'required',
        'employeecode' => 'required',
        'login_id'=>'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
	
	$branchcode = $request->branch;
	$employeecode = $request->employeecode;
	$authoritybranch = $request->authoritybranch;
	$login_id = $request->login_id;
	
	 
	 try {
		
		
		$getbranchadmin =DB::select('SELECT count(*) as cnt FROM branch_mapping where branch =? AND code =?',[$authoritybranch,$employeecode]);
		//$getbranchadmin =DB::select('SELECT count(*) as cnt FROM branch_admin where AUTHORITY_CODE =? AND CODE =?',[$authoritybranch,$employeecode]);
		
		
		if($getbranchadmin[0]->cnt>0)
		{
			
			$getbranchadmin =DB::insert('Delete FROM branch_mapping where branch =? AND code =?',[$authoritybranch,$employeecode]);
				//$getbranchadmin =DB::insert('Delete FROM branch_admin where AUTHORITY_CODE =? AND CODE =?',[$authoritybranch,$employeecode]);
			
			 return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'text' => 'branch Authority Removed successfully.'
            ], 200);
		}
		
		else
		{
			
			 $employeedetails = DB::select('SELECT COMPANY_CODE,SWIPECARDNO,MAINCODE,NAME FROM employee where MAINCODE=?',[$employeecode]);
				 
				 $companycode =$employeedetails[0]->COMPANY_CODE;
				 $swipecardno =$employeedetails[0]->SWIPECARDNO;
				 $Name =$employeedetails[0]->NAME;
				 $branchdetails = DB::select('SELECT NAME FROM branch where CODE=? LIMIT 1',[$branchcode]);
				 $brrname =$branchdetails[0]->NAME;
				 $Createbranchmapping =DB::insert('INSERT INTO branch_mapping(branch,code,branchname,status,createdby) VALUES(?,?,?,?,?);',[$branchcode,$employeecode,$brrname,1,$login_id]);
				 //$Createbranchmapping =DB::insert('INSERT INTO branch_admin(BRANCH_CODE,CODE,NAME,AUTHORITY_CODE) VALUES(?,?,?,?);',[$branchcode,$employeecode,$Name,$authoritybranch]);
				 
			
			return response()->json([
                'message' => "SUCCESS",
                'status_code' => "200",
                'text' => 'branch Authority Mapped successfully.'
            ], 200);
		}
		
            
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}



public function getbranchmappingdetails(Request $request)
{
	
	  $validator = Validator::make($request->all(), [
        'branchcode' => 'required', 
        
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }
	
	$branchcode = $request->branchcode;
	$employeecode = $request->employeecode;


	 
	 try {
		
		if ($employeecode=='' || $employeecode==null)
		{
			//$getbranchmappingdetails =DB::select('SELECT BRANCH_CODE,CODE,NAME,AUTHORITY_CODE AUTHORITY_BRANCH   FROM `branch_admin` WHERE BRANCH_CODE=?',[$branchcode]);
			$getbranchmappingdetails =DB::select('SELECT (select BRANCH_CODE FROM employee WHERE MAINCODE=branch_mapping.CODE LIMIT 1)as BRANCH_CODE,code as CODE,(select NAME FROM employee WHERE MAINCODE=branch_mapping.CODE LIMIT 1) AS NAME,branch AUTHORITY_BRANCH   FROM `branch_mapping` WHERE branch=?',[$branchcode]);
		                                         //SELECT branch as code , branchname  as name  FROM branch_mapping WHERE code =? and status=1 order by branch
		}
		else
		{
		    	$getbranchmappingdetails =DB::select('SELECT (select BRANCH_CODE FROM employee WHERE MAINCODE=branch_mapping.CODE LIMIT 1)as BRANCH_CODE,code as CODE,(select NAME FROM employee WHERE MAINCODE=branch_mapping.CODE LIMIT 1) AS NAME,branch AUTHORITY_BRANCH   FROM `branch_mapping` WHERE branch=? and code=?',[$branchcode,$employeecode]);
			//$getbranchmappingdetails =DB::select('SELECT BRANCH_CODE,CODE,NAME,AUTHORITY_CODE AUTHORITY_BRANCH   FROM `branch_admin` WHERE BRANCH_CODE=? and code =?',[$branchcode,$employeecode]);
		
		}
		
		
		
             Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'getbranchadmin' => $getbranchmappingdetails], 200);
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}



public function taskreport(Request $request)
{
    $login_id = $request->login_id;
    $date = $request->dates;
    $selectedEmployees = $request->employee_code; 
    $status = $request->status;
    
    
    
    
    try {
      
        $startOfMonth = \Carbon\Carbon::createFromFormat('M-Y', $date)->startOfMonth();
        $endOfMonth = \Carbon\Carbon::createFromFormat('M-Y', $date)->endOfMonth();
        
       
        $taskreport = [];
        
        
        $taskreport = [];

foreach ($selectedEmployees as $employeeCode) {
    $result = \DB::select('
        SELECT DISTINCT A.Transactionid, A.EmployeeId, A.EmployeeName, A.CreatedBy, A.TaskDetails,
        A.DateofCompletion, A.CompletedOn, B.Details, A.comments, A.Status, A.Closedon, A.ClosedBy
        FROM `employeetask` A
        LEFT JOIN employeetasktransaction B ON A.Transactionid = B.Transactionid
        WHERE A.EmployeeId = ? AND A.Status = ?  
        AND A.CreatedOn BETWEEN ? AND ? order by A.Transactionid desc',
        [$employeeCode, $status, $startOfMonth->format('Y-m-d'), $endOfMonth->format('Y-m-d')]
    );
	
  
  
    $taskreport = array_merge($taskreport, $result);
}

        
        
        return response()->json([
            'message' => 'SUCCESS',
            'status_code' => 200,
            'taskreport' => $taskreport
        ], 200);
        
    } catch (\Exception $e) {
       
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'error' => $e->getMessage()
        ], 400);
    }
}
public function locationupload(Request $request)
{
  
    $locationdata = $request->locationdata;
    $login_id = $request->login_id;
	
    $now = new DateTime();
    
    try {
      
        DB::beginTransaction();

        foreach ($locationdata as $data) {
            $employeeCode = $data['EmployeeCode'];
            $branchcode = $data['Branchcode'];
            $latitude = (float) $data['latitude']; 
            $longitude = (float) $data['longitude']; 

            
            $existingCount = DB::table('Employee_Travel_Mapping')
                ->where('EmployeeCode', $employeeCode)
                ->where('Branchcode', $branchcode)
                ->count();
//				echo $existingCount;
				

            if ($existingCount > 0) {
               
                DB::table('Employee_Travel_Mapping')
                    ->where('EmployeeCode', $employeeCode)
                    ->where('Branchcode', $branchcode)
                    ->delete();
			}
                
                
                DB::table('Employee_Travel_Mapping')->insert([
                    'EmployeeCode' => $employeeCode,
                    'Branchcode' => $branchcode,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                    'Createdby' => $login_id,
                    'CreatedOn' =>$now
                ]);
            
        }

        
        DB::commit();

       
        return response()->json(['message' => 'Data inserted/updated successfully'], 200);
    } catch (\Exception $e) {
        
        DB::rollBack();

        
        return response()->json(['message' => 'Failed to insert/update data: ' . $e->getMessage()], 500);
    }
}
public function locationlist(Request $request)
{
    
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'employeecode' => 'required|array', // employeecode should be an array
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

   
    try {
        $employeecodes = $request->input('employeecode');
        $locationlist = [];

        foreach ($employeecodes as $employeecode) {
           
            $location = DB::select('SELECT Employeecode as Employee, Branchcode as Branch, latitude as Latitude, longitude as Longitude FROM Employee_Travel_Mapping WHERE Employeecode = ?', [$employeecode]);
            
           
            if (!empty($location)) {
                $locationlist = array_merge($locationlist, $location);
            }
        }

        return response()->json([
            'message' => 'SUCCESS',
            'status_code' => 200,
            'locationlist' => $locationlist, // Directly assign locationlist without nested arrays
        ], 200);
    } catch (\Exception $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => $e->getMessage(),
        ], 400);
    }
}

public function locationlistremove(Request $request)
    {
		$validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'employeecode' => 'required',
        'branchcode' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }
	$employeeCode=$request->employeecode;
	$branchCode=$request->branchcode;
	
        try {
           
            DB::delete('DELETE FROM Employee_Travel_Mapping WHERE EmployeeCode = ? AND Branchcode = ?', [$employeeCode, $branchCode]);

            return response()->json([
                'message' => 'Employee travel mapping deleted successfully',
                'status_code' => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Failed to delete employee travel mapping',
                'status_code' => 400,
                'error' => $e->getMessage(),
            ], 400);
        }
    }
    
    
    public function getlocationheader(Request $request)
    {
        try {
            // Use Schema facade to get all the column names from Employee_Travel_Mapping
            $allColumns = Schema::getColumnListing('Employee_Travel_Mapping');

        } catch (\Exception $e) {
            return response()->json(['message' => 'Failure', 'status_code' => 400, 'text' => $e->getMessage()], 200);
        }

        return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'getlocationheader' => $allColumns], 200);
    }



// public function checksalarycalculate(Request $request)
// {
// 	$login_id = $request->login_id;
// 	$date = $request->dates;
	
// 	 $type='G';
	 
// 	 try {
		
		
// $dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');


//         $salarycount=DB::select("SELECT count(*) cnt FROM CT_SalaryExtraction where date_format(TRNDATE ,'%b-%Y')=?",[$date]);
		
// 		//$text =Salary already calculated for the month . $date .
		
// 		if ($salarycount[0]->cnt > 0)
// 		{
// 			 Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'salarycount' =>'1','text'=> 'Salary already calculated for the month '. $date . ' Do you want to Recalculate the Salary ?'  ], 200);
// 		}
// 		else
// 		{
// 			 Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'salarycount' =>'0'], 200);
// 		}
// 		} catch (\Exception $e) {
       

// 			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
// 		}
// }

	public function checksalarycalculate(Request $request)
{
    $login_id = $request->login_id;
    $date = $request->dates;

    // Check authorization
    $userCount = DB::select("SELECT count(*) as cnt FROM branch_admin WHERE code = ?", [ $login_id]);
    
    if ($userCount[0]->cnt == 0) {
        return response()->json(['message'=> 'Failure','status_code'=> 403,'text' => 'Not authorized to Calculate Salary.'], 403);
    }

    // Proceed with salary calculation check
    $type = 'G';

    try {
        $dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

        $salarycount = DB::select("SELECT count(*) as cnt FROM CT_SalaryExtraction WHERE date_format(TRNDATE, '%b-%Y') = ?", [$date]);

        if ($salarycount[0]->cnt > 0) {
            return response()->json([
                'message'=> "SUCCESS",
                'status_code'=> "200",
                'salarycount' => '1',
                'text'=> 'Salary already calculated for the month ' . $date . '. Do you want to Recalculate the Salary ?'
            ], 200);
        } else {
            return response()->json([
                'message'=> "SUCCESS",
                'status_code'=> "200",
                'salarycount' => '0'
            ], 200);
        }
    } catch (\Exception $e) {
        return response()->json([
            'message'=> 'Failure',
            'status_code'=> 400,
            'text' => $e->getMessage()
        ], 200);
    }
}



public function salarycalculate(Request $request)
{
	$login_id = $request->login_id;
	$date = $request->dates;
	 
	 $type='G';
	 
	 try {
		
		
$dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');


        

		
		$results = db::delete("delete from it_empcode_M");
		
			$employees = Employee::whereNull('RESIGN_TAG')
                     ->orWhere('RESIGN_DATE', '>=', $dates)
                     ->select('maincode')
                     ->get();

// Insert into it_empcode_M using DB::table
$insertData = [];
foreach ($employees as $employee) {
    $insertData[] = [
        'login_Id' => $login_id,
        'maincode' => $employee->maincode,
    ];
}

DB::table('it_empcode_M')->insert($insertData);
		
		
		$consolidateattendance =DB::select('call PROC_ATTENEXTRACTION_GRS_SALARY (?, ?,?)',[$login_id ,$dates,$type]);
		
		
		$salarycalculate = DB::select('call PROC_SALARY_M (?, ?)',[$login_id ,$dates]);
		
		
		
		
		
		
             Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'salarycalculate' => $salarycalculate,'text' => 'Salary Calculated successfully .'], 200);
       
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}


public function salaryextraction(Request $request)
{
	$login_id = $request->login_id;
	$date = $request->dates;
	 $selectedEmployees = $request->employee_code;
	
	 
	 try {
		
		
$dates = Carbon::createFromFormat('M-Y', $date)->startOfMonth()->format('Y-m-d');

		
		$results = db::delete("delete from it_empcode where login_id=?",[$login_id]);
		
		foreach ($selectedEmployees as $employee) 
		{
			
			DB::insert('insert into it_empcode (login_id, MAINCODE) values (?, ?)', [$login_id,$employee]);
		}
		
		$salaryextraction =DB::select('select * from CT_SalaryExtraction where maincode in(select maincode from it_empcode where login_id=?) and TRNDATE =?',[$login_id ,$dates]);
		
		
		
              Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'salaryextraction' => $salaryextraction], 200);
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}

public function employeesreport(Request $request)
{
    $login_id = $request->login_id;
    $selectedEmployees = $request->employee_code;

    try {
       
        $employeesreport = Employee::whereIn('MAINCODE', $selectedEmployees)
                                   
                                   ->get();

        return response()->json([
            'message' => 'SUCCESS',
            'status_code' => 200,
            'employeesreport' => $employeesreport
        ], 200);
    } catch (\Exception $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => $e->getMessage()
        ], 200);
    }
}
public function shiftallocationreport(Request $request)
{
    $login_id = $request->login_id;
    $selectedEmployees = $request->employee_code;
    $dates = $request->dates;

    try {
       
        $month = date_parse($dates)['month']; 

        
       
    $shiftallocationreport = DB::table('pshift_new')
    ->select('MAINCODE', 'YEAR', 'MONTH', 'DAY01SHIFT', 'DAY02SHIFT', 'DAY03SHIFT', 'DAY04SHIFT', 'DAY05SHIFT', 'DAY06SHIFT', 'DAY07SHIFT', 'DAY08SHIFT', 'DAY09SHIFT', 'DAY10SHIFT', 'DAY11SHIFT', 'DAY12SHIFT', 'DAY13SHIFT', 'DAY14SHIFT', 'DAY15SHIFT', 'DAY16SHIFT', 'DAY17SHIFT', 'DAY18SHIFT', 'DAY19SHIFT', 'DAY20SHIFT', 'DAY21SHIFT', 'DAY22SHIFT', 'DAY23SHIFT', 'DAY24SHIFT', 'DAY25SHIFT', 'DAY26SHIFT', 'DAY27SHIFT', 'DAY28SHIFT', 'DAY29SHIFT', 'DAY30SHIFT', 'DAY31SHIFT')
    ->whereIn('MAINCODE', $selectedEmployees)
    ->where('MONTH', $month)
    ->get();

	
        return response()->json(['shiftallocationreport' => $shiftallocationreport
        ], 200);
    } catch (\Exception $e) {
        return response()->json([
            'message' => 'Failure',
            'status_code' => 400,
            'text' => $e->getMessage()
        ], 200);
    }
}
public function notificationcount(Request $request)
    
		 {
		$validator = Validator::make($request->all(), [
        'login_id' => 'required',
        
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }
	$login_id =$request->login_id;
	 $notificationcount = DB::table('employee_deduction_header')
	 ->whereNotIn('STATUS', ['REQUESTED'])
            ->where('CODE', $login_id)
            ->whereNull('VIEW_STATUS')
            ->count();
        
       
        
        return response()->json(['notificationcount' => $notificationcount]);
    }
public function updatenotification(Request $request)
{
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        'login_id' => 'required|string', // Assuming 'login_id' should be a string
    ]);

    // Return validation errors if they exist
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

    $login_id = $request->login_id;

    // Update the records in the 'employee_deduction_header' table
    $updatedRows = DB::table('employee_deduction_header')
        ->where('CODE', $login_id)
        ->whereNull('VIEW_STATUS')
        ->whereNotIn('STATUS', ['REQUESTED'])
        ->update(['VIEW_STATUS' => 1]);

    // Check if the update was successful
    if ($updatedRows === false) {
        return response()->json([
            'message' => 'Failed to update records',
            'status_code' => 500,
        ], 500);
    }

    // Optionally, calculate the notification count
    $notificationcount = DB::table('employee_deduction_header')
        ->where('CODE', $login_id)
        ->where('VIEW_STATUS', 1)
        ->count();

    // Return the updated notification count
    return response()->json([
        'notificationcount' => $notificationcount,
        'status_code' => 200,
    ]);
}

public function statusofadvance(Request $request)
{
    
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

    $login_id = $request->login_id;

       DB::beginTransaction();

    try {
        
       /* $statusofadvance = DB::table('employee_deduction_header')
            ->select(
                'TOTAL_AMT',
                'NO_DUES',
                'DUE_AMT',
                'STATUS',
                'approved_by',
                DB::raw("(SELECT name FROM employee WHERE MAINCODE='approved_by') as APPROVER")
            )
            ->where('CODE', $login_id)
            ->whereNull('VIEW_STATUS')
            ->whereNotIn('STATUS', ['REQUESTED'])
            ->get(); */
            
            $statusofadvance = DB::table('employee_deduction_header')
    ->select(
        'TOTAL_AMT',
        'NO_DUES',
        'DUE_AMT',
        'STATUS',
        'approved_by',
        DB::raw("(SELECT name FROM employee WHERE employee.MAINCODE = employee_deduction_header.approved_by) as APPROVER")
    )
    ->where('CODE', $login_id)
    ->whereNull('VIEW_STATUS')
    ->whereNotIn('STATUS', ['REQUESTED'])
    ->get();

        
 /*   DB::table('employee_deduction_header')
            ->where('CODE', $login_id)
            ->whereNull('VIEW_STATUS')
            ->whereNotIn('STATUS', ['REQUESTED'])
            ->update(['VIEW_STATUS' => 1]); */
			

        
        DB::commit();

        
        return response()->json([
            'statusofadvance' => $statusofadvance,
            'message' => 'Records retrieved and updated successfully.',
        ]);
    } catch (\Exception $e) {
       
        DB::rollBack();

        
        return response()->json([
            'message' => 'An error occurred while processing the request.',
            'error' => $e->getMessage(),
            'status_code' => 500,
        ], 500);
    }
}
public function loanrequestreport(Request $request)
{
	$login_id = $request->login_id;
	$fromdate = $request->fromdate;
	$todate = $request->todate;

	 
	 try {
		
		
$fromdate1 = Carbon::createFromFormat('M-Y', $fromdate)->startOfMonth()->format('Y-m-d');
$todate1 = Carbon::createFromFormat('M-Y', $todate)->endofMonth()->format('Y-m-d');

		
		$loanrequestreport =DB::select('select a.maincode,(select NAME from employee where CODE=b.CODE )as name,a.ded_code,(select name from deduction where code=a.ded_code)as ded_name,a.Total_amt,a.Created_on,a.status,a.Approved_by,a.Approved_on,a.NO_DUES,a.DUE_AMT from employee_deduction_header a inner join employee b on a.CODE=b.CODE where a.created_on between ? and ?',[$fromdate1 ,$todate1]);
	//	$loanrequestreport =DB::select('select maincode,(select NAME from employee where MAINCODE=maincode)as name,ded_code,(select name from deduction where code=ded_code)as ded_name,Total_amt,Created_on,status,Approved_by,Approved_on,NO_DUES,DUE_AMT from employee_deduction_header where created_on between ? and ?',[$fromdate1 ,$todate1]);
		
		
		
              Return response()->json(['message'=> "SUCCESS",'status_code'=> "200",'loanrequestreport' => $loanrequestreport], 200);
			
			

			
		} catch (\Exception $e) {
       

			return response()->json(['message'=> 'Failure','status_code'=> 400,'text' => $e->getMessage()], 200);
		}
}
public function getpreclosure(Request $request)
{
    $login_id = $request->login_id;
    $selectedEmployees = $request->employee_code;

    
    $results = [];

    try {
        if(  $selectedEmployees="ALL"){
             $employeeData = DB::select('
                SELECT 
                    AUTOGENERATE_NO, 
                    CODE, 
                    (SELECT NAME FROM employee WHERE CODE = employee_deduction_header.CODE) AS NAME, 
                    DATE_FORMAT(START_DATE, "%b-%Y") AS START_DATE, 
                    DED_CODE, 
                    (SELECT NAME FROM deduction WHERE CODE = employee_deduction_header.DED_CODE) AS DED_NAME, 
                    TOTAL_AMT, 
                    IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_AMT,
                    NO_DUES, 
                    IFNULL((SELECT COUNT(*) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_DUES,DUE_AMT 
                FROM 
                    employee_deduction_header 
                WHERE IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) > 0 
                ORDER BY 
                    AUTOGENERATE_NO');

            
                 
               $results = $employeeData;
            
        }
        else
        {
        foreach ($selectedEmployees as $employee) {
          
            $employeeData = DB::select('
                SELECT 
                    AUTOGENERATE_NO, 
                    CODE, 
                    (SELECT NAME FROM employee WHERE CODE = employee_deduction_header.CODE) AS NAME, 
                    DATE_FORMAT(START_DATE, "%b-%Y") AS START_DATE, 
                    DED_CODE, 
                    (SELECT NAME FROM deduction WHERE CODE = employee_deduction_header.DED_CODE) AS DED_NAME, 
                    TOTAL_AMT, 
                    IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_AMT,
                    NO_DUES, 
                    IFNULL((SELECT COUNT(*) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_DUES,DUE_AMT 
                FROM 
                    employee_deduction_header 
                WHERE 
                    CODE = ? 
                    AND IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) > 0 
                ORDER BY 
                    AUTOGENERATE_NO', [$employee]);

            
                 if (!empty($employeeData)) {
               $results = array_merge($results, $employeeData);
            }
        }
}
        
        return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'getpreclosure' =>$results], 200);

    } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}
public function updatepreclosure(Request $request)
{
    // Validate the request
    $validator = Validator::make($request->all(), [
        'login_id' => 'required', 
       
        'rows' => 'required|array',
        'rows.*.AUTOGENERATE_NO' => 'required',
        'rows.*.CODE' => 'required',
        'rows.*.NAME' => 'required',
        'rows.*.START_DATE' => 'required',
        'rows.*.DED_CODE' => 'required',
        'rows.*.DED_NAME' => 'required',
        'rows.*.TOTAL_AMT' => 'required',
        'rows.*.BALANCE_AMT' => 'required',
        'rows.*.NO_DUES' => 'required',
        'rows.*.BALANCE_DUES' => 'required',
        'rows.*.DUE_AMT' => 'required',
        'rows.*.checkboxChecked' => 'required|boolean',
        'rows.*.textFieldValue' => 'required|string',
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        // Validation failed, return error response
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => '400',
        ], 400);
    }

    // Extract validated data
    $login_id = $request->login_id;
    $remarks = $request->remarks;
    $employee = $request->employee;
    $rows = $request->rows;

    // Initialize a counter for successful updates
    $rowsUpdated = 0;

    // Iterate over each row to update the database
    foreach ($rows as $row) {
        if ($row['checkboxChecked']) {
            $updated = DB::update(
                "update employee_deduction_trailer set STATUS=?, REMARKS=?, UPDATED_BY=?, UPDATED_ON=? where AUTOGENERATE_NO=? and CODE=? and STATUS is null",
                ['P', $row['textFieldValue'], $login_id, now(), $row['AUTOGENERATE_NO'], $row['CODE']]
            );
            if ($updated) {
                $rowsUpdated++;
            }
        }
    }

    // Check if any rows were updated
    if ($rowsUpdated > 0) {
        return response()->json(['message' => 'Success', 'status' => '200', 'text' => 'Data Submitted Successfully'], 200);
    } else {
        return response()->json(['message' => 'No rows updated, please try again', 'status' => '400'], 400);
    }
}
public function duesreportforemployee(Request $request)
{
    $login_id = $request->login_id;
   // $selectedEmployees = $request->employee_code;

    
    $results = [];

    try {
        
             $employeeData = DB::select('
               SELECT 
                    AUTOGENERATE_NO, 
                    CODE, 
                    (SELECT NAME FROM employee WHERE CODE = employee_deduction_header.CODE) AS NAME, 
                    DATE_FORMAT(START_DATE, "%b-%Y") AS START_DATE, 
                    DED_CODE, 
                    (SELECT NAME FROM deduction WHERE CODE = employee_deduction_header.DED_CODE) AS DED_NAME, 
                    TOTAL_AMT, 
                    IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_AMT,
                    NO_DUES, 
                    IFNULL((SELECT COUNT(*) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) AS BALANCE_DUES,DUE_AMT 
                FROM 
                    employee_deduction_header 
                WHERE CODE=? AND IFNULL((SELECT SUM(DUE_AMT) FROM employee_deduction_trailer WHERE STATUS IS NULL AND AUTOGENERATE_NO = employee_deduction_header.AUTOGENERATE_NO), 0) > 0 
                ORDER BY 
                    AUTOGENERATE_NO',[$login_id]);

            
                 
               $results = $employeeData;
            
        
              

        
        return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'duesreportforemployee' =>$results], 200);

    } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}


public function holidaylist(Request $request)
{
    $login_id = $request->login_id;
   // $selectedEmployees = $request->employee_code;

    
 

    try {
		
		 $employeeData = DB::select('select BRANCH_CODE from employee where maincode =?',[$login_id]);

         $BRANCH_CODE=$employeeData[0]->BRANCH_CODE;
		 
		 $holidays = DB::select("SELECT DATE_FORMAT(TRNDATE,'%d %b') as DAY,PARTICULARS as content FROM `holidays` where BRANCH_CODE=?",[$BRANCH_CODE]);
		 
		  return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'holidaylist' =>$holidays], 200);
		 
		
        } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}


public function bardata(Request $request)
{
    $login_id = $request->login_id;
   // $selectedEmployees = $request->employee_code;

    try {
		
		 $date1 =  DB::select("SELECT DATE_FORMAT(NOW() ,'%Y-%m-01') AS first_day_of_current_month");
		 $currentdate =$date1[0]->first_day_of_current_month;
	
		 
		 $date2 =  DB::select("SELECT DATE_FORMAT(
    DATE_SUB(
        DATE_FORMAT(CURDATE(), '%Y-%m-01'), 
        INTERVAL 5 MONTH),'%Y-%m-01') AS first_day_of_month_six_months_ago");
		
		$previosday =$date2[0]->first_day_of_month_six_months_ago;
		 
		 $query = DB::select("WITH RECURSIVE MonthList AS (
    SELECT DATE(?) AS trndate
    UNION ALL
    SELECT DATE_ADD(trndate, INTERVAL 1 MONTH)
    FROM MonthList
    WHERE trndate < ?
),
ActualData AS (
    SELECT maincode, trndate, workeddays, absentdays
    FROM t_w_hr_emp_salarydays
    WHERE maincode = ?
)
SELECT
    ? AS maincode,
    m.trndate,
    COALESCE(a.workeddays, '0.00') AS workeddays,
    COALESCE(a.absentdays, '0.00') AS absentdays
FROM MonthList m
LEFT JOIN ActualData a
ON m.trndate = a.trndate
ORDER BY m.trndate
LIMIT 6",[$previosday,$currentdate,$login_id,$login_id]);
		 
		  return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'bardata' =>$query], 200);
		 
		
        } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}


public function piedata(Request $request)
{
    $login_id = $request->login_id;
   // $selectedEmployees = $request->employee_code;
    try {
		
		 $date1 =  DB::select("SELECT DATE_FORMAT(NOW() ,'%Y-%m-01') AS first_day_of_current_month");
		 $currentdate =$date1[0]->first_day_of_current_month;
		 $query = DB::select("WITH RECURSIVE MonthList AS (
    SELECT DATE(?) AS trndate
    UNION ALL
    SELECT DATE_ADD(trndate, INTERVAL 1 MONTH)
    FROM MonthList
    WHERE trndate < ?
),
ActualData AS (
    SELECT maincode, trndate, workeddays, absentdays
    FROM t_w_hr_emp_salarydays
    WHERE maincode = ?
)
SELECT
    ? AS maincode,
    m.trndate,
    COALESCE(a.workeddays, '0.00') AS workeddays,
    COALESCE(a.absentdays, '0.00') AS absentdays
FROM MonthList m
LEFT JOIN ActualData a
ON m.trndate = a.trndate
ORDER BY m.trndate
LIMIT 6",[$currentdate,$currentdate,$login_id,$login_id]);
		 
		  return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'bardata' =>$query], 200);
		 
		
        } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}


// public function transaction(Request $request)
// {
    // $login_id = $request->login_id;
	// $year = $request->year;
	// $transactiontype = $request->transactiontype;
	// $status = $request->status;
    // try {
		 // $employeeData = DB::select('select name from employee where maincode =?',[$login_id]);
         // $name=$employeeData[0]->name;
		 // $query = DB::select("",[$currentdate,$currentdate,$login_id,$login_id]);
		  // return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'bardata' =>$query], 200);
        // } catch (\Exception $e) {
       // return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    // }
// }

public function hrdata(Request $request)
{
    //$login_id = $request->login_id;
   // $selectedEmployees = $request->employee_code;

    
 

    try {
		
		 
		 $hrdata = DB::select("SELECT * from hr_daily_atten where interfacedon is null");
		 
		  $statusupdate  = DB::select("update hr_daily_atten set interfacedon ='1' where interfacedon is null");
		 
		  return response()->json(['message' => "SUCCESS", 'status_code' => 200, 'hrdata' =>$hrdata], 200);
		 
		
        } catch (\Exception $e) {
        // Return failure response with error message
       return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}


public function employeedata(Request $request)
{
    // Start a DB transaction
    DB::beginTransaction();

    try {
        // Loop through each employee data from the request
        foreach ($request->all() as $employee) {
            // Assign each field from the employee data
            $NAME = $employee['NAME'];
            $CODE = $employee['MAINCODE'];
            $MAINCODE = $employee['MAINCODE'];
            $BRANCH_CODE = $employee['BRANCH_CODE'];
            $BRANCH_NAME = $employee['BRANCH_NAME'];
            $COMPANY_CODE = $employee['COMPANY_CODE'];
            $COMPANY_NAME = $employee['COMPANY_NAME'];
            $DEPT_CODE = $employee['DEPT_CODE'];
            $DEPT_NAME = $employee['DEPT_NAME'];
            $DESIG_CODE = $employee['DESIG_CODE'];
            $DESIG_NAME = $employee['DESIG_NAME'];
           
            $RESIGN_TAG = $employee['RESIGN_TAG'];
            $RESIGN_DATE = $employee['RESIGN_DATE'];
            $CREATED_ON = $employee['CREATED_ON'];
            $CREATED_BY = $employee['CREATED_BY'];
            $MODIFIED_BY = $employee['MODIFIED_BY'];
            $MODIFIED_ON = $employee['MODIFIED_ON'];
            $LOGIN_ID = $employee['MAINCODE']; 
            $password = "$2y$10$5rvdzvc6RkfWjzJdS2TBkeT3wLhiIE0B3vxgfjUO30Lj308get7yy"; 
            $TravelEligibility="NO";
            $LOGIN_PWD="1234";
            $NSW ="1";
            $SWIPECARDNO =$employee['SWIPECARDNO']; 
            
            
           
            DB::delete("DELETE FROM employee WHERE MAINCODE = ?", [$MAINCODE]);

            
            DB::insert("INSERT INTO employee (
                CODE, NAME, MAINCODE, BRANCH_CODE, BRANCH_NAME, COMPANY_CODE, COMPANY_NAME,
                DEPT_CODE, DEPT_NAME, DESIG_CODE, DESIG_NAME, RESIGN_TAG, RESIGN_DATE,
                CREATED_BY, CREATED_ON, MODIFIED_BY, MODIFIED_ON, LOGIN_ID, LOGIN_PWD, password,TravelEligibility,NSW,SWIPECARDNO
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)", [$CODE, $NAME, $MAINCODE, $BRANCH_CODE, $BRANCH_NAME, $COMPANY_CODE, $COMPANY_NAME,$DEPT_CODE, $DEPT_NAME, $DESIG_CODE, $DESIG_NAME,  $RESIGN_TAG,
                $RESIGN_DATE, $CREATED_BY, $CREATED_ON, $MODIFIED_BY, $MODIFIED_ON, $LOGIN_ID,
                $LOGIN_PWD, $password,$TravelEligibility,$NSW,$SWIPECARDNO
            ]);
        }

        // Commit the transaction if everything was successful
        DB::commit();

        // Return success response
        return response()->json(['message' => 'Data Submitted Successfully', 'status_code' => 200, 'hrdata' => 'Data submitted successfully'], 200);

    } catch (\Exception $e) {
        // Rollback the transaction in case of any error
        DB::rollBack();

        // Return failure response with error message
        return response()->json(['message' => 'Failure', 'status_code' => 400, 'error' => $e->getMessage()], 400);
    }
}

public function getpunchreportforportal(Request $request){
	
	$validator = Validator::make($request->all(), [
		'login_id' => 'required', 
		'reportee_code' => 'required', 
		'from_date' => 'required', 
		'to_date' => 'required', 
	]);

	// Check if validation fails
	if ($validator->fails()) {
		// Validation failed, return error response
		return response()->json([
			'message' => $validator->errors()->all(),
			'status_code' => '400',
		], 400);
	}

	$login_id = $request->login_id;
	$reportee_code = $request->reportee_code;
	$from_date = $request->from_date;
	$to_date = $request->to_date;

	// Query for punch details
	
	
	$punch_details = DB::select("SELECT hda.id, hda.image, hda.login_id, hda.name, hda.sdate, hda.location, hda.latitude, hda.longitude FROM employee e INNER JOIN hr_daily_atten hda ON e.swipecardno = hda.login_id INNER JOIN branch_mapping ba ON e.branch_code = ba.branch WHERE e.maincode = ? AND DATE(hda.sdate) BETWEEN ? AND ? 
AND ba.code =?;", [$reportee_code, $from_date, $to_date,$login_id ]);

	// Loop through each punch detail to base64 encode the image and add branchcode
	foreach ($punch_details as &$punch) {
	
		// First, check if the employee is eligible for travel
		$travelEligibilityCount = DB::select("SELECT count(*) as count FROM employee WHERE code = ? AND TravelEligibility = 'YES'", [$reportee_code]);

		// If eligible, fetch branch name using latitude and longitude
		if ($travelEligibilityCount[0]->count > 0) {
			$branch = DB::select("SELECT  Branchcode FROM Employee_Travel_Mapping WHERE latitude LIKE ? AND longitude LIKE ? AND EmployeeCode = ? limit 1", [
				substr($punch->latitude, 0, 2) . '%',
				substr($punch->longitude, 0, 2) . '%',
				$reportee_code,
			]);
			$punch->branchcode = $branch ? $branch[0]->Branchcode : null; // Set branchcode if found
		} else {
// 			$branch = DB::select("SELECT NAME FROM branch WHERE latitude LIKE ? AND longitude LIKE ?", [
// 				substr($punch->latitude, 0, 5) . '%', // Adjust the precision for latitude
// 				substr($punch->longitude, 0, 5) . '%', // Adjust the precision for longitude
// 			]);
		// Set branch name if found
			
				$branch = DB::select("SELECT NAME FROM branch WHERE code=(select distinct BRANCH_CODE from employee where maincode=?)", [$reportee_code]);
			
		
			$punch->branchcode = $branch ? $branch[0]->NAME : null; // Set branch name if found
			
		}

		// Encode the image to base64
		$imagePath = $punch->image; // Assuming `image` is the path stored in DB
		if ($imagePath) {
			// Get the image data and encode it to base64
			$imageData = Storage::get($imagePath);
			$punch->base64_image = base64_encode($imageData);
		} else {
			$punch->base64_image = null; // In case there is no image
		}
	}

	return response()->json([
		'message' => 'Success',
		'status_code' => '200', 
		'punch_details' => $punch_details
	], 200);
}

public function getreporteespunchforlc(Request $request){
	
	 $validator = Validator::make($request->all(), [
			'login_id' => 'required', 
			
			'date' => 'required', 
			
		]);

	
		if ($validator->fails()) {
		
			return response()->json([
				'message' => $validator->errors()->all(),
				'status_code' => '400',
			], 400);
		}

		$login_id = $request->login_id;
			$type = $request->type;
		$date = $request->date;
		$reportee_details="";
		if($type=="MODIFY"){
		    	$reportee_details = DB::SELECT("select hda.id,hda.login_id ,hda.name,hda.punchlocation,sdate,location,hda.latitude,hda.longitude from employee na
 inner join hr_daily_atten hda on na.swipecardno = hda.login_id where na.CODE=? and date_format(hda.sdate,'%Y-%m-%d')=? and date_format(hda.sdate,'%Y-%m-%d')   ;", [$login_id,$date]);
		}else{
		    	$reportee_details = DB::SELECT("select hda.id,hda.login_id ,hda.name,hda.punchlocation,sdate,location,hda.latitude,hda.longitude from employee na
 inner join hr_daily_atten hda on na.swipecardno = hda.login_id where na.CODE=? and date_format(hda.sdate,'%Y-%m-%d')=? and date_format(hda.sdate,'%Y-%m-%d') not in (select date_format(Trndate,'%Y-%m-%d') from EMP_LC_Trailer where Maincode=?)  ;", [$login_id,$date,$login_id]);
		}

	

		return response()->json(['message'=>'Success','status_code'=>'200', 'reportee_details'=> $reportee_details], 200);
		//return response()->json(['FUNCTION' => $fun_approve2], 200);
	}	
public function vechicletype(Request $request)
{
    $types = DB::table('VEHICLETYPE')
        ->select('VEHICLETYPE', 'AMTPERKM')
        ->where('active', '1')
        ->distinct()
        ->get();

    return response()->json([
        'message' => 'Success',
        'status_code' => 200, 
        'type' => $types
    ], 200);
}


    public function lc_entry(Request $request)
    {
        $data = $request->all();
        $header = $data['headerData'];
        $trailers = $data['trailerData'];

        DB::beginTransaction();
   $existingHeader = DB::table('EMP_LC_Trailer')
    
    ->where('Maincode', $header['Maincode'])
    ->where('Trndate', $header['FromDate']) 
    ->first();


        if ($existingHeader) {
          
            return response()->json([
                'status_code' => 400,
                'message' => 'LC Entry already exists for Date ' . $header['FromDate'],
            ], 200);
        }
        try {
            
            
        

          
            $trailerSql = "                INSERT INTO EMP_LC_Trailer 
                ( Branch_code, Maincode, Trndate, FromPlace, ToPlace, Fromtime, ToTime, Distance, VehicleType, Amount, MasterDistance,Rate)
                VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)
            ";

            foreach ($trailers as $trailer) {
                
             
                DB::statement($trailerSql, [
                 
                    $trailer['Branch_code'],
                    $trailer['Maincode'],
                    $trailer['Trndate'],
                    $trailer['FromPlace'],
                    $trailer['ToPlace'],
                    $trailer['Fromtime'],
                    $trailer['ToTime'],
                    $trailer['Distance'],
                    $trailer['VehicleType'],
                    $trailer['Amount'],
                    $trailer['MasterDistance'],
                    $trailer['Rate']
                ]);
            }

            DB::commit();
            return response()->json([
    'status_code' => 200, 
    'message' => 'LC Entry Created for Date ' . $trailer['Trndate']
], 200);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
    'status_code' => 400, 
    'message' => 'LC Entry Not Created. Please Try Again After Some Time',
    'error' => $e->getMessage()
], 200);

        }
    }

public function pending_lcentries(Request $request)
{
    
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
    ]);

  
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

    try {
      
        $login_id = $request->login_id;

       
        $sql = "SELECT 
    Branch_Code, 
    Maincode, 
    Trndate, 
    SUM(Amount) AS TotalAmount
FROM 
    EMP_LC_Trailer
WHERE 
    Maincode = ? 
    AND (Status IS NULL OR Status = '' or Status='REJECTED')
GROUP BY 
    Branch_Code, 
    Maincode, 
    Trndate;
";

    
        $results = DB::select($sql, [$login_id]);
        $doc_no=DB::select("SELECT CONCAT('LC', LPAD(MAX(CAST(SUBSTRING(TRN_Numer, 3) AS UNSIGNED)) + 1, 6, '0')) AS docno
FROM EMP_LC_Header");

     
        return response()->json([
            'status_code' => 200,
            'message' => 'LC Entries Retrieved Successfully',
            'lcentries' => $results,'docno' => $doc_no[0]->docno ?? 'LC250001'

        ], 200);
        
    } catch (\Exception $e) {
    
        return response()->json([
            'status_code' => 400,
            'message' => $e->getMessage(),
        ], 400);
    }
}
public function lc_submission(Request $request)
{
    $request->validate([
        'transactions' => 'required',
        'transactions.*.TRN_Numer' => 'required|string',
        'transactions.*.FromDate' => 'required|date',
        'transactions.*.RequestedTotal' => 'required|numeric',
         'transactions.*.login_id' => 'required',
    ]);

    
    $transactions = $request->input('transactions');

   
    $totalRequestedAmount = array_sum(array_column($transactions, 'RequestedTotal'));

    $firstTransaction = $transactions[0]; 
     
    $TRN_Numer = $firstTransaction['TRN_Numer'];
    $FromDate = $firstTransaction['FromDate'];
 $Maincode = $firstTransaction['login_id'];
   
   $trailer = DB::table('EMP_LC_Trailer')
    ->where('Maincode', $Maincode)
    ->whereDate('Trndate', '=', $FromDate)
    ->first();  

if (!$trailer) {
    return response()->json([
        'status_code' => 400,
        'message' => 'Trailer data not found for the given TRN_Numer and FromDate.',
    ]);
}

$Branch_Code = $trailer->Branch_code;  

    
    $DOC_DATE = now();  

    DB::beginTransaction();

    try {
        
        $headerSql = "
            INSERT INTO EMP_LC_Header 
            (TRN_Numer, Branch_Code, Maincode,  RequestedTotal, CreatedBy, CreatedOn, StatusBy, StatusOn, Status, DOC_DATE)
            VALUES (?, ?, ?, ?, ?, now(), ?, now(), 'REQUESTED',?)
        ";

        DB::statement($headerSql, [
            $TRN_Numer,
            $Branch_Code,
            $Maincode,
            $totalRequestedAmount, 
            $Maincode, 
            $Maincode,
            $FromDate
           
            
        ]);
        
       foreach ($transactions as $transaction) {
    DB::table('EMP_LC_Trailer')
        ->where('Maincode', $transaction['login_id'])
        ->whereDate('Trndate', $transaction['FromDate'])
        ->update([
            'TRN_Number' => $TRN_Numer,
            'Status' => 'REQUESTED'
        ]);
}
$lcData = DB::table('EMP_LC_Header')
    ->join('employee', 'employee.CODE', '=', 'EMP_LC_Header.Maincode')
    ->where('EMP_LC_Header.TRN_Numer', '=', $TRN_Numer)
    ->select('employee.NAME', 'EMP_LC_Header.RequestedTotal', 'EMP_LC_Header.DOC_DATE', 'EMP_LC_Header.Maincode')
    ->first();

if ($lcData) {
    $employeeName = $lcData->NAME;
    $requestedAmount = $lcData->RequestedTotal;
    $requestedDate = date('d-M-Y', strtotime($lcData->DOC_DATE));

    $notificationDescription = "Mr. {$employeeName} ({$lcData->Maincode}) Requested for Local Conveyance on {$requestedDate} RS.{$requestedAmount}/-";
    
    $moduleName = 'Local Conveyance';
    $adminId='RBS00007';
    $notificationSql = "
        INSERT INTO notifications 
        (sender_id, viewer_id, view_status, module_name, message, created_at,redirect,doc_no)
        VALUES (?, ?, 'UNREAD', ?, ?, now(),'/LC_Approvals',?)
    ";

    DB::statement($notificationSql, [
        $lcData->Maincode,
        $adminId,
        $moduleName,
        $notificationDescription,
        $TRN_Numer
    ]);

   
} 




        DB::commit();

       return response()->json([
    'status_code' => 200,
    'message' => 'Selected Entries are Submitted for Approval!',
], 200);

    } catch (\Exception $e) {
        DB::rollBack();

        return response()->json([
            'status_code' => 400,
            'message' => 'Error processing transactions: ' . $e->getMessage(),
        ],200);
    }
}

    
public function edit_lcentries(Request $request)
{
    // Validation for input fields
    $validator = Validator::make($request->all(), [
        'login_id' => 'required',
        'trndate' => 'required|date_format:Y-m-d', 
    ]);

   
    if ($validator->fails()) {
        return response()->json([
            'message' => $validator->errors()->all(),
            'status_code' => 400,
        ], 400);
    }

    try {
       
        $login_id = $request->login_id;
        $trndate = $request->trndate;

       
        $sql = "SELECT a.*,(CASE 
            WHEN a.STATUS = 'REJECTED' THEN 'REJECTED' 
            ELSE 'MODIFY' 
        END) AS Type  FROM EMP_LC_Trailer a 
                WHERE a.Maincode = ? 
                AND (STATUS IS NULL OR STATUS = '' OR STATUS = 'REJECTED') 
                AND DATE(a.Trndate) = ?";

       
        $results = DB::select($sql, [$login_id, $trndate]);

      
        return response()->json([
            'status_code' => 200,
            'message' => 'LC Entries Retrieved Successfully',
            'lcentries' => $results,
        ], 200);

    } catch (\Illuminate\Database\QueryException $e) {
       
        return response()->json([
            'status_code' => 500,
            'message' => 'Database error: ' . $e->getMessage(),
        ], 500);
    } catch (\Exception $e) {
        
        return response()->json([
            'status_code' => 400,
            'message' => 'An error occurred: ' . $e->getMessage(),
        ], 400);
    }
}
public function LC_approval_pending(Request $request)
{
    $request->validate([
        'login_id' => 'required|string',
    ]);

    $approverId = $request->input('login_id');
  $approverId = 'RBS00007';
  try {
//         $header = DB::select("SELECT DISTINCT a.*,(select NAME from employee where CODE=a.Maincode LIMIT 1)as Name
// FROM EMP_LC_Header a
// INNER JOIN branch_admin b ON a.Branch_code = b.AUTHORITY_CODE
// WHERE a.Status = 'REQUESTED'
//   AND b.CODE = ?;",[$approverId]);
          $header = DB::select("SELECT DISTINCT a.*,(select NAME from employee where CODE=a.Maincode LIMIT 1)as Name
FROM EMP_LC_Header a
INNER JOIN branch_admin b ON a.Branch_code = b.AUTHORITY_CODE
WHERE a.Status = 'REQUESTED'
  AND b.CODE = ?;",[$approverId]);

        if (!$header) {
            return response()->json([
                'status_code' => 400,
                'message' => 'No requested transactions found for the provided approver.',
            ], 200);
        }

        return response()->json([
            'status_code' => 200,
            'message' => 'Transaction found for approval.',
            'results' => $header,
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            'status_code' => 400,
            'message' => 'Error processing approval: ' . $e->getMessage(),
        ], 200);
    }
}
public function LC_App_Ext(Request $request)
{
    $request->validate([
        'trn_no' => 'required|string',
    ]);

    $trn_no = $request->input('trn_no');

    try {
        $header = DB::select("select * from EMP_LC_Trailer WHERE TRN_Number=?", [$trn_no]);

        if (!$header) {
            return response()->json([
                'status_code' => 400,
                'message' => 'No requested transactions found for the provided approver.',
            ], 200);
        }

        // Group by date (Trndate)
        $grouped = [];

        foreach ($header as $record) {
            // Make sure date string key is in Y-m-d format
            $dateKey = date('Y-m-d', strtotime($record->Trndate));
            
            if (!isset($grouped[$dateKey])) {
                $grouped[$dateKey] = [];
            }
            $grouped[$dateKey][] = $record;
        }

        return response()->json([
            'status_code' => 200,
            'message' => 'Transaction found for approval.',
            'results' => $grouped,
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            'status_code' => 400,
            'message' => 'Error processing approval: ' . $e->getMessage(),
        ], 200);
    }
}
public function LC_Update(Request $request)
{
    $request->validate([
        'TRN_Number' => 'required',
        'login_id' => 'required',
        'status' => 'required',
    ]);

    $trnNumber = $request->TRN_Number;
    $login_id = $request->login_id;
    $status = $request->status;

    $affected = 0;

    DB::beginTransaction();
    if ($status == "APPROVED" || $status == "REJECTED") {
        $affected = DB::update(
            "UPDATE EMP_LC_Header 
            SET STATUS = ?, StatusBy = ?, StatusOn = NOW() 
            WHERE TRN_Numer = ?", 
            [$status, $login_id, $trnNumber]
        );
         $trailer_affected = DB::update(
            "UPDATE EMP_LC_Trailer 
            SET Status = ?
            WHERE TRN_Number = ?", 
            [$status, $trnNumber]
        );
    }
  $updatess = DB::update("update notifications set view_status='READ',viewed_at=now()  where doc_no=? and viewer_id=?",[$trnNumber,$login_id]);

    if ($affected) {
        $lcData = DB::table('employee')
    ->where('CODE', '=', $login_id)
    ->select('NAME')
    ->first();

$headerda = DB::select("select * from EMP_LC_Header where TRN_Numer = ?", [$trnNumber]);

if ($lcData && !empty($headerda)) {
    $employeename = $lcData->NAME;
    $requestedAmount = $headerda[0]->RequestedTotal;
     $requestedDate = date('d-M-Y', strtotime($headerda[0]->DOC_DATE));
    $requestedid = $headerda[0]->Maincode;

    $notificationDescription = "Your request for Local Conveyance on {$requestedDate} for Rs. {$requestedAmount} has been {$status} by Mr. {$employeename}.";

    $moduleName = 'Local Conveyance';
    $redirect="";
if($status=="REJECTED"){
   $redirect="/Existing_LC" ;
}
else{
     $redirect="/dashboard" ;
}

    $notificationSql = "
        INSERT INTO notifications 
        (sender_id, viewer_id, view_status, module_name, message, created_at,redirect,doc_no)
        VALUES (?, ?, 'UNREAD', ?, ?, now(),?,?)
    ";

    DB::statement($notificationSql, [
        $login_id,
        $requestedid,
        $moduleName,
        $notificationDescription,
        $redirect,
        $trnNumber
    ]);
}

    DB::Commit();
        return response()->json([
            'status_code' => 200,
            'message' => 'DOC NO ' . $trnNumber . ' is ' . $status], 200);
    } else {
            DB::Rollback();
        return response()->json([
            'status_code' => 400,
            'message' => 'DOC NO ' . $trnNumber . ' is not ' . $status,
        ], 200);
    }
}

public function LC_Modify(Request $request)
{
    $request->validate([
        'headerData.Maincode' => 'required|string',
        'headerData.FromDate' => 'required|date',
        'headerData.docno'    => 'nullable|string',
        'trailerData' => 'required|array',
        'trailerData.*.entrytype' => 'required|string|in:R,N',
        'trailerData.*.Trndate' => 'required|date',
        'trailerData.*.FromPlace' => 'required|string',
        'trailerData.*.ToPlace' => 'required|string',
        'trailerData.*.Amount' => 'required|numeric',
    ]);

    $header = $request->input('headerData');
    $trailers = $request->input('trailerData');

    $maincode = $header['Maincode'];
    $docno = $header['docno'] ?? null;
       $Ttotal = $header['RequestedTotal'];
$datte="";
    DB::beginTransaction();

    try {
        
        $uniqueDates = collect($trailers)->pluck('Trndate')->unique();

        foreach ($uniqueDates as $trndate) {
            DB::table('EMP_LC_Trailer')
                ->where('Maincode', $maincode)
                ->whereDate('Trndate', $trndate)
                ->delete();
        }

              foreach ($trailers as $trailer) {
                  $datte= $trailer['Trndate'];
            $insertData = [
                'Maincode'       => $maincode,
                'Branch_code'    => $trailer['Branch_code'],
                'Trndate'        => $trailer['Trndate'],
                'FromPlace'      => $trailer['FromPlace'],
                'ToPlace'        => $trailer['ToPlace'],
                'Fromtime'       => $trailer['Fromtime'] ?? null,
                'ToTime'         => $trailer['ToTime'] ?? null,
                'Distance'       => $trailer['Distance'] ?? null,
                'VehicleType'    => $trailer['VehicleType'] ?? null,
                'Amount'         => $trailer['Amount'],
                'MasterDistance' => $trailer['MasterDistance'] ?? null,
                'Rate'           => $trailer['Rate'] ?? null,
            ];

            
            if ($trailer['entrytype'] === 'R') {
                $insertData['TRN_Number'] = $docno;
                $insertData['Status'] = 'REQUESTED';

               
               DB::table('EMP_LC_Header')
    ->where('TRN_Numer', $docno)
    ->where('Maincode', $maincode)
    ->update([
        'Status' => 'REQUESTED',
        'RequestedTotal' => $Ttotal
    ]);

            }

            DB::table('EMP_LC_Trailer')->insert($insertData);
        }
        $lcData = DB::table('EMP_LC_Header')
    ->join('employee', 'employee.CODE', '=', 'EMP_LC_Header.Maincode')
    ->where('EMP_LC_Header.TRN_Numer', '=', $docno)
    ->select('employee.NAME', 'EMP_LC_Header.RequestedTotal', 'EMP_LC_Header.DOC_DATE', 'EMP_LC_Header.Maincode')
    ->first();

if ($lcData) {
    $employeeName = $lcData->NAME;
    $requestedAmount = $lcData->RequestedTotal;
    $requestedDate = date('d-M-Y', strtotime($lcData->DOC_DATE));

    $notificationDescription = "Mr. {$employeeName} ({$lcData->Maincode}) Requested for Local Conveyance on {$requestedDate} RS.{$requestedAmount}/-";
    
    $moduleName = 'Local Conveyance';
  //  $adminId='CCS00541';
        $adminId='RBS00007';
    $notificationSql = "
        INSERT INTO notifications 
        (sender_id, viewer_id, view_status, module_name, message, created_at,redirect,doc_no)
        VALUES (?, ?, 'UNREAD', ?, ?, now(),'/LC_Approvals',?)
    ";

    DB::statement($notificationSql, [
        $lcData->Maincode,
        $adminId,
        $moduleName,
        $notificationDescription,
        $docno
    ]);
}

        DB::commit();

$formattedDate = Carbon::parse($datte)->format('d-M-Y');

return response()->json([
    'status_code' => 200,
    'message' => 'LC Entries Created successfully for ' . $formattedDate,
]);
    } catch (\Exception $e) {
        DB::rollBack();

        return response()->json([
            'status_code' => 500,
            'message' => 'Error processing data: ' . $e->getMessage(),
        ]);
    }
}
public function getNotifications(Request $request)
{
    $receiver_id=$request->login_id;
    $notifications = DB::table('notifications')
    ->where('viewer_id', $receiver_id)
        ->where('view_status', 'UNREAD')
    ->orderBy('created_at', 'desc')
    ->get();


    return response()->json([
        'status' => 'success',
        'notifications' => $notifications
    ]);
}
public function getNotifications_conut(Request $request)
{
    $receiver_id=$request->login_id;
   $notificationCount = DB::table('notifications')
    ->where('viewer_id', $receiver_id)
    ->where('view_status', 'UNREAD')
    ->count();



    return response()->json([
        'status' => 'success',
        'notifications' => $notificationCount
    ]);
}
public function updatenotify_status(Request $request)
{
    $id=$request->id;
  $notificationCount = DB::update("update notifications set view_status='READ',viewed_at=now()  where id=?",[$id]);

return response()->json([
    'status_code' => 200,
    'message' => 'Updated successfully',
]);
   
}
public function lc_report(Request $request)
{
    $employeeCodes = $request->input('employees');
    $monthYear = $request->input('month');
    $reportType = $request->input('reportType');
    $status = $request->input('status');
    if ($status=="NOT APPROVED"){
        $status="REQUESTED";
    }

    if (!$employeeCodes || !$monthYear || !is_array($employeeCodes)) {
        return response()->json(['error' => 'employee_code (array) and month_year are required'], 422);
    }

    $bindings = [$monthYear];
    $placeholders = implode(',', array_fill(0, count($employeeCodes), '?'));
    $bindings = array_merge($bindings, $employeeCodes);

    $statusCondition = '';
    if ($status !== 'ALL') {
        $statusCondition = ' AND b.Status = ?';
        $bindings[] = $status;
    }

    if ($reportType === 'EXTRACTION') {
        $query = "
            SELECT DISTINCT b.*,(select CONCAT(MAINCODE, ' - ', NAME) FROM employee where MAINCODE=b.Maincode LIMIT 1)as SerialNumber
            FROM EMP_LC_Header a
            INNER JOIN EMP_LC_Trailer b
                ON a.TRN_Numer = b.TRN_Number
                AND a.Maincode = b.Maincode
            WHERE DATE_FORMAT(a.DOC_DATE, '%Y-%m') = ?
              AND a.Maincode IN ($placeholders)
              $statusCondition
        ";
        
    } elseif ($reportType === 'CONSOLIDATE') {
        $query = "
            SELECT 
                (select CONCAT(MAINCODE, ' - ', NAME) FROM employee where MAINCODE=b.Maincode LIMIT 1)as Maincode,
                SUM(b.Distance) AS TotalDistance,
                SUM(b.Amount) AS TotalAmount
            FROM EMP_LC_Header a
            INNER JOIN EMP_LC_Trailer b
                ON a.TRN_Numer = b.TRN_Number
                AND a.Maincode = b.Maincode
            WHERE DATE_FORMAT(a.DOC_DATE, '%Y-%m') = ?
              AND a.Maincode IN ($placeholders)
              $statusCondition
            GROUP BY b.Maincode";
    } else {
        return response()->json(['error' => 'Invalid reportType'], 422);
    }

$results = DB::select($query, $bindings);
//        $results = $query;


 
    return response()->json($results);
}




}

?>